<?php        
    function check_snmp($ip,$community)
    {
	//include_once("logs.php");
        include("config.php");
        exec("snmpget -v2c -On -r1 -t1"." -c".$community." ".$ip." ".'1.3.6.1.2.1.1.5.0',$a,$retvar2);
	write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Check SNMP: '.$community.' == '.$ip);
	write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Check SNMP: '.$retvar2);
        return $retvar2;
    }                

    function get_vendor($ip,$community)
    { 
        $device=get_device_id_table($ip,$community);
        return $device['device_name'];
    }

    function get_hostname($ip,$community)
    { 
        include("config.php");
        exec("snmpget -v2c -On -r1 -t".$snmp_timeout." -c".$community." ".$ip." ".'1.3.6.1.2.1.1.5.0',$a,$retvar2);  //$a is table
        list($oid,$out)=explode('=',$a[0]);
        $ret=trim(str_replace($replace_table,"",$out));
        return $ret;
    }
    
    function get_device_id_table($ip,$community)
    {
        include_once("logs.php");
        include("config.php");
        include("config_device_id.php");

        exec("snmpget -v2c -Onv -r1 -t".$snmp_timeout." -c".$community." ".$ip." ".'1.3.6.1.2.1.1.2.0',$a,$retvar2); //get id vedor from .1.3.6.1.2.1.1.2.0 = OID: .1.3.6.1.4.1.890.1.5.8.48
        write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Device ID1: '.$a[0]);
        //list($d)=explode('.',str_replace('.1.3.6.1.4.1.','',str_replace('OID:','',get_snmp($ip,$community,'1.3.6.1.2.1.1.2.0', $snmp_timeout, $snmp_retry))));
        list($d)=explode('.',str_replace('.1.3.6.1.4.1.','',str_replace('OID:','',$a[0]))); //vendor's id 
        $d=trim($d);
        $device_idd=$device_id[$d];  //find vendor (table of oid for vendor - table is in snmp_template) in device_id table in config_device_id.php
        write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Device ID2:'.$d);
        //write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Device ID3: '.$device_idd[0]);
        if(!isset($device_idd) || is_null($device_idd) || $device_idd === "") $device_idd=9;  //9 - cisco
        return $device_idd;  //return array from config.php for index $device_idd in config_device_id.php
        //return $device_idd['device_name'];
        /*
        Array ( 
         *      [device_id] => 890 
         *      [device_name] => Zyxel 
         *      [device_model] => 1.3.6.1.2.1.1.1.0 
         *      [sysVendor] => 1.3.6.1.4.1.890 
         *      [sysSystem] => 1.3.6.1.2.1.1 
         */
    }
        
    //function get_count_interfaces($ip,$community,$device)
    //{
    //    return count(get_snmp_walk($ip,$community,$device['ifIndex']));
    //}
    
    function get_if_vlans($ip,$community,$oid,$device)
    {
        if(!isset($oid) || $oid === null || $oid === '') return "";
        return get_snmp_walk($ip,$community,$oid,$device);
    }
    function get_count_vlans($ip,$community,$oid,$device)
    {
        if(!isset($oid) || $oid === null || $oid === '') return "";
        return count(get_snmp_walk($ip,$community,$oid,$device));
    }

    function get_snmp($ip,$community,$oid)
    {
        if(!isset($oid) || $oid === null || $oid === '') return "";
        include("config.php");
        //snmp_set_oid_output_format(SNMP_OID_OUTPUT_NUMERIC);
        exec("snmpget -v2c -On -r1 -t".$snmp_timeout." -c".$community." ".$ip." ".$oid,$a,$retvar2);  //$a is table
        list($oid,$out)=explode('=',$a[0]);
        if($preg === 1) $out=preg_replace("/[^0-9]/","",$out);
        $ret=trim(str_replace($replace_table,"",$out));
        return $ret;
        //return trim(str_replace($replace_table,"",snmpget($ip, $community, $oid, $snmp_timeout_php, $snmp_retry)));
    }                

    function get_snmp_walk($ip,$community,$oid)  //,$device)
    {
        //if(!isset($oid) || $oid === null || $oid === '') return "";
        include("config.php");
        //snmp_set_oid_output_format(SNMP_OID_OUTPUT_NUMERIC);
        //$a=snmpwalk($ip,$community,$oid, $snmp_timeout_php, $snmp_retry);
        exec("snmpwalk -v2c -On -r1 -t".$snmp_timeout." -c".$community." ".$ip." ".$oid,$a,$retvar2);
        $b=array();
        //if(!isset($device)) $device[]='';
        $c_count=count($a);
        for ($i=0; $i<$c_count; $i++)
        {
            $line=trim($a[$i]);
            list($p1,$p2)=explode('=',$line);
            if($preg === 1) $p2=preg_replace("/[^0-9]/","",$p2);
            $b[]=trim(str_replace($replace_table,"",$p2));            
        }
        return $b;
    }
    
    function get_snmp_walk_ip($ip,$community,$if_indexes)
    {
        include("config.php");
        include("config_snmp.php");
        $c_indexes=count($if_indexes);
        if($c_indexes>0)
        {                    
            $ip_r=array_fill(0,$c_indexes-1,""); //returned table ip addresses
        
            $ip_a=get_snmp_walk($ip,$community,'1.3.6.1.2.1.4.20.1.1'); //ip addresses
            $c_count=count($ip_a);
            for($i=0;$i<$c_count;$i++)
            {
                $int_index[$ip_a[$i]]=get_snmp($ip,$community,'1.3.6.1.2.1.4.20.1.2'.'.'.$ip_a[$i]); //array ip => interfaces index
            }
            $int_key=array_values($int_index); //interface index 
            $int_ip= array_keys($int_index);   //ip for interface index
        
	    /*
            $mask=get_snmp_walk($ip,$community,'1.3.6.1.2.1.4.20.1.3'); //mask for ip
            $cc_count=count($mask);
            for ($i=0; $i<$cc_count; $i++)
            {
                $ip_mask[$ip_a[$i]]=$ipMask[$mask[$i]]; //full ip address width mask
            }
	     * 
	     */

	    $s_count=count($int_key);
            for($i=0;$i<$c_indexes;$i++) //i == interface index
            {                
                for($k=0;$k<$s_count;$k++) //find all ip for if_index
                {
                    if($int_key[$k] === $if_indexes[$i])
                    {
                        //if($int_ip[$k]<>"")
                        //{
                            $ip_r[$i]=$ip_r[$i].' '.$int_ip[$k]; //.'/'.$ip_mask[$int_ip[$k]];
                        //} else $ip_r[$i]="";
                    }
                }
            }            

            return $ip_r;
        } else return "";     
    }
    
    function get_snmp_vlans($ip,$community,$oid,$preg)
    {
        require("config.php");
        $a=array();
        exec("snmpwalk -v2c -On -r1 -t".$snmp_timeout." -c".$community." ".$ip." ".$oid,$a,$retvar2);
        $b=array();
        $c_count=count($a);
        for ($i=0; $i<$c_count; $i++)
        {
            $line=trim($a[$i]);
            list($p1,$p2)=explode('=',$line);
            if($preg === 1) $p2=preg_replace("/[^0-9]/","",$p2);
            $b[]=str_replace('.'.$oid.'.',"",trim($p1));
        }
        return $b;
    }
    
    function get_vlan_st($vlan_idd,$ip,$community,$oid)
    {
        require("config.php");
        $a=array();
        $oid=$oid.'.'.$vlan_idd;
        exec("snmpwalk -v2c -Onv -r1 -t".$snmp_timeout." -c".$community." ".$ip." ".$oid,$a,$retvar2);
        if(trim($a[0])==='No Such Instance currently exists at this OID')
        {
            $b="";
        } else
            {
                $b=str_replace($replace_table,"",$a[0]);
            }
        return $b;
    }
    function get_vlan_st_tb($vlan_id,$ip,$community,$oid)
    {
        require("config.php");
        $a=array();
        //$oid=$oid.'.'.$vlan_idd;
        exec("snmpwalk -v2c -Onv -r1 -t".$snmp_timeout." -c".$community." ".$ip." ".$oid,$a,$retvar2);
        $c_count=count($a);
        for($i=0;$i<$c_count;$i++)
        {
            $b[]=str_replace($replace_table,"",$a[$i]);
        }
        return $b;
    }
            
    function get_vlan_to_port_mac($vlan_idd,$ip,$community,$oid)
    {
        //'vlans_to_ports'        => '1.3.6.1.2.1.17.7.1.2.2.1.2', //+.<vlan_id>.[mac] = port       .1.3.6.1.2.1.17.7.1.2.2.1.2. 2105 .0.1.0.46.2.26 = INTEGER: 9
        require("config.php");
        $a=array();
        $oid=$oid.'.'.$vlan_idd;
        exec("snmpwalk -v2c -On -r1 -t".$snmp_timeout." -c".$community." ".$ip." ".$oid,$a,$retvar2);
        //$a=@snmpwalk($ip,$community,$oid, $snmp_timeout, $snmp_retry);
        $a_port="";
        $a_mac="";
        $c_count=count($a);
        for($i=0;$i<$c_count;$i++)
        {
            list($mac,$port)=explode('=',$a[$i]);  //.1.3.6.1.2.1.17.7.1.2.2.1.2.2105.160.228.203.139.29.200 = INTEGER: 12  //vlan 2105, port 12
            $port=str_replace($replace_table,'',$port);
            $a_port.=$port.'<br/>';
            
            $mac=str_replace($oid.'.','',$mac);
            $mac=trim(str_replace('.'.$oid,'',$mac));
            list($d0,$d1,$d2,$d3,$d4,$d5,$d6)=explode('.',$mac);
            $h1=dechex($d1);
            $h2=dechex($d2);
            $h3=dechex($d3);
            $h4=dechex($d4);
            $h5=dechex($d5);
            $h6=dechex($d6);
            $a_mac.=$h1.':'.$h2.':'.$h3.':'.$h4.':'.$h5.':'.$h6.'<br/>';
        }
        return $a_port.'|'.$a_mac;
    }
        
    function get_snmp_walk_bps($ip,$community,$oid)
    {
        if(!isset($oid) || $oid === null || $oid === '') return "";
        require("config.php");
        ////snmp_set_oid_output_format(SNMP_OID_OUTPUT_NUMERIC);
        //$a=@snmpwalk($ip,$community,$oid, $snmp_timeout_php, $snmp_retry);
        //$b=array();
        //$c_count=count($a);
        //for ($i=0; $i<$c_count; $i++)
        //{
        //    $line=preg_replace("/[^0-9]/","",str_replace($replace_table,"",$a[$i])) / 1000000;
        //    $b[]=trim($line);
        //}                
        
        exec("snmpwalk -v2c -Onv -r1 -t".$snmp_timeout." -c".$community." ".$ip." ".$oid,$a,$retvar2);
        $c_count=count($a);
        for($i=0;$i<$c_count;$i++)
        {
            $b[]=str_replace($replace_table,"",$a[$i]);
        }
        return $b;
    }
    
    function get_snmp_walk_bps_in($ip,$community,$if_index,$nr_pos,$device,$d_time,$in_out_o)
    {
        $d_bps=1000000*$d_time;
        $bps=array();
        $gdir=dirname(__FILE__).'/tmp';
        if(!(file_exists($gdir))) 
        {
            mkdir($gdir);
        }
        $file_in=$gdir."/".$ip.'_in';
        
        if(file_exists($file_in))
        {    
            $wp=fopen($file_in,'r');
            while (!feof($wp))
            {
                $in_o_hist[]=fgets($wp,128);
            }
            fclose($wp);
            $c_count=count($in_out_o);
            for($i=0;$i<$c_count;$i++)
            {
                $bp=($in_out_o[$i] - $in_o_hist[$i]);
                if($bp<0) $bp=0;
                $bps[]=round(($bp / $d_bps)*8,4);
                $in_bps=$bp;
                get_snmp_walk_bps_in_rrd($ip,$i,$in_bps);
            }
        }    
        $wp=fopen($file_in,'w');
        $c_count=count($in_out_o);
        for($i=0;$i<$c_count;$i++)
        {
            $text_in=$in_out_o[$i]."\n";
            fwrite($wp,$text_in,strlen($text_in));
        }    
        fclose($wp);
        
        return $bps;
    }
    function get_snmp_walk_bps_out($ip,$community,$if_index,$nr_pos,$device,$d_time,$in_out_o)
    {
        $d_bps=1000000*$d_time;
        $bps=array();
        $gdir=dirname(__FILE__).'/tmp';
        if(!(file_exists($gdir))) 
        {
            mkdir($gdir);
        }
        $file_in=$gdir."/".$ip.'_out';
        
        if(file_exists($file_in))
        {    
            $wp=fopen($file_in,'r');
            while (!feof($wp))
            {
                $in_o_hist[]=fgets($wp,128);
            }
            fclose($wp);
            $c_count=count($in_out_o);
            for($i=0;$i<$c_count;$i++)
            {
                $bp=($in_out_o[$i] - $in_o_hist[$i]);
                if($bp<0) $bp=0;
                $bps[]=round(($bp / $d_bps)*8,4);
                $in_bps=$bp;
                get_snmp_walk_bps_out_rrd($ip,$i,$in_bps);
            }
        }    
        $wp=fopen($file_in,'w');
        $c_count=count($in_out_o);
        for($i=0;$i<$c_count;$i++)
        {
            $text_in=$in_out_o[$i]."\n";
            fwrite($wp,$text_in,strlen($text_in));
        }    
        fclose($wp);        
        
        return $bps;
    }
    
    function get_snmp_walk_bps_in_rrd($ip,$i,$in_bps)
    {
        include("config.php");
        if(!isSet($rrd_path) || $rrd_path==="") $rrd_path=''.dirname(__FILE__)."/rrd/";
        $gdir_rrd=$rrd_path;
        if(!(file_exists($gdir_rrd))) 
        {
            mkdir($gdir_rrd);
        }
        $file_rrd=$gdir_rrd."/".$ip.'_'.$i.'_in.rrd';
        if(!(file_exists($file_rrd)))
        {
            $rrd="/usr/bin/rrdtool create ";
            $rrd.=$file_rrd;
            $rrd.=" --start now-30min --step 10";
            $rrd.=" 'DS:inbound:COUNTER:60:U:12500000'";
            $rrd.=" 'RRA:LAST:0.5:1:1000'";
            $rrd.=" 'RRA:MAX:0.5:1:100'";
            exec($rrd,$a_rrd,$retvar_rrd);
        } else
            {
                exec("/usr/bin/rrdtool update $file_rrd N:".$in_bps,$a_rrd,$retvar_rrd);
            }
        return 0;
    }    
    
    function get_snmp_walk_bps_out_rrd($ip,$i,$in_bps)
    {
        include("config.php");
        if(!isSet($rrd_path) || $rrd_path==="") $rrd_path=''.dirname(__FILE__)."/rrd/";
        $gdir_rrd=$rrd_path;
        if(!(file_exists($gdir_rrd))) 
        {
            mkdir($gdir_rrd);
        }
        $file_rrd=$gdir_rrd."/".$ip.'_'.$i.'_out.rrd';
        if(!(file_exists($file_rrd)))
        {
            $rrd="/usr/bin/rrdtool create ";
            $rrd.=$file_rrd;
            $rrd.=" --start now-30min --step 10";
            $rrd.=" 'DS:outbound:COUNTER:60:U:12500000'";
            $rrd.=" 'RRA:LAST:0.5:1:1000'";
            $rrd.=" 'RRA:MAX:0.5:1:100'";
            exec($rrd,$a_rrd,$retvar_rrd);
        } else
            {
                exec("/usr/bin/rrdtool update $file_rrd N:".$in_bps,$a_rrd,$retvar_rrd);
            }
        return 0;
    }
    
    function get_snmp_duplex_status($ip,$community,$if_indexes,$nr_pos,$device)
    {
        $k_i=array();
        if(count($if_indexes)>0)
        {    
            $c_count=count($if_indexes);            
            for($i=0;$i<$c_count;$i++)
            {
                $k_i[$if_indexes[$i]]=$nr_pos[$i]; //array interface => pos (nr_pos = numery wierszy)
            }            
            $pos_interface=array_flip($k_i); //array pos=>interface - zamiana kluczy z wartosciami
            $if_duplex_r=array_fill(0,count($if_indexes)-1,""); //returned full empty table of interfaces - pust tablica o rozmiarze ilosci interfejsow
            $s_count=count($if_duplex_r);
            for($i=0;$i<$s_count;$i++)
            {
                $dp=get_snmp($ip,$community,$device['ifDuplexStatus'].'.'.$pos_interface[$i]);                
                $if_duplex_interface[$i]=trim($dp); //preg_replace("/[^0-9]/","",$dp);
                //echo $dp;
                //echo $device['ifDuplexStatus'].'.'.$pos_interface[$i].'    ';
            }
            return $if_duplex_interface;
        } else return "";
    }
    
//----------------------------------------------------------------------------------------------------------------------------------------    
    
    function get_snmp_walk_vlan($ip,$community,$oid,$device)
    {
        if(!isset($oid) || $oid === null || $oid === '') return "";
        require("config.php");
        $a=@snmpwalkoid($ip,$community,$oid);
        $b=array();
        for (reset($a); $i = key($a); next($a)) 
        {
            $b[]=str_replace($replace_table,"",$i);
        }
        return $b;
    }
    
    function get_snmp_walk_vlan2($ip,$community,$oid,$device)
    {
        if(!isset($oid) || $oid === null || $oid === '') return "";
        return get_snmp_walk($ip,$community,$oid);
    }
    
    function get_snmp_walk_vlan_desc($ip,$community,$oid,$device)
    {
        if(!isset($oid) || $oid === null || $oid === '') return "";
        return get_snmp_walk($ip,$community,$oid);
    }

    function get_snmp_walk_vlan_port($ip,$community,$vlan,$device)
    {
        $p=array();
        $c_count=count($vlan);
        for($i=0;$i<$c_count;$i++)
        {
            $oid1='1.3.6.1.2.1.17.7.1.2.2.1.2.'.$vlan[$i];
            $oid2='1.3.6.1.2.1.17.7.1.2.2.1.3.'.$vlan[$i];
            $a1=get_snmp_walk($ip,$community,$oid1);
            $a2=get_snmp_walk($ip,$community,$oid2);
            //1.3.6.1.2.1.17.7.1.2.2.1.2. + vlan + mac = port
            $cc_count=count($a1);
            for ($i=0; $i<$c_count; $i++)
            {
                $line=str_replace($replace_table,"",$a1[$i]);
                $b1[]=$line;
                $line=str_replace($replace_table,"",$a2[$i]);
                $b2[]=$line;
            }
        }    
        return $p;
    }
    
//----------------------------------------------------------------------------------------------------------------------------------------
    
   function get_model($ip,$community)
    {
        $model_p=get_snmp($ip, $community, '1.3.6.1.2.1.1.1.0', $snmp_timeout, $snmp_retry);
        return $model_p;
        /*
        $model="CISCO"; //default
        if(!stristr($model_p,'3712') === false)
        {
            $model='MGS3712';
            return $model;
        } else if(!stristr($model_p,'3700') === false)
               {
                    $model='MGS3700';
                    return $model;
               } else if(!stristr($model_p,'4700') === false)
                      {
                        $model='XGS4700';
                        return $model;
                      } if(!stristr($model_p,'4728') === false)
                        {
                            $model='XGS4728';
                            return $model;
                        } else if(!stristr($model_p,'MES') === false)
                                {
                                    $model='MES';
                                    return $model;
                                } else  if(!stristr($model_p,'ES') === false)
                                        {
                                            $model='ES';
                                            return $model;
                                        } else if(!stristr($model_p, 'GS') === false)
                                               {
                                                    $model = 'GS';
                                                    return $model;
                                               } else if(!stristr($model_p, 'ISCOM') === false)
                                                      {
                                                            $model = 'RAISECOM';
                                                            return $model;
                                                      } else      
                                                        {
                                                            $model = 'NONE';
                                                            return $model;
                                                        }
         * 
         */
    }
    
    /*
    function get_tryb_pracy_portu($ip,$community,$device)
    {
        $pp=array();        
        if($device['device_id']==='zyxel')
        {
            $mm=get_model($ip,$community);
            switch ($mm)
            {
                case 'XGS4700': $oid='1.3.6.1.4.1.890.1.5.8.54.23.1.1.1';
                                $pp=get_snmp_walk($ip,$community,$oid);
                    break;
                case 'XGS4728': $oid='1.3.6.1.4.1.890.1.5.8.46.23.1.1.1';
                                $pp=get_snmp_walk($ip,$community,$oid);
                    break;                
                case 'MGS3700': $oid='1.3.6.1.4.1.890.1.5.8.75.22.1.1.1';
                                $pp=get_snmp_walk($ip,$community,$oid);
                    break;
                case 'MGS3712': $oid='1.3.6.1.4.1.890.1.5.8.48.22.1.1.1';
                                $pp=get_snmp_walk($ip,$community,$oid);
                    break;                
                case 'ES':      $oid='1.3.6.1.4.1.890.1.5.8.19.19.1.1.1';
                                $pp=get_snmp_walk($ip,$community,$oid);
                    break;
                case 'GS':      $oid='1.3.6.1.4.1.890.1.5.8.59.24.1.1.1';
                                $pp=get_snmp_walk($ip,$community,$oid);
                    break;
                case 'MES':     $oid='1.3.6.1.4.1.890.1.5.8.19.19.1.1.1';
                                $pp=get_snmp_walk($ip,$community,$oid);
                    break;
                default:        $oid='';
            }
        }             
        return $pp;
    }
     * 
     */
    /*
    function get_typ_modulu($ip,$community,$device)
    {
        $pp=array();
        if($device['device_id']==='zyxel')
        {
            $mm=get_model($ip,$community);
            switch ($mm)
            {
                case 'XGS4700': $oid='1.3.6.1.4.1.890.1.5.8.54.23.1.1.4';
                                $pp=get_snmp_walk($ip,$community,$oid);
                    break;
                case 'XGS4728': $oid='1.3.6.1.4.1.890.1.5.8.46.23.1.1.4';
                                $pp=get_snmp_walk($ip,$community,$oid);
                    break;                
                case 'MGS3700': $oid='1.3.6.1.4.1.890.1.5.8.75.22.1.1.4';
                                $pp=get_snmp_walk($ip,$community,$oid);
                    break;
                case 'MGS3712': $oid='1.3.6.1.4.1.890.1.5.8.48.22.1.1.4';
                                $pp=get_snmp_walk($ip,$community,$oid);
                    break;                
                case 'ES':      $oid='1.3.6.1.4.1.890.1.5.8.19.19.1.1.4';
                                $pp=get_snmp_walk($ip,$community,$oid);
                    break;                
                case 'GS':      $oid='1.3.6.1.4.1.890.1.5.8.59.24.1.1.4';
                                $pp=get_snmp_walk($ip,$community,$oid);
                    break;
                case 'MES':     $oid='1.3.6.1.4.1.890.1.5.8.19.19.1.1.4';
                                $pp=get_snmp_walk($ip,$community,$oid);
                    break;                
                default:        $oid='';
            }
        }
        return $pp;
    }
     * 
     */
    /*
    function get_run_modul($ip,$community,$device)
    {
        $pp=array();
        if($device['device_id']==='zyxel')
        {
            $mm=get_model($ip,$community);
            switch ($mm)
            {
                case 'XGS4700': $oid='1.3.6.1.4.1.890.1.5.8.54.23.1.1.5';
                                $pp=get_snmp_walk($ip,$community,$oid);
                    break;
                case 'XGS4728': $oid='1.3.6.1.4.1.890.1.5.8.46.23.1.1.5';
                                $pp=get_snmp_walk($ip,$community,$oid);
                    break;                
                case 'MGS3700': $oid='1.3.6.1.4.1.890.1.5.8.75.22.1.1.5';
                                $pp=get_snmp_walk($ip,$community,$oid);
                    break;
                case 'MGS3712': $oid='1.3.6.1.4.1.890.1.5.8.48.22.1.1.5';
                                $pp=get_snmp_walk($ip,$community,$oid);
                    break;                
                case 'ES':      $oid='1.3.6.1.4.1.890.1.5.8.19.19.1.1.5';
                                $pp=get_snmp_walk($ip,$community,$oid);
                    break;
                case 'GS':      $oid='1.3.6.1.4.1.890.1.5.8.59.24.1.1.5';
                                $pp=get_snmp_walk($ip,$community,$oid);
                    break;
                case 'MES':     $oid='1.3.6.1.4.1.890.1.5.8.19.19.1.1.5';
                                $pp=get_snmp_walk($ip,$community,$oid);
                    break;                
                default:        $oid='';
            }        
        }
        return $pp;
    }
     * 
     */
        

?>
