#!/usr/bin/php -q
<?php
    //error_reporting(0);
    include_once("snmp_get_functions.php");
    //include_once("config.php");

    $ip =           $_SERVER["argv"][1];
    $community=     $_SERVER["argv"][2];

    //=========================================================================
    $hostname=	    @get_hostname($ip,$community);
    $services=      @get_snmp_walk($ip,$community,'1.3.6.1.2.1.25.4.2.1.2');
    $services=array_unique($services);
    $count_i=count($services);

    echo '# HOST host definition'."\n";
    echo 'define host{'."\n";
    echo '  use		    generic-host            ; Name of host template to use'."\n";
    echo '  host_name	    '.$hostname."\n";
    echo '  alias	    '.$hostname."\n";
    echo '  address	    '.$ip."\n";
    echo '  check_command   check-host-alive'."\n";
    echo '  contact_groups  admins'."\n";
    echo '}'."\n\n";

    echo 'define service{'."\n";
    echo '  use			    generic-service         ; Name of service template to use'."\n";
    echo '  host_name		    '.$hostname."\n";
    echo '  service_description	    PING'."\n";
    echo '  #   service_groups	    Services'."\n";
    echo '  check_command	    check_ping!100.0,20%!500.0,60%'."\n";
    echo '}'."\n\n";

    for($k=0;$k<$count_i;$k++)
    {
	if(trim($services[$k]) !== '')
	{
	    echo 'define service{'."\n";
	    echo '	use                             generic-service         ; Name of service template to use'."\n";
	    echo '	host_name                       '.$hostname."\n";
	    echo '	service_description             '.trim($services[$k])."\n";
	    echo '	check_command                   check_snmp_procs!'.$community.'!'.$services[$k].'!0!0'."\n";
	    echo '}'."\n\n";
	}
    }
