#!/usr/bin/php -q
<?php
    //error_reporting(0);
    include_once("snmp_get_functions.php");
    //include_once("config.php");

    $ip =           $_SERVER["argv"][1];
    $community=     $_SERVER["argv"][2];

    //=========================================================================
    $hostname=	    @get_hostname($ip,$community);
    $if_index=      @get_snmp_walk($ip,$community,'1.3.6.1.2.1.2.2.1.1');
    $count_i=count($if_index);

    $adm_st=        @get_snmp_walk($ip,$community,'1.3.6.1.2.1.2.2.1.7');
    $oper_st=       @get_snmp_walk($ip,$community,'1.3.6.1.2.1.2.2.1.8');
    $desc=          @get_snmp_walk($ip,$community,'1.3.6.1.2.1.2.2.1.2');
    $alias=         @get_snmp_walk($ip,$community,'1.3.6.1.2.1.31.1.1.1.18');
    $if_ip=         @get_snmp_walk_ip($ip,$community,$if_index);

    echo '# HOST host definition'."\n";
    echo 'define host{'."\n";
    echo '  use		    generic-host            ; Name of host template to use'."\n";
    echo '  host_name	    '.$hostname."\n";
    echo '  alias	    '.$hostname."\n";
    echo '  address	    '.$ip."\n";
    echo '  check_command   check-host-alive'."\n";
    echo '  contact_groups  admins'."\n";
    echo '}'."\n\n";

    echo 'define service{'."\n";
    echo '  use			    generic-service         ; Name of service template to use'."\n";
    echo '  host_name		    '.$hostname."\n";
    echo '  service_description	    PING'."\n";
    echo '  #   service_groups	    Services'."\n";
    echo '  check_command	    check_ping!100.0,20%!500.0,60%'."\n";
    echo '}'."\n\n";

    for($k=0;$k<$count_i;$k++)
    {
	if($adm_st[$k] == 1 || $adm_st[$k] == 'up(1)')
	{
	    
	    if(trim($alias[$k]) !== '')
	    {
		echo 'define service{'."\n";
		echo '	use                             generic-service         ; Name of service template to use'."\n";
		echo '	host_name                       '.$hostname."\n";
		echo '	service_description             '.trim($alias[$k])."\n";
		echo '	check_command                   check_snmp_iftraffic!'.$community.'!'.$if_index[$k].'!999!1000'."\n";
		echo '}'."\n\n";
	    } else
		{
		    if(trim($desc[$k]) !== 'Null0')
		    {
			echo 'define service{'."\n";
			echo '  use                             generic-service         ; Name of service template to use'."\n";
			echo '  host_name                       '.$hostname."\n";
			echo '  service_description             '.trim($desc[$k])."\n";
			echo '  check_command                   check_snmp_iftraffic!'.$community.'!'.$if_index[$k].'!999!1000'."\n";
			echo '}'."\n\n";
		    }
		}

            if(trim($if_ip[$k]) !== '' && trim($if_ip[$k]) !== trim($ip)) //skip ip identical like host
	    {
		$ip=trim($if_ip[$k]);
		$ss=stripos(trim($if_ip[$k]),'172.');
		$sss=stripos(trim($if_ip[$k]),'192.168.');
		$ssss=stripos(trim($if_ip[$k]),'10.');
		if(trim($if_ip[$k]) !== '' && ($ss > 1 || $ss === false) && ($sss > 1 || $sss === false) && ($ssss > 1 || $ssss===false))
		{
		    echo '# HOST host definition'."\n";
		    echo 'define host{'."\n";
		    echo '  use		    generic-host            ; Name of host template to use'."\n";
		    echo '  host_name	    '.$hostname.'_Interface_'.trim($alias[$k])."\n";
		    echo '  alias	    '.$hostname.'_Interface_'.trim($alias[$k])."\n";
		    echo '  address	    '.trim($if_ip[$k])."\n";
		    echo '  check_command   check-host-alive'."\n";
		    echo '  contact_groups  admins'."\n";
		    echo '}'."\n\n";

		    echo 'define service{'."\n";
		    echo '  use			    generic-service         ; Name of service template to use'."\n";		    
		    if(trim($alias[$k]) === '') echo '  host_name		    '.$hostname.'_Interface_'.trim($desc[$k])."\n";
		    else echo '  host_name		    '.$hostname.'_Interface_'.trim($alias[$k])."\n";
		    echo '  service_description	    PING'."\n";
		    echo '  #   service_groups	    Services'."\n";
		    echo '  check_command	    check_ping!100.0,20%!500.0,60%'."\n";
		    echo '}'."\n\n";
		} else
		    {
			if(trim($desc[$k]) !== 'Null0')
			{
			    echo '# HOST host definition'."\n";
			    echo 'define host{'."\n";
			    echo '  use		    generic-host            ; Name of host template to use'."\n";
			    echo '  host_name	    '.$hostname.'_Interface_'.trim($desc[$k])."\n";
			    echo '  alias		    '.$hostname.'_Interface_'.trim($desc[$k])."\n";
			    echo '  address		    '.trim($if_ip[$k])."\n";
			    echo '  check_command	    check-host-alive'."\n";
			    echo '  contact_groups	    admins'."\n";
			    echo '}'."\n\n";

			    echo 'define service{'."\n";
			    echo '  use			generic-service         ; Name of service template to use'."\n";
			    echo '  host_name		'.$hostname.'_Interface_'.trim($desc[$k])."\n";
			    echo '  service_description	PING'."\n";
			    echo '  #   service_groups	Services'."\n";
			    echo '  check_command		check_ping!100.0,20%!500.0,60%'."\n";
			    echo '}'."\n\n";
			}
		    }
	    }
            //echo "\n";
	}
    }
