<?php
    require_once("../../config/config.php");
    require_once("../../db_class.php");
    require_once("../../db_class_nagios.php");
    include_once("../../logs.php");
    include_once("snmp_get_functions.php");
         	
    $host_name=	$_REQUEST["host_name"];
    $address_ip=$_REQUEST["address_ip"];
    $community=	$_REQUEST["community"];

    $snmp_check=check_snmp($address_ip,$community);
    $file_name= dirname(__FILE__).'/tmp/'.$address_ip;
    if($snmp_check===0)
    {
	write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' REC ID: '.$rec_id);	
	$config_nag='';
    
	write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' filename: '.$file_name);
        
	$config_nag .= '### Basic Host Config ################################################################'."\n";
	$config_nag .= gen_host($community,$host_name,$address_ip);
	$config_nag .= "\n\n".'### Interfaces Config ################################################################'."\n\n";
	$config_nag .= gen_interfaces($community,$host_name,$address_ip);
	$config_nag .= "\n\n".'### Services Config ################################################################'."\n\n";
	$config_nag .= gen_services($community,$host_name,$address_ip);
	$config_nag .= "\n\n".'### End Of Config File ################################################################'."\n\n";	
    } else
	{
	    $config_nag='SNMP timeout.'."\n";
	    $config_nag.='Check access to device from App Server.';
	}
	
    try{ save_to_file(trim($file_name),$config_nag);
    } catch (Exception $ex){ write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' ERROR: '.$ex);}
    
echo trim($file_name);

function gen_host($community,$host_name,$address_ip)
{
    $config_m='';
	
    $config_m.="\n";
    $config_m.='# HOST host definition'."\n";
    $config_m.='define host{'."\n";
    $config_m.='    use                     generic-host            ; Name of host template to use'."\n";
    $config_m.='    host_name               '.$host_name."\n";
    $config_m.='    alias                   '.$host_name."\n";
    $config_m.='    address                 '.$address_ip."\n";
    $config_m.='    check_command           check-host-alive'."\n";
    $config_m.='#    host_groups             Devices'."\n";
    $config_m.='    contact_groups          admins'."\n";
    $config_m.='}'."\n";
    $config_m.="\n";
    $config_m.="\n";

    $config_m.='define service{'."\n";
    $config_m.='    use                             generic-service         ; Name of service template to use'."\n";
    $config_m.='    host_name                       '.$host_name."\n";
    $config_m.='    service_description             PING'."\n";
    $config_m.='#   service_groups                  Services'."\n";
    $config_m.='    check_command                   check_ping!100.0,20%!500.0,60%'."\n";
    $config_m.='}'."\n";

    $config_m.="\n";
    $config_m.="\n";

    $config_m.='define service{'."\n";
    $config_m.='    use                             generic-service         ; Name of service template to use'."\n";
    $config_m.='    host_name                       '.$host_name."\n";
    $config_m.='    service_description             Interfaces'."\n";
    $config_m.='#   service_groups                  Services'."\n";
    $config_m.='    check_command                   check_interface_table!'.$community."\n";
    $config_m.='}'."\n";
	
    return $config_m;
}

function gen_interfaces($community,$host_name,$address_ip)
{
    include_once("snmp_get_functions.php");

    $config_m='';
    $ip=	    $address_ip;
    $hostname=	    @get_hostname($ip,$community); //from snmp
    $if_index=      @get_snmp_walk($ip,$community,'1.3.6.1.2.1.2.2.1.1');
    $count_i=count($if_index);

    $adm_st=        @get_snmp_walk($ip,$community,'1.3.6.1.2.1.2.2.1.7');
    $oper_st=       @get_snmp_walk($ip,$community,'1.3.6.1.2.1.2.2.1.8');
    $desc=          @get_snmp_walk($ip,$community,'1.3.6.1.2.1.2.2.1.2');
    $alias=         @get_snmp_walk($ip,$community,'1.3.6.1.2.1.31.1.1.1.18');
    $if_ip=         @get_snmp_walk_ip($ip,$community,$if_index);

    for($k=0;$k<$count_i;$k++)
    {
	if($adm_st[$k] == 1 || $adm_st[$k] == 'up(1)')
	{	    
	    if(trim($alias[$k]) !== '')
	    {
		$config_m.= 'define service{'."\n";
		$config_m.= '	use                             generic-service         ; Name of service template to use'."\n";
		$config_m.= '	host_name                       '.$hostname."\n";
		$config_m.= '	service_description             '.trim($alias[$k])."\n";
		$config_m.= '	check_command                   check_snmp_iftraffic!'.$community.'!'.$if_index[$k].'!999!1000'."\n";
		$config_m.= '}'."\n\n";
	    } else
		{
		    if(trim($desc[$k]) !== 'Null0')
		    {
			$config_m.= 'define service{'."\n";
			$config_m.= '  use                             generic-service         ; Name of service template to use'."\n";
			$config_m.= '  host_name                       '.$hostname."\n";
			$config_m.= '  service_description             '.trim($desc[$k])."\n";
			$config_m.= '  check_command                   check_snmp_iftraffic!'.$community.'!'.$if_index[$k].'!999!1000'."\n";
			$config_m.= '}'."\n\n";
		    }
		}

            if(trim($if_ip[$k]) !== '' && trim($if_ip[$k]) !== trim($ip)) //skip ip identical like host
	    {
		if(trim($alias[$k]) !== '')
		{
		    $config_m.= '# HOST host definition'."\n";
		    $config_m.= 'define host{'."\n";
		    $config_m.= '  use		    generic-host            ; Name of host template to use'."\n";
		    $config_m.= '  host_name	    '.$hostname.'_Interface_'.trim($alias[$k])."\n";
		    $config_m.= '  alias	    '.$hostname.'_Interface_'.trim($alias[$k])."\n";
		    $config_m.= '  address	    '.trim($if_ip[$k])."\n";
		    $config_m.= '  check_command   check-host-alive'."\n";
		    $config_m.= '  contact_groups  admins'."\n";
		    $config_m.= '}'."\n\n";

		    $config_m.= 'define service{'."\n";
		    $config_m.= '  use			    generic-service         ; Name of service template to use'."\n";
		    $config_m.= '  host_name		    '.$hostname.'_Interface_'.trim($alias[$k])."\n";
		    $config_m.= '  service_description	    PING'."\n";
		    $config_m.= '  #   service_groups	    Services'."\n";
		    $config_m.= '  check_command	    check_ping!100.0,20%!500.0,60%'."\n";
		    $config_m.= '}'."\n\n";
		} else
		    {
			if(trim($desc[$k]) !== 'Null0')
			{
			    $config_m.= '# HOST host definition'."\n";
			    $config_m.= 'define host{'."\n";
			    $config_m.= '  use		    generic-host            ; Name of host template to use'."\n";
			    $config_m.= '  host_name	    '.$hostname.'_Interface_'.trim($desc[$k])."\n";
			    $config_m.= '  alias		    '.$hostname.'_Interface_'.trim($desc[$k])."\n";
			    $config_m.= '  address		    '.trim($if_ip[$k])."\n";
			    $config_m.= '  check_command	    check-host-alive'."\n";
			    $config_m.= '  contact_groups	    admins'."\n";
			    $config_m.= '}'."\n\n";

			    $config_m.= 'define service{'."\n";
			    $config_m.= '  use			generic-service         ; Name of service template to use'."\n";
			    $config_m.= '  host_name		'.$hostname.'_Interface_'.trim($desc[$k])."\n";
			    $config_m.= '  service_description	PING'."\n";
			    $config_m.= '  #   service_groups	Services'."\n";
			    $config_m.= '  check_command		check_ping!100.0,20%!500.0,60%'."\n";
			    $config_m.= '}'."\n\n";
			}
		    }
	    }
            //echo "\n";
	}
    }
    return $config_m;
}

function gen_services($community,$host_name,$address_ip)
{
    include_once("snmp_get_functions.php");

    $config_m='';
    $ip =           $address_ip;
    $hostname=	    @get_hostname($ip,$community);
    $services=      @get_snmp_walk($ip,$community,'1.3.6.1.2.1.25.4.2.1.2');
    $services=array_unique($services);
    $count_i=count($services);

    for($k=0;$k<$count_i;$k++)
    {
	if(trim($services[$k]) !== '')
	{
	    $config_m.= 'define service{'."\n";
	    $config_m.= '	use                             generic-service         ; Name of service template to use'."\n";
	    $config_m.= '	host_name                       '.$hostname."\n";
	    $config_m.= '	service_description             '.trim($services[$k])."\n";
	    $config_m.= '	check_command                   check_snmp_procs!'.$community.'!'.$services[$k].'!0!0'."\n";
	    $config_m.= '}'."\n\n";
	}
    }
    return $config_m;
}

function save_to_file($file_name,$config_nag)
{
    try 
    {
        file_put_contents($file_name,$config_nag, LOCK_EX);
    } catch (Exception $ex){;}
    return $file_name;
}


?>
