-- MySQL dump 10.14  Distrib 5.5.68-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: nagios
-- ------------------------------------------------------
-- Server version	5.5.68-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `nagios`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `nagios` /*!40100 DEFAULT CHARACTER SET latin1 */;

USE `nagios`;

--
-- Table structure for table `nagios_acknowledgements`
--

DROP TABLE IF EXISTS `nagios_acknowledgements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nagios_acknowledgements` (
  `acknowledgement_id` int(11) NOT NULL AUTO_INCREMENT,
  `instance_id` smallint(6) NOT NULL DEFAULT '0',
  `entry_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `entry_time_usec` int(11) NOT NULL DEFAULT '0',
  `acknowledgement_type` smallint(6) NOT NULL DEFAULT '0',
  `object_id` int(11) NOT NULL DEFAULT '0',
  `state` smallint(6) NOT NULL DEFAULT '0',
  `author_name` varchar(64) NOT NULL DEFAULT '',
  `comment_data` varchar(255) NOT NULL DEFAULT '',
  `is_sticky` smallint(6) NOT NULL DEFAULT '0',
  `persistent_comment` smallint(6) NOT NULL DEFAULT '0',
  `notify_contacts` smallint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`acknowledgement_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COMMENT='Current and historical host and service acknowledgements';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nagios_acknowledgements`
--

LOCK TABLES `nagios_acknowledgements` WRITE;
/*!40000 ALTER TABLE `nagios_acknowledgements` DISABLE KEYS */;
/*!40000 ALTER TABLE `nagios_acknowledgements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nagios_commands`
--

DROP TABLE IF EXISTS `nagios_commands`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nagios_commands` (
  `command_id` int(11) NOT NULL AUTO_INCREMENT,
  `instance_id` smallint(6) NOT NULL DEFAULT '0',
  `config_type` smallint(6) NOT NULL DEFAULT '0',
  `object_id` int(11) NOT NULL DEFAULT '0',
  `command_line` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`command_id`),
  UNIQUE KEY `instance_id` (`instance_id`,`object_id`,`config_type`)
) ENGINE=InnoDB AUTO_INCREMENT=1529 DEFAULT CHARSET=latin1 COMMENT='Command definitions';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nagios_commands`
--

LOCK TABLES `nagios_commands` WRITE;
/*!40000 ALTER TABLE `nagios_commands` DISABLE KEYS */;
INSERT INTO `nagios_commands` VALUES (1411,2,1,26989,'$USER1$/check_ping -H $HOSTADDRESS$ -w 10000.0,85% -c 50000.0,100% -p 20 -t 2'),(1412,2,1,26990,'$USER1$/check_tcp -H $HOSTADDRESS$ -w 5000.0,85% -c 10000.0,100% -p $ARG1'),(1413,2,1,26991,'$USER1$/check_ping -H $HOSTADDRESS$ -w 15000.0,85% -c 20000.0,100% -p 20 -t 5'),(1414,2,1,26992,'$USER1$/ping_core.ip.sh $HOSTADDRESS$'),(1415,2,1,26993,'$USER1$/check_tcp -H $HOSTADDRESS$ -p $ARG1$'),(1416,2,1,26994,'$USER1$/check_cmts_power.pl $HOSTADDRESS$ $ARG1$ $ARG2$ $ARG3$ $ARG4$ $ARG5$ $ARG6$ $ARG7$'),(1417,2,1,26995,'$USER1$/check_cmts_sn.pl $HOSTADDRESS$ $ARG1$ $ARG2$ $ARG3$ $ARG4$ $ARG5$ $ARG6$ $ARG7$'),(1418,2,1,26996,'$USER1$/check_cmts_sn2.pl $HOSTADDRESS$ $ARG1$ $ARG2$ $ARG3$ $ARG4$ $ARG5$ $ARG6$ $ARG7$'),(1419,2,1,26997,'$USER1$/check_cmts_sn3.pl $HOSTADDRESS$ $ARG1$ $ARG2$ $ARG3$ $ARG4$ $ARG5$ $ARG6$ $ARG7$ $ARG8$ $ARG9$ $ARG10$'),(1420,2,1,26998,'$USER1$/check_by_telnet $HOSTADDRESS$ $ARG1$ $ARG2$ $ARG3$'),(1421,2,1,26999,'$USER1$/check_dhcp -s $HOSTADDRESS$ -t 10'),(1422,2,1,27000,'$USER1$/check_snmp -H $HOSTADDRESS$ -C $ARG1$ -o $ARG2$ -w$ARG3$ -c$ARG4$'),(1423,2,1,27001,'$USER1$/check_dns -H poczta.tvkdiana.pl -s $HOSTADDRESS$'),(1424,2,1,27002,'$USER1$/check_tcp -H $HOSTADDRESS$ -p 53'),(1425,2,1,27003,'$USER1$/check_by_telnet $HOSTADDRESS$ $ARG1$ $ARG2$ $ARG3$'),(1426,2,1,27004,'$USER1$/check_snmp -H $HOSTADDRESS$ -C $ARG1$ -o $ARG2$ -w$ARG3$ -c$ARG4$'),(1427,2,1,27005,'$USER1$/check_nrpe!check_file_size_squid'),(1428,2,1,27006,'$USER1$/check_by_telnet $HOSTADDRESS$ $ARG1$ $ARG2$ $ARG3$'),(1429,2,1,27007,'$USER1$/check_ftp -H $HOSTADDRESS$ -t 60'),(1430,2,1,27008,'$USER1$/check_hfc_traffic.pl -H $HOSTADDRESS$ -C $ARG1$ -i $ARG2$ -b 1 -u m'),(1431,2,1,27009,'$USER1$/check_hp2.pl -H $HOSTADDRESS$ -C $ARG1'),(1432,2,1,27010,'$USER1$/check_hp2.pl -p 1161 -H $HOSTADDRESS$ -C $ARG1$'),(1433,2,1,27011,'$USER1$/check_hpjd -H $HOSTADDRESS$ -C public'),(1434,2,1,27012,'$USER1$/check_http -H $HOSTADDRESS$'),(1435,2,1,27013,'$USER1$/check_http -H $HOSTADDRESS$ -p 8888'),(1436,2,1,27014,'$USER1$/check_tcp -H $ARG2$ -p $ARG1$'),(1437,2,1,27015,'$USER1$/check_http -H $HOSTADDRESS$ -p 8004'),(1438,2,1,27016,'$USER1$/check_http -H $HOSTADDRESS$ -p 80'),(1439,2,1,27017,'$USER1$/check_tcp -H $HOSTADDRESS$ -p 8888'),(1440,2,1,27018,'$USER1$/check_imap -H $HOSTADDRESS$'),(1441,2,1,27019,'$USER1$/check_interface_core.sh -H $HOSTADDRESS$'),(1442,2,1,27020,'$USER1$/check_interface_table_v3t.pl -H $HOSTADDRESS$ -C $ARG1$ -f --duplex --v2c --64bits --alias --ipinfo --noconfigtable --css nagiosxi'),(1443,2,1,27021,'$USER1$/check_interface_table_v3t.pl -H $HOSTADDRESS$ -C $ARG1$ -f --stp --duplex --64bits --v2c --alias'),(1444,2,1,27022,'$USER1$/check_interface_table_core_ip.sh $HOSTADDRESS$ $ARG1$'),(1445,2,1,27023,'$USER1$/check_interface_table_v3t.pl -H $HOSTADDRESS$ -C $ARG1$ -f'),(1446,2,1,27024,'$USER1$/check_by_telnet $HOSTADDRESS$ $ARG1$ $ARG2$ $ARG3$'),(1447,2,1,27025,'$USER1$/check_disk -w $ARG1$ -c $ARG2$ -p $ARG3$'),(1448,2,1,27026,'$USER1$/check_load -w $ARG1$ -c $ARG2$'),(1449,2,1,27027,'$USER1$/check_procs -w $ARG1$ -c $ARG2$ -s $ARG3$'),(1450,2,1,27028,'$USER1$/check_users -w $ARG1$ -c $ARG2$'),(1451,2,1,27029,'$USER1$/logged_modems_downstreams.pl $HOSTADDRESS$'),(1452,2,1,27030,'$USER1$/logged_modems_upstreams.pl $HOSTADDRESS$ $ARG1$'),(1453,2,1,27031,'$USER1$/check_tcp -H $HOSTADDRESS$ -p 3306'),(1454,2,1,27032,'$USER1$/check_mysql_health --hostname $HOSTADDRESS$ --database $ARG1$ --mode $ARG2$ --username $ARG3$ --password $ARG4$'),(1455,2,1,28633,'$USER1$/check_mysqld.pl -H $HOSTADDRESS$ -u $ARG1$ -p $ARG2$ $ARG3$ -w \",,,,\" -c \",,,,>1000\"'),(1456,2,1,27033,'$USER1$/check_rpc -H $HOSTADDRESS$ -C nfs'),(1457,2,1,27034,'$USER1$/check_nntp -H $HOSTADDRESS$'),(1458,2,1,27035,'$USER1$/check_nrpe -H $HOSTADDRESS$ -c check_disk -a $ARG1$ $ARG2$ $ARG3$'),(1459,2,1,27036,'$USER1$/check_nrpe -H $HOSTADDRESS$ -c check_load -a $ARG1$ $ARG2$'),(1460,2,1,27037,'$USER1$/check_nrpe -H $HOSTADDRESS$ -c check_procs_s -a $ARG1$ $ARG2$ $ARG3$'),(1461,2,1,27038,'$USER1$/check_nrpe -H $HOSTADDRESS$ -c check_users -a $ARG1$ $ARG2$'),(1462,2,1,27039,'$USER1$/check_nt -H $HOSTADDRESS$ -p 12489 -v $ARG1$ $ARG2$'),(1463,2,1,27040,'$USER1$/check_ping -H $HOSTADDRESS$ -w $ARG1$ -c $ARG2$ -p 20 -t 2'),(1464,2,1,27041,'$USER1$/ping_core.ip.sh $HOSTADDRESS$'),(1465,2,1,27042,'$USER1$/check_pop -H $HOSTADDRESS$'),(1466,2,1,27043,'$USER1$/check_postgres.pl -H $HOSTADDRESS$ -db $ARG1$ $ARG2$'),(1467,2,1,27044,'$USER1$/check_progress_actserver.sh -pf $ARG1$'),(1468,2,1,27045,'$USER1$/check_areaS_space_utilization.sh -pf $ARG1$'),(1469,2,1,27046,'$USER1$/check_progress_bufferact.sh -pf $ARG1$'),(1470,2,1,27047,'$USER1$/check_progress_checkpoint.sh -pf $ARG1$'),(1471,2,1,27048,'$USER1$/check_progress_dbread.sh -pf $ARG1$'),(1472,2,1,27049,'$USER1$/check_progress_lockact.sh -pf $ARG1$'),(1473,2,1,27050,'$USER1$/check_progress_users.sh -pf $ARG1$ -w $ARG2$ -c $ARG3$'),(1474,2,1,27051,'$USER1$/check_tcp -H $HOSTADDRESS$ -p $ARG1$'),(1475,2,1,27052,'$USER1$/check_smtp -H $HOSTADDRESS$'),(1476,2,1,27053,'$USER1$/check_snmp -H $HOSTADDRESS$ -C $ARG1$ -o $ARG2$ -w$ARG3$ -c$ARG4$ -l $ARG5$'),(1477,2,1,27054,'$USER1$/check_snmp -H $HOSTADDRESS$ -C $ARG1$ -o $ARG2$'),(1478,2,1,27055,'$USER1$/check_snmp -H $HOSTADDRESS$ -C $ARG1$ -o ssCpuUser.0,ssCpuSystem.0,ssCpuIdle.0 -w$ARG2$ -c$ARG3$'),(1479,2,1,27056,'$USER1$/check_snmp -H $HOSTADDRESS$ -C $ARG1$ -p 1161 -o ssCpuUser.0,ssCpuSystem.0,ssCpuIdle.0 -w$ARG2$ -c$ARG3$'),(1480,2,1,27057,'$USER1$/check_centreon_snmp_cpu -H $HOSTADDRESS$ -C $ARG1$'),(1481,2,1,27058,'$USER1$/check_snmp -H $HOSTADDRESS$ -C $ARG1$ -o $ARG2$ -w $ARG3$ -l $ARG4$'),(1482,2,1,27059,'$USER1$/check_snmp_storage.pl -H $HOSTADDRESS$ -C $ARG1$ -m $ARG2$ -w $ARG3$ -c $ARG4$ -T pl -f -r'),(1483,2,1,27060,'$USER1$/check_snmp_storage.pl -H $HOSTADDRESS$ -C $ARG1$ -p 1161 -m $ARG2$ -w $ARG3$ -c $ARG4$ -T pl -f -r'),(1484,2,1,27061,'$USER1$/check_snmp_disk.pl -H $HOSTADDRESS$ -C $ARG1$ -m $ARG2$ -w $ARG3$ -c $ARG4$ -i $ARG2$'),(1485,2,1,27062,'$USER1$/check_snmp_int.pl -H $HOSTADDRESS$ -C $ARG1$ -n $ARG2$ -f -k -w$ARG3$ -c$ARG4$ -t 1'),(1486,2,1,27063,'$USER1$/check_netint.pl -H $HOSTADDRESS$ -C $ARG1$ -n $ARG2$ -f -k -q -e -Z -w0,0,1,1,1,1 -c0,0,2,2,2,2 -t 10'),(1487,2,1,27064,'$USER1$/check_snmp_int.pl -H $HOSTADDRESS$ -C $ARG1$ -n $ARG2$ -p 1161 -f -k -w$ARG3$ -c$ARG4$ -e -r -t 1'),(1488,2,1,27065,'$USER1$/check_snmp_int_d5.pl -H $HOSTADDRESS$ -C $ARG1$ -n $ARG2$ -f -k -w$ARG3$ -c$ARG4$ -t 1'),(1489,2,1,27066,'$USER1$/check_centreon_snmp_traffic -H $HOSTADDRESS$ -C $ARG1$ -i $ARG2$ -n --64-bits -v2c'),(1490,2,1,27067,'$USER1$/check_centreon_snmp_traffic -H $HOSTADDRESS$ -C $ARG1$ -i $ARG2$ -n'),(1491,2,1,27068,'$USER1$/check_centreon_snmp_traffic -H $HOSTADDRESS$ -C $ARG1$ -i $ARG2$ -n --64-bits -v2c'),(1492,2,1,27069,'$USER1$/check_iftraffic_error.pl -H $HOSTADDRESS$ -C $ARG1$ -i $ARG2$ -b 1000 -w $ARG3$ -c $ARG4$ -u m'),(1493,2,1,27070,'$USER1$/check_snmp -H $HOSTADDRESS$ -C $ARG1$ -o $ARG2$ -w$ARG3$ -c$ARG4$ -l \"IO_utilize\"'),(1494,2,1,27071,'$USER1$/check_snmp_load.pl -H $HOSTADDRESS$ -C $ARG1$ -w$ARG2$ -c$ARG3$ $ARG4$ -f'),(1495,2,1,27072,'$USER1$/check_snmp -H $HOSTADDRESS$ -C $ARG1$ -o $ARG2$ -l $ARG3$'),(1496,2,1,27073,'$USER1$/check_snmp_load.pl -H $HOSTADDRESS$ -C $ARG1$ -p 1161 -w$ARG2$ -c$ARG3$ $ARG4$ -f'),(1497,2,1,27074,'$USER1$/check_snmp_load.pl -H $HOSTADDRESS$ -C $ARG1$ -w$ARG2$ -c$ARG3$ $ARG4$ -f'),(1498,2,1,27075,'$USER1$/check_snmp_mem.pl -H $HOSTADDRESS$ -C $ARG1$ -w$ARG2$ -c$ARG3$ $ARG4$ -f'),(1499,2,1,27076,'$USER1$/check_snmp.pl $HOSTADDRESS$ $ARG1$ $ARG2$ $ARG3$ $ARG4$ $ARG5$ $ARG6$'),(1500,2,1,27077,'$USER1$/check_snmp_process.pl -H $HOSTADDRESS$ -C $ARG1$ -n $ARG2$ -w $ARG3$ -c $ARG4$ -F'),(1501,2,1,27078,'$USER1$/check_snmp_process.pl -H $HOSTADDRESS$ -C $ARG1$ -n $ARG2$ -w $ARG3$ -c $ARG4$ -F -p $ARG5$'),(1502,2,1,27079,'$USER1$/check_snmp_process.pl -H $HOSTADDRESS$ -C $ARG1$ -n $ARG2$ -w $ARG3$ -c $ARG4$ -F'),(1503,2,1,27080,'$USER1$/check_snmp_procs.pl -H $HOSTADDRESS$ -C $ARG1$ -p $ARG2$'),(1504,2,1,27081,'$USER1$/check_snmp -H $HOSTADDRESS$ -C $ARG1$ -o $ARG2$ -p $ARG3$ -m /usr/local/nagios/libexec/squid.mib'),(1505,2,1,27082,'$USER1$/check_snmp -H $HOSTADDRESS$ -C $ARG1$ -o tcpCurrEstab.0,tcpAttemptFails.0 -w$ARG2$ -c$ARG3$ -l $ARG4$'),(1506,2,1,27083,'$USER1$/check_snmp -H $HOSTADDRESS$ -C $ARG1$ -p 1161 -o tcpCurrEstab.0,tcpAttemptFails.0 -w$ARG2$ -c$ARG3$ -l $ARG4$'),(1507,2,1,27084,'$USER1$/check_snmp -H $HOSTADDRESS$ -C $ARG1$ -o hrSystemNumUsers.0 -w$ARG2$ -c$ARG3$'),(1508,2,1,27085,'$USER1$/check_tcp -H $HOSTADDRESS$ -p $ARG1$'),(1509,2,1,27086,'$USER1$/check_ssh $HOSTADDRESS$'),(1510,2,1,27087,'$USER1$/check_by_telnet $HOSTADDRESS$ $ARG1$ $ARG2$ $ARG3$'),(1511,2,1,27088,'$USER1$/check_tcp -H $HOSTADDRESS$ -p $ARG1$'),(1512,2,1,27089,'$USER1$/check_tcp -H $HOSTADDRESS$ -p 23'),(1513,2,1,27090,'$USER1$/check_tftp.pl $HOSTADDRESS$ $ARG1$'),(1514,2,1,27091,'$USER1$/total_logged_modems.pl $HOSTADDRESS$'),(1515,2,1,27092,'$USER1$/total_logged_pc.php $HOSTADDRESS$'),(1516,2,1,27093,'$USER1$/check_udp -H $HOSTADDRESS$ -p $ARG1$'),(1517,2,1,27094,'$USER1$/check_by_telnet $HOSTADDRESS$ $ARG1$ $ARG2$ $ARG3$'),(1518,2,1,27095,'$USER1$/check_vip_load.pl $HOSTADDRESS$ $ARG1$ $ARG2$ $ARG3$'),(1519,2,1,27096,'/usr/bin/printf \"%b\" \"***** Nagios  *****\\n\\nNotification Type: $NOTIFICATIONTYPE$\\nHost: $HOSTNAME$\\nState: $HOSTSTATE$\\nAddress: $HOSTADDRESS$\\nInfo: $HOSTOUTPUT$\\n\\nDate/Time: $LONGDATETIME$\\n\" | /bin/mail -s \"Host $HOSTSTATE$ alert for $HOSTNAME$!\" $C'),(1520,2,1,27097,'/usr/local/nagios/mail/mail.sh $CONTACTEMAIL$ \"**Monitor Systemu TVKDIANA** Notification Type: $NOTIFICATIONTYPE$ Service: $SERVICEDESC$ Host: $HOSTALIAS$ Address: $HOSTADDRESS$ State: $SERVICESTATE$ Date/Time: $LONGDATETIME$ Additional Info: $SERVICEOUTP'),(1521,2,1,27098,'/usr/bin/printf \"%b\" \"Host \'$HOSTALIAS$\' is $HOSTSTATE$\\nInfo: $HOSTOUTPUT$\\nTime: $LONGDATETIME$\" | /bin/mail -s \"$NOTIFICATIONTYPE$ alert - Host $HOSTNAME$ is $HOSTSTATE$\" $CONTACTPAGER$'),(1522,2,1,27099,'/usr/bin/printf \"%b\" \"Address: $HOSTALIAS$ Info: $HOSTSTATE$ Date: $SHORTDATETIME$\" | /usr/bin/gnokii --sendsms $CONTACTPAGER$'),(1523,2,1,27100,'/usr/bin/printf \"%b\" \"***** Nagios  *****\\n\\nNotification Type: $NOTIFICATIONTYPE$\\n\\nService: $SERVICEDESC$\\nHost: $HOSTALIAS$\\nAddress: $HOSTADDRESS$\\nState: $SERVICESTATE$\\n\\nDate/Time: $LONGDATETIME$\\n\\nAdditional Info:\\n\\n$SERVICEOUTPUT$\" | /bin/mail'),(1524,2,1,27101,'/usr/local/nagios/mail/mail.sh $CONTACTEMAIL$ \"**Monitor Systemu TVKDIANA** Notification-Type:-$NOTIFICATIONTYPE$ Service:-$SERVICEDESC$ Host:-$HOSTALIAS$ Address:-$HOSTADDRESS$ State:-$SERVICESTATE$ Date/Time:-$LONGDATETIME$ Additional-Info: $SERVICEOUTP'),(1525,2,1,27102,'/usr/bin/printf \"%b\" \"Service: $SERVICEDESC$\\nHost: $HOSTNAME$\\nAddress: $HOSTADDRESS$\\nState: $SERVICESTATE$\\nInfo: $SERVICEOUTPUT$\\nDate: $LONGDATETIME$\" | /bin/mail -s \"$NOTIFICATIONTYPE$: $HOSTALIAS$/$SERVICEDESC$ is $SERVICESTATE$\" $CONTACTPAGER$'),(1526,2,1,27103,'/usr/bin/printf \"%b\" \"Service: $SERVICEDESC$ Address: $HOSTADDRESS$ Info: $SERVICEOUTPUT$ Date: $SHORTDATETIME$\" | /usr/bin/gnokii --sendsms $CONTACTPAGER$'),(1527,2,1,27104,'$USER1$/passive_check_missing'),(1528,2,1,27105,'/usr/local/nagios/etc/www/webinject.pl -c $ARG1$ $ARG2$');
/*!40000 ALTER TABLE `nagios_commands` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nagios_commenthistory`
--

DROP TABLE IF EXISTS `nagios_commenthistory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nagios_commenthistory` (
  `commenthistory_id` int(11) NOT NULL AUTO_INCREMENT,
  `instance_id` smallint(6) NOT NULL DEFAULT '0',
  `entry_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `entry_time_usec` int(11) NOT NULL DEFAULT '0',
  `comment_type` smallint(6) NOT NULL DEFAULT '0',
  `entry_type` smallint(6) NOT NULL DEFAULT '0',
  `object_id` int(11) NOT NULL DEFAULT '0',
  `comment_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `internal_comment_id` int(11) NOT NULL DEFAULT '0',
  `author_name` varchar(64) NOT NULL DEFAULT '',
  `comment_data` varchar(255) NOT NULL DEFAULT '',
  `is_persistent` smallint(6) NOT NULL DEFAULT '0',
  `comment_source` smallint(6) NOT NULL DEFAULT '0',
  `expires` smallint(6) NOT NULL DEFAULT '0',
  `expiration_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `deletion_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `deletion_time_usec` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`commenthistory_id`),
  UNIQUE KEY `instance_id` (`instance_id`,`comment_time`,`internal_comment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COMMENT='Historical host and service comments';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nagios_commenthistory`
--

LOCK TABLES `nagios_commenthistory` WRITE;
/*!40000 ALTER TABLE `nagios_commenthistory` DISABLE KEYS */;
/*!40000 ALTER TABLE `nagios_commenthistory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nagios_comments`
--

DROP TABLE IF EXISTS `nagios_comments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nagios_comments` (
  `comment_id` int(11) NOT NULL AUTO_INCREMENT,
  `instance_id` smallint(6) NOT NULL DEFAULT '0',
  `entry_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `entry_time_usec` int(11) NOT NULL DEFAULT '0',
  `comment_type` smallint(6) NOT NULL DEFAULT '0',
  `entry_type` smallint(6) NOT NULL DEFAULT '0',
  `object_id` int(11) NOT NULL DEFAULT '0',
  `comment_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `internal_comment_id` int(11) NOT NULL DEFAULT '0',
  `author_name` varchar(64) NOT NULL DEFAULT '',
  `comment_data` varchar(255) NOT NULL DEFAULT '',
  `is_persistent` smallint(6) NOT NULL DEFAULT '0',
  `comment_source` smallint(6) NOT NULL DEFAULT '0',
  `expires` smallint(6) NOT NULL DEFAULT '0',
  `expiration_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`comment_id`),
  UNIQUE KEY `instance_id` (`instance_id`,`comment_time`,`internal_comment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nagios_comments`
--

LOCK TABLES `nagios_comments` WRITE;
/*!40000 ALTER TABLE `nagios_comments` DISABLE KEYS */;
/*!40000 ALTER TABLE `nagios_comments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nagios_configfiles`
--

DROP TABLE IF EXISTS `nagios_configfiles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nagios_configfiles` (
  `configfile_id` int(11) NOT NULL AUTO_INCREMENT,
  `instance_id` smallint(6) NOT NULL DEFAULT '0',
  `configfile_type` smallint(6) NOT NULL DEFAULT '0',
  `configfile_path` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`configfile_id`),
  UNIQUE KEY `instance_id` (`instance_id`,`configfile_type`,`configfile_path`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=latin1 COMMENT='Configuration files';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nagios_configfiles`
--

LOCK TABLES `nagios_configfiles` WRITE;
/*!40000 ALTER TABLE `nagios_configfiles` DISABLE KEYS */;
INSERT INTO `nagios_configfiles` VALUES (13,2,0,'/usr/local/nagios3/etc/nagios.cfg');
/*!40000 ALTER TABLE `nagios_configfiles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nagios_configfilevariables`
--

DROP TABLE IF EXISTS `nagios_configfilevariables`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nagios_configfilevariables` (
  `configfilevariable_id` int(11) NOT NULL AUTO_INCREMENT,
  `instance_id` smallint(6) NOT NULL DEFAULT '0',
  `configfile_id` int(11) NOT NULL DEFAULT '0',
  `varname` varchar(64) NOT NULL DEFAULT '',
  `varvalue` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`configfilevariable_id`),
  UNIQUE KEY `instance_id` (`instance_id`,`configfile_id`,`varname`)
) ENGINE=InnoDB AUTO_INCREMENT=1629 DEFAULT CHARSET=latin1 COMMENT='Configuration file variables';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nagios_configfilevariables`
--

LOCK TABLES `nagios_configfilevariables` WRITE;
/*!40000 ALTER TABLE `nagios_configfilevariables` DISABLE KEYS */;
INSERT INTO `nagios_configfilevariables` VALUES (1492,2,13,'log_file','/usr/local/nagios3/var/nagios.log'),(1493,2,13,'cfg_dir','/usr/local/nagios3/etc/system'),(1496,2,13,'object_cache_file','/usr/local/nagios3/var/objects.cache'),(1497,2,13,'precached_object_file','/usr/local/nagios3/var/objects.precache'),(1498,2,13,'resource_file','/usr/local/nagios3/etc/resource.cfg'),(1499,2,13,'status_file','/usr/local/nagios3/var/status.dat'),(1500,2,13,'status_update_interval','5'),(1501,2,13,'nagios_user','nagios'),(1502,2,13,'nagios_group','nagios'),(1503,2,13,'check_external_commands','1'),(1504,2,13,'command_check_interval','-1'),(1505,2,13,'command_file','/usr/local/nagios3/var/rw/nagios.cmd'),(1506,2,13,'external_command_buffer_slots','4096'),(1507,2,13,'lock_file','/usr/local/nagios3/var/nagios.lock'),(1508,2,13,'temp_file','/usr/local/nagios3/var/nagios.tmp'),(1509,2,13,'temp_path','/tmp'),(1510,2,13,'event_broker_options','-1'),(1511,2,13,'broker_module','/usr/local/nagios3/bin/ndomod-3x.o config_file=/usr/local/nagios3/etc/ndomod.cfg'),(1512,2,13,'log_rotation_method','d'),(1513,2,13,'log_archive_path','/usr/local/nagios3/var/archives'),(1514,2,13,'use_syslog','0'),(1515,2,13,'log_notifications','1'),(1516,2,13,'log_service_retries','1'),(1517,2,13,'log_host_retries','0'),(1518,2,13,'log_event_handlers','0'),(1519,2,13,'log_initial_states','1'),(1520,2,13,'log_external_commands','1'),(1521,2,13,'log_passive_checks','1'),(1522,2,13,'service_inter_check_delay_method','s'),(1523,2,13,'max_service_check_spread','15'),(1524,2,13,'service_interleave_factor','s'),(1525,2,13,'host_inter_check_delay_method','s'),(1526,2,13,'max_host_check_spread','15'),(1527,2,13,'max_concurrent_checks','0'),(1528,2,13,'check_result_reaper_frequency','5'),(1529,2,13,'max_check_result_reaper_time','5'),(1530,2,13,'check_result_path','/usr/local/nagios3/var/spool/checkresults'),(1531,2,13,'max_check_result_file_age','3600'),(1532,2,13,'cached_host_check_horizon','15'),(1533,2,13,'cached_service_check_horizon','15'),(1534,2,13,'enable_predictive_host_dependency_checks','1'),(1535,2,13,'enable_predictive_service_dependency_checks','1'),(1536,2,13,'soft_state_dependencies','0'),(1537,2,13,'time_change_threshold','900'),(1538,2,13,'auto_rescheduling_interval','30'),(1539,2,13,'auto_rescheduling_window','180'),(1540,2,13,'sleep_time','1'),(1541,2,13,'service_check_timeout','30'),(1542,2,13,'host_check_timeout','30'),(1543,2,13,'event_handler_timeout','10'),(1544,2,13,'notification_timeout','10'),(1545,2,13,'ocsp_timeout','5'),(1546,2,13,'perfdata_timeout','10'),(1547,2,13,'retain_state_information','1'),(1548,2,13,'state_retention_file','/usr/local/nagios3/var/retention.dat'),(1549,2,13,'retention_update_interval','60'),(1550,2,13,'use_retained_program_state','1'),(1551,2,13,'use_retained_scheduling_info','1'),(1552,2,13,'retained_host_attribute_mask','0'),(1553,2,13,'retained_service_attribute_mask','0'),(1554,2,13,'retained_process_host_attribute_mask','0'),(1555,2,13,'retained_process_service_attribute_mask','0'),(1556,2,13,'retained_contact_host_attribute_mask','0'),(1557,2,13,'retained_contact_service_attribute_mask','0'),(1558,2,13,'interval_length','60'),(1559,2,13,'check_for_updates','0'),(1560,2,13,'bare_update_check','0'),(1561,2,13,'use_aggressive_host_checking','1'),(1562,2,13,'execute_service_checks','1'),(1563,2,13,'accept_passive_service_checks','1'),(1564,2,13,'execute_host_checks','1'),(1565,2,13,'accept_passive_host_checks','1'),(1566,2,13,'enable_notifications','1'),(1567,2,13,'enable_event_handlers','1'),(1568,2,13,'process_performance_data','1'),(1569,2,13,'service_perfdata_command','process-service-perfdata'),(1570,2,13,'host_perfdata_command','process-host-perfdata     # NOT advisable prior to Nagios 3.0'),(1571,2,13,'service_perfdata_file','/usr/local/nagios/var/service-perfdata'),(1572,2,13,'service_perfdata_file_template','DATATYPE::SERVICEPERFDATA\\tTIMET::$TIMET$\\tHOSTNAME::$HOSTNAME$\\tSERVICEDESC::$SERVICEDESC$\\tSERVICEPERFDATA::$SERVICEPERFDATA$\\tSERVICECHECKCOMMAND::$SERVICECHECKCOMMAND$\\tHOSTSTATE::$HOSTSTATE$\\tHOSTSTATETYPE::$HOSTSTATETYPE$\\tSERVICESTATE::$SERVICESTAT'),(1573,2,13,'service_perfdata_file_mode','w'),(1574,2,13,'service_perfdata_file_processing_interval','10'),(1575,2,13,'service_perfdata_file_processing_command','process-service-perfdata-file'),(1576,2,13,'host_perfdata_file','/usr/local/nagios/var/host-perfdata'),(1577,2,13,'host_perfdata_file_template','DATATYPE::HOSTPERFDATA\\tTIMET::$TIMET$\\tHOSTNAME::$HOSTNAME$\\tHOSTPERFDATA::$HOSTPERFDATA$\\tHOSTCHECKCOMMAND::$HOSTCHECKCOMMAND$\\tHOSTSTATE::$HOSTSTATE$\\tHOSTSTATETYPE::$HOSTSTATETYPE$'),(1578,2,13,'host_perfdata_file_mode','w'),(1579,2,13,'host_perfdata_file_processing_interval','10'),(1580,2,13,'host_perfdata_file_processing_command','process-host-perfdata-file'),(1593,2,13,'obsess_over_services','0'),(1594,2,13,'obsess_over_hosts','0'),(1595,2,13,'translate_passive_host_checks','0'),(1596,2,13,'passive_host_checks_are_soft','0'),(1597,2,13,'check_for_orphaned_services','0'),(1598,2,13,'check_for_orphaned_hosts','0'),(1599,2,13,'check_service_freshness','1'),(1600,2,13,'service_freshness_check_interval','60'),(1601,2,13,'check_host_freshness','0'),(1602,2,13,'host_freshness_check_interval','60'),(1603,2,13,'additional_freshness_latency','15'),(1604,2,13,'enable_flap_detection','0'),(1605,2,13,'low_service_flap_threshold','5.0'),(1606,2,13,'high_service_flap_threshold','20.0'),(1607,2,13,'low_host_flap_threshold','5.0'),(1608,2,13,'high_host_flap_threshold','20.0'),(1609,2,13,'date_format','euro'),(1610,2,13,'p1_file','/usr/local/nagios3/bin/p1.pl'),(1611,2,13,'enable_embedded_perl','1'),(1612,2,13,'use_embedded_perl_implicitly','1'),(1613,2,13,'illegal_object_name_chars','`~!$%^&*|\'\"<>?,()='),(1614,2,13,'illegal_macro_output_chars','`~$&|\'\"<>'),(1615,2,13,'use_regexp_matching','1'),(1616,2,13,'use_true_regexp_matching','0'),(1617,2,13,'admin_email','md@mdmit.pl'),(1618,2,13,'admin_pager','md@mdmit.pl'),(1619,2,13,'daemon_dumps_core','0'),(1620,2,13,'use_large_installation_tweaks','0'),(1621,2,13,'enable_environment_macros','1'),(1622,2,13,'debug_level','0'),(1623,2,13,'debug_verbosity','0'),(1624,2,13,'debug_file','/usr/local/nagios3/var/nagios.debug'),(1625,2,13,'max_debug_file_size','100000000');
/*!40000 ALTER TABLE `nagios_configfilevariables` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nagios_conninfo`
--

DROP TABLE IF EXISTS `nagios_conninfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nagios_conninfo` (
  `conninfo_id` int(11) NOT NULL AUTO_INCREMENT,
  `instance_id` smallint(6) NOT NULL DEFAULT '0',
  `agent_name` varchar(32) NOT NULL DEFAULT '',
  `agent_version` varchar(8) NOT NULL DEFAULT '',
  `disposition` varchar(16) NOT NULL DEFAULT '',
  `connect_source` varchar(16) NOT NULL DEFAULT '',
  `connect_type` varchar(16) NOT NULL DEFAULT '',
  `connect_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `disconnect_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_checkin_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `data_start_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `data_end_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `bytes_processed` int(11) NOT NULL DEFAULT '0',
  `lines_processed` int(11) NOT NULL DEFAULT '0',
  `entries_processed` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`conninfo_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1283 DEFAULT CHARSET=latin1 COMMENT='NDO2DB daemon connection information';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nagios_conninfo`
--

LOCK TABLES `nagios_conninfo` WRITE;
/*!40000 ALTER TABLE `nagios_conninfo` DISABLE KEYS */;
INSERT INTO `nagios_conninfo` VALUES (1203,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2017-08-26 16:37:15','0000-00-00 00:00:00','2017-08-27 12:44:00','2017-08-26 16:37:14','0000-00-00 00:00:00',2143622932,94984255,3162253),(1204,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','RECONNECT','2017-08-27 12:44:59','2017-08-28 15:07:40','2017-08-28 15:07:40','2017-08-27 12:44:59','2017-08-28 15:07:37',2147483647,131648853,4384203),(1205,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2017-08-28 15:07:42','2017-08-30 17:26:55','2017-08-30 17:26:55','2017-08-28 15:07:41','2017-08-30 17:25:14',513555298,229381294,7634202),(1206,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2017-08-30 17:25:42','2017-09-01 12:09:03','2017-09-01 12:09:03','2017-08-30 17:25:42','2017-09-01 12:06:28',2147483647,184328041,6133984),(1207,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2017-09-01 12:06:36','2017-09-05 19:09:02','2017-09-05 19:09:02','2017-09-01 12:06:36','2017-09-05 19:04:35',2130063449,422913427,14075644),(1208,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2017-09-05 19:04:39','2017-09-05 22:45:05','2017-09-05 22:45:05','2017-09-05 19:04:39','2017-09-05 22:44:12',242675407,15539720,506079),(1209,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2017-09-05 22:44:16','2017-09-07 08:39:56','2017-09-07 08:39:56','2017-09-05 22:44:16','2017-09-07 08:39:03',2007764111,136780448,4548883),(1210,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2017-09-07 08:39:07','2017-09-15 10:10:05','2017-09-15 10:10:05','2017-09-07 08:39:07','2017-09-15 10:04:46',2147483647,766461854,25604867),(1211,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2017-09-15 10:04:50','2017-09-26 11:53:31','2017-09-26 11:53:31','2017-09-15 10:04:50','2017-09-26 11:51:12',2147483647,1130323289,37636605),(1212,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2017-09-26 11:51:15','2017-10-03 11:36:17','2017-10-03 11:36:17','2017-09-26 11:51:15','2017-10-03 11:30:03',971841647,700032930,23319624),(1213,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2017-10-03 11:30:08','2017-10-04 15:42:57','2017-10-04 15:42:57','2017-10-03 11:30:08','2017-10-04 15:42:35',1662589045,117640884,3909914),(1214,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2017-10-04 15:42:39','2017-10-05 10:42:26','2017-10-05 10:42:26','2017-10-04 15:42:39','2017-10-05 10:41:45',1119328569,79632849,2643175),(1215,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2017-10-05 10:41:47','2017-10-05 11:26:22','2017-10-05 11:26:22','2017-10-05 10:41:47','2017-10-05 11:25:17',41672224,3594323,108779),(1216,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2017-10-05 11:25:36','2017-10-10 12:47:17','2017-10-10 12:47:17','2017-10-05 11:25:36','2017-10-10 12:42:50',2147483647,506097542,16851056),(1217,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2017-10-10 12:42:55','2017-10-12 11:17:27','2017-10-12 11:17:27','2017-10-10 12:42:55','2017-10-12 11:17:05',2147483647,187137434,6226327),(1218,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2017-10-12 11:17:07','2017-10-12 11:24:45','2017-10-12 11:24:45','2017-10-12 11:17:07','1970-01-01 01:00:00',7111801,721511,14203),(1219,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2017-10-12 11:21:17','2017-10-12 11:39:00','2017-10-12 11:39:00','2017-10-12 11:21:17','2017-10-12 11:38:45',11051466,1077573,28365),(1220,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2017-10-12 11:24:55','2017-11-02 10:40:05','2017-11-02 10:40:05','2017-10-12 11:24:55','1970-01-01 01:00:00',2147483647,1233516582,41714993),(1221,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2017-10-17 16:05:02','2017-10-20 09:48:29','2017-10-20 09:48:29','2017-10-17 16:05:02','2017-10-20 09:47:25',1938643960,120297601,4032172),(1222,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2017-10-20 09:47:33','2017-10-20 15:31:05','2017-10-20 15:31:05','2017-10-20 09:47:32','2017-10-20 15:30:40',203493329,12236474,403150),(1223,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2017-10-20 15:30:45','2017-10-23 12:55:02','2017-10-23 12:55:02','2017-10-20 15:30:45','2017-10-23 12:54:56',2147483647,141018500,4738525),(1224,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2017-10-23 12:54:58','2017-10-25 20:34:44','2017-10-25 20:34:44','2017-10-23 12:54:58','2017-10-25 20:34:00',1832864595,109779311,3691921),(1225,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2017-10-25 20:34:07','2017-10-26 11:15:05','2017-10-26 11:15:05','2017-10-25 20:34:07','2017-10-26 11:14:04',462283595,28771828,961801),(1226,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2017-10-26 11:14:10','2017-10-26 14:15:03','2017-10-26 14:15:03','2017-10-26 11:14:10','2017-10-26 14:14:43',88308726,5644748,181765),(1227,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2017-10-26 14:14:47','2017-11-02 10:34:27','2017-11-02 10:34:27','2017-10-26 14:14:47','2017-11-02 10:32:35',976852767,326125810,10992741),(1228,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2017-11-02 10:33:28','2017-11-02 10:37:05','2017-11-02 10:37:05','2017-11-02 10:33:28','1970-01-01 01:00:00',727397,82392,1587),(1229,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2017-11-02 10:37:03','0000-00-00 00:00:00','2017-11-02 10:44:32','2017-11-02 10:37:03','0000-00-00 00:00:00',9016356,736136,14521),(1230,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2017-11-02 10:47:02','2017-11-07 13:11:36','2017-11-07 13:11:36','2017-11-02 10:47:02','2017-11-07 13:08:49',2147483647,661702320,22072596),(1231,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2017-11-07 13:13:02','2017-11-09 10:42:44','2017-11-09 10:42:44','2017-11-07 13:13:02','2017-11-09 10:39:22',91759934,215946179,7161836),(1232,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2017-11-09 10:39:23','2017-11-09 10:56:32','2017-11-09 10:56:32','2017-11-09 10:39:23','2017-11-09 10:55:35',20024325,1538222,43663),(1233,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2017-11-09 10:55:35','2017-11-14 15:17:17','2017-11-14 15:17:17','2017-11-09 10:55:35','2017-11-14 15:13:30',2147483647,593247343,19681442),(1234,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2017-11-14 15:13:35','2017-11-15 15:34:25','2017-11-15 15:34:25','2017-11-14 15:13:35','2017-11-15 15:30:23',2147483647,115386264,3823050),(1235,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2017-11-15 15:30:30','2017-11-21 10:31:16','2017-11-21 10:31:16','2017-11-15 15:30:30','2017-11-21 10:27:57',5672333,649197401,21542843),(1236,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2017-11-21 10:28:02','2017-11-23 15:22:46','2017-11-23 15:22:46','2017-11-21 10:28:02','2017-11-23 15:21:12',609727432,245452633,8141415),(1237,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2017-11-23 15:21:13','2017-11-23 18:22:47','2017-11-23 18:22:47','2017-11-23 15:21:13','2017-11-23 18:22:33',240109630,14289305,467456),(1238,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2017-11-23 18:22:35','2017-11-26 18:27:20','2017-11-26 18:27:20','2017-11-23 18:22:35','2017-11-26 18:23:16',1800646975,341204378,11335400),(1239,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2017-11-26 18:23:17','2017-11-27 11:58:19','2017-11-27 11:58:19','2017-11-26 18:23:17','2017-11-27 11:58:01',1465423518,81820902,2714534),(1240,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2017-11-27 11:58:02','2017-12-01 11:52:04','2017-12-01 11:52:04','2017-11-27 11:58:02','2017-12-01 11:47:49',2147483647,449183990,14930110),(1241,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2017-12-01 11:47:50','2017-12-01 15:41:29','2017-12-01 15:41:29','2017-12-01 11:47:50','2017-12-01 15:40:06',242051980,16717142,548412),(1242,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2017-12-01 15:40:07','2017-12-04 12:53:32','2017-12-04 12:53:32','2017-12-01 15:40:07','2017-12-04 12:50:02',1262178029,325931644,10831451),(1243,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2017-12-04 12:50:03','2017-12-05 08:52:06','2017-12-05 08:52:06','2017-12-04 12:50:03','2017-12-05 08:48:49',1599276264,92398666,3066746),(1244,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2017-12-05 08:48:49','2017-12-12 15:54:15','2017-12-12 15:54:15','2017-12-05 08:48:49','2017-12-12 15:51:39',1570694558,825559325,27446918),(1245,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2017-12-12 15:51:40','2017-12-14 17:54:15','2017-12-14 17:54:15','2017-12-12 15:51:40','2017-12-14 17:51:52',2147483647,233308769,7751809),(1246,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2017-12-14 17:51:53','2017-12-20 15:38:47','2017-12-20 15:38:47','2017-12-14 17:51:53','2017-12-20 15:33:04',2147483647,660810080,21971735),(1247,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2017-12-20 15:33:05','2017-12-21 18:33:19','2017-12-21 18:33:19','2017-12-20 15:33:05','2017-12-21 18:29:33',1794373088,118542841,3938652),(1248,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2017-12-21 18:29:34','2017-12-29 09:18:37','2017-12-29 09:18:37','2017-12-21 18:29:34','2017-12-29 09:15:25',2147483647,757315690,25178521),(1249,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2017-12-29 09:15:39','2017-12-31 23:15:11','2017-12-31 23:15:11','2017-12-29 09:15:39','2017-12-31 23:12:18',1656144917,313322760,10403541),(1250,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2017-12-31 23:12:20','2018-01-02 09:58:52','2018-01-02 09:58:52','2017-12-31 23:12:19','2018-01-02 09:56:19',2147483647,167338710,5558178),(1251,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2018-01-02 09:56:19','0000-00-00 00:00:00','2018-01-04 12:13:54','2018-01-02 09:56:19','0000-00-00 00:00:00',2147483647,241509118,8021918),(1252,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2018-01-04 12:16:11','2018-01-04 12:47:56','2018-01-04 12:47:56','2018-01-04 12:16:11','1970-01-01 01:00:00',10962038,1021048,22454),(1253,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2018-01-04 12:43:32','2018-01-04 13:24:20','2018-01-04 13:24:20','2018-01-04 12:43:32','1970-01-01 01:00:00',4948256,466185,8626),(1254,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2018-01-04 13:26:45','2018-01-07 20:57:40','2018-01-07 20:57:40','2018-01-04 13:26:45','2018-01-07 20:52:59',2147483647,195405041,6542104),(1255,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2018-01-07 20:53:01','2018-01-08 10:34:11','2018-01-08 10:34:11','2018-01-07 20:53:01','2018-01-08 10:30:26',706612281,56268780,1878869),(1256,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2018-01-08 10:30:28','2018-01-12 11:46:56','2018-01-12 11:46:56','2018-01-08 10:30:28','2018-01-12 11:42:53',1560817350,426688669,14247152),(1257,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2018-01-12 11:42:55','2018-01-17 15:37:15','2018-01-17 15:37:15','2018-01-12 11:42:55','2018-01-17 15:30:03',1772737039,401165183,13407039),(1258,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2018-01-17 15:30:05','2018-01-18 13:53:54','2018-01-18 13:53:54','2018-01-17 15:30:05','2018-01-18 13:51:16',1100405434,87310667,2912675),(1259,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2018-01-18 13:51:17','2018-02-02 14:19:04','2018-02-02 14:19:04','2018-01-18 13:51:17','2018-02-02 14:13:44',2147483647,1527986080,51084319),(1260,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2018-02-02 14:13:45','2018-02-04 13:13:40','2018-02-04 13:13:40','2018-02-02 14:13:44','2018-02-04 13:10:16',2147483647,201036993,6719085),(1261,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2018-02-04 13:10:19','2018-02-05 09:37:10','2018-02-05 09:37:10','2018-02-04 13:10:19','2018-02-05 09:31:14',1084905460,85382247,2850335),(1262,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2018-02-05 09:31:17','2018-02-10 07:11:43','2018-02-10 07:11:43','2018-02-05 09:31:17','2018-02-10 07:07:01',608651682,400407867,13394787),(1263,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2018-02-10 07:07:02','0000-00-00 00:00:00','2018-02-12 15:48:30','2018-02-10 07:07:02','0000-00-00 00:00:00',2147483647,250504443,8370244),(1264,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','RECONNECT','2018-02-13 09:51:41','2018-02-16 10:26:18','2018-02-16 10:26:18','2018-02-13 09:51:41','2018-02-16 10:22:23',440870734,318124321,10654748),(1265,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2018-02-16 10:22:26','2018-02-21 08:59:55','2018-02-21 08:59:55','2018-02-16 10:22:26','2018-02-21 08:56:23',2110378911,509758424,17045622),(1266,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2018-02-21 08:56:24','2018-02-21 11:48:22','2018-02-21 11:48:22','2018-02-21 08:56:24','2018-02-21 11:47:46',135500172,11752723,385524),(1267,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2018-02-21 11:47:48','2018-02-22 08:33:24','2018-02-22 08:33:24','2018-02-21 11:47:48','2018-02-22 08:28:54',1021090080,80900474,2701994),(1268,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2018-02-22 08:28:56','2018-03-08 13:58:38','2018-03-08 13:58:38','2018-02-22 08:28:56','2018-03-08 13:53:58',616538633,1417060961,47412219),(1269,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2018-03-08 13:53:59','2018-03-14 14:50:30','2018-03-14 14:50:30','2018-03-08 13:53:59','2018-03-14 14:50:30',2147483647,220854061,7976174),(1270,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2018-03-14 14:50:31','2018-03-22 09:37:48','2018-03-22 09:37:48','2018-03-14 14:50:31','2018-03-22 09:31:46',2147483647,964859882,32820286),(1271,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','RECONNECT','2018-05-04 11:06:35','0000-00-00 00:00:00','2018-05-04 11:06:41','2018-05-04 11:06:34','0000-00-00 00:00:00',312,22,0),(1272,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','RECONNECT','2018-05-05 15:14:14','2018-05-05 15:14:26','2018-05-05 15:14:26','2018-05-05 15:14:14','2018-05-05 15:14:23',454099,28883,866),(1273,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2018-05-05 15:14:25','2018-05-06 00:04:35','2018-05-06 00:04:35','2018-05-05 15:14:25','2018-05-06 00:01:35',950486767,47376561,1579651),(1274,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2018-05-06 00:01:39','2018-05-07 00:08:15','2018-05-07 00:08:15','2018-05-06 00:01:39','2018-05-07 00:01:38',2147483647,127197352,4245866),(1275,2,'NDOMOD','1.4b9','REALTIME','TCPSOCKET','INITIAL','2018-05-07 00:01:42','0000-00-00 00:00:00','2018-05-07 11:05:44','2018-05-07 00:01:42','0000-00-00 00:00:00',951041484,55935146,1861757),(1276,2,'NDOMOD','2.1.3','REALTIME','TCPSOCKET','RECONNECT','2024-12-27 13:10:15','0000-00-00 00:00:00','2024-12-27 13:30:08','2024-12-27 13:10:11','0000-00-00 00:00:00',1584356,177496,7721),(1277,2,'NDOMOD','2.1.3','REALTIME','TCPSOCKET','RECONNECT','2024-12-27 13:30:38','0000-00-00 00:00:00','2024-12-27 20:18:46','2024-12-27 13:30:34','0000-00-00 00:00:00',32066258,3598524,156782),(1278,2,'NDOMOD','2.1.3','REALTIME','TCPSOCKET','INITIAL','2024-12-27 20:19:37','0000-00-00 00:00:00','2024-12-29 19:27:58','2024-12-27 20:19:36','0000-00-00 00:00:00',211899697,24172360,1064612),(1279,2,'NDOMOD','2.1.3','REALTIME','TCPSOCKET','INITIAL','2024-12-29 19:28:57','0000-00-00 00:00:00','2024-12-29 19:50:20','2024-12-29 19:28:52','0000-00-00 00:00:00',1718948,195924,8549),(1280,2,'NDOMOD','2.1.3','REALTIME','TCPSOCKET','INITIAL','2024-12-29 19:51:17','0000-00-00 00:00:00','2024-12-30 16:25:11','2024-12-29 19:51:11','0000-00-00 00:00:00',125488146,9984593,447458),(1281,2,'NDOMOD','2.1.3','REALTIME','TCPSOCKET','INITIAL','2024-12-30 16:26:11','0000-00-00 00:00:00','2025-01-01 00:12:16','2024-12-30 16:26:06','0000-00-00 00:00:00',194986833,15499135,694076),(1282,2,'NDOMOD','2.1.3','REALTIME','TCPSOCKET','RECONNECT','2025-01-01 00:12:37','0000-00-00 00:00:00','2025-01-01 12:31:21','2025-01-01 00:12:36','0000-00-00 00:00:00',75455488,6099139,272118);
/*!40000 ALTER TABLE `nagios_conninfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nagios_contact_addresses`
--

DROP TABLE IF EXISTS `nagios_contact_addresses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nagios_contact_addresses` (
  `contact_address_id` int(11) NOT NULL AUTO_INCREMENT,
  `instance_id` smallint(6) NOT NULL DEFAULT '0',
  `contact_id` int(11) NOT NULL DEFAULT '0',
  `address_number` smallint(6) NOT NULL DEFAULT '0',
  `address` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`contact_address_id`),
  UNIQUE KEY `contact_id` (`contact_id`,`address_number`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COMMENT='Contact addresses';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nagios_contact_addresses`
--

LOCK TABLES `nagios_contact_addresses` WRITE;
/*!40000 ALTER TABLE `nagios_contact_addresses` DISABLE KEYS */;
/*!40000 ALTER TABLE `nagios_contact_addresses` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nagios_contact_notificationcommands`
--

DROP TABLE IF EXISTS `nagios_contact_notificationcommands`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nagios_contact_notificationcommands` (
  `contact_notificationcommand_id` int(11) NOT NULL AUTO_INCREMENT,
  `instance_id` smallint(6) NOT NULL DEFAULT '0',
  `contact_id` int(11) NOT NULL DEFAULT '0',
  `notification_type` smallint(6) NOT NULL DEFAULT '0',
  `command_object_id` int(11) NOT NULL DEFAULT '0',
  `command_args` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`contact_notificationcommand_id`),
  UNIQUE KEY `contact_id` (`contact_id`,`notification_type`,`command_object_id`,`command_args`)
) ENGINE=InnoDB AUTO_INCREMENT=1405 DEFAULT CHARSET=latin1 COMMENT='Contact host and service notification commands';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nagios_contact_notificationcommands`
--

LOCK TABLES `nagios_contact_notificationcommands` WRITE;
/*!40000 ALTER TABLE `nagios_contact_notificationcommands` DISABLE KEYS */;
INSERT INTO `nagios_contact_notificationcommands` VALUES (1297,2,109,0,27111,''),(1298,2,109,0,27112,''),(1299,2,109,0,27113,''),(1300,2,109,0,27114,''),(1301,2,109,0,27115,''),(1302,2,109,0,27116,''),(1303,2,109,1,27111,''),(1304,2,109,1,27112,''),(1305,2,109,1,27113,''),(1306,2,109,1,27114,''),(1307,2,109,1,27115,''),(1308,2,109,1,27116,''),(1309,2,110,0,27111,''),(1310,2,110,0,27112,''),(1311,2,110,0,27113,''),(1312,2,110,0,27114,''),(1313,2,110,0,27115,''),(1314,2,110,0,27116,''),(1315,2,110,1,27111,''),(1316,2,110,1,27112,''),(1317,2,110,1,27113,''),(1318,2,110,1,27114,''),(1319,2,110,1,27115,''),(1320,2,110,1,27116,''),(1321,2,111,0,27111,''),(1322,2,111,0,27112,''),(1323,2,111,0,27113,''),(1324,2,111,0,27114,''),(1325,2,111,0,27115,''),(1326,2,111,0,27116,''),(1327,2,111,1,27111,''),(1328,2,111,1,27112,''),(1329,2,111,1,27113,''),(1330,2,111,1,27114,''),(1331,2,111,1,27115,''),(1332,2,111,1,27116,''),(1333,2,112,0,27111,''),(1334,2,112,0,27112,''),(1335,2,112,0,27113,''),(1336,2,112,0,27114,''),(1337,2,112,0,27115,''),(1338,2,112,0,27116,''),(1339,2,112,1,27111,''),(1340,2,112,1,27112,''),(1341,2,112,1,27113,''),(1342,2,112,1,27114,''),(1343,2,112,1,27115,''),(1344,2,112,1,27116,''),(1345,2,113,0,27111,''),(1346,2,113,0,27112,''),(1347,2,113,0,27113,''),(1348,2,113,0,27114,''),(1349,2,113,0,27115,''),(1350,2,113,0,27116,''),(1351,2,113,1,27111,''),(1352,2,113,1,27112,''),(1353,2,113,1,27113,''),(1354,2,113,1,27114,''),(1355,2,113,1,27115,''),(1356,2,113,1,27116,''),(1357,2,114,0,27111,''),(1358,2,114,0,27112,''),(1359,2,114,0,27113,''),(1360,2,114,0,27114,''),(1361,2,114,0,27115,''),(1362,2,114,0,27116,''),(1363,2,114,1,27111,''),(1364,2,114,1,27112,''),(1365,2,114,1,27113,''),(1366,2,114,1,27114,''),(1367,2,114,1,27115,''),(1368,2,114,1,27116,''),(1369,2,115,0,27111,''),(1370,2,115,0,27112,''),(1371,2,115,0,27113,''),(1372,2,115,0,27114,''),(1373,2,115,0,27115,''),(1374,2,115,0,27116,''),(1375,2,115,1,27111,''),(1376,2,115,1,27112,''),(1377,2,115,1,27113,''),(1378,2,115,1,27114,''),(1379,2,115,1,27115,''),(1380,2,115,1,27116,''),(1381,2,116,0,27111,''),(1382,2,116,0,27112,''),(1383,2,116,0,27113,''),(1384,2,116,0,27114,''),(1385,2,116,0,27115,''),(1386,2,116,0,27116,''),(1387,2,116,1,27111,''),(1388,2,116,1,27112,''),(1389,2,116,1,27113,''),(1390,2,116,1,27114,''),(1391,2,116,1,27115,''),(1392,2,116,1,27116,''),(1393,2,117,0,27111,''),(1394,2,117,0,27112,''),(1395,2,117,0,27113,''),(1396,2,117,0,27114,''),(1397,2,117,0,27115,''),(1398,2,117,0,27116,''),(1399,2,117,1,27111,''),(1400,2,117,1,27112,''),(1401,2,117,1,27113,''),(1402,2,117,1,27114,''),(1403,2,117,1,27115,''),(1404,2,117,1,27116,'');
/*!40000 ALTER TABLE `nagios_contact_notificationcommands` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nagios_contactgroup_members`
--

DROP TABLE IF EXISTS `nagios_contactgroup_members`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nagios_contactgroup_members` (
  `contactgroup_member_id` int(11) NOT NULL AUTO_INCREMENT,
  `instance_id` smallint(6) NOT NULL DEFAULT '0',
  `contactgroup_id` int(11) NOT NULL DEFAULT '0',
  `contact_object_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`contactgroup_member_id`),
  UNIQUE KEY `instance_id` (`contactgroup_id`,`contact_object_id`)
) ENGINE=InnoDB AUTO_INCREMENT=105 DEFAULT CHARSET=latin1 COMMENT='Contactgroup members';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nagios_contactgroup_members`
--

LOCK TABLES `nagios_contactgroup_members` WRITE;
/*!40000 ALTER TABLE `nagios_contactgroup_members` DISABLE KEYS */;
INSERT INTO `nagios_contactgroup_members` VALUES (97,2,73,26982),(98,2,74,26982),(99,2,74,26981),(100,2,75,26982),(101,2,75,26980),(102,2,76,26982),(103,2,77,26982),(104,2,78,26982);
/*!40000 ALTER TABLE `nagios_contactgroup_members` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nagios_contactgroups`
--

DROP TABLE IF EXISTS `nagios_contactgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nagios_contactgroups` (
  `contactgroup_id` int(11) NOT NULL AUTO_INCREMENT,
  `instance_id` smallint(6) NOT NULL DEFAULT '0',
  `config_type` smallint(6) NOT NULL DEFAULT '0',
  `contactgroup_object_id` int(11) NOT NULL DEFAULT '0',
  `alias` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`contactgroup_id`),
  UNIQUE KEY `instance_id` (`instance_id`,`config_type`,`contactgroup_object_id`)
) ENGINE=InnoDB AUTO_INCREMENT=79 DEFAULT CHARSET=latin1 COMMENT='Contactgroup definitions';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nagios_contactgroups`
--

LOCK TABLES `nagios_contactgroups` WRITE;
/*!40000 ALTER TABLE `nagios_contactgroups` DISABLE KEYS */;
INSERT INTO `nagios_contactgroups` VALUES (73,2,1,27117,'Etherswitch Administrators'),(74,2,1,27118,'Linux Administrators2'),(75,2,1,27119,'ctm-admin'),(76,2,1,27120,'Linux Administrators'),(77,2,1,27121,'Linux Adm'),(78,2,1,27122,'Router Technicians');
/*!40000 ALTER TABLE `nagios_contactgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nagios_contactnotificationmethods`
--

DROP TABLE IF EXISTS `nagios_contactnotificationmethods`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nagios_contactnotificationmethods` (
  `contactnotificationmethod_id` int(11) NOT NULL AUTO_INCREMENT,
  `instance_id` smallint(6) NOT NULL DEFAULT '0',
  `contactnotification_id` int(11) NOT NULL DEFAULT '0',
  `start_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `start_time_usec` int(11) NOT NULL DEFAULT '0',
  `end_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `end_time_usec` int(11) NOT NULL DEFAULT '0',
  `command_object_id` int(11) NOT NULL DEFAULT '0',
  `command_args` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`contactnotificationmethod_id`),
  UNIQUE KEY `instance_id` (`instance_id`,`contactnotification_id`,`start_time`,`start_time_usec`)
) ENGINE=InnoDB AUTO_INCREMENT=47 DEFAULT CHARSET=latin1 COMMENT='Historical record of contact notification methods';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nagios_contactnotificationmethods`
--

LOCK TABLES `nagios_contactnotificationmethods` WRITE;
/*!40000 ALTER TABLE `nagios_contactnotificationmethods` DISABLE KEYS */;
/*!40000 ALTER TABLE `nagios_contactnotificationmethods` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nagios_contactnotifications`
--

DROP TABLE IF EXISTS `nagios_contactnotifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nagios_contactnotifications` (
  `contactnotification_id` int(11) NOT NULL AUTO_INCREMENT,
  `instance_id` smallint(6) NOT NULL DEFAULT '0',
  `notification_id` int(11) NOT NULL DEFAULT '0',
  `contact_object_id` int(11) NOT NULL DEFAULT '0',
  `start_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `start_time_usec` int(11) NOT NULL DEFAULT '0',
  `end_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `end_time_usec` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`contactnotification_id`),
  UNIQUE KEY `instance_id` (`instance_id`,`contact_object_id`,`start_time`,`start_time_usec`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=latin1 ROW_FORMAT=FIXED COMMENT='Historical record of contact notifications';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nagios_contactnotifications`
--

LOCK TABLES `nagios_contactnotifications` WRITE;
/*!40000 ALTER TABLE `nagios_contactnotifications` DISABLE KEYS */;
/*!40000 ALTER TABLE `nagios_contactnotifications` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nagios_contacts`
--

DROP TABLE IF EXISTS `nagios_contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nagios_contacts` (
  `contact_id` int(11) NOT NULL AUTO_INCREMENT,
  `instance_id` smallint(6) NOT NULL DEFAULT '0',
  `config_type` smallint(6) NOT NULL DEFAULT '0',
  `contact_object_id` int(11) NOT NULL DEFAULT '0',
  `alias` varchar(64) NOT NULL DEFAULT '',
  `email_address` varchar(255) NOT NULL DEFAULT '',
  `pager_address` varchar(64) NOT NULL DEFAULT '',
  `host_timeperiod_object_id` int(11) NOT NULL DEFAULT '0',
  `service_timeperiod_object_id` int(11) NOT NULL DEFAULT '0',
  `host_notifications_enabled` smallint(6) NOT NULL DEFAULT '0',
  `service_notifications_enabled` smallint(6) NOT NULL DEFAULT '0',
  `can_submit_commands` smallint(6) NOT NULL DEFAULT '0',
  `notify_service_recovery` smallint(6) NOT NULL DEFAULT '0',
  `notify_service_warning` smallint(6) NOT NULL DEFAULT '0',
  `notify_service_unknown` smallint(6) NOT NULL DEFAULT '0',
  `notify_service_critical` smallint(6) NOT NULL DEFAULT '0',
  `notify_service_flapping` smallint(6) NOT NULL DEFAULT '0',
  `notify_service_downtime` smallint(6) NOT NULL DEFAULT '0',
  `notify_host_recovery` smallint(6) NOT NULL DEFAULT '0',
  `notify_host_down` smallint(6) NOT NULL DEFAULT '0',
  `notify_host_unreachable` smallint(6) NOT NULL DEFAULT '0',
  `notify_host_flapping` smallint(6) NOT NULL DEFAULT '0',
  `notify_host_downtime` smallint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`contact_id`),
  UNIQUE KEY `instance_id` (`instance_id`,`config_type`,`contact_object_id`)
) ENGINE=InnoDB AUTO_INCREMENT=118 DEFAULT CHARSET=latin1 COMMENT='Contact definitions';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nagios_contacts`
--

LOCK TABLES `nagios_contacts` WRITE;
/*!40000 ALTER TABLE `nagios_contacts` DISABLE KEYS */;
INSERT INTO `nagios_contacts` VALUES (109,2,1,26980,'Admin ctm','support@adescom.pl','',21265,21265,1,1,1,1,1,1,1,0,0,1,1,1,0,0),(110,2,1,26981,'Jacek Brodka','jbrodka@tvkdiana.pl','509440428',21265,21265,1,1,1,1,1,1,1,0,0,1,1,1,0,0),(111,2,1,26982,'Admin Mariusz','mariuszd@tvkdiana.pl','509440418',21265,21265,1,1,1,1,1,1,1,0,0,1,1,1,0,0),(112,2,1,26983,'Admin Mariusz','mariuszd@tvkdiana.pl','509440418',21265,21265,1,1,1,1,1,1,1,0,0,1,1,1,0,0),(113,2,1,26984,'Marcin Drelich','mchelpa@tvkdiana.pl','504408281',21265,21265,1,1,1,1,1,1,1,0,0,1,1,1,0,0),(114,2,1,26985,'Nagios Admin','nagios@localhost.localdomain','509295176',21265,21265,1,1,1,1,1,1,1,0,0,1,1,1,0,0),(115,2,1,26986,'Robert Sudol','rsudol@tvkdiana.pl','509440419',27110,27110,1,1,1,1,1,1,1,0,0,1,1,1,0,0),(116,2,1,26987,'Serwis WiFi','serwiswifi@tvkdiana.pl','509440419',27110,27110,1,1,1,1,1,1,1,0,0,1,1,1,0,0),(117,2,1,26988,'Wiesiek Dybka','wd@tvkdiana.pl','509440416',27110,27110,1,1,1,1,1,1,1,0,0,1,1,1,0,0);
/*!40000 ALTER TABLE `nagios_contacts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nagios_contactstatus`
--

DROP TABLE IF EXISTS `nagios_contactstatus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nagios_contactstatus` (
  `contactstatus_id` int(11) NOT NULL AUTO_INCREMENT,
  `instance_id` smallint(6) NOT NULL DEFAULT '0',
  `contact_object_id` int(11) NOT NULL DEFAULT '0',
  `status_update_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `host_notifications_enabled` smallint(6) NOT NULL DEFAULT '0',
  `service_notifications_enabled` smallint(6) NOT NULL DEFAULT '0',
  `last_host_notification` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_service_notification` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_attributes` int(11) NOT NULL DEFAULT '0',
  `modified_host_attributes` int(11) NOT NULL DEFAULT '0',
  `modified_service_attributes` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`contactstatus_id`),
  UNIQUE KEY `contact_object_id` (`contact_object_id`)
) ENGINE=InnoDB AUTO_INCREMENT=118 DEFAULT CHARSET=latin1 ROW_FORMAT=FIXED COMMENT='Contact status';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nagios_contactstatus`
--

LOCK TABLES `nagios_contactstatus` WRITE;
/*!40000 ALTER TABLE `nagios_contactstatus` DISABLE KEYS */;
INSERT INTO `nagios_contactstatus` VALUES (109,2,26980,'2024-12-30 16:26:06',1,1,'1970-01-01 01:00:00','1970-01-01 01:00:00',0,0,0),(110,2,26981,'2024-12-30 16:26:06',1,1,'1970-01-01 01:00:00','1970-01-01 01:00:00',0,0,0),(111,2,26982,'2024-12-30 16:26:06',1,1,'2024-12-27 12:40:05','1970-01-01 01:00:00',0,0,0),(112,2,26983,'2024-12-30 16:26:06',1,1,'1970-01-01 01:00:00','1970-01-01 01:00:00',0,0,0),(113,2,26984,'2024-12-30 16:26:06',1,1,'1970-01-01 01:00:00','1970-01-01 01:00:00',0,0,0),(114,2,26985,'2024-12-30 16:26:06',1,1,'1970-01-01 01:00:00','1970-01-01 01:00:00',0,0,0),(115,2,26986,'2024-12-30 16:26:06',1,1,'1970-01-01 01:00:00','1970-01-01 01:00:00',0,0,0),(116,2,26987,'2024-12-30 16:26:06',1,1,'1970-01-01 01:00:00','1970-01-01 01:00:00',0,0,0),(117,2,26988,'2024-12-30 16:26:06',1,1,'1970-01-01 01:00:00','1970-01-01 01:00:00',0,0,0);
/*!40000 ALTER TABLE `nagios_contactstatus` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nagios_customvariables`
--

DROP TABLE IF EXISTS `nagios_customvariables`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nagios_customvariables` (
  `customvariable_id` int(11) NOT NULL AUTO_INCREMENT,
  `instance_id` smallint(6) NOT NULL DEFAULT '0',
  `object_id` int(11) NOT NULL DEFAULT '0',
  `config_type` smallint(6) NOT NULL DEFAULT '0',
  `has_been_modified` smallint(6) NOT NULL DEFAULT '0',
  `varname` varchar(255) NOT NULL DEFAULT '',
  `varvalue` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`customvariable_id`),
  UNIQUE KEY `object_id_2` (`object_id`,`config_type`,`varname`),
  KEY `varname` (`varname`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COMMENT='Custom variables';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nagios_customvariables`
--

LOCK TABLES `nagios_customvariables` WRITE;
/*!40000 ALTER TABLE `nagios_customvariables` DISABLE KEYS */;
/*!40000 ALTER TABLE `nagios_customvariables` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nagios_customvariablestatus`
--

DROP TABLE IF EXISTS `nagios_customvariablestatus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nagios_customvariablestatus` (
  `customvariablestatus_id` int(11) NOT NULL AUTO_INCREMENT,
  `instance_id` smallint(6) NOT NULL DEFAULT '0',
  `object_id` int(11) NOT NULL DEFAULT '0',
  `status_update_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `has_been_modified` smallint(6) NOT NULL DEFAULT '0',
  `varname` varchar(255) NOT NULL DEFAULT '',
  `varvalue` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`customvariablestatus_id`),
  UNIQUE KEY `object_id_2` (`object_id`,`varname`),
  KEY `varname` (`varname`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COMMENT='Custom variable status information';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nagios_customvariablestatus`
--

LOCK TABLES `nagios_customvariablestatus` WRITE;
/*!40000 ALTER TABLE `nagios_customvariablestatus` DISABLE KEYS */;
/*!40000 ALTER TABLE `nagios_customvariablestatus` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nagios_dbversion`
--

DROP TABLE IF EXISTS `nagios_dbversion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nagios_dbversion` (
  `name` varchar(10) NOT NULL DEFAULT '',
  `version` varchar(10) NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nagios_dbversion`
--

LOCK TABLES `nagios_dbversion` WRITE;
/*!40000 ALTER TABLE `nagios_dbversion` DISABLE KEYS */;
/*!40000 ALTER TABLE `nagios_dbversion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nagios_downtimehistory`
--

DROP TABLE IF EXISTS `nagios_downtimehistory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nagios_downtimehistory` (
  `downtimehistory_id` int(11) NOT NULL AUTO_INCREMENT,
  `instance_id` smallint(6) NOT NULL DEFAULT '0',
  `downtime_type` smallint(6) NOT NULL DEFAULT '0',
  `object_id` int(11) NOT NULL DEFAULT '0',
  `entry_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `author_name` varchar(64) NOT NULL DEFAULT '',
  `comment_data` varchar(255) NOT NULL DEFAULT '',
  `internal_downtime_id` int(11) NOT NULL DEFAULT '0',
  `triggered_by_id` int(11) NOT NULL DEFAULT '0',
  `is_fixed` smallint(6) NOT NULL DEFAULT '0',
  `duration` smallint(6) NOT NULL DEFAULT '0',
  `scheduled_start_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `scheduled_end_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `was_started` smallint(6) NOT NULL DEFAULT '0',
  `actual_start_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `actual_start_time_usec` int(11) NOT NULL DEFAULT '0',
  `actual_end_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `actual_end_time_usec` int(11) NOT NULL DEFAULT '0',
  `was_cancelled` smallint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`downtimehistory_id`),
  UNIQUE KEY `instance_id` (`instance_id`,`object_id`,`entry_time`,`internal_downtime_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COMMENT='Historical scheduled host and service downtime';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nagios_downtimehistory`
--

LOCK TABLES `nagios_downtimehistory` WRITE;
/*!40000 ALTER TABLE `nagios_downtimehistory` DISABLE KEYS */;
/*!40000 ALTER TABLE `nagios_downtimehistory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nagios_eventhandlers`
--

DROP TABLE IF EXISTS `nagios_eventhandlers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nagios_eventhandlers` (
  `eventhandler_id` int(11) NOT NULL AUTO_INCREMENT,
  `instance_id` smallint(6) NOT NULL DEFAULT '0',
  `eventhandler_type` smallint(6) NOT NULL DEFAULT '0',
  `object_id` int(11) NOT NULL DEFAULT '0',
  `state` smallint(6) NOT NULL DEFAULT '0',
  `state_type` smallint(6) NOT NULL DEFAULT '0',
  `start_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `start_time_usec` int(11) NOT NULL DEFAULT '0',
  `end_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `end_time_usec` int(11) NOT NULL DEFAULT '0',
  `command_object_id` int(11) NOT NULL DEFAULT '0',
  `command_args` varchar(255) NOT NULL DEFAULT '',
  `command_line` varchar(255) NOT NULL DEFAULT '',
  `timeout` smallint(6) NOT NULL DEFAULT '0',
  `early_timeout` smallint(6) NOT NULL DEFAULT '0',
  `execution_time` double NOT NULL DEFAULT '0',
  `return_code` smallint(6) NOT NULL DEFAULT '0',
  `output` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`eventhandler_id`),
  UNIQUE KEY `instance_id` (`instance_id`,`object_id`,`start_time`,`start_time_usec`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COMMENT='Historical host and service event handlers';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nagios_eventhandlers`
--

LOCK TABLES `nagios_eventhandlers` WRITE;
/*!40000 ALTER TABLE `nagios_eventhandlers` DISABLE KEYS */;
/*!40000 ALTER TABLE `nagios_eventhandlers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nagios_externalcommands`
--

DROP TABLE IF EXISTS `nagios_externalcommands`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nagios_externalcommands` (
  `externalcommand_id` int(11) NOT NULL AUTO_INCREMENT,
  `instance_id` smallint(6) NOT NULL DEFAULT '0',
  `entry_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `command_type` smallint(6) NOT NULL DEFAULT '0',
  `command_name` varchar(128) NOT NULL DEFAULT '',
  `command_args` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`externalcommand_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COMMENT='Historical record of processed external commands';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nagios_externalcommands`
--

LOCK TABLES `nagios_externalcommands` WRITE;
/*!40000 ALTER TABLE `nagios_externalcommands` DISABLE KEYS */;
/*!40000 ALTER TABLE `nagios_externalcommands` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nagios_flappinghistory`
--

DROP TABLE IF EXISTS `nagios_flappinghistory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nagios_flappinghistory` (
  `flappinghistory_id` int(11) NOT NULL AUTO_INCREMENT,
  `instance_id` smallint(6) NOT NULL DEFAULT '0',
  `event_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `event_time_usec` int(11) NOT NULL DEFAULT '0',
  `event_type` smallint(6) NOT NULL DEFAULT '0',
  `reason_type` smallint(6) NOT NULL DEFAULT '0',
  `flapping_type` smallint(6) NOT NULL DEFAULT '0',
  `object_id` int(11) NOT NULL DEFAULT '0',
  `percent_state_change` double NOT NULL DEFAULT '0',
  `low_threshold` double NOT NULL DEFAULT '0',
  `high_threshold` double NOT NULL DEFAULT '0',
  `comment_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `internal_comment_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`flappinghistory_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=FIXED COMMENT='Current and historical record of host and service flapping';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nagios_flappinghistory`
--

LOCK TABLES `nagios_flappinghistory` WRITE;
/*!40000 ALTER TABLE `nagios_flappinghistory` DISABLE KEYS */;
/*!40000 ALTER TABLE `nagios_flappinghistory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nagios_host_contactgroups`
--

DROP TABLE IF EXISTS `nagios_host_contactgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nagios_host_contactgroups` (
  `host_contactgroup_id` int(11) NOT NULL AUTO_INCREMENT,
  `instance_id` smallint(6) NOT NULL DEFAULT '0',
  `host_id` int(11) NOT NULL DEFAULT '0',
  `contactgroup_object_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`host_contactgroup_id`),
  UNIQUE KEY `instance_id` (`host_id`,`contactgroup_object_id`)
) ENGINE=InnoDB AUTO_INCREMENT=21079 DEFAULT CHARSET=latin1 ROW_FORMAT=FIXED COMMENT='Host contact groups';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nagios_host_contactgroups`
--

LOCK TABLES `nagios_host_contactgroups` WRITE;
/*!40000 ALTER TABLE `nagios_host_contactgroups` DISABLE KEYS */;
INSERT INTO `nagios_host_contactgroups` VALUES (21068,2,21068,27117),(21069,2,21069,27117),(21070,2,21070,27117),(21071,2,21071,27117),(21072,2,21072,27120),(21073,2,21073,27120),(21074,2,21074,27120),(21075,2,21075,27120),(21076,2,21076,27120),(21077,2,21077,27120),(21078,2,21078,27120);
/*!40000 ALTER TABLE `nagios_host_contactgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nagios_host_contacts`
--

DROP TABLE IF EXISTS `nagios_host_contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nagios_host_contacts` (
  `host_contact_id` int(11) NOT NULL AUTO_INCREMENT,
  `instance_id` smallint(6) NOT NULL DEFAULT '0',
  `host_id` int(11) NOT NULL DEFAULT '0',
  `contact_object_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`host_contact_id`),
  UNIQUE KEY `instance_id` (`instance_id`,`host_id`,`contact_object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=FIXED;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nagios_host_contacts`
--

LOCK TABLES `nagios_host_contacts` WRITE;
/*!40000 ALTER TABLE `nagios_host_contacts` DISABLE KEYS */;
/*!40000 ALTER TABLE `nagios_host_contacts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nagios_host_parenthosts`
--

DROP TABLE IF EXISTS `nagios_host_parenthosts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nagios_host_parenthosts` (
  `host_parenthost_id` int(11) NOT NULL AUTO_INCREMENT,
  `instance_id` smallint(6) NOT NULL DEFAULT '0',
  `host_id` int(11) NOT NULL DEFAULT '0',
  `parent_host_object_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`host_parenthost_id`),
  UNIQUE KEY `instance_id` (`host_id`,`parent_host_object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=FIXED COMMENT='Parent hosts';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nagios_host_parenthosts`
--

LOCK TABLES `nagios_host_parenthosts` WRITE;
/*!40000 ALTER TABLE `nagios_host_parenthosts` DISABLE KEYS */;
/*!40000 ALTER TABLE `nagios_host_parenthosts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nagios_hostchecks`
--

DROP TABLE IF EXISTS `nagios_hostchecks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nagios_hostchecks` (
  `hostcheck_id` int(11) NOT NULL AUTO_INCREMENT,
  `instance_id` smallint(6) NOT NULL DEFAULT '0',
  `host_object_id` int(11) NOT NULL DEFAULT '0',
  `check_type` smallint(6) NOT NULL DEFAULT '0',
  `is_raw_check` smallint(6) NOT NULL DEFAULT '0',
  `current_check_attempt` smallint(6) NOT NULL DEFAULT '0',
  `max_check_attempts` smallint(6) NOT NULL DEFAULT '0',
  `state` smallint(6) NOT NULL DEFAULT '0',
  `state_type` smallint(6) NOT NULL DEFAULT '0',
  `start_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `start_time_usec` int(11) NOT NULL DEFAULT '0',
  `end_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `end_time_usec` int(11) NOT NULL DEFAULT '0',
  `command_object_id` int(11) NOT NULL DEFAULT '0',
  `command_args` varchar(255) NOT NULL DEFAULT '',
  `command_line` varchar(255) NOT NULL DEFAULT '',
  `timeout` smallint(6) NOT NULL DEFAULT '0',
  `early_timeout` smallint(6) NOT NULL DEFAULT '0',
  `execution_time` double NOT NULL DEFAULT '0',
  `latency` double NOT NULL DEFAULT '0',
  `return_code` smallint(6) NOT NULL DEFAULT '0',
  `output` varchar(255) NOT NULL DEFAULT '',
  `perfdata` varchar(255) NOT NULL DEFAULT '',
  `long_output` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`hostcheck_id`),
  UNIQUE KEY `instance_id` (`instance_id`,`host_object_id`,`start_time`,`start_time_usec`)
) ENGINE=InnoDB AUTO_INCREMENT=276746617 DEFAULT CHARSET=latin1 COMMENT='Historical host checks';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nagios_hostchecks`
--

LOCK TABLES `nagios_hostchecks` WRITE;
/*!40000 ALTER TABLE `nagios_hostchecks` DISABLE KEYS */;
INSERT INTO `nagios_hostchecks` VALUES (276627439,2,21395,0,0,1,5,1,1,'2024-12-27 13:09:55',0,'2024-12-27 13:09:57',100863,26989,'','',30,0,2.008,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627440,2,23551,0,0,1,1,0,1,'2024-12-27 13:09:50',0,'2024-12-27 13:09:57',101191,26989,'','',30,0,0.00888,0.08,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627441,2,23553,0,0,1,10,1,1,'2024-12-27 13:09:57',101395,'2024-12-27 13:09:59',110234,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627442,2,28533,0,0,1,1,1,1,'2024-12-27 13:10:00',131961,'2024-12-27 13:10:02',141688,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627443,2,21397,0,0,1,5,1,1,'2024-12-27 13:09:59',115659,'2024-12-27 13:10:02',142051,26989,'','',30,0,0.99267,3.115,2,'CRITICAL - 172.20.3.10: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627444,2,23548,0,0,1,5,1,1,'2024-12-27 13:09:59',112576,'2024-12-27 13:10:02',142215,26989,'','',30,0,0.99592,3.112,2,'CRITICAL - 172.20.3.11: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627445,2,23552,0,0,1,1,0,1,'2024-12-27 13:10:02',144293,'2024-12-27 13:10:05',154179,26989,'','',30,0,0.01071,2.144,0,'OK - 192.168.77.8: rta 0.184ms, lost 0%','rta=0.184ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627446,2,23549,0,0,1,10,0,1,'2024-12-27 13:10:02',147221,'2024-12-27 13:10:05',154324,26989,'','',30,0,0.01092,2.147,0,'OK - 84.38.95.222: rta 0.219ms, lost 0%','rta=0.219ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627447,2,28279,0,0,1,1,0,1,'2024-12-27 13:10:05',156385,'2024-12-27 13:10:10',178634,26989,'','',30,0,0.00691,0.156,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627448,2,28533,0,0,1,1,1,1,'2024-12-27 13:10:07',166921,'2024-12-27 13:10:10',179171,26989,'','',30,0,2.00808,0.166,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627449,2,23551,0,0,1,1,0,1,'2024-12-27 13:10:10',179209,'2024-12-27 13:10:10',189724,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627450,2,23554,0,0,1,1,0,1,'2024-12-27 13:10:15',220065,'2024-12-27 13:10:20',250488,26989,'','',30,0,0.00986,0.22,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627451,2,21396,0,0,1,5,0,1,'2024-12-27 13:10:20',250530,'2024-12-27 13:10:20',273376,26989,'','',30,0,0.022,0,0,'OK - 192.168.77.159: rta 0.752ms, lost 0%','rta=0.752ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627452,2,23553,0,0,1,10,1,1,'2024-12-27 13:10:20',273655,'2024-12-27 13:10:22',282601,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627453,2,23553,0,0,1,10,1,1,'2024-12-27 13:10:27',320782,'2024-12-27 13:10:30',344057,26989,'','',30,0,2.00732,0.32,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627454,2,21396,0,0,1,5,0,1,'2024-12-27 13:10:35',375695,'2024-12-27 13:10:40',400530,26989,'','',30,0,0.02734,0.375,0,'OK - 192.168.77.159: rta 1.062ms, lost 0%','rta=1.062ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627455,2,23552,0,0,1,1,0,1,'2024-12-27 13:10:45',430474,'2024-12-27 13:10:45',441281,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.134ms, lost 0%','rta=0.134ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627456,2,21395,0,0,1,5,1,1,'2024-12-27 13:10:41',406973,'2024-12-27 13:10:45',441643,26989,'','',30,0,2.00755,0.406,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627457,2,23553,0,0,1,10,1,1,'2024-12-27 13:10:45',441692,'2024-12-27 13:10:47',449838,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627458,2,23549,0,0,1,10,0,1,'2024-12-27 13:10:50',477987,'2024-12-27 13:10:50',490258,26989,'','',30,0,0.012,0,0,'OK - 84.38.95.222: rta 0.230ms, lost 0%','rta=0.230ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627459,2,23554,0,0,1,1,0,1,'2024-12-27 13:10:55',527603,'2024-12-27 13:10:55',538143,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627460,2,23551,0,0,1,1,0,1,'2024-12-27 13:10:55',538372,'2024-12-27 13:10:55',548121,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627461,2,23551,0,0,1,1,0,1,'2024-12-27 13:10:57',559235,'2024-12-27 13:11:00',591994,26989,'','',30,0,0.01005,0.559,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627462,2,23548,0,0,1,5,1,1,'2024-12-27 13:11:02',602042,'2024-12-27 13:11:05',628887,26989,'','',30,0,2.00799,0.601,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627463,2,21397,0,0,1,5,1,1,'2024-12-27 13:11:02',601265,'2024-12-27 13:11:05',629059,26989,'','',30,0,2.00942,0.601,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627464,2,28533,0,0,1,1,1,1,'2024-12-27 13:11:05',629099,'2024-12-27 13:11:07',637606,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627465,2,23552,0,0,1,1,0,1,'2024-12-27 13:11:07',639898,'2024-12-27 13:11:10',666067,26989,'','',30,0,0.00874,2.639,0,'OK - 192.168.77.8: rta 0.138ms, lost 0%','rta=0.138ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627466,2,23549,0,0,1,10,0,1,'2024-12-27 13:11:07',642984,'2024-12-27 13:11:10',666244,26989,'','',30,0,0.01329,2.642,0,'OK - 84.38.95.222: rta 0.352ms, lost 0%','rta=0.352ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627467,2,28279,0,0,1,1,0,1,'2024-12-27 13:11:10',668600,'2024-12-27 13:11:15',703593,26989,'','',30,0,0.00757,0.668,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627468,2,28533,0,0,1,1,1,1,'2024-12-27 13:11:10',672532,'2024-12-27 13:11:15',703761,26989,'','',30,0,2.00782,0.672,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627469,2,23553,0,0,1,10,1,1,'2024-12-27 13:11:15',703981,'2024-12-27 13:11:17',713315,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627470,2,23554,0,0,1,1,0,1,'2024-12-27 13:11:20',736614,'2024-12-27 13:11:20',747270,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627471,2,23554,0,0,1,1,0,1,'2024-12-27 13:11:20',749750,'2024-12-27 13:11:25',779765,26989,'','',30,0,0.00881,0.749,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627472,2,23551,0,0,1,1,0,1,'2024-12-27 13:11:30',822790,'2024-12-27 13:11:30',833197,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627473,2,28279,0,0,1,1,0,1,'2024-12-27 13:11:35',868343,'2024-12-27 13:11:35',875957,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627474,2,23553,0,0,1,10,1,1,'2024-12-27 13:11:30',836680,'2024-12-27 13:11:35',876324,26989,'','',30,0,2.00792,0.836,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627475,2,23552,0,0,1,1,0,1,'2024-12-27 13:11:35',876377,'2024-12-27 13:11:35',885470,26989,'','',30,0,0.008,0,0,'OK - 192.168.77.8: rta 0.117ms, lost 0%','rta=0.117ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627476,2,21397,0,0,1,5,1,1,'2024-12-27 13:11:45',936774,'2024-12-27 13:11:47',945410,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627477,2,21396,0,0,1,5,0,1,'2024-12-27 13:11:40',916431,'2024-12-27 13:11:47',945739,26989,'','',30,0,0.04954,0.916,0,'OK - 192.168.77.159: rta 2.156ms, lost 0%','rta=2.156ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627478,2,23554,0,0,1,1,0,1,'2024-12-27 13:11:47',945782,'2024-12-27 13:11:47',955554,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627479,2,23553,0,0,1,10,1,1,'2024-12-27 13:11:47',955764,'2024-12-27 13:11:48',944626,26989,'','',30,0,0.989,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627480,2,21395,0,0,1,5,1,1,'2024-12-27 13:11:48',947067,'2024-12-27 13:11:55',991986,26989,'','',30,0,2.00934,3.947,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627481,2,28533,0,0,1,1,1,1,'2024-12-27 13:11:55',992058,'2024-12-27 13:11:57',51,26989,'','',30,0,1.072,0,1,'CRITICAL - 172.50.1.3: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627482,2,23551,0,0,1,1,0,1,'2024-12-27 13:12:00',7,'2024-12-27 13:12:00',0,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627483,2,23551,0,0,1,1,0,1,'2024-12-27 13:12:00',0,'2024-12-27 13:12:05',106560,26989,'','',30,0,0.0093,0.094,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627484,2,23553,0,0,1,10,1,1,'2024-12-27 13:12:05',106606,'2024-12-27 13:12:07',115799,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627485,2,23552,0,0,1,1,0,1,'2024-12-27 13:12:07',116042,'2024-12-27 13:12:07',126247,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.125ms, lost 0%','rta=0.125ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627486,2,23554,0,0,1,1,0,1,'2024-12-27 13:12:10',141582,'2024-12-27 13:12:10',151685,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627487,2,23548,0,0,1,5,1,1,'2024-12-27 13:12:07',128765,'2024-12-27 13:12:10',152045,26989,'','',30,0,0.98524,2.128,2,'CRITICAL - 172.20.3.11: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627488,2,21397,0,0,1,5,1,1,'2024-12-27 13:12:07',131808,'2024-12-27 13:12:10',152213,26989,'','',30,0,0.98273,2.131,2,'CRITICAL - 172.20.3.10: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627489,2,23552,0,0,1,1,0,1,'2024-12-27 13:12:10',154448,'2024-12-27 13:12:15',172798,26989,'','',30,0,0.0086,0.154,0,'OK - 192.168.77.8: rta 0.137ms, lost 0%','rta=0.137ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627490,2,23549,0,0,1,10,0,1,'2024-12-27 13:12:10',157423,'2024-12-27 13:12:15',172944,26989,'','',30,0,0.01158,0.157,0,'OK - 84.38.95.222: rta 0.212ms, lost 0%','rta=0.212ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627491,2,28279,0,0,1,1,0,1,'2024-12-27 13:12:15',179210,'2024-12-27 13:12:20',195918,26989,'','',30,0,0.01128,0.179,0,'OK - 192.168.77.9: rta 0.029ms, lost 0%','rta=0.029ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627492,2,28533,0,0,1,1,1,1,'2024-12-27 13:12:15',180131,'2024-12-27 13:12:20',196165,26989,'','',30,0,2.00882,0.18,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627493,2,21395,0,0,1,5,1,1,'2024-12-27 13:12:25',213644,'2024-12-27 13:12:27',223630,26989,'','',30,0,2.009,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627494,2,23552,0,0,1,1,0,1,'2024-12-27 13:12:27',223847,'2024-12-27 13:12:27',243974,26989,'','',30,0,0.019,0,0,'OK - 192.168.77.8: rta 0.131ms, lost 0%','rta=0.131ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627495,2,23551,0,0,1,1,0,1,'2024-12-27 13:12:27',244272,'2024-12-27 13:12:27',254386,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627496,2,23554,0,0,1,1,0,1,'2024-12-27 13:12:27',257009,'2024-12-27 13:12:30',273945,26989,'','',30,0,0.01289,2.256,0,'OK - 192.168.77.208: rta 0.292ms, lost 0%','rta=0.292ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627497,2,23548,0,0,1,5,1,1,'2024-12-27 13:12:30',274244,'2024-12-27 13:12:32',283611,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627498,2,28533,0,0,1,1,1,1,'2024-12-27 13:12:35',319501,'2024-12-27 13:12:37',329558,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627499,2,23553,0,0,1,10,1,1,'2024-12-27 13:12:40',358278,'2024-12-27 13:12:42',367610,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627500,2,23553,0,0,1,10,1,1,'2024-12-27 13:12:37',347144,'2024-12-27 13:12:42',368283,26989,'','',30,0,0.0739,2.347,2,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627501,2,23554,0,0,1,1,0,1,'2024-12-27 13:12:45',402533,'2024-12-27 13:12:45',414325,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.208: rta 0.168ms, lost 0%','rta=0.168ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627502,2,23552,0,0,1,1,0,1,'2024-12-27 13:12:45',414584,'2024-12-27 13:12:45',424163,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.119ms, lost 0%','rta=0.119ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627503,2,21396,0,0,1,5,0,1,'2024-12-27 13:12:47',428658,'2024-12-27 13:12:50',453324,26989,'','',30,0,0.03503,0.428,0,'OK - 192.168.77.159: rta 0.925ms, lost 0%','rta=0.925ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627504,2,21395,0,0,1,5,1,1,'2024-12-27 13:12:50',453939,'2024-12-27 13:12:51',444880,26989,'','',30,0,0.991,0,1,'CRITICAL - 192.168.77.154: Host unreachable @ 192.168.77.9. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627505,2,23553,0,0,1,10,1,1,'2024-12-27 13:12:55',459033,'2024-12-27 13:12:57',469448,26989,'','',30,0,2.01,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627506,2,21395,0,0,1,5,1,1,'2024-12-27 13:12:57',491372,'2024-12-27 13:13:00',509325,26989,'','',30,0,2.00749,2.491,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627507,2,23551,0,0,1,1,0,1,'2024-12-27 13:13:00',509378,'2024-12-27 13:13:00',520694,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627508,2,28533,0,0,1,1,1,1,'2024-12-27 13:13:00',520964,'2024-12-27 13:13:02',528395,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627509,2,23551,0,0,1,1,0,1,'2024-12-27 13:13:05',555820,'2024-12-27 13:13:10',579988,26989,'','',30,0,0.00955,0.555,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627510,2,28279,0,0,1,1,0,1,'2024-12-27 13:13:10',580349,'2024-12-27 13:13:10',588605,26989,'','',30,0,0.008,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627511,2,23548,0,0,1,5,1,1,'2024-12-27 13:13:10',591449,'2024-12-27 13:13:15',609011,26989,'','',30,0,2.00653,0.591,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627512,2,21397,0,0,1,5,1,1,'2024-12-27 13:13:10',594460,'2024-12-27 13:13:15',609260,26989,'','',30,0,2.00779,0.594,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627513,2,23552,0,0,1,1,0,1,'2024-12-27 13:13:15',609333,'2024-12-27 13:13:15',619411,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.119ms, lost 0%','rta=0.119ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627514,2,23552,0,0,1,1,0,1,'2024-12-27 13:13:15',621993,'2024-12-27 13:13:20',641634,26989,'','',30,0,0.00919,0.621,0,'OK - 192.168.77.8: rta 0.142ms, lost 0%','rta=0.142ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627515,2,23549,0,0,1,10,0,1,'2024-12-27 13:13:15',622568,'2024-12-27 13:13:20',641843,26989,'','',30,0,0.01298,0.622,0,'OK - 84.38.95.222: rta 0.200ms, lost 0%','rta=0.200ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627516,2,21396,0,0,1,5,0,1,'2024-12-27 13:13:20',641897,'2024-12-27 13:13:20',664837,26989,'','',30,0,0.022,0,0,'OK - 192.168.77.159: rta 0.787ms, lost 0%','rta=0.787ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627517,2,23553,0,0,1,10,1,1,'2024-12-27 13:13:20',665145,'2024-12-27 13:13:22',674598,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627518,2,23554,0,0,1,1,0,1,'2024-12-27 13:13:25',707057,'2024-12-27 13:13:25',717559,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627519,2,28279,0,0,1,1,0,1,'2024-12-27 13:13:22',697205,'2024-12-27 13:13:25',718018,26989,'','',30,0,0.00643,2.697,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627520,2,28533,0,0,1,1,1,1,'2024-12-27 13:13:22',700302,'2024-12-27 13:13:25',718242,26989,'','',30,0,2.00747,2.7,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627521,2,23554,0,0,1,1,0,1,'2024-12-27 13:13:30',729613,'2024-12-27 13:13:35',758620,26989,'','',30,0,0.00898,0.729,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627522,2,23552,0,0,1,1,0,1,'2024-12-27 13:13:45',795616,'2024-12-27 13:13:45',805710,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.129ms, lost 0%','rta=0.129ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627523,2,23553,0,0,1,10,1,1,'2024-12-27 13:13:45',806014,'2024-12-27 13:13:47',814325,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627524,2,23553,0,0,1,10,1,1,'2024-12-27 13:13:42',777555,'2024-12-27 13:13:47',814702,26989,'','',30,0,1.67967,0.777,2,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627525,2,23549,0,0,1,10,0,1,'2024-12-27 13:13:50',853191,'2024-12-27 13:13:50',865116,26989,'','',30,0,0.011,0,0,'OK - 84.38.95.222: rta 0.210ms, lost 0%','rta=0.210ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627526,2,21396,0,0,1,5,0,1,'2024-12-27 13:13:50',867565,'2024-12-27 13:13:55',902445,26989,'','',30,0,0.02104,0.867,0,'OK - 192.168.77.159: rta 0.745ms, lost 0%','rta=0.745ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627527,2,23554,0,0,1,1,0,1,'2024-12-27 13:13:55',902494,'2024-12-27 13:13:55',913093,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627528,2,23551,0,0,1,1,0,1,'2024-12-27 13:13:55',913376,'2024-12-27 13:13:55',923139,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627529,2,21395,0,0,1,5,1,1,'2024-12-27 13:14:00',946596,'2024-12-27 13:14:05',974823,26989,'','',30,0,2.0073,0.946,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627530,2,28533,0,0,1,1,1,1,'2024-12-27 13:14:05',975141,'2024-12-27 13:14:07',984317,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627531,2,23552,0,0,1,1,0,1,'2024-12-27 13:14:10',8251,'2024-12-27 13:14:10',12684,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.130ms, lost 0%','rta=0.130ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627532,2,23551,0,0,1,1,0,1,'2024-12-27 13:14:10',219,'2024-12-27 13:14:15',4,26989,'','',30,0,0.00956,0.033,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627533,2,21397,0,0,1,5,1,1,'2024-12-27 13:14:15',4,'2024-12-27 13:14:17',5,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627534,2,23553,0,0,1,10,1,1,'2024-12-27 13:14:20',0,'2024-12-27 13:14:22',0,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627535,2,21397,0,0,1,5,1,1,'2024-12-27 13:14:17',3343,'2024-12-27 13:14:22',0,26989,'','',30,0,0.99245,2.064,2,'CRITICAL - 172.20.3.10: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627536,2,23548,0,0,1,5,1,1,'2024-12-27 13:14:17',48,'2024-12-27 13:14:22',0,26989,'','',30,0,0.99587,2.06,2,'CRITICAL - 172.20.3.11: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627537,2,23554,0,0,1,1,0,1,'2024-12-27 13:14:22',0,'2024-12-27 13:14:22',107073,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627538,2,23549,0,0,1,10,0,1,'2024-12-27 13:14:22',107381,'2024-12-27 13:14:22',118112,26989,'','',30,0,0.01,0,0,'OK - 84.38.95.222: rta 0.199ms, lost 0%','rta=0.199ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627539,2,23552,0,0,1,1,0,1,'2024-12-27 13:14:22',120649,'2024-12-27 13:14:25',138244,26989,'','',30,0,0.01067,2.12,0,'OK - 192.168.77.8: rta 0.240ms, lost 0%','rta=0.240ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627540,2,23549,0,0,1,10,0,1,'2024-12-27 13:14:22',123616,'2024-12-27 13:14:25',138460,26989,'','',30,0,0.01035,2.123,0,'OK - 84.38.95.222: rta 0.205ms, lost 0%','rta=0.205ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627541,2,28533,0,0,1,1,1,1,'2024-12-27 13:14:25',138740,'2024-12-27 13:14:27',146993,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627542,2,28279,0,0,1,1,0,1,'2024-12-27 13:14:27',149358,'2024-12-27 13:14:30',170256,26989,'','',30,0,0.00624,2.149,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627543,2,28533,0,0,1,1,1,1,'2024-12-27 13:14:27',152402,'2024-12-27 13:14:30',170738,26989,'','',30,0,0.99271,2.152,2,'CRITICAL - 172.50.1.3: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627544,2,23551,0,0,1,1,0,1,'2024-12-27 13:14:30',170796,'2024-12-27 13:14:30',181585,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627545,2,23554,0,0,1,1,0,1,'2024-12-27 13:14:35',203253,'2024-12-27 13:14:40',214810,26989,'','',30,0,0.00934,0.203,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627546,2,21397,0,0,1,5,1,1,'2024-12-27 13:14:45',230212,'2024-12-27 13:14:47',240619,26989,'','',30,0,2.01,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627547,2,23553,0,0,1,10,1,1,'2024-12-27 13:14:47',241080,'2024-12-27 13:14:48',238823,26989,'','',30,0,0.998,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627548,2,23553,0,0,1,10,1,1,'2024-12-27 13:14:48',265499,'2024-12-27 13:14:50',280451,26989,'','',30,0,2.00826,1.265,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627549,2,28533,0,0,1,1,1,1,'2024-12-27 13:14:55',294331,'2024-12-27 13:14:56',380707,26989,'','',30,0,1.085,0,1,'CRITICAL - 172.50.1.3: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627550,2,21396,0,0,1,5,0,1,'2024-12-27 13:14:56',383282,'2024-12-27 13:15:00',409239,26989,'','',30,0,0.02713,1.383,0,'OK - 192.168.77.159: rta 1.063ms, lost 0%','rta=1.063ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627551,2,23551,0,0,1,1,0,1,'2024-12-27 13:15:00',409832,'2024-12-27 13:15:00',420306,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627552,2,23553,0,0,1,10,1,1,'2024-12-27 13:15:05',433007,'2024-12-27 13:15:07',442169,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627553,2,23552,0,0,1,1,0,1,'2024-12-27 13:15:07',442389,'2024-12-27 13:15:07',451830,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.121ms, lost 0%','rta=0.121ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627554,2,23554,0,0,1,1,0,1,'2024-12-27 13:15:10',464676,'2024-12-27 13:15:10',476078,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627555,2,23548,0,0,1,5,1,1,'2024-12-27 13:15:10',476381,'2024-12-27 13:15:12',484433,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627556,2,21395,0,0,1,5,1,1,'2024-12-27 13:15:07',454469,'2024-12-27 13:15:12',484817,26989,'','',30,0,2.00712,2.454,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627557,2,23551,0,0,1,1,0,1,'2024-12-27 13:15:15',504894,'2024-12-27 13:15:20',517870,26989,'','',30,0,0.00958,0.504,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627558,2,21395,0,0,1,5,1,1,'2024-12-27 13:15:25',547141,'2024-12-27 13:15:27',556518,26989,'','',30,0,2.009,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627559,2,23552,0,0,1,1,0,1,'2024-12-27 13:15:27',556766,'2024-12-27 13:15:27',566175,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.127ms, lost 0%','rta=0.127ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627560,2,21397,0,0,1,5,1,1,'2024-12-27 13:15:22',534662,'2024-12-27 13:15:27',566890,26989,'','',30,0,2.00899,0.534,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627561,2,23548,0,0,1,5,1,1,'2024-12-27 13:15:22',538472,'2024-12-27 13:15:27',567114,26989,'','',30,0,2.00816,0.538,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627562,2,28533,0,0,1,1,1,1,'2024-12-27 13:15:30',591130,'2024-12-27 13:15:32',601564,26989,'','',30,0,2.01,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627563,2,23552,0,0,1,1,0,1,'2024-12-27 13:15:27',569318,'2024-12-27 13:15:32',601965,26989,'','',30,0,0.00955,2.569,0,'OK - 192.168.77.8: rta 0.174ms, lost 0%','rta=0.174ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627564,2,23549,0,0,1,10,0,1,'2024-12-27 13:15:27',572340,'2024-12-27 13:15:32',602158,26989,'','',30,0,0.01492,2.572,0,'OK - 84.38.95.222: rta 0.413ms, lost 0%','rta=0.413ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627565,2,28279,0,0,1,1,0,1,'2024-12-27 13:15:32',605088,'2024-12-27 13:15:35',629602,26989,'','',30,0,0.00672,2.605,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627566,2,28533,0,0,1,1,1,1,'2024-12-27 13:15:32',608580,'2024-12-27 13:15:35',629860,26989,'','',30,0,0.99017,2.608,2,'CRITICAL - 172.50.1.3: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627567,2,23553,0,0,1,10,1,1,'2024-12-27 13:15:40',645005,'2024-12-27 13:15:42',654891,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627568,2,23551,0,0,1,1,0,1,'2024-12-27 13:15:42',655128,'2024-12-27 13:15:42',665312,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627569,2,23554,0,0,1,1,0,1,'2024-12-27 13:15:42',667763,'2024-12-27 13:15:45',681293,26989,'','',30,0,0.00881,2.667,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627570,2,23552,0,0,1,1,0,1,'2024-12-27 13:15:45',682102,'2024-12-27 13:15:45',692893,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.139ms, lost 0%','rta=0.139ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627571,2,21395,0,0,1,5,1,1,'2024-12-27 13:15:50',731262,'2024-12-27 13:15:51',719159,26989,'','',30,0,0.988,0,1,'CRITICAL - 192.168.77.154: Host unreachable @ 192.168.77.9. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627572,2,23553,0,0,1,10,1,1,'2024-12-27 13:15:51',721560,'2024-12-27 13:15:55',734282,26989,'','',30,0,0.06848,1.721,2,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627573,2,23554,0,0,1,1,0,1,'2024-12-27 13:16:00',754624,'2024-12-27 13:16:00',766147,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627574,2,23551,0,0,1,1,0,1,'2024-12-27 13:16:00',766426,'2024-12-27 13:16:00',777646,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627575,2,28533,0,0,1,1,1,1,'2024-12-27 13:16:00',777936,'2024-12-27 13:16:02',786490,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627576,2,21396,0,0,1,5,0,1,'2024-12-27 13:16:02',789033,'2024-12-27 13:16:05',798872,26989,'','',30,0,0.02519,2.789,0,'OK - 192.168.77.159: rta 0.937ms, lost 0%','rta=0.937ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627577,2,28279,0,0,1,1,0,1,'2024-12-27 13:16:10',816198,'2024-12-27 13:16:10',824252,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627578,2,23552,0,0,1,1,0,1,'2024-12-27 13:16:15',840481,'2024-12-27 13:16:15',851763,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.8: rta 0.134ms, lost 0%','rta=0.134ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627579,2,21395,0,0,1,5,1,1,'2024-12-27 13:16:12',831797,'2024-12-27 13:16:15',852275,26989,'','',30,0,2.00858,0.831,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627580,2,21396,0,0,1,5,0,1,'2024-12-27 13:16:20',867253,'2024-12-27 13:16:20',889397,26989,'','',30,0,0.021,0,0,'OK - 192.168.77.159: rta 0.744ms, lost 0%','rta=0.744ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627581,2,23553,0,0,1,10,1,1,'2024-12-27 13:16:20',889701,'2024-12-27 13:16:22',897163,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627582,2,23554,0,0,1,1,0,1,'2024-12-27 13:16:25',906994,'2024-12-27 13:16:25',916995,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627583,2,23551,0,0,1,1,0,1,'2024-12-27 13:16:22',899785,'2024-12-27 13:16:25',917451,26989,'','',30,0,0.00909,2.899,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627584,2,21397,0,0,1,5,1,1,'2024-12-27 13:16:27',923056,'2024-12-27 13:16:30',935329,26989,'','',30,0,2.0075,0.923,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627585,2,23548,0,0,1,5,1,1,'2024-12-27 13:16:27',926104,'2024-12-27 13:16:30',935558,26989,'','',30,0,2.00846,0.926,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627586,2,23552,0,0,1,1,0,1,'2024-12-27 13:16:32',942193,'2024-12-27 13:16:35',952946,26989,'','',30,0,0.01046,0.942,0,'OK - 192.168.77.8: rta 0.131ms, lost 0%','rta=0.131ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627587,2,23549,0,0,1,10,0,1,'2024-12-27 13:16:32',943159,'2024-12-27 13:16:35',953161,26989,'','',30,0,0.0126,0.943,0,'OK - 84.38.95.222: rta 0.244ms, lost 0%','rta=0.244ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627588,2,28279,0,0,1,1,0,1,'2024-12-27 13:16:35',955592,'2024-12-27 13:16:40',975839,26989,'','',30,0,0.00676,0.955,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627589,2,28533,0,0,1,1,1,1,'2024-12-27 13:16:35',959002,'2024-12-27 13:16:40',976072,26989,'','',30,0,2.00837,0.958,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627590,2,23553,0,0,1,10,1,1,'2024-12-27 13:16:46',15,'2024-12-27 13:16:48',11788,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627591,2,23554,0,0,1,1,0,1,'2024-12-27 13:16:48',2,'2024-12-27 13:16:50',321,26989,'','',30,0,0.00934,3.029,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627592,2,23549,0,0,1,10,0,1,'2024-12-27 13:16:50',20811,'2024-12-27 13:16:50',3279,26989,'','',30,0,0.012,0,0,'OK - 84.38.95.222: rta 0.248ms, lost 0%','rta=0.248ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627593,2,23551,0,0,1,1,0,1,'2024-12-27 13:16:55',0,'2024-12-27 13:16:55',101102,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627594,2,23553,0,0,1,10,1,1,'2024-12-27 13:16:55',103659,'2024-12-27 13:17:00',142042,26989,'','',30,0,2.00767,0.103,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627595,2,28533,0,0,1,1,1,1,'2024-12-27 13:17:05',173949,'2024-12-27 13:17:07',184271,26989,'','',30,0,2.01,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627596,2,21396,0,0,1,5,0,1,'2024-12-27 13:17:07',186653,'2024-12-27 13:17:10',196833,26989,'','',30,0,0.02163,2.186,0,'OK - 192.168.77.159: rta 0.779ms, lost 0%','rta=0.779ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627597,2,23552,0,0,1,1,0,1,'2024-12-27 13:17:10',196897,'2024-12-27 13:17:10',207281,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.112ms, lost 0%','rta=0.112ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627598,2,21397,0,0,1,5,1,1,'2024-12-27 13:17:15',220407,'2024-12-27 13:17:17',229710,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627599,2,23553,0,0,1,10,1,1,'2024-12-27 13:17:17',229939,'2024-12-27 13:17:18',228849,26989,'','',30,0,0.999,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627600,2,23554,0,0,1,1,0,1,'2024-12-27 13:17:20',253012,'2024-12-27 13:17:20',264630,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627601,2,23549,0,0,1,10,0,1,'2024-12-27 13:17:20',264928,'2024-12-27 13:17:20',276403,26989,'','',30,0,0.011,0,0,'OK - 84.38.95.222: rta 0.230ms, lost 0%','rta=0.230ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627602,2,21395,0,0,1,5,1,1,'2024-12-27 13:17:18',231221,'2024-12-27 13:17:20',276835,26989,'','',30,0,2.00793,3.231,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627603,2,28533,0,0,1,1,1,1,'2024-12-27 13:17:25',293481,'2024-12-27 13:17:27',302346,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627604,2,23551,0,0,1,1,0,1,'2024-12-27 13:17:27',304763,'2024-12-27 13:17:30',324705,26989,'','',30,0,0.0094,2.304,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627605,2,28279,0,0,1,1,0,1,'2024-12-27 13:17:35',346340,'2024-12-27 13:17:35',355064,26989,'','',30,0,0.008,0,0,'OK - 192.168.77.9: rta 0.016ms, lost 0%','rta=0.016ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627606,2,21397,0,0,1,5,1,1,'2024-12-27 13:17:30',329141,'2024-12-27 13:17:35',355630,26989,'','',30,0,2.00989,0.329,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627607,2,23548,0,0,1,5,1,1,'2024-12-27 13:17:30',330775,'2024-12-27 13:17:35',355899,26989,'','',30,0,2.00971,0.33,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627608,2,23552,0,0,1,1,0,1,'2024-12-27 13:17:35',356002,'2024-12-27 13:17:35',366496,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.129ms, lost 0%','rta=0.129ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627609,2,23552,0,0,1,1,0,1,'2024-12-27 13:17:35',371078,'2024-12-27 13:17:40',382658,26989,'','',30,0,0.01146,0.371,0,'OK - 192.168.77.8: rta 0.168ms, lost 0%','rta=0.168ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627610,2,23549,0,0,1,10,0,1,'2024-12-27 13:17:35',372121,'2024-12-27 13:17:40',382883,26989,'','',30,0,0.01257,0.372,0,'OK - 84.38.95.222: rta 0.201ms, lost 0%','rta=0.201ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627611,2,28279,0,0,1,1,0,1,'2024-12-27 13:17:40',389093,'2024-12-27 13:17:45',407842,26989,'','',30,0,0.00655,0.389,0,'OK - 192.168.77.9: rta 0.017ms, lost 0%','rta=0.017ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627612,2,23554,0,0,1,1,0,1,'2024-12-27 13:17:45',408196,'2024-12-27 13:17:45',418624,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627613,2,28533,0,0,1,1,1,1,'2024-12-27 13:17:40',392128,'2024-12-27 13:17:45',419126,26989,'','',30,0,2.00839,0.392,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627614,2,23553,0,0,1,10,1,1,'2024-12-27 13:17:45',419201,'2024-12-27 13:17:47',426814,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627615,2,23554,0,0,1,1,0,1,'2024-12-27 13:17:50',445507,'2024-12-27 13:17:55',479464,26989,'','',30,0,0.01004,0.445,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627616,2,28533,0,0,1,1,1,1,'2024-12-27 13:18:00',498745,'2024-12-27 13:18:02',506874,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627617,2,23551,0,0,1,1,0,1,'2024-12-27 13:18:02',507101,'2024-12-27 13:18:02',517144,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.157ms, lost 0%','rta=0.157ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627618,2,23552,0,0,1,1,0,1,'2024-12-27 13:18:05',530275,'2024-12-27 13:18:05',540210,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.126ms, lost 0%','rta=0.126ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627619,2,23553,0,0,1,10,1,1,'2024-12-27 13:18:05',540530,'2024-12-27 13:18:07',549006,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627620,2,23553,0,0,1,10,1,1,'2024-12-27 13:18:02',522469,'2024-12-27 13:18:07',549387,26989,'','',30,0,2.00881,2.522,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627621,2,23554,0,0,1,1,0,1,'2024-12-27 13:18:10',563960,'2024-12-27 13:18:10',574112,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627622,2,23548,0,0,1,5,1,1,'2024-12-27 13:18:10',574409,'2024-12-27 13:18:12',583039,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627623,2,21396,0,0,1,5,0,1,'2024-12-27 13:18:12',585350,'2024-12-27 13:18:15',596191,26989,'','',30,0,0.02507,2.585,0,'OK - 192.168.77.159: rta 0.952ms, lost 0%','rta=0.952ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627624,2,21395,0,0,1,5,1,1,'2024-12-27 13:18:25',645095,'2024-12-27 13:18:27',655046,26989,'','',30,0,2.009,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627625,2,23552,0,0,1,1,0,1,'2024-12-27 13:18:27',655371,'2024-12-27 13:18:27',664990,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.117ms, lost 0%','rta=0.117ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627626,2,23551,0,0,1,1,0,1,'2024-12-27 13:18:27',665314,'2024-12-27 13:18:27',675212,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627627,2,21395,0,0,1,5,1,1,'2024-12-27 13:18:20',634446,'2024-12-27 13:18:27',675736,26989,'','',30,0,2.00961,0.634,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627628,2,28533,0,0,1,1,1,1,'2024-12-27 13:18:30',696092,'2024-12-27 13:18:32',706467,26989,'','',30,0,2.01,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627629,2,23548,0,0,1,5,1,1,'2024-12-27 13:18:32',706974,'2024-12-27 13:18:34',737168,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627630,2,23551,0,0,1,1,0,1,'2024-12-27 13:18:34',739978,'2024-12-27 13:18:35',761602,26989,'','',30,0,0.00979,4.739,0,'OK - 192.168.77.29: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627631,2,21397,0,0,1,5,1,1,'2024-12-27 13:18:35',764260,'2024-12-27 13:18:40',787171,26989,'','',30,0,2.00848,0.764,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627632,2,23548,0,0,1,5,1,1,'2024-12-27 13:18:35',768291,'2024-12-27 13:18:40',787417,26989,'','',30,0,2.00788,0.768,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627633,2,23553,0,0,1,10,1,1,'2024-12-27 13:18:40',787487,'2024-12-27 13:18:42',797661,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627634,2,23552,0,0,1,1,0,1,'2024-12-27 13:18:42',800456,'2024-12-27 13:18:45',816205,26989,'','',30,0,0.00874,2.8,0,'OK - 192.168.77.8: rta 0.136ms, lost 0%','rta=0.136ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627635,2,23549,0,0,1,10,0,1,'2024-12-27 13:18:42',803610,'2024-12-27 13:18:45',816408,26989,'','',30,0,0.01158,2.803,0,'OK - 84.38.95.222: rta 0.210ms, lost 0%','rta=0.210ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627636,2,23554,0,0,1,1,0,1,'2024-12-27 13:18:45',816702,'2024-12-27 13:18:45',827203,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627637,2,28279,0,0,1,1,0,1,'2024-12-27 13:18:45',830046,'2024-12-27 13:18:50',863674,26989,'','',30,0,0.00656,0.83,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627638,2,28533,0,0,1,1,1,1,'2024-12-27 13:18:45',833155,'2024-12-27 13:18:50',863882,26989,'','',30,0,2.00811,0.833,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627639,2,21395,0,0,1,5,1,1,'2024-12-27 13:18:50',864359,'2024-12-27 13:18:51',853266,26989,'','',30,0,0.989,0,1,'CRITICAL - 192.168.77.154: Host unreachable @ 192.168.77.9. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627640,2,23554,0,0,1,1,0,1,'2024-12-27 13:18:55',868422,'2024-12-27 13:19:00',912199,26989,'','',30,0,0.00969,0.868,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627641,2,23552,0,0,1,1,0,1,'2024-12-27 13:19:00',912285,'2024-12-27 13:19:00',923321,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.132ms, lost 0%','rta=0.132ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627642,2,23551,0,0,1,1,0,1,'2024-12-27 13:19:00',923819,'2024-12-27 13:19:00',933697,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627643,2,28279,0,0,1,1,0,1,'2024-12-27 13:19:10',967356,'2024-12-27 13:19:10',975137,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627644,2,23553,0,0,1,10,1,1,'2024-12-27 13:19:07',956844,'2024-12-27 13:19:10',975658,26989,'','',30,0,2.00839,0.956,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627645,2,21396,0,0,1,5,0,1,'2024-12-27 13:19:15',989634,'2024-12-27 13:19:20',3365,26989,'','',30,0,0.04151,0.989,0,'OK - 192.168.77.159: rta 1.743ms, lost 0%','rta=1.743ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627646,2,23553,0,0,1,10,1,1,'2024-12-27 13:19:25',17327,'2024-12-27 13:19:27',20540,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627647,2,23554,0,0,1,1,0,1,'2024-12-27 13:19:27',322,'2024-12-27 13:19:27',3091,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627648,2,21395,0,0,1,5,1,1,'2024-12-27 13:19:27',26059,'2024-12-27 13:19:30',0,26989,'','',30,0,2.00758,0.062,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627649,2,23551,0,0,1,1,0,1,'2024-12-27 13:19:35',125491,'2024-12-27 13:19:40',150342,26989,'','',30,0,0.00911,0.125,0,'OK - 192.168.77.29: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627650,2,23548,0,0,1,5,1,1,'2024-12-27 13:19:40',155371,'2024-12-27 13:19:45',193914,26989,'','',30,0,0.64317,0.155,2,'CRITICAL - 172.20.3.11: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627651,2,21397,0,0,1,5,1,1,'2024-12-27 13:19:40',152592,'2024-12-27 13:19:45',194158,26989,'','',30,0,0.64601,0.152,2,'CRITICAL - 172.20.3.10: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627652,2,23552,0,0,1,1,0,1,'2024-12-27 13:19:45',194230,'2024-12-27 13:19:45',204983,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.169ms, lost 0%','rta=0.169ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627653,2,23553,0,0,1,10,1,1,'2024-12-27 13:19:45',205334,'2024-12-27 13:19:47',213651,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627654,2,23552,0,0,1,1,0,1,'2024-12-27 13:19:47',216133,'2024-12-27 13:19:50',253238,26989,'','',30,0,0.00947,2.216,0,'OK - 192.168.77.8: rta 0.138ms, lost 0%','rta=0.138ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627655,2,23549,0,0,1,10,0,1,'2024-12-27 13:19:47',217884,'2024-12-27 13:19:50',253486,26989,'','',30,0,0.01078,2.217,0,'OK - 84.38.95.222: rta 0.209ms, lost 0%','rta=0.209ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627656,2,28279,0,0,1,1,0,1,'2024-12-27 13:19:50',256343,'2024-12-27 13:19:55',283254,26989,'','',30,0,0.00758,0.256,0,'OK - 192.168.77.9: rta 0.016ms, lost 0%','rta=0.016ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627657,2,23554,0,0,1,1,0,1,'2024-12-27 13:19:55',283319,'2024-12-27 13:19:55',294191,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627658,2,28533,0,0,1,1,1,1,'2024-12-27 13:19:50',258877,'2024-12-27 13:19:55',294628,26989,'','',30,0,2.00825,0.258,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627659,2,23551,0,0,1,1,0,1,'2024-12-27 13:19:55',294689,'2024-12-27 13:19:55',304586,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627660,2,23554,0,0,1,1,0,1,'2024-12-27 13:20:00',367772,'2024-12-27 13:20:05',400218,26989,'','',30,0,0.00969,0.367,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627661,2,23552,0,0,1,1,0,1,'2024-12-27 13:20:10',434421,'2024-12-27 13:20:10',444951,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.141ms, lost 0%','rta=0.141ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627662,2,23553,0,0,1,10,1,1,'2024-12-27 13:20:10',447381,'2024-12-27 13:20:15',482543,26989,'','',30,0,2.0081,0.447,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627663,2,21397,0,0,1,5,1,1,'2024-12-27 13:20:15',482589,'2024-12-27 13:20:17',491821,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627664,2,23554,0,0,1,1,0,1,'2024-12-27 13:20:20',530994,'2024-12-27 13:20:20',542095,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627665,2,23549,0,0,1,10,0,1,'2024-12-27 13:20:20',542393,'2024-12-27 13:20:20',553367,26989,'','',30,0,0.01,0,0,'OK - 84.38.95.222: rta 0.203ms, lost 0%','rta=0.203ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627666,2,21396,0,0,1,5,0,1,'2024-12-27 13:20:20',555755,'2024-12-27 13:20:25',596831,26989,'','',30,0,0.02729,0.555,0,'OK - 192.168.77.159: rta 1.068ms, lost 0%','rta=1.068ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627667,2,28533,0,0,1,1,1,1,'2024-12-27 13:20:25',597166,'2024-12-27 13:20:27',607436,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627668,2,23551,0,0,1,1,0,1,'2024-12-27 13:20:30',649282,'2024-12-27 13:20:30',660461,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627669,2,28279,0,0,1,1,0,1,'2024-12-27 13:20:35',696484,'2024-12-27 13:20:35',704585,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627670,2,21395,0,0,1,5,1,1,'2024-12-27 13:20:30',666098,'2024-12-27 13:20:35',705021,26989,'','',30,0,2.00878,0.666,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627671,2,23552,0,0,1,1,0,1,'2024-12-27 13:20:35',705089,'2024-12-27 13:20:35',714800,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.142ms, lost 0%','rta=0.142ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627672,2,23551,0,0,1,1,0,1,'2024-12-27 13:20:40',751754,'2024-12-27 13:20:45',781436,26989,'','',30,0,0.01057,0.751,0,'OK - 192.168.77.29: rta 0.156ms, lost 0%','rta=0.156ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627673,2,21397,0,0,1,5,1,1,'2024-12-27 13:20:45',781495,'2024-12-27 13:20:47',790677,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627674,2,23554,0,0,1,1,0,1,'2024-12-27 13:20:47',790915,'2024-12-27 13:20:47',800902,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.148ms, lost 0%','rta=0.148ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627675,2,23553,0,0,1,10,1,1,'2024-12-27 13:20:47',801184,'2024-12-27 13:20:48',789947,26989,'','',30,0,0.989,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627676,2,23548,0,0,1,5,1,1,'2024-12-27 13:20:48',792580,'2024-12-27 13:20:50',831173,26989,'','',30,0,2.00867,3.792,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627677,2,21397,0,0,1,5,1,1,'2024-12-27 13:20:48',795548,'2024-12-27 13:20:55',863792,26989,'','',30,0,2.00866,3.795,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627678,2,23552,0,0,1,1,0,1,'2024-12-27 13:20:50',835247,'2024-12-27 13:20:55',864034,26989,'','',30,0,0.01169,0.835,0,'OK - 192.168.77.8: rta 0.172ms, lost 0%','rta=0.172ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627679,2,23549,0,0,1,10,0,1,'2024-12-27 13:20:50',838143,'2024-12-27 13:20:55',864266,26989,'','',30,0,0.01057,0.838,0,'OK - 84.38.95.222: rta 0.199ms, lost 0%','rta=0.199ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627680,2,28533,0,0,1,1,1,1,'2024-12-27 13:20:55',864333,'2024-12-27 13:20:56',912360,26989,'','',30,0,1.047,0,1,'CRITICAL - 172.50.1.3: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627681,2,28279,0,0,1,1,0,1,'2024-12-27 13:20:56',914859,'2024-12-27 13:21:00',964469,26989,'','',30,0,0.00617,1.914,0,'OK - 192.168.77.9: rta 0.014ms, lost 0%','rta=0.014ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627682,2,23551,0,0,1,1,0,1,'2024-12-27 13:21:00',965060,'2024-12-27 13:21:00',975937,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627683,2,28533,0,0,1,1,1,1,'2024-12-27 13:20:56',917954,'2024-12-27 13:21:00',976423,26989,'','',30,0,2.00861,1.917,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627684,2,23552,0,0,1,1,0,1,'2024-12-27 13:21:06',0,'2024-12-27 13:21:06',1,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.131ms, lost 0%','rta=0.131ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627685,2,23553,0,0,1,10,1,1,'2024-12-27 13:21:06',1,'2024-12-27 13:21:08',2,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627686,2,23554,0,0,1,1,0,1,'2024-12-27 13:21:08',1587,'2024-12-27 13:21:10',3,26989,'','',30,0,0.00947,3.03,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627687,2,23548,0,0,1,5,1,1,'2024-12-27 13:21:10',3,'2024-12-27 13:21:12',4,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627688,2,23553,0,0,1,10,1,1,'2024-12-27 13:21:15',0,'2024-12-27 13:21:20',101755,26989,'','',30,0,2.00936,0.088,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627689,2,21395,0,0,1,5,1,1,'2024-12-27 13:21:25',122537,'2024-12-27 13:21:27',132661,26989,'','',30,0,2.009,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627690,2,23552,0,0,1,1,0,1,'2024-12-27 13:21:27',132981,'2024-12-27 13:21:27',150981,26989,'','',30,0,0.017,0,0,'OK - 192.168.77.8: rta 0.126ms, lost 0%','rta=0.126ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627691,2,23551,0,0,1,1,0,1,'2024-12-27 13:21:27',151271,'2024-12-27 13:21:27',161245,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627692,2,28533,0,0,1,1,1,1,'2024-12-27 13:21:30',184462,'2024-12-27 13:21:32',194280,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627693,2,21396,0,0,1,5,0,1,'2024-12-27 13:21:27',163756,'2024-12-27 13:21:32',194694,26989,'','',30,0,0.02619,2.163,0,'OK - 192.168.77.159: rta 1.007ms, lost 0%','rta=1.007ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627694,2,23548,0,0,1,5,1,1,'2024-12-27 13:21:32',195023,'2024-12-27 13:21:34',217924,26989,'','',30,0,2.022,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627695,2,21395,0,0,1,5,1,1,'2024-12-27 13:21:35',238317,'2024-12-27 13:21:40',255217,26989,'','',30,0,2.00847,0.238,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627696,2,23553,0,0,1,10,1,1,'2024-12-27 13:21:40',255273,'2024-12-27 13:21:42',264107,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627697,2,23554,0,0,1,1,0,1,'2024-12-27 13:21:45',295821,'2024-12-27 13:21:45',307478,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627698,2,23552,0,0,1,1,0,1,'2024-12-27 13:21:45',307812,'2024-12-27 13:21:45',317016,26989,'','',30,0,0.008,0,0,'OK - 192.168.77.8: rta 0.115ms, lost 0%','rta=0.115ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627699,2,23551,0,0,1,1,0,1,'2024-12-27 13:21:45',319872,'2024-12-27 13:21:50',346615,26989,'','',30,0,0.0089,0.319,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627700,2,23548,0,0,1,5,1,1,'2024-12-27 13:21:50',349607,'2024-12-27 13:21:55',364743,26989,'','',30,0,1.05692,0.349,2,'CRITICAL - 172.20.3.11: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627701,2,23552,0,0,1,1,0,1,'2024-12-27 13:21:55',371068,'2024-12-27 13:22:00',391596,26989,'','',30,0,0.00974,0.371,0,'OK - 192.168.77.8: rta 0.163ms, lost 0%','rta=0.163ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627702,2,23549,0,0,1,10,0,1,'2024-12-27 13:21:55',374180,'2024-12-27 13:22:00',391834,26989,'','',30,0,0.01058,0.374,0,'OK - 84.38.95.222: rta 0.210ms, lost 0%','rta=0.210ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627703,2,21397,0,0,1,5,1,1,'2024-12-27 13:21:55',367384,'2024-12-27 13:22:00',392356,26989,'','',30,0,2.00756,0.367,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627704,2,28533,0,0,1,1,1,1,'2024-12-27 13:22:00',392877,'2024-12-27 13:22:02',402496,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627705,2,28279,0,0,1,1,0,1,'2024-12-27 13:22:02',426845,'2024-12-27 13:22:05',440822,26989,'','',30,0,0.00662,2.426,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627706,2,28533,0,0,1,1,1,1,'2024-12-27 13:22:02',429978,'2024-12-27 13:22:05',441032,26989,'','',30,0,0.97071,2.429,2,'CRITICAL - 172.50.1.3: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627707,2,23551,0,0,1,1,0,1,'2024-12-27 13:22:10',458422,'2024-12-27 13:22:10',469054,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627708,2,23554,0,0,1,1,0,1,'2024-12-27 13:22:10',471521,'2024-12-27 13:22:15',485810,26989,'','',30,0,0.00874,0.471,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627709,2,23552,0,0,1,1,0,1,'2024-12-27 13:22:15',485862,'2024-12-27 13:22:15',496162,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.125ms, lost 0%','rta=0.125ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627710,2,21396,0,0,1,5,0,1,'2024-12-27 13:22:20',514553,'2024-12-27 13:22:20',535947,26989,'','',30,0,0.021,0,0,'OK - 192.168.77.159: rta 0.710ms, lost 0%','rta=0.710ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627711,2,23553,0,0,1,10,1,1,'2024-12-27 13:22:20',536243,'2024-12-27 13:22:22',544974,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627712,2,23553,0,0,1,10,1,1,'2024-12-27 13:22:22',563677,'2024-12-27 13:22:25',571713,26989,'','',30,0,0.9785,2.563,2,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627713,2,21396,0,0,1,5,0,1,'2024-12-27 13:22:32',596730,'2024-12-27 13:22:35',607766,26989,'','',30,0,0.0299,0.596,0,'OK - 192.168.77.159: rta 1.172ms, lost 0%','rta=1.172ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627714,2,21395,0,0,1,5,1,1,'2024-12-27 13:22:40',621916,'2024-12-27 13:22:45',637909,26989,'','',30,0,2.00802,0.621,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627715,2,23552,0,0,1,1,0,1,'2024-12-27 13:22:45',637973,'2024-12-27 13:22:45',648000,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.120ms, lost 0%','rta=0.120ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627716,2,23553,0,0,1,10,1,1,'2024-12-27 13:22:45',648358,'2024-12-27 13:22:47',656968,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627717,2,23549,0,0,1,10,0,1,'2024-12-27 13:22:50',685105,'2024-12-27 13:22:50',696694,26989,'','',30,0,0.011,0,0,'OK - 84.38.95.222: rta 0.201ms, lost 0%','rta=0.201ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627718,2,23551,0,0,1,1,0,1,'2024-12-27 13:22:50',699193,'2024-12-27 13:22:55',718918,26989,'','',30,0,0.00869,0.699,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627719,2,23554,0,0,1,1,0,1,'2024-12-27 13:22:55',718985,'2024-12-27 13:22:55',729595,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627720,2,23548,0,0,1,5,1,1,'2024-12-27 13:22:55',732285,'2024-12-27 13:23:00',763034,26989,'','',30,0,2.00655,0.732,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627721,2,23552,0,0,1,1,0,1,'2024-12-27 13:23:00',766101,'2024-12-27 13:23:05',805363,26989,'','',30,0,0.00903,0.766,0,'OK - 192.168.77.8: rta 0.109ms, lost 0%','rta=0.109ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627722,2,23549,0,0,1,10,0,1,'2024-12-27 13:23:00',767381,'2024-12-27 13:23:05',805563,26989,'','',30,0,0.01336,0.767,0,'OK - 84.38.95.222: rta 0.199ms, lost 0%','rta=0.199ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627723,2,21397,0,0,1,5,1,1,'2024-12-27 13:23:00',770397,'2024-12-27 13:23:05',805774,26989,'','',30,0,2.00812,0.77,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627724,2,28533,0,0,1,1,1,1,'2024-12-27 13:23:05',806044,'2024-12-27 13:23:07',815529,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627725,2,28279,0,0,1,1,0,1,'2024-12-27 13:23:07',833411,'2024-12-27 13:23:10',846230,26989,'','',30,0,0.00683,2.833,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627726,2,28533,0,0,1,1,1,1,'2024-12-27 13:23:07',835135,'2024-12-27 13:23:10',846698,26989,'','',30,0,0.97843,2.835,2,'CRITICAL - 172.50.1.3: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627727,2,23553,0,0,1,10,1,1,'2024-12-27 13:23:15',874790,'2024-12-27 13:23:17',884257,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627728,2,23554,0,0,1,1,0,1,'2024-12-27 13:23:17',905860,'2024-12-27 13:23:20',919072,26989,'','',30,0,0.00903,2.905,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627729,2,23549,0,0,1,10,0,1,'2024-12-27 13:23:20',919362,'2024-12-27 13:23:20',931499,26989,'','',30,0,0.011,0,0,'OK - 84.38.95.222: rta 0.232ms, lost 0%','rta=0.232ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627730,2,28533,0,0,1,1,1,1,'2024-12-27 13:23:25',946322,'2024-12-27 13:23:27',971026,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627731,2,23551,0,0,1,1,0,1,'2024-12-27 13:23:30',988627,'2024-12-27 13:23:30',999872,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627732,2,23553,0,0,1,10,1,1,'2024-12-27 13:23:27',973715,'2024-12-27 13:23:31',31,26989,'','',30,0,2.00754,2.973,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627733,2,28279,0,0,1,1,0,1,'2024-12-27 13:23:35',796,'2024-12-27 13:23:35',9780,26989,'','',30,0,0.008,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627734,2,23552,0,0,1,1,0,1,'2024-12-27 13:23:35',155,'2024-12-27 13:23:35',13825,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.134ms, lost 0%','rta=0.134ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627735,2,21396,0,0,1,5,0,1,'2024-12-27 13:23:35',3,'2024-12-27 13:23:40',4,26989,'','',30,0,0.02729,0.038,0,'OK - 192.168.77.159: rta 1.049ms, lost 0%','rta=1.049ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627736,2,21397,0,0,1,5,1,1,'2024-12-27 13:23:45',27943,'2024-12-27 13:23:47',31635,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627737,2,23554,0,0,1,1,0,1,'2024-12-27 13:23:47',61,'2024-12-27 13:23:47',0,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.148ms, lost 0%','rta=0.148ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627738,2,23553,0,0,1,10,1,1,'2024-12-27 13:23:47',0,'2024-12-27 13:23:48',486,26989,'','',30,0,0.988,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627739,2,21395,0,0,1,5,1,1,'2024-12-27 13:23:48',0,'2024-12-27 13:23:50',111424,26989,'','',30,0,2.00672,3.095,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627740,2,28533,0,0,1,1,1,1,'2024-12-27 13:23:55',127039,'2024-12-27 13:23:56',211519,26989,'','',30,0,1.083,0,1,'CRITICAL - 172.50.1.3: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627741,2,23551,0,0,1,1,0,1,'2024-12-27 13:23:56',214112,'2024-12-27 13:24:00',233549,26989,'','',30,0,0.009,1.214,0,'OK - 192.168.77.29: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627742,2,23548,0,0,1,5,1,1,'2024-12-27 13:24:00',236860,'2024-12-27 13:24:05',246399,26989,'','',30,0,2.00846,0.236,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627743,2,23552,0,0,1,1,0,1,'2024-12-27 13:24:05',246477,'2024-12-27 13:24:05',257132,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.165ms, lost 0%','rta=0.165ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627744,2,23553,0,0,1,10,1,1,'2024-12-27 13:24:05',257464,'2024-12-27 13:24:07',266124,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627745,2,23552,0,0,1,1,0,1,'2024-12-27 13:24:07',268875,'2024-12-27 13:24:10',287717,26989,'','',30,0,0.01171,2.268,0,'OK - 192.168.77.8: rta 0.291ms, lost 0%','rta=0.291ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627746,2,23549,0,0,1,10,0,1,'2024-12-27 13:24:07',271877,'2024-12-27 13:24:10',287930,26989,'','',30,0,0.0103,2.271,0,'OK - 84.38.95.222: rta 0.207ms, lost 0%','rta=0.207ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627747,2,21397,0,0,1,5,1,1,'2024-12-27 13:24:07',275198,'2024-12-27 13:24:10',288157,26989,'','',30,0,0.98916,2.275,2,'CRITICAL - 172.20.3.10: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627748,2,23554,0,0,1,1,0,1,'2024-12-27 13:24:10',288229,'2024-12-27 13:24:10',299113,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627749,2,28279,0,0,1,1,0,1,'2024-12-27 13:24:10',301993,'2024-12-27 13:24:15',317345,26989,'','',30,0,0.00683,0.301,0,'OK - 192.168.77.9: rta 0.016ms, lost 0%','rta=0.016ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627750,2,28533,0,0,1,1,1,1,'2024-12-27 13:24:10',305541,'2024-12-27 13:24:15',317566,26989,'','',30,0,2.00741,0.305,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627751,2,23554,0,0,1,1,0,1,'2024-12-27 13:24:20',341930,'2024-12-27 13:24:25',357732,26989,'','',30,0,0.00951,0.341,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627752,2,21395,0,0,1,5,1,1,'2024-12-27 13:24:25',357789,'2024-12-27 13:24:27',367943,26989,'','',30,0,2.009,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627753,2,23552,0,0,1,1,0,1,'2024-12-27 13:24:27',368170,'2024-12-27 13:24:27',378003,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.132ms, lost 0%','rta=0.132ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627754,2,23551,0,0,1,1,0,1,'2024-12-27 13:24:27',378264,'2024-12-27 13:24:27',388131,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627755,2,28533,0,0,1,1,1,1,'2024-12-27 13:24:30',406772,'2024-12-27 13:24:32',416102,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627756,2,23548,0,0,1,5,1,1,'2024-12-27 13:24:32',416734,'2024-12-27 13:24:34',426346,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627757,2,23553,0,0,1,10,1,1,'2024-12-27 13:24:34',429222,'2024-12-27 13:24:35',450342,26989,'','',30,0,0.99513,3.429,2,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627758,2,21396,0,0,1,5,0,1,'2024-12-27 13:24:40',466051,'2024-12-27 13:24:45',482830,26989,'','',30,0,0.02404,0.466,0,'OK - 192.168.77.159: rta 0.867ms, lost 0%','rta=0.867ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627759,2,23554,0,0,1,1,0,1,'2024-12-27 13:24:45',483385,'2024-12-27 13:24:45',494135,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627760,2,23552,0,0,1,1,0,1,'2024-12-27 13:24:45',494655,'2024-12-27 13:24:45',503972,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.123ms, lost 0%','rta=0.123ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627761,2,21395,0,0,1,5,1,1,'2024-12-27 13:24:50',532224,'2024-12-27 13:24:51',524428,26989,'','',30,0,0.992,0,1,'CRITICAL - 192.168.77.154: Host unreachable @ 192.168.77.9. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627762,2,21395,0,0,1,5,1,1,'2024-12-27 13:24:51',527045,'2024-12-27 13:24:55',540085,26989,'','',30,0,2.00752,1.527,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627763,2,23553,0,0,1,10,1,1,'2024-12-27 13:24:55',540136,'2024-12-27 13:24:57',549074,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627764,2,23551,0,0,1,1,0,1,'2024-12-27 13:25:00',588642,'2024-12-27 13:25:00',599943,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627765,2,28533,0,0,1,1,1,1,'2024-12-27 13:25:00',600208,'2024-12-27 13:25:02',607893,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627766,2,23551,0,0,1,1,0,1,'2024-12-27 13:25:02',610279,'2024-12-27 13:25:05',621395,26989,'','',30,0,0.00925,2.61,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627767,2,28279,0,0,1,1,0,1,'2024-12-27 13:25:10',656356,'2024-12-27 13:25:10',663979,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627768,2,23548,0,0,1,5,1,1,'2024-12-27 13:25:05',623644,'2024-12-27 13:25:10',664466,26989,'','',30,0,2.00794,0.623,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627769,2,23552,0,0,1,1,0,1,'2024-12-27 13:25:10',666915,'2024-12-27 13:25:15',687723,26989,'','',30,0,0.00861,0.666,0,'OK - 192.168.77.8: rta 0.123ms, lost 0%','rta=0.123ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627770,2,23549,0,0,1,10,0,1,'2024-12-27 13:25:10',669742,'2024-12-27 13:25:15',687953,26989,'','',30,0,0.01144,0.669,0,'OK - 84.38.95.222: rta 0.249ms, lost 0%','rta=0.249ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627771,2,21397,0,0,1,5,1,1,'2024-12-27 13:25:10',672977,'2024-12-27 13:25:15',688205,26989,'','',30,0,2.0085,0.672,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627772,2,28279,0,0,1,1,0,1,'2024-12-27 13:25:15',690773,'2024-12-27 13:25:20',728666,26989,'','',30,0,0.00714,0.69,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627773,2,21396,0,0,1,5,0,1,'2024-12-27 13:25:20',728719,'2024-12-27 13:25:20',751632,26989,'','',30,0,0.022,0,0,'OK - 192.168.77.159: rta 0.745ms, lost 0%','rta=0.745ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627774,2,28533,0,0,1,1,1,1,'2024-12-27 13:25:15',694337,'2024-12-27 13:25:20',752137,26989,'','',30,0,2.00854,0.694,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627775,2,23553,0,0,1,10,1,1,'2024-12-27 13:25:20',752202,'2024-12-27 13:25:22',760073,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627776,2,23554,0,0,1,1,0,1,'2024-12-27 13:25:25',767857,'2024-12-27 13:25:25',778039,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627777,2,23554,0,0,1,1,0,1,'2024-12-27 13:25:25',780509,'2024-12-27 13:25:30',790033,26989,'','',30,0,0.00875,0.78,0,'OK - 192.168.77.208: rta 0.148ms, lost 0%','rta=0.148ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627778,2,23553,0,0,1,10,1,1,'2024-12-27 13:25:35',825398,'2024-12-27 13:25:40',837973,26989,'','',30,0,2.00826,0.825,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627779,2,23552,0,0,1,1,0,1,'2024-12-27 13:25:45',850655,'2024-12-27 13:25:45',860269,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.117ms, lost 0%','rta=0.117ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627780,2,21396,0,0,1,5,0,1,'2024-12-27 13:25:45',863054,'2024-12-27 13:25:50',886346,26989,'','',30,0,0.02185,0.863,0,'OK - 192.168.77.159: rta 0.803ms, lost 0%','rta=0.803ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627781,2,23549,0,0,1,10,0,1,'2024-12-27 13:25:50',886676,'2024-12-27 13:25:50',898647,26989,'','',30,0,0.011,0,0,'OK - 84.38.95.222: rta 0.202ms, lost 0%','rta=0.202ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627782,2,23554,0,0,1,1,0,1,'2024-12-27 13:25:55',927059,'2024-12-27 13:25:55',937654,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627783,2,23551,0,0,1,1,0,1,'2024-12-27 13:25:55',938015,'2024-12-27 13:25:55',947835,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627784,2,21395,0,0,1,5,1,1,'2024-12-27 13:25:55',950368,'2024-12-27 13:26:00',972030,26989,'','',30,0,2.00795,0.95,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627785,2,23551,0,0,1,1,0,1,'2024-12-27 13:26:05',1724,'2024-12-27 13:26:10',1834,26989,'','',30,0,0.00997,0.003,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627786,2,28533,0,0,1,1,1,1,'2024-12-27 13:26:10',229,'2024-12-27 13:26:12',35,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627787,2,23552,0,0,1,1,0,1,'2024-12-27 13:26:12',18597,'2024-12-27 13:26:12',43,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.132ms, lost 0%','rta=0.132ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627788,2,21397,0,0,1,5,1,1,'2024-12-27 13:26:15',7,'2024-12-27 13:26:17',0,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627789,2,23548,0,0,1,5,1,1,'2024-12-27 13:26:12',23787,'2024-12-27 13:26:17',0,26989,'','',30,0,1.05976,2.056,2,'CRITICAL - 172.20.3.11: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627790,2,23553,0,0,1,10,1,1,'2024-12-27 13:26:20',131080,'2024-12-27 13:26:22',140213,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627791,2,23552,0,0,1,1,0,1,'2024-12-27 13:26:17',0,'2024-12-27 13:26:22',140713,26989,'','',30,0,0.00882,2.092,0,'OK - 192.168.77.8: rta 0.135ms, lost 0%','rta=0.135ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627792,2,23549,0,0,1,10,0,1,'2024-12-27 13:26:17',0,'2024-12-27 13:26:22',140948,26989,'','',30,0,0.01261,2.095,0,'OK - 84.38.95.222: rta 0.297ms, lost 0%','rta=0.297ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627793,2,21397,0,0,1,5,1,1,'2024-12-27 13:26:17',0,'2024-12-27 13:26:22',141189,26989,'','',30,0,0.98744,2.098,2,'CRITICAL - 172.20.3.10: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627794,2,23554,0,0,1,1,0,1,'2024-12-27 13:26:22',141262,'2024-12-27 13:26:22',151209,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627795,2,28279,0,0,1,1,0,1,'2024-12-27 13:26:22',153967,'2024-12-27 13:26:25',182251,26989,'','',30,0,0.00625,2.153,0,'OK - 192.168.77.9: rta 0.017ms, lost 0%','rta=0.017ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627796,2,28533,0,0,1,1,1,1,'2024-12-27 13:26:22',156384,'2024-12-27 13:26:25',182961,26989,'','',30,0,2.00821,2.156,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627797,2,23551,0,0,1,1,0,1,'2024-12-27 13:26:30',219921,'2024-12-27 13:26:30',231203,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627798,2,23554,0,0,1,1,0,1,'2024-12-27 13:26:30',233725,'2024-12-27 13:26:35',259106,26989,'','',30,0,0.00896,0.233,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627799,2,23552,0,0,1,1,0,1,'2024-12-27 13:26:35',259409,'2024-12-27 13:26:35',269988,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.146ms, lost 0%','rta=0.146ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627800,2,23553,0,0,1,10,1,1,'2024-12-27 13:26:40',310842,'2024-12-27 13:26:45',335469,26989,'','',30,0,0.03997,0.31,2,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627801,2,21397,0,0,1,5,1,1,'2024-12-27 13:26:45',335524,'2024-12-27 13:26:47',344921,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627802,2,23554,0,0,1,1,0,1,'2024-12-27 13:26:47',345240,'2024-12-27 13:26:47',355376,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627803,2,21396,0,0,1,5,0,1,'2024-12-27 13:26:50',393885,'2024-12-27 13:26:55',418676,26989,'','',30,0,0.02074,0.393,0,'OK - 192.168.77.159: rta 0.721ms, lost 0%','rta=0.721ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627804,2,28533,0,0,1,1,1,1,'2024-12-27 13:26:55',418768,'2024-12-27 13:26:56',472150,26989,'','',30,0,1.053,0,1,'CRITICAL - 172.50.1.3: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627805,2,23551,0,0,1,1,0,1,'2024-12-27 13:27:00',507203,'2024-12-27 13:27:00',518402,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627806,2,21395,0,0,1,5,1,1,'2024-12-27 13:27:00',521213,'2024-12-27 13:27:05',559174,26989,'','',30,0,2.0099,0.521,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627807,2,23552,0,0,1,1,0,1,'2024-12-27 13:27:05',559226,'2024-12-27 13:27:05',568738,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.124ms, lost 0%','rta=0.124ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627808,2,23553,0,0,1,10,1,1,'2024-12-27 13:27:05',569216,'2024-12-27 13:27:07',577396,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627809,2,23554,0,0,1,1,0,1,'2024-12-27 13:27:10',600104,'2024-12-27 13:27:10',610930,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627810,2,23548,0,0,1,5,1,1,'2024-12-27 13:27:10',611195,'2024-12-27 13:27:12',619570,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627811,2,23551,0,0,1,1,0,1,'2024-12-27 13:27:12',621951,'2024-12-27 13:27:15',646803,26989,'','',30,0,0.00895,2.621,0,'OK - 192.168.77.29: rta 0.155ms, lost 0%','rta=0.155ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627812,2,23548,0,0,1,5,1,1,'2024-12-27 13:27:17',657389,'2024-12-27 13:27:20',678117,26989,'','',30,0,2.00792,0.657,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627813,2,21395,0,0,1,5,1,1,'2024-12-27 13:27:25',708302,'2024-12-27 13:27:27',718819,26989,'','',30,0,2.01,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627814,2,23552,0,0,1,1,0,1,'2024-12-27 13:27:27',719139,'2024-12-27 13:27:27',728459,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.118ms, lost 0%','rta=0.118ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627815,2,23552,0,0,1,1,0,1,'2024-12-27 13:27:22',688705,'2024-12-27 13:27:27',729157,26989,'','',30,0,0.01374,0.688,0,'OK - 192.168.77.8: rta 0.143ms, lost 0%','rta=0.143ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627816,2,23549,0,0,1,10,0,1,'2024-12-27 13:27:22',689782,'2024-12-27 13:27:27',729370,26989,'','',30,0,0.01525,0.689,0,'OK - 84.38.95.222: rta 0.430ms, lost 0%','rta=0.430ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627817,2,21397,0,0,1,5,1,1,'2024-12-27 13:27:22',693093,'2024-12-27 13:27:27',729610,26989,'','',30,0,2.00908,0.693,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627818,2,28533,0,0,1,1,1,1,'2024-12-27 13:27:30',998066,'2024-12-27 13:27:33',4052,26989,'','',30,0,2.01,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627819,2,28279,0,0,1,1,0,1,'2024-12-27 13:27:27',731873,'2024-12-27 13:27:33',0,26989,'','',30,0,0.00779,2.731,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627820,2,28533,0,0,1,1,1,1,'2024-12-27 13:27:27',733656,'2024-12-27 13:27:33',0,26989,'','',30,0,2.00991,2.733,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627821,2,23548,0,0,1,5,1,1,'2024-12-27 13:27:33',0,'2024-12-27 13:27:35',1,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627822,2,23554,0,0,1,1,0,1,'2024-12-27 13:27:35',22639,'2024-12-27 13:27:40',439,26989,'','',30,0,0.00952,0.054,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627823,2,23553,0,0,1,10,1,1,'2024-12-27 13:27:40',3534,'2024-12-27 13:27:42',63,26989,'','',30,0,2.01,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627824,2,23551,0,0,1,1,0,1,'2024-12-27 13:27:42',7,'2024-12-27 13:27:42',0,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627825,2,28533,0,0,1,1,1,1,'2024-12-27 13:27:45',103449,'2024-12-27 13:27:47',113098,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627826,2,23552,0,0,1,1,0,1,'2024-12-27 13:27:50',142228,'2024-12-27 13:27:50',152966,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.114ms, lost 0%','rta=0.114ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627827,2,23553,0,0,1,10,1,1,'2024-12-27 13:27:47',115874,'2024-12-27 13:27:50',153885,26989,'','',30,0,2.00744,2.115,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627828,2,21395,0,0,1,5,1,1,'2024-12-27 13:27:50',153937,'2024-12-27 13:27:51',132947,26989,'','',30,0,0.979,0,1,'CRITICAL - 192.168.77.154: Host unreachable @ 192.168.77.9. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627829,2,21396,0,0,1,5,0,1,'2024-12-27 13:27:55',149358,'2024-12-27 13:28:00',170149,26989,'','',30,0,0.02114,0.149,0,'OK - 192.168.77.159: rta 0.709ms, lost 0%','rta=0.709ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627830,2,23554,0,0,1,1,0,1,'2024-12-27 13:28:00',170494,'2024-12-27 13:28:00',182097,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.208: rta 0.155ms, lost 0%','rta=0.155ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627831,2,23551,0,0,1,1,0,1,'2024-12-27 13:28:00',182397,'2024-12-27 13:28:00',192292,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627832,2,28279,0,0,1,1,0,1,'2024-12-27 13:28:10',229394,'2024-12-27 13:28:10',237420,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627833,2,21395,0,0,1,5,1,1,'2024-12-27 13:28:05',208479,'2024-12-27 13:28:10',237883,26989,'','',30,0,2.00792,0.208,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627834,2,23552,0,0,1,1,0,1,'2024-12-27 13:28:15',250136,'2024-12-27 13:28:15',260869,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.131ms, lost 0%','rta=0.131ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627835,2,23551,0,0,1,1,0,1,'2024-12-27 13:28:15',263302,'2024-12-27 13:28:20',281879,26989,'','',30,0,0.00889,0.263,0,'OK - 192.168.77.29: rta 0.146ms, lost 0%','rta=0.146ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627836,2,21396,0,0,1,5,0,1,'2024-12-27 13:28:20',281933,'2024-12-27 13:28:20',304083,26989,'','',30,0,0.021,0,0,'OK - 192.168.77.159: rta 0.722ms, lost 0%','rta=0.722ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627837,2,23553,0,0,1,10,1,1,'2024-12-27 13:28:20',304383,'2024-12-27 13:28:22',312279,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627838,2,23554,0,0,1,1,0,1,'2024-12-27 13:28:25',338756,'2024-12-27 13:28:25',354337,26989,'','',30,0,0.015,0,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627839,2,23548,0,0,1,5,1,1,'2024-12-27 13:28:22',331417,'2024-12-27 13:28:25',354904,26989,'','',30,0,0.97883,2.331,2,'CRITICAL - 172.20.3.11: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627840,2,23552,0,0,1,1,0,1,'2024-12-27 13:28:27',361409,'2024-12-27 13:28:30',394866,26989,'','',30,0,0.0268,0.361,0,'OK - 192.168.77.8: rta 0.121ms, lost 0%','rta=0.121ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627841,2,23549,0,0,1,10,0,1,'2024-12-27 13:28:27',364777,'2024-12-27 13:28:30',395079,26989,'','',30,0,0.08276,0.364,0,'OK - 84.38.95.222: rta 3.088ms, lost 0%','rta=3.088ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627842,2,21397,0,0,1,5,1,1,'2024-12-27 13:28:27',368180,'2024-12-27 13:28:30',395316,26989,'','',30,0,2.02418,0.368,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627843,2,28279,0,0,1,1,0,1,'2024-12-27 13:28:33',406675,'2024-12-27 13:28:35',417495,26989,'','',30,0,0.00718,0.406,0,'OK - 192.168.77.9: rta 0.016ms, lost 0%','rta=0.016ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627844,2,28533,0,0,1,1,1,1,'2024-12-27 13:28:33',407795,'2024-12-27 13:28:40',443573,26989,'','',30,0,2.01094,0.407,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627845,2,23554,0,0,1,1,0,1,'2024-12-27 13:28:40',445888,'2024-12-27 13:28:45',462198,26989,'','',30,0,0.00985,0.445,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627846,2,23552,0,0,1,1,0,1,'2024-12-27 13:28:45',462291,'2024-12-27 13:28:45',473764,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.8: rta 0.118ms, lost 0%','rta=0.118ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627847,2,23553,0,0,1,10,1,1,'2024-12-27 13:28:45',474084,'2024-12-27 13:28:47',498523,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627848,2,23549,0,0,1,10,0,1,'2024-12-27 13:28:50',516519,'2024-12-27 13:28:50',717278,26989,'','',30,0,0.2,0,0,'OK - 84.38.95.222: rta 9.645ms, lost 0%','rta=9.645ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627849,2,23553,0,0,1,10,1,1,'2024-12-27 13:28:50',719777,'2024-12-27 13:28:55',761164,26989,'','',30,0,2.00761,0.719,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627850,2,23551,0,0,1,1,0,1,'2024-12-27 13:28:55',761227,'2024-12-27 13:28:55',772021,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627851,2,23554,0,0,1,1,0,1,'2024-12-27 13:29:00',792463,'2024-12-27 13:29:00',803301,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627852,2,21396,0,0,1,5,0,1,'2024-12-27 13:29:00',806129,'2024-12-27 13:29:05',823413,26989,'','',30,0,0.02455,0.806,0,'OK - 192.168.77.159: rta 0.934ms, lost 0%','rta=0.934ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627853,2,28533,0,0,1,1,1,1,'2024-12-27 13:29:05',823652,'2024-12-27 13:29:07',833891,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627854,2,23552,0,0,1,1,0,1,'2024-12-27 13:29:10',855905,'2024-12-27 13:29:10',865991,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.120ms, lost 0%','rta=0.120ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627855,2,21395,0,0,1,5,1,1,'2024-12-27 13:29:10',868531,'2024-12-27 13:29:15',881335,26989,'','',30,0,2.00745,0.868,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627856,2,21397,0,0,1,5,1,1,'2024-12-27 13:29:15',881399,'2024-12-27 13:29:17',890468,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627857,2,23553,0,0,1,10,1,1,'2024-12-27 13:29:17',890788,'2024-12-27 13:29:18',889622,26989,'','',30,0,0.999,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627858,2,23554,0,0,1,1,0,1,'2024-12-27 13:29:20',904060,'2024-12-27 13:29:20',915729,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627859,2,23549,0,0,1,10,0,1,'2024-12-27 13:29:20',916040,'2024-12-27 13:29:20',926902,26989,'','',30,0,0.01,0,0,'OK - 84.38.95.222: rta 0.198ms, lost 0%','rta=0.198ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627860,2,23551,0,0,1,1,0,1,'2024-12-27 13:29:20',929302,'2024-12-27 13:29:25',948059,26989,'','',30,0,0.00884,0.929,0,'OK - 192.168.77.29: rta 0.148ms, lost 0%','rta=0.148ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627861,2,28533,0,0,1,1,1,1,'2024-12-27 13:29:25',948370,'2024-12-27 13:29:27',957027,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627862,2,23548,0,0,1,5,1,1,'2024-12-27 13:29:27',959503,'2024-12-27 13:29:30',975742,26989,'','',30,0,2.00685,2.959,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627863,2,23552,0,0,1,1,0,1,'2024-12-27 13:29:30',977980,'2024-12-27 13:29:36',1038,26989,'','',30,0,0.01087,0.977,0,'OK - 192.168.77.8: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627864,2,23549,0,0,1,10,0,1,'2024-12-27 13:29:30',979518,'2024-12-27 13:29:36',1184,26989,'','',30,0,0.01239,0.979,0,'OK - 84.38.95.222: rta 0.208ms, lost 0%','rta=0.208ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627865,2,28279,0,0,1,1,0,1,'2024-12-27 13:29:36',1219,'2024-12-27 13:29:36',8,26989,'','',30,0,0.008,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627866,2,21397,0,0,1,5,1,1,'2024-12-27 13:29:30',982374,'2024-12-27 13:29:36',4857,26989,'','',30,0,2.00934,0.982,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627867,2,28279,0,0,1,1,0,1,'2024-12-27 13:29:36',840,'2024-12-27 13:29:40',9891,26989,'','',30,0,0.00652,1.015,0,'OK - 192.168.77.9: rta 0.014ms, lost 0%','rta=0.014ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627868,2,23551,0,0,1,1,0,1,'2024-12-27 13:29:40',9934,'2024-12-27 13:29:40',14612,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.157ms, lost 0%','rta=0.157ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627869,2,28533,0,0,1,1,1,1,'2024-12-27 13:29:40',16438,'2024-12-27 13:29:45',2813,26989,'','',30,0,2.0076,0.04,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627870,2,23554,0,0,1,1,0,1,'2024-12-27 13:29:45',22559,'2024-12-27 13:29:45',52,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627871,2,23553,0,0,1,10,1,1,'2024-12-27 13:29:45',3404,'2024-12-27 13:29:47',30774,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627872,2,23554,0,0,1,1,0,1,'2024-12-27 13:29:47',32069,'2024-12-27 13:29:50',102798,26989,'','',30,0,0.00896,2.076,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627873,2,23553,0,0,1,10,1,1,'2024-12-27 13:29:55',122296,'2024-12-27 13:30:00',162963,26989,'','',30,0,2.00862,0.122,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627874,2,28533,0,0,1,1,1,1,'2024-12-27 13:30:00',163558,'2024-12-27 13:30:02',172825,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627875,2,23551,0,0,1,1,0,1,'2024-12-27 13:30:02',173152,'2024-12-27 13:30:02',183505,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627876,2,23552,0,0,1,1,0,1,'2024-12-27 13:30:05',192776,'2024-12-27 13:30:05',203130,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.130ms, lost 0%','rta=0.130ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627877,2,21396,0,0,1,5,0,1,'2024-12-27 13:30:05',206235,'2024-12-27 13:30:10',237500,26989,'','',30,0,0.02015,0.206,0,'OK - 192.168.77.159: rta 0.713ms, lost 0%','rta=0.713ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627878,2,23554,0,0,1,1,0,1,'2024-12-27 13:30:10',237557,'2024-12-27 13:30:10',248801,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627879,2,23548,0,0,1,5,1,1,'2024-12-27 13:30:10',249102,'2024-12-27 13:30:12',257426,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627880,2,21395,0,0,1,5,1,1,'2024-12-27 13:30:15',274082,'2024-12-27 13:30:20',285344,26989,'','',30,0,2.00815,0.274,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627881,2,23552,0,0,1,1,0,1,'2024-12-27 13:30:25',306641,'2024-12-27 13:30:25',316588,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.117ms, lost 0%','rta=0.117ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627882,2,23551,0,0,1,1,0,1,'2024-12-27 13:30:25',316800,'2024-12-27 13:30:25',326548,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627883,2,23551,0,0,1,1,0,1,'2024-12-27 13:30:25',328858,'2024-12-27 13:30:30',351453,26989,'','',30,0,0.00877,0.328,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627884,2,28533,0,0,1,1,1,1,'2024-12-27 13:30:30',351496,'2024-12-27 13:30:32',360931,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627885,2,23548,0,0,1,5,1,1,'2024-12-27 13:30:32',361327,'2024-12-27 13:30:34',370639,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627886,2,23548,0,0,1,5,1,1,'2024-12-27 13:30:34',373166,'2024-12-27 13:30:35',392118,26989,'','',30,0,0.99512,4.373,2,'CRITICAL - 172.20.3.11: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627887,2,23552,0,0,1,1,0,1,'2024-12-27 13:30:36',410241,'2024-12-27 13:30:40',431244,26989,'','',30,0,0.01268,0.41,0,'OK - 192.168.77.8: rta 0.269ms, lost 0%','rta=0.269ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627888,2,23549,0,0,1,10,0,1,'2024-12-27 13:30:36',413467,'2024-12-27 13:30:40',431462,26989,'','',30,0,0.0121,0.413,0,'OK - 84.38.95.222: rta 0.247ms, lost 0%','rta=0.247ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627889,2,23553,0,0,1,10,1,1,'2024-12-27 13:30:40',431515,'2024-12-27 13:30:42',440931,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627890,2,23551,0,0,1,1,0,1,'2024-12-27 13:30:42',441244,'2024-12-27 13:30:42',451313,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627891,2,21397,0,0,1,5,1,1,'2024-12-27 13:30:36',416579,'2024-12-27 13:30:42',451811,26989,'','',30,0,2.00916,0.416,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627892,2,28279,0,0,1,1,0,1,'2024-12-27 13:30:42',454052,'2024-12-27 13:30:45',468754,26989,'','',30,0,0.0061,2.454,0,'OK - 192.168.77.9: rta 0.014ms, lost 0%','rta=0.014ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627893,2,23554,0,0,1,1,0,1,'2024-12-27 13:30:50',492405,'2024-12-27 13:30:50',503565,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.155ms, lost 0%','rta=0.155ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627894,2,28533,0,0,1,1,1,1,'2024-12-27 13:30:45',471355,'2024-12-27 13:30:50',504642,26989,'','',30,0,2.00844,0.471,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627895,2,21395,0,0,1,5,1,1,'2024-12-27 13:30:55',522319,'2024-12-27 13:30:57',531338,26989,'','',30,0,2.008,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627896,2,23554,0,0,1,1,0,1,'2024-12-27 13:30:50',507432,'2024-12-27 13:30:57',531844,26989,'','',30,0,0.00914,0.507,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627897,2,23553,0,0,1,10,1,1,'2024-12-27 13:30:57',532159,'2024-12-27 13:30:59',540938,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627898,2,23552,0,0,1,1,0,1,'2024-12-27 13:31:00',555321,'2024-12-27 13:31:00',566543,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.137ms, lost 0%','rta=0.137ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627899,2,23551,0,0,1,1,0,1,'2024-12-27 13:31:00',567148,'2024-12-27 13:31:00',577042,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627900,2,23553,0,0,1,10,1,1,'2024-12-27 13:31:00',579849,'2024-12-27 13:31:05',595548,26989,'','',30,0,2.00862,0.579,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627901,2,28279,0,0,1,1,0,1,'2024-12-27 13:31:10',645959,'2024-12-27 13:31:10',653847,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627902,2,21396,0,0,1,5,0,1,'2024-12-27 13:31:10',656623,'2024-12-27 13:31:15',683208,26989,'','',30,0,0.02854,0.656,0,'OK - 192.168.77.159: rta 1.137ms, lost 0%','rta=1.137ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627903,2,23553,0,0,1,10,1,1,'2024-12-27 13:31:20',715946,'2024-12-27 13:31:22',725213,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627904,2,23554,0,0,1,1,0,1,'2024-12-27 13:31:25',747120,'2024-12-27 13:31:25',757161,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627905,2,21395,0,0,1,5,1,1,'2024-12-27 13:31:22',728186,'2024-12-27 13:31:25',757655,26989,'','',30,0,2.00792,2.728,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627906,2,23551,0,0,1,1,0,1,'2024-12-27 13:31:30',787464,'2024-12-27 13:31:35',813609,26989,'','',30,0,0.00897,0.787,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627907,2,23548,0,0,1,5,1,1,'2024-12-27 13:31:35',816570,'2024-12-27 13:31:40',846237,26989,'','',30,0,2.00833,0.816,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627908,2,23552,0,0,1,1,0,1,'2024-12-27 13:31:40',848536,'2024-12-27 13:31:45',891582,26989,'','',30,0,0.00984,0.848,0,'OK - 192.168.77.8: rta 0.129ms, lost 0%','rta=0.129ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627909,2,23549,0,0,1,10,0,1,'2024-12-27 13:31:40',852332,'2024-12-27 13:31:45',891812,26989,'','',30,0,0.0138,0.852,0,'OK - 84.38.95.222: rta 0.364ms, lost 0%','rta=0.364ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627910,2,23553,0,0,1,10,1,1,'2024-12-27 13:31:45',892152,'2024-12-27 13:31:47',901244,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627911,2,21397,0,0,1,5,1,1,'2024-12-27 13:31:42',860591,'2024-12-27 13:31:47',901742,26989,'','',30,0,2.00889,0.86,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627912,2,28279,0,0,1,1,0,1,'2024-12-27 13:31:47',903943,'2024-12-27 13:31:50',937888,26989,'','',30,0,0.00624,2.903,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627913,2,23554,0,0,1,1,0,1,'2024-12-27 13:31:55',959722,'2024-12-27 13:31:55',970243,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627914,2,28533,0,0,1,1,1,1,'2024-12-27 13:31:50',940771,'2024-12-27 13:31:55',970829,26989,'','',30,0,2.01,0.94,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627915,2,23551,0,0,1,1,0,1,'2024-12-27 13:31:55',970892,'2024-12-27 13:31:55',980740,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627916,2,23554,0,0,1,1,0,1,'2024-12-27 13:31:57',989737,'2024-12-27 13:32:00',1162,26989,'','',30,0,0.01054,0.989,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627917,2,28533,0,0,1,1,1,1,'2024-12-27 13:32:10',3488,'2024-12-27 13:32:12',60,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627918,2,23553,0,0,1,10,1,1,'2024-12-27 13:32:05',2746,'2024-12-27 13:32:12',0,26989,'','',30,0,2.00769,0.052,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627919,2,23552,0,0,1,1,0,1,'2024-12-27 13:32:12',0,'2024-12-27 13:32:12',107006,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.123ms, lost 0%','rta=0.123ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627920,2,21397,0,0,1,5,1,1,'2024-12-27 13:32:15',117185,'2024-12-27 13:32:17',144320,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627921,2,21396,0,0,1,5,0,1,'2024-12-27 13:32:17',147074,'2024-12-27 13:32:20',159223,26989,'','',30,0,0.02218,2.147,0,'OK - 192.168.77.159: rta 0.811ms, lost 0%','rta=0.811ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627922,2,23554,0,0,1,1,0,1,'2024-12-27 13:32:20',159300,'2024-12-27 13:32:20',170909,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627923,2,23549,0,0,1,10,0,1,'2024-12-27 13:32:20',171268,'2024-12-27 13:32:20',182254,26989,'','',30,0,0.01,0,0,'OK - 84.38.95.222: rta 0.201ms, lost 0%','rta=0.201ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627924,2,21395,0,0,1,5,1,1,'2024-12-27 13:32:25',198354,'2024-12-27 13:32:30',229879,26989,'','',30,0,2.00813,0.198,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627925,2,23551,0,0,1,1,0,1,'2024-12-27 13:32:30',230246,'2024-12-27 13:32:30',241395,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627926,2,28279,0,0,1,1,0,1,'2024-12-27 13:32:35',273825,'2024-12-27 13:32:35',282766,26989,'','',30,0,0.008,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627927,2,23552,0,0,1,1,0,1,'2024-12-27 13:32:35',283102,'2024-12-27 13:32:35',292350,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.116ms, lost 0%','rta=0.116ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627928,2,23551,0,0,1,1,0,1,'2024-12-27 13:32:35',294884,'2024-12-27 13:32:40',309829,26989,'','',30,0,0.00876,0.294,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627929,2,23548,0,0,1,5,1,1,'2024-12-27 13:32:40',315762,'2024-12-27 13:32:45',331257,26989,'','',30,0,0.05976,0.315,2,'CRITICAL - 172.20.3.11: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627930,2,21397,0,0,1,5,1,1,'2024-12-27 13:32:45',331314,'2024-12-27 13:32:47',339539,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627931,2,23553,0,0,1,10,1,1,'2024-12-27 13:32:47',339840,'2024-12-27 13:32:48',339853,26989,'','',30,0,1,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627932,2,23554,0,0,1,1,0,1,'2024-12-27 13:32:48',340413,'2024-12-27 13:32:48',429347,26989,'','',30,0,0.088,0,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627933,2,23552,0,0,1,1,0,1,'2024-12-27 13:32:48',431910,'2024-12-27 13:32:50',456852,26989,'','',30,0,0.00869,3.431,0,'OK - 192.168.77.8: rta 0.133ms, lost 0%','rta=0.133ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627934,2,23549,0,0,1,10,0,1,'2024-12-27 13:32:48',434772,'2024-12-27 13:32:50',457100,26989,'','',30,0,0.01135,3.434,0,'OK - 84.38.95.222: rta 0.239ms, lost 0%','rta=0.239ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627935,2,21397,0,0,1,5,1,1,'2024-12-27 13:32:48',438122,'2024-12-27 13:32:50',457363,26989,'','',30,0,2.00815,1.438,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627936,2,28279,0,0,1,1,0,1,'2024-12-27 13:32:50',462103,'2024-12-27 13:32:55',477077,26989,'','',30,0,0.00824,0.462,0,'OK - 192.168.77.9: rta 0.030ms, lost 0%','rta=0.030ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627937,2,28533,0,0,1,1,1,1,'2024-12-27 13:32:55',477147,'2024-12-27 13:32:56',555124,26989,'','',30,0,1.077,0,1,'CRITICAL - 172.50.1.3: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627938,2,23551,0,0,1,1,0,1,'2024-12-27 13:33:00',577254,'2024-12-27 13:33:00',588725,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627939,2,28533,0,0,1,1,1,1,'2024-12-27 13:32:56',557799,'2024-12-27 13:33:00',589230,26989,'','',30,0,2.00673,1.557,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627940,2,23554,0,0,1,1,0,1,'2024-12-27 13:33:00',591718,'2024-12-27 13:33:05',622194,26989,'','',30,0,0.00889,0.591,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627941,2,23552,0,0,1,1,0,1,'2024-12-27 13:33:05',622274,'2024-12-27 13:33:05',632718,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.131ms, lost 0%','rta=0.131ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627942,2,23553,0,0,1,10,1,1,'2024-12-27 13:33:05',633254,'2024-12-27 13:33:07',642300,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627943,2,23548,0,0,1,5,1,1,'2024-12-27 13:33:10',669299,'2024-12-27 13:33:12',679043,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627944,2,23553,0,0,1,10,1,1,'2024-12-27 13:33:12',684605,'2024-12-27 13:33:15',707122,26989,'','',30,0,0.99166,0.684,2,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627945,2,21396,0,0,1,5,0,1,'2024-12-27 13:33:20',742978,'2024-12-27 13:33:25',763952,26989,'','',30,0,0.02175,0.742,0,'OK - 192.168.77.159: rta 0.714ms, lost 0%','rta=0.714ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627946,2,21395,0,0,1,5,1,1,'2024-12-27 13:33:25',764011,'2024-12-27 13:33:27',773622,26989,'','',30,0,2.009,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627947,2,23552,0,0,1,1,0,1,'2024-12-27 13:33:27',773907,'2024-12-27 13:33:27',783358,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.126ms, lost 0%','rta=0.126ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627948,2,23551,0,0,1,1,0,1,'2024-12-27 13:33:27',783651,'2024-12-27 13:33:27',793743,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627949,2,28533,0,0,1,1,1,1,'2024-12-27 13:33:30',831673,'2024-12-27 13:33:32',841464,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627950,2,23548,0,0,1,5,1,1,'2024-12-27 13:33:32',842097,'2024-12-27 13:33:34',849761,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627951,2,21395,0,0,1,5,1,1,'2024-12-27 13:33:34',852699,'2024-12-27 13:33:40',917796,26989,'','',30,0,2.00736,4.852,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627952,2,23553,0,0,1,10,1,1,'2024-12-27 13:33:40',917865,'2024-12-27 13:33:42',927133,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627953,2,23551,0,0,1,1,0,1,'2024-12-27 13:33:42',930008,'2024-12-27 13:33:45',944546,26989,'','',30,0,0.0094,2.929,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627954,2,23554,0,0,1,1,0,1,'2024-12-27 13:33:50',985052,'2024-12-27 13:33:50',996661,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627955,2,23552,0,0,1,1,0,1,'2024-12-27 13:33:50',997251,'2024-12-27 13:33:51',450,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.141ms, lost 0%','rta=0.141ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627956,2,23548,0,0,1,5,1,1,'2024-12-27 13:33:45',947045,'2024-12-27 13:33:51',3943,26989,'','',30,0,1.10109,0.947,2,'CRITICAL - 172.20.3.11: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627957,2,21395,0,0,1,5,1,1,'2024-12-27 13:33:51',0,'2024-12-27 13:33:51',966925,26989,'','',30,0,0.958,0,1,'CRITICAL - 192.168.77.154: Host unreachable @ 192.168.77.9. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627958,2,23552,0,0,1,1,0,1,'2024-12-27 13:33:51',969405,'2024-12-27 13:33:56',6,26989,'','',30,0,0.0091,1.969,0,'OK - 192.168.77.8: rta 0.146ms, lost 0%','rta=0.146ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627959,2,23549,0,0,1,10,0,1,'2024-12-27 13:33:51',972640,'2024-12-27 13:33:56',56,26989,'','',30,0,0.01199,1.972,0,'OK - 84.38.95.222: rta 0.234ms, lost 0%','rta=0.234ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627960,2,21397,0,0,1,5,1,1,'2024-12-27 13:33:51',976717,'2024-12-27 13:33:56',3810,26989,'','',30,0,0.07366,1.976,2,'CRITICAL - 172.20.3.10: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627961,2,23553,0,0,1,10,1,1,'2024-12-27 13:33:56',502,'2024-12-27 13:33:58',121,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627962,2,28279,0,0,1,1,0,1,'2024-12-27 13:33:58',1,'2024-12-27 13:34:00',15096,26989,'','',30,0,0.00623,3.019,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627963,2,23551,0,0,1,1,0,1,'2024-12-27 13:34:00',15302,'2024-12-27 13:34:00',310,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627964,2,28533,0,0,1,1,1,1,'2024-12-27 13:34:00',19978,'2024-12-27 13:34:02',62,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627965,2,28533,0,0,1,1,1,1,'2024-12-27 13:34:02',7,'2024-12-27 13:34:05',0,26989,'','',30,0,0.97518,2.079,2,'CRITICAL - 172.50.1.3: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627966,2,23554,0,0,1,1,0,1,'2024-12-27 13:34:05',0,'2024-12-27 13:34:10',113663,26989,'','',30,0,0.00928,0.091,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627967,2,23552,0,0,1,1,0,1,'2024-12-27 13:34:15',125020,'2024-12-27 13:34:15',135493,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.124ms, lost 0%','rta=0.124ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627968,2,21396,0,0,1,5,0,1,'2024-12-27 13:34:20',177297,'2024-12-27 13:34:20',202298,26989,'','',30,0,0.024,0,0,'OK - 192.168.77.159: rta 0.892ms, lost 0%','rta=0.892ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627969,2,23553,0,0,1,10,1,1,'2024-12-27 13:34:15',138006,'2024-12-27 13:34:20',202816,26989,'','',30,0,2.00713,0.137,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627970,2,23554,0,0,1,1,0,1,'2024-12-27 13:34:25',239372,'2024-12-27 13:34:25',249737,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627971,2,21396,0,0,1,5,0,1,'2024-12-27 13:34:25',252230,'2024-12-27 13:34:30',273527,26989,'','',30,0,0.02021,0.252,0,'OK - 192.168.77.159: rta 0.721ms, lost 0%','rta=0.721ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627972,2,21395,0,0,1,5,1,1,'2024-12-27 13:34:40',333285,'2024-12-27 13:34:45',358924,26989,'','',30,0,2.00757,0.333,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627973,2,23552,0,0,1,1,0,1,'2024-12-27 13:34:45',358988,'2024-12-27 13:34:45',368801,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.113ms, lost 0%','rta=0.113ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627974,2,23553,0,0,1,10,1,1,'2024-12-27 13:34:45',369152,'2024-12-27 13:34:47',378392,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627975,2,23551,0,0,1,1,0,1,'2024-12-27 13:34:47',381012,'2024-12-27 13:34:50',420465,26989,'','',30,0,0.00898,2.38,0,'OK - 192.168.77.29: rta 0.148ms, lost 0%','rta=0.148ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627976,2,23549,0,0,1,10,0,1,'2024-12-27 13:34:50',420833,'2024-12-27 13:34:50',436066,26989,'','',30,0,0.014,0,0,'OK - 84.38.95.222: rta 0.382ms, lost 0%','rta=0.382ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627977,2,23554,0,0,1,1,0,1,'2024-12-27 13:34:55',469026,'2024-12-27 13:34:55',480012,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627978,2,23548,0,0,1,5,1,1,'2024-12-27 13:34:51',439767,'2024-12-27 13:34:55',480887,26989,'','',30,0,2.00759,0.439,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627979,2,23552,0,0,1,1,0,1,'2024-12-27 13:34:56',484658,'2024-12-27 13:35:00',536055,26989,'','',30,0,0.00971,0.484,0,'OK - 192.168.77.8: rta 0.124ms, lost 0%','rta=0.124ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627980,2,23549,0,0,1,10,0,1,'2024-12-27 13:34:56',488048,'2024-12-27 13:35:00',536268,26989,'','',30,0,0.01406,0.488,0,'OK - 84.38.95.222: rta 0.356ms, lost 0%','rta=0.356ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627981,2,21397,0,0,1,5,1,1,'2024-12-27 13:34:56',491736,'2024-12-27 13:35:00',536766,26989,'','',30,0,2.00814,0.491,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627982,2,28279,0,0,1,1,0,1,'2024-12-27 13:35:00',539676,'2024-12-27 13:35:05',576814,26989,'','',30,0,0.00654,0.539,0,'OK - 192.168.77.9: rta 0.014ms, lost 0%','rta=0.014ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627983,2,28533,0,0,1,1,1,1,'2024-12-27 13:35:05',577157,'2024-12-27 13:35:07',586400,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627984,2,28533,0,0,1,1,1,1,'2024-12-27 13:35:07',588972,'2024-12-27 13:35:10',642360,26989,'','',30,0,0.99555,2.588,2,'CRITICAL - 172.50.1.3: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627985,2,23554,0,0,1,1,0,1,'2024-12-27 13:35:10',644751,'2024-12-27 13:35:15',671680,26989,'','',30,0,0.00976,0.644,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627986,2,21397,0,0,1,5,1,1,'2024-12-27 13:35:15',671731,'2024-12-27 13:35:17',680840,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627987,2,23553,0,0,1,10,1,1,'2024-12-27 13:35:17',681188,'2024-12-27 13:35:18',680911,26989,'','',30,0,1,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627988,2,23549,0,0,1,10,0,1,'2024-12-27 13:35:20',725985,'2024-12-27 13:35:20',737512,26989,'','',30,0,0.011,0,0,'OK - 84.38.95.222: rta 0.199ms, lost 0%','rta=0.199ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627989,2,23553,0,0,1,10,1,1,'2024-12-27 13:35:20',740014,'2024-12-27 13:35:25',770495,26989,'','',30,0,2.00749,0.739,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627990,2,28533,0,0,1,1,1,1,'2024-12-27 13:35:25',770844,'2024-12-27 13:35:27',780313,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627991,2,23551,0,0,1,1,0,1,'2024-12-27 13:35:30',819916,'2024-12-27 13:35:30',831239,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627992,2,21396,0,0,1,5,0,1,'2024-12-27 13:35:30',833832,'2024-12-27 13:35:35',877843,26989,'','',30,0,0.02146,0.833,0,'OK - 192.168.77.159: rta 0.777ms, lost 0%','rta=0.777ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627993,2,28279,0,0,1,1,0,1,'2024-12-27 13:35:35',877906,'2024-12-27 13:35:35',885939,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627994,2,23552,0,0,1,1,0,1,'2024-12-27 13:35:35',886268,'2024-12-27 13:35:35',895424,26989,'','',30,0,0.008,0,0,'OK - 192.168.77.8: rta 0.114ms, lost 0%','rta=0.114ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627995,2,21397,0,0,1,5,1,1,'2024-12-27 13:35:45',957462,'2024-12-27 13:35:47',967994,26989,'','',30,0,2.01,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627996,2,23553,0,0,1,10,1,1,'2024-12-27 13:35:47',968358,'2024-12-27 13:35:48',967169,26989,'','',30,0,0.999,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627997,2,23554,0,0,1,1,0,1,'2024-12-27 13:35:48',967803,'2024-12-27 13:35:48',977893,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276627998,2,21395,0,0,1,5,1,1,'2024-12-27 13:35:48',980528,'2024-12-27 13:35:51',1131,26989,'','',30,0,2.00772,3.98,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276627999,2,23551,0,0,1,1,0,1,'2024-12-27 13:35:51',11905,'2024-12-27 13:35:55',15063,26989,'','',30,0,0.00978,1.027,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628000,2,28533,0,0,1,1,1,1,'2024-12-27 13:35:55',235,'2024-12-27 13:35:57',19229,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628001,2,23548,0,0,1,5,1,1,'2024-12-27 13:35:57',3204,'2024-12-27 13:36:00',0,26989,'','',30,0,2.00748,2.062,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628002,2,23552,0,0,1,1,0,1,'2024-12-27 13:36:00',0,'2024-12-27 13:36:05',105774,26989,'','',30,0,0.00959,0.084,0,'OK - 192.168.77.8: rta 0.147ms, lost 0%','rta=0.147ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628003,2,23549,0,0,1,10,0,1,'2024-12-27 13:36:00',0,'2024-12-27 13:36:05',106037,26989,'','',30,0,0.0126,0.088,0,'OK - 84.38.95.222: rta 0.305ms, lost 0%','rta=0.305ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628004,2,21397,0,0,1,5,1,1,'2024-12-27 13:36:00',0,'2024-12-27 13:36:05',106293,26989,'','',30,0,2.00811,0.091,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628005,2,23553,0,0,1,10,1,1,'2024-12-27 13:36:05',106645,'2024-12-27 13:36:07',135807,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628006,2,23551,0,0,1,1,0,1,'2024-12-27 13:36:07',136145,'2024-12-27 13:36:07',146364,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628007,2,28279,0,0,1,1,0,1,'2024-12-27 13:36:07',148966,'2024-12-27 13:36:10',161696,26989,'','',30,0,0.00615,2.148,0,'OK - 192.168.77.9: rta 0.014ms, lost 0%','rta=0.014ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628008,2,23554,0,0,1,1,0,1,'2024-12-27 13:36:10',161758,'2024-12-27 13:36:10',173058,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628009,2,28533,0,0,1,1,1,1,'2024-12-27 13:36:10',175778,'2024-12-27 13:36:15',191572,26989,'','',30,0,2.00848,0.175,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628010,2,23554,0,0,1,1,0,1,'2024-12-27 13:36:15',200248,'2024-12-27 13:36:20',213526,26989,'','',30,0,0.01016,0.2,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628011,2,21395,0,0,1,5,1,1,'2024-12-27 13:36:25',234610,'2024-12-27 13:36:27',244171,26989,'','',30,0,2.009,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628012,2,23552,0,0,1,1,0,1,'2024-12-27 13:36:27',244497,'2024-12-27 13:36:27',254336,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.135ms, lost 0%','rta=0.135ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628013,2,23551,0,0,1,1,0,1,'2024-12-27 13:36:27',254653,'2024-12-27 13:36:27',264506,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628014,2,28533,0,0,1,1,1,1,'2024-12-27 13:36:30',287396,'2024-12-27 13:36:32',296218,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628015,2,23553,0,0,1,10,1,1,'2024-12-27 13:36:27',267084,'2024-12-27 13:36:32',296975,26989,'','',30,0,2.00643,2.267,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628016,2,23548,0,0,1,5,1,1,'2024-12-27 13:36:32',297045,'2024-12-27 13:36:34',305636,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628017,2,21396,0,0,1,5,0,1,'2024-12-27 13:36:35',327067,'2024-12-27 13:36:40',343750,26989,'','',30,0,0.02108,0.327,0,'OK - 192.168.77.159: rta 0.738ms, lost 0%','rta=0.738ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628018,2,23554,0,0,1,1,0,1,'2024-12-27 13:36:50',389915,'2024-12-27 13:36:50',400939,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628019,2,23553,0,0,1,10,1,1,'2024-12-27 13:36:50',401241,'2024-12-27 13:36:51',528252,26989,'','',30,0,1.126,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628020,2,23552,0,0,1,1,0,1,'2024-12-27 13:36:51',528534,'2024-12-27 13:36:51',537974,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.122ms, lost 0%','rta=0.122ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628021,2,21395,0,0,1,5,1,1,'2024-12-27 13:36:51',538695,'2024-12-27 13:36:53',548026,26989,'','',30,0,2.009,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628022,2,21395,0,0,1,5,1,1,'2024-12-27 13:36:53',554164,'2024-12-27 13:36:55',562075,26989,'','',30,0,0.99203,2.554,2,'CRITICAL - 192.168.77.154: Host unreachable @ 192.168.77.9. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628023,2,23551,0,0,1,1,0,1,'2024-12-27 13:36:55',564432,'2024-12-27 13:37:00',581101,26989,'','',30,0,0.00983,0.564,0,'OK - 192.168.77.29: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628024,2,28533,0,0,1,1,1,1,'2024-12-27 13:37:00',581962,'2024-12-27 13:37:02',592862,26989,'','',30,0,2.01,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628025,2,23548,0,0,1,5,1,1,'2024-12-27 13:37:02',595634,'2024-12-27 13:37:05',608301,26989,'','',30,0,2.00814,2.595,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628026,2,23552,0,0,1,1,0,1,'2024-12-27 13:37:05',610714,'2024-12-27 13:37:10',632928,26989,'','',30,0,0.01156,0.61,0,'OK - 192.168.77.8: rta 0.237ms, lost 0%','rta=0.237ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628027,2,23549,0,0,1,10,0,1,'2024-12-27 13:37:05',614057,'2024-12-27 13:37:10',633164,26989,'','',30,0,0.0112,0.613,0,'OK - 84.38.95.222: rta 0.203ms, lost 0%','rta=0.203ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628028,2,28279,0,0,1,1,0,1,'2024-12-27 13:37:10',633503,'2024-12-27 13:37:10',642142,26989,'','',30,0,0.008,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628029,2,21397,0,0,1,5,1,1,'2024-12-27 13:37:05',617001,'2024-12-27 13:37:10',642633,26989,'','',30,0,2.00923,0.616,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628030,2,28279,0,0,1,1,0,1,'2024-12-27 13:37:10',645151,'2024-12-27 13:37:15',659400,26989,'','',30,0,0.0061,0.645,0,'OK - 192.168.77.9: rta 0.014ms, lost 0%','rta=0.014ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628031,2,21396,0,0,1,5,0,1,'2024-12-27 13:37:20',706174,'2024-12-27 13:37:20',727859,26989,'','',30,0,0.021,0,0,'OK - 192.168.77.159: rta 0.695ms, lost 0%','rta=0.695ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628032,2,28533,0,0,1,1,1,1,'2024-12-27 13:37:15',661927,'2024-12-27 13:37:20',728386,26989,'','',30,0,2.00941,0.661,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628033,2,23553,0,0,1,10,1,1,'2024-12-27 13:37:20',728444,'2024-12-27 13:37:22',736837,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628034,2,23554,0,0,1,1,0,1,'2024-12-27 13:37:25',760530,'2024-12-27 13:37:25',770874,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628035,2,23554,0,0,1,1,0,1,'2024-12-27 13:37:22',739634,'2024-12-27 13:37:25',771362,26989,'','',30,0,0.00954,2.739,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628036,2,23553,0,0,1,10,1,1,'2024-12-27 13:37:32',802927,'2024-12-27 13:37:35',823834,26989,'','',30,0,2.00819,0.802,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628037,2,21396,0,0,1,5,0,1,'2024-12-27 13:37:40',856349,'2024-12-27 13:37:45',882213,26989,'','',30,0,0.02895,0.856,0,'OK - 192.168.77.159: rta 1.083ms, lost 0%','rta=1.083ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628038,2,23552,0,0,1,1,0,1,'2024-12-27 13:37:45',882273,'2024-12-27 13:37:45',892258,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.117ms, lost 0%','rta=0.117ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628039,2,23549,0,0,1,10,0,1,'2024-12-27 13:37:50',929522,'2024-12-27 13:37:50',947290,26989,'','',30,0,0.017,0,0,'OK - 84.38.95.222: rta 0.505ms, lost 0%','rta=0.505ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628040,2,23554,0,0,1,1,0,1,'2024-12-27 13:37:55',982608,'2024-12-27 13:37:55',993957,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628041,2,23551,0,0,1,1,0,1,'2024-12-27 13:37:55',994319,'2024-12-27 13:37:56',2144,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628042,2,21395,0,0,1,5,1,1,'2024-12-27 13:37:56',3582,'2024-12-27 13:38:00',1,26989,'','',30,0,2.00753,1.006,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628043,2,23551,0,0,1,1,0,1,'2024-12-27 13:38:00',1198,'2024-12-27 13:38:05',2217,26989,'','',30,0,0.00939,0.022,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628044,2,28533,0,0,1,1,1,1,'2024-12-27 13:38:10',5,'2024-12-27 13:38:12',6,26989,'','',30,0,2.01,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628045,2,23548,0,0,1,5,1,1,'2024-12-27 13:38:05',18993,'2024-12-27 13:38:12',28781,26989,'','',30,0,2.00827,0.045,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628046,2,23552,0,0,1,1,0,1,'2024-12-27 13:38:12',28812,'2024-12-27 13:38:12',0,26989,'','',30,0,0.025,0,0,'OK - 192.168.77.8: rta 0.140ms, lost 0%','rta=0.140ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628047,2,23552,0,0,1,1,0,1,'2024-12-27 13:38:12',0,'2024-12-27 13:38:15',115269,26989,'','',30,0,0.01122,2.098,0,'OK - 192.168.77.8: rta 0.268ms, lost 0%','rta=0.268ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628048,2,23549,0,0,1,10,0,1,'2024-12-27 13:38:12',101494,'2024-12-27 13:38:15',115469,26989,'','',30,0,0.01744,2.101,0,'OK - 84.38.95.222: rta 0.541ms, lost 0%','rta=0.541ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628049,2,21397,0,0,1,5,1,1,'2024-12-27 13:38:12',102271,'2024-12-27 13:38:15',115671,26989,'','',30,0,0.05251,2.102,2,'CRITICAL - 172.20.3.10: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628050,2,23553,0,0,1,10,1,1,'2024-12-27 13:38:15',115941,'2024-12-27 13:38:17',125060,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628051,2,28279,0,0,1,1,0,1,'2024-12-27 13:38:17',141976,'2024-12-27 13:38:20',153990,26989,'','',30,0,0.00735,2.141,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628052,2,23554,0,0,1,1,0,1,'2024-12-27 13:38:20',154080,'2024-12-27 13:38:20',165078,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628053,2,28533,0,0,1,1,1,1,'2024-12-27 13:38:20',167846,'2024-12-27 13:38:25',203208,26989,'','',30,0,2.00667,0.167,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628054,2,23554,0,0,1,1,0,1,'2024-12-27 13:38:25',205915,'2024-12-27 13:38:30',235745,26989,'','',30,0,0.0094,0.205,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628055,2,23551,0,0,1,1,0,1,'2024-12-27 13:38:30',236096,'2024-12-27 13:38:30',247101,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628056,2,28279,0,0,1,1,0,1,'2024-12-27 13:38:35',263485,'2024-12-27 13:38:35',271547,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628057,2,23552,0,0,1,1,0,1,'2024-12-27 13:38:35',271954,'2024-12-27 13:38:35',282476,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.119ms, lost 0%','rta=0.119ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628058,2,23553,0,0,1,10,1,1,'2024-12-27 13:38:35',285096,'2024-12-27 13:38:40',297174,26989,'','',30,0,0.07813,0.285,2,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628059,2,21397,0,0,1,5,1,1,'2024-12-27 13:38:45',317545,'2024-12-27 13:38:47',326806,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628060,2,23554,0,0,1,1,0,1,'2024-12-27 13:38:47',327597,'2024-12-27 13:38:47',337748,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628061,2,21396,0,0,1,5,0,1,'2024-12-27 13:38:47',340235,'2024-12-27 13:38:50',348648,26989,'','',30,0,0.02179,2.34,0,'OK - 192.168.77.159: rta 0.783ms, lost 0%','rta=0.783ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628062,2,28533,0,0,1,1,1,1,'2024-12-27 13:38:55',364769,'2024-12-27 13:38:57',374448,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628063,2,23551,0,0,1,1,0,1,'2024-12-27 13:39:00',391155,'2024-12-27 13:39:00',402038,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628064,2,21395,0,0,1,5,1,1,'2024-12-27 13:39:00',404528,'2024-12-27 13:39:05',429393,26989,'','',30,0,2.00656,0.404,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628065,2,23552,0,0,1,1,0,1,'2024-12-27 13:39:05',429466,'2024-12-27 13:39:05',439782,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.135ms, lost 0%','rta=0.135ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628066,2,23553,0,0,1,10,1,1,'2024-12-27 13:39:05',440154,'2024-12-27 13:39:07',448599,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628067,2,23551,0,0,1,1,0,1,'2024-12-27 13:39:07',451439,'2024-12-27 13:39:10',475547,26989,'','',30,0,0.00915,2.451,0,'OK - 192.168.77.29: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628068,2,23548,0,0,1,5,1,1,'2024-12-27 13:39:10',475615,'2024-12-27 13:39:12',483955,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628069,2,23554,0,0,1,1,0,1,'2024-12-27 13:39:12',484274,'2024-12-27 13:39:12',494202,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628070,2,23548,0,0,1,5,1,1,'2024-12-27 13:39:12',499904,'2024-12-27 13:39:15',517470,26989,'','',30,0,0.98322,0.499,2,'CRITICAL - 172.20.3.11: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628071,2,23552,0,0,1,1,0,1,'2024-12-27 13:39:15',525574,'2024-12-27 13:39:20',562715,26989,'','',30,0,0.0098,0.525,0,'OK - 192.168.77.8: rta 0.133ms, lost 0%','rta=0.133ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628072,2,23549,0,0,1,10,0,1,'2024-12-27 13:39:15',526610,'2024-12-27 13:39:20',562954,26989,'','',30,0,0.01891,0.526,0,'OK - 84.38.95.222: rta 0.504ms, lost 0%','rta=0.504ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628073,2,21397,0,0,1,5,1,1,'2024-12-27 13:39:15',529265,'2024-12-27 13:39:20',563209,26989,'','',30,0,2.00774,0.529,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628074,2,28279,0,0,1,1,0,1,'2024-12-27 13:39:20',572789,'2024-12-27 13:39:25',599161,26989,'','',30,0,0.00693,0.572,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628075,2,21395,0,0,1,5,1,1,'2024-12-27 13:39:25',599221,'2024-12-27 13:39:27',607751,26989,'','',30,0,2.008,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628076,2,23551,0,0,1,1,0,1,'2024-12-27 13:39:27',608375,'2024-12-27 13:39:27',618411,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628077,2,28533,0,0,1,1,1,1,'2024-12-27 13:39:30',663760,'2024-12-27 13:39:32',673868,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628078,2,28533,0,0,1,1,1,1,'2024-12-27 13:39:27',621192,'2024-12-27 13:39:32',674538,26989,'','',30,0,2.00815,2.621,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628079,2,23548,0,0,1,5,1,1,'2024-12-27 13:39:32',674590,'2024-12-27 13:39:34',683448,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628080,2,23552,0,0,1,1,0,1,'2024-12-27 13:39:34',683721,'2024-12-27 13:39:34',693095,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.120ms, lost 0%','rta=0.120ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628081,2,23554,0,0,1,1,0,1,'2024-12-27 13:39:34',695822,'2024-12-27 13:39:35',718041,26989,'','',30,0,0.00972,4.695,0,'OK - 192.168.77.208: rta 0.148ms, lost 0%','rta=0.148ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628082,2,23553,0,0,1,10,1,1,'2024-12-27 13:39:40',769883,'2024-12-27 13:39:42',779556,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628083,2,28533,0,0,1,1,1,1,'2024-12-27 13:39:45',806643,'2024-12-27 13:39:47',815941,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628084,2,23553,0,0,1,10,1,1,'2024-12-27 13:39:42',782203,'2024-12-27 13:39:47',816447,26989,'','',30,0,0.99562,2.782,2,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628085,2,23554,0,0,1,1,0,1,'2024-12-27 13:39:50',861153,'2024-12-27 13:39:50',872676,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628086,2,23552,0,0,1,1,0,1,'2024-12-27 13:39:50',873340,'2024-12-27 13:39:50',882655,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.116ms, lost 0%','rta=0.116ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628087,2,21395,0,0,1,5,1,1,'2024-12-27 13:39:50',883532,'2024-12-27 13:39:51',832378,26989,'','',30,0,0.949,0,1,'CRITICAL - 192.168.77.154: Host unreachable @ 192.168.77.9. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628088,2,21396,0,0,1,5,0,1,'2024-12-27 13:39:51',834789,'2024-12-27 13:39:55',858179,26989,'','',30,0,0.02796,1.834,0,'OK - 192.168.77.159: rta 1.093ms, lost 0%','rta=1.093ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628089,2,23551,0,0,1,1,0,1,'2024-12-27 13:40:00',899064,'2024-12-27 13:40:00',910514,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628090,2,28279,0,0,1,1,0,1,'2024-12-27 13:40:10',963973,'2024-12-27 13:40:10',971857,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628091,2,21395,0,0,1,5,1,1,'2024-12-27 13:40:05',925771,'2024-12-27 13:40:10',972371,26989,'','',30,0,2.00826,0.925,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628092,2,23551,0,0,1,1,0,1,'2024-12-27 13:40:10',974820,'2024-12-27 13:40:16',100,26989,'','',30,0,0.00888,0.974,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628093,2,23552,0,0,1,1,0,1,'2024-12-27 13:40:16',836,'2024-12-27 13:40:16',78,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.129ms, lost 0%','rta=0.129ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628094,2,21396,0,0,1,5,0,1,'2024-12-27 13:40:20',11902,'2024-12-27 13:40:20',4,26989,'','',30,0,0.021,0,0,'OK - 192.168.77.159: rta 0.712ms, lost 0%','rta=0.712ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628095,2,23548,0,0,1,5,1,1,'2024-12-27 13:40:16',6247,'2024-12-27 13:40:20',4,26989,'','',30,0,2.00749,1.014,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628096,2,23552,0,0,1,1,0,1,'2024-12-27 13:40:20',2668,'2024-12-27 13:40:25',29070,26989,'','',30,0,0.00966,0.051,0,'OK - 192.168.77.8: rta 0.187ms, lost 0%','rta=0.187ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628097,2,23553,0,0,1,10,1,1,'2024-12-27 13:40:25',3639,'2024-12-27 13:40:27',7,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628098,2,23549,0,0,1,10,0,1,'2024-12-27 13:40:20',43,'2024-12-27 13:40:27',0,26989,'','',30,0,0.0154,0.053,0,'OK - 84.38.95.222: rta 0.437ms, lost 0%','rta=0.437ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628099,2,21397,0,0,1,5,1,1,'2024-12-27 13:40:20',24202,'2024-12-27 13:40:27',0,26989,'','',30,0,2.00919,0.057,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628100,2,23554,0,0,1,1,0,1,'2024-12-27 13:40:27',0,'2024-12-27 13:40:27',102131,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628101,2,28279,0,0,1,1,0,1,'2024-12-27 13:40:27',104688,'2024-12-27 13:40:30',112188,26989,'','',30,0,0.00609,2.104,0,'OK - 192.168.77.9: rta 0.014ms, lost 0%','rta=0.014ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628102,2,28533,0,0,1,1,1,1,'2024-12-27 13:40:32',130071,'2024-12-27 13:40:35',142032,26989,'','',30,0,2.00828,0.13,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628103,2,23554,0,0,1,1,0,1,'2024-12-27 13:40:35',144617,'2024-12-27 13:40:40',171896,26989,'','',30,0,0.00952,0.144,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628104,2,23552,0,0,1,1,0,1,'2024-12-27 13:40:45',185019,'2024-12-27 13:40:45',195876,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.130ms, lost 0%','rta=0.130ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628105,2,23553,0,0,1,10,1,1,'2024-12-27 13:40:45',196189,'2024-12-27 13:40:47',204995,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628106,2,23553,0,0,1,10,1,1,'2024-12-27 13:40:47',207437,'2024-12-27 13:40:50',223271,26989,'','',30,0,0.99573,0.207,2,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628107,2,23549,0,0,1,10,0,1,'2024-12-27 13:40:50',223609,'2024-12-27 13:40:50',235247,26989,'','',30,0,0.011,0,0,'OK - 84.38.95.222: rta 0.198ms, lost 0%','rta=0.198ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628108,2,23554,0,0,1,1,0,1,'2024-12-27 13:40:55',250350,'2024-12-27 13:40:55',261251,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628109,2,23551,0,0,1,1,0,1,'2024-12-27 13:40:55',261577,'2024-12-27 13:40:55',271492,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.148ms, lost 0%','rta=0.148ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628110,2,21396,0,0,1,5,0,1,'2024-12-27 13:40:55',273984,'2024-12-27 13:41:00',311209,26989,'','',30,0,0.02027,0.273,0,'OK - 192.168.77.159: rta 0.714ms, lost 0%','rta=0.714ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628111,2,28533,0,0,1,1,1,1,'2024-12-27 13:41:05',329804,'2024-12-27 13:41:07',339134,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628112,2,23552,0,0,1,1,0,1,'2024-12-27 13:41:10',351890,'2024-12-27 13:41:10',363442,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.8: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628113,2,21395,0,0,1,5,1,1,'2024-12-27 13:41:10',365977,'2024-12-27 13:41:15',410702,26989,'','',30,0,2.00757,0.365,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628114,2,21397,0,0,1,5,1,1,'2024-12-27 13:41:15',410757,'2024-12-27 13:41:17',420425,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628115,2,23553,0,0,1,10,1,1,'2024-12-27 13:41:17',420750,'2024-12-27 13:41:18',418577,26989,'','',30,0,0.998,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628116,2,23551,0,0,1,1,0,1,'2024-12-27 13:41:18',421096,'2024-12-27 13:41:20',451683,26989,'','',30,0,0.01305,2.421,0,'OK - 192.168.77.29: rta 0.352ms, lost 0%','rta=0.352ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628117,2,23554,0,0,1,1,0,1,'2024-12-27 13:41:20',451743,'2024-12-27 13:41:20',462318,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628118,2,23549,0,0,1,10,0,1,'2024-12-27 13:41:20',462712,'2024-12-27 13:41:20',481201,26989,'','',30,0,0.018,0,0,'OK - 84.38.95.222: rta 0.512ms, lost 0%','rta=0.512ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628119,2,23548,0,0,1,5,1,1,'2024-12-27 13:41:20',483810,'2024-12-27 13:41:25',519612,26989,'','',30,0,2.00878,0.483,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628120,2,28533,0,0,1,1,1,1,'2024-12-27 13:41:25',519919,'2024-12-27 13:41:27',530727,26989,'','',30,0,2.01,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628121,2,23552,0,0,1,1,0,1,'2024-12-27 13:41:27',533207,'2024-12-27 13:41:30',575849,26989,'','',30,0,0.00913,2.533,0,'OK - 192.168.77.8: rta 0.142ms, lost 0%','rta=0.142ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628122,2,23549,0,0,1,10,0,1,'2024-12-27 13:41:27',545394,'2024-12-27 13:41:30',576092,26989,'','',30,0,0.01241,0.545,0,'OK - 84.38.95.222: rta 0.300ms, lost 0%','rta=0.300ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628123,2,21397,0,0,1,5,1,1,'2024-12-27 13:41:27',548920,'2024-12-27 13:41:30',576834,26989,'','',30,0,2.008,0.548,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628124,2,28279,0,0,1,1,0,1,'2024-12-27 13:41:30',578966,'2024-12-27 13:41:35',616787,26989,'','',30,0,0.00725,0.578,0,'OK - 192.168.77.9: rta 0.014ms, lost 0%','rta=0.014ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628125,2,28533,0,0,1,1,1,1,'2024-12-27 13:41:35',619572,'2024-12-27 13:41:40',648841,26989,'','',30,0,2.00855,0.619,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628126,2,23551,0,0,1,1,0,1,'2024-12-27 13:41:40',648901,'2024-12-27 13:41:40',659408,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628127,2,23554,0,0,1,1,0,1,'2024-12-27 13:41:40',664385,'2024-12-27 13:41:45',705100,26989,'','',30,0,0.00936,0.664,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628128,2,21397,0,0,1,5,1,1,'2024-12-27 13:41:45',705177,'2024-12-27 13:41:47',715273,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628129,2,23553,0,0,1,10,1,1,'2024-12-27 13:41:47',715642,'2024-12-27 13:41:48',714584,26989,'','',30,0,0.999,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628130,2,28533,0,0,1,1,1,1,'2024-12-27 13:41:55',766731,'2024-12-27 13:41:56',829724,26989,'','',30,0,1.062,0,1,'CRITICAL - 172.50.1.3: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628131,2,23553,0,0,1,10,1,1,'2024-12-27 13:41:50',735941,'2024-12-27 13:41:56',830232,26989,'','',30,0,2.00966,0.735,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628132,2,23551,0,0,1,1,0,1,'2024-12-27 13:42:00',876342,'2024-12-27 13:42:00',887565,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628133,2,21396,0,0,1,5,0,1,'2024-12-27 13:42:00',890439,'2024-12-27 13:42:05',909233,26989,'','',30,0,0.02017,0.89,0,'OK - 192.168.77.159: rta 0.705ms, lost 0%','rta=0.705ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628134,2,23552,0,0,1,1,0,1,'2024-12-27 13:42:05',909303,'2024-12-27 13:42:05',919275,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.121ms, lost 0%','rta=0.121ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628135,2,23548,0,0,1,5,1,1,'2024-12-27 13:42:10',943926,'2024-12-27 13:42:12',954090,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628136,2,23554,0,0,1,1,0,1,'2024-12-27 13:42:12',954453,'2024-12-27 13:42:12',965775,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628137,2,21395,0,0,1,5,1,1,'2024-12-27 13:42:16',1636,'2024-12-27 13:42:20',7554,26989,'','',30,0,2.00876,1.003,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628138,2,23551,0,0,1,1,0,1,'2024-12-27 13:42:20',170,'2024-12-27 13:42:25',31,26989,'','',30,0,0.00952,0.025,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628139,2,23552,0,0,1,1,0,1,'2024-12-27 13:42:25',3,'2024-12-27 13:42:25',4,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.137ms, lost 0%','rta=0.137ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628140,2,28533,0,0,1,1,1,1,'2024-12-27 13:42:30',31750,'2024-12-27 13:42:32',0,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628141,2,23548,0,0,1,5,1,1,'2024-12-27 13:42:25',2647,'2024-12-27 13:42:32',0,26989,'','',30,0,2.00766,0.051,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628142,2,23552,0,0,1,1,0,1,'2024-12-27 13:42:32',0,'2024-12-27 13:42:35',104969,26989,'','',30,0,0.00895,2.089,0,'OK - 192.168.77.8: rta 0.137ms, lost 0%','rta=0.137ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628143,2,23549,0,0,1,10,0,1,'2024-12-27 13:42:32',0,'2024-12-27 13:42:35',105188,26989,'','',30,0,0.01057,2.092,0,'OK - 84.38.95.222: rta 0.200ms, lost 0%','rta=0.200ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628144,2,21397,0,0,1,5,1,1,'2024-12-27 13:42:32',0,'2024-12-27 13:42:35',105410,26989,'','',30,0,2.00809,2.096,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628145,2,28279,0,0,1,1,0,1,'2024-12-27 13:42:35',117389,'2024-12-27 13:42:40',132271,26989,'','',30,0,0.00742,0.117,0,'OK - 192.168.77.9: rta 0.016ms, lost 0%','rta=0.016ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628146,2,23553,0,0,1,10,1,1,'2024-12-27 13:42:40',132603,'2024-12-27 13:42:42',141558,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628147,2,23551,0,0,1,1,0,1,'2024-12-27 13:42:42',160377,'2024-12-27 13:42:42',170640,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628148,2,28533,0,0,1,1,1,1,'2024-12-27 13:42:42',173132,'2024-12-27 13:42:45',182640,26989,'','',30,0,2.00775,2.173,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628149,2,23554,0,0,1,1,0,1,'2024-12-27 13:42:45',184887,'2024-12-27 13:42:50',212923,26989,'','',30,0,0.01022,0.184,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628150,2,23552,0,0,1,1,0,1,'2024-12-27 13:42:50',213571,'2024-12-27 13:42:50',224417,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.125ms, lost 0%','rta=0.125ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628151,2,21395,0,0,1,5,1,1,'2024-12-27 13:42:50',225213,'2024-12-27 13:42:51',204763,26989,'','',30,0,0.98,0,1,'CRITICAL - 192.168.77.154: Host unreachable @ 192.168.77.9. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628152,2,23553,0,0,1,10,1,1,'2024-12-27 13:42:56',222326,'2024-12-27 13:43:00',241250,26989,'','',30,0,2.0084,0.222,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628153,2,23551,0,0,1,1,0,1,'2024-12-27 13:43:00',241564,'2024-12-27 13:43:00',252581,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628154,2,28533,0,0,1,1,1,1,'2024-12-27 13:43:00',252916,'2024-12-27 13:43:02',261629,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628155,2,21396,0,0,1,5,0,1,'2024-12-27 13:43:05',275089,'2024-12-27 13:43:10',296201,26989,'','',30,0,0.021,0.275,0,'OK - 192.168.77.159: rta 0.722ms, lost 0%','rta=0.722ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628156,2,28279,0,0,1,1,0,1,'2024-12-27 13:43:10',296534,'2024-12-27 13:43:10',304243,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628157,2,23552,0,0,1,1,0,1,'2024-12-27 13:43:15',318545,'2024-12-27 13:43:15',328477,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.119ms, lost 0%','rta=0.119ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628158,2,23553,0,0,1,10,1,1,'2024-12-27 13:43:20',370397,'2024-12-27 13:43:22',379021,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628159,2,23554,0,0,1,1,0,1,'2024-12-27 13:43:25',398658,'2024-12-27 13:43:25',410018,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628160,2,21395,0,0,1,5,1,1,'2024-12-27 13:43:22',381779,'2024-12-27 13:43:25',410503,26989,'','',30,0,2.00739,2.381,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628161,2,23551,0,0,1,1,0,1,'2024-12-27 13:43:25',412739,'2024-12-27 13:43:30',437437,26989,'','',30,0,0.00904,0.412,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628162,2,23548,0,0,1,5,1,1,'2024-12-27 13:43:32',446011,'2024-12-27 13:43:35',695853,26989,'','',30,0,2.00876,0.445,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628163,2,23552,0,0,1,1,0,1,'2024-12-27 13:43:35',698373,'2024-12-27 13:43:40',730411,26989,'','',30,0,0.0093,0.698,0,'OK - 192.168.77.8: rta 0.145ms, lost 0%','rta=0.145ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628164,2,23549,0,0,1,10,0,1,'2024-12-27 13:43:35',701635,'2024-12-27 13:43:40',730638,26989,'','',30,0,0.01134,0.701,0,'OK - 84.38.95.222: rta 0.217ms, lost 0%','rta=0.217ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628165,2,21397,0,0,1,5,1,1,'2024-12-27 13:43:35',704549,'2024-12-27 13:43:40',730885,26989,'','',30,0,2.00941,0.704,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628166,2,28279,0,0,1,1,0,1,'2024-12-27 13:43:40',733153,'2024-12-27 13:43:45',764944,26989,'','',30,0,0.00716,0.733,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628167,2,23553,0,0,1,10,1,1,'2024-12-27 13:43:45',765273,'2024-12-27 13:43:47',774272,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628168,2,28533,0,0,1,1,1,1,'2024-12-27 13:43:47',776767,'2024-12-27 13:43:50',812706,26989,'','',30,0,2.00687,2.776,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628169,2,23554,0,0,1,1,0,1,'2024-12-27 13:43:50',814924,'2024-12-27 13:43:55',847383,26989,'','',30,0,0.0097,0.814,0,'OK - 192.168.77.208: rta 0.154ms, lost 0%','rta=0.154ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628170,2,23551,0,0,1,1,0,1,'2024-12-27 13:43:55',847750,'2024-12-27 13:43:55',858677,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628171,2,23553,0,0,1,10,1,1,'2024-12-27 13:44:00',900716,'2024-12-27 13:44:05',931124,26989,'','',30,0,2.0079,0.9,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628172,2,28533,0,0,1,1,1,1,'2024-12-27 13:44:05',931463,'2024-12-27 13:44:07',941873,26989,'','',30,0,2.01,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628173,2,23552,0,0,1,1,0,1,'2024-12-27 13:44:10',975610,'2024-12-27 13:44:10',986344,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.124ms, lost 0%','rta=0.124ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628174,2,21396,0,0,1,5,0,1,'2024-12-27 13:44:10',988989,'2024-12-27 13:44:15',624,26989,'','',30,0,0.02041,0.988,0,'OK - 192.168.77.159: rta 0.731ms, lost 0%','rta=0.731ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628175,2,21397,0,0,1,5,1,1,'2024-12-27 13:44:15',656,'2024-12-27 13:44:17',0,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628176,2,23553,0,0,1,10,1,1,'2024-12-27 13:44:20',17209,'2024-12-27 13:44:22',21632,26989,'','',30,0,2.01,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628177,2,23549,0,0,1,10,0,1,'2024-12-27 13:44:22',57,'2024-12-27 13:44:22',0,26989,'','',30,0,0.01,0,0,'OK - 84.38.95.222: rta 0.199ms, lost 0%','rta=0.199ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628178,2,23554,0,0,1,1,0,1,'2024-12-27 13:44:22',0,'2024-12-27 13:44:22',0,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628179,2,28533,0,0,1,1,1,1,'2024-12-27 13:44:25',106012,'2024-12-27 13:44:27',115769,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628180,2,23551,0,0,1,1,0,1,'2024-12-27 13:44:30',143122,'2024-12-27 13:44:30',154379,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628181,2,21395,0,0,1,5,1,1,'2024-12-27 13:44:27',128863,'2024-12-27 13:44:30',154895,26989,'','',30,0,2.00734,2.128,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628182,2,23551,0,0,1,1,0,1,'2024-12-27 13:44:30',157171,'2024-12-27 13:44:35',176162,26989,'','',30,0,0.00886,0.157,0,'OK - 192.168.77.29: rta 0.148ms, lost 0%','rta=0.148ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628183,2,28279,0,0,1,1,0,1,'2024-12-27 13:44:35',176222,'2024-12-27 13:44:35',184034,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628184,2,23552,0,0,1,1,0,1,'2024-12-27 13:44:35',184367,'2024-12-27 13:44:35',193388,26989,'','',30,0,0.008,0,0,'OK - 192.168.77.8: rta 0.110ms, lost 0%','rta=0.110ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628185,2,23548,0,0,1,5,1,1,'2024-12-27 13:44:35',195918,'2024-12-27 13:44:40',207270,26989,'','',30,0,0.07725,0.195,2,'CRITICAL - 172.20.3.11: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628186,2,23552,0,0,1,1,0,1,'2024-12-27 13:44:40',213206,'2024-12-27 13:44:45',235240,26989,'','',30,0,0.01059,0.213,0,'OK - 192.168.77.8: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628187,2,23549,0,0,1,10,0,1,'2024-12-27 13:44:40',216868,'2024-12-27 13:44:45',235463,26989,'','',30,0,0.01087,0.216,0,'OK - 84.38.95.222: rta 0.214ms, lost 0%','rta=0.214ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628188,2,21397,0,0,1,5,1,1,'2024-12-27 13:44:40',220179,'2024-12-27 13:44:45',235689,26989,'','',30,0,0.05401,0.22,2,'CRITICAL - 172.20.3.10: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628189,2,23553,0,0,1,10,1,1,'2024-12-27 13:44:45',235985,'2024-12-27 13:44:47',246489,26989,'','',30,0,2.01,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628190,2,23554,0,0,1,1,0,1,'2024-12-27 13:44:47',247060,'2024-12-27 13:44:47',257208,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628191,2,28279,0,0,1,1,0,1,'2024-12-27 13:44:47',259767,'2024-12-27 13:44:50',445091,26989,'','',30,0,0.00623,2.259,0,'OK - 192.168.77.9: rta 0.014ms, lost 0%','rta=0.014ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628192,2,28533,0,0,1,1,1,1,'2024-12-27 13:44:50',447504,'2024-12-27 13:44:55',461134,26989,'','',30,0,1.09953,0.447,2,'CRITICAL - 172.50.1.3: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628193,2,23554,0,0,1,1,0,1,'2024-12-27 13:44:55',463802,'2024-12-27 13:45:00',484117,26989,'','',30,0,0.00938,0.463,0,'OK - 192.168.77.208: rta 0.148ms, lost 0%','rta=0.148ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628194,2,23551,0,0,1,1,0,1,'2024-12-27 13:45:00',484954,'2024-12-27 13:45:00',495896,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.148ms, lost 0%','rta=0.148ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628195,2,23552,0,0,1,1,0,1,'2024-12-27 13:45:05',535791,'2024-12-27 13:45:05',546340,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.129ms, lost 0%','rta=0.129ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628196,2,23553,0,0,1,10,1,1,'2024-12-27 13:45:05',546706,'2024-12-27 13:45:07',555878,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628197,2,23553,0,0,1,10,1,1,'2024-12-27 13:45:07',558854,'2024-12-27 13:45:10',582653,26989,'','',30,0,0.99415,2.558,2,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628198,2,23548,0,0,1,5,1,1,'2024-12-27 13:45:10',582719,'2024-12-27 13:45:12',593478,26989,'','',30,0,2.01,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628199,2,23554,0,0,1,1,0,1,'2024-12-27 13:45:12',593782,'2024-12-27 13:45:12',603851,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628200,2,21396,0,0,1,5,0,1,'2024-12-27 13:45:15',633302,'2024-12-27 13:45:20',657729,26989,'','',30,0,0.02095,0.633,0,'OK - 192.168.77.159: rta 0.715ms, lost 0%','rta=0.715ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628201,2,21395,0,0,1,5,1,1,'2024-12-27 13:45:25',693631,'2024-12-27 13:45:27',702038,26989,'','',30,0,2.008,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628202,2,23552,0,0,1,1,0,1,'2024-12-27 13:45:27',702393,'2024-12-27 13:45:27',711902,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.123ms, lost 0%','rta=0.123ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628203,2,23551,0,0,1,1,0,1,'2024-12-27 13:45:27',712241,'2024-12-27 13:45:27',722040,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628204,2,28533,0,0,1,1,1,1,'2024-12-27 13:45:30',758791,'2024-12-27 13:45:32',768224,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628205,2,23548,0,0,1,5,1,1,'2024-12-27 13:45:32',768823,'2024-12-27 13:45:34',777499,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628206,2,23551,0,0,1,1,0,1,'2024-12-27 13:45:35',822041,'2024-12-27 13:45:40',846673,26989,'','',30,0,0.01092,0.822,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628207,2,21395,0,0,1,5,1,1,'2024-12-27 13:45:34',780285,'2024-12-27 13:45:40',847193,26989,'','',30,0,2.00752,4.78,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628208,2,23553,0,0,1,10,1,1,'2024-12-27 13:45:40',847248,'2024-12-27 13:45:42',856558,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628209,2,23548,0,0,1,5,1,1,'2024-12-27 13:45:42',859425,'2024-12-27 13:45:45',883577,26989,'','',30,0,0.99617,2.859,2,'CRITICAL - 172.20.3.11: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628210,2,23552,0,0,1,1,0,1,'2024-12-27 13:45:45',886055,'2024-12-27 13:45:50',917664,26989,'','',30,0,0.01045,0.886,0,'OK - 192.168.77.8: rta 0.185ms, lost 0%','rta=0.185ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628211,2,23549,0,0,1,10,0,1,'2024-12-27 13:45:45',887558,'2024-12-27 13:45:50',917890,26989,'','',30,0,0.0136,0.887,0,'OK - 84.38.95.222: rta 0.262ms, lost 0%','rta=0.262ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628212,2,23554,0,0,1,1,0,1,'2024-12-27 13:45:50',917948,'2024-12-27 13:45:50',929400,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628213,2,21397,0,0,1,5,1,1,'2024-12-27 13:45:45',888969,'2024-12-27 13:45:50',930370,26989,'','',30,0,1.08857,0.888,2,'CRITICAL - 172.20.3.10: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628214,2,21395,0,0,1,5,1,1,'2024-12-27 13:45:50',930872,'2024-12-27 13:45:51',908995,26989,'','',30,0,0.978,0,1,'CRITICAL - 192.168.77.154: Host unreachable @ 192.168.77.9. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628215,2,28279,0,0,1,1,0,1,'2024-12-27 13:45:51',911530,'2024-12-27 13:45:55',957923,26989,'','',30,0,0.00639,1.911,0,'OK - 192.168.77.9: rta 0.014ms, lost 0%','rta=0.014ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628216,2,28533,0,0,1,1,1,1,'2024-12-27 13:45:55',960752,'2024-12-27 13:46:00',994200,26989,'','',30,0,2.00767,0.96,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628217,2,23551,0,0,1,1,0,1,'2024-12-27 13:46:00',994545,'2024-12-27 13:46:01',2969,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.29: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628218,2,23554,0,0,1,1,0,1,'2024-12-27 13:46:01',0,'2024-12-27 13:46:05',8838,26989,'','',30,0,0.00954,1.008,0,'OK - 192.168.77.208: rta 0.154ms, lost 0%','rta=0.154ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628219,2,28279,0,0,1,1,0,1,'2024-12-27 13:46:10',3,'2024-12-27 13:46:10',20058,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628220,2,23553,0,0,1,10,1,1,'2024-12-27 13:46:10',4,'2024-12-27 13:46:15',53,26989,'','',30,0,2.00824,0.049,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628221,2,23552,0,0,1,1,0,1,'2024-12-27 13:46:15',3459,'2024-12-27 13:46:15',61,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.122ms, lost 0%','rta=0.122ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628222,2,21396,0,0,1,5,0,1,'2024-12-27 13:46:20',105753,'2024-12-27 13:46:20',134073,26989,'','',30,0,0.028,0,0,'OK - 192.168.77.159: rta 1.066ms, lost 0%','rta=1.066ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628223,2,21396,0,0,1,5,0,1,'2024-12-27 13:46:20',137029,'2024-12-27 13:46:25',146215,26989,'','',30,0,0.0214,0.137,0,'OK - 192.168.77.159: rta 0.773ms, lost 0%','rta=0.773ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628224,2,23554,0,0,1,1,0,1,'2024-12-27 13:46:25',146269,'2024-12-27 13:46:25',156479,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628225,2,23551,0,0,1,1,0,1,'2024-12-27 13:46:40',221615,'2024-12-27 13:46:45',244067,26989,'','',30,0,0.00986,0.221,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628226,2,21395,0,0,1,5,1,1,'2024-12-27 13:46:40',224645,'2024-12-27 13:46:45',244306,26989,'','',30,0,2.00743,0.224,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628227,2,23552,0,0,1,1,0,1,'2024-12-27 13:46:45',244365,'2024-12-27 13:46:45',254555,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.143ms, lost 0%','rta=0.143ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628228,2,23553,0,0,1,10,1,1,'2024-12-27 13:46:45',254897,'2024-12-27 13:46:47',262881,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628229,2,23548,0,0,1,5,1,1,'2024-12-27 13:46:47',265451,'2024-12-27 13:46:50',302044,26989,'','',30,0,0.99556,2.265,2,'CRITICAL - 172.20.3.11: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628230,2,23549,0,0,1,10,0,1,'2024-12-27 13:46:50',302396,'2024-12-27 13:46:50',314321,26989,'','',30,0,0.011,0,0,'OK - 84.38.95.222: rta 0.199ms, lost 0%','rta=0.199ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628231,2,23552,0,0,1,1,0,1,'2024-12-27 13:46:50',316900,'2024-12-27 13:46:55',356614,26989,'','',30,0,0.01119,0.316,0,'OK - 192.168.77.8: rta 0.260ms, lost 0%','rta=0.260ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628232,2,23549,0,0,1,10,0,1,'2024-12-27 13:46:50',319636,'2024-12-27 13:46:55',356803,26989,'','',30,0,0.01273,0.319,0,'OK - 84.38.95.222: rta 0.310ms, lost 0%','rta=0.310ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628233,2,23554,0,0,1,1,0,1,'2024-12-27 13:46:55',356864,'2024-12-27 13:46:55',367374,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628234,2,21397,0,0,1,5,1,1,'2024-12-27 13:46:50',322957,'2024-12-27 13:46:55',367834,26989,'','',30,0,2.00986,0.322,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628235,2,28279,0,0,1,1,0,1,'2024-12-27 13:46:55',370310,'2024-12-27 13:47:00',410948,26989,'','',30,0,0.00611,0.37,0,'OK - 192.168.77.9: rta 0.016ms, lost 0%','rta=0.016ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628236,2,23551,0,0,1,1,0,1,'2024-12-27 13:47:00',411434,'2024-12-27 13:47:00',422009,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628237,2,28533,0,0,1,1,1,1,'2024-12-27 13:47:00',424895,'2024-12-27 13:47:05',467109,26989,'','',30,0,2.00958,0.424,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628238,2,23554,0,0,1,1,0,1,'2024-12-27 13:47:05',469892,'2024-12-27 13:47:10',504130,26989,'','',30,0,0.00978,0.469,0,'OK - 192.168.77.208: rta 0.160ms, lost 0%','rta=0.160ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628239,2,23552,0,0,1,1,0,1,'2024-12-27 13:47:10',504211,'2024-12-27 13:47:10',515826,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.8: rta 0.163ms, lost 0%','rta=0.163ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628240,2,21397,0,0,1,5,1,1,'2024-12-27 13:47:15',546486,'2024-12-27 13:47:17',557467,26989,'','',30,0,2.01,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628241,2,23553,0,0,1,10,1,1,'2024-12-27 13:47:17',557804,'2024-12-27 13:47:18',556729,26989,'','',30,0,0.999,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628242,2,23549,0,0,1,10,0,1,'2024-12-27 13:47:20',593548,'2024-12-27 13:47:20',607503,26989,'','',30,0,0.013,0,0,'OK - 84.38.95.222: rta 0.275ms, lost 0%','rta=0.275ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628243,2,23553,0,0,1,10,1,1,'2024-12-27 13:47:18',559515,'2024-12-27 13:47:20',608013,26989,'','',30,0,2.00823,3.559,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628244,2,28533,0,0,1,1,1,1,'2024-12-27 13:47:25',639696,'2024-12-27 13:47:27',648968,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628245,2,21396,0,0,1,5,0,1,'2024-12-27 13:47:27',651497,'2024-12-27 13:47:30',683377,26989,'','',30,0,0.02942,2.651,0,'OK - 192.168.77.159: rta 1.079ms, lost 0%','rta=1.079ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628246,2,23551,0,0,1,1,0,1,'2024-12-27 13:47:30',683705,'2024-12-27 13:47:30',694902,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628247,2,28279,0,0,1,1,0,1,'2024-12-27 13:47:35',731362,'2024-12-27 13:47:35',739674,26989,'','',30,0,0.008,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628248,2,23552,0,0,1,1,0,1,'2024-12-27 13:47:35',740037,'2024-12-27 13:47:35',749400,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.109ms, lost 0%','rta=0.109ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628249,2,21397,0,0,1,5,1,1,'2024-12-27 13:47:45',819012,'2024-12-27 13:47:47',829457,26989,'','',30,0,2.01,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628250,2,23553,0,0,1,10,1,1,'2024-12-27 13:47:47',829771,'2024-12-27 13:47:48',827569,26989,'','',30,0,0.998,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628251,2,23554,0,0,1,1,0,1,'2024-12-27 13:47:48',828113,'2024-12-27 13:47:48',838288,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628252,2,23551,0,0,1,1,0,1,'2024-12-27 13:47:48',840842,'2024-12-27 13:47:50',865728,26989,'','',30,0,0.01149,3.84,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628253,2,21395,0,0,1,5,1,1,'2024-12-27 13:47:48',843453,'2024-12-27 13:47:55',885729,26989,'','',30,0,2.00794,3.843,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628254,2,28533,0,0,1,1,1,1,'2024-12-27 13:47:55',885793,'2024-12-27 13:47:56',959589,26989,'','',30,0,1.073,0,1,'CRITICAL - 172.50.1.3: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628255,2,23548,0,0,1,5,1,1,'2024-12-27 13:47:50',868229,'2024-12-27 13:47:56',960045,26989,'','',30,0,2.00932,0.868,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628256,2,23552,0,0,1,1,0,1,'2024-12-27 13:47:56',962224,'2024-12-27 13:48:01',1651,26989,'','',30,0,0.00912,1.962,0,'OK - 192.168.77.8: rta 0.156ms, lost 0%','rta=0.156ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628257,2,23549,0,0,1,10,0,1,'2024-12-27 13:47:56',965167,'2024-12-27 13:48:01',27,26989,'','',30,0,0.01063,1.965,0,'OK - 84.38.95.222: rta 0.198ms, lost 0%','rta=0.198ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628258,2,21397,0,0,1,5,1,1,'2024-12-27 13:47:56',968174,'2024-12-27 13:48:01',280,26989,'','',30,0,2.00763,1.968,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628259,2,28279,0,0,1,1,0,1,'2024-12-27 13:48:01',6,'2024-12-27 13:48:05',8605,26989,'','',30,0,0.00711,1.006,0,'OK - 192.168.77.9: rta 0.016ms, lost 0%','rta=0.016ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628260,2,23553,0,0,1,10,1,1,'2024-12-27 13:48:05',16,'2024-12-27 13:48:07',12987,26989,'','',30,0,2.01,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628261,2,23551,0,0,1,1,0,1,'2024-12-27 13:48:07',319,'2024-12-27 13:48:07',47,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628262,2,23548,0,0,1,5,1,1,'2024-12-27 13:48:10',59,'2024-12-27 13:48:12',0,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628263,2,23554,0,0,1,1,0,1,'2024-12-27 13:48:12',0,'2024-12-27 13:48:12',104416,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628264,2,28533,0,0,1,1,1,1,'2024-12-27 13:48:07',24925,'2024-12-27 13:48:12',104961,26989,'','',30,0,2.00711,2.06,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628265,2,23554,0,0,1,1,0,1,'2024-12-27 13:48:12',107408,'2024-12-27 13:48:15',118092,26989,'','',30,0,0.01199,2.107,0,'OK - 192.168.77.208: rta 0.242ms, lost 0%','rta=0.242ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628266,2,21395,0,0,1,5,1,1,'2024-12-27 13:48:25',162985,'2024-12-27 13:48:27',171787,26989,'','',30,0,2.008,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628267,2,23552,0,0,1,1,0,1,'2024-12-27 13:48:27',172139,'2024-12-27 13:48:27',182689,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.125ms, lost 0%','rta=0.125ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628268,2,23551,0,0,1,1,0,1,'2024-12-27 13:48:27',183017,'2024-12-27 13:48:27',193598,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628269,2,23553,0,0,1,10,1,1,'2024-12-27 13:48:20',149397,'2024-12-27 13:48:27',194035,26989,'','',30,0,2.00746,0.149,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628270,2,28533,0,0,1,1,1,1,'2024-12-27 13:48:30',214928,'2024-12-27 13:48:32',224915,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628271,2,23548,0,0,1,5,1,1,'2024-12-27 13:48:32',225450,'2024-12-27 13:48:34',233350,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628272,2,21396,0,0,1,5,0,1,'2024-12-27 13:48:34',248252,'2024-12-27 13:48:35',253096,26989,'','',30,0,0.02784,4.248,0,'OK - 192.168.77.159: rta 1.088ms, lost 0%','rta=1.088ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628273,2,23553,0,0,1,10,1,1,'2024-12-27 13:48:40',283310,'2024-12-27 13:48:42',294491,26989,'','',30,0,2.01,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628274,2,23554,0,0,1,1,0,1,'2024-12-27 13:48:50',362420,'2024-12-27 13:48:50',372808,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628275,2,23552,0,0,1,1,0,1,'2024-12-27 13:48:50',373380,'2024-12-27 13:48:50',383335,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.129ms, lost 0%','rta=0.129ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628276,2,21395,0,0,1,5,1,1,'2024-12-27 13:48:55',421632,'2024-12-27 13:48:57',431831,26989,'','',30,0,2.009,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628277,2,23551,0,0,1,1,0,1,'2024-12-27 13:48:50',386442,'2024-12-27 13:48:57',432331,26989,'','',30,0,0.00955,0.386,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628278,2,23553,0,0,1,10,1,1,'2024-12-27 13:48:57',432397,'2024-12-27 13:48:59',441142,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628279,2,28533,0,0,1,1,1,1,'2024-12-27 13:49:00',463742,'2024-12-27 13:49:02',473780,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628280,2,23548,0,0,1,5,1,1,'2024-12-27 13:48:59',447392,'2024-12-27 13:49:05',516546,26989,'','',30,0,0.99186,3.447,2,'CRITICAL - 172.20.3.11: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628281,2,21395,0,0,1,5,1,1,'2024-12-27 13:48:59',443948,'2024-12-27 13:49:05',516758,26989,'','',30,0,2.00742,4.443,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628282,2,23552,0,0,1,1,0,1,'2024-12-27 13:49:02',476347,'2024-12-27 13:49:05',516941,26989,'','',30,0,0.00881,1.476,0,'OK - 192.168.77.8: rta 0.138ms, lost 0%','rta=0.138ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628283,2,23549,0,0,1,10,0,1,'2024-12-27 13:49:02',479534,'2024-12-27 13:49:05',517138,26989,'','',30,0,0.01719,1.479,0,'OK - 84.38.95.222: rta 0.520ms, lost 0%','rta=0.520ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628284,2,21397,0,0,1,5,1,1,'2024-12-27 13:49:02',483098,'2024-12-27 13:49:05',517339,26989,'','',30,0,2.00797,1.483,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628285,2,28279,0,0,1,1,0,1,'2024-12-27 13:49:05',519585,'2024-12-27 13:49:10',553859,26989,'','',30,0,0.0066,0.519,0,'OK - 192.168.77.9: rta 0.014ms, lost 0%','rta=0.014ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628286,2,23551,0,0,1,1,0,1,'2024-12-27 13:49:10',554367,'2024-12-27 13:49:10',565052,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628287,2,28533,0,0,1,1,1,1,'2024-12-27 13:49:12',572485,'2024-12-27 13:49:15',624469,26989,'','',30,0,2.00815,0.572,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628288,2,23554,0,0,1,1,0,1,'2024-12-27 13:49:15',626887,'2024-12-27 13:49:20',657332,26989,'','',30,0,0.01027,0.626,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628289,2,21396,0,0,1,5,0,1,'2024-12-27 13:49:20',657388,'2024-12-27 13:49:20',682243,26989,'','',30,0,0.024,0,0,'OK - 192.168.77.159: rta 0.878ms, lost 0%','rta=0.878ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628290,2,23553,0,0,1,10,1,1,'2024-12-27 13:49:20',682561,'2024-12-27 13:49:22',689786,26989,'','',30,0,2.006,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628291,2,23553,0,0,1,10,1,1,'2024-12-27 13:49:27',732561,'2024-12-27 13:49:30',753511,26989,'','',30,0,2.00821,0.732,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628292,2,21396,0,0,1,5,0,1,'2024-12-27 13:49:35',782999,'2024-12-27 13:49:40',815131,26989,'','',30,0,0.02018,0.782,0,'OK - 192.168.77.159: rta 0.693ms, lost 0%','rta=0.693ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628293,2,23552,0,0,1,1,0,1,'2024-12-27 13:49:45',855720,'2024-12-27 13:49:45',866571,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.120ms, lost 0%','rta=0.120ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628294,2,23553,0,0,1,10,1,1,'2024-12-27 13:49:45',866930,'2024-12-27 13:49:47',875725,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628295,2,23549,0,0,1,10,0,1,'2024-12-27 13:49:50',892845,'2024-12-27 13:49:50',904366,26989,'','',30,0,0.011,0,0,'OK - 84.38.95.222: rta 0.202ms, lost 0%','rta=0.202ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628296,2,23554,0,0,1,1,0,1,'2024-12-27 13:49:55',937704,'2024-12-27 13:49:55',948452,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628297,2,23551,0,0,1,1,0,1,'2024-12-27 13:49:55',948793,'2024-12-27 13:49:55',958704,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.148ms, lost 0%','rta=0.148ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628298,2,23551,0,0,1,1,0,1,'2024-12-27 13:49:57',969840,'2024-12-27 13:50:01',505,26989,'','',30,0,0.00986,0.969,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628299,2,28533,0,0,1,1,1,1,'2024-12-27 13:50:10',343,'2024-12-27 13:50:12',25751,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628300,2,23552,0,0,1,1,0,1,'2024-12-27 13:50:05',2,'2024-12-27 13:50:12',29704,26989,'','',30,0,0.01102,0.029,0,'OK - 192.168.77.8: rta 0.184ms, lost 0%','rta=0.184ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628301,2,23549,0,0,1,10,0,1,'2024-12-27 13:50:05',14172,'2024-12-27 13:50:12',465,26989,'','',30,0,0.01594,0.033,0,'OK - 84.38.95.222: rta 0.464ms, lost 0%','rta=0.464ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628302,2,23548,0,0,1,5,1,1,'2024-12-27 13:50:05',11325,'2024-12-27 13:50:12',467,26989,'','',30,0,2.0107,0.026,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628303,2,21395,0,0,1,5,1,1,'2024-12-27 13:50:05',11918,'2024-12-27 13:50:12',469,26989,'','',30,0,2.00957,0.027,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628304,2,21397,0,0,1,5,1,1,'2024-12-27 13:50:05',15848,'2024-12-27 13:50:12',471,26989,'','',30,0,2.00781,0.036,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628305,2,28279,0,0,1,1,0,1,'2024-12-27 13:50:12',31439,'2024-12-27 13:50:15',0,26989,'','',30,0,0.0063,2.075,0,'OK - 192.168.77.9: rta 0.014ms, lost 0%','rta=0.014ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628306,2,23553,0,0,1,10,1,1,'2024-12-27 13:50:15',0,'2024-12-27 13:50:17',119489,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628307,2,23554,0,0,1,1,0,1,'2024-12-27 13:50:20',136357,'2024-12-27 13:50:20',147844,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628308,2,28533,0,0,1,1,1,1,'2024-12-27 13:50:17',122083,'2024-12-27 13:50:20',148660,26989,'','',30,0,2.0079,2.122,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628309,2,23554,0,0,1,1,0,1,'2024-12-27 13:50:20',151035,'2024-12-27 13:50:25',169591,26989,'','',30,0,0.00895,0.151,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628310,2,23551,0,0,1,1,0,1,'2024-12-27 13:50:30',193576,'2024-12-27 13:50:30',204649,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628311,2,28279,0,0,1,1,0,1,'2024-12-27 13:50:35',244988,'2024-12-27 13:50:35',252710,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628312,2,23553,0,0,1,10,1,1,'2024-12-27 13:50:30',207236,'2024-12-27 13:50:35',253238,26989,'','',30,0,2.00777,0.207,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628313,2,23552,0,0,1,1,0,1,'2024-12-27 13:50:35',253309,'2024-12-27 13:50:35',262717,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.127ms, lost 0%','rta=0.127ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628314,2,21396,0,0,1,5,0,1,'2024-12-27 13:50:40',281534,'2024-12-27 13:50:45',293019,26989,'','',30,0,0.02514,0.281,0,'OK - 192.168.77.159: rta 0.932ms, lost 0%','rta=0.932ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628315,2,21397,0,0,1,5,1,1,'2024-12-27 13:50:45',293082,'2024-12-27 13:50:47',302180,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628316,2,23553,0,0,1,10,1,1,'2024-12-27 13:50:47',302527,'2024-12-27 13:50:48',300410,26989,'','',30,0,0.998,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628317,2,23554,0,0,1,1,0,1,'2024-12-27 13:50:48',300969,'2024-12-27 13:50:48',310869,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628318,2,28533,0,0,1,1,1,1,'2024-12-27 13:50:55',335932,'2024-12-27 13:50:57',345733,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628319,2,23551,0,0,1,1,0,1,'2024-12-27 13:51:00',366068,'2024-12-27 13:51:00',376731,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628320,2,23551,0,0,1,1,0,1,'2024-12-27 13:51:01',381936,'2024-12-27 13:51:05',405222,26989,'','',30,0,0.00891,0.381,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628321,2,23552,0,0,1,1,0,1,'2024-12-27 13:51:05',405291,'2024-12-27 13:51:05',414718,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.116ms, lost 0%','rta=0.116ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628322,2,23553,0,0,1,10,1,1,'2024-12-27 13:51:05',415068,'2024-12-27 13:51:07',423313,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628323,2,23548,0,0,1,5,1,1,'2024-12-27 13:51:10',445676,'2024-12-27 13:51:12',456052,26989,'','',30,0,2.01,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628324,2,23554,0,0,1,1,0,1,'2024-12-27 13:51:12',456368,'2024-12-27 13:51:12',466306,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628325,2,23552,0,0,1,1,0,1,'2024-12-27 13:51:12',470375,'2024-12-27 13:51:15',502750,26989,'','',30,0,0.00919,0.47,0,'OK - 192.168.77.8: rta 0.122ms, lost 0%','rta=0.122ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628326,2,23549,0,0,1,10,0,1,'2024-12-27 13:51:12',471381,'2024-12-27 13:51:15',503244,26989,'','',30,0,0.01275,0.471,0,'OK - 84.38.95.222: rta 0.197ms, lost 0%','rta=0.197ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628327,2,21397,0,0,1,5,1,1,'2024-12-27 13:51:12',478876,'2024-12-27 13:51:15',503479,26989,'','',30,0,0.97541,0.478,2,'CRITICAL - 172.20.3.10: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628328,2,23548,0,0,1,5,1,1,'2024-12-27 13:51:12',472109,'2024-12-27 13:51:15',503728,26989,'','',30,0,0.9828,0.472,2,'CRITICAL - 172.20.3.11: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628329,2,21395,0,0,1,5,1,1,'2024-12-27 13:51:12',475648,'2024-12-27 13:51:15',503964,26989,'','',30,0,2.00828,0.475,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628330,2,28279,0,0,1,1,0,1,'2024-12-27 13:51:15',510512,'2024-12-27 13:51:20',544472,26989,'','',30,0,0.00731,0.51,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628331,2,23551,0,0,1,1,0,1,'2024-12-27 13:51:25',576394,'2024-12-27 13:51:25',587642,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628332,2,28533,0,0,1,1,1,1,'2024-12-27 13:51:20',553299,'2024-12-27 13:51:25',588185,26989,'','',30,0,2.00821,0.553,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628333,2,23554,0,0,1,1,0,1,'2024-12-27 13:51:25',590613,'2024-12-27 13:51:30',638055,26989,'','',30,0,0.00909,0.59,0,'OK - 192.168.77.208: rta 0.158ms, lost 0%','rta=0.158ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628334,2,23548,0,0,1,5,1,1,'2024-12-27 13:51:30',638568,'2024-12-27 13:51:32',648150,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628335,2,23552,0,0,1,1,0,1,'2024-12-27 13:51:32',648540,'2024-12-27 13:51:32',659035,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.112ms, lost 0%','rta=0.112ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628336,2,23553,0,0,1,10,1,1,'2024-12-27 13:51:40',730279,'2024-12-27 13:51:42',739011,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628337,2,23553,0,0,1,10,1,1,'2024-12-27 13:51:35',704486,'2024-12-27 13:51:42',739521,26989,'','',30,0,2.00776,0.704,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628338,2,23551,0,0,1,1,0,1,'2024-12-27 13:51:42',739584,'2024-12-27 13:51:42',749775,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.148ms, lost 0%','rta=0.148ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628339,2,28533,0,0,1,1,1,1,'2024-12-27 13:51:45',776096,'2024-12-27 13:51:47',784276,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628340,2,23554,0,0,1,1,0,1,'2024-12-27 13:51:50',823398,'2024-12-27 13:51:50',835012,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628341,2,23552,0,0,1,1,0,1,'2024-12-27 13:51:50',835616,'2024-12-27 13:51:50',845308,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.136ms, lost 0%','rta=0.136ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628342,2,21396,0,0,1,5,0,1,'2024-12-27 13:51:47',787144,'2024-12-27 13:51:50',845788,26989,'','',30,0,0.02807,2.787,0,'OK - 192.168.77.159: rta 1.095ms, lost 0%','rta=1.095ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628343,2,21395,0,0,1,5,1,1,'2024-12-27 13:51:50',846333,'2024-12-27 13:51:51',803307,26989,'','',30,0,0.957,0,1,'CRITICAL - 192.168.77.154: Host unreachable @ 192.168.77.9. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628344,2,23553,0,0,1,10,1,1,'2024-12-27 13:51:55',831284,'2024-12-27 13:51:57',841020,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628345,2,23551,0,0,1,1,0,1,'2024-12-27 13:52:00',867347,'2024-12-27 13:52:00',878511,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.154ms, lost 0%','rta=0.154ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628346,2,23551,0,0,1,1,0,1,'2024-12-27 13:52:05',909280,'2024-12-27 13:52:10',946913,26989,'','',30,0,0.0104,0.909,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628347,2,28279,0,0,1,1,0,1,'2024-12-27 13:52:10',947204,'2024-12-27 13:52:10',955202,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628348,2,23552,0,0,1,1,0,1,'2024-12-27 13:52:15',989753,'2024-12-27 13:52:15',999990,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.125ms, lost 0%','rta=0.125ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628349,2,23552,0,0,1,1,0,1,'2024-12-27 13:52:16',166,'2024-12-27 13:52:20',179,26989,'','',30,0,0.00848,1.002,0,'OK - 192.168.77.8: rta 0.128ms, lost 0%','rta=0.128ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628350,2,23549,0,0,1,10,0,1,'2024-12-27 13:52:16',2660,'2024-12-27 13:52:20',11681,26989,'','',30,0,0.01076,1.005,0,'OK - 84.38.95.222: rta 0.203ms, lost 0%','rta=0.203ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628351,2,21396,0,0,1,5,0,1,'2024-12-27 13:52:20',11713,'2024-12-27 13:52:20',42,26989,'','',30,0,0.025,0,0,'OK - 192.168.77.159: rta 0.939ms, lost 0%','rta=0.939ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628352,2,21397,0,0,1,5,1,1,'2024-12-27 13:52:16',3407,'2024-12-27 13:52:20',22252,26989,'','',30,0,2.00858,1.006,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628353,2,23548,0,0,1,5,1,1,'2024-12-27 13:52:16',0,'2024-12-27 13:52:20',349,26989,'','',30,0,2.00882,1.009,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628354,2,21395,0,0,1,5,1,1,'2024-12-27 13:52:16',5040,'2024-12-27 13:52:20',43,26989,'','',30,0,2.00773,1.011,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628355,2,23553,0,0,1,10,1,1,'2024-12-27 13:52:25',3536,'2024-12-27 13:52:27',32132,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628356,2,28279,0,0,1,1,0,1,'2024-12-27 13:52:20',23739,'2024-12-27 13:52:27',0,26989,'','',30,0,0.00615,0.056,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628357,2,23554,0,0,1,1,0,1,'2024-12-27 13:52:27',0,'2024-12-27 13:52:27',106417,26989,'','',30,0,0.017,0,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628358,2,28533,0,0,1,1,1,1,'2024-12-27 13:52:27',108917,'2024-12-27 13:52:30',120390,26989,'','',30,0,2.00791,2.108,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628359,2,23554,0,0,1,1,0,1,'2024-12-27 13:52:30',122541,'2024-12-27 13:52:35',139524,26989,'','',30,0,0.01014,0.122,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628360,2,23552,0,0,1,1,0,1,'2024-12-27 13:52:45',170456,'2024-12-27 13:52:45',180370,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.129ms, lost 0%','rta=0.129ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628361,2,23553,0,0,1,10,1,1,'2024-12-27 13:52:45',180730,'2024-12-27 13:52:47',189046,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628362,2,23553,0,0,1,10,1,1,'2024-12-27 13:52:42',162609,'2024-12-27 13:52:47',205554,26989,'','',30,0,1.66638,0.162,2,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628363,2,23549,0,0,1,10,0,1,'2024-12-27 13:52:50',220862,'2024-12-27 13:52:50',232387,26989,'','',30,0,0.011,0,0,'OK - 84.38.95.222: rta 0.205ms, lost 0%','rta=0.205ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628364,2,21396,0,0,1,5,0,1,'2024-12-27 13:52:50',234908,'2024-12-27 13:52:55',253019,26989,'','',30,0,0.02776,0.234,0,'OK - 192.168.77.159: rta 1.098ms, lost 0%','rta=1.098ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628365,2,23554,0,0,1,1,0,1,'2024-12-27 13:52:55',253076,'2024-12-27 13:52:55',263558,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628366,2,23551,0,0,1,1,0,1,'2024-12-27 13:52:55',263897,'2024-12-27 13:52:55',273609,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.148ms, lost 0%','rta=0.148ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628367,2,28533,0,0,1,1,1,1,'2024-12-27 13:53:05',309933,'2024-12-27 13:53:07',318539,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628368,2,23552,0,0,1,1,0,1,'2024-12-27 13:53:10',352478,'2024-12-27 13:53:10',362505,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.122ms, lost 0%','rta=0.122ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628369,2,23551,0,0,1,1,0,1,'2024-12-27 13:53:10',364979,'2024-12-27 13:53:15',379646,26989,'','',30,0,0.00874,0.364,0,'OK - 192.168.77.29: rta 0.146ms, lost 0%','rta=0.146ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628370,2,21397,0,0,1,5,1,1,'2024-12-27 13:53:15',379699,'2024-12-27 13:53:17',389710,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628371,2,23553,0,0,1,10,1,1,'2024-12-27 13:53:17',399878,'2024-12-27 13:53:18',387969,26989,'','',30,0,0.988,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628372,2,23554,0,0,1,1,0,1,'2024-12-27 13:53:20',400474,'2024-12-27 13:53:20',410787,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628373,2,23549,0,0,1,10,0,1,'2024-12-27 13:53:20',411156,'2024-12-27 13:53:20',421947,26989,'','',30,0,0.01,0,0,'OK - 84.38.95.222: rta 0.195ms, lost 0%','rta=0.195ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628374,2,23552,0,0,1,1,0,1,'2024-12-27 13:53:20',424507,'2024-12-27 13:53:25',468853,26989,'','',30,0,0.0085,0.424,0,'OK - 192.168.77.8: rta 0.131ms, lost 0%','rta=0.131ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628375,2,23549,0,0,1,10,0,1,'2024-12-27 13:53:20',427551,'2024-12-27 13:53:25',469068,26989,'','',30,0,0.01391,0.427,0,'OK - 84.38.95.222: rta 0.240ms, lost 0%','rta=0.240ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628376,2,21397,0,0,1,5,1,1,'2024-12-27 13:53:20',431121,'2024-12-27 13:53:25',469297,26989,'','',30,0,2.00738,0.431,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628377,2,23548,0,0,1,5,1,1,'2024-12-27 13:53:20',434326,'2024-12-27 13:53:25',469520,26989,'','',30,0,2.00716,0.434,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628378,2,21395,0,0,1,5,1,1,'2024-12-27 13:53:20',437792,'2024-12-27 13:53:25',469730,26989,'','',30,0,2.00768,0.437,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628379,2,28533,0,0,1,1,1,1,'2024-12-27 13:53:25',470041,'2024-12-27 13:53:27',491989,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628380,2,28279,0,0,1,1,0,1,'2024-12-27 13:53:27',508665,'2024-12-27 13:53:30',518681,26989,'','',30,0,0.00722,0.508,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628381,2,23551,0,0,1,1,0,1,'2024-12-27 13:53:30',519008,'2024-12-27 13:53:30',530406,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628382,2,28533,0,0,1,1,1,1,'2024-12-27 13:53:30',533248,'2024-12-27 13:53:35',564825,26989,'','',30,0,2.00789,0.533,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628383,2,23554,0,0,1,1,0,1,'2024-12-27 13:53:35',567359,'2024-12-27 13:53:40',579907,26989,'','',30,0,0.00953,0.567,0,'OK - 192.168.77.208: rta 0.148ms, lost 0%','rta=0.148ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628384,2,21397,0,0,1,5,1,1,'2024-12-27 13:53:45',598015,'2024-12-27 13:53:47',606941,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628385,2,23553,0,0,1,10,1,1,'2024-12-27 13:53:47',607259,'2024-12-27 13:53:48',607138,26989,'','',30,0,1,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628386,2,23553,0,0,1,10,1,1,'2024-12-27 13:53:48',610188,'2024-12-27 13:53:50',625465,26989,'','',30,0,2.00864,1.61,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628387,2,28533,0,0,1,1,1,1,'2024-12-27 13:53:55',644377,'2024-12-27 13:53:57',653834,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628388,2,21396,0,0,1,5,0,1,'2024-12-27 13:53:57',656665,'2024-12-27 13:54:00',670304,26989,'','',30,0,0.02208,2.656,0,'OK - 192.168.77.159: rta 0.775ms, lost 0%','rta=0.775ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628389,2,23551,0,0,1,1,0,1,'2024-12-27 13:54:00',671137,'2024-12-27 13:54:00',681473,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628390,2,23552,0,0,1,1,0,1,'2024-12-27 13:54:05',712391,'2024-12-27 13:54:05',722049,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.117ms, lost 0%','rta=0.117ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628391,2,23553,0,0,1,10,1,1,'2024-12-27 13:54:05',722374,'2024-12-27 13:54:07',730047,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628392,2,23548,0,0,1,5,1,1,'2024-12-27 13:54:10',753773,'2024-12-27 13:54:12',763419,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628393,2,23554,0,0,1,1,0,1,'2024-12-27 13:54:12',763719,'2024-12-27 13:54:12',773886,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628394,2,23551,0,0,1,1,0,1,'2024-12-27 13:54:15',810503,'2024-12-27 13:54:20',840657,26989,'','',30,0,0.00993,0.81,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628395,2,21395,0,0,1,5,1,1,'2024-12-27 13:54:25',860732,'2024-12-27 13:54:27',870513,26989,'','',30,0,2.009,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628396,2,23552,0,0,1,1,0,1,'2024-12-27 13:54:27',870872,'2024-12-27 13:54:27',880424,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.123ms, lost 0%','rta=0.123ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628397,2,28533,0,0,1,1,1,1,'2024-12-27 13:54:30',933037,'2024-12-27 13:54:32',942690,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628398,2,23552,0,0,1,1,0,1,'2024-12-27 13:54:27',883430,'2024-12-27 13:54:32',943146,26989,'','',30,0,0.0084,2.883,0,'OK - 192.168.77.8: rta 0.119ms, lost 0%','rta=0.119ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628399,2,23549,0,0,1,10,0,1,'2024-12-27 13:54:27',886081,'2024-12-27 13:54:32',943356,26989,'','',30,0,0.01333,2.886,0,'OK - 84.38.95.222: rta 0.285ms, lost 0%','rta=0.285ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628400,2,21395,0,0,1,5,1,1,'2024-12-27 13:54:27',896372,'2024-12-27 13:54:32',943791,26989,'','',30,0,0.97126,2.896,2,'CRITICAL - 192.168.77.154: Host unreachable @ 192.168.77.9. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628401,2,21397,0,0,1,5,1,1,'2024-12-27 13:54:27',889399,'2024-12-27 13:54:32',944020,26989,'','',30,0,2.00827,2.889,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628402,2,23548,0,0,1,5,1,1,'2024-12-27 13:54:27',893008,'2024-12-27 13:54:32',944229,26989,'','',30,0,2.00862,2.892,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628403,2,28279,0,0,1,1,0,1,'2024-12-27 13:54:32',946929,'2024-12-27 13:54:35',971446,26989,'','',30,0,0.0072,2.946,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628404,2,28533,0,0,1,1,1,1,'2024-12-27 13:54:35',989411,'2024-12-27 13:54:40',2,26989,'','',30,0,2.00905,0.989,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628405,2,23553,0,0,1,10,1,1,'2024-12-27 13:54:40',1539,'2024-12-27 13:54:42',5130,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628406,2,23551,0,0,1,1,0,1,'2024-12-27 13:54:42',10027,'2024-12-27 13:54:42',222,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628407,2,23554,0,0,1,1,0,1,'2024-12-27 13:54:42',15514,'2024-12-27 13:54:45',339,26989,'','',30,0,0.00883,2.036,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628408,2,23552,0,0,1,1,0,1,'2024-12-27 13:54:50',102459,'2024-12-27 13:54:50',113719,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.130ms, lost 0%','rta=0.130ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628409,2,21395,0,0,1,5,1,1,'2024-12-27 13:54:50',114493,'2024-12-27 13:54:51',0,26989,'','',30,0,0.977,0,1,'CRITICAL - 192.168.77.154: Host unreachable @ 192.168.77.9. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628410,2,23553,0,0,1,10,1,1,'2024-12-27 13:54:51',0,'2024-12-27 13:54:55',107647,26989,'','',30,0,0.06131,1.093,2,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628411,2,23554,0,0,1,1,0,1,'2024-12-27 13:55:00',129160,'2024-12-27 13:55:00',140465,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628412,2,23551,0,0,1,1,0,1,'2024-12-27 13:55:00',140838,'2024-12-27 13:55:00',152100,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628413,2,28533,0,0,1,1,1,1,'2024-12-27 13:55:00',152419,'2024-12-27 13:55:02',161095,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628414,2,21396,0,0,1,5,0,1,'2024-12-27 13:55:02',163728,'2024-12-27 13:55:05',175907,26989,'','',30,0,0.03356,2.163,0,'OK - 192.168.77.159: rta 1.375ms, lost 0%','rta=1.375ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628415,2,28279,0,0,1,1,0,1,'2024-12-27 13:55:10',198620,'2024-12-27 13:55:10',206846,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628416,2,23552,0,0,1,1,0,1,'2024-12-27 13:55:15',220360,'2024-12-27 13:55:15',230555,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.129ms, lost 0%','rta=0.129ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628417,2,21396,0,0,1,5,0,1,'2024-12-27 13:55:20',273568,'2024-12-27 13:55:20',295752,26989,'','',30,0,0.021,0,0,'OK - 192.168.77.159: rta 0.750ms, lost 0%','rta=0.750ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628418,2,23553,0,0,1,10,1,1,'2024-12-27 13:55:20',296074,'2024-12-27 13:55:22',305155,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628419,2,23554,0,0,1,1,0,1,'2024-12-27 13:55:25',334463,'2024-12-27 13:55:25',344444,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628420,2,23551,0,0,1,1,0,1,'2024-12-27 13:55:22',307863,'2024-12-27 13:55:25',344924,26989,'','',30,0,0.00893,2.307,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628421,2,23552,0,0,1,1,0,1,'2024-12-27 13:55:32',376789,'2024-12-27 13:55:35',405639,26989,'','',30,0,0.01099,0.376,0,'OK - 192.168.77.8: rta 0.220ms, lost 0%','rta=0.220ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628422,2,23549,0,0,1,10,0,1,'2024-12-27 13:55:32',378702,'2024-12-27 13:55:35',405884,26989,'','',30,0,0.01252,0.378,0,'OK - 84.38.95.222: rta 0.264ms, lost 0%','rta=0.264ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628423,2,21395,0,0,1,5,1,1,'2024-12-27 13:55:32',381806,'2024-12-27 13:55:35',406124,26989,'','',30,0,2.0084,0.381,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628424,2,21397,0,0,1,5,1,1,'2024-12-27 13:55:32',384240,'2024-12-27 13:55:35',406352,26989,'','',30,0,2.01038,0.384,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628425,2,23548,0,0,1,5,1,1,'2024-12-27 13:55:32',385216,'2024-12-27 13:55:35',406593,26989,'','',30,0,2.00994,0.385,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628426,2,28279,0,0,1,1,0,1,'2024-12-27 13:55:35',409117,'2024-12-27 13:55:40',438370,26989,'','',30,0,0.00729,0.409,0,'OK - 192.168.77.9: rta 0.014ms, lost 0%','rta=0.014ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628427,2,28533,0,0,1,1,1,1,'2024-12-27 13:55:40',440599,'2024-12-27 13:55:45',475820,26989,'','',30,0,2.00805,0.44,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628428,2,23553,0,0,1,10,1,1,'2024-12-27 13:55:45',476160,'2024-12-27 13:55:47',485551,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628429,2,23554,0,0,1,1,0,1,'2024-12-27 13:55:47',488090,'2024-12-27 13:55:50',520646,26989,'','',30,0,0.00897,2.488,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628430,2,23549,0,0,1,10,0,1,'2024-12-27 13:55:50',520955,'2024-12-27 13:55:50',532895,26989,'','',30,0,0.011,0,0,'OK - 84.38.95.222: rta 0.228ms, lost 0%','rta=0.228ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628431,2,23551,0,0,1,1,0,1,'2024-12-27 13:55:55',571125,'2024-12-27 13:55:55',581630,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628432,2,23553,0,0,1,10,1,1,'2024-12-27 13:55:55',584101,'2024-12-27 13:56:00',617361,26989,'','',30,0,2.00708,0.584,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628433,2,28533,0,0,1,1,1,1,'2024-12-27 13:56:05',649738,'2024-12-27 13:56:07',659293,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628434,2,21396,0,0,1,5,0,1,'2024-12-27 13:56:07',661834,'2024-12-27 13:56:10',694935,26989,'','',30,0,0.02218,2.661,0,'OK - 192.168.77.159: rta 0.802ms, lost 0%','rta=0.802ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628435,2,23552,0,0,1,1,0,1,'2024-12-27 13:56:10',695011,'2024-12-27 13:56:10',705705,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.148ms, lost 0%','rta=0.148ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628436,2,21397,0,0,1,5,1,1,'2024-12-27 13:56:15',728207,'2024-12-27 13:56:17',736934,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628437,2,23553,0,0,1,10,1,1,'2024-12-27 13:56:17',737238,'2024-12-27 13:56:18',736088,26989,'','',30,0,0.999,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628438,2,23554,0,0,1,1,0,1,'2024-12-27 13:56:20',766398,'2024-12-27 13:56:20',777624,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628439,2,23549,0,0,1,10,0,1,'2024-12-27 13:56:20',777950,'2024-12-27 13:56:20',794688,26989,'','',30,0,0.016,0,0,'OK - 84.38.95.222: rta 0.498ms, lost 0%','rta=0.498ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628440,2,28533,0,0,1,1,1,1,'2024-12-27 13:56:25',825736,'2024-12-27 13:56:27',834760,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628441,2,23551,0,0,1,1,0,1,'2024-12-27 13:56:27',837352,'2024-12-27 13:56:30',852895,26989,'','',30,0,0.00947,2.837,0,'OK - 192.168.77.29: rta 0.154ms, lost 0%','rta=0.154ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628442,2,28279,0,0,1,1,0,1,'2024-12-27 13:56:35',889557,'2024-12-27 13:56:35',897450,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628443,2,23552,0,0,1,1,0,1,'2024-12-27 13:56:35',897794,'2024-12-27 13:56:35',907274,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.125ms, lost 0%','rta=0.125ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628444,2,23552,0,0,1,1,0,1,'2024-12-27 13:56:35',909896,'2024-12-27 13:56:40',942856,26989,'','',30,0,0.00826,0.909,0,'OK - 192.168.77.8: rta 0.117ms, lost 0%','rta=0.117ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628445,2,23549,0,0,1,10,0,1,'2024-12-27 13:56:35',912981,'2024-12-27 13:56:40',943086,26989,'','',30,0,0.01164,0.912,0,'OK - 84.38.95.222: rta 0.234ms, lost 0%','rta=0.234ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628446,2,23548,0,0,1,5,1,1,'2024-12-27 13:56:35',918530,'2024-12-27 13:56:40',943315,26989,'','',30,0,0.04929,0.918,2,'CRITICAL - 172.20.3.11: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628447,2,21397,0,0,1,5,1,1,'2024-12-27 13:56:35',917524,'2024-12-27 13:56:40',943553,26989,'','',30,0,0.05033,0.917,2,'CRITICAL - 172.20.3.10: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628448,2,21395,0,0,1,5,1,1,'2024-12-27 13:56:35',916287,'2024-12-27 13:56:40',943787,26989,'','',30,0,2.00916,0.916,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628449,2,28279,0,0,1,1,0,1,'2024-12-27 13:56:40',949536,'2024-12-27 13:56:45',982284,26989,'','',30,0,0.00687,0.949,0,'OK - 192.168.77.9: rta 0.018ms, lost 0%','rta=0.018ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628450,2,23553,0,0,1,10,1,1,'2024-12-27 13:56:45',982659,'2024-12-27 13:56:47',991659,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628451,2,23554,0,0,1,1,0,1,'2024-12-27 13:56:47',992247,'2024-12-27 13:56:48',22,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628452,2,28533,0,0,1,1,1,1,'2024-12-27 13:56:48',2744,'2024-12-27 13:56:50',1,26989,'','',30,0,2.00774,3.005,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628453,2,23554,0,0,1,1,0,1,'2024-12-27 13:56:50',9217,'2024-12-27 13:56:55',40,26989,'','',30,0,0.0097,0.021,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628454,2,23551,0,0,1,1,0,1,'2024-12-27 13:57:00',0,'2024-12-27 13:57:00',0,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628455,2,23553,0,0,1,10,1,1,'2024-12-27 13:57:00',101717,'2024-12-27 13:57:05',135659,26989,'','',30,0,2.00843,0.101,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628456,2,23552,0,0,1,1,0,1,'2024-12-27 13:57:05',135736,'2024-12-27 13:57:05',145712,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.114ms, lost 0%','rta=0.114ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628457,2,23548,0,0,1,5,1,1,'2024-12-27 13:57:10',161767,'2024-12-27 13:57:12',171971,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628458,2,23554,0,0,1,1,0,1,'2024-12-27 13:57:12',172265,'2024-12-27 13:57:12',182322,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628459,2,21396,0,0,1,5,0,1,'2024-12-27 13:57:12',184899,'2024-12-27 13:57:15',195964,26989,'','',30,0,0.02232,2.184,0,'OK - 192.168.77.159: rta 0.800ms, lost 0%','rta=0.800ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628460,2,21395,0,0,1,5,1,1,'2024-12-27 13:57:25',255832,'2024-12-27 13:57:27',265547,26989,'','',30,0,2.009,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628461,2,23552,0,0,1,1,0,1,'2024-12-27 13:57:27',265829,'2024-12-27 13:57:27',275558,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.126ms, lost 0%','rta=0.126ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628462,2,23551,0,0,1,1,0,1,'2024-12-27 13:57:27',275830,'2024-12-27 13:57:27',285695,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628463,2,28533,0,0,1,1,1,1,'2024-12-27 13:57:30',328244,'2024-12-27 13:57:32',337412,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628464,2,23548,0,0,1,5,1,1,'2024-12-27 13:57:32',338034,'2024-12-27 13:57:34',346653,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628465,2,23551,0,0,1,1,0,1,'2024-12-27 13:57:34',349544,'2024-12-27 13:57:35',380023,26989,'','',30,0,0.00903,4.349,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628466,2,23553,0,0,1,10,1,1,'2024-12-27 13:57:40',421219,'2024-12-27 13:57:42',431085,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628467,2,23552,0,0,1,1,0,1,'2024-12-27 13:57:42',433827,'2024-12-27 13:57:45',476777,26989,'','',30,0,0.00927,2.433,0,'OK - 192.168.77.8: rta 0.137ms, lost 0%','rta=0.137ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628468,2,23549,0,0,1,10,0,1,'2024-12-27 13:57:42',436348,'2024-12-27 13:57:45',476978,26989,'','',30,0,0.01159,2.436,0,'OK - 84.38.95.222: rta 0.249ms, lost 0%','rta=0.249ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628469,2,23548,0,0,1,5,1,1,'2024-12-27 13:57:42',439197,'2024-12-27 13:57:45',477197,26989,'','',30,0,0.98989,2.439,2,'CRITICAL - 172.20.3.11: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628470,2,21397,0,0,1,5,1,1,'2024-12-27 13:57:42',442811,'2024-12-27 13:57:45',477422,26989,'','',30,0,0.9868,2.442,2,'CRITICAL - 172.20.3.10: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628471,2,21395,0,0,1,5,1,1,'2024-12-27 13:57:42',446138,'2024-12-27 13:57:45',477841,26989,'','',30,0,2.00843,2.446,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628472,2,28279,0,0,1,1,0,1,'2024-12-27 13:57:45',480132,'2024-12-27 13:57:50',530530,26989,'','',30,0,0.00766,0.48,0,'OK - 192.168.77.9: rta 0.014ms, lost 0%','rta=0.014ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628473,2,23554,0,0,1,1,0,1,'2024-12-27 13:57:50',530598,'2024-12-27 13:57:50',541824,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628474,2,28533,0,0,1,1,1,1,'2024-12-27 13:57:50',546015,'2024-12-27 13:57:55',574665,26989,'','',30,0,2.00872,0.545,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628475,2,23554,0,0,1,1,0,1,'2024-12-27 13:57:55',577624,'2024-12-27 13:58:00',609534,26989,'','',30,0,0.01019,0.577,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628476,2,23552,0,0,1,1,0,1,'2024-12-27 13:58:00',609622,'2024-12-27 13:58:00',620250,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.125ms, lost 0%','rta=0.125ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628477,2,23551,0,0,1,1,0,1,'2024-12-27 13:58:00',620843,'2024-12-27 13:58:00',630736,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628478,2,28279,0,0,1,1,0,1,'2024-12-27 13:58:10',703872,'2024-12-27 13:58:10',711840,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628479,2,23553,0,0,1,10,1,1,'2024-12-27 13:58:05',658859,'2024-12-27 13:58:10',712321,26989,'','',30,0,2.00776,0.658,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628480,2,21396,0,0,1,5,0,1,'2024-12-27 13:58:15',736263,'2024-12-27 13:58:20',774967,26989,'','',30,0,0.02163,0.736,0,'OK - 192.168.77.159: rta 0.739ms, lost 0%','rta=0.739ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628481,2,23554,0,0,1,1,0,1,'2024-12-27 13:58:25',797737,'2024-12-27 13:58:25',808364,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628482,2,23551,0,0,1,1,0,1,'2024-12-27 13:58:35',849210,'2024-12-27 13:58:40',878475,26989,'','',30,0,0.00923,0.849,0,'OK - 192.168.77.29: rta 0.148ms, lost 0%','rta=0.148ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628483,2,23552,0,0,1,1,0,1,'2024-12-27 13:58:45',908034,'2024-12-27 13:58:45',919149,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.133ms, lost 0%','rta=0.133ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628484,2,23553,0,0,1,10,1,1,'2024-12-27 13:58:45',919532,'2024-12-27 13:58:47',927375,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628485,2,23552,0,0,1,1,0,1,'2024-12-27 13:58:47',930066,'2024-12-27 13:58:50',968257,26989,'','',30,0,0.01099,2.93,0,'OK - 192.168.77.8: rta 0.237ms, lost 0%','rta=0.237ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628486,2,23549,0,0,1,10,0,1,'2024-12-27 13:58:47',933124,'2024-12-27 13:58:50',968478,26989,'','',30,0,0.01137,2.933,0,'OK - 84.38.95.222: rta 0.241ms, lost 0%','rta=0.241ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628487,2,23548,0,0,1,5,1,1,'2024-12-27 13:58:47',936322,'2024-12-27 13:58:50',968741,26989,'','',30,0,0.99015,2.936,2,'CRITICAL - 172.20.3.11: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628488,2,21397,0,0,1,5,1,1,'2024-12-27 13:58:47',938157,'2024-12-27 13:58:50',968963,26989,'','',30,0,0.98833,2.938,2,'CRITICAL - 172.20.3.10: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628489,2,21395,0,0,1,5,1,1,'2024-12-27 13:58:47',939154,'2024-12-27 13:58:50',969671,26989,'','',30,0,2.01109,2.939,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628490,2,28279,0,0,1,1,0,1,'2024-12-27 13:58:50',971988,'2024-12-27 13:58:56',0,26989,'','',30,0,0.00743,0.971,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628491,2,23554,0,0,1,1,0,1,'2024-12-27 13:58:56',0,'2024-12-27 13:58:56',1,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628492,2,23551,0,0,1,1,0,1,'2024-12-27 13:58:56',1,'2024-12-27 13:58:56',2,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628493,2,28533,0,0,1,1,1,1,'2024-12-27 13:58:56',203,'2024-12-27 13:59:00',4,26989,'','',30,0,2.00698,1.031,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628494,2,23554,0,0,1,1,0,1,'2024-12-27 13:59:00',21697,'2024-12-27 13:59:05',7,26989,'','',30,0,0.00935,0.052,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628495,2,23552,0,0,1,1,0,1,'2024-12-27 13:59:10',0,'2024-12-27 13:59:10',105661,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.127ms, lost 0%','rta=0.127ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628496,2,23553,0,0,1,10,1,1,'2024-12-27 13:59:10',108329,'2024-12-27 13:59:15',123291,26989,'','',30,0,2.00859,0.108,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628497,2,21397,0,0,1,5,1,1,'2024-12-27 13:59:15',123345,'2024-12-27 13:59:17',133677,26989,'','',30,0,2.01,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628498,2,23554,0,0,1,1,0,1,'2024-12-27 13:59:20',145712,'2024-12-27 13:59:20',156125,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628499,2,23549,0,0,1,10,0,1,'2024-12-27 13:59:20',156458,'2024-12-27 13:59:20',167179,26989,'','',30,0,0.01,0,0,'OK - 84.38.95.222: rta 0.199ms, lost 0%','rta=0.199ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628500,2,21396,0,0,1,5,0,1,'2024-12-27 13:59:20',169662,'2024-12-27 13:59:25',183498,26989,'','',30,0,0.02009,0.169,0,'OK - 192.168.77.159: rta 0.707ms, lost 0%','rta=0.707ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628501,2,28533,0,0,1,1,1,1,'2024-12-27 13:59:25',183815,'2024-12-27 13:59:27',193949,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628502,2,23551,0,0,1,1,0,1,'2024-12-27 13:59:30',212665,'2024-12-27 13:59:30',223946,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.29: rta 0.154ms, lost 0%','rta=0.154ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628503,2,28279,0,0,1,1,0,1,'2024-12-27 13:59:35',238942,'2024-12-27 13:59:35',246671,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628504,2,23552,0,0,1,1,0,1,'2024-12-27 13:59:35',247020,'2024-12-27 13:59:35',256129,26989,'','',30,0,0.008,0,0,'OK - 192.168.77.8: rta 0.115ms, lost 0%','rta=0.115ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628505,2,23551,0,0,1,1,0,1,'2024-12-27 13:59:40',293341,'2024-12-27 13:59:45',314966,26989,'','',30,0,0.00929,0.293,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628506,2,21397,0,0,1,5,1,1,'2024-12-27 13:59:45',315020,'2024-12-27 13:59:47',323390,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628507,2,23553,0,0,1,10,1,1,'2024-12-27 13:59:47',323691,'2024-12-27 13:59:48',323560,26989,'','',30,0,1,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628508,2,23554,0,0,1,1,0,1,'2024-12-27 13:59:48',324108,'2024-12-27 13:59:48',333931,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628509,2,23552,0,0,1,1,0,1,'2024-12-27 13:59:50',361310,'2024-12-27 13:59:55',396724,26989,'','',30,0,0.01099,0.361,0,'OK - 192.168.77.8: rta 0.161ms, lost 0%','rta=0.161ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628510,2,23549,0,0,1,10,0,1,'2024-12-27 13:59:50',364070,'2024-12-27 13:59:55',396938,26989,'','',30,0,0.01929,0.364,0,'OK - 84.38.95.222: rta 0.587ms, lost 0%','rta=0.587ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628511,2,28533,0,0,1,1,1,1,'2024-12-27 13:59:55',396993,'2024-12-27 13:59:56',447932,26989,'','',30,0,1.05,0,1,'CRITICAL - 172.50.1.3: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628512,2,23548,0,0,1,5,1,1,'2024-12-27 13:59:50',365074,'2024-12-27 13:59:56',448531,26989,'','',30,0,2.00838,0.365,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628513,2,21397,0,0,1,5,1,1,'2024-12-27 13:59:50',366076,'2024-12-27 13:59:56',448790,26989,'','',30,0,2.00798,0.366,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628514,2,21395,0,0,1,5,1,1,'2024-12-27 13:59:50',369151,'2024-12-27 13:59:56',449035,26989,'','',30,0,2.00848,0.369,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628515,2,28279,0,0,1,1,0,1,'2024-12-27 13:59:56',451458,'2024-12-27 14:00:00',493883,26989,'','',30,0,0.00753,0.451,0,'OK - 192.168.77.9: rta 0.016ms, lost 0%','rta=0.016ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628516,2,23551,0,0,1,1,0,1,'2024-12-27 14:00:00',494427,'2024-12-27 14:00:00',504517,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628517,2,28533,0,0,1,1,1,1,'2024-12-27 14:00:00',507305,'2024-12-27 14:00:05',540045,26989,'','',30,0,2.00702,0.507,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628518,2,23553,0,0,1,10,1,1,'2024-12-27 14:00:05',540566,'2024-12-27 14:00:07',549209,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628519,2,23554,0,0,1,1,0,1,'2024-12-27 14:00:07',551672,'2024-12-27 14:00:10',581225,26989,'','',30,0,0.00908,2.551,0,'OK - 192.168.77.208: rta 0.148ms, lost 0%','rta=0.148ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628520,2,23548,0,0,1,5,1,1,'2024-12-27 14:00:10',581557,'2024-12-27 14:00:12',589901,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628521,2,23553,0,0,1,10,1,1,'2024-12-27 14:00:15',625812,'2024-12-27 14:00:20',648084,26989,'','',30,0,2.00844,0.625,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628522,2,21395,0,0,1,5,1,1,'2024-12-27 14:00:25',679323,'2024-12-27 14:00:27',687862,26989,'','',30,0,2.008,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628523,2,23552,0,0,1,1,0,1,'2024-12-27 14:00:27',688205,'2024-12-27 14:00:27',697449,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.111ms, lost 0%','rta=0.111ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628524,2,23551,0,0,1,1,0,1,'2024-12-27 14:00:27',697786,'2024-12-27 14:00:27',707637,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628525,2,28533,0,0,1,1,1,1,'2024-12-27 14:00:30',745283,'2024-12-27 14:00:32',755962,26989,'','',30,0,2.01,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628526,2,21396,0,0,1,5,0,1,'2024-12-27 14:00:27',710127,'2024-12-27 14:00:32',756488,26989,'','',30,0,0.0224,2.71,0,'OK - 192.168.77.159: rta 0.825ms, lost 0%','rta=0.825ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628527,2,23548,0,0,1,5,1,1,'2024-12-27 14:00:32',756850,'2024-12-27 14:00:34',766197,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628528,2,23553,0,0,1,10,1,1,'2024-12-27 14:00:40',822229,'2024-12-27 14:00:42',832491,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628529,2,23551,0,0,1,1,0,1,'2024-12-27 14:00:45',872030,'2024-12-27 14:00:50',922014,26989,'','',30,0,0.00942,0.872,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628530,2,23554,0,0,1,1,0,1,'2024-12-27 14:00:50',922084,'2024-12-27 14:00:50',933071,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.161ms, lost 0%','rta=0.161ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628531,2,23552,0,0,1,1,0,1,'2024-12-27 14:00:50',933682,'2024-12-27 14:00:50',943149,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.128ms, lost 0%','rta=0.128ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628532,2,21395,0,0,1,5,1,1,'2024-12-27 14:00:50',943987,'2024-12-27 14:00:51',894954,26989,'','',30,0,0.951,0,1,'CRITICAL - 192.168.77.154: Host unreachable @ 192.168.77.9. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628533,2,23552,0,0,1,1,0,1,'2024-12-27 14:00:55',929598,'2024-12-27 14:01:00',976347,26989,'','',30,0,0.00971,0.929,0,'OK - 192.168.77.8: rta 0.133ms, lost 0%','rta=0.133ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628534,2,23549,0,0,1,10,0,1,'2024-12-27 14:00:55',932880,'2024-12-27 14:01:00',976572,26989,'','',30,0,0.01034,0.932,0,'OK - 84.38.95.222: rta 0.199ms, lost 0%','rta=0.199ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628535,2,23548,0,0,1,5,1,1,'2024-12-27 14:00:56',938010,'2024-12-27 14:01:00',977147,26989,'','',30,0,2.00792,0.937,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628536,2,21397,0,0,1,5,1,1,'2024-12-27 14:00:56',941593,'2024-12-27 14:01:00',977386,26989,'','',30,0,2.00829,0.941,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628537,2,21395,0,0,1,5,1,1,'2024-12-27 14:00:56',945028,'2024-12-27 14:01:00',977623,26989,'','',30,0,2.00786,0.944,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628538,2,28533,0,0,1,1,1,1,'2024-12-27 14:01:00',978195,'2024-12-27 14:01:02',987958,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628539,2,28279,0,0,1,1,0,1,'2024-12-27 14:01:02',990586,'2024-12-27 14:01:06',1,26989,'','',30,0,0.00668,2.99,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628540,2,28533,0,0,1,1,1,1,'2024-12-27 14:01:06',16,'2024-12-27 14:01:10',3,26989,'','',30,0,2.00864,1.02,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628541,2,23554,0,0,1,1,0,1,'2024-12-27 14:01:10',260,'2024-12-27 14:01:15',23488,26989,'','',30,0,0.00963,0.04,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628542,2,23551,0,0,1,1,0,1,'2024-12-27 14:01:15',2942,'2024-12-27 14:01:15',27922,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628543,2,23552,0,0,1,1,0,1,'2024-12-27 14:01:15',439,'2024-12-27 14:01:15',31779,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.124ms, lost 0%','rta=0.124ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628544,2,21396,0,0,1,5,0,1,'2024-12-27 14:01:20',0,'2024-12-27 14:01:20',119354,26989,'','',30,0,0.028,0,0,'OK - 192.168.77.159: rta 1.077ms, lost 0%','rta=1.077ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628545,2,23553,0,0,1,10,1,1,'2024-12-27 14:01:20',119702,'2024-12-27 14:01:22',128660,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628546,2,23553,0,0,1,10,1,1,'2024-12-27 14:01:22',131503,'2024-12-27 14:01:25',140680,26989,'','',30,0,0.99427,2.131,2,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628547,2,21396,0,0,1,5,0,1,'2024-12-27 14:01:32',157912,'2024-12-27 14:01:35',167645,26989,'','',30,0,0.03966,0.157,0,'OK - 192.168.77.159: rta 1.654ms, lost 0%','rta=1.654ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628548,2,23552,0,0,1,1,0,1,'2024-12-27 14:01:45',213611,'2024-12-27 14:01:45',223710,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.134ms, lost 0%','rta=0.134ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628549,2,23553,0,0,1,10,1,1,'2024-12-27 14:01:45',224086,'2024-12-27 14:01:47',232974,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628550,2,23549,0,0,1,10,0,1,'2024-12-27 14:01:50',270623,'2024-12-27 14:01:50',288366,26989,'','',30,0,0.017,0,0,'OK - 84.38.95.222: rta 0.480ms, lost 0%','rta=0.480ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628551,2,23551,0,0,1,1,0,1,'2024-12-27 14:01:50',291097,'2024-12-27 14:01:55',321666,26989,'','',30,0,0.00898,0.291,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628552,2,23554,0,0,1,1,0,1,'2024-12-27 14:01:55',321738,'2024-12-27 14:01:55',332631,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628553,2,23552,0,0,1,1,0,1,'2024-12-27 14:02:00',373586,'2024-12-27 14:02:05',418778,26989,'','',30,0,0.01033,0.373,0,'OK - 192.168.77.8: rta 0.188ms, lost 0%','rta=0.188ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628554,2,23549,0,0,1,10,0,1,'2024-12-27 14:02:00',376898,'2024-12-27 14:02:05',419020,26989,'','',30,0,0.0132,0.376,0,'OK - 84.38.95.222: rta 0.204ms, lost 0%','rta=0.204ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628555,2,23548,0,0,1,5,1,1,'2024-12-27 14:02:00',378812,'2024-12-27 14:02:05',419255,26989,'','',30,0,2.00973,0.378,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628556,2,21395,0,0,1,5,1,1,'2024-12-27 14:02:00',380794,'2024-12-27 14:02:05',419479,26989,'','',30,0,2.00852,0.38,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628557,2,21397,0,0,1,5,1,1,'2024-12-27 14:02:00',379830,'2024-12-27 14:02:05',419699,26989,'','',30,0,2.01036,0.379,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628558,2,28533,0,0,1,1,1,1,'2024-12-27 14:02:05',420014,'2024-12-27 14:02:07',429149,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628559,2,28279,0,0,1,1,0,1,'2024-12-27 14:02:07',431701,'2024-12-27 14:02:10',458297,26989,'','',30,0,0.00624,1.431,0,'OK - 192.168.77.9: rta 0.014ms, lost 0%','rta=0.014ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628560,2,28533,0,0,1,1,1,1,'2024-12-27 14:02:10',460711,'2024-12-27 14:02:15',490383,26989,'','',30,0,2.00824,0.46,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628561,2,23553,0,0,1,10,1,1,'2024-12-27 14:02:15',490723,'2024-12-27 14:02:17',498859,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628562,2,23554,0,0,1,1,0,1,'2024-12-27 14:02:17',501295,'2024-12-27 14:02:20',534511,26989,'','',30,0,0.00887,2.501,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628563,2,23549,0,0,1,10,0,1,'2024-12-27 14:02:20',534853,'2024-12-27 14:02:20',547436,26989,'','',30,0,0.012,0,0,'OK - 84.38.95.222: rta 0.225ms, lost 0%','rta=0.225ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628564,2,23553,0,0,1,10,1,1,'2024-12-27 14:02:25',581437,'2024-12-27 14:02:30',616024,26989,'','',30,0,2.00915,0.581,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628565,2,23551,0,0,1,1,0,1,'2024-12-27 14:02:30',616381,'2024-12-27 14:02:30',627373,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628566,2,28279,0,0,1,1,0,1,'2024-12-27 14:02:35',657347,'2024-12-27 14:02:35',665717,26989,'','',30,0,0.008,0,0,'OK - 192.168.77.9: rta 0.016ms, lost 0%','rta=0.016ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628567,2,23552,0,0,1,1,0,1,'2024-12-27 14:02:35',666039,'2024-12-27 14:02:35',675322,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.121ms, lost 0%','rta=0.121ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628568,2,21396,0,0,1,5,0,1,'2024-12-27 14:02:35',677811,'2024-12-27 14:02:40',714484,26989,'','',30,0,0.0223,0.677,0,'OK - 192.168.77.159: rta 0.817ms, lost 0%','rta=0.817ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628569,2,21397,0,0,1,5,1,1,'2024-12-27 14:02:45',749553,'2024-12-27 14:02:47',758377,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628570,2,23553,0,0,1,10,1,1,'2024-12-27 14:02:47',758736,'2024-12-27 14:02:48',758421,26989,'','',30,0,1,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628571,2,23554,0,0,1,1,0,1,'2024-12-27 14:02:48',758985,'2024-12-27 14:02:48',769118,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628572,2,28533,0,0,1,1,1,1,'2024-12-27 14:02:55',813435,'2024-12-27 14:02:56',882878,26989,'','',30,0,1.069,0,1,'CRITICAL - 172.50.1.3: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628573,2,23551,0,0,1,1,0,1,'2024-12-27 14:02:56',885368,'2024-12-27 14:03:00',932827,26989,'','',30,0,0.0094,1.885,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628574,2,23552,0,0,1,1,0,1,'2024-12-27 14:03:05',959942,'2024-12-27 14:03:05',969247,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.116ms, lost 0%','rta=0.116ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628575,2,23553,0,0,1,10,1,1,'2024-12-27 14:03:05',969824,'2024-12-27 14:03:07',977844,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628576,2,23552,0,0,1,1,0,1,'2024-12-27 14:03:07',980403,'2024-12-27 14:03:10',0,26989,'','',30,0,0.01177,2.98,0,'OK - 192.168.77.8: rta 0.255ms, lost 0%','rta=0.255ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628577,2,23549,0,0,1,10,0,1,'2024-12-27 14:03:07',983477,'2024-12-27 14:03:10',0,26989,'','',30,0,0.0136,2.983,0,'OK - 84.38.95.222: rta 0.346ms, lost 0%','rta=0.346ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628578,2,21397,0,0,1,5,1,1,'2024-12-27 14:03:07',991334,'2024-12-27 14:03:10',4103,26989,'','',30,0,0.98575,2.991,2,'CRITICAL - 172.20.3.10: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628579,2,23548,0,0,1,5,1,1,'2024-12-27 14:03:07',984900,'2024-12-27 14:03:10',4263,26989,'','',30,0,0.99221,2.984,2,'CRITICAL - 172.20.3.11: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628580,2,23554,0,0,1,1,0,1,'2024-12-27 14:03:10',4453,'2024-12-27 14:03:10',17,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628581,2,21395,0,0,1,5,1,1,'2024-12-27 14:03:07',987797,'2024-12-27 14:03:10',9490,26989,'','',30,0,2.00876,2.987,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628582,2,28279,0,0,1,1,0,1,'2024-12-27 14:03:10',1331,'2024-12-27 14:03:15',256,26989,'','',30,0,0.00623,0.024,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628583,2,28533,0,0,1,1,1,1,'2024-12-27 14:03:15',19847,'2024-12-27 14:03:20',5,26989,'','',30,0,2.00969,0.046,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628584,2,23554,0,0,1,1,0,1,'2024-12-27 14:03:20',52,'2024-12-27 14:03:25',7,26989,'','',30,0,0.01056,0.064,0,'OK - 192.168.77.208: rta 0.154ms, lost 0%','rta=0.154ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628585,2,21395,0,0,1,5,1,1,'2024-12-27 14:03:25',0,'2024-12-27 14:03:27',0,26989,'','',30,0,2.008,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628586,2,23552,0,0,1,1,0,1,'2024-12-27 14:03:27',0,'2024-12-27 14:03:27',0,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.118ms, lost 0%','rta=0.118ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628587,2,23551,0,0,1,1,0,1,'2024-12-27 14:03:27',0,'2024-12-27 14:03:27',108874,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628588,2,23548,0,0,1,5,1,1,'2024-12-27 14:03:30',130886,'2024-12-27 14:03:32',140243,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628589,2,28533,0,0,1,1,1,1,'2024-12-27 14:03:35',150812,'2024-12-27 14:03:37',159549,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628590,2,23553,0,0,1,10,1,1,'2024-12-27 14:03:32',143233,'2024-12-27 14:03:37',160122,26989,'','',30,0,0.99513,2.143,2,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628591,2,21396,0,0,1,5,0,1,'2024-12-27 14:03:40',199989,'2024-12-27 14:03:45',297733,26989,'','',30,0,0.02992,0.199,0,'OK - 192.168.77.159: rta 1.131ms, lost 0%','rta=1.131ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628592,2,23554,0,0,1,1,0,1,'2024-12-27 14:03:50',345272,'2024-12-27 14:03:50',355482,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628593,2,23553,0,0,1,10,1,1,'2024-12-27 14:03:50',355802,'2024-12-27 14:03:51',422372,26989,'','',30,0,1.066,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628594,2,23552,0,0,1,1,0,1,'2024-12-27 14:03:51',422651,'2024-12-27 14:03:51',431887,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.116ms, lost 0%','rta=0.116ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628595,2,21395,0,0,1,5,1,1,'2024-12-27 14:03:55',462231,'2024-12-27 14:03:57',471355,26989,'','',30,0,2.008,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628596,2,23551,0,0,1,1,0,1,'2024-12-27 14:04:00',494763,'2024-12-27 14:04:00',506099,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.29: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628597,2,28533,0,0,1,1,1,1,'2024-12-27 14:04:00',506409,'2024-12-27 14:04:02',514552,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628598,2,23551,0,0,1,1,0,1,'2024-12-27 14:04:02',517074,'2024-12-27 14:04:05',551492,26989,'','',30,0,0.00963,2.517,0,'OK - 192.168.77.29: rta 0.155ms, lost 0%','rta=0.155ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628599,2,28279,0,0,1,1,0,1,'2024-12-27 14:04:10',588398,'2024-12-27 14:04:10',596382,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628600,2,23552,0,0,1,1,0,1,'2024-12-27 14:04:10',598998,'2024-12-27 14:04:15',639905,26989,'','',30,0,0.00872,0.598,0,'OK - 192.168.77.8: rta 0.141ms, lost 0%','rta=0.141ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628601,2,23549,0,0,1,10,0,1,'2024-12-27 14:04:10',602034,'2024-12-27 14:04:15',640151,26989,'','',30,0,0.01067,0.602,0,'OK - 84.38.95.222: rta 0.198ms, lost 0%','rta=0.198ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628602,2,21397,0,0,1,5,1,1,'2024-12-27 14:04:10',605668,'2024-12-27 14:04:15',640405,26989,'','',30,0,2.00819,0.605,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628603,2,23548,0,0,1,5,1,1,'2024-12-27 14:04:10',609375,'2024-12-27 14:04:15',640656,26989,'','',30,0,2.00775,0.609,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628604,2,21395,0,0,1,5,1,1,'2024-12-27 14:04:10',612529,'2024-12-27 14:04:15',640898,26989,'','',30,0,2.00758,0.612,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628605,2,28279,0,0,1,1,0,1,'2024-12-27 14:04:15',643542,'2024-12-27 14:04:20',670577,26989,'','',30,0,0.00679,0.643,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628606,2,21396,0,0,1,5,0,1,'2024-12-27 14:04:20',670640,'2024-12-27 14:04:20',691963,26989,'','',30,0,0.021,0,0,'OK - 192.168.77.159: rta 0.713ms, lost 0%','rta=0.713ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628607,2,23553,0,0,1,10,1,1,'2024-12-27 14:04:20',692286,'2024-12-27 14:04:22',700545,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628608,2,23554,0,0,1,1,0,1,'2024-12-27 14:04:25',724581,'2024-12-27 14:04:25',734383,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628609,2,28533,0,0,1,1,1,1,'2024-12-27 14:04:22',703404,'2024-12-27 14:04:25',734887,26989,'','',30,0,2.0065,2.703,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628610,2,23554,0,0,1,1,0,1,'2024-12-27 14:04:25',737096,'2024-12-27 14:04:30',758944,26989,'','',30,0,0.00882,0.737,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628611,2,23553,0,0,1,10,1,1,'2024-12-27 14:04:37',799312,'2024-12-27 14:04:40',806905,26989,'','',30,0,2.00778,0.799,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628612,2,23552,0,0,1,1,0,1,'2024-12-27 14:04:45',835951,'2024-12-27 14:04:45',845835,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.118ms, lost 0%','rta=0.118ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628613,2,21396,0,0,1,5,0,1,'2024-12-27 14:04:45',848744,'2024-12-27 14:04:50',890226,26989,'','',30,0,0.02105,0.848,0,'OK - 192.168.77.159: rta 0.755ms, lost 0%','rta=0.755ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628614,2,23549,0,0,1,10,0,1,'2024-12-27 14:04:50',890532,'2024-12-27 14:04:50',902684,26989,'','',30,0,0.011,0,0,'OK - 84.38.95.222: rta 0.203ms, lost 0%','rta=0.203ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628615,2,23554,0,0,1,1,0,1,'2024-12-27 14:04:55',925599,'2024-12-27 14:04:55',936492,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.162ms, lost 0%','rta=0.162ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628616,2,23551,0,0,1,1,0,1,'2024-12-27 14:04:55',936853,'2024-12-27 14:04:55',947977,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628617,2,23551,0,0,1,1,0,1,'2024-12-27 14:05:05',2535,'2024-12-27 14:05:10',12,26989,'','',30,0,0.01046,0.004,0,'OK - 192.168.77.29: rta 0.154ms, lost 0%','rta=0.154ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628618,2,28533,0,0,1,1,1,1,'2024-12-27 14:05:10',12,'2024-12-27 14:05:12',10135,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628619,2,23552,0,0,1,1,0,1,'2024-12-27 14:05:12',19,'2024-12-27 14:05:12',221,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.120ms, lost 0%','rta=0.120ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628620,2,21397,0,0,1,5,1,1,'2024-12-27 14:05:15',17774,'2024-12-27 14:05:17',334,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628621,2,23553,0,0,1,10,1,1,'2024-12-27 14:05:20',61,'2024-12-27 14:05:21',21439,26989,'','',30,0,0.976,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628622,2,23552,0,0,1,1,0,1,'2024-12-27 14:05:17',22649,'2024-12-27 14:05:21',21650,26989,'','',30,0,0.00966,2.054,0,'OK - 192.168.77.8: rta 0.175ms, lost 0%','rta=0.175ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628623,2,23549,0,0,1,10,0,1,'2024-12-27 14:05:17',377,'2024-12-27 14:05:21',21805,26989,'','',30,0,0.01931,2.057,0,'OK - 84.38.95.222: rta 0.556ms, lost 0%','rta=0.556ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628624,2,23548,0,0,1,5,1,1,'2024-12-27 14:05:17',25167,'2024-12-27 14:05:21',342,26989,'','',30,0,0.9877,2.061,2,'CRITICAL - 172.20.3.11: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628625,2,21397,0,0,1,5,1,1,'2024-12-27 14:05:17',24653,'2024-12-27 14:05:21',42,26989,'','',30,0,0.98888,2.06,2,'CRITICAL - 172.20.3.10: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628626,2,23554,0,0,1,1,0,1,'2024-12-27 14:05:21',2752,'2024-12-27 14:05:21',3308,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628627,2,21395,0,0,1,5,1,1,'2024-12-27 14:05:17',25685,'2024-12-27 14:05:21',26809,26989,'','',30,0,2.00888,2.062,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628628,2,28279,0,0,1,1,0,1,'2024-12-27 14:05:21',3510,'2024-12-27 14:05:25',0,26989,'','',30,0,0.00608,1.066,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628629,2,28533,0,0,1,1,1,1,'2024-12-27 14:05:25',0,'2024-12-27 14:05:30',138024,26989,'','',30,0,2.00785,0.092,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628630,2,23551,0,0,1,1,0,1,'2024-12-27 14:05:30',138374,'2024-12-27 14:05:30',149593,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628631,2,23554,0,0,1,1,0,1,'2024-12-27 14:05:30',152082,'2024-12-27 14:05:35',180830,26989,'','',30,0,0.00908,0.152,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628632,2,23552,0,0,1,1,0,1,'2024-12-27 14:05:35',181232,'2024-12-27 14:05:35',192097,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.123ms, lost 0%','rta=0.123ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628633,2,23553,0,0,1,10,1,1,'2024-12-27 14:05:40',228778,'2024-12-27 14:05:45',252214,26989,'','',30,0,0.0448,0.228,2,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628634,2,21397,0,0,1,5,1,1,'2024-12-27 14:05:45',252278,'2024-12-27 14:05:47',262001,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628635,2,23554,0,0,1,1,0,1,'2024-12-27 14:05:47',262828,'2024-12-27 14:05:47',272977,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628636,2,21396,0,0,1,5,0,1,'2024-12-27 14:05:50',301074,'2024-12-27 14:05:55',327344,26989,'','',30,0,0.03464,0.301,0,'OK - 192.168.77.159: rta 1.364ms, lost 0%','rta=1.364ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628637,2,28533,0,0,1,1,1,1,'2024-12-27 14:05:55',327409,'2024-12-27 14:05:56',388451,26989,'','',30,0,1.06,0,1,'CRITICAL - 172.50.1.3: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628638,2,23551,0,0,1,1,0,1,'2024-12-27 14:06:00',423644,'2024-12-27 14:06:00',434140,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628639,2,23552,0,0,1,1,0,1,'2024-12-27 14:06:05',464020,'2024-12-27 14:06:05',474383,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.135ms, lost 0%','rta=0.135ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628640,2,23553,0,0,1,10,1,1,'2024-12-27 14:06:05',475012,'2024-12-27 14:06:07',484691,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628641,2,23548,0,0,1,5,1,1,'2024-12-27 14:06:10',516936,'2024-12-27 14:06:12',527703,26989,'','',30,0,2.01,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628642,2,23554,0,0,1,1,0,1,'2024-12-27 14:06:12',527968,'2024-12-27 14:06:12',537893,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628643,2,23551,0,0,1,1,0,1,'2024-12-27 14:06:12',540463,'2024-12-27 14:06:15',564112,26989,'','',30,0,0.00987,2.54,0,'OK - 192.168.77.29: rta 0.148ms, lost 0%','rta=0.148ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628644,2,21395,0,0,1,5,1,1,'2024-12-27 14:06:25',634507,'2024-12-27 14:06:27',643428,26989,'','',30,0,2.008,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628645,2,23552,0,0,1,1,0,1,'2024-12-27 14:06:27',643737,'2024-12-27 14:06:27',653447,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.118ms, lost 0%','rta=0.118ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628646,2,23552,0,0,1,1,0,1,'2024-12-27 14:06:21',604509,'2024-12-27 14:06:27',653892,26989,'','',30,0,0.01194,0.604,0,'OK - 192.168.77.8: rta 0.180ms, lost 0%','rta=0.180ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628647,2,23549,0,0,1,10,0,1,'2024-12-27 14:06:21',606823,'2024-12-27 14:06:27',654103,26989,'','',30,0,0.01185,0.606,0,'OK - 84.38.95.222: rta 0.238ms, lost 0%','rta=0.238ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628648,2,23548,0,0,1,5,1,1,'2024-12-27 14:06:21',609741,'2024-12-27 14:06:27',654559,26989,'','',30,0,2.0083,0.609,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628649,2,21397,0,0,1,5,1,1,'2024-12-27 14:06:21',613293,'2024-12-27 14:06:27',654778,26989,'','',30,0,2.00872,0.613,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628650,2,21395,0,0,1,5,1,1,'2024-12-27 14:06:21',616588,'2024-12-27 14:06:27',655003,26989,'','',30,0,2.00742,0.616,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628651,2,28533,0,0,1,1,1,1,'2024-12-27 14:06:30',699714,'2024-12-27 14:06:32',709305,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628652,2,28279,0,0,1,1,0,1,'2024-12-27 14:06:27',657314,'2024-12-27 14:06:32',709803,26989,'','',30,0,0.01274,2.657,0,'OK - 192.168.77.9: rta 0.027ms, lost 0%','rta=0.027ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628653,2,28533,0,0,1,1,1,1,'2024-12-27 14:06:32',712778,'2024-12-27 14:06:35',729492,26989,'','',30,0,0.99551,2.712,2,'CRITICAL - 172.50.1.3: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628654,2,23554,0,0,1,1,0,1,'2024-12-27 14:06:35',731724,'2024-12-27 14:06:40',775510,26989,'','',30,0,0.00952,0.731,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628655,2,23553,0,0,1,10,1,1,'2024-12-27 14:06:40',775584,'2024-12-27 14:06:40',857856,26989,'','',30,0,0.082,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628656,2,23551,0,0,1,1,0,1,'2024-12-27 14:06:40',858195,'2024-12-27 14:06:40',867997,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628657,2,23552,0,0,1,1,0,1,'2024-12-27 14:06:50',927759,'2024-12-27 14:06:50',937761,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.128ms, lost 0%','rta=0.128ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628658,2,23553,0,0,1,10,1,1,'2024-12-27 14:06:45',887555,'2024-12-27 14:06:50',938457,26989,'','',30,0,2.00863,0.887,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628659,2,21395,0,0,1,5,1,1,'2024-12-27 14:06:50',938738,'2024-12-27 14:06:51',909379,26989,'','',30,0,0.971,0,1,'CRITICAL - 192.168.77.154: Host unreachable @ 192.168.77.9. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628660,2,21396,0,0,1,5,0,1,'2024-12-27 14:06:55',942886,'2024-12-27 14:07:00',978410,26989,'','',30,0,0.02244,0.942,0,'OK - 192.168.77.159: rta 0.769ms, lost 0%','rta=0.769ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628661,2,23554,0,0,1,1,0,1,'2024-12-27 14:07:00',978773,'2024-12-27 14:07:00',990341,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628662,2,23551,0,0,1,1,0,1,'2024-12-27 14:07:00',990752,'2024-12-27 14:07:01',131,26989,'','',30,0,0.012,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628663,2,28533,0,0,1,1,1,1,'2024-12-27 14:07:01',19,'2024-12-27 14:07:03',4466,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628664,2,28279,0,0,1,1,0,1,'2024-12-27 14:07:10',46,'2024-12-27 14:07:10',26858,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628665,2,23552,0,0,1,1,0,1,'2024-12-27 14:07:15',0,'2024-12-27 14:07:15',0,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.123ms, lost 0%','rta=0.123ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628666,2,23551,0,0,1,1,0,1,'2024-12-27 14:07:15',0,'2024-12-27 14:07:20',110196,26989,'','',30,0,0.00885,0.094,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628667,2,21396,0,0,1,5,0,1,'2024-12-27 14:07:20',110258,'2024-12-27 14:07:20',134326,26989,'','',30,0,0.023,0,0,'OK - 192.168.77.159: rta 0.809ms, lost 0%','rta=0.809ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628668,2,23553,0,0,1,10,1,1,'2024-12-27 14:07:20',134643,'2024-12-27 14:07:22',143740,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628669,2,23554,0,0,1,1,0,1,'2024-12-27 14:07:25',150952,'2024-12-27 14:07:25',161604,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628670,2,23552,0,0,1,1,0,1,'2024-12-27 14:07:27',168279,'2024-12-27 14:07:30',184641,26989,'','',30,0,0.00881,0.168,0,'OK - 192.168.77.8: rta 0.127ms, lost 0%','rta=0.127ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628671,2,23549,0,0,1,10,0,1,'2024-12-27 14:07:27',171440,'2024-12-27 14:07:30',184879,26989,'','',30,0,0.01328,0.171,0,'OK - 84.38.95.222: rta 0.328ms, lost 0%','rta=0.328ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628672,2,23548,0,0,1,5,1,1,'2024-12-27 14:07:27',173212,'2024-12-27 14:07:30',185123,26989,'','',30,0,2.00763,0.173,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628673,2,21397,0,0,1,5,1,1,'2024-12-27 14:07:27',176264,'2024-12-27 14:07:30',185333,26989,'','',30,0,2.00753,0.176,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628674,2,21395,0,0,1,5,1,1,'2024-12-27 14:07:27',178235,'2024-12-27 14:07:30',185550,26989,'','',30,0,2.00838,0.178,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628675,2,28279,0,0,1,1,0,1,'2024-12-27 14:07:32',194317,'2024-12-27 14:07:35',208273,26989,'','',30,0,0.01566,0.194,0,'OK - 192.168.77.9: rta 0.014ms, lost 0%','rta=0.014ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628676,2,28533,0,0,1,1,1,1,'2024-12-27 14:07:35',210900,'2024-12-27 14:07:40',226348,26989,'','',30,0,2.00804,0.21,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628677,2,23554,0,0,1,1,0,1,'2024-12-27 14:07:40',228680,'2024-12-27 14:07:45',241678,26989,'','',30,0,0.00937,0.228,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628678,2,23552,0,0,1,1,0,1,'2024-12-27 14:07:45',241752,'2024-12-27 14:07:45',252693,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.129ms, lost 0%','rta=0.129ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628679,2,23553,0,0,1,10,1,1,'2024-12-27 14:07:45',253038,'2024-12-27 14:07:47',261742,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628680,2,23549,0,0,1,10,0,1,'2024-12-27 14:07:50',279516,'2024-12-27 14:07:50',291274,26989,'','',30,0,0.011,0,0,'OK - 84.38.95.222: rta 0.204ms, lost 0%','rta=0.204ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628681,2,23553,0,0,1,10,1,1,'2024-12-27 14:07:50',293926,'2024-12-27 14:07:55',313004,26989,'','',30,0,2.00842,0.293,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628682,2,23551,0,0,1,1,0,1,'2024-12-27 14:07:55',313066,'2024-12-27 14:07:55',323755,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628683,2,23554,0,0,1,1,0,1,'2024-12-27 14:08:00',344730,'2024-12-27 14:08:00',355195,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628684,2,21396,0,0,1,5,0,1,'2024-12-27 14:08:00',358359,'2024-12-27 14:08:05',378592,26989,'','',30,0,0.02003,0.358,0,'OK - 192.168.77.159: rta 0.712ms, lost 0%','rta=0.712ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628685,2,28533,0,0,1,1,1,1,'2024-12-27 14:08:05',378912,'2024-12-27 14:08:07',388366,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628686,2,23552,0,0,1,1,0,1,'2024-12-27 14:08:10',397512,'2024-12-27 14:08:10',407634,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.128ms, lost 0%','rta=0.128ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628687,2,21397,0,0,1,5,1,1,'2024-12-27 14:08:15',434244,'2024-12-27 14:08:17',443306,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628688,2,23553,0,0,1,10,1,1,'2024-12-27 14:08:17',443650,'2024-12-27 14:08:18',442263,26989,'','',30,0,0.999,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628689,2,23554,0,0,1,1,0,1,'2024-12-27 14:08:20',463665,'2024-12-27 14:08:20',474824,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628690,2,23549,0,0,1,10,0,1,'2024-12-27 14:08:20',475167,'2024-12-27 14:08:20',488736,26989,'','',30,0,0.013,0,0,'OK - 84.38.95.222: rta 0.334ms, lost 0%','rta=0.334ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628691,2,23551,0,0,1,1,0,1,'2024-12-27 14:08:20',491342,'2024-12-27 14:08:25',517641,26989,'','',30,0,0.0089,0.491,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628692,2,28533,0,0,1,1,1,1,'2024-12-27 14:08:25',517991,'2024-12-27 14:08:27',528244,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628693,2,23552,0,0,1,1,0,1,'2024-12-27 14:08:30',579407,'2024-12-27 14:08:35',619015,26989,'','',30,0,0.01051,0.579,0,'OK - 192.168.77.8: rta 0.168ms, lost 0%','rta=0.168ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628694,2,23549,0,0,1,10,0,1,'2024-12-27 14:08:30',582937,'2024-12-27 14:08:35',619252,26989,'','',30,0,0.01393,0.582,0,'OK - 84.38.95.222: rta 0.261ms, lost 0%','rta=0.261ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628695,2,28279,0,0,1,1,0,1,'2024-12-27 14:08:35',619314,'2024-12-27 14:08:35',626990,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.016ms, lost 0%','rta=0.016ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628696,2,23548,0,0,1,5,1,1,'2024-12-27 14:08:30',584822,'2024-12-27 14:08:35',627523,26989,'','',30,0,2.00992,0.584,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628697,2,21395,0,0,1,5,1,1,'2024-12-27 14:08:30',587805,'2024-12-27 14:08:35',627777,26989,'','',30,0,2.00854,0.587,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628698,2,21397,0,0,1,5,1,1,'2024-12-27 14:08:30',585843,'2024-12-27 14:08:35',628030,26989,'','',30,0,2.01065,0.585,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628699,2,28279,0,0,1,1,0,1,'2024-12-27 14:08:35',630672,'2024-12-27 14:08:40',664009,26989,'','',30,0,0.006,0.63,0,'OK - 192.168.77.9: rta 0.014ms, lost 0%','rta=0.014ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628700,2,23551,0,0,1,1,0,1,'2024-12-27 14:08:40',664084,'2024-12-27 14:08:40',675260,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628701,2,28533,0,0,1,1,1,1,'2024-12-27 14:08:40',681111,'2024-12-27 14:08:45',707293,26989,'','',30,0,2.0079,0.681,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628702,2,23553,0,0,1,10,1,1,'2024-12-27 14:08:45',707362,'2024-12-27 14:08:47',717300,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628703,2,23554,0,0,1,1,0,1,'2024-12-27 14:08:47',717893,'2024-12-27 14:08:47',728092,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628704,2,23554,0,0,1,1,0,1,'2024-12-27 14:08:47',730661,'2024-12-27 14:08:50',756812,26989,'','',30,0,0.00901,2.73,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628705,2,23553,0,0,1,10,1,1,'2024-12-27 14:08:55',787818,'2024-12-27 14:09:00',824676,26989,'','',30,0,2.00794,0.787,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628706,2,28533,0,0,1,1,1,1,'2024-12-27 14:09:00',825278,'2024-12-27 14:09:02',834722,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628707,2,23551,0,0,1,1,0,1,'2024-12-27 14:09:02',835047,'2024-12-27 14:09:02',845214,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628708,2,23552,0,0,1,1,0,1,'2024-12-27 14:09:05',876416,'2024-12-27 14:09:05',886802,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.134ms, lost 0%','rta=0.134ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628709,2,21396,0,0,1,5,0,1,'2024-12-27 14:09:05',889896,'2024-12-27 14:09:10',916204,26989,'','',30,0,0.0206,0.889,0,'OK - 192.168.77.159: rta 0.731ms, lost 0%','rta=0.731ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628710,2,23548,0,0,1,5,1,1,'2024-12-27 14:09:10',916257,'2024-12-27 14:09:12',924167,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628711,2,23554,0,0,1,1,0,1,'2024-12-27 14:09:12',924504,'2024-12-27 14:09:12',935703,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628712,2,21395,0,0,1,5,1,1,'2024-12-27 14:09:25',3898,'2024-12-27 14:09:27',15,26989,'','',30,0,2.01,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628713,2,23552,0,0,1,1,0,1,'2024-12-27 14:09:27',1,'2024-12-27 14:09:27',2,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.130ms, lost 0%','rta=0.130ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628714,2,23551,0,0,1,1,0,1,'2024-12-27 14:09:27',2,'2024-12-27 14:09:27',3,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628715,2,28533,0,0,1,1,1,1,'2024-12-27 14:09:30',5,'2024-12-27 14:09:32',6,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628716,2,23551,0,0,1,1,0,1,'2024-12-27 14:09:27',32,'2024-12-27 14:09:32',450,26989,'','',30,0,0.01118,2.04,0,'OK - 192.168.77.29: rta 0.253ms, lost 0%','rta=0.253ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628717,2,23548,0,0,1,5,1,1,'2024-12-27 14:09:32',453,'2024-12-27 14:09:34',7,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628718,2,23552,0,0,1,1,0,1,'2024-12-27 14:09:35',0,'2024-12-27 14:09:40',121711,26989,'','',30,0,0.00844,0.085,0,'OK - 192.168.77.8: rta 0.117ms, lost 0%','rta=0.117ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628719,2,23549,0,0,1,10,0,1,'2024-12-27 14:09:35',0,'2024-12-27 14:09:40',121917,26989,'','',30,0,0.01449,0.088,0,'OK - 84.38.95.222: rta 0.331ms, lost 0%','rta=0.331ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628720,2,23548,0,0,1,5,1,1,'2024-12-27 14:09:35',0,'2024-12-27 14:09:40',122151,26989,'','',30,0,2.00826,0.091,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628721,2,21397,0,0,1,5,1,1,'2024-12-27 14:09:35',0,'2024-12-27 14:09:40',122394,26989,'','',30,0,2.00831,0.093,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628722,2,21395,0,0,1,5,1,1,'2024-12-27 14:09:35',0,'2024-12-27 14:09:40',122623,26989,'','',30,0,2.01022,0.092,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628723,2,23553,0,0,1,10,1,1,'2024-12-27 14:09:40',122680,'2024-12-27 14:09:42',132415,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628724,2,28279,0,0,1,1,0,1,'2024-12-27 14:09:42',151721,'2024-12-27 14:09:45',167385,26989,'','',30,0,0.00636,2.151,0,'OK - 192.168.77.9: rta 0.014ms, lost 0%','rta=0.014ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628725,2,28533,0,0,1,1,1,1,'2024-12-27 14:09:45',170343,'2024-12-27 14:09:50',188732,26989,'','',30,0,2.0086,0.17,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628726,2,23554,0,0,1,1,0,1,'2024-12-27 14:09:50',188808,'2024-12-27 14:09:50',199829,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628727,2,21395,0,0,1,5,1,1,'2024-12-27 14:09:55',247170,'2024-12-27 14:09:57',257587,26989,'','',30,0,2.01,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628728,2,23554,0,0,1,1,0,1,'2024-12-27 14:09:50',203463,'2024-12-27 14:09:57',258047,26989,'','',30,0,0.00905,0.203,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628729,2,23553,0,0,1,10,1,1,'2024-12-27 14:09:57',258102,'2024-12-27 14:09:59',265957,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628730,2,23552,0,0,1,1,0,1,'2024-12-27 14:10:00',277269,'2024-12-27 14:10:00',288004,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.115ms, lost 0%','rta=0.115ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628731,2,23551,0,0,1,1,0,1,'2024-12-27 14:10:00',288611,'2024-12-27 14:10:00',298894,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628732,2,23553,0,0,1,10,1,1,'2024-12-27 14:10:00',301631,'2024-12-27 14:10:05',318126,26989,'','',30,0,2.00697,0.301,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628733,2,28279,0,0,1,1,0,1,'2024-12-27 14:10:10',339980,'2024-12-27 14:10:10',347624,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628734,2,21396,0,0,1,5,0,1,'2024-12-27 14:10:10',350364,'2024-12-27 14:10:15',363622,26989,'','',30,0,0.02687,0.35,0,'OK - 192.168.77.159: rta 1.053ms, lost 0%','rta=1.053ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628735,2,23553,0,0,1,10,1,1,'2024-12-27 14:10:20',391069,'2024-12-27 14:10:22',400855,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628736,2,23554,0,0,1,1,0,1,'2024-12-27 14:10:25',423519,'2024-12-27 14:10:25',433594,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628737,2,23551,0,0,1,1,0,1,'2024-12-27 14:10:32',468153,'2024-12-27 14:10:35',488792,26989,'','',30,0,0.00951,0.468,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628738,2,23552,0,0,1,1,0,1,'2024-12-27 14:10:40',519180,'2024-12-27 14:10:45',554912,26989,'','',30,0,0.00958,0.519,0,'OK - 192.168.77.8: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628739,2,23549,0,0,1,10,0,1,'2024-12-27 14:10:40',522697,'2024-12-27 14:10:45',555118,26989,'','',30,0,0.01094,0.522,0,'OK - 84.38.95.222: rta 0.200ms, lost 0%','rta=0.200ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628740,2,23548,0,0,1,5,1,1,'2024-12-27 14:10:40',526365,'2024-12-27 14:10:45',555346,26989,'','',30,0,0.63364,0.526,2,'CRITICAL - 172.20.3.11: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628741,2,21397,0,0,1,5,1,1,'2024-12-27 14:10:40',530040,'2024-12-27 14:10:45',555590,26989,'','',30,0,0.63005,0.53,2,'CRITICAL - 172.20.3.10: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628742,2,21395,0,0,1,5,1,1,'2024-12-27 14:10:40',532589,'2024-12-27 14:10:45',555816,26989,'','',30,0,2.0086,0.532,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628743,2,23553,0,0,1,10,1,1,'2024-12-27 14:10:45',556149,'2024-12-27 14:10:47',565241,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628744,2,28279,0,0,1,1,0,1,'2024-12-27 14:10:47',567694,'2024-12-27 14:10:50',599736,26989,'','',30,0,0.00609,2.567,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628745,2,23554,0,0,1,1,0,1,'2024-12-27 14:10:55',626967,'2024-12-27 14:10:55',637989,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628746,2,28533,0,0,1,1,1,1,'2024-12-27 14:10:50',602569,'2024-12-27 14:10:55',638524,26989,'','',30,0,2.00728,0.602,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628747,2,23551,0,0,1,1,0,1,'2024-12-27 14:10:55',638585,'2024-12-27 14:10:55',648460,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.154ms, lost 0%','rta=0.154ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628748,2,23554,0,0,1,1,0,1,'2024-12-27 14:10:57',658498,'2024-12-27 14:11:00',695390,26989,'','',30,0,0.00969,0.658,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628749,2,23553,0,0,1,10,1,1,'2024-12-27 14:11:05',733264,'2024-12-27 14:11:10',766718,26989,'','',30,0,2.00924,0.733,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628750,2,23552,0,0,1,1,0,1,'2024-12-27 14:11:10',766799,'2024-12-27 14:11:10',777399,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.113ms, lost 0%','rta=0.113ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628751,2,21397,0,0,1,5,1,1,'2024-12-27 14:11:15',791039,'2024-12-27 14:11:17',800622,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628752,2,21396,0,0,1,5,0,1,'2024-12-27 14:11:17',803459,'2024-12-27 14:11:20',839537,26989,'','',30,0,0.02284,2.803,0,'OK - 192.168.77.159: rta 0.840ms, lost 0%','rta=0.840ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628753,2,23554,0,0,1,1,0,1,'2024-12-27 14:11:20',839617,'2024-12-27 14:11:20',850723,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628754,2,23549,0,0,1,10,0,1,'2024-12-27 14:11:20',851064,'2024-12-27 14:11:20',862042,26989,'','',30,0,0.01,0,0,'OK - 84.38.95.222: rta 0.199ms, lost 0%','rta=0.199ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628755,2,28533,0,0,1,1,1,1,'2024-12-27 14:11:25',890286,'2024-12-27 14:11:27',899041,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628756,2,23551,0,0,1,1,0,1,'2024-12-27 14:11:30',933750,'2024-12-27 14:11:30',944779,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628757,2,28279,0,0,1,1,0,1,'2024-12-27 14:11:35',983433,'2024-12-27 14:11:35',991258,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.016ms, lost 0%','rta=0.016ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628758,2,23552,0,0,1,1,0,1,'2024-12-27 14:11:35',991625,'2024-12-27 14:11:36',71,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.132ms, lost 0%','rta=0.132ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628759,2,23551,0,0,1,1,0,1,'2024-12-27 14:11:36',2021,'2024-12-27 14:11:40',5387,26989,'','',30,0,0.00988,1.003,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628760,2,21397,0,0,1,5,1,1,'2024-12-27 14:11:45',2,'2024-12-27 14:11:47',3,26989,'','',30,0,2.01,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628761,2,23554,0,0,1,1,0,1,'2024-12-27 14:11:47',260,'2024-12-27 14:11:47',333,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628762,2,23553,0,0,1,10,1,1,'2024-12-27 14:11:47',41,'2024-12-27 14:11:48',31,26989,'','',30,0,0.986,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628763,2,23549,0,0,1,10,0,1,'2024-12-27 14:11:48',17342,'2024-12-27 14:11:50',6,26989,'','',30,0,0.01306,3.041,0,'OK - 84.38.95.222: rta 0.343ms, lost 0%','rta=0.343ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628764,2,23552,0,0,1,1,0,1,'2024-12-27 14:11:48',16696,'2024-12-27 14:11:50',6,26989,'','',30,0,0.01516,3.04,0,'OK - 192.168.77.8: rta 0.187ms, lost 0%','rta=0.187ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628765,2,23548,0,0,1,5,1,1,'2024-12-27 14:11:48',294,'2024-12-27 14:11:50',6,26989,'','',30,0,2.00802,3.044,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628766,2,21397,0,0,1,5,1,1,'2024-12-27 14:11:48',4,'2024-12-27 14:11:50',28756,26989,'','',30,0,2.00925,3.048,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628767,2,21395,0,0,1,5,1,1,'2024-12-27 14:11:48',21433,'2024-12-27 14:11:50',451,26989,'','',30,0,2.008,3.051,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628768,2,28279,0,0,1,1,0,1,'2024-12-27 14:11:50',30193,'2024-12-27 14:11:55',0,26989,'','',30,0,0.00744,0.072,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628769,2,28533,0,0,1,1,1,1,'2024-12-27 14:11:55',0,'2024-12-27 14:11:57',100024,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628770,2,28533,0,0,1,1,1,1,'2024-12-27 14:11:57',102512,'2024-12-27 14:12:00',120263,26989,'','',30,0,0.9946,2.102,2,'CRITICAL - 172.50.1.3: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628771,2,23551,0,0,1,1,0,1,'2024-12-27 14:12:00',120548,'2024-12-27 14:12:00',130910,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628772,2,23554,0,0,1,1,0,1,'2024-12-27 14:12:00',133618,'2024-12-27 14:12:05',148043,26989,'','',30,0,0.00893,0.133,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628773,2,23552,0,0,1,1,0,1,'2024-12-27 14:12:05',148106,'2024-12-27 14:12:05',159157,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.134ms, lost 0%','rta=0.134ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628774,2,23553,0,0,1,10,1,1,'2024-12-27 14:12:05',159477,'2024-12-27 14:12:07',167812,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628775,2,23548,0,0,1,5,1,1,'2024-12-27 14:12:10',181635,'2024-12-27 14:12:12',191425,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628776,2,23553,0,0,1,10,1,1,'2024-12-27 14:12:12',194335,'2024-12-27 14:12:15',206083,26989,'','',30,0,0.9952,2.194,2,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628777,2,21396,0,0,1,5,0,1,'2024-12-27 14:12:20',228567,'2024-12-27 14:12:25',240146,26989,'','',30,0,0.02619,0.228,0,'OK - 192.168.77.159: rta 0.918ms, lost 0%','rta=0.918ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628778,2,21395,0,0,1,5,1,1,'2024-12-27 14:12:25',240215,'2024-12-27 14:12:27',250105,26989,'','',30,0,2.009,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628779,2,23552,0,0,1,1,0,1,'2024-12-27 14:12:27',250444,'2024-12-27 14:12:27',260023,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.119ms, lost 0%','rta=0.119ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628780,2,23551,0,0,1,1,0,1,'2024-12-27 14:12:27',260360,'2024-12-27 14:12:27',270246,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628781,2,28533,0,0,1,1,1,1,'2024-12-27 14:12:30',312933,'2024-12-27 14:12:32',321922,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628782,2,23548,0,0,1,5,1,1,'2024-12-27 14:12:32',322548,'2024-12-27 14:12:34',331310,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628783,2,23553,0,0,1,10,1,1,'2024-12-27 14:12:40',388483,'2024-12-27 14:12:40',468415,26989,'','',30,0,0.079,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628784,2,23551,0,0,1,1,0,1,'2024-12-27 14:12:40',471578,'2024-12-27 14:12:45',501568,26989,'','',30,0,0.009,0.471,0,'OK - 192.168.77.29: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628785,2,23554,0,0,1,1,0,1,'2024-12-27 14:12:50',543384,'2024-12-27 14:12:50',554120,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.159ms, lost 0%','rta=0.159ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628786,2,23552,0,0,1,1,0,1,'2024-12-27 14:12:50',554433,'2024-12-27 14:12:50',563829,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.126ms, lost 0%','rta=0.126ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628787,2,21395,0,0,1,5,1,1,'2024-12-27 14:12:55',602153,'2024-12-27 14:12:57',611253,26989,'','',30,0,2.008,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628788,2,23552,0,0,1,1,0,1,'2024-12-27 14:12:50',569893,'2024-12-27 14:12:57',611618,26989,'','',30,0,0.00944,0.569,0,'OK - 192.168.77.8: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628789,2,23549,0,0,1,10,0,1,'2024-12-27 14:12:50',566820,'2024-12-27 14:12:57',611776,26989,'','',30,0,0.01423,0.566,0,'OK - 84.38.95.222: rta 0.417ms, lost 0%','rta=0.417ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628790,2,21395,0,0,1,5,1,1,'2024-12-27 14:12:50',577841,'2024-12-27 14:12:57',611939,26989,'','',30,0,0.94427,0.577,2,'CRITICAL - 192.168.77.154: Host unreachable @ 192.168.77.9. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628791,2,23548,0,0,1,5,1,1,'2024-12-27 14:12:50',571703,'2024-12-27 14:12:57',612096,26989,'','',30,0,1.02043,0.571,2,'CRITICAL - 172.20.3.11: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628792,2,21397,0,0,1,5,1,1,'2024-12-27 14:12:50',574762,'2024-12-27 14:12:57',612261,26989,'','',30,0,1.01745,0.574,2,'CRITICAL - 172.20.3.10: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628793,2,23553,0,0,1,10,1,1,'2024-12-27 14:12:57',612301,'2024-12-27 14:12:59',621499,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628794,2,28279,0,0,1,1,0,1,'2024-12-27 14:12:59',624330,'2024-12-27 14:13:00',668379,26989,'','',30,0,0.00971,4.624,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628795,2,23551,0,0,1,1,0,1,'2024-12-27 14:13:00',668433,'2024-12-27 14:13:00',679689,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.29: rta 0.154ms, lost 0%','rta=0.154ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628796,2,28533,0,0,1,1,1,1,'2024-12-27 14:13:00',679959,'2024-12-27 14:13:02',688873,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628797,2,28533,0,0,1,1,1,1,'2024-12-27 14:13:02',691298,'2024-12-27 14:13:05',714009,26989,'','',30,0,0.9957,2.691,2,'CRITICAL - 172.50.1.3: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628798,2,23554,0,0,1,1,0,1,'2024-12-27 14:13:05',716311,'2024-12-27 14:13:10',749306,26989,'','',30,0,0.01016,0.716,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628799,2,23552,0,0,1,1,0,1,'2024-12-27 14:13:15',766221,'2024-12-27 14:13:15',776840,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.119ms, lost 0%','rta=0.119ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628800,2,21396,0,0,1,5,0,1,'2024-12-27 14:13:20',813500,'2024-12-27 14:13:20',842445,26989,'','',30,0,0.028,0,0,'OK - 192.168.77.159: rta 1.069ms, lost 0%','rta=1.069ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628801,2,23553,0,0,1,10,1,1,'2024-12-27 14:13:15',779374,'2024-12-27 14:13:20',843000,26989,'','',30,0,2.0076,0.779,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628802,2,23554,0,0,1,1,0,1,'2024-12-27 14:13:25',860736,'2024-12-27 14:13:25',871056,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628803,2,21396,0,0,1,5,0,1,'2024-12-27 14:13:25',873421,'2024-12-27 14:13:30',901015,26989,'','',30,0,0.02019,0.873,0,'OK - 192.168.77.159: rta 0.720ms, lost 0%','rta=0.720ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628804,2,23552,0,0,1,1,0,1,'2024-12-27 14:13:45',987453,'2024-12-27 14:13:45',997194,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.123ms, lost 0%','rta=0.123ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628805,2,23553,0,0,1,10,1,1,'2024-12-27 14:13:45',997540,'2024-12-27 14:13:48',5,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628806,2,23551,0,0,1,1,0,1,'2024-12-27 14:13:48',0,'2024-12-27 14:13:50',1503,26989,'','',30,0,0.00893,3.008,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628807,2,23549,0,0,1,10,0,1,'2024-12-27 14:13:50',190,'2024-12-27 14:13:50',3,26989,'','',30,0,0.011,0,0,'OK - 84.38.95.222: rta 0.201ms, lost 0%','rta=0.201ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628808,2,23554,0,0,1,1,0,1,'2024-12-27 14:13:55',5,'2024-12-27 14:13:55',451,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628809,2,23549,0,0,1,10,0,1,'2024-12-27 14:13:57',0,'2024-12-27 14:14:00',112158,26989,'','',30,0,0.01169,0.09,0,'OK - 84.38.95.222: rta 0.200ms, lost 0%','rta=0.200ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628810,2,23552,0,0,1,1,0,1,'2024-12-27 14:13:57',0,'2024-12-27 14:14:00',112382,26989,'','',30,0,0.02108,0.081,0,'OK - 192.168.77.8: rta 0.264ms, lost 0%','rta=0.264ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628811,2,21395,0,0,1,5,1,1,'2024-12-27 14:13:57',0,'2024-12-27 14:14:00',113118,26989,'','',30,0,2.00761,0.092,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628812,2,23548,0,0,1,5,1,1,'2024-12-27 14:13:57',0,'2024-12-27 14:14:00',113328,26989,'','',30,0,2.00775,0.095,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628813,2,21397,0,0,1,5,1,1,'2024-12-27 14:13:57',0,'2024-12-27 14:14:00',113550,26989,'','',30,0,2.00773,0.098,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628814,2,28279,0,0,1,1,0,1,'2024-12-27 14:14:00',116306,'2024-12-27 14:14:05',129775,26989,'','',30,0,0.00776,0.116,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628815,2,28533,0,0,1,1,1,1,'2024-12-27 14:14:05',130099,'2024-12-27 14:14:07',161256,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628816,2,28533,0,0,1,1,1,1,'2024-12-27 14:14:07',163766,'2024-12-27 14:14:10',174226,26989,'','',30,0,0.97312,2.163,2,'CRITICAL - 172.50.1.3: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628817,2,23554,0,0,1,1,0,1,'2024-12-27 14:14:10',176386,'2024-12-27 14:14:15',218380,26989,'','',30,0,0.0098,0.176,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628818,2,21397,0,0,1,5,1,1,'2024-12-27 14:14:15',218442,'2024-12-27 14:14:17',227483,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628819,2,23553,0,0,1,10,1,1,'2024-12-27 14:14:17',236124,'2024-12-27 14:14:18',226680,26989,'','',30,0,0.991,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628820,2,23549,0,0,1,10,0,1,'2024-12-27 14:14:20',238372,'2024-12-27 14:14:20',251603,26989,'','',30,0,0.013,0,0,'OK - 84.38.95.222: rta 0.255ms, lost 0%','rta=0.255ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628821,2,23553,0,0,1,10,1,1,'2024-12-27 14:14:20',254097,'2024-12-27 14:14:25',267704,26989,'','',30,0,2.00732,0.254,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628822,2,28533,0,0,1,1,1,1,'2024-12-27 14:14:25',267994,'2024-12-27 14:14:27',277317,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628823,2,23551,0,0,1,1,0,1,'2024-12-27 14:14:30',320449,'2024-12-27 14:14:30',331406,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628824,2,21396,0,0,1,5,0,1,'2024-12-27 14:14:30',334004,'2024-12-27 14:14:35',347092,26989,'','',30,0,0.02928,0.333,0,'OK - 192.168.77.159: rta 1.163ms, lost 0%','rta=1.163ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628825,2,28279,0,0,1,1,0,1,'2024-12-27 14:14:35',347173,'2024-12-27 14:14:35',355264,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628826,2,23552,0,0,1,1,0,1,'2024-12-27 14:14:35',355626,'2024-12-27 14:14:35',365197,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.138ms, lost 0%','rta=0.138ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628827,2,21397,0,0,1,5,1,1,'2024-12-27 14:14:45',396019,'2024-12-27 14:14:47',406775,26989,'','',30,0,2.01,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628828,2,23553,0,0,1,10,1,1,'2024-12-27 14:14:47',407084,'2024-12-27 14:14:48',404914,26989,'','',30,0,0.998,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628829,2,23554,0,0,1,1,0,1,'2024-12-27 14:14:48',405484,'2024-12-27 14:14:48',415682,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628830,2,23551,0,0,1,1,0,1,'2024-12-27 14:14:50',428944,'2024-12-27 14:14:55',449428,26989,'','',30,0,0.00969,0.428,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628831,2,28533,0,0,1,1,1,1,'2024-12-27 14:14:55',449493,'2024-12-27 14:14:56',534425,26989,'','',30,0,1.084,0,1,'CRITICAL - 172.50.1.3: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628832,2,23549,0,0,1,10,0,1,'2024-12-27 14:15:00',553888,'2024-12-27 14:15:05',598311,26989,'','',30,0,0.0113,0.553,0,'OK - 84.38.95.222: rta 0.203ms, lost 0%','rta=0.203ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628833,2,23552,0,0,1,1,0,1,'2024-12-27 14:15:00',557138,'2024-12-27 14:15:05',598528,26989,'','',30,0,0.01165,0.557,0,'OK - 192.168.77.8: rta 0.180ms, lost 0%','rta=0.180ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628834,2,21395,0,0,1,5,1,1,'2024-12-27 14:15:00',559140,'2024-12-27 14:15:05',598757,26989,'','',30,0,2.0097,0.559,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628835,2,23548,0,0,1,5,1,1,'2024-12-27 14:15:00',560190,'2024-12-27 14:15:05',598971,26989,'','',30,0,2.00901,0.56,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628836,2,21397,0,0,1,5,1,1,'2024-12-27 14:15:00',561256,'2024-12-27 14:15:05',599180,26989,'','',30,0,2.00881,0.561,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628837,2,23553,0,0,1,10,1,1,'2024-12-27 14:15:05',599485,'2024-12-27 14:15:07',608911,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628838,2,23551,0,0,1,1,0,1,'2024-12-27 14:15:07',609220,'2024-12-27 14:15:07',619116,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.148ms, lost 0%','rta=0.148ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628839,2,28279,0,0,1,1,0,1,'2024-12-27 14:15:07',621540,'2024-12-27 14:15:10',650776,26989,'','',30,0,0.00603,2.621,0,'OK - 192.168.77.9: rta 0.014ms, lost 0%','rta=0.014ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628840,2,23554,0,0,1,1,0,1,'2024-12-27 14:15:10',651108,'2024-12-27 14:15:10',661443,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.148ms, lost 0%','rta=0.148ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628841,2,28533,0,0,1,1,1,1,'2024-12-27 14:15:10',664017,'2024-12-27 14:15:15',688055,26989,'','',30,0,2.00763,0.663,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628842,2,23554,0,0,1,1,0,1,'2024-12-27 14:15:15',696951,'2024-12-27 14:15:20',721019,26989,'','',30,0,0.00976,0.696,0,'OK - 192.168.77.208: rta 0.154ms, lost 0%','rta=0.154ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628843,2,21395,0,0,1,5,1,1,'2024-12-27 14:15:25',749868,'2024-12-27 14:15:27',758950,26989,'','',30,0,2.008,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628844,2,23552,0,0,1,1,0,1,'2024-12-27 14:15:27',759267,'2024-12-27 14:15:27',769379,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.155ms, lost 0%','rta=0.155ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628845,2,23551,0,0,1,1,0,1,'2024-12-27 14:15:27',769679,'2024-12-27 14:15:27',779534,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628846,2,28533,0,0,1,1,1,1,'2024-12-27 14:15:30',815971,'2024-12-27 14:15:32',826543,26989,'','',30,0,2.01,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628847,2,23553,0,0,1,10,1,1,'2024-12-27 14:15:27',782073,'2024-12-27 14:15:32',827358,26989,'','',30,0,2.00738,2.782,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628848,2,23548,0,0,1,5,1,1,'2024-12-27 14:15:32',827432,'2024-12-27 14:15:34',836862,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628849,2,21396,0,0,1,5,0,1,'2024-12-27 14:15:35',859037,'2024-12-27 14:15:40',890403,26989,'','',30,0,0.02825,0.859,0,'OK - 192.168.77.159: rta 1.098ms, lost 0%','rta=1.098ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628850,2,23553,0,0,1,10,1,1,'2024-12-27 14:15:50',956508,'2024-12-27 14:15:52',785,26989,'','',30,0,1.058,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628851,2,23554,0,0,1,1,0,1,'2024-12-27 14:15:52',6527,'2024-12-27 14:15:52',10569,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.155ms, lost 0%','rta=0.155ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628852,2,23552,0,0,1,1,0,1,'2024-12-27 14:15:52',20,'2024-12-27 14:15:52',27,26989,'','',30,0,0.008,0,0,'OK - 192.168.77.8: rta 0.120ms, lost 0%','rta=0.120ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628853,2,21395,0,0,1,5,1,1,'2024-12-27 14:15:55',18966,'2024-12-27 14:15:57',22792,26989,'','',30,0,2.009,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628854,2,23551,0,0,1,1,0,1,'2024-12-27 14:15:57',24300,'2024-12-27 14:16:00',57,26989,'','',30,0,0.00902,2.057,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628855,2,28533,0,0,1,1,1,1,'2024-12-27 14:16:00',30048,'2024-12-27 14:16:02',0,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628856,2,23549,0,0,1,10,0,1,'2024-12-27 14:16:05',0,'2024-12-27 14:16:10',123629,26989,'','',30,0,0.01195,0.094,0,'OK - 84.38.95.222: rta 0.269ms, lost 0%','rta=0.269ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628857,2,23552,0,0,1,1,0,1,'2024-12-27 14:16:05',0,'2024-12-27 14:16:10',123884,26989,'','',30,0,0.00962,0.097,0,'OK - 192.168.77.8: rta 0.163ms, lost 0%','rta=0.163ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628858,2,28279,0,0,1,1,0,1,'2024-12-27 14:16:10',124228,'2024-12-27 14:16:10',132784,26989,'','',30,0,0.008,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628859,2,21395,0,0,1,5,1,1,'2024-12-27 14:16:05',100695,'2024-12-27 14:16:10',133331,26989,'','',30,0,2.01019,0.1,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628860,2,23548,0,0,1,5,1,1,'2024-12-27 14:16:05',104100,'2024-12-27 14:16:10',133586,26989,'','',30,0,2.00974,0.104,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628861,2,21397,0,0,1,5,1,1,'2024-12-27 14:16:05',106013,'2024-12-27 14:16:10',133839,26989,'','',30,0,2.00982,0.105,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628862,2,28279,0,0,1,1,0,1,'2024-12-27 14:16:10',136491,'2024-12-27 14:16:15',150254,26989,'','',30,0,0.00606,0.136,0,'OK - 192.168.77.9: rta 0.014ms, lost 0%','rta=0.014ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628863,2,21396,0,0,1,5,0,1,'2024-12-27 14:16:20',170501,'2024-12-27 14:16:20',200497,26989,'','',30,0,0.029,0,0,'OK - 192.168.77.159: rta 1.110ms, lost 0%','rta=1.110ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628864,2,28533,0,0,1,1,1,1,'2024-12-27 14:16:15',152843,'2024-12-27 14:16:20',200992,26989,'','',30,0,2.00821,0.152,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628865,2,23553,0,0,1,10,1,1,'2024-12-27 14:16:20',201050,'2024-12-27 14:16:22',209891,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628866,2,23554,0,0,1,1,0,1,'2024-12-27 14:16:25',221610,'2024-12-27 14:16:25',231395,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628867,2,23554,0,0,1,1,0,1,'2024-12-27 14:16:22',212547,'2024-12-27 14:16:25',231860,26989,'','',30,0,0.00888,2.212,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628868,2,23553,0,0,1,10,1,1,'2024-12-27 14:16:32',251203,'2024-12-27 14:16:35',277363,26989,'','',30,0,2.008,0.251,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628869,2,21396,0,0,1,5,0,1,'2024-12-27 14:16:40',314216,'2024-12-27 14:16:45',338549,26989,'','',30,0,0.02855,0.314,0,'OK - 192.168.77.159: rta 1.111ms, lost 0%','rta=1.111ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628870,2,23552,0,0,1,1,0,1,'2024-12-27 14:16:45',338636,'2024-12-27 14:16:45',349181,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.112ms, lost 0%','rta=0.112ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628871,2,23549,0,0,1,10,0,1,'2024-12-27 14:16:50',381565,'2024-12-27 14:16:50',397752,26989,'','',30,0,0.015,0,0,'OK - 84.38.95.222: rta 0.439ms, lost 0%','rta=0.439ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628872,2,23554,0,0,1,1,0,1,'2024-12-27 14:16:55',426149,'2024-12-27 14:16:55',437251,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628873,2,23551,0,0,1,1,0,1,'2024-12-27 14:16:55',437613,'2024-12-27 14:16:55',447528,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628874,2,23551,0,0,1,1,0,1,'2024-12-27 14:17:00',485933,'2024-12-27 14:17:05',512396,26989,'','',30,0,0.01029,0.485,0,'OK - 192.168.77.29: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628875,2,28533,0,0,1,1,1,1,'2024-12-27 14:17:05',512759,'2024-12-27 14:17:07',522254,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628876,2,23552,0,0,1,1,0,1,'2024-12-27 14:17:10',546160,'2024-12-27 14:17:10',556386,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.121ms, lost 0%','rta=0.121ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628877,2,23549,0,0,1,10,0,1,'2024-12-27 14:17:10',558920,'2024-12-27 14:17:15',596999,26989,'','',30,0,0.01253,0.558,0,'OK - 84.38.95.222: rta 0.323ms, lost 0%','rta=0.323ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628878,2,23552,0,0,1,1,0,1,'2024-12-27 14:17:10',561981,'2024-12-27 14:17:15',597226,26989,'','',30,0,0.0101,0.561,0,'OK - 192.168.77.8: rta 0.144ms, lost 0%','rta=0.144ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628879,2,21395,0,0,1,5,1,1,'2024-12-27 14:17:10',565500,'2024-12-27 14:17:15',597444,26989,'','',30,0,2.00943,0.565,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628880,2,21397,0,0,1,5,1,1,'2024-12-27 14:17:10',570889,'2024-12-27 14:17:15',597664,26989,'','',30,0,2.00802,0.57,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628881,2,23548,0,0,1,5,1,1,'2024-12-27 14:17:10',568917,'2024-12-27 14:17:15',597890,26989,'','',30,0,2.0114,0.568,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628882,2,23553,0,0,1,10,1,1,'2024-12-27 14:17:15',598198,'2024-12-27 14:17:17',606768,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628883,2,28279,0,0,1,1,0,1,'2024-12-27 14:17:17',609286,'2024-12-27 14:17:20',640425,26989,'','',30,0,0.00611,2.609,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628884,2,23554,0,0,1,1,0,1,'2024-12-27 14:17:20',640486,'2024-12-27 14:17:20',651082,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628885,2,28533,0,0,1,1,1,1,'2024-12-27 14:17:20',653829,'2024-12-27 14:17:25',681677,26989,'','',30,0,2.00766,0.653,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628886,2,23554,0,0,1,1,0,1,'2024-12-27 14:17:25',684421,'2024-12-27 14:17:30',719858,26989,'','',30,0,0.00928,0.684,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628887,2,23551,0,0,1,1,0,1,'2024-12-27 14:17:30',720205,'2024-12-27 14:17:30',731178,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.148ms, lost 0%','rta=0.148ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628888,2,28279,0,0,1,1,0,1,'2024-12-27 14:17:35',746753,'2024-12-27 14:17:35',755522,26989,'','',30,0,0.008,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628889,2,23552,0,0,1,1,0,1,'2024-12-27 14:17:35',755855,'2024-12-27 14:17:35',765433,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.132ms, lost 0%','rta=0.132ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628890,2,23553,0,0,1,10,1,1,'2024-12-27 14:17:35',768038,'2024-12-27 14:17:40',793534,26989,'','',30,0,0.07961,0.768,2,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628891,2,21397,0,0,1,5,1,1,'2024-12-27 14:17:45',833589,'2024-12-27 14:17:47',842983,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628892,2,23554,0,0,1,1,0,1,'2024-12-27 14:17:47',843792,'2024-12-27 14:17:47',854052,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628893,2,21396,0,0,1,5,0,1,'2024-12-27 14:17:47',856603,'2024-12-27 14:17:50',876034,26989,'','',30,0,0.02275,2.856,0,'OK - 192.168.77.159: rta 0.839ms, lost 0%','rta=0.839ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628894,2,28533,0,0,1,1,1,1,'2024-12-27 14:17:55',905203,'2024-12-27 14:17:57',914511,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628895,2,23551,0,0,1,1,0,1,'2024-12-27 14:18:00',942932,'2024-12-27 14:18:00',953370,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628896,2,23552,0,0,1,1,0,1,'2024-12-27 14:18:05',991679,'2024-12-27 14:18:06',705,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.120ms, lost 0%','rta=0.120ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628897,2,23553,0,0,1,10,1,1,'2024-12-27 14:18:06',933,'2024-12-27 14:18:08',4294,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628898,2,23551,0,0,1,1,0,1,'2024-12-27 14:18:08',5741,'2024-12-27 14:18:10',11670,26989,'','',30,0,0.00904,3.013,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628899,2,23548,0,0,1,5,1,1,'2024-12-27 14:18:10',11715,'2024-12-27 14:18:12',15110,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628900,2,23554,0,0,1,1,0,1,'2024-12-27 14:18:12',15345,'2024-12-27 14:18:12',332,26989,'','',30,0,0.015,0,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628901,2,23549,0,0,1,10,0,1,'2024-12-27 14:18:15',465,'2024-12-27 14:18:20',0,26989,'','',30,0,0.01404,0.072,0,'OK - 84.38.95.222: rta 0.384ms, lost 0%','rta=0.384ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628902,2,23552,0,0,1,1,0,1,'2024-12-27 14:18:15',31736,'2024-12-27 14:18:20',0,26989,'','',30,0,0.01239,0.075,0,'OK - 192.168.77.8: rta 0.223ms, lost 0%','rta=0.223ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628903,2,21395,0,0,1,5,1,1,'2024-12-27 14:18:15',7,'2024-12-27 14:18:20',0,26989,'','',30,0,2.01067,0.078,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628904,2,23548,0,0,1,5,1,1,'2024-12-27 14:18:15',0,'2024-12-27 14:18:20',0,26989,'','',30,0,2.00894,0.08,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628905,2,21397,0,0,1,5,1,1,'2024-12-27 14:18:15',7,'2024-12-27 14:18:20',0,26989,'','',30,0,2.01238,0.079,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628906,2,28279,0,0,1,1,0,1,'2024-12-27 14:18:20',102482,'2024-12-27 14:18:25',115955,26989,'','',30,0,0.00685,0.102,0,'OK - 192.168.77.9: rta 0.017ms, lost 0%','rta=0.017ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628907,2,23551,0,0,1,1,0,1,'2024-12-27 14:18:25',116498,'2024-12-27 14:18:25',127208,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628908,2,28533,0,0,1,1,1,1,'2024-12-27 14:18:30',169617,'2024-12-27 14:18:32',178481,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628909,2,28533,0,0,1,1,1,1,'2024-12-27 14:18:25',129661,'2024-12-27 14:18:32',178979,26989,'','',30,0,2.00746,0.129,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628910,2,23548,0,0,1,5,1,1,'2024-12-27 14:18:32',179296,'2024-12-27 14:18:34',187751,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628911,2,23552,0,0,1,1,0,1,'2024-12-27 14:18:34',188057,'2024-12-27 14:18:34',197651,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.121ms, lost 0%','rta=0.121ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628912,2,23554,0,0,1,1,0,1,'2024-12-27 14:18:34',200126,'2024-12-27 14:18:35',220837,26989,'','',30,0,0.00902,4.2,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628913,2,23553,0,0,1,10,1,1,'2024-12-27 14:18:40',259390,'2024-12-27 14:18:40',343412,26989,'','',30,0,0.083,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628914,2,23553,0,0,1,10,1,1,'2024-12-27 14:18:40',346361,'2024-12-27 14:18:45',382915,26989,'','',30,0,2.00771,0.346,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628915,2,28533,0,0,1,1,1,1,'2024-12-27 14:18:45',383280,'2024-12-27 14:18:47',393308,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628916,2,23554,0,0,1,1,0,1,'2024-12-27 14:18:50',426224,'2024-12-27 14:18:50',437044,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628917,2,23552,0,0,1,1,0,1,'2024-12-27 14:18:50',437376,'2024-12-27 14:18:50',446846,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.127ms, lost 0%','rta=0.127ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628918,2,21395,0,0,1,5,1,1,'2024-12-27 14:18:50',447659,'2024-12-27 14:18:51',409398,26989,'','',30,0,0.962,0,1,'CRITICAL - 192.168.77.154: Host unreachable @ 192.168.77.9. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628919,2,21396,0,0,1,5,0,1,'2024-12-27 14:18:51',411952,'2024-12-27 14:18:55',477010,26989,'','',30,0,0.02824,1.411,0,'OK - 192.168.77.159: rta 1.106ms, lost 0%','rta=1.106ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628920,2,23551,0,0,1,1,0,1,'2024-12-27 14:19:00',513142,'2024-12-27 14:19:00',524479,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628921,2,28279,0,0,1,1,0,1,'2024-12-27 14:19:10',589000,'2024-12-27 14:19:10',597641,26989,'','',30,0,0.008,0,0,'OK - 192.168.77.9: rta 0.014ms, lost 0%','rta=0.014ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628922,2,23551,0,0,1,1,0,1,'2024-12-27 14:19:10',600578,'2024-12-27 14:19:15',636259,26989,'','',30,0,0.00893,0.6,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628923,2,23552,0,0,1,1,0,1,'2024-12-27 14:19:15',636328,'2024-12-27 14:19:15',646723,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.132ms, lost 0%','rta=0.132ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628924,2,21396,0,0,1,5,0,1,'2024-12-27 14:19:20',674268,'2024-12-27 14:19:20',696581,26989,'','',30,0,0.022,0,0,'OK - 192.168.77.159: rta 0.757ms, lost 0%','rta=0.757ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628925,2,23553,0,0,1,10,1,1,'2024-12-27 14:19:20',696914,'2024-12-27 14:19:22',704122,26989,'','',30,0,2.006,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628926,2,23554,0,0,1,1,0,1,'2024-12-27 14:19:25',732196,'2024-12-27 14:19:25',742633,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628927,2,23552,0,0,1,1,0,1,'2024-12-27 14:19:22',710050,'2024-12-27 14:19:25',743148,26989,'','',30,0,0.00934,2.71,0,'OK - 192.168.77.8: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628928,2,23549,0,0,1,10,0,1,'2024-12-27 14:19:22',706950,'2024-12-27 14:19:25',743370,26989,'','',30,0,0.01634,2.706,0,'OK - 84.38.95.222: rta 0.519ms, lost 0%','rta=0.519ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628929,2,21397,0,0,1,5,1,1,'2024-12-27 14:19:22',717120,'2024-12-27 14:19:25',743637,26989,'','',30,0,0.98618,2.717,2,'CRITICAL - 172.20.3.10: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628930,2,23548,0,0,1,5,1,1,'2024-12-27 14:19:22',716175,'2024-12-27 14:19:25',743877,26989,'','',30,0,0.98719,2.716,2,'CRITICAL - 172.20.3.11: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628931,2,21395,0,0,1,5,1,1,'2024-12-27 14:19:22',713239,'2024-12-27 14:19:25',744109,26989,'','',30,0,2.00927,2.713,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628932,2,28279,0,0,1,1,0,1,'2024-12-27 14:19:25',746405,'2024-12-27 14:19:30',771957,26989,'','',30,0,0.00609,0.746,0,'OK - 192.168.77.9: rta 0.014ms, lost 0%','rta=0.014ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628933,2,28533,0,0,1,1,1,1,'2024-12-27 14:19:32',779973,'2024-12-27 14:19:35',800607,26989,'','',30,0,2.00743,0.779,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628934,2,23554,0,0,1,1,0,1,'2024-12-27 14:19:35',803239,'2024-12-27 14:19:40',831174,26989,'','',30,0,0.00936,0.803,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628935,2,23552,0,0,1,1,0,1,'2024-12-27 14:19:45',865398,'2024-12-27 14:19:45',876333,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.117ms, lost 0%','rta=0.117ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628936,2,23553,0,0,1,10,1,1,'2024-12-27 14:19:45',876664,'2024-12-27 14:19:47',885044,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628937,2,23553,0,0,1,10,1,1,'2024-12-27 14:19:47',887577,'2024-12-27 14:19:50',919016,26989,'','',30,0,0.99569,2.887,2,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628938,2,23549,0,0,1,10,0,1,'2024-12-27 14:19:50',919352,'2024-12-27 14:19:50',930846,26989,'','',30,0,0.011,0,0,'OK - 84.38.95.222: rta 0.198ms, lost 0%','rta=0.198ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628939,2,23554,0,0,1,1,0,1,'2024-12-27 14:19:55',960933,'2024-12-27 14:19:55',971605,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628940,2,23551,0,0,1,1,0,1,'2024-12-27 14:19:55',971942,'2024-12-27 14:19:55',981657,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628941,2,21396,0,0,1,5,0,1,'2024-12-27 14:19:55',984250,'2024-12-27 14:20:01',1,26989,'','',30,0,0.02064,0.984,0,'OK - 192.168.77.159: rta 0.745ms, lost 0%','rta=0.745ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628942,2,28533,0,0,1,1,1,1,'2024-12-27 14:20:10',39,'2024-12-27 14:20:12',24376,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628943,2,23552,0,0,1,1,0,1,'2024-12-27 14:20:12',24549,'2024-12-27 14:20:12',28298,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.125ms, lost 0%','rta=0.125ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628944,2,21397,0,0,1,5,1,1,'2024-12-27 14:20:15',62,'2024-12-27 14:20:17',0,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628945,2,23553,0,0,1,10,1,1,'2024-12-27 14:20:17',0,'2024-12-27 14:20:18',0,26989,'','',30,0,1,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628946,2,23551,0,0,1,1,0,1,'2024-12-27 14:20:18',0,'2024-12-27 14:20:20',101823,26989,'','',30,0,0.00932,3.088,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628947,2,23554,0,0,1,1,0,1,'2024-12-27 14:20:20',101876,'2024-12-27 14:20:20',112082,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.148ms, lost 0%','rta=0.148ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628948,2,23549,0,0,1,10,0,1,'2024-12-27 14:20:20',112389,'2024-12-27 14:20:20',125454,26989,'','',30,0,0.012,0,0,'OK - 84.38.95.222: rta 0.317ms, lost 0%','rta=0.317ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628949,2,23552,0,0,1,1,0,1,'2024-12-27 14:20:25',143607,'2024-12-27 14:20:30',187412,26989,'','',30,0,0.0119,0.143,0,'OK - 192.168.77.8: rta 0.237ms, lost 0%','rta=0.237ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628950,2,23549,0,0,1,10,0,1,'2024-12-27 14:20:25',146497,'2024-12-27 14:20:30',187598,26989,'','',30,0,0.01522,0.146,0,'OK - 84.38.95.222: rta 0.443ms, lost 0%','rta=0.443ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628951,2,21397,0,0,1,5,1,1,'2024-12-27 14:20:25',147435,'2024-12-27 14:20:30',187792,26989,'','',30,0,2.00819,0.147,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628952,2,23548,0,0,1,5,1,1,'2024-12-27 14:20:25',148361,'2024-12-27 14:20:30',188007,26989,'','',30,0,2.00881,0.148,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628953,2,21395,0,0,1,5,1,1,'2024-12-27 14:20:25',151445,'2024-12-27 14:20:30',188192,26989,'','',30,0,2.00893,0.151,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628954,2,28279,0,0,1,1,0,1,'2024-12-27 14:20:30',190823,'2024-12-27 14:20:35',217880,26989,'','',30,0,0.00682,0.19,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628955,2,28533,0,0,1,1,1,1,'2024-12-27 14:20:35',220770,'2024-12-27 14:20:40',246126,26989,'','',30,0,2.00779,0.22,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628956,2,23551,0,0,1,1,0,1,'2024-12-27 14:20:40',246203,'2024-12-27 14:20:40',257024,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628957,2,23554,0,0,1,1,0,1,'2024-12-27 14:20:40',262834,'2024-12-27 14:20:45',288212,26989,'','',30,0,0.00926,0.262,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628958,2,21397,0,0,1,5,1,1,'2024-12-27 14:20:45',288273,'2024-12-27 14:20:47',296130,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628959,2,23553,0,0,1,10,1,1,'2024-12-27 14:20:47',296469,'2024-12-27 14:20:48',296357,26989,'','',30,0,1,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628960,2,28533,0,0,1,1,1,1,'2024-12-27 14:20:55',353787,'2024-12-27 14:20:56',413753,26989,'','',30,0,1.059,0,1,'CRITICAL - 172.50.1.3: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628961,2,23553,0,0,1,10,1,1,'2024-12-27 14:20:50',323518,'2024-12-27 14:20:56',414206,26989,'','',30,0,2.00877,0.323,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628962,2,23551,0,0,1,1,0,1,'2024-12-27 14:21:00',449527,'2024-12-27 14:21:00',459600,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628963,2,21396,0,0,1,5,0,1,'2024-12-27 14:21:01',463431,'2024-12-27 14:21:05',489032,26989,'','',30,0,0.03617,0.463,0,'OK - 192.168.77.159: rta 1.512ms, lost 0%','rta=1.512ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628964,2,23552,0,0,1,1,0,1,'2024-12-27 14:21:05',489097,'2024-12-27 14:21:05',499206,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.155ms, lost 0%','rta=0.155ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628965,2,23548,0,0,1,5,1,1,'2024-12-27 14:21:10',526572,'2024-12-27 14:21:12',534285,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628966,2,23554,0,0,1,1,0,1,'2024-12-27 14:21:12',534585,'2024-12-27 14:21:12',544591,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628967,2,23551,0,0,1,1,0,1,'2024-12-27 14:21:20',612439,'2024-12-27 14:21:25',639383,26989,'','',30,0,0.01153,0.612,0,'OK - 192.168.77.29: rta 0.154ms, lost 0%','rta=0.154ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628968,2,21395,0,0,1,5,1,1,'2024-12-27 14:21:25',639447,'2024-12-27 14:21:27',648755,26989,'','',30,0,2.009,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628969,2,23552,0,0,1,1,0,1,'2024-12-27 14:21:27',649086,'2024-12-27 14:21:27',658675,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.126ms, lost 0%','rta=0.126ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628970,2,28533,0,0,1,1,1,1,'2024-12-27 14:21:30',690601,'2024-12-27 14:21:32',700646,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628971,2,23548,0,0,1,5,1,1,'2024-12-27 14:21:32',701216,'2024-12-27 14:21:34',709865,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628972,2,23552,0,0,1,1,0,1,'2024-12-27 14:21:34',712583,'2024-12-27 14:21:35',739318,26989,'','',30,0,0.01125,4.712,0,'OK - 192.168.77.8: rta 0.166ms, lost 0%','rta=0.166ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628973,2,23549,0,0,1,10,0,1,'2024-12-27 14:21:34',714988,'2024-12-27 14:21:35',739552,26989,'','',30,0,0.01161,4.714,0,'OK - 84.38.95.222: rta 0.243ms, lost 0%','rta=0.243ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628974,2,21397,0,0,1,5,1,1,'2024-12-27 14:21:34',718490,'2024-12-27 14:21:35',739780,26989,'','',30,0,0.98959,4.718,2,'CRITICAL - 172.20.3.10: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628975,2,23548,0,0,1,5,1,1,'2024-12-27 14:21:34',721958,'2024-12-27 14:21:35',740010,26989,'','',30,0,0.98614,4.721,2,'CRITICAL - 172.20.3.11: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628976,2,28279,0,0,1,1,0,1,'2024-12-27 14:21:35',742328,'2024-12-27 14:21:40',769175,26989,'','',30,0,0.00754,0.742,0,'OK - 192.168.77.9: rta 0.021ms, lost 0%','rta=0.021ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628977,2,21395,0,0,1,5,1,1,'2024-12-27 14:21:34',724954,'2024-12-27 14:21:40',769421,26989,'','',30,0,2.00919,4.724,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628978,2,23553,0,0,1,10,1,1,'2024-12-27 14:21:40',769481,'2024-12-27 14:21:40',864109,26989,'','',30,0,0.094,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628979,2,23551,0,0,1,1,0,1,'2024-12-27 14:21:40',864428,'2024-12-27 14:21:40',874231,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628980,2,28533,0,0,1,1,1,1,'2024-12-27 14:21:40',876979,'2024-12-27 14:21:45',910403,26989,'','',30,0,0.54385,0.876,2,'CRITICAL - 172.50.1.3: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628981,2,23554,0,0,1,1,0,1,'2024-12-27 14:21:45',913091,'2024-12-27 14:21:50',937540,26989,'','',30,0,0.00966,0.913,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628982,2,23552,0,0,1,1,0,1,'2024-12-27 14:21:50',937894,'2024-12-27 14:21:50',948575,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.139ms, lost 0%','rta=0.139ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628983,2,21395,0,0,1,5,1,1,'2024-12-27 14:21:55',975331,'2024-12-27 14:21:57',984444,26989,'','',30,0,2.008,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628984,2,23553,0,0,1,10,1,1,'2024-12-27 14:21:57',984817,'2024-12-27 14:21:59',995301,26989,'','',30,0,2.01,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628985,2,23551,0,0,1,1,0,1,'2024-12-27 14:22:05',24,'2024-12-27 14:22:05',17369,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628986,2,28533,0,0,1,1,1,1,'2024-12-27 14:22:05',17451,'2024-12-27 14:22:07',20674,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628987,2,23553,0,0,1,10,1,1,'2024-12-27 14:21:59',998129,'2024-12-27 14:22:07',327,26989,'','',30,0,0.99532,3.998,2,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628988,2,21396,0,0,1,5,0,1,'2024-12-27 14:22:07',22026,'2024-12-27 14:22:10',56,26989,'','',30,0,0.02459,2.052,0,'OK - 192.168.77.159: rta 0.930ms, lost 0%','rta=0.930ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628989,2,28279,0,0,1,1,0,1,'2024-12-27 14:22:10',56,'2024-12-27 14:22:10',7,26989,'','',30,0,0.008,0,0,'OK - 192.168.77.9: rta 0.016ms, lost 0%','rta=0.016ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628990,2,23552,0,0,1,1,0,1,'2024-12-27 14:22:15',0,'2024-12-27 14:22:15',105959,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.135ms, lost 0%','rta=0.135ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628991,2,23553,0,0,1,10,1,1,'2024-12-27 14:22:20',122509,'2024-12-27 14:22:22',132491,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628992,2,23554,0,0,1,1,0,1,'2024-12-27 14:22:25',140563,'2024-12-27 14:22:25',150840,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628993,2,23551,0,0,1,1,0,1,'2024-12-27 14:22:25',153313,'2024-12-27 14:22:30',170622,26989,'','',30,0,0.00877,0.153,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628994,2,23552,0,0,1,1,0,1,'2024-12-27 14:22:35',200673,'2024-12-27 14:22:40',232908,26989,'','',30,0,0.01227,0.2,0,'OK - 192.168.77.8: rta 0.205ms, lost 0%','rta=0.205ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628995,2,23549,0,0,1,10,0,1,'2024-12-27 14:22:35',204405,'2024-12-27 14:22:40',233139,26989,'','',30,0,0.01711,0.204,0,'OK - 84.38.95.222: rta 0.539ms, lost 0%','rta=0.539ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628996,2,23548,0,0,1,5,1,1,'2024-12-27 14:22:35',206360,'2024-12-27 14:22:40',233376,26989,'','',30,0,2.00857,0.206,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628997,2,21397,0,0,1,5,1,1,'2024-12-27 14:22:35',205415,'2024-12-27 14:22:40',233641,26989,'','',30,0,2.01226,0.205,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276628998,2,28279,0,0,1,1,0,1,'2024-12-27 14:22:40',235816,'2024-12-27 14:22:45',388240,26989,'','',30,0,0.00736,0.235,0,'OK - 192.168.77.9: rta 0.016ms, lost 0%','rta=0.016ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276628999,2,21395,0,0,1,5,1,1,'2024-12-27 14:22:40',239535,'2024-12-27 14:22:45',388482,26989,'','',30,0,2.00814,0.239,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629000,2,23553,0,0,1,10,1,1,'2024-12-27 14:22:45',388823,'2024-12-27 14:22:47',398767,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629001,2,28533,0,0,1,1,1,1,'2024-12-27 14:22:47',401247,'2024-12-27 14:22:50',444526,26989,'','',30,0,2.00861,2.401,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629002,2,23554,0,0,1,1,0,1,'2024-12-27 14:22:50',446669,'2024-12-27 14:22:55',464444,26989,'','',30,0,0.00982,0.446,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629003,2,23551,0,0,1,1,0,1,'2024-12-27 14:22:55',464786,'2024-12-27 14:22:55',475440,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629004,2,28533,0,0,1,1,1,1,'2024-12-27 14:23:05',546514,'2024-12-27 14:23:07',556059,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629005,2,23552,0,0,1,1,0,1,'2024-12-27 14:23:10',589705,'2024-12-27 14:23:10',599910,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.136ms, lost 0%','rta=0.136ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629006,2,23553,0,0,1,10,1,1,'2024-12-27 14:23:07',558659,'2024-12-27 14:23:10',600448,26989,'','',30,0,0.08721,0.558,2,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629007,2,21396,0,0,1,5,0,1,'2024-12-27 14:23:10',602735,'2024-12-27 14:23:15',634758,26989,'','',30,0,0.02008,0.602,0,'OK - 192.168.77.159: rta 0.715ms, lost 0%','rta=0.715ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629008,2,21397,0,0,1,5,1,1,'2024-12-27 14:23:15',634814,'2024-12-27 14:23:17',643300,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629009,2,23554,0,0,1,1,0,1,'2024-12-27 14:23:20',671752,'2024-12-27 14:23:20',683394,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629010,2,23549,0,0,1,10,0,1,'2024-12-27 14:23:20',683681,'2024-12-27 14:23:20',694458,26989,'','',30,0,0.01,0,0,'OK - 84.38.95.222: rta 0.203ms, lost 0%','rta=0.203ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629011,2,28533,0,0,1,1,1,1,'2024-12-27 14:23:25',718577,'2024-12-27 14:23:27',729354,26989,'','',30,0,2.01,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629012,2,23551,0,0,1,1,0,1,'2024-12-27 14:23:30',746171,'2024-12-27 14:23:30',757158,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629013,2,23551,0,0,1,1,0,1,'2024-12-27 14:23:30',759644,'2024-12-27 14:23:35',784785,26989,'','',30,0,0.00891,0.759,0,'OK - 192.168.77.29: rta 0.148ms, lost 0%','rta=0.148ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629014,2,28279,0,0,1,1,0,1,'2024-12-27 14:23:35',784853,'2024-12-27 14:23:35',792764,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.016ms, lost 0%','rta=0.016ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629015,2,23552,0,0,1,1,0,1,'2024-12-27 14:23:35',793090,'2024-12-27 14:23:35',802404,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.120ms, lost 0%','rta=0.120ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629016,2,23552,0,0,1,1,0,1,'2024-12-27 14:23:40',840061,'2024-12-27 14:23:45',871292,26989,'','',30,0,0.01027,0.84,0,'OK - 192.168.77.8: rta 0.189ms, lost 0%','rta=0.189ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629017,2,23549,0,0,1,10,0,1,'2024-12-27 14:23:40',842151,'2024-12-27 14:23:45',871490,26989,'','',30,0,0.01809,0.842,0,'OK - 84.38.95.222: rta 0.511ms, lost 0%','rta=0.511ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629018,2,21397,0,0,1,5,1,1,'2024-12-27 14:23:45',871540,'2024-12-27 14:23:47',880956,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629019,2,23548,0,0,1,5,1,1,'2024-12-27 14:23:40',846002,'2024-12-27 14:23:47',881397,26989,'','',30,0,0.03115,0.845,2,'CRITICAL - 172.20.3.11: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629020,2,21397,0,0,1,5,1,1,'2024-12-27 14:23:40',847935,'2024-12-27 14:23:47',881593,26989,'','',30,0,0.02993,0.847,2,'CRITICAL - 172.20.3.10: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629021,2,23553,0,0,1,10,1,1,'2024-12-27 14:23:47',881645,'2024-12-27 14:23:48',879193,26989,'','',30,0,0.998,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629022,2,23554,0,0,1,1,0,1,'2024-12-27 14:23:48',879676,'2024-12-27 14:23:48',889533,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629023,2,28279,0,0,1,1,0,1,'2024-12-27 14:23:48',891929,'2024-12-27 14:23:50',927277,26989,'','',30,0,0.00612,3.891,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629024,2,21395,0,0,1,5,1,1,'2024-12-27 14:23:48',894345,'2024-12-27 14:23:50',927524,26989,'','',30,0,2.0083,3.894,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629025,2,28533,0,0,1,1,1,1,'2024-12-27 14:23:50',929781,'2024-12-27 14:23:55',955226,26989,'','',30,0,1.07812,0.929,2,'CRITICAL - 172.50.1.3: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629026,2,23554,0,0,1,1,0,1,'2024-12-27 14:23:55',957938,'2024-12-27 14:24:00',998215,26989,'','',30,0,0.0104,0.957,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629027,2,23551,0,0,1,1,0,1,'2024-12-27 14:24:00',999043,'2024-12-27 14:24:01',0,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629028,2,23552,0,0,1,1,0,1,'2024-12-27 14:24:05',17,'2024-12-27 14:24:05',13029,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.123ms, lost 0%','rta=0.123ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629029,2,23553,0,0,1,10,1,1,'2024-12-27 14:24:05',13244,'2024-12-27 14:24:07',3,26989,'','',30,0,2.006,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629030,2,23548,0,0,1,5,1,1,'2024-12-27 14:24:10',41,'2024-12-27 14:24:12',24883,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629031,2,23554,0,0,1,1,0,1,'2024-12-27 14:24:12',6,'2024-12-27 14:24:12',7,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629032,2,23553,0,0,1,10,1,1,'2024-12-27 14:24:12',0,'2024-12-27 14:24:15',0,26989,'','',30,0,0.97662,2.081,2,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629033,2,21396,0,0,1,5,0,1,'2024-12-27 14:24:15',101792,'2024-12-27 14:24:20',112297,26989,'','',30,0,0.0206,0.101,0,'OK - 192.168.77.159: rta 0.691ms, lost 0%','rta=0.691ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629034,2,21395,0,0,1,5,1,1,'2024-12-27 14:24:25',130906,'2024-12-27 14:24:27',141305,26989,'','',30,0,2.01,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629035,2,23552,0,0,1,1,0,1,'2024-12-27 14:24:27',141633,'2024-12-27 14:24:27',151022,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.115ms, lost 0%','rta=0.115ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629036,2,23551,0,0,1,1,0,1,'2024-12-27 14:24:27',151338,'2024-12-27 14:24:27',161137,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629037,2,28533,0,0,1,1,1,1,'2024-12-27 14:24:30',198378,'2024-12-27 14:24:32',207714,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629038,2,23548,0,0,1,5,1,1,'2024-12-27 14:24:32',208310,'2024-12-27 14:24:34',217037,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629039,2,23551,0,0,1,1,0,1,'2024-12-27 14:24:35',245274,'2024-12-27 14:24:40',282566,26989,'','',30,0,0.00922,0.245,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629040,2,23553,0,0,1,10,1,1,'2024-12-27 14:24:40',282637,'2024-12-27 14:24:40',363016,26989,'','',30,0,0.08,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629041,2,23552,0,0,1,1,0,1,'2024-12-27 14:24:45',398749,'2024-12-27 14:24:50',455434,26989,'','',30,0,0.0098,0.398,0,'OK - 192.168.77.8: rta 0.135ms, lost 0%','rta=0.135ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629042,2,23549,0,0,1,10,0,1,'2024-12-27 14:24:45',402822,'2024-12-27 14:24:50',455681,26989,'','',30,0,0.01096,0.402,0,'OK - 84.38.95.222: rta 0.219ms, lost 0%','rta=0.219ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629043,2,23554,0,0,1,1,0,1,'2024-12-27 14:24:50',456565,'2024-12-27 14:24:50',468347,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629044,2,23548,0,0,1,5,1,1,'2024-12-27 14:24:47',408296,'2024-12-27 14:24:50',469129,26989,'','',30,0,2.00818,0.408,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629045,2,21397,0,0,1,5,1,1,'2024-12-27 14:24:47',411901,'2024-12-27 14:24:50',469323,26989,'','',30,0,2.00753,0.411,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629046,2,21395,0,0,1,5,1,1,'2024-12-27 14:24:50',469397,'2024-12-27 14:24:51',431064,26989,'','',30,0,0.962,0,1,'CRITICAL - 192.168.77.154: Host unreachable @ 192.168.77.9. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629047,2,28279,0,0,1,1,0,1,'2024-12-27 14:24:51',433595,'2024-12-27 14:24:55',472119,26989,'','',30,0,0.00624,1.433,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629048,2,21395,0,0,1,5,1,1,'2024-12-27 14:24:51',436707,'2024-12-27 14:24:55',472388,26989,'','',30,0,2.00865,1.436,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629049,2,28533,0,0,1,1,1,1,'2024-12-27 14:24:55',475332,'2024-12-27 14:25:00',502957,26989,'','',30,0,2.00779,0.475,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629050,2,23554,0,0,1,1,0,1,'2024-12-27 14:25:00',514887,'2024-12-27 14:25:05',545459,26989,'','',30,0,0.00951,0.514,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629051,2,23551,0,0,1,1,0,1,'2024-12-27 14:25:05',545512,'2024-12-27 14:25:05',556314,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629052,2,28279,0,0,1,1,0,1,'2024-12-27 14:25:10',583892,'2024-12-27 14:25:10',591819,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629053,2,23552,0,0,1,1,0,1,'2024-12-27 14:25:15',630554,'2024-12-27 14:25:15',640602,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.115ms, lost 0%','rta=0.115ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629054,2,21396,0,0,1,5,0,1,'2024-12-27 14:25:20',673325,'2024-12-27 14:25:20',694915,26989,'','',30,0,0.021,0,0,'OK - 192.168.77.159: rta 0.709ms, lost 0%','rta=0.709ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629055,2,23553,0,0,1,10,1,1,'2024-12-27 14:25:15',643019,'2024-12-27 14:25:20',695422,26989,'','',30,0,2.00754,0.642,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629056,2,21396,0,0,1,5,0,1,'2024-12-27 14:25:20',698179,'2024-12-27 14:25:25',723881,26989,'','',30,0,0.02488,0.698,0,'OK - 192.168.77.159: rta 0.941ms, lost 0%','rta=0.941ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629057,2,23554,0,0,1,1,0,1,'2024-12-27 14:25:25',723928,'2024-12-27 14:25:25',734292,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629058,2,23551,0,0,1,1,0,1,'2024-12-27 14:25:40',821779,'2024-12-27 14:25:45',851885,26989,'','',30,0,0.0095,0.821,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629059,2,23552,0,0,1,1,0,1,'2024-12-27 14:25:45',851942,'2024-12-27 14:25:45',861856,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.130ms, lost 0%','rta=0.130ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629060,2,23553,0,0,1,10,1,1,'2024-12-27 14:25:45',862203,'2024-12-27 14:25:47',870224,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629061,2,23549,0,0,1,10,0,1,'2024-12-27 14:25:50',902925,'2024-12-27 14:25:50',917219,26989,'','',30,0,0.014,0,0,'OK - 84.38.95.222: rta 0.329ms, lost 0%','rta=0.329ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629062,2,23552,0,0,1,1,0,1,'2024-12-27 14:25:50',919697,'2024-12-27 14:25:55',957891,26989,'','',30,0,0.0086,0.919,0,'OK - 192.168.77.8: rta 0.129ms, lost 0%','rta=0.129ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629063,2,23549,0,0,1,10,0,1,'2024-12-27 14:25:50',922729,'2024-12-27 14:25:55',958179,26989,'','',30,0,0.01064,0.922,0,'OK - 84.38.95.222: rta 0.199ms, lost 0%','rta=0.199ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629064,2,23554,0,0,1,1,0,1,'2024-12-27 14:25:55',958243,'2024-12-27 14:25:55',969113,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629065,2,23548,0,0,1,5,1,1,'2024-12-27 14:25:50',926289,'2024-12-27 14:25:55',969674,26989,'','',30,0,2.00809,0.926,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629066,2,21397,0,0,1,5,1,1,'2024-12-27 14:25:50',929351,'2024-12-27 14:25:55',969921,26989,'','',30,0,2.00815,0.929,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629067,2,28279,0,0,1,1,0,1,'2024-12-27 14:25:55',972492,'2024-12-27 14:26:01',8,26989,'','',30,0,0.00623,0.972,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629068,2,21395,0,0,1,5,1,1,'2024-12-27 14:25:55',975366,'2024-12-27 14:26:01',4712,26989,'','',30,0,2.00883,0.975,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629069,2,23551,0,0,1,1,0,1,'2024-12-27 14:26:01',5089,'2024-12-27 14:26:01',17,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629070,2,28533,0,0,1,1,1,1,'2024-12-27 14:26:01',20,'2024-12-27 14:26:05',16696,26989,'','',30,0,2.00649,1.024,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629071,2,23554,0,0,1,1,0,1,'2024-12-27 14:26:05',34,'2024-12-27 14:26:10',24448,26989,'','',30,0,0.00984,0.042,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629072,2,23552,0,0,1,1,0,1,'2024-12-27 14:26:10',47,'2024-12-27 14:26:10',6,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.121ms, lost 0%','rta=0.121ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629073,2,21397,0,0,1,5,1,1,'2024-12-27 14:26:15',0,'2024-12-27 14:26:17',0,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629074,2,23553,0,0,1,10,1,1,'2024-12-27 14:26:17',0,'2024-12-27 14:26:18',0,26989,'','',30,0,1,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629075,2,23549,0,0,1,10,0,1,'2024-12-27 14:26:20',137792,'2024-12-27 14:26:20',150465,26989,'','',30,0,0.012,0,0,'OK - 84.38.95.222: rta 0.219ms, lost 0%','rta=0.219ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629076,2,23553,0,0,1,10,1,1,'2024-12-27 14:26:20',152968,'2024-12-27 14:26:25',171502,26989,'','',30,0,2.00775,0.152,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629077,2,28533,0,0,1,1,1,1,'2024-12-27 14:26:25',171787,'2024-12-27 14:26:27',180281,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629078,2,21396,0,0,1,5,0,1,'2024-12-27 14:26:27',182743,'2024-12-27 14:26:30',195805,26989,'','',30,0,0.02006,2.182,0,'OK - 192.168.77.159: rta 0.713ms, lost 0%','rta=0.713ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629079,2,23551,0,0,1,1,0,1,'2024-12-27 14:26:30',196120,'2024-12-27 14:26:30',206841,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629080,2,28279,0,0,1,1,0,1,'2024-12-27 14:26:35',224189,'2024-12-27 14:26:35',231873,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629081,2,23552,0,0,1,1,0,1,'2024-12-27 14:26:35',232194,'2024-12-27 14:26:35',241621,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.130ms, lost 0%','rta=0.130ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629082,2,21397,0,0,1,5,1,1,'2024-12-27 14:26:45',302598,'2024-12-27 14:26:47',313106,26989,'','',30,0,2.01,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629083,2,23553,0,0,1,10,1,1,'2024-12-27 14:26:47',313422,'2024-12-27 14:26:48',311265,26989,'','',30,0,0.998,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629084,2,23554,0,0,1,1,0,1,'2024-12-27 14:26:48',311855,'2024-12-27 14:26:48',321645,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.146ms, lost 0%','rta=0.146ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629085,2,23551,0,0,1,1,0,1,'2024-12-27 14:26:48',324153,'2024-12-27 14:26:50',349296,26989,'','',30,0,0.00881,3.324,0,'OK - 192.168.77.29: rta 0.148ms, lost 0%','rta=0.148ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629086,2,28533,0,0,1,1,1,1,'2024-12-27 14:26:55',373416,'2024-12-27 14:26:56',439020,26989,'','',30,0,1.065,0,1,'CRITICAL - 172.50.1.3: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629087,2,23552,0,0,1,1,0,1,'2024-12-27 14:26:56',441467,'2024-12-27 14:27:00',491681,26989,'','',30,0,0.01017,1.441,0,'OK - 192.168.77.8: rta 0.173ms, lost 0%','rta=0.173ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629088,2,23549,0,0,1,10,0,1,'2024-12-27 14:26:56',442879,'2024-12-27 14:27:00',491886,26989,'','',30,0,0.01205,1.442,0,'OK - 84.38.95.222: rta 0.234ms, lost 0%','rta=0.234ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629089,2,23548,0,0,1,5,1,1,'2024-12-27 14:26:56',445083,'2024-12-27 14:27:00',492821,26989,'','',30,0,2.00838,1.445,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629090,2,21397,0,0,1,5,1,1,'2024-12-27 14:26:56',447983,'2024-12-27 14:27:00',493036,26989,'','',30,0,2.00828,1.447,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629091,2,28279,0,0,1,1,0,1,'2024-12-27 14:27:01',497251,'2024-12-27 14:27:05',523077,26989,'','',30,0,0.00654,0.497,0,'OK - 192.168.77.9: rta 0.014ms, lost 0%','rta=0.014ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629092,2,21395,0,0,1,5,1,1,'2024-12-27 14:27:01',500534,'2024-12-27 14:27:05',523585,26989,'','',30,0,2.00722,0.5,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629093,2,23551,0,0,1,1,0,1,'2024-12-27 14:27:05',523630,'2024-12-27 14:27:05',535061,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629094,2,23553,0,0,1,10,1,1,'2024-12-27 14:27:05',535354,'2024-12-27 14:27:07',543999,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629095,2,23554,0,0,1,1,0,1,'2024-12-27 14:27:10',574707,'2024-12-27 14:27:10',585797,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629096,2,28533,0,0,1,1,1,1,'2024-12-27 14:27:07',546509,'2024-12-27 14:27:10',586611,26989,'','',30,0,2.00765,2.546,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629097,2,23554,0,0,1,1,0,1,'2024-12-27 14:27:10',588912,'2024-12-27 14:27:15',621947,26989,'','',30,0,0.00891,0.588,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629098,2,21395,0,0,1,5,1,1,'2024-12-27 14:27:25',691728,'2024-12-27 14:27:27',700033,26989,'','',30,0,2.008,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629099,2,23552,0,0,1,1,0,1,'2024-12-27 14:27:27',700329,'2024-12-27 14:27:27',709353,26989,'','',30,0,0.008,0,0,'OK - 192.168.77.8: rta 0.104ms, lost 0%','rta=0.104ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629100,2,23551,0,0,1,1,0,1,'2024-12-27 14:27:27',709657,'2024-12-27 14:27:27',719436,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629101,2,28533,0,0,1,1,1,1,'2024-12-27 14:27:30',738245,'2024-12-27 14:27:32',747897,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629102,2,23553,0,0,1,10,1,1,'2024-12-27 14:27:27',721978,'2024-12-27 14:27:32',748711,26989,'','',30,0,2.00735,2.721,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629103,2,23548,0,0,1,5,1,1,'2024-12-27 14:27:32',748787,'2024-12-27 14:27:34',757091,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629104,2,21396,0,0,1,5,0,1,'2024-12-27 14:27:34',760068,'2024-12-27 14:27:35',777421,26989,'','',30,0,0.02052,4.76,0,'OK - 192.168.77.159: rta 0.724ms, lost 0%','rta=0.724ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629105,2,23553,0,0,1,10,1,1,'2024-12-27 14:27:50',911545,'2024-12-27 14:27:51',951523,26989,'','',30,0,1.039,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629106,2,23552,0,0,1,1,0,1,'2024-12-27 14:27:51',951874,'2024-12-27 14:27:51',961879,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.146ms, lost 0%','rta=0.146ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629107,2,23554,0,0,1,1,0,1,'2024-12-27 14:27:51',962242,'2024-12-27 14:27:51',972166,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629108,2,21395,0,0,1,5,1,1,'2024-12-27 14:27:51',973041,'2024-12-27 14:27:53',980609,26989,'','',30,0,2.007,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629109,2,23551,0,0,1,1,0,1,'2024-12-27 14:27:53',983084,'2024-12-27 14:27:56',79,26989,'','',30,0,0.0092,3.983,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629110,2,23552,0,0,1,1,0,1,'2024-12-27 14:28:00',1565,'2024-12-27 14:28:05',368,26989,'','',30,0,0.01004,0.03,0,'OK - 192.168.77.8: rta 0.136ms, lost 0%','rta=0.136ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629111,2,23549,0,0,1,10,0,1,'2024-12-27 14:28:00',1705,'2024-12-27 14:28:05',23757,26989,'','',30,0,0.01113,0.032,0,'OK - 84.38.95.222: rta 0.233ms, lost 0%','rta=0.233ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629112,2,28533,0,0,1,1,1,1,'2024-12-27 14:28:05',23958,'2024-12-27 14:28:07',3453,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629113,2,23548,0,0,1,5,1,1,'2024-12-27 14:28:00',15507,'2024-12-27 14:28:07',63,26989,'','',30,0,2.00759,0.036,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629114,2,21397,0,0,1,5,1,1,'2024-12-27 14:28:00',3,'2024-12-27 14:28:07',7,26989,'','',30,0,2.0074,0.039,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629115,2,28279,0,0,1,1,0,1,'2024-12-27 14:28:07',0,'2024-12-27 14:28:10',0,26989,'','',30,0,0.00764,2.08,0,'OK - 192.168.77.9: rta 0.016ms, lost 0%','rta=0.016ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629116,2,21395,0,0,1,5,1,1,'2024-12-27 14:28:07',0,'2024-12-27 14:28:10',0,26989,'','',30,0,2.00914,2.083,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629117,2,23551,0,0,1,1,0,1,'2024-12-27 14:28:15',117223,'2024-12-27 14:28:15',128455,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629118,2,28533,0,0,1,1,1,1,'2024-12-27 14:28:10',101376,'2024-12-27 14:28:15',129006,26989,'','',30,0,2.00774,0.101,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629119,2,23554,0,0,1,1,0,1,'2024-12-27 14:28:15',131643,'2024-12-27 14:28:20',146759,26989,'','',30,0,0.00903,0.131,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629120,2,21396,0,0,1,5,0,1,'2024-12-27 14:28:20',146815,'2024-12-27 14:28:20',167726,26989,'','',30,0,0.02,0,0,'OK - 192.168.77.159: rta 0.693ms, lost 0%','rta=0.693ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629121,2,23553,0,0,1,10,1,1,'2024-12-27 14:28:20',168071,'2024-12-27 14:28:22',176940,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629122,2,23553,0,0,1,10,1,1,'2024-12-27 14:28:32',203459,'2024-12-27 14:28:35',228260,26989,'','',30,0,2.0083,0.203,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629123,2,21396,0,0,1,5,0,1,'2024-12-27 14:28:35',230904,'2024-12-27 14:28:40',255553,26989,'','',30,0,0.02101,0.23,0,'OK - 192.168.77.159: rta 0.725ms, lost 0%','rta=0.725ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629124,2,23552,0,0,1,1,0,1,'2024-12-27 14:28:45',288295,'2024-12-27 14:28:45',299069,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.117ms, lost 0%','rta=0.117ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629125,2,23549,0,0,1,10,0,1,'2024-12-27 14:28:50',328229,'2024-12-27 14:28:50',339927,26989,'','',30,0,0.011,0,0,'OK - 84.38.95.222: rta 0.200ms, lost 0%','rta=0.200ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629126,2,23554,0,0,1,1,0,1,'2024-12-27 14:28:55',378090,'2024-12-27 14:28:55',388788,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629127,2,23551,0,0,1,1,0,1,'2024-12-27 14:28:55',389144,'2024-12-27 14:28:55',399976,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629128,2,23551,0,0,1,1,0,1,'2024-12-27 14:28:56',404529,'2024-12-27 14:29:00',435762,26989,'','',30,0,0.0094,0.404,0,'OK - 192.168.77.29: rta 0.147ms, lost 0%','rta=0.147ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629129,2,28533,0,0,1,1,1,1,'2024-12-27 14:29:05',476611,'2024-12-27 14:29:07',485829,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629130,2,23552,0,0,1,1,0,1,'2024-12-27 14:29:07',488394,'2024-12-27 14:29:10',520205,26989,'','',30,0,0.00954,2.488,0,'OK - 192.168.77.8: rta 0.145ms, lost 0%','rta=0.145ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629131,2,23549,0,0,1,10,0,1,'2024-12-27 14:29:07',491376,'2024-12-27 14:29:10',520443,26989,'','',30,0,0.0121,2.491,0,'OK - 84.38.95.222: rta 0.243ms, lost 0%','rta=0.243ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629132,2,21397,0,0,1,5,1,1,'2024-12-27 14:29:07',493609,'2024-12-27 14:29:10',520959,26989,'','',30,0,0.07516,0.493,2,'CRITICAL - 172.20.3.10: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629133,2,23548,0,0,1,5,1,1,'2024-12-27 14:29:07',491960,'2024-12-27 14:29:10',521195,26989,'','',30,0,0.07696,0.491,2,'CRITICAL - 172.20.3.11: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629134,2,28279,0,0,1,1,0,1,'2024-12-27 14:29:10',523449,'2024-12-27 14:29:15',551433,26989,'','',30,0,0.00676,0.523,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629135,2,21395,0,0,1,5,1,1,'2024-12-27 14:29:10',526822,'2024-12-27 14:29:15',551676,26989,'','',30,0,2.00768,0.526,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629136,2,23553,0,0,1,10,1,1,'2024-12-27 14:29:15',551988,'2024-12-27 14:29:17',561096,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629137,2,23554,0,0,1,1,0,1,'2024-12-27 14:29:20',593688,'2024-12-27 14:29:20',605478,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629138,2,28533,0,0,1,1,1,1,'2024-12-27 14:29:17',563708,'2024-12-27 14:29:20',606306,26989,'','',30,0,2.00668,2.563,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629139,2,23554,0,0,1,1,0,1,'2024-12-27 14:29:20',608712,'2024-12-27 14:29:25',646806,26989,'','',30,0,0.00977,0.608,0,'OK - 192.168.77.208: rta 0.146ms, lost 0%','rta=0.146ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629140,2,23551,0,0,1,1,0,1,'2024-12-27 14:29:30',679082,'2024-12-27 14:29:30',690294,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629141,2,28279,0,0,1,1,0,1,'2024-12-27 14:29:35',705654,'2024-12-27 14:29:35',713892,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.016ms, lost 0%','rta=0.016ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629142,2,23552,0,0,1,1,0,1,'2024-12-27 14:29:35',714218,'2024-12-27 14:29:35',723364,26989,'','',30,0,0.008,0,0,'OK - 192.168.77.8: rta 0.118ms, lost 0%','rta=0.118ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629143,2,23553,0,0,1,10,1,1,'2024-12-27 14:29:35',725922,'2024-12-27 14:29:40',746541,26989,'','',30,0,0.08049,0.725,2,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629144,2,21396,0,0,1,5,0,1,'2024-12-27 14:29:40',751635,'2024-12-27 14:29:45',787860,26989,'','',30,0,0.02644,0.751,0,'OK - 192.168.77.159: rta 1.006ms, lost 0%','rta=1.006ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629145,2,21397,0,0,1,5,1,1,'2024-12-27 14:29:45',787912,'2024-12-27 14:29:47',796206,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629146,2,23554,0,0,1,1,0,1,'2024-12-27 14:29:47',796980,'2024-12-27 14:29:47',806948,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629147,2,28533,0,0,1,1,1,1,'2024-12-27 14:29:55',857890,'2024-12-27 14:29:56',921021,26989,'','',30,0,1.062,0,1,'CRITICAL - 172.50.1.3: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629148,2,23551,0,0,1,1,0,1,'2024-12-27 14:30:00',953649,'2024-12-27 14:30:00',963780,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629149,2,23551,0,0,1,1,0,1,'2024-12-27 14:30:00',966436,'2024-12-27 14:30:05',991416,26989,'','',30,0,0.00885,0.966,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629150,2,23552,0,0,1,1,0,1,'2024-12-27 14:30:05',991473,'2024-12-27 14:30:06',80,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.134ms, lost 0%','rta=0.134ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629151,2,23553,0,0,1,10,1,1,'2024-12-27 14:30:06',15,'2024-12-27 14:30:08',4420,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629152,2,23554,0,0,1,1,0,1,'2024-12-27 14:30:10',140,'2024-12-27 14:30:10',26,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629153,2,23548,0,0,1,5,1,1,'2024-12-27 14:30:10',14007,'2024-12-27 14:30:12',32,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629154,2,23552,0,0,1,1,0,1,'2024-12-27 14:30:12',18236,'2024-12-27 14:30:15',3237,26989,'','',30,0,0.01013,2.043,0,'OK - 192.168.77.8: rta 0.112ms, lost 0%','rta=0.112ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629155,2,23549,0,0,1,10,0,1,'2024-12-27 14:30:12',19890,'2024-12-27 14:30:15',26050,26989,'','',30,0,0.01115,2.046,0,'OK - 84.38.95.222: rta 0.232ms, lost 0%','rta=0.232ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629156,2,21397,0,0,1,5,1,1,'2024-12-27 14:30:12',4,'2024-12-27 14:30:15',26258,26989,'','',30,0,0.99074,2.049,2,'CRITICAL - 172.20.3.10: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629157,2,23548,0,0,1,5,1,1,'2024-12-27 14:30:12',41,'2024-12-27 14:30:15',412,26989,'','',30,0,0.98832,2.051,2,'CRITICAL - 172.20.3.11: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629158,2,28279,0,0,1,1,0,1,'2024-12-27 14:30:15',6,'2024-12-27 14:30:20',0,26989,'','',30,0,0.00746,0.069,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629159,2,21395,0,0,1,5,1,1,'2024-12-27 14:30:15',30125,'2024-12-27 14:30:20',0,26989,'','',30,0,2.00736,0.072,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629160,2,23551,0,0,1,1,0,1,'2024-12-27 14:30:25',105884,'2024-12-27 14:30:25',116658,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.154ms, lost 0%','rta=0.154ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629161,2,28533,0,0,1,1,1,1,'2024-12-27 14:30:20',0,'2024-12-27 14:30:25',117161,26989,'','',30,0,2.00869,0.093,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629162,2,23554,0,0,1,1,0,1,'2024-12-27 14:30:25',119352,'2024-12-27 14:30:30',141847,26989,'','',30,0,0.00899,0.119,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629163,2,23548,0,0,1,5,1,1,'2024-12-27 14:30:30',142452,'2024-12-27 14:30:30',151871,26989,'','',30,0,0.009,0,1,'CRITICAL - 172.20.3.11: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629164,2,23552,0,0,1,1,0,1,'2024-12-27 14:30:30',152171,'2024-12-27 14:30:30',161452,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.124ms, lost 0%','rta=0.124ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629165,2,23553,0,0,1,10,1,1,'2024-12-27 14:30:40',199452,'2024-12-27 14:30:40',295867,26989,'','',30,0,0.096,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629166,2,23553,0,0,1,10,1,1,'2024-12-27 14:30:40',298755,'2024-12-27 14:30:45',318918,26989,'','',30,0,2.00834,0.298,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629167,2,28533,0,0,1,1,1,1,'2024-12-27 14:30:45',319269,'2024-12-27 14:30:47',328570,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629168,2,23552,0,0,1,1,0,1,'2024-12-27 14:30:50',357181,'2024-12-27 14:30:50',368183,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.121ms, lost 0%','rta=0.121ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629169,2,23554,0,0,1,1,0,1,'2024-12-27 14:30:50',368788,'2024-12-27 14:30:50',378856,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629170,2,21396,0,0,1,5,0,1,'2024-12-27 14:30:47',331198,'2024-12-27 14:30:50',379612,26989,'','',30,0,0.02835,2.331,0,'OK - 192.168.77.159: rta 1.066ms, lost 0%','rta=1.066ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629171,2,21395,0,0,1,5,1,1,'2024-12-27 14:30:50',379928,'2024-12-27 14:30:51',344494,26989,'','',30,0,0.965,0,1,'CRITICAL - 192.168.77.154: Host unreachable @ 192.168.77.9. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629172,2,23551,0,0,1,1,0,1,'2024-12-27 14:31:05',392475,'2024-12-27 14:31:05',403135,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629173,2,28533,0,0,1,1,1,1,'2024-12-27 14:31:05',403450,'2024-12-27 14:31:07',411989,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629174,2,23551,0,0,1,1,0,1,'2024-12-27 14:31:07',414457,'2024-12-27 14:31:10',431893,26989,'','',30,0,0.01292,2.414,0,'OK - 192.168.77.29: rta 0.349ms, lost 0%','rta=0.349ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629175,2,28279,0,0,1,1,0,1,'2024-12-27 14:31:10',432230,'2024-12-27 14:31:10',440159,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629176,2,23552,0,0,1,1,0,1,'2024-12-27 14:31:15',453098,'2024-12-27 14:31:15',464237,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.132ms, lost 0%','rta=0.132ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629177,2,23552,0,0,1,1,0,1,'2024-12-27 14:31:15',466826,'2024-12-27 14:31:20',524061,26989,'','',30,0,0.00992,0.466,0,'OK - 192.168.77.8: rta 0.195ms, lost 0%','rta=0.195ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629178,2,23549,0,0,1,10,0,1,'2024-12-27 14:31:15',469515,'2024-12-27 14:31:20',524278,26989,'','',30,0,0.01375,0.469,0,'OK - 84.38.95.222: rta 0.315ms, lost 0%','rta=0.315ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629179,2,21396,0,0,1,5,0,1,'2024-12-27 14:31:20',524339,'2024-12-27 14:31:20',553805,26989,'','',30,0,0.029,0,0,'OK - 192.168.77.159: rta 1.092ms, lost 0%','rta=1.092ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629180,2,21397,0,0,1,5,1,1,'2024-12-27 14:31:15',473445,'2024-12-27 14:31:20',554397,26989,'','',30,0,2.00759,0.473,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629181,2,23548,0,0,1,5,1,1,'2024-12-27 14:31:15',476288,'2024-12-27 14:31:20',554653,26989,'','',30,0,2.00872,0.476,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629182,2,23553,0,0,1,10,1,1,'2024-12-27 14:31:20',554729,'2024-12-27 14:31:22',564696,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629183,2,23554,0,0,1,1,0,1,'2024-12-27 14:31:25',588998,'2024-12-27 14:31:25',599439,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629184,2,28279,0,0,1,1,0,1,'2024-12-27 14:31:22',567593,'2024-12-27 14:31:25',599968,26989,'','',30,0,0.00674,2.567,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629185,2,21395,0,0,1,5,1,1,'2024-12-27 14:31:22',571070,'2024-12-27 14:31:25',600212,26989,'','',30,0,2.00759,2.571,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629186,2,28533,0,0,1,1,1,1,'2024-12-27 14:31:25',602519,'2024-12-27 14:31:30',625936,26989,'','',30,0,2.00665,0.602,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629187,2,23554,0,0,1,1,0,1,'2024-12-27 14:31:30',628134,'2024-12-27 14:31:35',653613,26989,'','',30,0,0.0092,0.628,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629188,2,23552,0,0,1,1,0,1,'2024-12-27 14:31:45',698661,'2024-12-27 14:31:45',708939,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.121ms, lost 0%','rta=0.121ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629189,2,23553,0,0,1,10,1,1,'2024-12-27 14:31:45',709310,'2024-12-27 14:31:47',717999,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629190,2,23553,0,0,1,10,1,1,'2024-12-27 14:31:47',720579,'2024-12-27 14:31:50',745665,26989,'','',30,0,0.99552,2.72,2,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629191,2,23549,0,0,1,10,0,1,'2024-12-27 14:31:50',745955,'2024-12-27 14:31:50',761770,26989,'','',30,0,0.015,0,0,'OK - 84.38.95.222: rta 0.406ms, lost 0%','rta=0.406ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629192,2,21396,0,0,1,5,0,1,'2024-12-27 14:31:50',764192,'2024-12-27 14:31:55',788991,26989,'','',30,0,0.02809,0.764,0,'OK - 192.168.77.159: rta 1.108ms, lost 0%','rta=1.108ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629193,2,23554,0,0,1,1,0,1,'2024-12-27 14:31:55',789070,'2024-12-27 14:31:55',800450,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629194,2,23551,0,0,1,1,0,1,'2024-12-27 14:31:55',800808,'2024-12-27 14:31:55',810727,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629195,2,28533,0,0,1,1,1,1,'2024-12-27 14:32:05',890186,'2024-12-27 14:32:07',899470,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629196,2,23552,0,0,1,1,0,1,'2024-12-27 14:32:10',930287,'2024-12-27 14:32:10',941735,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.8: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629197,2,23551,0,0,1,1,0,1,'2024-12-27 14:32:10',944305,'2024-12-27 14:32:15',978227,26989,'','',30,0,0.00928,0.944,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629198,2,21397,0,0,1,5,1,1,'2024-12-27 14:32:15',978291,'2024-12-27 14:32:17',987037,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629199,2,23553,0,0,1,10,1,1,'2024-12-27 14:32:17',987375,'2024-12-27 14:32:18',987243,26989,'','',30,0,1,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629200,2,23554,0,0,1,1,0,1,'2024-12-27 14:32:21',0,'2024-12-27 14:32:21',8474,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.208: rta 0.148ms, lost 0%','rta=0.148ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629201,2,23549,0,0,1,10,0,1,'2024-12-27 14:32:21',8694,'2024-12-27 14:32:21',16163,26989,'','',30,0,0.016,0,0,'OK - 84.38.95.222: rta 0.487ms, lost 0%','rta=0.487ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629202,2,23552,0,0,1,1,0,1,'2024-12-27 14:32:21',3,'2024-12-27 14:32:25',53,26989,'','',30,0,0.00885,1.039,0,'OK - 192.168.77.8: rta 0.118ms, lost 0%','rta=0.118ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629203,2,23549,0,0,1,10,0,1,'2024-12-27 14:32:21',279,'2024-12-27 14:32:25',27668,26989,'','',30,0,0.01485,1.042,0,'OK - 84.38.95.222: rta 0.408ms, lost 0%','rta=0.408ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629204,2,28533,0,0,1,1,1,1,'2024-12-27 14:32:25',434,'2024-12-27 14:32:27',3910,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629205,2,21397,0,0,1,5,1,1,'2024-12-27 14:32:21',35,'2024-12-27 14:32:27',31577,26989,'','',30,0,2.01075,1.043,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629206,2,23548,0,0,1,5,1,1,'2024-12-27 14:32:21',19769,'2024-12-27 14:32:27',31714,26989,'','',30,0,2.00919,1.046,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629207,2,28279,0,0,1,1,0,1,'2024-12-27 14:32:27',63,'2024-12-27 14:32:30',0,26989,'','',30,0,0.00652,2.077,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629208,2,21395,0,0,1,5,1,1,'2024-12-27 14:32:27',0,'2024-12-27 14:32:30',0,26989,'','',30,0,2.00811,2.08,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629209,2,23551,0,0,1,1,0,1,'2024-12-27 14:32:30',0,'2024-12-27 14:32:30',104579,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629210,2,28533,0,0,1,1,1,1,'2024-12-27 14:32:30',107012,'2024-12-27 14:32:35',148058,26989,'','',30,0,2.00775,0.106,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629211,2,23554,0,0,1,1,0,1,'2024-12-27 14:32:35',150558,'2024-12-27 14:32:40',165739,26989,'','',30,0,0.00987,0.15,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629212,2,21397,0,0,1,5,1,1,'2024-12-27 14:32:45',182720,'2024-12-27 14:32:47',191963,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629213,2,23553,0,0,1,10,1,1,'2024-12-27 14:32:47',192300,'2024-12-27 14:32:48',191161,26989,'','',30,0,0.999,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629214,2,28533,0,0,1,1,1,1,'2024-12-27 14:32:55',222152,'2024-12-27 14:32:56',305559,26989,'','',30,0,1.083,0,1,'CRITICAL - 172.50.1.3: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629215,2,23553,0,0,1,10,1,1,'2024-12-27 14:32:50',205874,'2024-12-27 14:32:56',306073,26989,'','',30,0,2.00781,0.205,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629216,2,21396,0,0,1,5,0,1,'2024-12-27 14:32:56',308474,'2024-12-27 14:33:00',326872,26989,'','',30,0,0.0197,1.308,0,'OK - 192.168.77.159: rta 0.690ms, lost 0%','rta=0.690ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629217,2,23551,0,0,1,1,0,1,'2024-12-27 14:33:00',327502,'2024-12-27 14:33:00',338535,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629218,2,23552,0,0,1,1,0,1,'2024-12-27 14:33:05',366053,'2024-12-27 14:33:05',376124,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.128ms, lost 0%','rta=0.128ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629219,2,23554,0,0,1,1,0,1,'2024-12-27 14:33:10',411196,'2024-12-27 14:33:10',422760,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629220,2,23548,0,0,1,5,1,1,'2024-12-27 14:33:10',423084,'2024-12-27 14:33:12',432397,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629221,2,23551,0,0,1,1,0,1,'2024-12-27 14:33:15',460525,'2024-12-27 14:33:20',491305,26989,'','',30,0,0.0103,0.46,0,'OK - 192.168.77.29: rta 0.146ms, lost 0%','rta=0.146ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629222,2,21395,0,0,1,5,1,1,'2024-12-27 14:33:25',529477,'2024-12-27 14:33:27',539965,26989,'','',30,0,2.01,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629223,2,23552,0,0,1,1,0,1,'2024-12-27 14:33:27',540300,'2024-12-27 14:33:27',550864,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.132ms, lost 0%','rta=0.132ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629224,2,28533,0,0,1,1,1,1,'2024-12-27 14:33:30',591645,'2024-12-27 14:33:32',601031,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629225,2,23552,0,0,1,1,0,1,'2024-12-27 14:33:27',553706,'2024-12-27 14:33:32',601530,26989,'','',30,0,0.01022,2.553,0,'OK - 192.168.77.8: rta 0.177ms, lost 0%','rta=0.177ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629226,2,23549,0,0,1,10,0,1,'2024-12-27 14:33:27',554704,'2024-12-27 14:33:32',601753,26989,'','',30,0,0.08246,2.554,0,'OK - 84.38.95.222: rta 3.672ms, lost 0%','rta=3.672ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629227,2,23548,0,0,1,5,1,1,'2024-12-27 14:33:32',602053,'2024-12-27 14:33:34',610437,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629228,2,21397,0,0,1,5,1,1,'2024-12-27 14:33:27',571531,'2024-12-27 14:33:34',610902,26989,'','',30,0,2.00756,0.571,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629229,2,23548,0,0,1,5,1,1,'2024-12-27 14:33:27',574694,'2024-12-27 14:33:34',611123,26989,'','',30,0,2.00665,0.574,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629230,2,28279,0,0,1,1,0,1,'2024-12-27 14:33:34',613692,'2024-12-27 14:33:35',638698,26989,'','',30,0,0.00636,4.613,0,'OK - 192.168.77.9: rta 0.014ms, lost 0%','rta=0.014ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629231,2,21395,0,0,1,5,1,1,'2024-12-27 14:33:34',616862,'2024-12-27 14:33:40',673753,26989,'','',30,0,2.00786,4.616,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629232,2,28533,0,0,1,1,1,1,'2024-12-27 14:33:35',640873,'2024-12-27 14:33:40',674001,26989,'','',30,0,2.00811,0.64,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629233,2,23551,0,0,1,1,0,1,'2024-12-27 14:33:40',674072,'2024-12-27 14:33:40',685378,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629234,2,23553,0,0,1,10,1,1,'2024-12-27 14:33:40',685712,'2024-12-27 14:33:40',768406,26989,'','',30,0,0.082,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629235,2,23554,0,0,1,1,0,1,'2024-12-27 14:33:40',771159,'2024-12-27 14:33:45',797223,26989,'','',30,0,0.00881,0.771,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629236,2,23552,0,0,1,1,0,1,'2024-12-27 14:33:50',832644,'2024-12-27 14:33:50',842835,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.126ms, lost 0%','rta=0.126ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629237,2,21395,0,0,1,5,1,1,'2024-12-27 14:33:50',844012,'2024-12-27 14:33:51',816088,26989,'','',30,0,0.972,0,1,'CRITICAL - 192.168.77.154: Host unreachable @ 192.168.77.9. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629238,2,23553,0,0,1,10,1,1,'2024-12-27 14:33:56',842770,'2024-12-27 14:34:00',862063,26989,'','',30,0,2.00731,0.842,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629239,2,23554,0,0,1,1,0,1,'2024-12-27 14:34:00',862115,'2024-12-27 14:34:00',873375,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629240,2,21396,0,0,1,5,0,1,'2024-12-27 14:34:00',882048,'2024-12-27 14:34:05',911121,26989,'','',30,0,0.03,0.882,0,'OK - 192.168.77.159: rta 1.090ms, lost 0%','rta=1.090ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629241,2,23551,0,0,1,1,0,1,'2024-12-27 14:34:05',911181,'2024-12-27 14:34:05',921700,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629242,2,28533,0,0,1,1,1,1,'2024-12-27 14:34:05',922003,'2024-12-27 14:34:07',930440,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629243,2,28279,0,0,1,1,0,1,'2024-12-27 14:34:10',963020,'2024-12-27 14:34:10',970630,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629244,2,23552,0,0,1,1,0,1,'2024-12-27 14:34:15',999005,'2024-12-27 14:34:16',0,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.107ms, lost 0%','rta=0.107ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629245,2,21396,0,0,1,5,0,1,'2024-12-27 14:34:20',174,'2024-12-27 14:34:20',5,26989,'','',30,0,0.031,0,0,'OK - 192.168.77.159: rta 1.162ms, lost 0%','rta=1.162ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629246,2,23553,0,0,1,10,1,1,'2024-12-27 14:34:25',30916,'2024-12-27 14:34:27',0,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629247,2,23551,0,0,1,1,0,1,'2024-12-27 14:34:20',49,'2024-12-27 14:34:27',0,26989,'','',30,0,0.00991,0.061,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629248,2,23554,0,0,1,1,0,1,'2024-12-27 14:34:27',0,'2024-12-27 14:34:27',114341,26989,'','',30,0,0.018,0,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629249,2,23552,0,0,1,1,0,1,'2024-12-27 14:34:32',130869,'2024-12-27 14:34:35',153303,26989,'','',30,0,0.01261,0.13,0,'OK - 192.168.77.8: rta 0.121ms, lost 0%','rta=0.121ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629250,2,23549,0,0,1,10,0,1,'2024-12-27 14:34:32',132796,'2024-12-27 14:34:35',153512,26989,'','',30,0,0.01958,0.132,0,'OK - 84.38.95.222: rta 0.300ms, lost 0%','rta=0.300ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629251,2,28279,0,0,1,1,0,1,'2024-12-27 14:34:35',156070,'2024-12-27 14:34:40',171052,26989,'','',30,0,0.00718,0.156,0,'OK - 192.168.77.9: rta 0.030ms, lost 0%','rta=0.030ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629252,2,21397,0,0,1,5,1,1,'2024-12-27 14:34:34',145067,'2024-12-27 14:34:40',171290,26989,'','',30,0,2.00774,0.145,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629253,2,23548,0,0,1,5,1,1,'2024-12-27 14:34:34',147915,'2024-12-27 14:34:40',171522,26989,'','',30,0,2.00925,0.147,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629254,2,21395,0,0,1,5,1,1,'2024-12-27 14:34:40',173676,'2024-12-27 14:34:45',189019,26989,'','',30,0,2.00894,0.173,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629255,2,28533,0,0,1,1,1,1,'2024-12-27 14:34:40',175587,'2024-12-27 14:34:45',189260,26989,'','',30,0,2.00962,0.175,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629256,2,23553,0,0,1,10,1,1,'2024-12-27 14:34:45',189626,'2024-12-27 14:34:47',199008,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629257,2,23554,0,0,1,1,0,1,'2024-12-27 14:34:47',222461,'2024-12-27 14:34:50',240350,26989,'','',30,0,0.00992,2.222,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629258,2,23549,0,0,1,10,0,1,'2024-12-27 14:34:50',240704,'2024-12-27 14:34:50',252570,26989,'','',30,0,0.011,0,0,'OK - 84.38.95.222: rta 0.197ms, lost 0%','rta=0.197ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629259,2,23551,0,0,1,1,0,1,'2024-12-27 14:34:55',292722,'2024-12-27 14:34:55',303617,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629260,2,23553,0,0,1,10,1,1,'2024-12-27 14:35:00',321560,'2024-12-27 14:35:05',340522,26989,'','',30,0,2.00702,0.321,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629261,2,28533,0,0,1,1,1,1,'2024-12-27 14:35:05',340845,'2024-12-27 14:35:07',350970,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629262,2,21396,0,0,1,5,0,1,'2024-12-27 14:35:07',368156,'2024-12-27 14:35:10',376250,26989,'','',30,0,0.02846,2.368,0,'OK - 192.168.77.159: rta 1.122ms, lost 0%','rta=1.122ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629263,2,23552,0,0,1,1,0,1,'2024-12-27 14:35:10',376304,'2024-12-27 14:35:10',386955,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.141ms, lost 0%','rta=0.141ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629264,2,21397,0,0,1,5,1,1,'2024-12-27 14:35:15',400860,'2024-12-27 14:35:17',410526,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629265,2,23553,0,0,1,10,1,1,'2024-12-27 14:35:17',420122,'2024-12-27 14:35:18',408698,26989,'','',30,0,0.989,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629266,2,23554,0,0,1,1,0,1,'2024-12-27 14:35:20',420505,'2024-12-27 14:35:20',430964,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629267,2,23549,0,0,1,10,0,1,'2024-12-27 14:35:20',431288,'2024-12-27 14:35:20',443616,26989,'','',30,0,0.012,0,0,'OK - 84.38.95.222: rta 0.273ms, lost 0%','rta=0.273ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629268,2,28533,0,0,1,1,1,1,'2024-12-27 14:35:25',477135,'2024-12-27 14:35:27',497802,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629269,2,23551,0,0,1,1,0,1,'2024-12-27 14:35:27',507136,'2024-12-27 14:35:30',516526,26989,'','',30,0,0.01237,0.507,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629270,2,28279,0,0,1,1,0,1,'2024-12-27 14:35:35',535631,'2024-12-27 14:35:35',543661,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629271,2,23552,0,0,1,1,0,1,'2024-12-27 14:35:35',544007,'2024-12-27 14:35:35',553327,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.124ms, lost 0%','rta=0.124ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629272,2,23552,0,0,1,1,0,1,'2024-12-27 14:35:35',555841,'2024-12-27 14:35:40',567293,26989,'','',30,0,0.0097,0.555,0,'OK - 192.168.77.8: rta 0.157ms, lost 0%','rta=0.157ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629273,2,23549,0,0,1,10,0,1,'2024-12-27 14:35:35',558440,'2024-12-27 14:35:40',567544,26989,'','',30,0,0.01097,0.558,0,'OK - 84.38.95.222: rta 0.213ms, lost 0%','rta=0.213ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629274,2,28279,0,0,1,1,0,1,'2024-12-27 14:35:40',573785,'2024-12-27 14:35:45',595053,26989,'','',30,0,0.00778,0.573,0,'OK - 192.168.77.9: rta 0.017ms, lost 0%','rta=0.017ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629275,2,21397,0,0,1,5,1,1,'2024-12-27 14:35:45',595110,'2024-12-27 14:35:47',604092,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629276,2,21397,0,0,1,5,1,1,'2024-12-27 14:35:40',577321,'2024-12-27 14:35:47',604562,26989,'','',30,0,0.06332,0.577,2,'CRITICAL - 172.20.3.10: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629277,2,23548,0,0,1,5,1,1,'2024-12-27 14:35:40',580892,'2024-12-27 14:35:47',604823,26989,'','',30,0,0.06021,0.58,2,'CRITICAL - 172.20.3.11: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629278,2,23553,0,0,1,10,1,1,'2024-12-27 14:35:47',604877,'2024-12-27 14:35:48',603285,26989,'','',30,0,0.999,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629279,2,23554,0,0,1,1,0,1,'2024-12-27 14:35:48',603837,'2024-12-27 14:35:48',613732,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629280,2,21395,0,0,1,5,1,1,'2024-12-27 14:35:48',616194,'2024-12-27 14:35:50',636376,26989,'','',30,0,2.00692,3.616,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629281,2,28533,0,0,1,1,1,1,'2024-12-27 14:35:48',618946,'2024-12-27 14:35:50',636614,26989,'','',30,0,2.00712,3.618,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629282,2,23554,0,0,1,1,0,1,'2024-12-27 14:35:50',638943,'2024-12-27 14:35:55',653775,26989,'','',30,0,0.0106,0.638,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629283,2,23551,0,0,1,1,0,1,'2024-12-27 14:36:00',674605,'2024-12-27 14:36:00',685573,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629284,2,23552,0,0,1,1,0,1,'2024-12-27 14:36:05',699964,'2024-12-27 14:36:05',711184,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629285,2,23553,0,0,1,10,1,1,'2024-12-27 14:36:05',711538,'2024-12-27 14:36:07',720240,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629286,2,23553,0,0,1,10,1,1,'2024-12-27 14:36:07',723029,'2024-12-27 14:36:10',739294,26989,'','',30,0,0.99532,2.723,2,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629287,2,23554,0,0,1,1,0,1,'2024-12-27 14:36:10',739357,'2024-12-27 14:36:10',749986,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629288,2,23548,0,0,1,5,1,1,'2024-12-27 14:36:10',750317,'2024-12-27 14:36:12',758013,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629289,2,21396,0,0,1,5,0,1,'2024-12-27 14:36:12',760594,'2024-12-27 14:36:15',783604,26989,'','',30,0,0.02841,2.76,0,'OK - 192.168.77.159: rta 1.123ms, lost 0%','rta=1.123ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629290,2,21395,0,0,1,5,1,1,'2024-12-27 14:36:25',840299,'2024-12-27 14:36:27',849777,26989,'','',30,0,2.009,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629291,2,23552,0,0,1,1,0,1,'2024-12-27 14:36:27',850076,'2024-12-27 14:36:27',859901,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.127ms, lost 0%','rta=0.127ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629292,2,23551,0,0,1,1,0,1,'2024-12-27 14:36:27',860195,'2024-12-27 14:36:27',870235,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629293,2,28533,0,0,1,1,1,1,'2024-12-27 14:36:30',906133,'2024-12-27 14:36:32',916716,26989,'','',30,0,2.01,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629294,2,23548,0,0,1,5,1,1,'2024-12-27 14:36:32',917404,'2024-12-27 14:36:34',927234,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629295,2,23551,0,0,1,1,0,1,'2024-12-27 14:36:34',930210,'2024-12-27 14:36:35',957915,26989,'','',30,0,0.00915,4.93,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629296,2,23553,0,0,1,10,1,1,'2024-12-27 14:36:40',994190,'2024-12-27 14:36:41',7,26989,'','',30,0,0.085,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629297,2,23552,0,0,1,1,0,1,'2024-12-27 14:36:41',0,'2024-12-27 14:36:45',103436,26989,'','',30,0,0.00968,1.081,0,'OK - 192.168.77.8: rta 0.127ms, lost 0%','rta=0.127ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629298,2,23549,0,0,1,10,0,1,'2024-12-27 14:36:41',0,'2024-12-27 14:36:45',103687,26989,'','',30,0,0.01301,1.084,0,'OK - 84.38.95.222: rta 0.278ms, lost 0%','rta=0.278ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629299,2,28279,0,0,1,1,0,1,'2024-12-27 14:36:45',106440,'2024-12-27 14:36:50',138799,26989,'','',30,0,0.0074,0.106,0,'OK - 192.168.77.9: rta 0.016ms, lost 0%','rta=0.016ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629300,2,23554,0,0,1,1,0,1,'2024-12-27 14:36:50',139577,'2024-12-27 14:36:50',151167,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629301,2,21397,0,0,1,5,1,1,'2024-12-27 14:36:47',113412,'2024-12-27 14:36:50',151807,26989,'','',30,0,2.00831,0.113,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629302,2,23548,0,0,1,5,1,1,'2024-12-27 14:36:47',114476,'2024-12-27 14:36:50',152022,26989,'','',30,0,2.00922,0.114,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629303,2,21395,0,0,1,5,1,1,'2024-12-27 14:36:50',152076,'2024-12-27 14:36:51',131601,26989,'','',30,0,0.98,0,1,'CRITICAL - 192.168.77.154: Host unreachable @ 192.168.77.9. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629304,2,21395,0,0,1,5,1,1,'2024-12-27 14:36:51',134081,'2024-12-27 14:36:55',204896,26989,'','',30,0,2.00773,1.134,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629305,2,28533,0,0,1,1,1,1,'2024-12-27 14:36:51',137294,'2024-12-27 14:36:55',205165,26989,'','',30,0,2.00818,1.137,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629306,2,23554,0,0,1,1,0,1,'2024-12-27 14:36:55',207996,'2024-12-27 14:37:00',221873,26989,'','',30,0,0.01003,0.207,0,'OK - 192.168.77.208: rta 0.154ms, lost 0%','rta=0.154ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629307,2,23552,0,0,1,1,0,1,'2024-12-27 14:37:00',221940,'2024-12-27 14:37:00',232141,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.121ms, lost 0%','rta=0.121ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629308,2,23551,0,0,1,1,0,1,'2024-12-27 14:37:05',261798,'2024-12-27 14:37:05',272986,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629309,2,28279,0,0,1,1,0,1,'2024-12-27 14:37:10',293853,'2024-12-27 14:37:10',301570,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629310,2,23553,0,0,1,10,1,1,'2024-12-27 14:37:10',304221,'2024-12-27 14:37:15',320976,26989,'','',30,0,2.00694,0.304,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629311,2,21396,0,0,1,5,0,1,'2024-12-27 14:37:15',323429,'2024-12-27 14:37:20',353294,26989,'','',30,0,0.02852,0.323,0,'OK - 192.168.77.159: rta 1.100ms, lost 0%','rta=1.100ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629312,2,23554,0,0,1,1,0,1,'2024-12-27 14:37:25',394864,'2024-12-27 14:37:25',406068,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629313,2,23551,0,0,1,1,0,1,'2024-12-27 14:37:35',454944,'2024-12-27 14:37:40',479738,26989,'','',30,0,0.00933,0.454,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629314,2,23552,0,0,1,1,0,1,'2024-12-27 14:37:45',517713,'2024-12-27 14:37:45',527824,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.116ms, lost 0%','rta=0.116ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629315,2,23553,0,0,1,10,1,1,'2024-12-27 14:37:45',528148,'2024-12-27 14:37:47',537470,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629316,2,23552,0,0,1,1,0,1,'2024-12-27 14:37:47',539899,'2024-12-27 14:37:50',572452,26989,'','',30,0,0.0108,2.539,0,'OK - 192.168.77.8: rta 0.238ms, lost 0%','rta=0.238ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629317,2,23549,0,0,1,10,0,1,'2024-12-27 14:37:47',542980,'2024-12-27 14:37:50',572666,26989,'','',30,0,0.01571,2.542,0,'OK - 84.38.95.222: rta 0.473ms, lost 0%','rta=0.473ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629318,2,28279,0,0,1,1,0,1,'2024-12-27 14:37:50',575314,'2024-12-27 14:37:55',615300,26989,'','',30,0,0.00685,0.575,0,'OK - 192.168.77.9: rta 0.016ms, lost 0%','rta=0.016ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629319,2,23554,0,0,1,1,0,1,'2024-12-27 14:37:55',615360,'2024-12-27 14:37:55',626005,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629320,2,21397,0,0,1,5,1,1,'2024-12-27 14:37:50',578601,'2024-12-27 14:37:55',626481,26989,'','',30,0,2.00685,0.578,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629321,2,23548,0,0,1,5,1,1,'2024-12-27 14:37:50',581631,'2024-12-27 14:37:55',626699,26989,'','',30,0,2.00838,0.581,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629322,2,23551,0,0,1,1,0,1,'2024-12-27 14:37:55',626758,'2024-12-27 14:37:55',636581,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629323,2,21395,0,0,1,5,1,1,'2024-12-27 14:37:55',639007,'2024-12-27 14:38:00',669256,26989,'','',30,0,2.00727,0.638,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629324,2,28533,0,0,1,1,1,1,'2024-12-27 14:37:55',642096,'2024-12-27 14:38:00',669511,26989,'','',30,0,2.00715,0.642,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629325,2,23554,0,0,1,1,0,1,'2024-12-27 14:38:00',672802,'2024-12-27 14:38:05',700990,26989,'','',30,0,0.00921,0.672,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629326,2,23552,0,0,1,1,0,1,'2024-12-27 14:38:10',726932,'2024-12-27 14:38:10',738179,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.125ms, lost 0%','rta=0.125ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629327,2,21397,0,0,1,5,1,1,'2024-12-27 14:38:15',777048,'2024-12-27 14:38:17',786417,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629328,2,23553,0,0,1,10,1,1,'2024-12-27 14:38:17',786754,'2024-12-27 14:38:18',785638,26989,'','',30,0,0.999,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629329,2,23554,0,0,1,1,0,1,'2024-12-27 14:38:20',829488,'2024-12-27 14:38:20',840431,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629330,2,23549,0,0,1,10,0,1,'2024-12-27 14:38:20',840736,'2024-12-27 14:38:20',856289,26989,'','',30,0,0.015,0,0,'OK - 84.38.95.222: rta 0.391ms, lost 0%','rta=0.391ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629331,2,23553,0,0,1,10,1,1,'2024-12-27 14:38:18',788105,'2024-12-27 14:38:20',856848,26989,'','',30,0,2.00802,3.788,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629332,2,21396,0,0,1,5,0,1,'2024-12-27 14:38:20',859273,'2024-12-27 14:38:25',888454,26989,'','',30,0,0.02984,0.859,0,'OK - 192.168.77.159: rta 1.162ms, lost 0%','rta=1.162ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629333,2,28533,0,0,1,1,1,1,'2024-12-27 14:38:25',888752,'2024-12-27 14:38:27',898579,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629334,2,23551,0,0,1,1,0,1,'2024-12-27 14:38:30',928442,'2024-12-27 14:38:30',939743,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629335,2,28279,0,0,1,1,0,1,'2024-12-27 14:38:35',977626,'2024-12-27 14:38:35',986060,26989,'','',30,0,0.008,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629336,2,23552,0,0,1,1,0,1,'2024-12-27 14:38:35',986396,'2024-12-27 14:38:35',995914,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.128ms, lost 0%','rta=0.128ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629337,2,23551,0,0,1,1,0,1,'2024-12-27 14:38:40',6696,'2024-12-27 14:38:45',1463,26989,'','',30,0,0.00915,0.015,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629338,2,21397,0,0,1,5,1,1,'2024-12-27 14:38:45',11737,'2024-12-27 14:38:47',15169,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629339,2,23553,0,0,1,10,1,1,'2024-12-27 14:38:47',15384,'2024-12-27 14:38:48',15288,26989,'','',30,0,1,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629340,2,23554,0,0,1,1,0,1,'2024-12-27 14:38:48',29,'2024-12-27 14:38:48',37,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.155ms, lost 0%','rta=0.155ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629341,2,23552,0,0,1,1,0,1,'2024-12-27 14:38:50',387,'2024-12-27 14:38:55',7,26989,'','',30,0,0.00915,0.06,0,'OK - 192.168.77.8: rta 0.115ms, lost 0%','rta=0.115ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629342,2,23549,0,0,1,10,0,1,'2024-12-27 14:38:50',412,'2024-12-27 14:38:55',7,26989,'','',30,0,0.01365,0.063,0,'OK - 84.38.95.222: rta 0.330ms, lost 0%','rta=0.330ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629343,2,28533,0,0,1,1,1,1,'2024-12-27 14:38:55',7,'2024-12-27 14:38:57',0,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629344,2,28279,0,0,1,1,0,1,'2024-12-27 14:38:57',0,'2024-12-27 14:39:00',112701,26989,'','',30,0,0.00645,2.091,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629345,2,23551,0,0,1,1,0,1,'2024-12-27 14:39:00',113469,'2024-12-27 14:39:00',124086,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629346,2,21397,0,0,1,5,1,1,'2024-12-27 14:38:57',0,'2024-12-27 14:39:00',124562,26989,'','',30,0,2.00892,2.094,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629347,2,23548,0,0,1,5,1,1,'2024-12-27 14:38:57',0,'2024-12-27 14:39:00',124793,26989,'','',30,0,2.0078,2.098,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629348,2,21395,0,0,1,5,1,1,'2024-12-27 14:39:00',127031,'2024-12-27 14:39:05',144936,26989,'','',30,0,2.00805,0.127,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629349,2,28533,0,0,1,1,1,1,'2024-12-27 14:39:00',130022,'2024-12-27 14:39:05',145167,26989,'','',30,0,2.00905,0.129,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629350,2,23553,0,0,1,10,1,1,'2024-12-27 14:39:05',145478,'2024-12-27 14:39:07',154211,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629351,2,23554,0,0,1,1,0,1,'2024-12-27 14:39:07',156876,'2024-12-27 14:39:10',186083,26989,'','',30,0,0.00919,2.156,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629352,2,21395,0,0,1,5,1,1,'2024-12-27 14:39:25',256874,'2024-12-27 14:39:27',266656,26989,'','',30,0,2.009,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629353,2,23552,0,0,1,1,0,1,'2024-12-27 14:39:27',266991,'2024-12-27 14:39:27',277547,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.124ms, lost 0%','rta=0.124ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629354,2,23551,0,0,1,1,0,1,'2024-12-27 14:39:27',277831,'2024-12-27 14:39:27',287668,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629355,2,23553,0,0,1,10,1,1,'2024-12-27 14:39:20',240785,'2024-12-27 14:39:27',288152,26989,'','',30,0,2.00941,0.24,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629356,2,28533,0,0,1,1,1,1,'2024-12-27 14:39:30',334034,'2024-12-27 14:39:32',343068,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629357,2,21396,0,0,1,5,0,1,'2024-12-27 14:39:27',290465,'2024-12-27 14:39:32',343581,26989,'','',30,0,0.02779,2.29,0,'OK - 192.168.77.159: rta 1.090ms, lost 0%','rta=1.090ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629358,2,23548,0,0,1,5,1,1,'2024-12-27 14:39:32',343908,'2024-12-27 14:39:34',352617,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629359,2,23553,0,0,1,10,1,1,'2024-12-27 14:39:40',423397,'2024-12-27 14:39:40',503527,26989,'','',30,0,0.079,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629360,2,23551,0,0,1,1,0,1,'2024-12-27 14:39:45',532249,'2024-12-27 14:39:50',574715,26989,'','',30,0,0.01042,0.532,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629361,2,23552,0,0,1,1,0,1,'2024-12-27 14:39:50',574786,'2024-12-27 14:39:50',585606,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.119ms, lost 0%','rta=0.119ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629362,2,23554,0,0,1,1,0,1,'2024-12-27 14:39:50',586235,'2024-12-27 14:39:50',596401,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629363,2,21395,0,0,1,5,1,1,'2024-12-27 14:39:50',597308,'2024-12-27 14:39:51',550895,26989,'','',30,0,0.954,0,1,'CRITICAL - 192.168.77.154: Host unreachable @ 192.168.77.9. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629364,2,23549,0,0,1,10,0,1,'2024-12-27 14:39:55',585395,'2024-12-27 14:40:00',612818,26989,'','',30,0,0.01072,0.585,0,'OK - 84.38.95.222: rta 0.199ms, lost 0%','rta=0.199ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629365,2,23552,0,0,1,1,0,1,'2024-12-27 14:39:55',584749,'2024-12-27 14:40:00',613007,26989,'','',30,0,0.01201,0.584,0,'OK - 192.168.77.8: rta 0.133ms, lost 0%','rta=0.133ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629366,2,28279,0,0,1,1,0,1,'2024-12-27 14:40:00',626316,'2024-12-27 14:40:05',658857,26989,'','',30,0,0.00663,0.626,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629367,2,23551,0,0,1,1,0,1,'2024-12-27 14:40:05',658925,'2024-12-27 14:40:05',670581,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629368,2,28533,0,0,1,1,1,1,'2024-12-27 14:40:05',670948,'2024-12-27 14:40:07',680892,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629369,2,21397,0,0,1,5,1,1,'2024-12-27 14:40:00',629491,'2024-12-27 14:40:07',681418,26989,'','',30,0,2.00817,0.629,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629370,2,23548,0,0,1,5,1,1,'2024-12-27 14:40:00',631418,'2024-12-27 14:40:07',681658,26989,'','',30,0,2.00848,0.631,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629371,2,28533,0,0,1,1,1,1,'2024-12-27 14:40:07',687329,'2024-12-27 14:40:10',712255,26989,'','',30,0,0.99179,2.687,2,'CRITICAL - 172.50.1.3: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629372,2,21395,0,0,1,5,1,1,'2024-12-27 14:40:07',684067,'2024-12-27 14:40:10',712482,26989,'','',30,0,2.00814,2.684,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629373,2,23554,0,0,1,1,0,1,'2024-12-27 14:40:10',714677,'2024-12-27 14:40:15',741319,26989,'','',30,0,0.00942,0.714,0,'OK - 192.168.77.208: rta 0.148ms, lost 0%','rta=0.148ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629374,2,23552,0,0,1,1,0,1,'2024-12-27 14:40:15',741683,'2024-12-27 14:40:15',752683,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.118ms, lost 0%','rta=0.118ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629375,2,21396,0,0,1,5,0,1,'2024-12-27 14:40:20',787998,'2024-12-27 14:40:20',810294,26989,'','',30,0,0.022,0,0,'OK - 192.168.77.159: rta 0.718ms, lost 0%','rta=0.718ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629376,2,23553,0,0,1,10,1,1,'2024-12-27 14:40:20',810618,'2024-12-27 14:40:22',819712,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629377,2,23553,0,0,1,10,1,1,'2024-12-27 14:40:27',838389,'2024-12-27 14:40:30',864315,26989,'','',30,0,2.00846,0.838,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629378,2,21396,0,0,1,5,0,1,'2024-12-27 14:40:32',875035,'2024-12-27 14:40:35',905349,26989,'','',30,0,0.02787,0.875,0,'OK - 192.168.77.159: rta 1.072ms, lost 0%','rta=1.072ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629379,2,23552,0,0,1,1,0,1,'2024-12-27 14:40:45',963805,'2024-12-27 14:40:45',973988,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.131ms, lost 0%','rta=0.131ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629380,2,23553,0,0,1,10,1,1,'2024-12-27 14:40:45',974325,'2024-12-27 14:40:47',981975,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629381,2,23549,0,0,1,10,0,1,'2024-12-27 14:40:51',4658,'2024-12-27 14:40:51',19,26989,'','',30,0,0.012,0,0,'OK - 84.38.95.222: rta 0.264ms, lost 0%','rta=0.264ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629382,2,23551,0,0,1,1,0,1,'2024-12-27 14:40:51',11625,'2024-12-27 14:40:55',286,26989,'','',30,0,0.00896,1.026,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629383,2,23554,0,0,1,1,0,1,'2024-12-27 14:40:55',18425,'2024-12-27 14:40:55',44,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.154ms, lost 0%','rta=0.154ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629384,2,23549,0,0,1,10,0,1,'2024-12-27 14:41:00',62,'2024-12-27 14:41:05',0,26989,'','',30,0,0.01162,0.076,0,'OK - 84.38.95.222: rta 0.279ms, lost 0%','rta=0.279ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629385,2,23552,0,0,1,1,0,1,'2024-12-27 14:41:00',7,'2024-12-27 14:41:05',0,26989,'','',30,0,0.0108,0.079,0,'OK - 192.168.77.8: rta 0.162ms, lost 0%','rta=0.162ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629386,2,28533,0,0,1,1,1,1,'2024-12-27 14:41:05',0,'2024-12-27 14:41:07',108971,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629387,2,28279,0,0,1,1,0,1,'2024-12-27 14:41:07',122721,'2024-12-27 14:41:10',141145,26989,'','',30,0,0.00654,2.122,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629388,2,23548,0,0,1,5,1,1,'2024-12-27 14:41:07',129329,'2024-12-27 14:41:10',141650,26989,'','',30,0,0.08481,0.129,2,'CRITICAL - 172.20.3.11: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629389,2,21397,0,0,1,5,1,1,'2024-12-27 14:41:07',125996,'2024-12-27 14:41:10',141864,26989,'','',30,0,0.08818,0.125,2,'CRITICAL - 172.20.3.10: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629390,2,28533,0,0,1,1,1,1,'2024-12-27 14:41:10',144067,'2024-12-27 14:41:15',177936,26989,'','',30,0,2.0078,0.144,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629391,2,21395,0,0,1,5,1,1,'2024-12-27 14:41:10',147296,'2024-12-27 14:41:15',178185,26989,'','',30,0,2.00657,0.147,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629392,2,23553,0,0,1,10,1,1,'2024-12-27 14:41:15',178518,'2024-12-27 14:41:17',188157,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629393,2,23554,0,0,1,1,0,1,'2024-12-27 14:41:17',209660,'2024-12-27 14:41:20',224772,26989,'','',30,0,0.00901,2.209,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629394,2,23549,0,0,1,10,0,1,'2024-12-27 14:41:20',225098,'2024-12-27 14:41:20',238218,26989,'','',30,0,0.012,0,0,'OK - 84.38.95.222: rta 0.233ms, lost 0%','rta=0.233ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629395,2,23551,0,0,1,1,0,1,'2024-12-27 14:41:30',282809,'2024-12-27 14:41:30',293881,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629396,2,28279,0,0,1,1,0,1,'2024-12-27 14:41:35',311656,'2024-12-27 14:41:35',319426,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.014ms, lost 0%','rta=0.014ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629397,2,23553,0,0,1,10,1,1,'2024-12-27 14:41:30',296509,'2024-12-27 14:41:35',319956,26989,'','',30,0,2.00709,0.296,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629398,2,23552,0,0,1,1,0,1,'2024-12-27 14:41:35',320035,'2024-12-27 14:41:35',329383,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.125ms, lost 0%','rta=0.125ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629399,2,21396,0,0,1,5,0,1,'2024-12-27 14:41:35',332034,'2024-12-27 14:41:40',346069,26989,'','',30,0,0.02705,0.332,0,'OK - 192.168.77.159: rta 1.059ms, lost 0%','rta=1.059ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629400,2,21397,0,0,1,5,1,1,'2024-12-27 14:41:45',360317,'2024-12-27 14:41:47',370199,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629401,2,23553,0,0,1,10,1,1,'2024-12-27 14:41:47',386148,'2024-12-27 14:41:48',368421,26989,'','',30,0,0.983,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629402,2,23554,0,0,1,1,0,1,'2024-12-27 14:41:48',368973,'2024-12-27 14:41:48',378885,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629403,2,28533,0,0,1,1,1,1,'2024-12-27 14:41:55',402828,'2024-12-27 14:41:57',412209,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629404,2,23551,0,0,1,1,0,1,'2024-12-27 14:41:57',414718,'2024-12-27 14:42:00',434644,26989,'','',30,0,0.00914,2.414,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629405,2,23552,0,0,1,1,0,1,'2024-12-27 14:42:05',445482,'2024-12-27 14:42:05',456003,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.120ms, lost 0%','rta=0.120ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629406,2,23553,0,0,1,10,1,1,'2024-12-27 14:42:05',456286,'2024-12-27 14:42:07',464836,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629407,2,23552,0,0,1,1,0,1,'2024-12-27 14:42:07',470738,'2024-12-27 14:42:10',486922,26989,'','',30,0,0.00908,2.47,0,'OK - 192.168.77.8: rta 0.130ms, lost 0%','rta=0.130ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629408,2,23549,0,0,1,10,0,1,'2024-12-27 14:42:07',467587,'2024-12-27 14:42:10',487153,26989,'','',30,0,0.01636,2.467,0,'OK - 84.38.95.222: rta 0.513ms, lost 0%','rta=0.513ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629409,2,23554,0,0,1,1,0,1,'2024-12-27 14:42:10',487226,'2024-12-27 14:42:10',498427,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629410,2,23548,0,0,1,5,1,1,'2024-12-27 14:42:10',498743,'2024-12-27 14:42:12',507478,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629411,2,28279,0,0,1,1,0,1,'2024-12-27 14:42:12',510135,'2024-12-27 14:42:15',523881,26989,'','',30,0,0.00701,2.51,0,'OK - 192.168.77.9: rta 0.016ms, lost 0%','rta=0.016ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629412,2,23548,0,0,1,5,1,1,'2024-12-27 14:42:12',511655,'2024-12-27 14:42:15',524342,26989,'','',30,0,0.99301,2.511,2,'CRITICAL - 172.20.3.11: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629413,2,21397,0,0,1,5,1,1,'2024-12-27 14:42:12',513172,'2024-12-27 14:42:15',524571,26989,'','',30,0,0.99169,2.513,2,'CRITICAL - 172.20.3.10: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629414,2,28533,0,0,1,1,1,1,'2024-12-27 14:42:15',532736,'2024-12-27 14:42:20',548389,26989,'','',30,0,2.00828,0.532,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629415,2,21395,0,0,1,5,1,1,'2024-12-27 14:42:15',536359,'2024-12-27 14:42:20',548593,26989,'','',30,0,2.00694,0.536,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629416,2,23554,0,0,1,1,0,1,'2024-12-27 14:42:20',557892,'2024-12-27 14:42:25',573607,26989,'','',30,0,0.00958,0.557,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629417,2,23552,0,0,1,1,0,1,'2024-12-27 14:42:25',573920,'2024-12-27 14:42:25',584695,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.112ms, lost 0%','rta=0.112ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629418,2,23551,0,0,1,1,0,1,'2024-12-27 14:42:25',585047,'2024-12-27 14:42:25',596155,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629419,2,23548,0,0,1,5,1,1,'2024-12-27 14:42:30',635078,'2024-12-27 14:42:32',645116,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629420,2,28533,0,0,1,1,1,1,'2024-12-27 14:42:35',653825,'2024-12-27 14:42:37',663035,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629421,2,23553,0,0,1,10,1,1,'2024-12-27 14:42:40',710441,'2024-12-27 14:42:42',720003,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629422,2,23551,0,0,1,1,0,1,'2024-12-27 14:42:42',720359,'2024-12-27 14:42:42',730614,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.154ms, lost 0%','rta=0.154ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629423,2,23553,0,0,1,10,1,1,'2024-12-27 14:42:37',665462,'2024-12-27 14:42:42',731426,26989,'','',30,0,2.0078,2.665,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629424,2,21396,0,0,1,5,0,1,'2024-12-27 14:42:42',733713,'2024-12-27 14:42:45',757573,26989,'','',30,0,0.02034,2.733,0,'OK - 192.168.77.159: rta 0.721ms, lost 0%','rta=0.721ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629425,2,23552,0,0,1,1,0,1,'2024-12-27 14:42:50',809089,'2024-12-27 14:42:50',819371,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.139ms, lost 0%','rta=0.139ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629426,2,23554,0,0,1,1,0,1,'2024-12-27 14:42:50',820214,'2024-12-27 14:42:50',830315,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629427,2,21395,0,0,1,5,1,1,'2024-12-27 14:42:50',830866,'2024-12-27 14:42:51',778433,26989,'','',30,0,0.948,0,1,'CRITICAL - 192.168.77.154: Host unreachable @ 192.168.77.9. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629428,2,23553,0,0,1,10,1,1,'2024-12-27 14:42:55',809494,'2024-12-27 14:42:57',819433,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629429,2,23551,0,0,1,1,0,1,'2024-12-27 14:43:00',856390,'2024-12-27 14:43:05',880668,26989,'','',30,0,0.01046,0.856,0,'OK - 192.168.77.29: rta 0.154ms, lost 0%','rta=0.154ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629430,2,28533,0,0,1,1,1,1,'2024-12-27 14:43:05',881033,'2024-12-27 14:43:07',890488,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629431,2,28279,0,0,1,1,0,1,'2024-12-27 14:43:10',929237,'2024-12-27 14:43:10',937011,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629432,2,23552,0,0,1,1,0,1,'2024-12-27 14:43:10',939576,'2024-12-27 14:43:15',967045,26989,'','',30,0,0.00819,0.939,0,'OK - 192.168.77.8: rta 0.119ms, lost 0%','rta=0.119ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629433,2,23549,0,0,1,10,0,1,'2024-12-27 14:43:10',942615,'2024-12-27 14:43:15',967268,26989,'','',30,0,0.01682,0.942,0,'OK - 84.38.95.222: rta 0.526ms, lost 0%','rta=0.526ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629434,2,28279,0,0,1,1,0,1,'2024-12-27 14:43:15',970044,'2024-12-27 14:43:21',4795,26989,'','',30,0,0.00801,0.97,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629435,2,21396,0,0,1,5,0,1,'2024-12-27 14:43:21',4825,'2024-12-27 14:43:21',17058,26989,'','',30,0,0.029,0,0,'OK - 192.168.77.159: rta 1.115ms, lost 0%','rta=1.115ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629436,2,23548,0,0,1,5,1,1,'2024-12-27 14:43:15',973156,'2024-12-27 14:43:21',2170,26989,'','',30,0,2.00744,0.973,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629437,2,21397,0,0,1,5,1,1,'2024-12-27 14:43:15',976306,'2024-12-27 14:43:21',33,26989,'','',30,0,2.0083,0.976,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629438,2,23553,0,0,1,10,1,1,'2024-12-27 14:43:21',17425,'2024-12-27 14:43:23',21350,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629439,2,23554,0,0,1,1,0,1,'2024-12-27 14:43:25',26160,'2024-12-27 14:43:25',60,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629440,2,28533,0,0,1,1,1,1,'2024-12-27 14:43:23',355,'2024-12-27 14:43:30',0,26989,'','',30,0,2.00833,3.054,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629441,2,21395,0,0,1,5,1,1,'2024-12-27 14:43:23',47,'2024-12-27 14:43:30',0,26989,'','',30,0,2.00786,3.057,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629442,2,23554,0,0,1,1,0,1,'2024-12-27 14:43:25',508,'2024-12-27 14:43:30',0,26989,'','',30,0,0.00893,0.077,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629443,2,23552,0,0,1,1,0,1,'2024-12-27 14:43:45',176744,'2024-12-27 14:43:45',186659,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.124ms, lost 0%','rta=0.124ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629444,2,23553,0,0,1,10,1,1,'2024-12-27 14:43:42',153702,'2024-12-27 14:43:45',187186,26989,'','',30,0,1.64551,0.153,2,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629445,2,21396,0,0,1,5,0,1,'2024-12-27 14:43:45',189792,'2024-12-27 14:43:50',230600,26989,'','',30,0,0.02705,0.189,0,'OK - 192.168.77.159: rta 1.058ms, lost 0%','rta=1.058ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629446,2,23549,0,0,1,10,0,1,'2024-12-27 14:43:50',230975,'2024-12-27 14:43:50',243123,26989,'','',30,0,0.011,0,0,'OK - 84.38.95.222: rta 0.202ms, lost 0%','rta=0.202ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629447,2,23554,0,0,1,1,0,1,'2024-12-27 14:43:55',268783,'2024-12-27 14:43:55',279756,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.159ms, lost 0%','rta=0.159ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629448,2,23551,0,0,1,1,0,1,'2024-12-27 14:43:55',280149,'2024-12-27 14:43:55',291196,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629449,2,28533,0,0,1,1,1,1,'2024-12-27 14:44:05',371137,'2024-12-27 14:44:07',381048,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629450,2,23551,0,0,1,1,0,1,'2024-12-27 14:44:07',383622,'2024-12-27 14:44:10',414932,26989,'','',30,0,0.00951,2.383,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629451,2,23552,0,0,1,1,0,1,'2024-12-27 14:44:10',415001,'2024-12-27 14:44:10',424875,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.117ms, lost 0%','rta=0.117ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629452,2,21397,0,0,1,5,1,1,'2024-12-27 14:44:15',446758,'2024-12-27 14:44:17',455805,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629453,2,23553,0,0,1,10,1,1,'2024-12-27 14:44:17',456079,'2024-12-27 14:44:18',455129,26989,'','',30,0,0.999,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629454,2,23552,0,0,1,1,0,1,'2024-12-27 14:44:18',457589,'2024-12-27 14:44:20',497052,26989,'','',30,0,0.0123,3.457,0,'OK - 192.168.77.8: rta 0.317ms, lost 0%','rta=0.317ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629455,2,23549,0,0,1,10,0,1,'2024-12-27 14:44:18',460496,'2024-12-27 14:44:20',497266,26989,'','',30,0,0.01591,3.46,0,'OK - 84.38.95.222: rta 0.459ms, lost 0%','rta=0.459ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629456,2,23554,0,0,1,1,0,1,'2024-12-27 14:44:20',497335,'2024-12-27 14:44:20',507894,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629457,2,28279,0,0,1,1,0,1,'2024-12-27 14:44:21',511656,'2024-12-27 14:44:25',544288,26989,'','',30,0,0.00629,0.511,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629458,2,28533,0,0,1,1,1,1,'2024-12-27 14:44:25',544611,'2024-12-27 14:44:27',554787,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629459,2,23548,0,0,1,5,1,1,'2024-12-27 14:44:21',514710,'2024-12-27 14:44:27',555303,26989,'','',30,0,2.00766,0.514,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629460,2,21397,0,0,1,5,1,1,'2024-12-27 14:44:21',517803,'2024-12-27 14:44:27',555539,26989,'','',30,0,2.00753,0.517,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629461,2,23551,0,0,1,1,0,1,'2024-12-27 14:44:30',593536,'2024-12-27 14:44:30',604190,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629462,2,23554,0,0,1,1,0,1,'2024-12-27 14:44:30',611095,'2024-12-27 14:44:35',647085,26989,'','',30,0,0.0097,0.611,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629463,2,28533,0,0,1,1,1,1,'2024-12-27 14:44:30',606728,'2024-12-27 14:44:35',647611,26989,'','',30,0,2.00735,0.606,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629464,2,21395,0,0,1,5,1,1,'2024-12-27 14:44:30',609086,'2024-12-27 14:44:35',647837,26989,'','',30,0,2.00847,0.609,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629465,2,23552,0,0,1,1,0,1,'2024-12-27 14:44:35',647896,'2024-12-27 14:44:35',657735,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.115ms, lost 0%','rta=0.115ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629466,2,21397,0,0,1,5,1,1,'2024-12-27 14:44:45',704179,'2024-12-27 14:44:47',712477,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629467,2,23553,0,0,1,10,1,1,'2024-12-27 14:44:47',712783,'2024-12-27 14:44:48',711721,26989,'','',30,0,0.999,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629468,2,23554,0,0,1,1,0,1,'2024-12-27 14:44:48',712292,'2024-12-27 14:44:48',722191,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629469,2,23553,0,0,1,10,1,1,'2024-12-27 14:44:48',724713,'2024-12-27 14:44:55',779431,26989,'','',30,0,2.00726,3.724,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629470,2,21396,0,0,1,5,0,1,'2024-12-27 14:44:50',750915,'2024-12-27 14:44:55',779670,26989,'','',30,0,0.02257,0.75,0,'OK - 192.168.77.159: rta 0.766ms, lost 0%','rta=0.766ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629471,2,28533,0,0,1,1,1,1,'2024-12-27 14:44:55',779743,'2024-12-27 14:44:56',842268,26989,'','',30,0,1.062,0,1,'CRITICAL - 172.50.1.3: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629472,2,23551,0,0,1,1,0,1,'2024-12-27 14:45:00',876456,'2024-12-27 14:45:00',886664,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629473,2,23552,0,0,1,1,0,1,'2024-12-27 14:45:05',911322,'2024-12-27 14:45:05',921018,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.129ms, lost 0%','rta=0.129ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629474,2,23553,0,0,1,10,1,1,'2024-12-27 14:45:05',921613,'2024-12-27 14:45:07',929971,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629475,2,23554,0,0,1,1,0,1,'2024-12-27 14:45:10',955595,'2024-12-27 14:45:10',967355,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629476,2,23548,0,0,1,5,1,1,'2024-12-27 14:45:10',967673,'2024-12-27 14:45:12',976051,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629477,2,23551,0,0,1,1,0,1,'2024-12-27 14:45:12',978516,'2024-12-27 14:45:15',998879,26989,'','',30,0,0.00932,2.978,0,'OK - 192.168.77.29: rta 0.159ms, lost 0%','rta=0.159ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629478,2,23552,0,0,1,1,0,1,'2024-12-27 14:45:20',19,'2024-12-27 14:45:25',17744,26989,'','',30,0,0.01068,0.023,0,'OK - 192.168.77.8: rta 0.171ms, lost 0%','rta=0.171ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629479,2,23549,0,0,1,10,0,1,'2024-12-27 14:45:20',12160,'2024-12-27 14:45:25',17911,26989,'','',30,0,0.01093,0.027,0,'OK - 84.38.95.222: rta 0.227ms, lost 0%','rta=0.227ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629480,2,21395,0,0,1,5,1,1,'2024-12-27 14:45:25',34,'2024-12-27 14:45:27',41,26989,'','',30,0,2.008,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629481,2,28533,0,0,1,1,1,1,'2024-12-27 14:45:30',0,'2024-12-27 14:45:32',0,26989,'','',30,0,2.01,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629482,2,28279,0,0,1,1,0,1,'2024-12-27 14:45:27',44,'2024-12-27 14:45:32',0,26989,'','',30,0,0.00636,2.054,0,'OK - 192.168.77.9: rta 0.014ms, lost 0%','rta=0.014ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629483,2,23548,0,0,1,5,1,1,'2024-12-27 14:45:32',0,'2024-12-27 14:45:34',103655,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629484,2,23548,0,0,1,5,1,1,'2024-12-27 14:45:27',29596,'2024-12-27 14:45:34',104154,26989,'','',30,0,2.00831,0.071,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629485,2,21397,0,0,1,5,1,1,'2024-12-27 14:45:27',60,'2024-12-27 14:45:34',104399,26989,'','',30,0,2.00848,0.074,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629486,2,23554,0,0,1,1,0,1,'2024-12-27 14:45:35',110944,'2024-12-27 14:45:40',141983,26989,'','',30,0,0.00982,0.11,0,'OK - 192.168.77.208: rta 0.184ms, lost 0%','rta=0.184ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629487,2,28533,0,0,1,1,1,1,'2024-12-27 14:45:35',114150,'2024-12-27 14:45:40',142235,26989,'','',30,0,2.00796,0.114,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629488,2,21395,0,0,1,5,1,1,'2024-12-27 14:45:35',117346,'2024-12-27 14:45:40',142474,26989,'','',30,0,2.00779,0.117,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629489,2,23553,0,0,1,10,1,1,'2024-12-27 14:45:40',142549,'2024-12-27 14:45:40',241762,26989,'','',30,0,0.098,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629490,2,23551,0,0,1,1,0,1,'2024-12-27 14:45:40',242089,'2024-12-27 14:45:40',251965,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629491,2,23552,0,0,1,1,0,1,'2024-12-27 14:45:50',303105,'2024-12-27 14:45:50',313201,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.122ms, lost 0%','rta=0.122ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629492,2,21396,0,0,1,5,0,1,'2024-12-27 14:45:55',333869,'2024-12-27 14:46:00',345252,26989,'','',30,0,0.02845,0.333,0,'OK - 192.168.77.159: rta 1.046ms, lost 0%','rta=1.046ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629493,2,23553,0,0,1,10,1,1,'2024-12-27 14:45:55',332010,'2024-12-27 14:46:00',345792,26989,'','',30,0,2.01003,0.331,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629494,2,23554,0,0,1,1,0,1,'2024-12-27 14:46:00',345845,'2024-12-27 14:46:00',357093,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629495,2,23551,0,0,1,1,0,1,'2024-12-27 14:46:05',379979,'2024-12-27 14:46:05',391261,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629496,2,28533,0,0,1,1,1,1,'2024-12-27 14:46:05',391602,'2024-12-27 14:46:07',400816,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629497,2,28279,0,0,1,1,0,1,'2024-12-27 14:46:10',428329,'2024-12-27 14:46:10',436049,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629498,2,23552,0,0,1,1,0,1,'2024-12-27 14:46:15',476920,'2024-12-27 14:46:15',486962,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.119ms, lost 0%','rta=0.119ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629499,2,23551,0,0,1,1,0,1,'2024-12-27 14:46:15',489351,'2024-12-27 14:46:20',526244,26989,'','',30,0,0.00915,0.489,0,'OK - 192.168.77.29: rta 0.148ms, lost 0%','rta=0.148ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629500,2,21396,0,0,1,5,0,1,'2024-12-27 14:46:20',526316,'2024-12-27 14:46:20',550043,26989,'','',30,0,0.023,0,0,'OK - 192.168.77.159: rta 0.797ms, lost 0%','rta=0.797ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629501,2,23553,0,0,1,10,1,1,'2024-12-27 14:46:20',550373,'2024-12-27 14:46:22',558566,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629502,2,23554,0,0,1,1,0,1,'2024-12-27 14:46:25',578356,'2024-12-27 14:46:25',588556,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629503,2,23552,0,0,1,1,0,1,'2024-12-27 14:46:25',591051,'2024-12-27 14:46:30',617158,26989,'','',30,0,0.00976,0.591,0,'OK - 192.168.77.8: rta 0.192ms, lost 0%','rta=0.192ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629504,2,23549,0,0,1,10,0,1,'2024-12-27 14:46:25',594011,'2024-12-27 14:46:30',617391,26989,'','',30,0,0.01371,0.593,0,'OK - 84.38.95.222: rta 0.364ms, lost 0%','rta=0.364ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629505,2,28279,0,0,1,1,0,1,'2024-12-27 14:46:32',626689,'2024-12-27 14:46:35',639268,26989,'','',30,0,0.00743,0.626,0,'OK - 192.168.77.9: rta 0.014ms, lost 0%','rta=0.014ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629506,2,21397,0,0,1,5,1,1,'2024-12-27 14:46:34',636229,'2024-12-27 14:46:40',675741,26989,'','',30,0,2.00731,0.636,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629507,2,23548,0,0,1,5,1,1,'2024-12-27 14:46:34',635106,'2024-12-27 14:46:40',675987,26989,'','',30,0,2.00918,0.635,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629508,2,23554,0,0,1,1,0,1,'2024-12-27 14:46:40',678210,'2024-12-27 14:46:45',717495,26989,'','',30,0,0.01178,0.678,0,'OK - 192.168.77.208: rta 0.246ms, lost 0%','rta=0.246ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629509,2,28533,0,0,1,1,1,1,'2024-12-27 14:46:40',681681,'2024-12-27 14:46:45',717777,26989,'','',30,0,2.00814,0.681,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629510,2,21395,0,0,1,5,1,1,'2024-12-27 14:46:40',684612,'2024-12-27 14:46:45',718011,26989,'','',30,0,2.00775,0.684,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629511,2,23552,0,0,1,1,0,1,'2024-12-27 14:46:45',718068,'2024-12-27 14:46:45',728066,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.119ms, lost 0%','rta=0.119ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629512,2,23553,0,0,1,10,1,1,'2024-12-27 14:46:45',728396,'2024-12-27 14:46:47',736690,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629513,2,23549,0,0,1,10,0,1,'2024-12-27 14:46:50',767003,'2024-12-27 14:46:50',779159,26989,'','',30,0,0.011,0,0,'OK - 84.38.95.222: rta 0.217ms, lost 0%','rta=0.217ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629514,2,23551,0,0,1,1,0,1,'2024-12-27 14:46:55',809234,'2024-12-27 14:46:55',819723,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629515,2,23554,0,0,1,1,0,1,'2024-12-27 14:47:00',850939,'2024-12-27 14:47:00',861403,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629516,2,21396,0,0,1,5,0,1,'2024-12-27 14:47:00',864310,'2024-12-27 14:47:05',899378,26989,'','',30,0,0.02393,0.864,0,'OK - 192.168.77.159: rta 0.901ms, lost 0%','rta=0.901ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629517,2,23553,0,0,1,10,1,1,'2024-12-27 14:47:00',867356,'2024-12-27 14:47:05',899638,26989,'','',30,0,2.00774,0.867,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629518,2,28533,0,0,1,1,1,1,'2024-12-27 14:47:05',900002,'2024-12-27 14:47:07',910025,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629519,2,23552,0,0,1,1,0,1,'2024-12-27 14:47:10',932461,'2024-12-27 14:47:10',943006,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.112ms, lost 0%','rta=0.112ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629520,2,21397,0,0,1,5,1,1,'2024-12-27 14:47:15',975545,'2024-12-27 14:47:17',984092,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629521,2,23553,0,0,1,10,1,1,'2024-12-27 14:47:17',984370,'2024-12-27 14:47:18',984436,26989,'','',30,0,1,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629522,2,23554,0,0,1,1,0,1,'2024-12-27 14:47:21',6549,'2024-12-27 14:47:21',20,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629523,2,23549,0,0,1,10,0,1,'2024-12-27 14:47:21',10908,'2024-12-27 14:47:21',16206,26989,'','',30,0,0.012,0,0,'OK - 84.38.95.222: rta 0.278ms, lost 0%','rta=0.278ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629524,2,23551,0,0,1,1,0,1,'2024-12-27 14:47:21',3,'2024-12-27 14:47:25',24236,26989,'','',30,0,0.00877,1.039,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629525,2,28533,0,0,1,1,1,1,'2024-12-27 14:47:25',381,'2024-12-27 14:47:27',27410,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629526,2,23552,0,0,1,1,0,1,'2024-12-27 14:47:30',0,'2024-12-27 14:47:35',112947,26989,'','',30,0,0.00988,0.085,0,'OK - 192.168.77.8: rta 0.118ms, lost 0%','rta=0.118ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629527,2,23549,0,0,1,10,0,1,'2024-12-27 14:47:30',0,'2024-12-27 14:47:35',113182,26989,'','',30,0,0.0128,0.088,0,'OK - 84.38.95.222: rta 0.263ms, lost 0%','rta=0.263ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629528,2,28279,0,0,1,1,0,1,'2024-12-27 14:47:35',113250,'2024-12-27 14:47:35',121145,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629529,2,28279,0,0,1,1,0,1,'2024-12-27 14:47:35',123803,'2024-12-27 14:47:40',138255,26989,'','',30,0,0.00615,0.123,0,'OK - 192.168.77.9: rta 0.014ms, lost 0%','rta=0.014ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629530,2,23551,0,0,1,1,0,1,'2024-12-27 14:47:40',138328,'2024-12-27 14:47:40',149022,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629531,2,21397,0,0,1,5,1,1,'2024-12-27 14:47:45',192441,'2024-12-27 14:47:47',202002,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629532,2,21397,0,0,1,5,1,1,'2024-12-27 14:47:40',154671,'2024-12-27 14:47:47',212776,26989,'','',30,0,0.05968,0.154,2,'CRITICAL - 172.20.3.10: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629533,2,23548,0,0,1,5,1,1,'2024-12-27 14:47:40',157799,'2024-12-27 14:47:47',213007,26989,'','',30,0,0.05696,0.157,2,'CRITICAL - 172.20.3.11: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629534,2,23553,0,0,1,10,1,1,'2024-12-27 14:47:47',213057,'2024-12-27 14:47:48',201131,26989,'','',30,0,0.988,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629535,2,23554,0,0,1,1,0,1,'2024-12-27 14:47:48',201701,'2024-12-27 14:47:48',211810,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629536,2,23554,0,0,1,1,0,1,'2024-12-27 14:47:48',214306,'2024-12-27 14:47:50',238473,26989,'','',30,0,0.00913,3.214,0,'OK - 192.168.77.208: rta 0.154ms, lost 0%','rta=0.154ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629537,2,28533,0,0,1,1,1,1,'2024-12-27 14:47:48',217394,'2024-12-27 14:47:50',238711,26989,'','',30,0,2.00701,3.217,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629538,2,21395,0,0,1,5,1,1,'2024-12-27 14:47:48',220647,'2024-12-27 14:47:50',238966,26989,'','',30,0,2.00844,3.22,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629539,2,23551,0,0,1,1,0,1,'2024-12-27 14:48:00',274566,'2024-12-27 14:48:00',285279,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629540,2,23552,0,0,1,1,0,1,'2024-12-27 14:48:05',298581,'2024-12-27 14:48:05',308294,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.120ms, lost 0%','rta=0.120ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629541,2,23553,0,0,1,10,1,1,'2024-12-27 14:48:05',308570,'2024-12-27 14:48:07',316261,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629542,2,21396,0,0,1,5,0,1,'2024-12-27 14:48:07',318926,'2024-12-27 14:48:10',337957,26989,'','',30,0,0.02138,2.318,0,'OK - 192.168.77.159: rta 0.773ms, lost 0%','rta=0.773ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629543,2,23553,0,0,1,10,1,1,'2024-12-27 14:48:07',321868,'2024-12-27 14:48:10',338232,26989,'','',30,0,0.99372,2.321,2,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629544,2,23554,0,0,1,1,0,1,'2024-12-27 14:48:10',338289,'2024-12-27 14:48:10',348751,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.154ms, lost 0%','rta=0.154ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629545,2,23548,0,0,1,5,1,1,'2024-12-27 14:48:10',349069,'2024-12-27 14:48:12',357621,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629546,2,21395,0,0,1,5,1,1,'2024-12-27 14:48:25',431618,'2024-12-27 14:48:27',439995,26989,'','',30,0,2.007,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629547,2,23552,0,0,1,1,0,1,'2024-12-27 14:48:27',440359,'2024-12-27 14:48:27',450121,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.127ms, lost 0%','rta=0.127ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629548,2,23551,0,0,1,1,0,1,'2024-12-27 14:48:27',450429,'2024-12-27 14:48:27',460321,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629549,2,28533,0,0,1,1,1,1,'2024-12-27 14:48:30',497044,'2024-12-27 14:48:32',506817,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629550,2,23551,0,0,1,1,0,1,'2024-12-27 14:48:27',462910,'2024-12-27 14:48:32',507330,26989,'','',30,0,0.00895,2.462,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629551,2,23548,0,0,1,5,1,1,'2024-12-27 14:48:32',507637,'2024-12-27 14:48:34',517135,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629552,2,23552,0,0,1,1,0,1,'2024-12-27 14:48:35',544755,'2024-12-27 14:48:40',585647,26989,'','',30,0,0.00921,0.544,0,'OK - 192.168.77.8: rta 0.140ms, lost 0%','rta=0.140ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629553,2,23549,0,0,1,10,0,1,'2024-12-27 14:48:35',547544,'2024-12-27 14:48:40',585875,26989,'','',30,0,0.01483,0.547,0,'OK - 84.38.95.222: rta 0.422ms, lost 0%','rta=0.422ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629554,2,23553,0,0,1,10,1,1,'2024-12-27 14:48:40',585934,'2024-12-27 14:48:40',675745,26989,'','',30,0,0.089,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629555,2,28279,0,0,1,1,0,1,'2024-12-27 14:48:40',678733,'2024-12-27 14:48:45',695514,26989,'','',30,0,0.00604,0.678,0,'OK - 192.168.77.9: rta 0.014ms, lost 0%','rta=0.014ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629556,2,23554,0,0,1,1,0,1,'2024-12-27 14:48:50',757943,'2024-12-27 14:48:50',769627,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.208: rta 0.162ms, lost 0%','rta=0.162ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629557,2,21397,0,0,1,5,1,1,'2024-12-27 14:48:47',702259,'2024-12-27 14:48:50',771086,26989,'','',30,0,2.00949,0.702,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629558,2,23548,0,0,1,5,1,1,'2024-12-27 14:48:47',705391,'2024-12-27 14:48:50',771308,26989,'','',30,0,2.00872,0.705,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629559,2,21395,0,0,1,5,1,1,'2024-12-27 14:48:50',771364,'2024-12-27 14:48:51',722846,26989,'','',30,0,0.952,0,1,'CRITICAL - 192.168.77.154: Host unreachable @ 192.168.77.9. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629560,2,23554,0,0,1,1,0,1,'2024-12-27 14:48:51',725349,'2024-12-27 14:48:55',754425,26989,'','',30,0,0.00921,1.725,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629561,2,28533,0,0,1,1,1,1,'2024-12-27 14:48:51',728410,'2024-12-27 14:48:55',754658,26989,'','',30,0,2.00738,1.728,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629562,2,21395,0,0,1,5,1,1,'2024-12-27 14:48:51',731594,'2024-12-27 14:48:55',754902,26989,'','',30,0,2.00751,1.731,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629563,2,23552,0,0,1,1,0,1,'2024-12-27 14:49:00',785874,'2024-12-27 14:49:00',796247,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.116ms, lost 0%','rta=0.116ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629564,2,23551,0,0,1,1,0,1,'2024-12-27 14:49:05',825995,'2024-12-27 14:49:05',836933,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629565,2,28279,0,0,1,1,0,1,'2024-12-27 14:49:10',879173,'2024-12-27 14:49:10',887982,26989,'','',30,0,0.008,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629566,2,21396,0,0,1,5,0,1,'2024-12-27 14:49:10',890522,'2024-12-27 14:49:15',917596,26989,'','',30,0,0.02879,0.89,0,'OK - 192.168.77.159: rta 1.139ms, lost 0%','rta=1.139ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629567,2,23553,0,0,1,10,1,1,'2024-12-27 14:49:10',893624,'2024-12-27 14:49:15',917839,26989,'','',30,0,2.00823,0.893,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629568,2,23554,0,0,1,1,0,1,'2024-12-27 14:49:25',984111,'2024-12-27 14:49:25',995430,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629569,2,23551,0,0,1,1,0,1,'2024-12-27 14:49:32',5685,'2024-12-27 14:49:35',21,26989,'','',30,0,0.01043,0.013,0,'OK - 192.168.77.29: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629570,2,23552,0,0,1,1,0,1,'2024-12-27 14:49:40',33,'2024-12-27 14:49:45',24377,26989,'','',30,0,0.01036,0.041,0,'OK - 192.168.77.8: rta 0.143ms, lost 0%','rta=0.143ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629571,2,23549,0,0,1,10,0,1,'2024-12-27 14:49:40',2236,'2024-12-27 14:49:45',24518,26989,'','',30,0,0.01383,0.042,0,'OK - 84.38.95.222: rta 0.230ms, lost 0%','rta=0.230ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629572,2,23553,0,0,1,10,1,1,'2024-12-27 14:49:45',5,'2024-12-27 14:49:47',28459,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629573,2,28279,0,0,1,1,0,1,'2024-12-27 14:49:47',448,'2024-12-27 14:49:50',0,26989,'','',30,0,0.00608,2.07,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629574,2,23554,0,0,1,1,0,1,'2024-12-27 14:49:55',114881,'2024-12-27 14:49:55',125323,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629575,2,21397,0,0,1,5,1,1,'2024-12-27 14:49:50',0,'2024-12-27 14:49:55',125873,26989,'','',30,0,2.00814,0.092,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629576,2,23548,0,0,1,5,1,1,'2024-12-27 14:49:50',0,'2024-12-27 14:49:55',126139,26989,'','',30,0,2.00842,0.095,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629577,2,23551,0,0,1,1,0,1,'2024-12-27 14:49:55',126208,'2024-12-27 14:49:55',136030,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629578,2,23554,0,0,1,1,0,1,'2024-12-27 14:49:55',138570,'2024-12-27 14:50:00',161635,26989,'','',30,0,0.01261,0.138,0,'OK - 192.168.77.208: rta 0.294ms, lost 0%','rta=0.294ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629579,2,28533,0,0,1,1,1,1,'2024-12-27 14:49:55',141590,'2024-12-27 14:50:00',161892,26989,'','',30,0,2.00739,0.141,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629580,2,21395,0,0,1,5,1,1,'2024-12-27 14:49:55',144586,'2024-12-27 14:50:00',162129,26989,'','',30,0,2.00949,0.144,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629581,2,23552,0,0,1,1,0,1,'2024-12-27 14:50:10',194877,'2024-12-27 14:50:10',204975,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.120ms, lost 0%','rta=0.120ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629582,2,21397,0,0,1,5,1,1,'2024-12-27 14:50:15',233096,'2024-12-27 14:50:17',242684,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629583,2,23553,0,0,1,10,1,1,'2024-12-27 14:50:17',243016,'2024-12-27 14:50:18',240857,26989,'','',30,0,0.998,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629584,2,21396,0,0,1,5,0,1,'2024-12-27 14:50:18',243449,'2024-12-27 14:50:20',282559,26989,'','',30,0,0.02183,3.243,0,'OK - 192.168.77.159: rta 0.790ms, lost 0%','rta=0.790ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629585,2,23554,0,0,1,1,0,1,'2024-12-27 14:50:20',282635,'2024-12-27 14:50:20',293835,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629586,2,23549,0,0,1,10,0,1,'2024-12-27 14:50:20',294193,'2024-12-27 14:50:20',306446,26989,'','',30,0,0.012,0,0,'OK - 84.38.95.222: rta 0.271ms, lost 0%','rta=0.271ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629587,2,23553,0,0,1,10,1,1,'2024-12-27 14:50:18',246584,'2024-12-27 14:50:25',333155,26989,'','',30,0,2.00759,3.246,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629588,2,28533,0,0,1,1,1,1,'2024-12-27 14:50:25',333502,'2024-12-27 14:50:27',343431,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629589,2,23551,0,0,1,1,0,1,'2024-12-27 14:50:30',382407,'2024-12-27 14:50:30',393239,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629590,2,28279,0,0,1,1,0,1,'2024-12-27 14:50:35',420910,'2024-12-27 14:50:35',428560,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629591,2,23552,0,0,1,1,0,1,'2024-12-27 14:50:35',428910,'2024-12-27 14:50:35',438366,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.134ms, lost 0%','rta=0.134ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629592,2,23551,0,0,1,1,0,1,'2024-12-27 14:50:35',440889,'2024-12-27 14:50:40',468159,26989,'','',30,0,0.00888,0.44,0,'OK - 192.168.77.29: rta 0.148ms, lost 0%','rta=0.148ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629593,2,21397,0,0,1,5,1,1,'2024-12-27 14:50:45',499553,'2024-12-27 14:50:47',507777,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629594,2,23553,0,0,1,10,1,1,'2024-12-27 14:50:47',508085,'2024-12-27 14:50:48',508063,26989,'','',30,0,1,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629595,2,23554,0,0,1,1,0,1,'2024-12-27 14:50:48',508613,'2024-12-27 14:50:48',518591,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629596,2,23552,0,0,1,1,0,1,'2024-12-27 14:50:48',521063,'2024-12-27 14:50:50',559528,26989,'','',30,0,0.01206,3.521,0,'OK - 192.168.77.8: rta 0.142ms, lost 0%','rta=0.142ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629597,2,23549,0,0,1,10,0,1,'2024-12-27 14:50:48',524149,'2024-12-27 14:50:50',559790,26989,'','',30,0,0.01074,3.524,0,'OK - 84.38.95.222: rta 0.216ms, lost 0%','rta=0.216ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629598,2,28279,0,0,1,1,0,1,'2024-12-27 14:50:50',562156,'2024-12-27 14:50:55',592086,26989,'','',30,0,0.00768,0.562,0,'OK - 192.168.77.9: rta 0.016ms, lost 0%','rta=0.016ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629599,2,28533,0,0,1,1,1,1,'2024-12-27 14:50:55',592145,'2024-12-27 14:50:56',638154,26989,'','',30,0,1.045,0,1,'CRITICAL - 172.50.1.3: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629600,2,21397,0,0,1,5,1,1,'2024-12-27 14:50:56',640570,'2024-12-27 14:51:00',659300,26989,'','',30,0,2.00831,1.64,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629601,2,23551,0,0,1,1,0,1,'2024-12-27 14:51:00',659374,'2024-12-27 14:51:00',669588,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629602,2,23548,0,0,1,5,1,1,'2024-12-27 14:50:56',643729,'2024-12-27 14:51:00',670093,26989,'','',30,0,2.00754,1.643,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629603,2,23554,0,0,1,1,0,1,'2024-12-27 14:51:00',672556,'2024-12-27 14:51:05',707001,26989,'','',30,0,0.01042,0.672,0,'OK - 192.168.77.208: rta 0.154ms, lost 0%','rta=0.154ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629604,2,28533,0,0,1,1,1,1,'2024-12-27 14:51:00',676019,'2024-12-27 14:51:05',707246,26989,'','',30,0,2.00791,0.675,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629605,2,21395,0,0,1,5,1,1,'2024-12-27 14:51:00',679282,'2024-12-27 14:51:05',707482,26989,'','',30,0,2.00866,0.679,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629606,2,23552,0,0,1,1,0,1,'2024-12-27 14:51:05',707555,'2024-12-27 14:51:05',718514,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.128ms, lost 0%','rta=0.128ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629607,2,23553,0,0,1,10,1,1,'2024-12-27 14:51:05',719196,'2024-12-27 14:51:07',729174,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629608,2,21396,0,0,1,5,0,1,'2024-12-27 14:51:20',821195,'2024-12-27 14:51:25',855821,26989,'','',30,0,0.03927,0.821,0,'OK - 192.168.77.159: rta 1.640ms, lost 0%','rta=1.640ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629609,2,21395,0,0,1,5,1,1,'2024-12-27 14:51:25',855891,'2024-12-27 14:51:27',865526,26989,'','',30,0,2.009,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629610,2,23552,0,0,1,1,0,1,'2024-12-27 14:51:27',865891,'2024-12-27 14:51:27',875646,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.119ms, lost 0%','rta=0.119ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629611,2,23551,0,0,1,1,0,1,'2024-12-27 14:51:27',876009,'2024-12-27 14:51:27',886004,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629612,2,28533,0,0,1,1,1,1,'2024-12-27 14:51:30',926632,'2024-12-27 14:51:32',936754,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629613,2,23553,0,0,1,10,1,1,'2024-12-27 14:51:27',888677,'2024-12-27 14:51:32',937530,26989,'','',30,0,2.01081,2.888,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629614,2,23548,0,0,1,5,1,1,'2024-12-27 14:51:32',937598,'2024-12-27 14:51:34',946136,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629615,2,23551,0,0,1,1,0,1,'2024-12-27 14:51:41',0,'2024-12-27 14:51:45',9821,26989,'','',30,0,0.0105,1.009,0,'OK - 192.168.77.29: rta 0.148ms, lost 0%','rta=0.148ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629616,2,23552,0,0,1,1,0,1,'2024-12-27 14:51:50',61,'2024-12-27 14:51:50',0,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.120ms, lost 0%','rta=0.120ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629617,2,23553,0,0,1,10,1,1,'2024-12-27 14:51:50',0,'2024-12-27 14:51:51',128264,26989,'','',30,0,1.041,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629618,2,23554,0,0,1,1,0,1,'2024-12-27 14:51:51',128798,'2024-12-27 14:51:51',138640,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629619,2,21395,0,0,1,5,1,1,'2024-12-27 14:51:55',157423,'2024-12-27 14:51:57',167298,26989,'','',30,0,2.009,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629620,2,23552,0,0,1,1,0,1,'2024-12-27 14:51:51',141146,'2024-12-27 14:51:57',167783,26989,'','',30,0,0.00877,1.141,0,'OK - 192.168.77.8: rta 0.118ms, lost 0%','rta=0.118ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629621,2,23549,0,0,1,10,0,1,'2024-12-27 14:51:51',144029,'2024-12-27 14:51:57',167997,26989,'','',30,0,0.01169,1.143,0,'OK - 84.38.95.222: rta 0.231ms, lost 0%','rta=0.231ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629622,2,28279,0,0,1,1,0,1,'2024-12-27 14:51:57',170687,'2024-12-27 14:52:00',178102,26989,'','',30,0,0.00653,2.17,0,'OK - 192.168.77.9: rta 0.014ms, lost 0%','rta=0.014ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629623,2,23551,0,0,1,1,0,1,'2024-12-27 14:52:05',204728,'2024-12-27 14:52:05',215277,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629624,2,28533,0,0,1,1,1,1,'2024-12-27 14:52:05',215603,'2024-12-27 14:52:07',224634,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629625,2,21397,0,0,1,5,1,1,'2024-12-27 14:52:00',190232,'2024-12-27 14:52:07',225118,26989,'','',30,0,2.00736,0.19,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629626,2,23548,0,0,1,5,1,1,'2024-12-27 14:52:00',193035,'2024-12-27 14:52:07',225342,26989,'','',30,0,2.00755,0.193,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629627,2,23554,0,0,1,1,0,1,'2024-12-27 14:52:07',227556,'2024-12-27 14:52:10',259819,26989,'','',30,0,0.01371,2.227,0,'OK - 192.168.77.208: rta 0.387ms, lost 0%','rta=0.387ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629628,2,28533,0,0,1,1,1,1,'2024-12-27 14:52:07',230632,'2024-12-27 14:52:10',260494,26989,'','',30,0,0.99136,2.23,2,'CRITICAL - 172.50.1.3: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629629,2,21395,0,0,1,5,1,1,'2024-12-27 14:52:07',234088,'2024-12-27 14:52:10',260701,26989,'','',30,0,2.00817,2.234,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629630,2,23552,0,0,1,1,0,1,'2024-12-27 14:52:15',284812,'2024-12-27 14:52:15',295309,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.135ms, lost 0%','rta=0.135ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629631,2,21396,0,0,1,5,0,1,'2024-12-27 14:52:20',331621,'2024-12-27 14:52:20',353990,26989,'','',30,0,0.022,0,0,'OK - 192.168.77.159: rta 0.760ms, lost 0%','rta=0.760ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629632,2,23553,0,0,1,10,1,1,'2024-12-27 14:52:20',354290,'2024-12-27 14:52:22',363104,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629633,2,23554,0,0,1,1,0,1,'2024-12-27 14:52:25',383028,'2024-12-27 14:52:25',393239,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629634,2,21396,0,0,1,5,0,1,'2024-12-27 14:52:25',395550,'2024-12-27 14:52:30',431386,26989,'','',30,0,0.02515,0.395,0,'OK - 192.168.77.159: rta 0.973ms, lost 0%','rta=0.973ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629635,2,23553,0,0,1,10,1,1,'2024-12-27 14:52:32',440680,'2024-12-27 14:52:35',462848,26989,'','',30,0,2.00913,0.44,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629636,2,23552,0,0,1,1,0,1,'2024-12-27 14:52:45',524990,'2024-12-27 14:52:45',536249,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.137ms, lost 0%','rta=0.137ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629637,2,23551,0,0,1,1,0,1,'2024-12-27 14:52:45',539099,'2024-12-27 14:52:50',584135,26989,'','',30,0,0.00887,0.539,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629638,2,23549,0,0,1,10,0,1,'2024-12-27 14:52:50',584468,'2024-12-27 14:52:50',597223,26989,'','',30,0,0.012,0,0,'OK - 84.38.95.222: rta 0.264ms, lost 0%','rta=0.264ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629639,2,23554,0,0,1,1,0,1,'2024-12-27 14:52:55',611045,'2024-12-27 14:52:55',621634,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.154ms, lost 0%','rta=0.154ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629640,2,23552,0,0,1,1,0,1,'2024-12-27 14:52:57',631162,'2024-12-27 14:53:00',665263,26989,'','',30,0,0.01017,0.631,0,'OK - 192.168.77.8: rta 0.132ms, lost 0%','rta=0.132ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629641,2,23549,0,0,1,10,0,1,'2024-12-27 14:52:57',634754,'2024-12-27 14:53:00',665499,26989,'','',30,0,0.01209,0.634,0,'OK - 84.38.95.222: rta 0.236ms, lost 0%','rta=0.236ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629642,2,28279,0,0,1,1,0,1,'2024-12-27 14:53:00',668723,'2024-12-27 14:53:05',692915,26989,'','',30,0,0.00744,0.668,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629643,2,28533,0,0,1,1,1,1,'2024-12-27 14:53:05',693212,'2024-12-27 14:53:07',702140,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629644,2,21397,0,0,1,5,1,1,'2024-12-27 14:53:07',704545,'2024-12-27 14:53:10',732716,26989,'','',30,0,0.08955,0.704,2,'CRITICAL - 172.20.3.10: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629645,2,23548,0,0,1,5,1,1,'2024-12-27 14:53:07',707125,'2024-12-27 14:53:10',732997,26989,'','',30,0,0.08715,0.707,2,'CRITICAL - 172.20.3.11: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629646,2,23554,0,0,1,1,0,1,'2024-12-27 14:53:10',735338,'2024-12-27 14:53:15',769039,26989,'','',30,0,0.00973,0.735,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629647,2,28533,0,0,1,1,1,1,'2024-12-27 14:53:10',738132,'2024-12-27 14:53:15',769314,26989,'','',30,0,2.00828,0.738,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629648,2,21395,0,0,1,5,1,1,'2024-12-27 14:53:10',741660,'2024-12-27 14:53:15',769557,26989,'','',30,0,2.00795,0.741,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629649,2,23553,0,0,1,10,1,1,'2024-12-27 14:53:15',769895,'2024-12-27 14:53:17',778092,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629650,2,23549,0,0,1,10,0,1,'2024-12-27 14:53:20',813195,'2024-12-27 14:53:20',828127,26989,'','',30,0,0.014,0,0,'OK - 84.38.95.222: rta 0.364ms, lost 0%','rta=0.364ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629651,2,23551,0,0,1,1,0,1,'2024-12-27 14:53:30',885695,'2024-12-27 14:53:30',896339,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629652,2,21396,0,0,1,5,0,1,'2024-12-27 14:53:30',898885,'2024-12-27 14:53:35',932636,26989,'','',30,0,0.01999,0.898,0,'OK - 192.168.77.159: rta 0.710ms, lost 0%','rta=0.710ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629653,2,28279,0,0,1,1,0,1,'2024-12-27 14:53:35',932697,'2024-12-27 14:53:35',940569,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629654,2,23552,0,0,1,1,0,1,'2024-12-27 14:53:35',940868,'2024-12-27 14:53:35',950263,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.130ms, lost 0%','rta=0.130ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629655,2,23553,0,0,1,10,1,1,'2024-12-27 14:53:35',952667,'2024-12-27 14:53:40',979001,26989,'','',30,0,0.06392,0.952,2,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629656,2,21397,0,0,1,5,1,1,'2024-12-27 14:53:46',0,'2024-12-27 14:53:48',1,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629657,2,23554,0,0,1,1,0,1,'2024-12-27 14:53:48',1,'2024-12-27 14:53:48',2,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629658,2,23551,0,0,1,1,0,1,'2024-12-27 14:53:50',108341,'2024-12-27 14:53:55',125032,26989,'','',30,0,0.01003,0.108,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629659,2,28533,0,0,1,1,1,1,'2024-12-27 14:53:55',125119,'2024-12-27 14:53:56',207684,26989,'','',30,0,1.082,0,1,'CRITICAL - 172.50.1.3: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629660,2,23552,0,0,1,1,0,1,'2024-12-27 14:54:00',251102,'2024-12-27 14:54:05',269366,26989,'','',30,0,0.00992,0.251,0,'OK - 192.168.77.8: rta 0.146ms, lost 0%','rta=0.146ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629661,2,23549,0,0,1,10,0,1,'2024-12-27 14:54:00',254456,'2024-12-27 14:54:05',269580,26989,'','',30,0,0.01339,0.254,0,'OK - 84.38.95.222: rta 0.343ms, lost 0%','rta=0.343ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629662,2,23553,0,0,1,10,1,1,'2024-12-27 14:54:05',270130,'2024-12-27 14:54:07',279090,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629663,2,28279,0,0,1,1,0,1,'2024-12-27 14:54:07',292388,'2024-12-27 14:54:10',306317,26989,'','',30,0,0.00607,2.292,0,'OK - 192.168.77.9: rta 0.014ms, lost 0%','rta=0.014ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629664,2,23554,0,0,1,1,0,1,'2024-12-27 14:54:10',306381,'2024-12-27 14:54:10',317910,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629665,2,23548,0,0,1,5,1,1,'2024-12-27 14:54:10',318256,'2024-12-27 14:54:12',349574,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629666,2,23548,0,0,1,5,1,1,'2024-12-27 14:54:12',352776,'2024-12-27 14:54:15',363313,26989,'','',30,0,0.97354,2.352,2,'CRITICAL - 172.20.3.11: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629667,2,21397,0,0,1,5,1,1,'2024-12-27 14:54:12',352095,'2024-12-27 14:54:15',363529,26989,'','',30,0,0.97436,2.352,2,'CRITICAL - 172.20.3.10: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629668,2,23554,0,0,1,1,0,1,'2024-12-27 14:54:15',365738,'2024-12-27 14:54:20',385462,26989,'','',30,0,0.00963,0.365,0,'OK - 192.168.77.208: rta 0.154ms, lost 0%','rta=0.154ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629669,2,28533,0,0,1,1,1,1,'2024-12-27 14:54:15',368785,'2024-12-27 14:54:20',385717,26989,'','',30,0,2.00836,0.368,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629670,2,21395,0,0,1,5,1,1,'2024-12-27 14:54:15',369575,'2024-12-27 14:54:20',385952,26989,'','',30,0,2.0093,0.369,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629671,2,23552,0,0,1,1,0,1,'2024-12-27 14:54:25',404599,'2024-12-27 14:54:25',415110,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.120ms, lost 0%','rta=0.120ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629672,2,23551,0,0,1,1,0,1,'2024-12-27 14:54:25',415418,'2024-12-27 14:54:25',425263,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.146ms, lost 0%','rta=0.146ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629673,2,23548,0,0,1,5,1,1,'2024-12-27 14:54:30',449539,'2024-12-27 14:54:32',458791,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629674,2,28533,0,0,1,1,1,1,'2024-12-27 14:54:35',467255,'2024-12-27 14:54:37',477344,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629675,2,21396,0,0,1,5,0,1,'2024-12-27 14:54:37',479867,'2024-12-27 14:54:40',524241,26989,'','',30,0,0.03252,2.479,0,'OK - 192.168.77.159: rta 1.316ms, lost 0%','rta=1.316ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629676,2,23553,0,0,1,10,1,1,'2024-12-27 14:54:40',524313,'2024-12-27 14:54:40',604107,26989,'','',30,0,0.079,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629677,2,23553,0,0,1,10,1,1,'2024-12-27 14:54:40',607212,'2024-12-27 14:54:45',622258,26989,'','',30,0,2.00721,0.607,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629678,2,23552,0,0,1,1,0,1,'2024-12-27 14:54:50',680670,'2024-12-27 14:54:50',692030,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.8: rta 0.164ms, lost 0%','rta=0.164ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629679,2,23554,0,0,1,1,0,1,'2024-12-27 14:54:50',692865,'2024-12-27 14:54:50',702806,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629680,2,21395,0,0,1,5,1,1,'2024-12-27 14:54:50',703378,'2024-12-27 14:54:51',643763,26989,'','',30,0,0.941,0,1,'CRITICAL - 192.168.77.154: Host unreachable @ 192.168.77.9. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629681,2,23551,0,0,1,1,0,1,'2024-12-27 14:54:55',678271,'2024-12-27 14:55:00',712253,26989,'','',30,0,0.01001,0.678,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629682,2,28533,0,0,1,1,1,1,'2024-12-27 14:55:05',750252,'2024-12-27 14:55:07',758783,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629683,2,23552,0,0,1,1,0,1,'2024-12-27 14:55:07',761330,'2024-12-27 14:55:10',794050,26989,'','',30,0,0.00854,2.761,0,'OK - 192.168.77.8: rta 0.127ms, lost 0%','rta=0.127ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629684,2,23549,0,0,1,10,0,1,'2024-12-27 14:55:07',764425,'2024-12-27 14:55:10',794268,26989,'','',30,0,0.01078,2.764,0,'OK - 84.38.95.222: rta 0.222ms, lost 0%','rta=0.222ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629685,2,28279,0,0,1,1,0,1,'2024-12-27 14:55:10',794585,'2024-12-27 14:55:10',802370,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629686,2,28279,0,0,1,1,0,1,'2024-12-27 14:55:10',804827,'2024-12-27 14:55:15',835677,26989,'','',30,0,0.00603,0.804,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629687,2,23551,0,0,1,1,0,1,'2024-12-27 14:55:15',835745,'2024-12-27 14:55:15',847131,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629688,2,21396,0,0,1,5,0,1,'2024-12-27 14:55:20',885559,'2024-12-27 14:55:20',908927,26989,'','',30,0,0.023,0,0,'OK - 192.168.77.159: rta 0.802ms, lost 0%','rta=0.802ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629689,2,23548,0,0,1,5,1,1,'2024-12-27 14:55:15',850100,'2024-12-27 14:55:20',909464,26989,'','',30,0,2.00936,0.85,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629690,2,21397,0,0,1,5,1,1,'2024-12-27 14:55:15',853430,'2024-12-27 14:55:20',909711,26989,'','',30,0,2.00766,0.853,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629691,2,23553,0,0,1,10,1,1,'2024-12-27 14:55:20',909774,'2024-12-27 14:55:22',918569,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629692,2,23554,0,0,1,1,0,1,'2024-12-27 14:55:25',946801,'2024-12-27 14:55:25',957736,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629693,2,23554,0,0,1,1,0,1,'2024-12-27 14:55:22',921412,'2024-12-27 14:55:25',958221,26989,'','',30,0,0.00899,2.921,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629694,2,28533,0,0,1,1,1,1,'2024-12-27 14:55:22',924528,'2024-12-27 14:55:25',958460,26989,'','',30,0,2.00838,2.924,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629695,2,21395,0,0,1,5,1,1,'2024-12-27 14:55:22',927755,'2024-12-27 14:55:25',958684,26989,'','',30,0,2.00929,2.927,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629696,2,21396,0,0,1,5,0,1,'2024-12-27 14:55:40',19,'2024-12-27 14:55:45',3,26989,'','',30,0,0.02213,0.023,0,'OK - 192.168.77.159: rta 0.751ms, lost 0%','rta=0.751ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629697,2,23552,0,0,1,1,0,1,'2024-12-27 14:55:45',3,'2024-12-27 14:55:45',4,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.115ms, lost 0%','rta=0.115ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629698,2,23553,0,0,1,10,1,1,'2024-12-27 14:55:45',4,'2024-12-27 14:55:47',3068,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629699,2,23553,0,0,1,10,1,1,'2024-12-27 14:55:47',24721,'2024-12-27 14:55:50',0,26989,'','',30,0,0.99664,2.06,2,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629700,2,23549,0,0,1,10,0,1,'2024-12-27 14:55:50',0,'2024-12-27 14:55:50',0,26989,'','',30,0,0.011,0,0,'OK - 84.38.95.222: rta 0.217ms, lost 0%','rta=0.217ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629701,2,23554,0,0,1,1,0,1,'2024-12-27 14:55:55',110600,'2024-12-27 14:55:55',121040,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629702,2,23551,0,0,1,1,0,1,'2024-12-27 14:55:55',121364,'2024-12-27 14:55:55',131073,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629703,2,23551,0,0,1,1,0,1,'2024-12-27 14:56:00',151845,'2024-12-27 14:56:05',180734,26989,'','',30,0,0.00997,0.151,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629704,2,28533,0,0,1,1,1,1,'2024-12-27 14:56:05',181057,'2024-12-27 14:56:07',190480,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629705,2,23552,0,0,1,1,0,1,'2024-12-27 14:56:10',200614,'2024-12-27 14:56:10',210776,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.123ms, lost 0%','rta=0.123ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629706,2,23552,0,0,1,1,0,1,'2024-12-27 14:56:10',213234,'2024-12-27 14:56:15',247299,26989,'','',30,0,0.00882,0.213,0,'OK - 192.168.77.8: rta 0.139ms, lost 0%','rta=0.139ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629707,2,23549,0,0,1,10,0,1,'2024-12-27 14:56:10',216301,'2024-12-27 14:56:15',247557,26989,'','',30,0,0.01284,0.216,0,'OK - 84.38.95.222: rta 0.318ms, lost 0%','rta=0.318ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629708,2,21397,0,0,1,5,1,1,'2024-12-27 14:56:15',247606,'2024-12-27 14:56:17',256102,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629709,2,23553,0,0,1,10,1,1,'2024-12-27 14:56:17',256408,'2024-12-27 14:56:18',256253,26989,'','',30,0,1,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629710,2,28279,0,0,1,1,0,1,'2024-12-27 14:56:18',258701,'2024-12-27 14:56:20',296438,26989,'','',30,0,0.00958,3.258,0,'OK - 192.168.77.9: rta 0.016ms, lost 0%','rta=0.016ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629711,2,23554,0,0,1,1,0,1,'2024-12-27 14:56:20',296504,'2024-12-27 14:56:20',307989,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629712,2,23548,0,0,1,5,1,1,'2024-12-27 14:56:20',310680,'2024-12-27 14:56:25',340054,26989,'','',30,0,2.00692,0.31,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629713,2,21397,0,0,1,5,1,1,'2024-12-27 14:56:20',313706,'2024-12-27 14:56:25',340283,26989,'','',30,0,2.00689,0.313,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629714,2,28533,0,0,1,1,1,1,'2024-12-27 14:56:25',340548,'2024-12-27 14:56:27',350350,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629715,2,23554,0,0,1,1,0,1,'2024-12-27 14:56:27',352953,'2024-12-27 14:56:30',390600,26989,'','',30,0,0.01129,2.352,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629716,2,28533,0,0,1,1,1,1,'2024-12-27 14:56:27',355967,'2024-12-27 14:56:30',391103,26989,'','',30,0,0.9924,2.355,2,'CRITICAL - 172.50.1.3: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629717,2,23551,0,0,1,1,0,1,'2024-12-27 14:56:30',391159,'2024-12-27 14:56:30',402322,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629718,2,21395,0,0,1,5,1,1,'2024-12-27 14:56:27',359498,'2024-12-27 14:56:30',402800,26989,'','',30,0,2.00863,2.359,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629719,2,28279,0,0,1,1,0,1,'2024-12-27 14:56:35',429082,'2024-12-27 14:56:35',436994,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629720,2,23552,0,0,1,1,0,1,'2024-12-27 14:56:35',437328,'2024-12-27 14:56:35',447122,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.130ms, lost 0%','rta=0.130ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629721,2,21397,0,0,1,5,1,1,'2024-12-27 14:56:45',504125,'2024-12-27 14:56:47',513323,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629722,2,23553,0,0,1,10,1,1,'2024-12-27 14:56:47',513633,'2024-12-27 14:56:48',513468,26989,'','',30,0,1,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629723,2,23554,0,0,1,1,0,1,'2024-12-27 14:56:48',514015,'2024-12-27 14:56:48',524195,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629724,2,21396,0,0,1,5,0,1,'2024-12-27 14:56:48',526719,'2024-12-27 14:56:50',561694,26989,'','',30,0,0.03127,3.526,0,'OK - 192.168.77.159: rta 1.263ms, lost 0%','rta=1.263ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629725,2,28533,0,0,1,1,1,1,'2024-12-27 14:56:55',579195,'2024-12-27 14:56:56',643546,26989,'','',30,0,1.063,0,1,'CRITICAL - 172.50.1.3: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629726,2,23553,0,0,1,10,1,1,'2024-12-27 14:56:50',564080,'2024-12-27 14:56:56',644080,26989,'','',30,0,2.00899,0.564,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629727,2,23551,0,0,1,1,0,1,'2024-12-27 14:57:00',675897,'2024-12-27 14:57:00',686253,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629728,2,23552,0,0,1,1,0,1,'2024-12-27 14:57:05',714577,'2024-12-27 14:57:05',724346,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.110ms, lost 0%','rta=0.110ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629729,2,23551,0,0,1,1,0,1,'2024-12-27 14:57:05',727274,'2024-12-27 14:57:10',755856,26989,'','',30,0,0.00902,0.727,0,'OK - 192.168.77.29: rta 0.146ms, lost 0%','rta=0.146ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629730,2,23548,0,0,1,5,1,1,'2024-12-27 14:57:10',755913,'2024-12-27 14:57:12',764449,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629731,2,23554,0,0,1,1,0,1,'2024-12-27 14:57:12',764758,'2024-12-27 14:57:12',775126,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629732,2,23552,0,0,1,1,0,1,'2024-12-27 14:57:15',797285,'2024-12-27 14:57:20',831661,26989,'','',30,0,0.01012,0.797,0,'OK - 192.168.77.8: rta 0.134ms, lost 0%','rta=0.134ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629733,2,23549,0,0,1,10,0,1,'2024-12-27 14:57:15',801263,'2024-12-27 14:57:20',831903,26989,'','',30,0,0.01093,0.801,0,'OK - 84.38.95.222: rta 0.202ms, lost 0%','rta=0.202ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629734,2,28279,0,0,1,1,0,1,'2024-12-27 14:57:20',839267,'2024-12-27 14:57:25',872494,26989,'','',30,0,0.00745,0.839,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629735,2,21395,0,0,1,5,1,1,'2024-12-27 14:57:25',872564,'2024-12-27 14:57:27',882143,26989,'','',30,0,2.009,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629736,2,23551,0,0,1,1,0,1,'2024-12-27 14:57:27',882761,'2024-12-27 14:57:27',893091,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629737,2,28533,0,0,1,1,1,1,'2024-12-27 14:57:30',931487,'2024-12-27 14:57:32',941386,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629738,2,23548,0,0,1,5,1,1,'2024-12-27 14:57:27',895783,'2024-12-27 14:57:32',942226,26989,'','',30,0,2.00766,2.895,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629739,2,21397,0,0,1,5,1,1,'2024-12-27 14:57:27',898851,'2024-12-27 14:57:32',942485,26989,'','',30,0,2.00857,2.898,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629740,2,23552,0,0,1,1,0,1,'2024-12-27 14:57:32',942813,'2024-12-27 14:57:32',952329,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.125ms, lost 0%','rta=0.125ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629741,2,23554,0,0,1,1,0,1,'2024-12-27 14:57:32',954832,'2024-12-27 14:57:35',980111,26989,'','',30,0,0.00883,2.954,0,'OK - 192.168.77.208: rta 0.146ms, lost 0%','rta=0.146ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629742,2,28533,0,0,1,1,1,1,'2024-12-27 14:57:32',957914,'2024-12-27 14:57:35',980363,26989,'','',30,0,0.98048,2.957,2,'CRITICAL - 172.50.1.3: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629743,2,21395,0,0,1,5,1,1,'2024-12-27 14:57:32',960402,'2024-12-27 14:57:35',980607,26989,'','',30,0,2.00932,2.96,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629744,2,23553,0,0,1,10,1,1,'2024-12-27 14:57:40',103863,'2024-12-27 14:57:41',205816,26989,'','',30,0,1.101,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629745,2,23552,0,0,1,1,0,1,'2024-12-27 14:57:50',263703,'2024-12-27 14:57:50',274533,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.119ms, lost 0%','rta=0.119ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629746,2,23554,0,0,1,1,0,1,'2024-12-27 14:57:50',275371,'2024-12-27 14:57:50',285409,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629747,2,21395,0,0,1,5,1,1,'2024-12-27 14:57:50',285966,'2024-12-27 14:57:51',253034,26989,'','',30,0,0.967,0,1,'CRITICAL - 192.168.77.154: Host unreachable @ 192.168.77.9. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629748,2,21396,0,0,1,5,0,1,'2024-12-27 14:57:51',255540,'2024-12-27 14:57:55',268324,26989,'','',30,0,0.02029,1.255,0,'OK - 192.168.77.159: rta 0.707ms, lost 0%','rta=0.707ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629749,2,23553,0,0,1,10,1,1,'2024-12-27 14:57:56',272921,'2024-12-27 14:58:00',283778,26989,'','',30,0,2.00923,0.272,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629750,2,23551,0,0,1,1,0,1,'2024-12-27 14:58:05',301719,'2024-12-27 14:58:05',312811,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629751,2,28533,0,0,1,1,1,1,'2024-12-27 14:58:05',313145,'2024-12-27 14:58:07',321341,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629752,2,28279,0,0,1,1,0,1,'2024-12-27 14:58:10',333721,'2024-12-27 14:58:10',341674,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629753,2,23551,0,0,1,1,0,1,'2024-12-27 14:58:10',344173,'2024-12-27 14:58:15',359789,26989,'','',30,0,0.00891,0.344,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629754,2,23552,0,0,1,1,0,1,'2024-12-27 14:58:15',360116,'2024-12-27 14:58:15',370501,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.131ms, lost 0%','rta=0.131ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629755,2,21396,0,0,1,5,0,1,'2024-12-27 14:58:20',401802,'2024-12-27 14:58:20',422982,26989,'','',30,0,0.02,0,0,'OK - 192.168.77.159: rta 0.692ms, lost 0%','rta=0.692ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629756,2,23553,0,0,1,10,1,1,'2024-12-27 14:58:20',423301,'2024-12-27 14:58:22',431553,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629757,2,23554,0,0,1,1,0,1,'2024-12-27 14:58:25',453050,'2024-12-27 14:58:25',464532,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.208: rta 0.154ms, lost 0%','rta=0.154ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629758,2,23552,0,0,1,1,0,1,'2024-12-27 14:58:22',434217,'2024-12-27 14:58:25',465053,26989,'','',30,0,0.00858,2.434,0,'OK - 192.168.77.8: rta 0.122ms, lost 0%','rta=0.122ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629759,2,23549,0,0,1,10,0,1,'2024-12-27 14:58:22',437354,'2024-12-27 14:58:25',465287,26989,'','',30,0,0.01064,2.437,0,'OK - 84.38.95.222: rta 0.216ms, lost 0%','rta=0.216ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629760,2,28279,0,0,1,1,0,1,'2024-12-27 14:58:25',467583,'2024-12-27 14:58:30',494493,26989,'','',30,0,0.00632,0.467,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629761,2,21397,0,0,1,5,1,1,'2024-12-27 14:58:32',503127,'2024-12-27 14:58:35',526347,26989,'','',30,0,2.00799,0.503,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629762,2,23548,0,0,1,5,1,1,'2024-12-27 14:58:32',501451,'2024-12-27 14:58:35',526598,26989,'','',30,0,2.00996,0.501,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629763,2,23554,0,0,1,1,0,1,'2024-12-27 14:58:35',529117,'2024-12-27 14:58:40',564683,26989,'','',30,0,0.00998,0.529,0,'OK - 192.168.77.208: rta 0.171ms, lost 0%','rta=0.171ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629764,2,28533,0,0,1,1,1,1,'2024-12-27 14:58:35',532350,'2024-12-27 14:58:40',564966,26989,'','',30,0,2.00923,0.532,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629765,2,21395,0,0,1,5,1,1,'2024-12-27 14:58:35',533598,'2024-12-27 14:58:40',565217,26989,'','',30,0,2.01093,0.533,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629766,2,23552,0,0,1,1,0,1,'2024-12-27 14:58:45',579515,'2024-12-27 14:58:45',589478,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.122ms, lost 0%','rta=0.122ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629767,2,23553,0,0,1,10,1,1,'2024-12-27 14:58:45',589791,'2024-12-27 14:58:47',598325,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629768,2,23549,0,0,1,10,0,1,'2024-12-27 14:58:50',634725,'2024-12-27 14:58:50',650421,26989,'','',30,0,0.015,0,0,'OK - 84.38.95.222: rta 0.404ms, lost 0%','rta=0.404ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629769,2,23554,0,0,1,1,0,1,'2024-12-27 14:58:55',675321,'2024-12-27 14:58:55',685793,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629770,2,23551,0,0,1,1,0,1,'2024-12-27 14:58:55',686134,'2024-12-27 14:58:55',695954,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629771,2,21396,0,0,1,5,0,1,'2024-12-27 14:58:55',698507,'2024-12-27 14:59:00',728923,26989,'','',30,0,0.02029,0.698,0,'OK - 192.168.77.159: rta 0.719ms, lost 0%','rta=0.719ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629772,2,23553,0,0,1,10,1,1,'2024-12-27 14:59:00',732363,'2024-12-27 14:59:05',761876,26989,'','',30,0,2.00856,0.732,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629773,2,28533,0,0,1,1,1,1,'2024-12-27 14:59:05',762227,'2024-12-27 14:59:07',772529,26989,'','',30,0,2.01,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629774,2,23552,0,0,1,1,0,1,'2024-12-27 14:59:10',798635,'2024-12-27 14:59:10',810275,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.8: rta 0.160ms, lost 0%','rta=0.160ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629775,2,21397,0,0,1,5,1,1,'2024-12-27 14:59:15',843219,'2024-12-27 14:59:17',852868,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629776,2,23553,0,0,1,10,1,1,'2024-12-27 14:59:17',853155,'2024-12-27 14:59:18',851084,26989,'','',30,0,0.998,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629777,2,23551,0,0,1,1,0,1,'2024-12-27 14:59:18',853651,'2024-12-27 14:59:20',882213,26989,'','',30,0,0.01223,3.853,0,'OK - 192.168.77.29: rta 0.304ms, lost 0%','rta=0.304ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629778,2,23554,0,0,1,1,0,1,'2024-12-27 14:59:20',882274,'2024-12-27 14:59:20',893349,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629779,2,23549,0,0,1,10,0,1,'2024-12-27 14:59:20',893686,'2024-12-27 14:59:20',907271,26989,'','',30,0,0.013,0,0,'OK - 84.38.95.222: rta 0.324ms, lost 0%','rta=0.324ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629780,2,28533,0,0,1,1,1,1,'2024-12-27 14:59:25',933402,'2024-12-27 14:59:27',942816,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629781,2,23552,0,0,1,1,0,1,'2024-12-27 14:59:27',945358,'2024-12-27 14:59:30',975916,26989,'','',30,0,0.00929,2.945,0,'OK - 192.168.77.8: rta 0.165ms, lost 0%','rta=0.165ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629782,2,23549,0,0,1,10,0,1,'2024-12-27 14:59:27',948411,'2024-12-27 14:59:30',976126,26989,'','',30,0,0.01242,2.948,0,'OK - 84.38.95.222: rta 0.216ms, lost 0%','rta=0.216ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629783,2,28279,0,0,1,1,0,1,'2024-12-27 14:59:30',978832,'2024-12-27 14:59:36',5703,26989,'','',30,0,0.00684,0.978,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629784,2,23548,0,0,1,5,1,1,'2024-12-27 14:59:36',15,'2024-12-27 14:59:40',196,26989,'','',30,0,0.08024,1.017,2,'CRITICAL - 172.20.3.11: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629785,2,21397,0,0,1,5,1,1,'2024-12-27 14:59:36',13,'2024-12-27 14:59:40',12790,26989,'','',30,0,0.08225,1.015,2,'CRITICAL - 172.20.3.10: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629786,2,23551,0,0,1,1,0,1,'2024-12-27 14:59:40',24,'2024-12-27 14:59:40',17800,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.29: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629787,2,23554,0,0,1,1,0,1,'2024-12-27 14:59:40',4,'2024-12-27 14:59:45',27359,26989,'','',30,0,0.00929,0.048,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629788,2,28533,0,0,1,1,1,1,'2024-12-27 14:59:40',41,'2024-12-27 14:59:45',53,26989,'','',30,0,2.0074,0.051,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629789,2,21395,0,0,1,5,1,1,'2024-12-27 14:59:40',44,'2024-12-27 14:59:45',27748,26989,'','',30,0,2.00853,0.054,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629790,2,23553,0,0,1,10,1,1,'2024-12-27 14:59:45',3493,'2024-12-27 14:59:47',4005,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629791,2,28533,0,0,1,1,1,1,'2024-12-27 15:00:00',138987,'2024-12-27 15:00:02',148984,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629792,2,23551,0,0,1,1,0,1,'2024-12-27 15:00:02',149302,'2024-12-27 15:00:02',159534,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629793,2,21396,0,0,1,5,0,1,'2024-12-27 15:00:02',162151,'2024-12-27 15:00:05',171452,26989,'','',30,0,0.02225,2.162,0,'OK - 192.168.77.159: rta 0.784ms, lost 0%','rta=0.784ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629794,2,23552,0,0,1,1,0,1,'2024-12-27 15:00:05',171512,'2024-12-27 15:00:05',181275,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.117ms, lost 0%','rta=0.117ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629795,2,23553,0,0,1,10,1,1,'2024-12-27 15:00:05',181595,'2024-12-27 15:00:07',190026,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629796,2,23553,0,0,1,10,1,1,'2024-12-27 15:00:07',192828,'2024-12-27 15:00:10',212372,26989,'','',30,0,0.99534,2.192,2,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629797,2,23548,0,0,1,5,1,1,'2024-12-27 15:00:10',212443,'2024-12-27 15:00:12',222148,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629798,2,23554,0,0,1,1,0,1,'2024-12-27 15:00:12',222484,'2024-12-27 15:00:12',233430,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629799,2,23551,0,0,1,1,0,1,'2024-12-27 15:00:20',285893,'2024-12-27 15:00:25',309326,26989,'','',30,0,0.01055,0.285,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629800,2,21395,0,0,1,5,1,1,'2024-12-27 15:00:25',309392,'2024-12-27 15:00:27',319587,26989,'','',30,0,2.009,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629801,2,23552,0,0,1,1,0,1,'2024-12-27 15:00:27',319905,'2024-12-27 15:00:27',329734,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.135ms, lost 0%','rta=0.135ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629802,2,28533,0,0,1,1,1,1,'2024-12-27 15:00:30',368408,'2024-12-27 15:00:32',377368,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629803,2,23548,0,0,1,5,1,1,'2024-12-27 15:00:32',377956,'2024-12-27 15:00:34',386782,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629804,2,23552,0,0,1,1,0,1,'2024-12-27 15:00:34',389629,'2024-12-27 15:00:35',412541,26989,'','',30,0,0.00946,4.389,0,'OK - 192.168.77.8: rta 0.130ms, lost 0%','rta=0.130ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629805,2,23549,0,0,1,10,0,1,'2024-12-27 15:00:34',392752,'2024-12-27 15:00:35',412762,26989,'','',30,0,0.01087,4.392,0,'OK - 84.38.95.222: rta 0.203ms, lost 0%','rta=0.203ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629806,2,28279,0,0,1,1,0,1,'2024-12-27 15:00:36',416182,'2024-12-27 15:00:40',459560,26989,'','',30,0,0.00646,0.416,0,'OK - 192.168.77.9: rta 0.014ms, lost 0%','rta=0.014ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629807,2,23551,0,0,1,1,0,1,'2024-12-27 15:00:40',459642,'2024-12-27 15:00:40',471084,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629808,2,23553,0,0,1,10,1,1,'2024-12-27 15:00:40',471403,'2024-12-27 15:00:41',546016,26989,'','',30,0,1.074,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629809,2,23548,0,0,1,5,1,1,'2024-12-27 15:00:41',548732,'2024-12-27 15:00:45',567041,26989,'','',30,0,2.00841,1.548,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629810,2,21397,0,0,1,5,1,1,'2024-12-27 15:00:41',551577,'2024-12-27 15:00:45',567327,26989,'','',30,0,2.01206,1.551,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629811,2,23554,0,0,1,1,0,1,'2024-12-27 15:00:45',570128,'2024-12-27 15:00:50',622695,26989,'','',30,0,0.01019,0.57,0,'OK - 192.168.77.208: rta 0.156ms, lost 0%','rta=0.156ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629812,2,28533,0,0,1,1,1,1,'2024-12-27 15:00:45',573496,'2024-12-27 15:00:50',622966,26989,'','',30,0,2.00831,0.573,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629813,2,21395,0,0,1,5,1,1,'2024-12-27 15:00:45',576973,'2024-12-27 15:00:50',623209,26989,'','',30,0,2.00784,0.576,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629814,2,23552,0,0,1,1,0,1,'2024-12-27 15:00:50',623268,'2024-12-27 15:00:50',633405,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.129ms, lost 0%','rta=0.129ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629815,2,23551,0,0,1,1,0,1,'2024-12-27 15:01:05',710386,'2024-12-27 15:01:05',721087,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629816,2,28533,0,0,1,1,1,1,'2024-12-27 15:01:05',721421,'2024-12-27 15:01:07',730949,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629817,2,21396,0,0,1,5,0,1,'2024-12-27 15:01:07',733399,'2024-12-27 15:01:10',759558,26989,'','',30,0,0.02764,2.733,0,'OK - 192.168.77.159: rta 1.059ms, lost 0%','rta=1.059ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629818,2,28279,0,0,1,1,0,1,'2024-12-27 15:01:10',759625,'2024-12-27 15:01:10',767916,26989,'','',30,0,0.008,0,0,'OK - 192.168.77.9: rta 0.014ms, lost 0%','rta=0.014ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629819,2,23553,0,0,1,10,1,1,'2024-12-27 15:01:10',770439,'2024-12-27 15:01:15',798445,26989,'','',30,0,2.00794,0.77,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629820,2,23552,0,0,1,1,0,1,'2024-12-27 15:01:15',798499,'2024-12-27 15:01:15',808381,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.118ms, lost 0%','rta=0.118ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629821,2,23554,0,0,1,1,0,1,'2024-12-27 15:01:25',869735,'2024-12-27 15:01:25',880965,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629822,2,23551,0,0,1,1,0,1,'2024-12-27 15:01:25',883401,'2024-12-27 15:01:30',911189,26989,'','',30,0,0.00887,0.883,0,'OK - 192.168.77.29: rta 0.146ms, lost 0%','rta=0.146ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629823,2,23552,0,0,1,1,0,1,'2024-12-27 15:01:35',940876,'2024-12-27 15:01:40',18930,26989,'','',30,0,0.0091,0.94,0,'OK - 192.168.77.8: rta 0.116ms, lost 0%','rta=0.116ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629824,2,23549,0,0,1,10,0,1,'2024-12-27 15:01:35',943576,'2024-12-27 15:01:40',36,26989,'','',30,0,0.01101,0.943,0,'OK - 84.38.95.222: rta 0.200ms, lost 0%','rta=0.200ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629825,2,28279,0,0,1,1,0,1,'2024-12-27 15:01:40',20054,'2024-12-27 15:01:45',0,26989,'','',30,0,0.00668,0.047,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629826,2,23553,0,0,1,10,1,1,'2024-12-27 15:01:45',0,'2024-12-27 15:01:47',0,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629827,2,23548,0,0,1,5,1,1,'2024-12-27 15:01:47',0,'2024-12-27 15:01:50',113788,26989,'','',30,0,0.99661,2.095,2,'CRITICAL - 172.20.3.11: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629828,2,21397,0,0,1,5,1,1,'2024-12-27 15:01:47',0,'2024-12-27 15:01:50',114052,26989,'','',30,0,0.99349,2.098,2,'CRITICAL - 172.20.3.10: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629829,2,23554,0,0,1,1,0,1,'2024-12-27 15:01:50',116858,'2024-12-27 15:01:55',162650,26989,'','',30,0,0.00986,0.116,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629830,2,28533,0,0,1,1,1,1,'2024-12-27 15:01:50',120313,'2024-12-27 15:01:55',163156,26989,'','',30,0,2.00769,0.12,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629831,2,21395,0,0,1,5,1,1,'2024-12-27 15:01:50',123656,'2024-12-27 15:01:55',163376,26989,'','',30,0,2.0083,0.123,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629832,2,23551,0,0,1,1,0,1,'2024-12-27 15:01:55',163432,'2024-12-27 15:01:55',174269,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.148ms, lost 0%','rta=0.148ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629833,2,23552,0,0,1,1,0,1,'2024-12-27 15:02:10',239664,'2024-12-27 15:02:10',249947,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.140ms, lost 0%','rta=0.140ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629834,2,21396,0,0,1,5,0,1,'2024-12-27 15:02:10',252384,'2024-12-27 15:02:15',266324,26989,'','',30,0,0.01964,0.252,0,'OK - 192.168.77.159: rta 0.692ms, lost 0%','rta=0.692ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629835,2,21397,0,0,1,5,1,1,'2024-12-27 15:02:15',266375,'2024-12-27 15:02:17',275408,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629836,2,23553,0,0,1,10,1,1,'2024-12-27 15:02:17',275721,'2024-12-27 15:02:18',274544,26989,'','',30,0,0.999,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629837,2,23554,0,0,1,1,0,1,'2024-12-27 15:02:20',297089,'2024-12-27 15:02:20',308715,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629838,2,23549,0,0,1,10,0,1,'2024-12-27 15:02:20',309050,'2024-12-27 15:02:20',319860,26989,'','',30,0,0.01,0,0,'OK - 84.38.95.222: rta 0.196ms, lost 0%','rta=0.196ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629839,2,23553,0,0,1,10,1,1,'2024-12-27 15:02:18',276994,'2024-12-27 15:02:20',320345,26989,'','',30,0,2.00686,3.276,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629840,2,28533,0,0,1,1,1,1,'2024-12-27 15:02:25',337947,'2024-12-27 15:02:27',347129,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629841,2,23551,0,0,1,1,0,1,'2024-12-27 15:02:30',363686,'2024-12-27 15:02:30',374817,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629842,2,23551,0,0,1,1,0,1,'2024-12-27 15:02:30',377257,'2024-12-27 15:02:35',390653,26989,'','',30,0,0.00907,0.377,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629843,2,28279,0,0,1,1,0,1,'2024-12-27 15:02:35',390723,'2024-12-27 15:02:35',398851,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.016ms, lost 0%','rta=0.016ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629844,2,23552,0,0,1,1,0,1,'2024-12-27 15:02:35',399177,'2024-12-27 15:02:35',408476,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.122ms, lost 0%','rta=0.122ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629845,2,23552,0,0,1,1,0,1,'2024-12-27 15:02:40',440562,'2024-12-27 15:02:45',464968,26989,'','',30,0,0.01051,0.44,0,'OK - 192.168.77.8: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629846,2,23549,0,0,1,10,0,1,'2024-12-27 15:02:40',442544,'2024-12-27 15:02:45',465201,26989,'','',30,0,0.01262,0.442,0,'OK - 84.38.95.222: rta 0.252ms, lost 0%','rta=0.252ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629847,2,21397,0,0,1,5,1,1,'2024-12-27 15:02:45',465260,'2024-12-27 15:02:47',474775,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629848,2,23553,0,0,1,10,1,1,'2024-12-27 15:02:47',475119,'2024-12-27 15:02:48',473055,26989,'','',30,0,0.998,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629849,2,23554,0,0,1,1,0,1,'2024-12-27 15:02:48',473649,'2024-12-27 15:02:48',483707,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629850,2,28279,0,0,1,1,0,1,'2024-12-27 15:02:48',486312,'2024-12-27 15:02:50',513675,26989,'','',30,0,0.00622,3.486,0,'OK - 192.168.77.9: rta 0.014ms, lost 0%','rta=0.014ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629851,2,28533,0,0,1,1,1,1,'2024-12-27 15:02:55',541211,'2024-12-27 15:02:56',603247,26989,'','',30,0,1.061,0,1,'CRITICAL - 172.50.1.3: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629852,2,23548,0,0,1,5,1,1,'2024-12-27 15:02:50',515856,'2024-12-27 15:02:56',603773,26989,'','',30,0,2.00835,0.515,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629853,2,21397,0,0,1,5,1,1,'2024-12-27 15:02:50',519514,'2024-12-27 15:02:56',604014,26989,'','',30,0,2.00787,0.519,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629854,2,23554,0,0,1,1,0,1,'2024-12-27 15:02:56',606235,'2024-12-27 15:03:00',630691,26989,'','',30,0,0.01071,1.606,0,'OK - 192.168.77.208: rta 0.202ms, lost 0%','rta=0.202ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629855,2,23551,0,0,1,1,0,1,'2024-12-27 15:03:00',631249,'2024-12-27 15:03:00',642379,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629856,2,28533,0,0,1,1,1,1,'2024-12-27 15:02:56',607041,'2024-12-27 15:03:00',642846,26989,'','',30,0,2.01043,1.606,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629857,2,21395,0,0,1,5,1,1,'2024-12-27 15:02:56',610033,'2024-12-27 15:03:00',643065,26989,'','',30,0,2.0084,1.609,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629858,2,23552,0,0,1,1,0,1,'2024-12-27 15:03:05',663859,'2024-12-27 15:03:05',674027,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.143ms, lost 0%','rta=0.143ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629859,2,23553,0,0,1,10,1,1,'2024-12-27 15:03:05',674589,'2024-12-27 15:03:07',683096,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629860,2,23548,0,0,1,5,1,1,'2024-12-27 15:03:10',719527,'2024-12-27 15:03:12',728833,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629861,2,23554,0,0,1,1,0,1,'2024-12-27 15:03:12',729150,'2024-12-27 15:03:12',739118,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629862,2,21396,0,0,1,5,0,1,'2024-12-27 15:03:15',763726,'2024-12-27 15:03:20',791843,26989,'','',30,0,0.02026,0.763,0,'OK - 192.168.77.159: rta 0.701ms, lost 0%','rta=0.701ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629863,2,21395,0,0,1,5,1,1,'2024-12-27 15:03:25',830811,'2024-12-27 15:03:27',840708,26989,'','',30,0,2.009,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629864,2,23552,0,0,1,1,0,1,'2024-12-27 15:03:27',841045,'2024-12-27 15:03:27',850461,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.123ms, lost 0%','rta=0.123ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629865,2,23553,0,0,1,10,1,1,'2024-12-27 15:03:20',800078,'2024-12-27 15:03:27',850983,26989,'','',30,0,2.01,0.799,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629866,2,23551,0,0,1,1,0,1,'2024-12-27 15:03:27',851059,'2024-12-27 15:03:27',861017,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629867,2,28533,0,0,1,1,1,1,'2024-12-27 15:03:30',894185,'2024-12-27 15:03:32',904057,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629868,2,23548,0,0,1,5,1,1,'2024-12-27 15:03:32',904599,'2024-12-27 15:03:34',913389,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629869,2,23551,0,0,1,1,0,1,'2024-12-27 15:03:35',932735,'2024-12-27 15:03:40',970994,26989,'','',30,0,0.00913,0.932,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629870,2,23553,0,0,1,10,1,1,'2024-12-27 15:03:40',971353,'2024-12-27 15:03:42',3439,26989,'','',30,0,1.094,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629871,2,23552,0,0,1,1,0,1,'2024-12-27 15:03:45',0,'2024-12-27 15:03:50',113505,26989,'','',30,0,0.00875,0.082,0,'OK - 192.168.77.8: rta 0.118ms, lost 0%','rta=0.118ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629872,2,23549,0,0,1,10,0,1,'2024-12-27 15:03:45',0,'2024-12-27 15:03:50',113735,26989,'','',30,0,0.01102,0.084,0,'OK - 84.38.95.222: rta 0.230ms, lost 0%','rta=0.230ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629873,2,28533,0,0,1,1,1,1,'2024-12-27 15:03:50',113803,'2024-12-27 15:03:52',123541,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629874,2,23554,0,0,1,1,0,1,'2024-12-27 15:03:52',124601,'2024-12-27 15:03:52',134815,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629875,2,21395,0,0,1,5,1,1,'2024-12-27 15:03:52',135376,'2024-12-27 15:03:54',143911,26989,'','',30,0,2.008,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629876,2,28279,0,0,1,1,0,1,'2024-12-27 15:03:54',146498,'2024-12-27 15:03:55',155383,26989,'','',30,0,0.00673,4.146,0,'OK - 192.168.77.9: rta 0.014ms, lost 0%','rta=0.014ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629877,2,23548,0,0,1,5,1,1,'2024-12-27 15:03:56',158705,'2024-12-27 15:04:00',172814,26989,'','',30,0,2.0087,0.158,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629878,2,21397,0,0,1,5,1,1,'2024-12-27 15:03:56',162143,'2024-12-27 15:04:00',173071,26989,'','',30,0,2.00809,0.162,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629879,2,23554,0,0,1,1,0,1,'2024-12-27 15:04:00',185248,'2024-12-27 15:04:05',205006,26989,'','',30,0,0.01027,0.185,0,'OK - 192.168.77.208: rta 0.156ms, lost 0%','rta=0.156ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629880,2,23551,0,0,1,1,0,1,'2024-12-27 15:04:05',205061,'2024-12-27 15:04:05',215770,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629881,2,21395,0,0,1,5,1,1,'2024-12-27 15:04:00',189239,'2024-12-27 15:04:05',216501,26989,'','',30,0,2.00832,0.189,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629882,2,28533,0,0,1,1,1,1,'2024-12-27 15:04:00',186274,'2024-12-27 15:04:05',216740,26989,'','',30,0,2.0114,0.186,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629883,2,28279,0,0,1,1,0,1,'2024-12-27 15:04:10',235801,'2024-12-27 15:04:10',244543,26989,'','',30,0,0.008,0,0,'OK - 192.168.77.9: rta 0.014ms, lost 0%','rta=0.014ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629884,2,23552,0,0,1,1,0,1,'2024-12-27 15:04:15',260842,'2024-12-27 15:04:15',271980,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.146ms, lost 0%','rta=0.146ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629885,2,21396,0,0,1,5,0,1,'2024-12-27 15:04:20',301455,'2024-12-27 15:04:20',331861,26989,'','',30,0,0.03,0,0,'OK - 192.168.77.159: rta 1.140ms, lost 0%','rta=1.140ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629886,2,23553,0,0,1,10,1,1,'2024-12-27 15:04:20',332204,'2024-12-27 15:04:22',341615,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629887,2,23554,0,0,1,1,0,1,'2024-12-27 15:04:25',361064,'2024-12-27 15:04:25',371796,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629888,2,21396,0,0,1,5,0,1,'2024-12-27 15:04:22',344322,'2024-12-27 15:04:25',372318,26989,'','',30,0,0.02216,2.344,0,'OK - 192.168.77.159: rta 0.807ms, lost 0%','rta=0.807ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629889,2,23553,0,0,1,10,1,1,'2024-12-27 15:04:27',378873,'2024-12-27 15:04:30',401458,26989,'','',30,0,2.00655,0.378,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629890,2,23551,0,0,1,1,0,1,'2024-12-27 15:04:40',474754,'2024-12-27 15:04:45',507782,26989,'','',30,0,0.00934,0.474,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629891,2,23552,0,0,1,1,0,1,'2024-12-27 15:04:45',507844,'2024-12-27 15:04:45',518454,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.136ms, lost 0%','rta=0.136ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629892,2,23553,0,0,1,10,1,1,'2024-12-27 15:04:45',518786,'2024-12-27 15:04:47',527447,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629893,2,23549,0,0,1,10,0,1,'2024-12-27 15:04:50',552444,'2024-12-27 15:04:50',569202,26989,'','',30,0,0.016,0,0,'OK - 84.38.95.222: rta 0.402ms, lost 0%','rta=0.402ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629894,2,23552,0,0,1,1,0,1,'2024-12-27 15:04:50',571843,'2024-12-27 15:04:55',603910,26989,'','',30,0,0.0093,0.571,0,'OK - 192.168.77.8: rta 0.145ms, lost 0%','rta=0.145ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629895,2,23549,0,0,1,10,0,1,'2024-12-27 15:04:50',575321,'2024-12-27 15:04:55',604137,26989,'','',30,0,0.01212,0.575,0,'OK - 84.38.95.222: rta 0.217ms, lost 0%','rta=0.217ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629896,2,23554,0,0,1,1,0,1,'2024-12-27 15:04:55',604207,'2024-12-27 15:04:55',615517,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629897,2,28279,0,0,1,1,0,1,'2024-12-27 15:04:55',618258,'2024-12-27 15:05:00',652478,26989,'','',30,0,0.0061,0.618,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629898,2,23551,0,0,1,1,0,1,'2024-12-27 15:05:00',653066,'2024-12-27 15:05:00',664448,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629899,2,23548,0,0,1,5,1,1,'2024-12-27 15:05:00',667231,'2024-12-27 15:05:05',700857,26989,'','',30,0,2.00875,0.667,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629900,2,21397,0,0,1,5,1,1,'2024-12-27 15:05:00',670321,'2024-12-27 15:05:05',701097,26989,'','',30,0,2.00868,0.67,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629901,2,28533,0,0,1,1,1,1,'2024-12-27 15:05:05',701428,'2024-12-27 15:05:07',709967,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629902,2,23554,0,0,1,1,0,1,'2024-12-27 15:05:07',712413,'2024-12-27 15:05:10',746349,26989,'','',30,0,0.00973,2.712,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629903,2,23552,0,0,1,1,0,1,'2024-12-27 15:05:10',746430,'2024-12-27 15:05:10',756402,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.121ms, lost 0%','rta=0.121ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629904,2,28533,0,0,1,1,1,1,'2024-12-27 15:05:07',719190,'2024-12-27 15:05:10',756904,26989,'','',30,0,0.98982,2.719,2,'CRITICAL - 172.50.1.3: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629905,2,21395,0,0,1,5,1,1,'2024-12-27 15:05:07',715621,'2024-12-27 15:05:10',757138,26989,'','',30,0,2.00855,2.715,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629906,2,23553,0,0,1,10,1,1,'2024-12-27 15:05:15',788775,'2024-12-27 15:05:17',798763,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629907,2,23549,0,0,1,10,0,1,'2024-12-27 15:05:20',834225,'2024-12-27 15:05:20',850666,26989,'','',30,0,0.016,0,0,'OK - 84.38.95.222: rta 0.418ms, lost 0%','rta=0.418ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629908,2,28533,0,0,1,1,1,1,'2024-12-27 15:05:25',880981,'2024-12-27 15:05:27',890452,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629909,2,21396,0,0,1,5,0,1,'2024-12-27 15:05:27',892940,'2024-12-27 15:05:30',925902,26989,'','',30,0,0.02322,2.892,0,'OK - 192.168.77.159: rta 0.844ms, lost 0%','rta=0.844ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629910,2,23551,0,0,1,1,0,1,'2024-12-27 15:05:30',926234,'2024-12-27 15:05:30',937369,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.148ms, lost 0%','rta=0.148ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629911,2,28279,0,0,1,1,0,1,'2024-12-27 15:05:35',970010,'2024-12-27 15:05:35',978529,26989,'','',30,0,0.008,0,0,'OK - 192.168.77.9: rta 0.016ms, lost 0%','rta=0.016ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629912,2,23553,0,0,1,10,1,1,'2024-12-27 15:05:30',939923,'2024-12-27 15:05:35',978983,26989,'','',30,0,2.00769,0.939,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629913,2,23552,0,0,1,1,0,1,'2024-12-27 15:05:35',979047,'2024-12-27 15:05:35',988554,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.129ms, lost 0%','rta=0.129ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629914,2,21397,0,0,1,5,1,1,'2024-12-27 15:05:45',367,'2024-12-27 15:05:47',426,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629915,2,23553,0,0,1,10,1,1,'2024-12-27 15:05:47',53,'2024-12-27 15:05:48',26966,26989,'','',30,0,0.999,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629916,2,23554,0,0,1,1,0,1,'2024-12-27 15:05:48',52,'2024-12-27 15:05:48',60,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.148ms, lost 0%','rta=0.148ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629917,2,23551,0,0,1,1,0,1,'2024-12-27 15:05:48',507,'2024-12-27 15:05:50',0,26989,'','',30,0,0.01254,3.077,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629918,2,28533,0,0,1,1,1,1,'2024-12-27 15:05:55',105046,'2024-12-27 15:05:56',191327,26989,'','',30,0,1.085,0,1,'CRITICAL - 172.50.1.3: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629919,2,23552,0,0,1,1,0,1,'2024-12-27 15:05:56',193808,'2024-12-27 15:06:00',218244,26989,'','',30,0,0.00935,1.193,0,'OK - 192.168.77.8: rta 0.126ms, lost 0%','rta=0.126ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629920,2,23549,0,0,1,10,0,1,'2024-12-27 15:05:56',197069,'2024-12-27 15:06:00',218488,26989,'','',30,0,0.0112,1.197,0,'OK - 84.38.95.222: rta 0.197ms, lost 0%','rta=0.197ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629921,2,28279,0,0,1,1,0,1,'2024-12-27 15:06:00',221797,'2024-12-27 15:06:05',236869,26989,'','',30,0,0.0064,0.221,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629922,2,23551,0,0,1,1,0,1,'2024-12-27 15:06:05',237198,'2024-12-27 15:06:05',247531,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629923,2,23553,0,0,1,10,1,1,'2024-12-27 15:06:05',247859,'2024-12-27 15:06:07',256723,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629924,2,21397,0,0,1,5,1,1,'2024-12-27 15:06:07',261757,'2024-12-27 15:06:10',278062,26989,'','',30,0,0.99325,2.261,2,'CRITICAL - 172.20.3.10: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629925,2,23548,0,0,1,5,1,1,'2024-12-27 15:06:07',259249,'2024-12-27 15:06:10',278290,26989,'','',30,0,0.99593,2.259,2,'CRITICAL - 172.20.3.11: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629926,2,23554,0,0,1,1,0,1,'2024-12-27 15:06:10',278577,'2024-12-27 15:06:10',288794,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629927,2,23554,0,0,1,1,0,1,'2024-12-27 15:06:10',291241,'2024-12-27 15:06:15',309209,26989,'','',30,0,0.01004,0.291,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629928,2,28533,0,0,1,1,1,1,'2024-12-27 15:06:10',294260,'2024-12-27 15:06:15',309445,26989,'','',30,0,2.00863,0.294,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629929,2,21395,0,0,1,5,1,1,'2024-12-27 15:06:10',297734,'2024-12-27 15:06:15',309675,26989,'','',30,0,2.00769,0.297,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629930,2,23552,0,0,1,1,0,1,'2024-12-27 15:06:25',382900,'2024-12-27 15:06:25',393508,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.141ms, lost 0%','rta=0.141ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629931,2,23551,0,0,1,1,0,1,'2024-12-27 15:06:25',393835,'2024-12-27 15:06:25',403720,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629932,2,28533,0,0,1,1,1,1,'2024-12-27 15:06:30',450306,'2024-12-27 15:06:32',460626,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629933,2,23548,0,0,1,5,1,1,'2024-12-27 15:06:32',461303,'2024-12-27 15:06:34',470664,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629934,2,21396,0,0,1,5,0,1,'2024-12-27 15:06:34',473492,'2024-12-27 15:06:35',497577,26989,'','',30,0,0.02111,4.473,0,'OK - 192.168.77.159: rta 0.744ms, lost 0%','rta=0.744ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629935,2,23553,0,0,1,10,1,1,'2024-12-27 15:06:35',499706,'2024-12-27 15:06:40',544770,26989,'','',30,0,2.00852,0.499,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629936,2,23552,0,0,1,1,0,1,'2024-12-27 15:06:50',617201,'2024-12-27 15:06:50',627652,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.118ms, lost 0%','rta=0.118ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629937,2,23554,0,0,1,1,0,1,'2024-12-27 15:06:50',628207,'2024-12-27 15:06:50',638118,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629938,2,21395,0,0,1,5,1,1,'2024-12-27 15:06:55',667337,'2024-12-27 15:06:57',676653,26989,'','',30,0,2.009,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629939,2,23551,0,0,1,1,0,1,'2024-12-27 15:06:50',640857,'2024-12-27 15:06:57',677137,26989,'','',30,0,0.00893,0.64,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629940,2,23553,0,0,1,10,1,1,'2024-12-27 15:06:57',677199,'2024-12-27 15:06:59',684947,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629941,2,23552,0,0,1,1,0,1,'2024-12-27 15:07:00',715024,'2024-12-27 15:07:05',740326,26989,'','',30,0,0.00848,0.714,0,'OK - 192.168.77.8: rta 0.116ms, lost 0%','rta=0.116ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629942,2,23549,0,0,1,10,0,1,'2024-12-27 15:07:00',718391,'2024-12-27 15:07:05',740548,26989,'','',30,0,0.01027,0.718,0,'OK - 84.38.95.222: rta 0.199ms, lost 0%','rta=0.199ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629943,2,28533,0,0,1,1,1,1,'2024-12-27 15:07:05',740881,'2024-12-27 15:07:07',750231,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629944,2,28279,0,0,1,1,0,1,'2024-12-27 15:07:07',752724,'2024-12-27 15:07:10',788999,26989,'','',30,0,0.0073,2.752,0,'OK - 192.168.77.9: rta 0.016ms, lost 0%','rta=0.016ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629945,2,23551,0,0,1,1,0,1,'2024-12-27 15:07:15',816384,'2024-12-27 15:07:15',826949,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629946,2,21397,0,0,1,5,1,1,'2024-12-27 15:07:10',791585,'2024-12-27 15:07:15',827455,26989,'','',30,0,2.00709,0.791,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629947,2,23548,0,0,1,5,1,1,'2024-12-27 15:07:10',795102,'2024-12-27 15:07:15',827687,26989,'','',30,0,2.00653,0.795,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629948,2,23554,0,0,1,1,0,1,'2024-12-27 15:07:15',830126,'2024-12-27 15:07:20',872863,26989,'','',30,0,0.01086,0.83,0,'OK - 192.168.77.208: rta 0.246ms, lost 0%','rta=0.246ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629949,2,21396,0,0,1,5,0,1,'2024-12-27 15:07:20',872935,'2024-12-27 15:07:20',903441,26989,'','',30,0,0.03,0,0,'OK - 192.168.77.159: rta 1.161ms, lost 0%','rta=1.161ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629950,2,28533,0,0,1,1,1,1,'2024-12-27 15:07:15',833230,'2024-12-27 15:07:20',903977,26989,'','',30,0,2.00781,0.833,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629951,2,21395,0,0,1,5,1,1,'2024-12-27 15:07:15',836439,'2024-12-27 15:07:20',904212,26989,'','',30,0,2.00855,0.836,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629952,2,23553,0,0,1,10,1,1,'2024-12-27 15:07:20',904278,'2024-12-27 15:07:22',913796,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629953,2,21396,0,0,1,5,0,1,'2024-12-27 15:07:35',989577,'2024-12-27 15:07:40',2,26989,'','',30,0,0.02294,0.989,0,'OK - 192.168.77.159: rta 0.825ms, lost 0%','rta=0.825ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629954,2,23553,0,0,1,10,1,1,'2024-12-27 15:07:40',2663,'2024-12-27 15:07:45',8443,26989,'','',30,0,1.65789,0.005,2,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629955,2,23552,0,0,1,1,0,1,'2024-12-27 15:07:45',8487,'2024-12-27 15:07:45',12854,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.113ms, lost 0%','rta=0.113ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629956,2,23549,0,0,1,10,0,1,'2024-12-27 15:07:50',21182,'2024-12-27 15:07:50',50,26989,'','',30,0,0.011,0,0,'OK - 84.38.95.222: rta 0.199ms, lost 0%','rta=0.199ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629957,2,23554,0,0,1,1,0,1,'2024-12-27 15:07:55',7,'2024-12-27 15:07:55',0,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629958,2,23551,0,0,1,1,0,1,'2024-12-27 15:07:55',0,'2024-12-27 15:07:55',100535,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629959,2,23551,0,0,1,1,0,1,'2024-12-27 15:07:57',110556,'2024-12-27 15:08:00',122663,26989,'','',30,0,0.01159,0.11,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629960,2,28533,0,0,1,1,1,1,'2024-12-27 15:08:05',139502,'2024-12-27 15:08:07',148510,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629961,2,23552,0,0,1,1,0,1,'2024-12-27 15:08:07',150981,'2024-12-27 15:08:10',174533,26989,'','',30,0,0.00898,2.15,0,'OK - 192.168.77.8: rta 0.138ms, lost 0%','rta=0.138ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629962,2,23549,0,0,1,10,0,1,'2024-12-27 15:08:07',154217,'2024-12-27 15:08:10',174762,26989,'','',30,0,0.01266,2.154,0,'OK - 84.38.95.222: rta 0.300ms, lost 0%','rta=0.300ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629963,2,28279,0,0,1,1,0,1,'2024-12-27 15:08:10',177185,'2024-12-27 15:08:15',192460,26989,'','',30,0,0.00689,0.177,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629964,2,21397,0,0,1,5,1,1,'2024-12-27 15:08:15',192520,'2024-12-27 15:08:17',202102,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629965,2,23553,0,0,1,10,1,1,'2024-12-27 15:08:17',202483,'2024-12-27 15:08:18',202112,26989,'','',30,0,1,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629966,2,23554,0,0,1,1,0,1,'2024-12-27 15:08:20',224091,'2024-12-27 15:08:20',235490,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629967,2,21397,0,0,1,5,1,1,'2024-12-27 15:08:18',204766,'2024-12-27 15:08:20',236253,26989,'','',30,0,2.00742,3.204,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629968,2,23548,0,0,1,5,1,1,'2024-12-27 15:08:18',207616,'2024-12-27 15:08:20',236476,26989,'','',30,0,2.00757,3.207,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629969,2,23554,0,0,1,1,0,1,'2024-12-27 15:08:20',238680,'2024-12-27 15:08:25',273187,26989,'','',30,0,0.01221,0.238,0,'OK - 192.168.77.208: rta 0.309ms, lost 0%','rta=0.309ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629970,2,28533,0,0,1,1,1,1,'2024-12-27 15:08:20',241763,'2024-12-27 15:08:25',273451,26989,'','',30,0,2.00808,0.241,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629971,2,21395,0,0,1,5,1,1,'2024-12-27 15:08:20',244853,'2024-12-27 15:08:25',273700,26989,'','',30,0,2.00796,0.244,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629972,2,23551,0,0,1,1,0,1,'2024-12-27 15:08:30',309197,'2024-12-27 15:08:30',319892,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.154ms, lost 0%','rta=0.154ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629973,2,28279,0,0,1,1,0,1,'2024-12-27 15:08:35',351057,'2024-12-27 15:08:35',358800,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629974,2,23552,0,0,1,1,0,1,'2024-12-27 15:08:35',359137,'2024-12-27 15:08:35',368525,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.129ms, lost 0%','rta=0.129ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629975,2,21397,0,0,1,5,1,1,'2024-12-27 15:08:45',443986,'2024-12-27 15:08:47',453964,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629976,2,21396,0,0,1,5,0,1,'2024-12-27 15:08:40',415943,'2024-12-27 15:08:47',454412,26989,'','',30,0,0.02973,0.415,0,'OK - 192.168.77.159: rta 1.121ms, lost 0%','rta=1.121ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629977,2,23553,0,0,1,10,1,1,'2024-12-27 15:08:47',454463,'2024-12-27 15:08:48',453197,26989,'','',30,0,0.999,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629978,2,23554,0,0,1,1,0,1,'2024-12-27 15:08:48',453683,'2024-12-27 15:08:48',463564,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629979,2,23553,0,0,1,10,1,1,'2024-12-27 15:08:48',466055,'2024-12-27 15:08:55',527128,26989,'','',30,0,2.00854,3.466,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629980,2,28533,0,0,1,1,1,1,'2024-12-27 15:08:55',527187,'2024-12-27 15:08:56',580484,26989,'','',30,0,1.053,0,1,'CRITICAL - 172.50.1.3: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629981,2,23551,0,0,1,1,0,1,'2024-12-27 15:09:00',599818,'2024-12-27 15:09:00',609984,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629982,2,23551,0,0,1,1,0,1,'2024-12-27 15:09:00',612604,'2024-12-27 15:09:05',634097,26989,'','',30,0,0.00898,0.612,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629983,2,23552,0,0,1,1,0,1,'2024-12-27 15:09:05',634158,'2024-12-27 15:09:05',643424,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.117ms, lost 0%','rta=0.117ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629984,2,23553,0,0,1,10,1,1,'2024-12-27 15:09:05',643922,'2024-12-27 15:09:07',652265,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629985,2,23548,0,0,1,5,1,1,'2024-12-27 15:09:10',684917,'2024-12-27 15:09:12',694656,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629986,2,23554,0,0,1,1,0,1,'2024-12-27 15:09:12',695014,'2024-12-27 15:09:12',705944,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629987,2,23552,0,0,1,1,0,1,'2024-12-27 15:09:12',708473,'2024-12-27 15:09:15',739773,26989,'','',30,0,0.00945,2.708,0,'OK - 192.168.77.8: rta 0.167ms, lost 0%','rta=0.167ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629988,2,23549,0,0,1,10,0,1,'2024-12-27 15:09:12',711260,'2024-12-27 15:09:15',739988,26989,'','',30,0,0.01056,2.711,0,'OK - 84.38.95.222: rta 0.203ms, lost 0%','rta=0.203ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629989,2,28279,0,0,1,1,0,1,'2024-12-27 15:09:15',742394,'2024-12-27 15:09:20',779018,26989,'','',30,0,0.00652,0.742,0,'OK - 192.168.77.9: rta 0.014ms, lost 0%','rta=0.014ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629990,2,21395,0,0,1,5,1,1,'2024-12-27 15:09:25',819230,'2024-12-27 15:09:27',828815,26989,'','',30,0,2.009,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629991,2,21397,0,0,1,5,1,1,'2024-12-27 15:09:20',787317,'2024-12-27 15:09:27',829502,26989,'','',30,0,2.00731,0.787,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629992,2,23548,0,0,1,5,1,1,'2024-12-27 15:09:20',790890,'2024-12-27 15:09:27',829714,26989,'','',30,0,2.00782,0.79,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629993,2,23551,0,0,1,1,0,1,'2024-12-27 15:09:27',829785,'2024-12-27 15:09:27',839876,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629994,2,28533,0,0,1,1,1,1,'2024-12-27 15:09:30',881316,'2024-12-27 15:09:32',891745,26989,'','',30,0,2.01,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629995,2,23554,0,0,1,1,0,1,'2024-12-27 15:09:27',842285,'2024-12-27 15:09:32',892224,26989,'','',30,0,0.01213,2.842,0,'OK - 192.168.77.208: rta 0.313ms, lost 0%','rta=0.313ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629996,2,21395,0,0,1,5,1,1,'2024-12-27 15:09:27',848340,'2024-12-27 15:09:32',892698,26989,'','',30,0,0.97865,2.848,2,'CRITICAL - 192.168.77.154: Host unreachable @ 192.168.77.9. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629997,2,28533,0,0,1,1,1,1,'2024-12-27 15:09:27',845295,'2024-12-27 15:09:32',892938,26989,'','',30,0,2.00685,2.845,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276629998,2,23552,0,0,1,1,0,1,'2024-12-27 15:09:32',893243,'2024-12-27 15:09:32',903200,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.135ms, lost 0%','rta=0.135ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276629999,2,23553,0,0,1,10,1,1,'2024-12-27 15:09:40',28718,'2024-12-27 15:09:41',175187,26989,'','',30,0,1.104,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630000,2,28533,0,0,1,1,1,1,'2024-12-27 15:09:45',215973,'2024-12-27 15:09:47',225809,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630001,2,21396,0,0,1,5,0,1,'2024-12-27 15:09:47',228260,'2024-12-27 15:09:50',249583,26989,'','',30,0,0.02756,0.228,0,'OK - 192.168.77.159: rta 1.072ms, lost 0%','rta=1.072ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630002,2,23552,0,0,1,1,0,1,'2024-12-27 15:09:50',249651,'2024-12-27 15:09:50',260317,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.116ms, lost 0%','rta=0.116ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630003,2,23554,0,0,1,1,0,1,'2024-12-27 15:09:50',260879,'2024-12-27 15:09:50',270813,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.147ms, lost 0%','rta=0.147ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630004,2,21395,0,0,1,5,1,1,'2024-12-27 15:09:50',271612,'2024-12-27 15:09:51',244789,26989,'','',30,0,0.973,0,1,'CRITICAL - 192.168.77.154: Host unreachable @ 192.168.77.9. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630005,2,23553,0,0,1,10,1,1,'2024-12-27 15:09:55',259673,'2024-12-27 15:10:00',272277,26989,'','',30,0,2.00816,0.259,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630006,2,23551,0,0,1,1,0,1,'2024-12-27 15:10:05',294267,'2024-12-27 15:10:05',305383,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630007,2,28533,0,0,1,1,1,1,'2024-12-27 15:10:05',305731,'2024-12-27 15:10:07',313992,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630008,2,23551,0,0,1,1,0,1,'2024-12-27 15:10:07',316604,'2024-12-27 15:10:10',344524,26989,'','',30,0,0.00997,2.316,0,'OK - 192.168.77.29: rta 0.183ms, lost 0%','rta=0.183ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630009,2,28279,0,0,1,1,0,1,'2024-12-27 15:10:10',344804,'2024-12-27 15:10:10',352666,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.016ms, lost 0%','rta=0.016ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630010,2,23552,0,0,1,1,0,1,'2024-12-27 15:10:15',387506,'2024-12-27 15:10:15',398307,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.114ms, lost 0%','rta=0.114ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630011,2,23552,0,0,1,1,0,1,'2024-12-27 15:10:15',400917,'2024-12-27 15:10:20',434956,26989,'','',30,0,0.01041,0.4,0,'OK - 192.168.77.8: rta 0.209ms, lost 0%','rta=0.209ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630012,2,23549,0,0,1,10,0,1,'2024-12-27 15:10:15',403880,'2024-12-27 15:10:20',435201,26989,'','',30,0,0.01344,0.403,0,'OK - 84.38.95.222: rta 0.302ms, lost 0%','rta=0.302ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630013,2,21396,0,0,1,5,0,1,'2024-12-27 15:10:20',435265,'2024-12-27 15:10:20',456810,26989,'','',30,0,0.021,0,0,'OK - 192.168.77.159: rta 0.714ms, lost 0%','rta=0.714ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630014,2,23553,0,0,1,10,1,1,'2024-12-27 15:10:20',457148,'2024-12-27 15:10:22',466066,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630015,2,23554,0,0,1,1,0,1,'2024-12-27 15:10:25',489483,'2024-12-27 15:10:25',499630,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.147ms, lost 0%','rta=0.147ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630016,2,28279,0,0,1,1,0,1,'2024-12-27 15:10:22',468910,'2024-12-27 15:10:25',500142,26989,'','',30,0,0.00617,2.468,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630017,2,21397,0,0,1,5,1,1,'2024-12-27 15:10:27',506205,'2024-12-27 15:10:30',518306,26989,'','',30,0,2.00754,0.506,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630018,2,23548,0,0,1,5,1,1,'2024-12-27 15:10:27',509233,'2024-12-27 15:10:30',518559,26989,'','',30,0,2.0075,0.509,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630019,2,23554,0,0,1,1,0,1,'2024-12-27 15:10:32',526220,'2024-12-27 15:10:35',558788,26989,'','',30,0,0.00954,0.526,0,'OK - 192.168.77.208: rta 0.163ms, lost 0%','rta=0.163ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630020,2,21395,0,0,1,5,1,1,'2024-12-27 15:10:32',527880,'2024-12-27 15:10:35',559042,26989,'','',30,0,2.00741,0.527,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630021,2,28533,0,0,1,1,1,1,'2024-12-27 15:10:32',528912,'2024-12-27 15:10:35',559283,26989,'','',30,0,2.01026,0.528,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630022,2,23552,0,0,1,1,0,1,'2024-12-27 15:10:45',613799,'2024-12-27 15:10:45',623458,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.121ms, lost 0%','rta=0.121ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630023,2,23553,0,0,1,10,1,1,'2024-12-27 15:10:45',623806,'2024-12-27 15:10:47',631555,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630024,2,23549,0,0,1,10,0,1,'2024-12-27 15:10:50',670438,'2024-12-27 15:10:50',683650,26989,'','',30,0,0.012,0,0,'OK - 84.38.95.222: rta 0.273ms, lost 0%','rta=0.273ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630025,2,21396,0,0,1,5,0,1,'2024-12-27 15:10:50',686302,'2024-12-27 15:10:55',712703,26989,'','',30,0,0.02343,0.686,0,'OK - 192.168.77.159: rta 0.840ms, lost 0%','rta=0.840ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630026,2,23554,0,0,1,1,0,1,'2024-12-27 15:10:55',712755,'2024-12-27 15:10:55',723324,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630027,2,23551,0,0,1,1,0,1,'2024-12-27 15:10:55',723648,'2024-12-27 15:10:55',733436,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630028,2,23553,0,0,1,10,1,1,'2024-12-27 15:11:00',769010,'2024-12-27 15:11:05',794792,26989,'','',30,0,2.00821,0.768,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630029,2,28533,0,0,1,1,1,1,'2024-12-27 15:11:05',795108,'2024-12-27 15:11:07',804017,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630030,2,23552,0,0,1,1,0,1,'2024-12-27 15:11:10',835513,'2024-12-27 15:11:10',845269,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.106ms, lost 0%','rta=0.106ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630031,2,23551,0,0,1,1,0,1,'2024-12-27 15:11:10',847762,'2024-12-27 15:11:15',877369,26989,'','',30,0,0.00901,0.847,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630032,2,21397,0,0,1,5,1,1,'2024-12-27 15:11:15',877419,'2024-12-27 15:11:17',886624,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630033,2,23553,0,0,1,10,1,1,'2024-12-27 15:11:17',886931,'2024-12-27 15:11:18',885825,26989,'','',30,0,0.999,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630034,2,23554,0,0,1,1,0,1,'2024-12-27 15:11:20',917995,'2024-12-27 15:11:20',928347,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630035,2,23549,0,0,1,10,0,1,'2024-12-27 15:11:20',928664,'2024-12-27 15:11:20',942134,26989,'','',30,0,0.013,0,0,'OK - 84.38.95.222: rta 0.326ms, lost 0%','rta=0.326ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630036,2,23552,0,0,1,1,0,1,'2024-12-27 15:11:20',944566,'2024-12-27 15:11:25',971769,26989,'','',30,0,0.01076,0.944,0,'OK - 192.168.77.8: rta 0.244ms, lost 0%','rta=0.244ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630037,2,23549,0,0,1,10,0,1,'2024-12-27 15:11:20',947577,'2024-12-27 15:11:25',972009,26989,'','',30,0,0.01266,0.947,0,'OK - 84.38.95.222: rta 0.322ms, lost 0%','rta=0.322ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630038,2,28533,0,0,1,1,1,1,'2024-12-27 15:11:25',972287,'2024-12-27 15:11:27',982290,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630039,2,28279,0,0,1,1,0,1,'2024-12-27 15:11:28',1,'2024-12-27 15:11:30',3,26989,'','',30,0,0.01072,3.019,0,'OK - 192.168.77.9: rta 0.016ms, lost 0%','rta=0.016ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630040,2,23551,0,0,1,1,0,1,'2024-12-27 15:11:30',3,'2024-12-27 15:11:30',4,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630041,2,21397,0,0,1,5,1,1,'2024-12-27 15:11:30',21730,'2024-12-27 15:11:35',0,26989,'','',30,0,2.00863,0.052,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630042,2,23548,0,0,1,5,1,1,'2024-12-27 15:11:30',23288,'2024-12-27 15:11:35',0,26989,'','',30,0,2.00858,0.055,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630043,2,23554,0,0,1,1,0,1,'2024-12-27 15:11:35',0,'2024-12-27 15:11:40',107563,26989,'','',30,0,0.01013,0.092,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630044,2,21395,0,0,1,5,1,1,'2024-12-27 15:11:35',0,'2024-12-27 15:11:40',107819,26989,'','',30,0,2.00945,0.095,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630045,2,28533,0,0,1,1,1,1,'2024-12-27 15:11:35',0,'2024-12-27 15:11:40',108066,26989,'','',30,0,2.00814,0.097,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630046,2,23553,0,0,1,10,1,1,'2024-12-27 15:11:45',124657,'2024-12-27 15:11:47',132121,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630047,2,28533,0,0,1,1,1,1,'2024-12-27 15:11:55',171577,'2024-12-27 15:11:57',181080,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630048,2,21396,0,0,1,5,0,1,'2024-12-27 15:11:57',183899,'2024-12-27 15:12:00',201142,26989,'','',30,0,0.0292,2.183,0,'OK - 192.168.77.159: rta 1.113ms, lost 0%','rta=1.113ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630049,2,23551,0,0,1,1,0,1,'2024-12-27 15:12:00',201970,'2024-12-27 15:12:00',212785,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630050,2,23552,0,0,1,1,0,1,'2024-12-27 15:12:05',227011,'2024-12-27 15:12:05',236915,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.109ms, lost 0%','rta=0.109ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630051,2,23553,0,0,1,10,1,1,'2024-12-27 15:12:05',237242,'2024-12-27 15:12:07',246159,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630052,2,23553,0,0,1,10,1,1,'2024-12-27 15:12:07',248917,'2024-12-27 15:12:10',265749,26989,'','',30,0,0.99518,2.248,2,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630053,2,23548,0,0,1,5,1,1,'2024-12-27 15:12:10',265825,'2024-12-27 15:12:12',274328,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630054,2,23554,0,0,1,1,0,1,'2024-12-27 15:12:12',274639,'2024-12-27 15:12:12',284592,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630055,2,23551,0,0,1,1,0,1,'2024-12-27 15:12:15',297590,'2024-12-27 15:12:20',335413,26989,'','',30,0,0.00899,0.297,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630056,2,21395,0,0,1,5,1,1,'2024-12-27 15:12:25',364190,'2024-12-27 15:12:27',373577,26989,'','',30,0,2.009,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630057,2,23552,0,0,1,1,0,1,'2024-12-27 15:12:27',373938,'2024-12-27 15:12:27',383515,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.127ms, lost 0%','rta=0.127ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630058,2,28533,0,0,1,1,1,1,'2024-12-27 15:12:30',421090,'2024-12-27 15:12:32',431907,26989,'','',30,0,2.01,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630059,2,23552,0,0,1,1,0,1,'2024-12-27 15:12:27',386469,'2024-12-27 15:12:32',432464,26989,'','',30,0,0.01312,2.386,0,'OK - 192.168.77.8: rta 0.298ms, lost 0%','rta=0.298ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630060,2,23549,0,0,1,10,0,1,'2024-12-27 15:12:27',389299,'2024-12-27 15:12:32',432711,26989,'','',30,0,0.01803,2.389,0,'OK - 84.38.95.222: rta 0.515ms, lost 0%','rta=0.515ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630061,2,23548,0,0,1,5,1,1,'2024-12-27 15:12:32',433065,'2024-12-27 15:12:34',442237,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630062,2,28279,0,0,1,1,0,1,'2024-12-27 15:12:34',445177,'2024-12-27 15:12:35',465488,26989,'','',30,0,0.00632,4.445,0,'OK - 192.168.77.9: rta 0.014ms, lost 0%','rta=0.014ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630063,2,21397,0,0,1,5,1,1,'2024-12-27 15:12:35',467663,'2024-12-27 15:12:40',498835,26989,'','',30,0,2.00721,0.467,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630064,2,23548,0,0,1,5,1,1,'2024-12-27 15:12:35',470756,'2024-12-27 15:12:40',499104,26989,'','',30,0,2.00722,0.47,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630065,2,23553,0,0,1,10,1,1,'2024-12-27 15:12:40',499176,'2024-12-27 15:12:41',604018,26989,'','',30,0,1.104,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630066,2,23551,0,0,1,1,0,1,'2024-12-27 15:12:41',604345,'2024-12-27 15:12:41',614412,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630067,2,23554,0,0,1,1,0,1,'2024-12-27 15:12:41',617289,'2024-12-27 15:12:45',652229,26989,'','',30,0,0.00879,1.617,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630068,2,28533,0,0,1,1,1,1,'2024-12-27 15:12:41',622236,'2024-12-27 15:12:45',652518,26989,'','',30,0,0.52537,1.622,2,'CRITICAL - 172.50.1.3: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630069,2,21395,0,0,1,5,1,1,'2024-12-27 15:12:41',620320,'2024-12-27 15:12:45',652775,26989,'','',30,0,2.00772,1.62,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630070,2,23552,0,0,1,1,0,1,'2024-12-27 15:12:50',682267,'2024-12-27 15:12:50',698777,26989,'','',30,0,0.016,0,0,'OK - 192.168.77.8: rta 0.139ms, lost 0%','rta=0.139ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630071,2,23554,0,0,1,1,0,1,'2024-12-27 15:13:00',748603,'2024-12-27 15:13:00',759728,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630072,2,21396,0,0,1,5,0,1,'2024-12-27 15:13:00',772370,'2024-12-27 15:13:05',802477,26989,'','',30,0,0.0282,0.772,0,'OK - 192.168.77.159: rta 1.080ms, lost 0%','rta=1.080ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630073,2,23551,0,0,1,1,0,1,'2024-12-27 15:13:05',802551,'2024-12-27 15:13:05',813295,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630074,2,28533,0,0,1,1,1,1,'2024-12-27 15:13:05',813611,'2024-12-27 15:13:07',822324,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630075,2,28279,0,0,1,1,0,1,'2024-12-27 15:13:10',855830,'2024-12-27 15:13:10',863768,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630076,2,23553,0,0,1,10,1,1,'2024-12-27 15:13:10',866209,'2024-12-27 15:13:15',905527,26989,'','',30,0,2.00668,0.866,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630077,2,23552,0,0,1,1,0,1,'2024-12-27 15:13:15',905595,'2024-12-27 15:13:15',917271,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.8: rta 0.159ms, lost 0%','rta=0.159ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630078,2,21396,0,0,1,5,0,1,'2024-12-27 15:13:20',943406,'2024-12-27 15:13:20',965514,26989,'','',30,0,0.021,0,0,'OK - 192.168.77.159: rta 0.713ms, lost 0%','rta=0.713ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630079,2,23551,0,0,1,1,0,1,'2024-12-27 15:13:20',968473,'2024-12-27 15:13:25',990489,26989,'','',30,0,0.0089,0.968,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630080,2,23554,0,0,1,1,0,1,'2024-12-27 15:13:25',990562,'2024-12-27 15:13:26',94,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630081,2,23552,0,0,1,1,0,1,'2024-12-27 15:13:32',1,'2024-12-27 15:13:35',12933,26989,'','',30,0,0.00949,0.018,0,'OK - 192.168.77.8: rta 0.137ms, lost 0%','rta=0.137ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630082,2,23549,0,0,1,10,0,1,'2024-12-27 15:13:32',1,'2024-12-27 15:13:35',13078,26989,'','',30,0,0.01267,0.019,0,'OK - 84.38.95.222: rta 0.256ms, lost 0%','rta=0.256ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630083,2,28279,0,0,1,1,0,1,'2024-12-27 15:13:35',27,'2024-12-27 15:13:40',4,26989,'','',30,0,0.00662,0.033,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630084,2,21397,0,0,1,5,1,1,'2024-12-27 15:13:40',21078,'2024-12-27 15:13:45',6,26989,'','',30,0,0.66631,0.051,2,'CRITICAL - 172.20.3.10: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630085,2,23548,0,0,1,5,1,1,'2024-12-27 15:13:40',356,'2024-12-27 15:13:45',6,26989,'','',30,0,0.66344,0.054,2,'CRITICAL - 172.20.3.11: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630086,2,23553,0,0,1,10,1,1,'2024-12-27 15:13:45',6,'2024-12-27 15:13:47',508,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630087,2,23554,0,0,1,1,0,1,'2024-12-27 15:13:47',7,'2024-12-27 15:13:50',100590,26989,'','',30,0,0.01096,2.079,0,'OK - 192.168.77.208: rta 0.251ms, lost 0%','rta=0.251ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630088,2,23549,0,0,1,10,0,1,'2024-12-27 15:13:50',100900,'2024-12-27 15:13:50',112885,26989,'','',30,0,0.011,0,0,'OK - 84.38.95.222: rta 0.230ms, lost 0%','rta=0.230ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630089,2,28533,0,0,1,1,1,1,'2024-12-27 15:13:47',0,'2024-12-27 15:13:50',113385,26989,'','',30,0,2.00883,2.082,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630090,2,21395,0,0,1,5,1,1,'2024-12-27 15:13:47',0,'2024-12-27 15:13:50',113626,26989,'','',30,0,2.00828,2.086,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630091,2,23551,0,0,1,1,0,1,'2024-12-27 15:13:55',129526,'2024-12-27 15:13:55',140059,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630092,2,28533,0,0,1,1,1,1,'2024-12-27 15:14:05',175823,'2024-12-27 15:14:07',184048,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630093,2,21396,0,0,1,5,0,1,'2024-12-27 15:14:07',186536,'2024-12-27 15:14:10',198717,26989,'','',30,0,0.02065,2.186,0,'OK - 192.168.77.159: rta 0.721ms, lost 0%','rta=0.721ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630094,2,23552,0,0,1,1,0,1,'2024-12-27 15:14:10',198781,'2024-12-27 15:14:10',209089,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.127ms, lost 0%','rta=0.127ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630095,2,21397,0,0,1,5,1,1,'2024-12-27 15:14:15',239913,'2024-12-27 15:14:17',248872,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630096,2,23553,0,0,1,10,1,1,'2024-12-27 15:14:17',249187,'2024-12-27 15:14:18',249008,26989,'','',30,0,1,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630097,2,23554,0,0,1,1,0,1,'2024-12-27 15:14:20',270520,'2024-12-27 15:14:20',281838,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630098,2,23549,0,0,1,10,0,1,'2024-12-27 15:14:20',282172,'2024-12-27 15:14:20',293549,26989,'','',30,0,0.011,0,0,'OK - 84.38.95.222: rta 0.231ms, lost 0%','rta=0.231ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630099,2,23553,0,0,1,10,1,1,'2024-12-27 15:14:18',251470,'2024-12-27 15:14:25',321699,26989,'','',30,0,2.00775,3.251,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630100,2,28533,0,0,1,1,1,1,'2024-12-27 15:14:25',321980,'2024-12-27 15:14:27',331596,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630101,2,23551,0,0,1,1,0,1,'2024-12-27 15:14:27',334384,'2024-12-27 15:14:30',369714,26989,'','',30,0,0.01022,2.334,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630102,2,28279,0,0,1,1,0,1,'2024-12-27 15:14:35',396761,'2024-12-27 15:14:35',405239,26989,'','',30,0,0.008,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630103,2,23552,0,0,1,1,0,1,'2024-12-27 15:14:35',405645,'2024-12-27 15:14:35',415756,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.121ms, lost 0%','rta=0.121ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630104,2,23552,0,0,1,1,0,1,'2024-12-27 15:14:35',418357,'2024-12-27 15:14:40',457163,26989,'','',30,0,0.00954,0.418,0,'OK - 192.168.77.8: rta 0.124ms, lost 0%','rta=0.124ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630105,2,23549,0,0,1,10,0,1,'2024-12-27 15:14:35',420599,'2024-12-27 15:14:40',457403,26989,'','',30,0,0.01642,0.42,0,'OK - 84.38.95.222: rta 0.466ms, lost 0%','rta=0.466ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630106,2,28279,0,0,1,1,0,1,'2024-12-27 15:14:40',462613,'2024-12-27 15:14:45',497064,26989,'','',30,0,0.00705,0.462,0,'OK - 192.168.77.9: rta 0.017ms, lost 0%','rta=0.017ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630107,2,21397,0,0,1,5,1,1,'2024-12-27 15:14:45',497141,'2024-12-27 15:14:47',506250,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630108,2,23553,0,0,1,10,1,1,'2024-12-27 15:14:47',506609,'2024-12-27 15:14:48',505495,26989,'','',30,0,0.999,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630109,2,23554,0,0,1,1,0,1,'2024-12-27 15:14:48',506082,'2024-12-27 15:14:48',516039,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630110,2,21397,0,0,1,5,1,1,'2024-12-27 15:14:48',518639,'2024-12-27 15:14:50',540737,26989,'','',30,0,2.00769,3.518,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630111,2,23548,0,0,1,5,1,1,'2024-12-27 15:14:48',521259,'2024-12-27 15:14:50',540990,26989,'','',30,0,2.00863,3.521,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630112,2,23554,0,0,1,1,0,1,'2024-12-27 15:14:50',543224,'2024-12-27 15:14:55',574847,26989,'','',30,0,0.01086,0.543,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630113,2,28533,0,0,1,1,1,1,'2024-12-27 15:14:55',574913,'2024-12-27 15:14:56',634866,26989,'','',30,0,1.059,0,1,'CRITICAL - 172.50.1.3: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630114,2,28533,0,0,1,1,1,1,'2024-12-27 15:14:50',544673,'2024-12-27 15:14:56',635382,26989,'','',30,0,1.08895,0.544,2,'CRITICAL - 172.50.1.3: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630115,2,21395,0,0,1,5,1,1,'2024-12-27 15:14:50',547016,'2024-12-27 15:14:56',635615,26989,'','',30,0,2.00813,0.546,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630116,2,23551,0,0,1,1,0,1,'2024-12-27 15:15:00',670577,'2024-12-27 15:15:00',680534,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630117,2,23552,0,0,1,1,0,1,'2024-12-27 15:15:05',714614,'2024-12-27 15:15:05',724159,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.127ms, lost 0%','rta=0.127ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630118,2,23553,0,0,1,10,1,1,'2024-12-27 15:15:05',724747,'2024-12-27 15:15:07',733048,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630119,2,23548,0,0,1,5,1,1,'2024-12-27 15:15:10',758378,'2024-12-27 15:15:12',768234,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630120,2,23554,0,0,1,1,0,1,'2024-12-27 15:15:12',768546,'2024-12-27 15:15:12',778532,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630121,2,21396,0,0,1,5,0,1,'2024-12-27 15:15:12',780966,'2024-12-27 15:15:15',806260,26989,'','',30,0,0.02828,2.78,0,'OK - 192.168.77.159: rta 1.123ms, lost 0%','rta=1.123ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630122,2,21395,0,0,1,5,1,1,'2024-12-27 15:15:25',875256,'2024-12-27 15:15:27',884183,26989,'','',30,0,2.008,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630123,2,23552,0,0,1,1,0,1,'2024-12-27 15:15:27',884576,'2024-12-27 15:15:27',894060,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.123ms, lost 0%','rta=0.123ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630124,2,23551,0,0,1,1,0,1,'2024-12-27 15:15:27',894405,'2024-12-27 15:15:27',904286,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630125,2,28533,0,0,1,1,1,1,'2024-12-27 15:15:30',2,'2024-12-27 15:15:32',3,26989,'','',30,0,2.01,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630126,2,23553,0,0,1,10,1,1,'2024-12-27 15:15:28',2405,'2024-12-27 15:15:32',3,26989,'','',30,0,2.01119,3.004,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630127,2,23548,0,0,1,5,1,1,'2024-12-27 15:15:32',3,'2024-12-27 15:15:34',39,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630128,2,23551,0,0,1,1,0,1,'2024-12-27 15:15:34',20809,'2024-12-27 15:15:35',24105,26989,'','',30,0,0.01001,4.05,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630129,2,23552,0,0,1,1,0,1,'2024-12-27 15:15:40',0,'2024-12-27 15:15:45',107284,26989,'','',30,0,0.01025,0.085,0,'OK - 192.168.77.8: rta 0.141ms, lost 0%','rta=0.141ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630130,2,23549,0,0,1,10,0,1,'2024-12-27 15:15:40',0,'2024-12-27 15:15:45',107541,26989,'','',30,0,0.01255,0.088,0,'OK - 84.38.95.222: rta 0.288ms, lost 0%','rta=0.288ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630131,2,28279,0,0,1,1,0,1,'2024-12-27 15:15:45',110274,'2024-12-27 15:15:50',154544,26989,'','',30,0,0.007,0.11,0,'OK - 192.168.77.9: rta 0.014ms, lost 0%','rta=0.014ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630132,2,23553,0,0,1,10,1,1,'2024-12-27 15:15:50',155373,'2024-12-27 15:15:51',214227,26989,'','',30,0,1.058,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630133,2,23554,0,0,1,1,0,1,'2024-12-27 15:15:51',214521,'2024-12-27 15:15:51',224678,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630134,2,21395,0,0,1,5,1,1,'2024-12-27 15:15:55',238278,'2024-12-27 15:15:57',247321,26989,'','',30,0,2.008,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630135,2,21397,0,0,1,5,1,1,'2024-12-27 15:15:51',227258,'2024-12-27 15:15:57',248098,26989,'','',30,0,2.00913,1.227,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630136,2,23548,0,0,1,5,1,1,'2024-12-27 15:15:51',228881,'2024-12-27 15:15:57',248338,26989,'','',30,0,2.00852,1.228,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630137,2,23552,0,0,1,1,0,1,'2024-12-27 15:16:00',265360,'2024-12-27 15:16:00',276284,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.131ms, lost 0%','rta=0.131ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630138,2,23554,0,0,1,1,0,1,'2024-12-27 15:15:57',250860,'2024-12-27 15:16:00',276737,26989,'','',30,0,0.01206,2.25,0,'OK - 192.168.77.208: rta 0.288ms, lost 0%','rta=0.288ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630139,2,21395,0,0,1,5,1,1,'2024-12-27 15:15:57',257291,'2024-12-27 15:16:00',276949,26989,'','',30,0,0.98822,1.257,2,'CRITICAL - 192.168.77.154: Host unreachable @ 192.168.77.9. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630140,2,28533,0,0,1,1,1,1,'2024-12-27 15:15:57',254151,'2024-12-27 15:16:00',277363,26989,'','',30,0,2.00762,1.254,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630141,2,23551,0,0,1,1,0,1,'2024-12-27 15:16:05',303083,'2024-12-27 15:16:05',314460,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.29: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630142,2,28279,0,0,1,1,0,1,'2024-12-27 15:16:10',331131,'2024-12-27 15:16:10',338863,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630143,2,21396,0,0,1,5,0,1,'2024-12-27 15:16:15',356380,'2024-12-27 15:16:20',395726,26989,'','',30,0,0.02791,0.356,0,'OK - 192.168.77.159: rta 1.073ms, lost 0%','rta=1.073ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630144,2,23553,0,0,1,10,1,1,'2024-12-27 15:16:20',396044,'2024-12-27 15:16:22',404683,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630145,2,23554,0,0,1,1,0,1,'2024-12-27 15:16:25',430852,'2024-12-27 15:16:25',440861,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630146,2,23553,0,0,1,10,1,1,'2024-12-27 15:16:32',473220,'2024-12-27 15:16:35',487742,26989,'','',30,0,2.00791,0.473,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630147,2,23551,0,0,1,1,0,1,'2024-12-27 15:16:35',490268,'2024-12-27 15:16:40',525733,26989,'','',30,0,0.00898,0.49,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630148,2,23552,0,0,1,1,0,1,'2024-12-27 15:16:45',559419,'2024-12-27 15:16:45',569819,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.120ms, lost 0%','rta=0.120ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630149,2,23552,0,0,1,1,0,1,'2024-12-27 15:16:45',572753,'2024-12-27 15:16:50',609978,26989,'','',30,0,0.01143,0.572,0,'OK - 192.168.77.8: rta 0.134ms, lost 0%','rta=0.134ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630150,2,23549,0,0,1,10,0,1,'2024-12-27 15:16:45',574109,'2024-12-27 15:16:50',610196,26989,'','',30,0,0.01407,0.574,0,'OK - 84.38.95.222: rta 0.401ms, lost 0%','rta=0.401ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630151,2,28279,0,0,1,1,0,1,'2024-12-27 15:16:50',612963,'2024-12-27 15:16:55',643317,26989,'','',30,0,0.00752,0.612,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630152,2,23554,0,0,1,1,0,1,'2024-12-27 15:16:55',643377,'2024-12-27 15:16:55',653826,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630153,2,23551,0,0,1,1,0,1,'2024-12-27 15:16:55',654134,'2024-12-27 15:16:55',663880,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630154,2,21397,0,0,1,5,1,1,'2024-12-27 15:16:57',673382,'2024-12-27 15:17:00',703425,26989,'','',30,0,2.00823,0.673,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630155,2,23548,0,0,1,5,1,1,'2024-12-27 15:16:57',677174,'2024-12-27 15:17:00',703670,26989,'','',30,0,2.00738,0.677,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630156,2,23554,0,0,1,1,0,1,'2024-12-27 15:17:00',706516,'2024-12-27 15:17:05',749282,26989,'','',30,0,0.0134,0.706,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630157,2,21395,0,0,1,5,1,1,'2024-12-27 15:17:00',707964,'2024-12-27 15:17:05',749538,26989,'','',30,0,2.00821,0.707,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630158,2,28533,0,0,1,1,1,1,'2024-12-27 15:17:00',710907,'2024-12-27 15:17:05',749809,26989,'','',30,0,2.00847,0.71,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630159,2,23552,0,0,1,1,0,1,'2024-12-27 15:17:10',783788,'2024-12-27 15:17:10',794577,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.130ms, lost 0%','rta=0.130ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630160,2,21397,0,0,1,5,1,1,'2024-12-27 15:17:15',816774,'2024-12-27 15:17:17',826439,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630161,2,23553,0,0,1,10,1,1,'2024-12-27 15:17:17',826760,'2024-12-27 15:17:18',825631,26989,'','',30,0,0.999,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630162,2,23554,0,0,1,1,0,1,'2024-12-27 15:17:20',852572,'2024-12-27 15:17:20',863034,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630163,2,23549,0,0,1,10,0,1,'2024-12-27 15:17:20',863362,'2024-12-27 15:17:20',874410,26989,'','',30,0,0.01,0,0,'OK - 84.38.95.222: rta 0.208ms, lost 0%','rta=0.208ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630164,2,21396,0,0,1,5,0,1,'2024-12-27 15:17:20',876865,'2024-12-27 15:17:25',904624,26989,'','',30,0,0.02002,0.876,0,'OK - 192.168.77.159: rta 0.709ms, lost 0%','rta=0.709ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630165,2,28533,0,0,1,1,1,1,'2024-12-27 15:17:25',904967,'2024-12-27 15:17:27',914772,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630166,2,23551,0,0,1,1,0,1,'2024-12-27 15:17:30',17678,'2024-12-27 15:17:30',22192,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630167,2,28279,0,0,1,1,0,1,'2024-12-27 15:17:35',30274,'2024-12-27 15:17:35',0,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630168,2,23552,0,0,1,1,0,1,'2024-12-27 15:17:35',0,'2024-12-27 15:17:35',0,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.133ms, lost 0%','rta=0.133ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630169,2,23553,0,0,1,10,1,1,'2024-12-27 15:17:35',0,'2024-12-27 15:17:40',102564,26989,'','',30,0,0.07829,0.093,2,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630170,2,23551,0,0,1,1,0,1,'2024-12-27 15:17:40',108764,'2024-12-27 15:17:45',124037,26989,'','',30,0,0.00996,0.108,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630171,2,21397,0,0,1,5,1,1,'2024-12-27 15:17:45',124107,'2024-12-27 15:17:47',151054,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630172,2,23554,0,0,1,1,0,1,'2024-12-27 15:17:47',151915,'2024-12-27 15:17:47',162318,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.154ms, lost 0%','rta=0.154ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630173,2,23552,0,0,1,1,0,1,'2024-12-27 15:17:50',174690,'2024-12-27 15:17:55',195545,26989,'','',30,0,0.00981,0.174,0,'OK - 192.168.77.8: rta 0.126ms, lost 0%','rta=0.126ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630174,2,23549,0,0,1,10,0,1,'2024-12-27 15:17:50',177638,'2024-12-27 15:17:55',195768,26989,'','',30,0,0.01227,0.177,0,'OK - 84.38.95.222: rta 0.285ms, lost 0%','rta=0.285ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630175,2,28533,0,0,1,1,1,1,'2024-12-27 15:17:55',195831,'2024-12-27 15:17:56',277684,26989,'','',30,0,1.081,0,1,'CRITICAL - 172.50.1.3: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630176,2,28279,0,0,1,1,0,1,'2024-12-27 15:17:56',280171,'2024-12-27 15:18:00',303869,26989,'','',30,0,0.00613,1.28,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630177,2,23551,0,0,1,1,0,1,'2024-12-27 15:18:00',304468,'2024-12-27 15:18:00',315060,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630178,2,21397,0,0,1,5,1,1,'2024-12-27 15:18:00',317905,'2024-12-27 15:18:05',335201,26989,'','',30,0,2.00753,0.317,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630179,2,23548,0,0,1,5,1,1,'2024-12-27 15:18:00',320952,'2024-12-27 15:18:05',335459,26989,'','',30,0,2.00749,0.32,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630180,2,23553,0,0,1,10,1,1,'2024-12-27 15:18:05',335803,'2024-12-27 15:18:07',345407,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630181,2,23554,0,0,1,1,0,1,'2024-12-27 15:18:07',348274,'2024-12-27 15:18:10',366180,26989,'','',30,0,0.0123,2.348,0,'OK - 192.168.77.208: rta 0.274ms, lost 0%','rta=0.274ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630182,2,21395,0,0,1,5,1,1,'2024-12-27 15:18:07',351041,'2024-12-27 15:18:10',366895,26989,'','',30,0,2.0093,2.351,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630183,2,28533,0,0,1,1,1,1,'2024-12-27 15:18:07',352039,'2024-12-27 15:18:10',367130,26989,'','',30,0,2.00958,2.351,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630184,2,21395,0,0,1,5,1,1,'2024-12-27 15:18:25',451518,'2024-12-27 15:18:27',459674,26989,'','',30,0,2.007,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630185,2,23552,0,0,1,1,0,1,'2024-12-27 15:18:27',460001,'2024-12-27 15:18:27',469831,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.145ms, lost 0%','rta=0.145ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630186,2,23551,0,0,1,1,0,1,'2024-12-27 15:18:27',470158,'2024-12-27 15:18:27',480011,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630187,2,28533,0,0,1,1,1,1,'2024-12-27 15:18:30',513154,'2024-12-27 15:18:32',524018,26989,'','',30,0,2.01,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630188,2,21396,0,0,1,5,0,1,'2024-12-27 15:18:27',482559,'2024-12-27 15:18:32',524555,26989,'','',30,0,0.0226,2.482,0,'OK - 192.168.77.159: rta 0.838ms, lost 0%','rta=0.838ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630189,2,23548,0,0,1,5,1,1,'2024-12-27 15:18:32',525153,'2024-12-27 15:18:34',534296,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630190,2,23553,0,0,1,10,1,1,'2024-12-27 15:18:40',599524,'2024-12-27 15:18:41',682465,26989,'','',30,0,1.082,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630191,2,23553,0,0,1,10,1,1,'2024-12-27 15:18:41',685343,'2024-12-27 15:18:45',720306,26989,'','',30,0,2.00729,1.685,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630192,2,23551,0,0,1,1,0,1,'2024-12-27 15:18:45',723028,'2024-12-27 15:18:50',767640,26989,'','',30,0,0.0099,0.723,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630193,2,23552,0,0,1,1,0,1,'2024-12-27 15:18:50',767717,'2024-12-27 15:18:50',778488,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.125ms, lost 0%','rta=0.125ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630194,2,23554,0,0,1,1,0,1,'2024-12-27 15:18:50',779328,'2024-12-27 15:18:50',789282,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630195,2,21395,0,0,1,5,1,1,'2024-12-27 15:18:50',789846,'2024-12-27 15:18:51',744126,26989,'','',30,0,0.955,0,1,'CRITICAL - 192.168.77.154: Host unreachable @ 192.168.77.9. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630196,2,23552,0,0,1,1,0,1,'2024-12-27 15:18:55',787158,'2024-12-27 15:19:00',819051,26989,'','',30,0,0.00941,0.787,0,'OK - 192.168.77.8: rta 0.133ms, lost 0%','rta=0.133ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630197,2,23549,0,0,1,10,0,1,'2024-12-27 15:18:55',790710,'2024-12-27 15:19:00',819286,26989,'','',30,0,0.01146,0.79,0,'OK - 84.38.95.222: rta 0.251ms, lost 0%','rta=0.251ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630198,2,28279,0,0,1,1,0,1,'2024-12-27 15:19:00',832311,'2024-12-27 15:19:05',850066,26989,'','',30,0,0.00681,0.832,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630199,2,23551,0,0,1,1,0,1,'2024-12-27 15:19:05',850140,'2024-12-27 15:19:05',860957,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630200,2,28533,0,0,1,1,1,1,'2024-12-27 15:19:05',861300,'2024-12-27 15:19:07',870197,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630201,2,21397,0,0,1,5,1,1,'2024-12-27 15:19:07',892986,'2024-12-27 15:19:10',931718,26989,'','',30,0,2.00749,2.892,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630202,2,23548,0,0,1,5,1,1,'2024-12-27 15:19:07',896168,'2024-12-27 15:19:10',931926,26989,'','',30,0,2.00831,2.896,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630203,2,23554,0,0,1,1,0,1,'2024-12-27 15:19:10',934112,'2024-12-27 15:19:15',967085,26989,'','',30,0,0.01119,0.934,0,'OK - 192.168.77.208: rta 0.243ms, lost 0%','rta=0.243ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630204,2,21395,0,0,1,5,1,1,'2024-12-27 15:19:10',937567,'2024-12-27 15:19:15',967292,26989,'','',30,0,2.00916,0.937,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630205,2,28533,0,0,1,1,1,1,'2024-12-27 15:19:10',940926,'2024-12-27 15:19:15',967496,26989,'','',30,0,2.00875,0.94,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630206,2,23552,0,0,1,1,0,1,'2024-12-27 15:19:15',967546,'2024-12-27 15:19:15',977384,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.119ms, lost 0%','rta=0.119ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630207,2,21396,0,0,1,5,0,1,'2024-12-27 15:19:21',5770,'2024-12-27 15:19:21',2269,26989,'','',30,0,0.029,0,0,'OK - 192.168.77.159: rta 1.141ms, lost 0%','rta=1.141ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630208,2,23553,0,0,1,10,1,1,'2024-12-27 15:19:21',286,'2024-12-27 15:19:23',21465,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630209,2,21396,0,0,1,5,0,1,'2024-12-27 15:19:32',32289,'2024-12-27 15:19:35',0,26989,'','',30,0,0.02045,0.077,0,'OK - 192.168.77.159: rta 0.709ms, lost 0%','rta=0.709ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630210,2,23552,0,0,1,1,0,1,'2024-12-27 15:19:45',149264,'2024-12-27 15:19:45',160648,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.8: rta 0.164ms, lost 0%','rta=0.164ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630211,2,23553,0,0,1,10,1,1,'2024-12-27 15:19:45',161010,'2024-12-27 15:19:47',170321,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630212,2,23553,0,0,1,10,1,1,'2024-12-27 15:19:47',173030,'2024-12-27 15:19:50',207646,26989,'','',30,0,0.9952,2.172,2,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630213,2,23549,0,0,1,10,0,1,'2024-12-27 15:19:50',207993,'2024-12-27 15:19:50',220109,26989,'','',30,0,0.011,0,0,'OK - 84.38.95.222: rta 0.202ms, lost 0%','rta=0.202ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630214,2,23551,0,0,1,1,0,1,'2024-12-27 15:19:50',222761,'2024-12-27 15:19:55',249600,26989,'','',30,0,0.00963,0.222,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630215,2,23554,0,0,1,1,0,1,'2024-12-27 15:19:55',249658,'2024-12-27 15:19:55',259969,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630216,2,23552,0,0,1,1,0,1,'2024-12-27 15:20:00',295837,'2024-12-27 15:20:05',325435,26989,'','',30,0,0.00961,0.295,0,'OK - 192.168.77.8: rta 0.133ms, lost 0%','rta=0.133ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630217,2,23549,0,0,1,10,0,1,'2024-12-27 15:20:00',299372,'2024-12-27 15:20:05',325656,26989,'','',30,0,0.01157,0.299,0,'OK - 84.38.95.222: rta 0.231ms, lost 0%','rta=0.231ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630218,2,28533,0,0,1,1,1,1,'2024-12-27 15:20:05',325981,'2024-12-27 15:20:07',334073,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630219,2,28279,0,0,1,1,0,1,'2024-12-27 15:20:07',336615,'2024-12-27 15:20:10',371500,26989,'','',30,0,0.00644,2.336,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630220,2,21397,0,0,1,5,1,1,'2024-12-27 15:20:10',374121,'2024-12-27 15:20:15',403675,26989,'','',30,0,2.00856,0.374,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630221,2,23548,0,0,1,5,1,1,'2024-12-27 15:20:10',377937,'2024-12-27 15:20:15',403915,26989,'','',30,0,2.00775,0.377,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630222,2,23553,0,0,1,10,1,1,'2024-12-27 15:20:15',404217,'2024-12-27 15:20:17',412927,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630223,2,23554,0,0,1,1,0,1,'2024-12-27 15:20:17',415439,'2024-12-27 15:20:20',449125,26989,'','',30,0,0.00992,2.415,0,'OK - 192.168.77.208: rta 0.185ms, lost 0%','rta=0.185ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630224,2,23549,0,0,1,10,0,1,'2024-12-27 15:20:20',449523,'2024-12-27 15:20:20',464602,26989,'','',30,0,0.014,0,0,'OK - 84.38.95.222: rta 0.340ms, lost 0%','rta=0.340ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630225,2,21395,0,0,1,5,1,1,'2024-12-27 15:20:17',418344,'2024-12-27 15:20:20',465135,26989,'','',30,0,2.00706,2.418,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630226,2,28533,0,0,1,1,1,1,'2024-12-27 15:20:17',421877,'2024-12-27 15:20:20',465393,26989,'','',30,0,2.00878,2.421,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630227,2,23551,0,0,1,1,0,1,'2024-12-27 15:20:30',526298,'2024-12-27 15:20:30',537164,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630228,2,28279,0,0,1,1,0,1,'2024-12-27 15:20:35',561750,'2024-12-27 15:20:35',569347,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.016ms, lost 0%','rta=0.016ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630229,2,23552,0,0,1,1,0,1,'2024-12-27 15:20:35',569649,'2024-12-27 15:20:35',578844,26989,'','',30,0,0.008,0,0,'OK - 192.168.77.8: rta 0.124ms, lost 0%','rta=0.124ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630230,2,21396,0,0,1,5,0,1,'2024-12-27 15:20:35',581255,'2024-12-27 15:20:40',620378,26989,'','',30,0,0.02451,0.581,0,'OK - 192.168.77.159: rta 0.934ms, lost 0%','rta=0.934ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630231,2,21397,0,0,1,5,1,1,'2024-12-27 15:20:45',655433,'2024-12-27 15:20:47',665351,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630232,2,23553,0,0,1,10,1,1,'2024-12-27 15:20:47',665655,'2024-12-27 15:20:48',664799,26989,'','',30,0,0.999,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630233,2,23554,0,0,1,1,0,1,'2024-12-27 15:20:48',665343,'2024-12-27 15:20:48',675230,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630234,2,28533,0,0,1,1,1,1,'2024-12-27 15:20:55',725565,'2024-12-27 15:20:56',788766,26989,'','',30,0,1.062,0,1,'CRITICAL - 172.50.1.3: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630235,2,23553,0,0,1,10,1,1,'2024-12-27 15:20:50',699544,'2024-12-27 15:20:56',789325,26989,'','',30,0,2.00968,0.699,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630236,2,23551,0,0,1,1,0,1,'2024-12-27 15:20:56',791658,'2024-12-27 15:21:00',832988,26989,'','',30,0,0.00909,1.791,0,'OK - 192.168.77.29: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630237,2,23552,0,0,1,1,0,1,'2024-12-27 15:21:05',870238,'2024-12-27 15:21:05',880125,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.134ms, lost 0%','rta=0.134ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630238,2,23552,0,0,1,1,0,1,'2024-12-27 15:21:05',883043,'2024-12-27 15:21:10',921354,26989,'','',30,0,0.00817,0.883,0,'OK - 192.168.77.8: rta 0.115ms, lost 0%','rta=0.115ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630239,2,23549,0,0,1,10,0,1,'2024-12-27 15:21:05',886060,'2024-12-27 15:21:10',921564,26989,'','',30,0,0.01342,0.886,0,'OK - 84.38.95.222: rta 0.356ms, lost 0%','rta=0.356ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630240,2,23548,0,0,1,5,1,1,'2024-12-27 15:21:10',921616,'2024-12-27 15:21:12',930680,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630241,2,23554,0,0,1,1,0,1,'2024-12-27 15:21:12',930962,'2024-12-27 15:21:12',940924,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630242,2,28279,0,0,1,1,0,1,'2024-12-27 15:21:12',943434,'2024-12-27 15:21:15',965824,26989,'','',30,0,0.00649,2.943,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630243,2,21397,0,0,1,5,1,1,'2024-12-27 15:21:15',968258,'2024-12-27 15:21:20',997736,26989,'','',30,0,2.00853,0.968,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630244,2,23548,0,0,1,5,1,1,'2024-12-27 15:21:15',970929,'2024-12-27 15:21:20',997943,26989,'','',30,0,2.00781,0.97,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630245,2,23554,0,0,1,1,0,1,'2024-12-27 15:21:21',7,'2024-12-27 15:21:25',11088,26989,'','',30,0,0.00939,1.007,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630246,2,21395,0,0,1,5,1,1,'2024-12-27 15:21:25',173,'2024-12-27 15:21:27',15062,26989,'','',30,0,2.009,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630247,2,23552,0,0,1,1,0,1,'2024-12-27 15:21:27',15286,'2024-12-27 15:21:27',299,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.129ms, lost 0%','rta=0.129ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630248,2,21395,0,0,1,5,1,1,'2024-12-27 15:21:21',599,'2024-12-27 15:21:27',37,26989,'','',30,0,2.00766,1.011,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630249,2,28533,0,0,1,1,1,1,'2024-12-27 15:21:21',102,'2024-12-27 15:21:27',19559,26989,'','',30,0,2.00821,1.014,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630250,2,23551,0,0,1,1,0,1,'2024-12-27 15:21:27',19603,'2024-12-27 15:21:27',2955,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630251,2,23553,0,0,1,10,1,1,'2024-12-27 15:21:40',126873,'2024-12-27 15:21:41',227100,26989,'','',30,0,1.099,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630252,2,21396,0,0,1,5,0,1,'2024-12-27 15:21:41',229848,'2024-12-27 15:21:45',244578,26989,'','',30,0,0.02097,1.229,0,'OK - 192.168.77.159: rta 0.747ms, lost 0%','rta=0.747ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630253,2,28533,0,0,1,1,1,1,'2024-12-27 15:21:45',244932,'2024-12-27 15:21:47',253970,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630254,2,23552,0,0,1,1,0,1,'2024-12-27 15:21:50',299905,'2024-12-27 15:21:50',311279,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.8: rta 0.137ms, lost 0%','rta=0.137ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630255,2,23554,0,0,1,1,0,1,'2024-12-27 15:21:50',312153,'2024-12-27 15:21:50',322184,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630256,2,21395,0,0,1,5,1,1,'2024-12-27 15:21:50',322777,'2024-12-27 15:21:51',286030,26989,'','',30,0,0.963,0,1,'CRITICAL - 192.168.77.154: Host unreachable @ 192.168.77.9. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630257,2,23553,0,0,1,10,1,1,'2024-12-27 15:21:56',305542,'2024-12-27 15:22:00',315053,26989,'','',30,0,2.00798,0.305,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630258,2,23551,0,0,1,1,0,1,'2024-12-27 15:22:00',326137,'2024-12-27 15:22:05',339036,26989,'','',30,0,0.00987,0.326,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630259,2,28533,0,0,1,1,1,1,'2024-12-27 15:22:05',339418,'2024-12-27 15:22:07',348911,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630260,2,28279,0,0,1,1,0,1,'2024-12-27 15:22:10',382561,'2024-12-27 15:22:10',390967,26989,'','',30,0,0.008,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630261,2,23552,0,0,1,1,0,1,'2024-12-27 15:22:10',393470,'2024-12-27 15:22:15',424683,26989,'','',30,0,0.00919,0.393,0,'OK - 192.168.77.8: rta 0.137ms, lost 0%','rta=0.137ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630262,2,23549,0,0,1,10,0,1,'2024-12-27 15:22:10',396374,'2024-12-27 15:22:15',424955,26989,'','',30,0,0.01204,0.396,0,'OK - 84.38.95.222: rta 0.231ms, lost 0%','rta=0.231ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630263,2,28279,0,0,1,1,0,1,'2024-12-27 15:22:15',427772,'2024-12-27 15:22:20',459652,26989,'','',30,0,0.0075,0.427,0,'OK - 192.168.77.9: rta 0.014ms, lost 0%','rta=0.014ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630264,2,21396,0,0,1,5,0,1,'2024-12-27 15:22:20',459701,'2024-12-27 15:22:20',482311,26989,'','',30,0,0.022,0,0,'OK - 192.168.77.159: rta 0.772ms, lost 0%','rta=0.772ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630265,2,23553,0,0,1,10,1,1,'2024-12-27 15:22:20',482632,'2024-12-27 15:22:22',490729,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630266,2,23554,0,0,1,1,0,1,'2024-12-27 15:22:25',504122,'2024-12-27 15:22:25',514559,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630267,2,21397,0,0,1,5,1,1,'2024-12-27 15:22:22',493415,'2024-12-27 15:22:25',515074,26989,'','',30,0,0.99559,2.493,2,'CRITICAL - 172.20.3.10: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630268,2,23548,0,0,1,5,1,1,'2024-12-27 15:22:22',496394,'2024-12-27 15:22:25',515314,26989,'','',30,0,0.99266,2.496,2,'CRITICAL - 172.20.3.11: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630269,2,23554,0,0,1,1,0,1,'2024-12-27 15:22:25',517550,'2024-12-27 15:22:30',539930,26989,'','',30,0,0.00892,0.517,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630270,2,28533,0,0,1,1,1,1,'2024-12-27 15:22:27',523165,'2024-12-27 15:22:30',540163,26989,'','',30,0,2.00833,0.523,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630271,2,21395,0,0,1,5,1,1,'2024-12-27 15:22:27',522080,'2024-12-27 15:22:30',540384,26989,'','',30,0,2.01143,0.522,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630272,2,23552,0,0,1,1,0,1,'2024-12-27 15:22:45',622688,'2024-12-27 15:22:45',633124,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.110ms, lost 0%','rta=0.110ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630273,2,23553,0,0,1,10,1,1,'2024-12-27 15:22:45',633549,'2024-12-27 15:22:47',642363,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630274,2,21396,0,0,1,5,0,1,'2024-12-27 15:22:47',644854,'2024-12-27 15:22:50',673906,26989,'','',30,0,0.02942,2.644,0,'OK - 192.168.77.159: rta 1.172ms, lost 0%','rta=1.172ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630275,2,23549,0,0,1,10,0,1,'2024-12-27 15:22:50',674276,'2024-12-27 15:22:50',686512,26989,'','',30,0,0.011,0,0,'OK - 84.38.95.222: rta 0.200ms, lost 0%','rta=0.200ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630276,2,23554,0,0,1,1,0,1,'2024-12-27 15:22:55',716156,'2024-12-27 15:22:55',726513,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630277,2,23551,0,0,1,1,0,1,'2024-12-27 15:22:55',726864,'2024-12-27 15:22:55',736576,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630278,2,23553,0,0,1,10,1,1,'2024-12-27 15:23:00',779324,'2024-12-27 15:23:05',811043,26989,'','',30,0,2.00847,0.779,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630279,2,28533,0,0,1,1,1,1,'2024-12-27 15:23:05',811380,'2024-12-27 15:23:07',821090,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630280,2,23551,0,0,1,1,0,1,'2024-12-27 15:23:07',823545,'2024-12-27 15:23:10',855836,26989,'','',30,0,0.00908,2.823,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630281,2,23552,0,0,1,1,0,1,'2024-12-27 15:23:10',855895,'2024-12-27 15:23:10',866100,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.142ms, lost 0%','rta=0.142ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630282,2,21397,0,0,1,5,1,1,'2024-12-27 15:23:15',893577,'2024-12-27 15:23:17',902790,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630283,2,23553,0,0,1,10,1,1,'2024-12-27 15:23:17',903137,'2024-12-27 15:23:18',902993,26989,'','',30,0,1,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630284,2,23552,0,0,1,1,0,1,'2024-12-27 15:23:18',905547,'2024-12-27 15:23:20',934253,26989,'','',30,0,0.00922,3.905,0,'OK - 192.168.77.8: rta 0.159ms, lost 0%','rta=0.159ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630285,2,23549,0,0,1,10,0,1,'2024-12-27 15:23:18',908065,'2024-12-27 15:23:20',934453,26989,'','',30,0,0.01144,3.908,0,'OK - 84.38.95.222: rta 0.199ms, lost 0%','rta=0.199ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630286,2,23554,0,0,1,1,0,1,'2024-12-27 15:23:20',934523,'2024-12-27 15:23:20',945491,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630287,2,28279,0,0,1,1,0,1,'2024-12-27 15:23:20',948131,'2024-12-27 15:23:25',976012,26989,'','',30,0,0.00605,0.948,0,'OK - 192.168.77.9: rta 0.016ms, lost 0%','rta=0.016ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630288,2,28533,0,0,1,1,1,1,'2024-12-27 15:23:25',976337,'2024-12-27 15:23:27',985031,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630289,2,23551,0,0,1,1,0,1,'2024-12-27 15:23:30',0,'2024-12-27 15:23:30',8536,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630290,2,21397,0,0,1,5,1,1,'2024-12-27 15:23:27',987604,'2024-12-27 15:23:30',8945,26989,'','',30,0,2.00865,2.987,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630291,2,23548,0,0,1,5,1,1,'2024-12-27 15:23:27',990056,'2024-12-27 15:23:30',9097,26989,'','',30,0,2.00753,2.99,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630292,2,23554,0,0,1,1,0,1,'2024-12-27 15:23:30',19,'2024-12-27 15:23:35',19002,26989,'','',30,0,0.00939,0.023,0,'OK - 192.168.77.208: rta 0.157ms, lost 0%','rta=0.157ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630293,2,28533,0,0,1,1,1,1,'2024-12-27 15:23:30',22,'2024-12-27 15:23:35',19328,26989,'','',30,0,2.00899,0.026,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630294,2,21395,0,0,1,5,1,1,'2024-12-27 15:23:30',2,'2024-12-27 15:23:35',37,26989,'','',30,0,2.00859,0.029,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630295,2,23552,0,0,1,1,0,1,'2024-12-27 15:23:35',37,'2024-12-27 15:23:35',23831,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.147ms, lost 0%','rta=0.147ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630296,2,21397,0,0,1,5,1,1,'2024-12-27 15:23:45',0,'2024-12-27 15:23:47',104324,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630297,2,23553,0,0,1,10,1,1,'2024-12-27 15:23:47',104656,'2024-12-27 15:23:48',0,26989,'','',30,0,0.991,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630298,2,23554,0,0,1,1,0,1,'2024-12-27 15:23:48',0,'2024-12-27 15:23:48',106408,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630299,2,21396,0,0,1,5,0,1,'2024-12-27 15:23:50',119144,'2024-12-27 15:23:55',137452,26989,'','',30,0,0.02824,0.119,0,'OK - 192.168.77.159: rta 1.077ms, lost 0%','rta=1.077ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630300,2,28533,0,0,1,1,1,1,'2024-12-27 15:23:55',137536,'2024-12-27 15:23:57',147241,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630301,2,23551,0,0,1,1,0,1,'2024-12-27 15:24:00',162614,'2024-12-27 15:24:00',173442,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630302,2,23552,0,0,1,1,0,1,'2024-12-27 15:24:05',186066,'2024-12-27 15:24:05',196175,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.126ms, lost 0%','rta=0.126ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630303,2,23553,0,0,1,10,1,1,'2024-12-27 15:24:05',196524,'2024-12-27 15:24:07',205813,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630304,2,23553,0,0,1,10,1,1,'2024-12-27 15:24:07',208589,'2024-12-27 15:24:10',232104,26989,'','',30,0,0.99422,2.208,2,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630305,2,23548,0,0,1,5,1,1,'2024-12-27 15:24:10',232160,'2024-12-27 15:24:12',240418,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630306,2,23554,0,0,1,1,0,1,'2024-12-27 15:24:12',240696,'2024-12-27 15:24:12',250588,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630307,2,23551,0,0,1,1,0,1,'2024-12-27 15:24:12',253004,'2024-12-27 15:24:15',264303,26989,'','',30,0,0.00887,2.252,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630308,2,23552,0,0,1,1,0,1,'2024-12-27 15:24:20',306099,'2024-12-27 15:24:25',333415,26989,'','',30,0,0.01063,0.306,0,'OK - 192.168.77.8: rta 0.138ms, lost 0%','rta=0.138ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630309,2,23549,0,0,1,10,0,1,'2024-12-27 15:24:20',307873,'2024-12-27 15:24:25',333668,26989,'','',30,0,0.01286,0.307,0,'OK - 84.38.95.222: rta 0.216ms, lost 0%','rta=0.216ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630310,2,21395,0,0,1,5,1,1,'2024-12-27 15:24:25',334001,'2024-12-27 15:24:27',342982,26989,'','',30,0,2.008,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630311,2,28533,0,0,1,1,1,1,'2024-12-27 15:24:30',384963,'2024-12-27 15:24:32',394513,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630312,2,28279,0,0,1,1,0,1,'2024-12-27 15:24:27',345910,'2024-12-27 15:24:32',395073,26989,'','',30,0,0.00611,2.345,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630313,2,23548,0,0,1,5,1,1,'2024-12-27 15:24:32',395659,'2024-12-27 15:24:34',404488,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630314,2,23548,0,0,1,5,1,1,'2024-12-27 15:24:34',409983,'2024-12-27 15:24:40',467803,26989,'','',30,0,0.99341,4.409,2,'CRITICAL - 172.20.3.11: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630315,2,21397,0,0,1,5,1,1,'2024-12-27 15:24:34',407134,'2024-12-27 15:24:40',468048,26989,'','',30,0,0.99639,4.407,2,'CRITICAL - 172.20.3.10: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630316,2,23554,0,0,1,1,0,1,'2024-12-27 15:24:35',424580,'2024-12-27 15:24:40',468276,26989,'','',30,0,0.0101,0.424,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630317,2,28533,0,0,1,1,1,1,'2024-12-27 15:24:35',425403,'2024-12-27 15:24:40',468501,26989,'','',30,0,2.00933,0.425,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630318,2,21395,0,0,1,5,1,1,'2024-12-27 15:24:35',426511,'2024-12-27 15:24:40',468713,26989,'','',30,0,2.01002,0.426,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630319,2,23553,0,0,1,10,1,1,'2024-12-27 15:24:40',469017,'2024-12-27 15:24:41',557324,26989,'','',30,0,1.088,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630320,2,23551,0,0,1,1,0,1,'2024-12-27 15:24:41',557604,'2024-12-27 15:24:41',567588,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630321,2,23552,0,0,1,1,0,1,'2024-12-27 15:24:50',629580,'2024-12-27 15:24:50',639409,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.118ms, lost 0%','rta=0.118ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630322,2,21395,0,0,1,5,1,1,'2024-12-27 15:24:55',670117,'2024-12-27 15:24:57',679976,26989,'','',30,0,2.009,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630323,2,23553,0,0,1,10,1,1,'2024-12-27 15:24:57',680284,'2024-12-27 15:24:59',688183,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630324,2,23554,0,0,1,1,0,1,'2024-12-27 15:25:00',714065,'2024-12-27 15:25:00',723985,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630325,2,21396,0,0,1,5,0,1,'2024-12-27 15:24:59',690910,'2024-12-27 15:25:00',724413,26989,'','',30,0,0.0277,4.69,0,'OK - 192.168.77.159: rta 1.083ms, lost 0%','rta=1.083ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630326,2,23551,0,0,1,1,0,1,'2024-12-27 15:25:05',759043,'2024-12-27 15:25:05',770732,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.29: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630327,2,28533,0,0,1,1,1,1,'2024-12-27 15:25:05',771046,'2024-12-27 15:25:07',779161,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630328,2,28279,0,0,1,1,0,1,'2024-12-27 15:25:10',815660,'2024-12-27 15:25:10',823760,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630329,2,23553,0,0,1,10,1,1,'2024-12-27 15:25:10',826343,'2024-12-27 15:25:15',857200,26989,'','',30,0,2.0094,0.826,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630330,2,23552,0,0,1,1,0,1,'2024-12-27 15:25:15',857255,'2024-12-27 15:25:15',867903,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.131ms, lost 0%','rta=0.131ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630331,2,23551,0,0,1,1,0,1,'2024-12-27 15:25:15',870317,'2024-12-27 15:25:20',901924,26989,'','',30,0,0.009,0.87,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630332,2,21396,0,0,1,5,0,1,'2024-12-27 15:25:20',901982,'2024-12-27 15:25:20',924487,26989,'','',30,0,0.022,0,0,'OK - 192.168.77.159: rta 0.738ms, lost 0%','rta=0.738ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630333,2,23554,0,0,1,1,0,1,'2024-12-27 15:25:25',948205,'2024-12-27 15:25:25',959301,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630334,2,23552,0,0,1,1,0,1,'2024-12-27 15:25:25',961910,'2024-12-27 15:25:30',998141,26989,'','',30,0,0.00955,0.961,0,'OK - 192.168.77.8: rta 0.117ms, lost 0%','rta=0.117ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630335,2,23549,0,0,1,10,0,1,'2024-12-27 15:25:25',964955,'2024-12-27 15:25:30',998382,26989,'','',30,0,0.01057,0.964,0,'OK - 84.38.95.222: rta 0.199ms, lost 0%','rta=0.199ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630336,2,28279,0,0,1,1,0,1,'2024-12-27 15:25:32',2,'2024-12-27 15:25:35',6484,26989,'','',30,0,0.00898,0.002,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630337,2,23554,0,0,1,1,0,1,'2024-12-27 15:25:40',16298,'2024-12-27 15:25:45',22819,26989,'','',30,0,0.01191,0.037,0,'OK - 192.168.77.208: rta 0.264ms, lost 0%','rta=0.264ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630338,2,23548,0,0,1,5,1,1,'2024-12-27 15:25:40',1635,'2024-12-27 15:25:45',22966,26989,'','',30,0,0.65578,0.031,2,'CRITICAL - 172.20.3.11: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630339,2,21397,0,0,1,5,1,1,'2024-12-27 15:25:40',14892,'2024-12-27 15:25:45',44,26989,'','',30,0,0.6527,0.035,2,'CRITICAL - 172.20.3.10: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630340,2,28533,0,0,1,1,1,1,'2024-12-27 15:25:40',3,'2024-12-27 15:25:45',2886,26989,'','',30,0,2.00949,0.039,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630341,2,21395,0,0,1,5,1,1,'2024-12-27 15:25:40',16472,'2024-12-27 15:25:45',23217,26989,'','',30,0,2.01006,0.04,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630342,2,23552,0,0,1,1,0,1,'2024-12-27 15:25:45',23255,'2024-12-27 15:25:45',27593,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.137ms, lost 0%','rta=0.137ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630343,2,23553,0,0,1,10,1,1,'2024-12-27 15:25:45',27657,'2024-12-27 15:25:47',59,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630344,2,23549,0,0,1,10,0,1,'2024-12-27 15:25:50',105907,'2024-12-27 15:25:50',117521,26989,'','',30,0,0.011,0,0,'OK - 84.38.95.222: rta 0.207ms, lost 0%','rta=0.207ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630345,2,23551,0,0,1,1,0,1,'2024-12-27 15:25:55',135528,'2024-12-27 15:25:55',146843,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630346,2,23554,0,0,1,1,0,1,'2024-12-27 15:26:00',169103,'2024-12-27 15:26:00',179873,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630347,2,21396,0,0,1,5,0,1,'2024-12-27 15:26:00',182795,'2024-12-27 15:26:05',201150,26989,'','',30,0,0.02836,0.182,0,'OK - 192.168.77.159: rta 1.117ms, lost 0%','rta=1.117ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630348,2,28533,0,0,1,1,1,1,'2024-12-27 15:26:05',201480,'2024-12-27 15:26:07',232172,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630349,2,23552,0,0,1,1,0,1,'2024-12-27 15:26:10',241946,'2024-12-27 15:26:10',253100,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.133ms, lost 0%','rta=0.133ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630350,2,21397,0,0,1,5,1,1,'2024-12-27 15:26:15',264800,'2024-12-27 15:26:17',273560,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630351,2,23553,0,0,1,10,1,1,'2024-12-27 15:26:17',282384,'2024-12-27 15:26:18',272858,26989,'','',30,0,0.991,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630352,2,23554,0,0,1,1,0,1,'2024-12-27 15:26:20',291255,'2024-12-27 15:26:20',302797,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630353,2,23549,0,0,1,10,0,1,'2024-12-27 15:26:20',303137,'2024-12-27 15:26:20',314150,26989,'','',30,0,0.01,0,0,'OK - 84.38.95.222: rta 0.203ms, lost 0%','rta=0.203ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630354,2,23553,0,0,1,10,1,1,'2024-12-27 15:26:18',275426,'2024-12-27 15:26:20',314632,26989,'','',30,0,2.00772,3.275,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630355,2,23551,0,0,1,1,0,1,'2024-12-27 15:26:20',316805,'2024-12-27 15:26:25',354325,26989,'','',30,0,0.00899,0.316,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630356,2,28533,0,0,1,1,1,1,'2024-12-27 15:26:25',354626,'2024-12-27 15:26:27',374944,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630357,2,23552,0,0,1,1,0,1,'2024-12-27 15:26:30',395105,'2024-12-27 15:26:35',414927,26989,'','',30,0,0.01052,0.395,0,'OK - 192.168.77.8: rta 0.157ms, lost 0%','rta=0.157ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630358,2,23549,0,0,1,10,0,1,'2024-12-27 15:26:30',398260,'2024-12-27 15:26:35',415164,26989,'','',30,0,0.01307,0.398,0,'OK - 84.38.95.222: rta 0.252ms, lost 0%','rta=0.252ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630359,2,28279,0,0,1,1,0,1,'2024-12-27 15:26:35',415233,'2024-12-27 15:26:35',423765,26989,'','',30,0,0.008,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630360,2,28279,0,0,1,1,0,1,'2024-12-27 15:26:35',426697,'2024-12-27 15:26:40',456400,26989,'','',30,0,0.00644,0.426,0,'OK - 192.168.77.9: rta 0.014ms, lost 0%','rta=0.014ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630361,2,23551,0,0,1,1,0,1,'2024-12-27 15:26:40',456453,'2024-12-27 15:26:40',466690,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630362,2,21397,0,0,1,5,1,1,'2024-12-27 15:26:45',484177,'2024-12-27 15:26:47',501280,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630363,2,23553,0,0,1,10,1,1,'2024-12-27 15:26:47',501570,'2024-12-27 15:26:48',491839,26989,'','',30,0,0.991,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630364,2,23554,0,0,1,1,0,1,'2024-12-27 15:26:48',492325,'2024-12-27 15:26:48',502174,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630365,2,23554,0,0,1,1,0,1,'2024-12-27 15:26:48',504561,'2024-12-27 15:26:50',525663,26989,'','',30,0,0.01191,3.504,0,'OK - 192.168.77.208: rta 0.301ms, lost 0%','rta=0.301ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630366,2,23548,0,0,1,5,1,1,'2024-12-27 15:26:48',507581,'2024-12-27 15:26:50',525916,26989,'','',30,0,2.0075,3.507,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630367,2,21397,0,0,1,5,1,1,'2024-12-27 15:26:48',508390,'2024-12-27 15:26:50',526147,26989,'','',30,0,2.00953,3.508,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630368,2,28533,0,0,1,1,1,1,'2024-12-27 15:26:48',511325,'2024-12-27 15:26:50',526370,26989,'','',30,0,2.00844,3.511,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630369,2,21395,0,0,1,5,1,1,'2024-12-27 15:26:48',512849,'2024-12-27 15:26:55',545282,26989,'','',30,0,2.00988,3.512,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630370,2,23551,0,0,1,1,0,1,'2024-12-27 15:27:00',563850,'2024-12-27 15:27:00',574429,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.148ms, lost 0%','rta=0.148ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630371,2,23552,0,0,1,1,0,1,'2024-12-27 15:27:05',588796,'2024-12-27 15:27:05',598563,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.113ms, lost 0%','rta=0.113ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630372,2,23553,0,0,1,10,1,1,'2024-12-27 15:27:05',598966,'2024-12-27 15:27:07',608367,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630373,2,21396,0,0,1,5,0,1,'2024-12-27 15:27:07',611265,'2024-12-27 15:27:10',637411,26989,'','',30,0,0.02776,2.611,0,'OK - 192.168.77.159: rta 1.094ms, lost 0%','rta=1.094ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630374,2,23548,0,0,1,5,1,1,'2024-12-27 15:27:10',637466,'2024-12-27 15:27:12',645729,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630375,2,23554,0,0,1,1,0,1,'2024-12-27 15:27:12',646024,'2024-12-27 15:27:12',656262,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630376,2,23552,0,0,1,1,0,1,'2024-12-27 15:27:25',765247,'2024-12-27 15:27:25',776041,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.120ms, lost 0%','rta=0.120ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630377,2,21395,0,0,1,5,1,1,'2024-12-27 15:27:25',776378,'2024-12-27 15:27:27',785273,26989,'','',30,0,2.008,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630378,2,23553,0,0,1,10,1,1,'2024-12-27 15:27:20',737472,'2024-12-27 15:27:27',785764,26989,'','',30,0,2.00881,0.737,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630379,2,23551,0,0,1,1,0,1,'2024-12-27 15:27:27',785832,'2024-12-27 15:27:27',796047,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630380,2,28533,0,0,1,1,1,1,'2024-12-27 15:27:30',833888,'2024-12-27 15:27:32',843293,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630381,2,23551,0,0,1,1,0,1,'2024-12-27 15:27:27',798531,'2024-12-27 15:27:32',843778,26989,'','',30,0,0.00884,2.798,0,'OK - 192.168.77.29: rta 0.148ms, lost 0%','rta=0.148ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630382,2,23548,0,0,1,5,1,1,'2024-12-27 15:27:32',844348,'2024-12-27 15:27:34',852475,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630383,2,23552,0,0,1,1,0,1,'2024-12-27 15:27:35',873679,'2024-12-27 15:27:40',986645,26989,'','',30,0,0.00901,0.873,0,'OK - 192.168.77.8: rta 0.133ms, lost 0%','rta=0.133ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630384,2,23549,0,0,1,10,0,1,'2024-12-27 15:27:35',877009,'2024-12-27 15:27:40',986858,26989,'','',30,0,0.01115,0.876,0,'OK - 84.38.95.222: rta 0.237ms, lost 0%','rta=0.237ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630385,2,23553,0,0,1,10,1,1,'2024-12-27 15:27:40',987186,'2024-12-27 15:27:42',26115,26989,'','',30,0,1.076,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630386,2,28279,0,0,1,1,0,1,'2024-12-27 15:27:42',3454,'2024-12-27 15:27:45',7,26989,'','',30,0,0.00619,2.065,0,'OK - 192.168.77.9: rta 0.016ms, lost 0%','rta=0.016ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630387,2,28533,0,0,1,1,1,1,'2024-12-27 15:27:50',107254,'2024-12-27 15:27:52',116354,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630388,2,23552,0,0,1,1,0,1,'2024-12-27 15:27:52',117110,'2024-12-27 15:27:52',126947,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.110ms, lost 0%','rta=0.110ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630389,2,23554,0,0,1,1,0,1,'2024-12-27 15:27:52',127226,'2024-12-27 15:27:52',137124,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630390,2,21395,0,0,1,5,1,1,'2024-12-27 15:27:52',137621,'2024-12-27 15:27:54',145574,26989,'','',30,0,2.007,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630391,2,23554,0,0,1,1,0,1,'2024-12-27 15:27:54',148022,'2024-12-27 15:27:55',163462,26989,'','',30,0,0.00907,4.147,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630392,2,23548,0,0,1,5,1,1,'2024-12-27 15:27:54',151142,'2024-12-27 15:28:00',178825,26989,'','',30,0,2.0082,4.151,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630393,2,21397,0,0,1,5,1,1,'2024-12-27 15:27:54',154597,'2024-12-27 15:28:00',179064,26989,'','',30,0,2.00774,4.154,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630394,2,28533,0,0,1,1,1,1,'2024-12-27 15:27:54',156622,'2024-12-27 15:28:00',179308,26989,'','',30,0,2.00917,4.156,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630395,2,21395,0,0,1,5,1,1,'2024-12-27 15:27:55',165993,'2024-12-27 15:28:00',179538,26989,'','',30,0,2.0086,0.165,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630396,2,23551,0,0,1,1,0,1,'2024-12-27 15:28:05',203269,'2024-12-27 15:28:05',214683,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.29: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630397,2,28279,0,0,1,1,0,1,'2024-12-27 15:28:10',234590,'2024-12-27 15:28:10',242514,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630398,2,21396,0,0,1,5,0,1,'2024-12-27 15:28:10',244951,'2024-12-27 15:28:15',255381,26989,'','',30,0,0.02157,0.244,0,'OK - 192.168.77.159: rta 0.781ms, lost 0%','rta=0.781ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630399,2,23552,0,0,1,1,0,1,'2024-12-27 15:28:15',255667,'2024-12-27 15:28:15',265549,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.115ms, lost 0%','rta=0.115ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630400,2,23553,0,0,1,10,1,1,'2024-12-27 15:28:20',294757,'2024-12-27 15:28:22',303496,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630401,2,23554,0,0,1,1,0,1,'2024-12-27 15:28:25',323471,'2024-12-27 15:28:25',333454,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630402,2,23553,0,0,1,10,1,1,'2024-12-27 15:28:27',339795,'2024-12-27 15:28:30',365086,26989,'','',30,0,2.0075,0.339,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630403,2,23551,0,0,1,1,0,1,'2024-12-27 15:28:32',371756,'2024-12-27 15:28:35',390121,26989,'','',30,0,0.01144,0.371,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630404,2,23552,0,0,1,1,0,1,'2024-12-27 15:28:40',415382,'2024-12-27 15:28:45',435650,26989,'','',30,0,0.00945,0.415,0,'OK - 192.168.77.8: rta 0.127ms, lost 0%','rta=0.127ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630405,2,23549,0,0,1,10,0,1,'2024-12-27 15:28:40',418115,'2024-12-27 15:28:45',435846,26989,'','',30,0,0.01032,0.418,0,'OK - 84.38.95.222: rta 0.208ms, lost 0%','rta=0.208ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630406,2,23553,0,0,1,10,1,1,'2024-12-27 15:28:45',436163,'2024-12-27 15:28:47',445778,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630407,2,28279,0,0,1,1,0,1,'2024-12-27 15:28:47',448169,'2024-12-27 15:28:50',483798,26989,'','',30,0,0.00611,2.448,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630408,2,23554,0,0,1,1,0,1,'2024-12-27 15:28:55',507203,'2024-12-27 15:28:55',518315,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630409,2,23551,0,0,1,1,0,1,'2024-12-27 15:28:55',518679,'2024-12-27 15:28:55',529153,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630410,2,23554,0,0,1,1,0,1,'2024-12-27 15:28:55',531634,'2024-12-27 15:29:00',570911,26989,'','',30,0,0.00888,0.531,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630411,2,23548,0,0,1,5,1,1,'2024-12-27 15:29:00',574111,'2024-12-27 15:29:05',608920,26989,'','',30,0,2.00798,0.574,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630412,2,21397,0,0,1,5,1,1,'2024-12-27 15:29:00',577638,'2024-12-27 15:29:05',609128,26989,'','',30,0,2.00741,0.577,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630413,2,28533,0,0,1,1,1,1,'2024-12-27 15:29:00',581122,'2024-12-27 15:29:05',609323,26989,'','',30,0,2.00892,0.581,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630414,2,21395,0,0,1,5,1,1,'2024-12-27 15:29:00',584069,'2024-12-27 15:29:05',609536,26989,'','',30,0,2.00769,0.584,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630415,2,23552,0,0,1,1,0,1,'2024-12-27 15:29:10',636760,'2024-12-27 15:29:10',646861,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.128ms, lost 0%','rta=0.128ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630416,2,23553,0,0,1,10,1,1,'2024-12-27 15:29:15',678900,'2024-12-27 15:29:17',688366,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630417,2,21396,0,0,1,5,0,1,'2024-12-27 15:29:17',690722,'2024-12-27 15:29:20',723291,26989,'','',30,0,0.02097,2.69,0,'OK - 192.168.77.159: rta 0.739ms, lost 0%','rta=0.739ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630418,2,23554,0,0,1,1,0,1,'2024-12-27 15:29:20',723351,'2024-12-27 15:29:20',734764,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630419,2,23549,0,0,1,10,0,1,'2024-12-27 15:29:20',735157,'2024-12-27 15:29:20',747111,26989,'','',30,0,0.011,0,0,'OK - 84.38.95.222: rta 0.205ms, lost 0%','rta=0.205ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630420,2,28533,0,0,1,1,1,1,'2024-12-27 15:29:25',778292,'2024-12-27 15:29:27',787029,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630421,2,23551,0,0,1,1,0,1,'2024-12-27 15:29:30',814771,'2024-12-27 15:29:30',826272,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630422,2,28279,0,0,1,1,0,1,'2024-12-27 15:29:35',859801,'2024-12-27 15:29:35',867832,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630423,2,23553,0,0,1,10,1,1,'2024-12-27 15:29:30',829143,'2024-12-27 15:29:35',868372,26989,'','',30,0,2.00721,0.829,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630424,2,23552,0,0,1,1,0,1,'2024-12-27 15:29:35',868441,'2024-12-27 15:29:35',877925,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.130ms, lost 0%','rta=0.130ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630425,2,23551,0,0,1,1,0,1,'2024-12-27 15:29:35',880512,'2024-12-27 15:29:40',955934,26989,'','',30,0,0.00875,0.88,0,'OK - 192.168.77.29: rta 0.148ms, lost 0%','rta=0.148ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630426,2,21397,0,0,1,5,1,1,'2024-12-27 15:29:45',991543,'2024-12-27 15:29:48',1,26989,'','',30,0,2.011,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630427,2,23554,0,0,1,1,0,1,'2024-12-27 15:29:48',1352,'2024-12-27 15:29:48',93,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630428,2,23552,0,0,1,1,0,1,'2024-12-27 15:29:48',7312,'2024-12-27 15:29:50',12879,26989,'','',30,0,0.01069,3.016,0,'OK - 192.168.77.8: rta 0.208ms, lost 0%','rta=0.208ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630429,2,23549,0,0,1,10,0,1,'2024-12-27 15:29:48',15,'2024-12-27 15:29:50',12998,26989,'','',30,0,0.01235,3.017,0,'OK - 84.38.95.222: rta 0.200ms, lost 0%','rta=0.200ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630430,2,28279,0,0,1,1,0,1,'2024-12-27 15:29:50',1774,'2024-12-27 15:29:55',21128,26989,'','',30,0,0.00681,0.033,0,'OK - 192.168.77.9: rta 0.014ms, lost 0%','rta=0.014ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630431,2,28533,0,0,1,1,1,1,'2024-12-27 15:29:55',330,'2024-12-27 15:29:56',132170,26989,'','',30,0,1.08,0,1,'CRITICAL - 172.50.1.3: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630432,2,23551,0,0,1,1,0,1,'2024-12-27 15:30:00',166335,'2024-12-27 15:30:00',177460,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630433,2,23554,0,0,1,1,0,1,'2024-12-27 15:30:00',180193,'2024-12-27 15:30:05',190702,26989,'','',30,0,0.00898,0.18,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630434,2,23552,0,0,1,1,0,1,'2024-12-27 15:30:05',190759,'2024-12-27 15:30:05',200701,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.129ms, lost 0%','rta=0.129ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630435,2,23553,0,0,1,10,1,1,'2024-12-27 15:30:05',201204,'2024-12-27 15:30:07',209723,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630436,2,23548,0,0,1,5,1,1,'2024-12-27 15:30:07',225005,'2024-12-27 15:30:10',246464,26989,'','',30,0,0.98287,2.224,2,'CRITICAL - 172.20.3.11: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630437,2,21397,0,0,1,5,1,1,'2024-12-27 15:30:07',227895,'2024-12-27 15:30:10',246699,26989,'','',30,0,0.98001,2.227,2,'CRITICAL - 172.20.3.10: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630438,2,28533,0,0,1,1,1,1,'2024-12-27 15:30:07',231383,'2024-12-27 15:30:10',247446,26989,'','',30,0,2.00781,2.231,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630439,2,21395,0,0,1,5,1,1,'2024-12-27 15:30:07',234529,'2024-12-27 15:30:10',247674,26989,'','',30,0,2.00767,2.234,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630440,2,21396,0,0,1,5,0,1,'2024-12-27 15:30:20',305148,'2024-12-27 15:30:25',322728,26989,'','',30,0,0.02153,0.305,0,'OK - 192.168.77.159: rta 0.710ms, lost 0%','rta=0.710ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630441,2,21395,0,0,1,5,1,1,'2024-12-27 15:30:25',322796,'2024-12-27 15:30:27',333090,26989,'','',30,0,2.01,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630442,2,23552,0,0,1,1,0,1,'2024-12-27 15:30:27',333412,'2024-12-27 15:30:27',342690,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.117ms, lost 0%','rta=0.117ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630443,2,23551,0,0,1,1,0,1,'2024-12-27 15:30:27',342991,'2024-12-27 15:30:27',353046,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630444,2,28533,0,0,1,1,1,1,'2024-12-27 15:30:30',403895,'2024-12-27 15:30:32',414166,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630445,2,23548,0,0,1,5,1,1,'2024-12-27 15:30:32',415006,'2024-12-27 15:30:34',423638,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630446,2,23553,0,0,1,10,1,1,'2024-12-27 15:30:35',434834,'2024-12-27 15:30:40',476098,26989,'','',30,0,2.00847,0.434,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630447,2,23551,0,0,1,1,0,1,'2024-12-27 15:30:40',479168,'2024-12-27 15:30:45',515977,26989,'','',30,0,0.01045,0.479,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630448,2,23552,0,0,1,1,0,1,'2024-12-27 15:30:50',550871,'2024-12-27 15:30:50',560903,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.128ms, lost 0%','rta=0.128ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630449,2,23554,0,0,1,1,0,1,'2024-12-27 15:30:50',561195,'2024-12-27 15:30:50',571027,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630450,2,21395,0,0,1,5,1,1,'2024-12-27 15:30:55',599655,'2024-12-27 15:30:57',609261,26989,'','',30,0,2.009,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630451,2,23552,0,0,1,1,0,1,'2024-12-27 15:30:50',573791,'2024-12-27 15:30:57',609697,26989,'','',30,0,0.00917,0.573,0,'OK - 192.168.77.8: rta 0.129ms, lost 0%','rta=0.129ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630452,2,23549,0,0,1,10,0,1,'2024-12-27 15:30:50',576669,'2024-12-27 15:30:57',609901,26989,'','',30,0,0.01142,0.576,0,'OK - 84.38.95.222: rta 0.207ms, lost 0%','rta=0.207ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630453,2,23553,0,0,1,10,1,1,'2024-12-27 15:30:57',609956,'2024-12-27 15:30:59',618748,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630454,2,28279,0,0,1,1,0,1,'2024-12-27 15:30:59',621458,'2024-12-27 15:31:00',647839,26989,'','',30,0,0.00618,4.621,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630455,2,23551,0,0,1,1,0,1,'2024-12-27 15:31:05',685466,'2024-12-27 15:31:05',696715,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630456,2,28533,0,0,1,1,1,1,'2024-12-27 15:31:05',697042,'2024-12-27 15:31:07',705125,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630457,2,23554,0,0,1,1,0,1,'2024-12-27 15:31:07',707742,'2024-12-27 15:31:10',738982,26989,'','',30,0,0.00891,2.707,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630458,2,21397,0,0,1,5,1,1,'2024-12-27 15:31:10',743313,'2024-12-27 15:31:15',774508,26989,'','',30,0,2.00879,0.743,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630459,2,28533,0,0,1,1,1,1,'2024-12-27 15:31:10',745458,'2024-12-27 15:31:15',774746,26989,'','',30,0,2.00786,0.745,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630460,2,23548,0,0,1,5,1,1,'2024-12-27 15:31:10',742065,'2024-12-27 15:31:15',774972,26989,'','',30,0,2.013,0.742,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630461,2,21395,0,0,1,5,1,1,'2024-12-27 15:31:10',748552,'2024-12-27 15:31:15',775182,26989,'','',30,0,2.00831,0.748,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630462,2,23552,0,0,1,1,0,1,'2024-12-27 15:31:15',775233,'2024-12-27 15:31:15',785521,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.130ms, lost 0%','rta=0.130ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630463,2,21396,0,0,1,5,0,1,'2024-12-27 15:31:20',823841,'2024-12-27 15:31:20',846451,26989,'','',30,0,0.022,0,0,'OK - 192.168.77.159: rta 0.709ms, lost 0%','rta=0.709ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630464,2,23553,0,0,1,10,1,1,'2024-12-27 15:31:20',846742,'2024-12-27 15:31:22',854693,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630465,2,23554,0,0,1,1,0,1,'2024-12-27 15:31:25',880082,'2024-12-27 15:31:25',890318,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630466,2,21396,0,0,1,5,0,1,'2024-12-27 15:31:25',892715,'2024-12-27 15:31:30',918477,26989,'','',30,0,0.02006,0.892,0,'OK - 192.168.77.159: rta 0.710ms, lost 0%','rta=0.710ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630467,2,23553,0,0,1,10,1,1,'2024-12-27 15:31:40',976030,'2024-12-27 15:31:45',998939,26989,'','',30,0,0.6409,0.975,2,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630468,2,23552,0,0,1,1,0,1,'2024-12-27 15:31:45',999012,'2024-12-27 15:31:46',0,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.8: rta 0.128ms, lost 0%','rta=0.128ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630469,2,23551,0,0,1,1,0,1,'2024-12-27 15:31:46',655,'2024-12-27 15:31:50',25,26989,'','',30,0,0.00951,1.012,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630470,2,23549,0,0,1,10,0,1,'2024-12-27 15:31:50',13515,'2024-12-27 15:31:50',36,26989,'','',30,0,0.012,0,0,'OK - 84.38.95.222: rta 0.256ms, lost 0%','rta=0.256ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630471,2,23554,0,0,1,1,0,1,'2024-12-27 15:31:55',408,'2024-12-27 15:31:55',30617,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630472,2,23552,0,0,1,1,0,1,'2024-12-27 15:31:57',0,'2024-12-27 15:32:00',112278,26989,'','',30,0,0.02024,0.082,0,'OK - 192.168.77.8: rta 0.121ms, lost 0%','rta=0.121ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630473,2,23549,0,0,1,10,0,1,'2024-12-27 15:31:57',0,'2024-12-27 15:32:00',112511,26989,'','',30,0,0.02537,0.084,0,'OK - 84.38.95.222: rta 0.209ms, lost 0%','rta=0.209ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630474,2,28279,0,0,1,1,0,1,'2024-12-27 15:32:00',115847,'2024-12-27 15:32:05',134422,26989,'','',30,0,0.00736,0.115,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630475,2,28533,0,0,1,1,1,1,'2024-12-27 15:32:05',134765,'2024-12-27 15:32:07',145250,26989,'','',30,0,2.01,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630476,2,23554,0,0,1,1,0,1,'2024-12-27 15:32:10',177298,'2024-12-27 15:32:15',193029,26989,'','',30,0,0.00958,0.177,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630477,2,21397,0,0,1,5,1,1,'2024-12-27 15:32:15',193091,'2024-12-27 15:32:17',201848,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630478,2,23553,0,0,1,10,1,1,'2024-12-27 15:32:17',211381,'2024-12-27 15:32:18',201158,26989,'','',30,0,0.99,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630479,2,23549,0,0,1,10,0,1,'2024-12-27 15:32:20',233095,'2024-12-27 15:32:20',246378,26989,'','',30,0,0.013,0,0,'OK - 84.38.95.222: rta 0.247ms, lost 0%','rta=0.247ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630480,2,21397,0,0,1,5,1,1,'2024-12-27 15:32:18',203768,'2024-12-27 15:32:20',246872,26989,'','',30,0,2.00767,3.203,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630481,2,28533,0,0,1,1,1,1,'2024-12-27 15:32:18',206854,'2024-12-27 15:32:20',247122,26989,'','',30,0,2.00757,3.206,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630482,2,23548,0,0,1,5,1,1,'2024-12-27 15:32:18',210403,'2024-12-27 15:32:20',247354,26989,'','',30,0,2.00801,3.21,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630483,2,21395,0,0,1,5,1,1,'2024-12-27 15:32:18',213965,'2024-12-27 15:32:20',247580,26989,'','',30,0,2.00845,3.213,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630484,2,23551,0,0,1,1,0,1,'2024-12-27 15:32:30',300348,'2024-12-27 15:32:30',311656,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630485,2,21396,0,0,1,5,0,1,'2024-12-27 15:32:30',314397,'2024-12-27 15:32:35',333709,26989,'','',30,0,0.02062,0.314,0,'OK - 192.168.77.159: rta 0.729ms, lost 0%','rta=0.729ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630486,2,28279,0,0,1,1,0,1,'2024-12-27 15:32:35',333787,'2024-12-27 15:32:35',342177,26989,'','',30,0,0.008,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630487,2,23552,0,0,1,1,0,1,'2024-12-27 15:32:35',342512,'2024-12-27 15:32:35',352094,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.123ms, lost 0%','rta=0.123ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630488,2,21397,0,0,1,5,1,1,'2024-12-27 15:32:45',397652,'2024-12-27 15:32:47',406608,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630489,2,23553,0,0,1,10,1,1,'2024-12-27 15:32:47',406920,'2024-12-27 15:32:48',406811,26989,'','',30,0,1,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630490,2,23554,0,0,1,1,0,1,'2024-12-27 15:32:48',407405,'2024-12-27 15:32:48',417397,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630491,2,23553,0,0,1,10,1,1,'2024-12-27 15:32:48',420071,'2024-12-27 15:32:55',462946,26989,'','',30,0,2.01139,3.42,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630492,2,23551,0,0,1,1,0,1,'2024-12-27 15:32:50',434753,'2024-12-27 15:32:55',463165,26989,'','',30,0,0.01007,0.434,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630493,2,28533,0,0,1,1,1,1,'2024-12-27 15:32:55',463251,'2024-12-27 15:32:57',473645,26989,'','',30,0,2.01,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630494,2,23552,0,0,1,1,0,1,'2024-12-27 15:33:00',506203,'2024-12-27 15:33:05',532642,26989,'','',30,0,0.00903,0.506,0,'OK - 192.168.77.8: rta 0.108ms, lost 0%','rta=0.108ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630495,2,23549,0,0,1,10,0,1,'2024-12-27 15:33:00',508975,'2024-12-27 15:33:05',532843,26989,'','',30,0,0.01188,0.508,0,'OK - 84.38.95.222: rta 0.239ms, lost 0%','rta=0.239ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630496,2,23553,0,0,1,10,1,1,'2024-12-27 15:33:05',533127,'2024-12-27 15:33:07',542510,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630497,2,23551,0,0,1,1,0,1,'2024-12-27 15:33:07',542786,'2024-12-27 15:33:07',552650,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630498,2,28279,0,0,1,1,0,1,'2024-12-27 15:33:07',555120,'2024-12-27 15:33:10',584157,26989,'','',30,0,0.00604,2.555,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630499,2,23548,0,0,1,5,1,1,'2024-12-27 15:33:10',584217,'2024-12-27 15:33:12',594325,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630500,2,23554,0,0,1,1,0,1,'2024-12-27 15:33:12',594648,'2024-12-27 15:33:12',604818,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630501,2,23554,0,0,1,1,0,1,'2024-12-27 15:33:15',625601,'2024-12-27 15:33:20',661760,26989,'','',30,0,0.00929,0.625,0,'OK - 192.168.77.208: rta 0.148ms, lost 0%','rta=0.148ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630502,2,21395,0,0,1,5,1,1,'2024-12-27 15:33:25',706625,'2024-12-27 15:33:27',715867,26989,'','',30,0,2.008,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630503,2,23552,0,0,1,1,0,1,'2024-12-27 15:33:27',716183,'2024-12-27 15:33:27',726108,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.132ms, lost 0%','rta=0.132ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630504,2,21397,0,0,1,5,1,1,'2024-12-27 15:33:20',664141,'2024-12-27 15:33:27',726602,26989,'','',30,0,2.00899,0.664,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630505,2,28533,0,0,1,1,1,1,'2024-12-27 15:33:20',665131,'2024-12-27 15:33:27',726833,26989,'','',30,0,2.01055,0.665,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630506,2,23548,0,0,1,5,1,1,'2024-12-27 15:33:20',668386,'2024-12-27 15:33:27',727069,26989,'','',30,0,2.00871,0.668,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630507,2,21395,0,0,1,5,1,1,'2024-12-27 15:33:20',669130,'2024-12-27 15:33:27',727294,26989,'','',30,0,2.00929,0.669,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630508,2,23551,0,0,1,1,0,1,'2024-12-27 15:33:27',727382,'2024-12-27 15:33:27',737102,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.146ms, lost 0%','rta=0.146ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630509,2,21396,0,0,1,5,0,1,'2024-12-27 15:33:35',799108,'2024-12-27 15:33:40',927103,26989,'','',30,0,0.02416,0.799,0,'OK - 192.168.77.159: rta 0.842ms, lost 0%','rta=0.842ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630510,2,23553,0,0,1,10,1,1,'2024-12-27 15:33:40',927482,'2024-12-27 15:33:42',0,26989,'','',30,0,1.081,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630511,2,28533,0,0,1,1,1,1,'2024-12-27 15:33:50',38,'2024-12-27 15:33:52',23887,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630512,2,23552,0,0,1,1,0,1,'2024-12-27 15:33:52',24275,'2024-12-27 15:33:52',28233,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.134ms, lost 0%','rta=0.134ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630513,2,23554,0,0,1,1,0,1,'2024-12-27 15:33:52',28426,'2024-12-27 15:33:52',32478,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630514,2,21395,0,0,1,5,1,1,'2024-12-27 15:33:55',0,'2024-12-27 15:33:57',0,26989,'','',30,0,2.008,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630515,2,23553,0,0,1,10,1,1,'2024-12-27 15:33:57',0,'2024-12-27 15:33:59',107078,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630516,2,23551,0,0,1,1,0,1,'2024-12-27 15:33:59',113276,'2024-12-27 15:34:00',117262,26989,'','',30,0,0.00926,4.113,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630517,2,23553,0,0,1,10,1,1,'2024-12-27 15:33:59',109862,'2024-12-27 15:34:00',117509,26989,'','',30,0,0.99526,4.109,2,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630518,2,23552,0,0,1,1,0,1,'2024-12-27 15:34:05',144065,'2024-12-27 15:34:10',165639,26989,'','',30,0,0.0105,0.144,0,'OK - 192.168.77.8: rta 0.131ms, lost 0%','rta=0.131ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630519,2,23549,0,0,1,10,0,1,'2024-12-27 15:34:05',145934,'2024-12-27 15:34:10',165880,26989,'','',30,0,0.01292,0.145,0,'OK - 84.38.95.222: rta 0.203ms, lost 0%','rta=0.203ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630520,2,28279,0,0,1,1,0,1,'2024-12-27 15:34:10',166211,'2024-12-27 15:34:10',174474,26989,'','',30,0,0.008,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630521,2,28279,0,0,1,1,0,1,'2024-12-27 15:34:10',176955,'2024-12-27 15:34:15',187740,26989,'','',30,0,0.00624,0.176,0,'OK - 192.168.77.9: rta 0.014ms, lost 0%','rta=0.014ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630522,2,23551,0,0,1,1,0,1,'2024-12-27 15:34:15',187838,'2024-12-27 15:34:15',198498,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630523,2,21396,0,0,1,5,0,1,'2024-12-27 15:34:20',232084,'2024-12-27 15:34:20',262975,26989,'','',30,0,0.03,0,0,'OK - 192.168.77.159: rta 1.133ms, lost 0%','rta=1.133ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630524,2,23553,0,0,1,10,1,1,'2024-12-27 15:34:20',263335,'2024-12-27 15:34:22',271895,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630525,2,23554,0,0,1,1,0,1,'2024-12-27 15:34:25',296565,'2024-12-27 15:34:25',306514,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630526,2,23554,0,0,1,1,0,1,'2024-12-27 15:34:22',274582,'2024-12-27 15:34:25',307026,26989,'','',30,0,0.00896,2.274,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630527,2,21397,0,0,1,5,1,1,'2024-12-27 15:34:27',311917,'2024-12-27 15:34:30',340240,26989,'','',30,0,2.00701,0.311,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630528,2,28533,0,0,1,1,1,1,'2024-12-27 15:34:27',314943,'2024-12-27 15:34:30',340511,26989,'','',30,0,2.008,0.314,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630529,2,23548,0,0,1,5,1,1,'2024-12-27 15:34:27',318322,'2024-12-27 15:34:30',340766,26989,'','',30,0,2.00849,0.318,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630530,2,21395,0,0,1,5,1,1,'2024-12-27 15:34:27',321074,'2024-12-27 15:34:30',341026,26989,'','',30,0,2.00687,0.321,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630531,2,21396,0,0,1,5,0,1,'2024-12-27 15:34:40',391947,'2024-12-27 15:34:45',414153,26989,'','',30,0,0.02783,0.391,0,'OK - 192.168.77.159: rta 1.067ms, lost 0%','rta=1.067ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630532,2,23552,0,0,1,1,0,1,'2024-12-27 15:34:45',414228,'2024-12-27 15:34:45',424517,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.127ms, lost 0%','rta=0.127ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630533,2,23553,0,0,1,10,1,1,'2024-12-27 15:34:45',424863,'2024-12-27 15:34:47',433433,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630534,2,23549,0,0,1,10,0,1,'2024-12-27 15:34:50',473207,'2024-12-27 15:34:50',485906,26989,'','',30,0,0.012,0,0,'OK - 84.38.95.222: rta 0.252ms, lost 0%','rta=0.252ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630535,2,23554,0,0,1,1,0,1,'2024-12-27 15:34:55',514138,'2024-12-27 15:34:55',524826,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630536,2,23551,0,0,1,1,0,1,'2024-12-27 15:34:55',525137,'2024-12-27 15:34:55',535007,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630537,2,23551,0,0,1,1,0,1,'2024-12-27 15:35:00',570352,'2024-12-27 15:35:05',603558,26989,'','',30,0,0.01046,0.57,0,'OK - 192.168.77.29: rta 0.183ms, lost 0%','rta=0.183ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630538,2,23553,0,0,1,10,1,1,'2024-12-27 15:35:00',573778,'2024-12-27 15:35:05',603795,26989,'','',30,0,2.00869,0.573,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630539,2,28533,0,0,1,1,1,1,'2024-12-27 15:35:05',604119,'2024-12-27 15:35:07',614279,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630540,2,23552,0,0,1,1,0,1,'2024-12-27 15:35:10',638394,'2024-12-27 15:35:10',648588,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.120ms, lost 0%','rta=0.120ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630541,2,23552,0,0,1,1,0,1,'2024-12-27 15:35:10',651061,'2024-12-27 15:35:15',686349,26989,'','',30,0,0.0084,0.651,0,'OK - 192.168.77.8: rta 0.123ms, lost 0%','rta=0.123ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630542,2,23549,0,0,1,10,0,1,'2024-12-27 15:35:10',654200,'2024-12-27 15:35:15',686561,26989,'','',30,0,0.01039,0.654,0,'OK - 84.38.95.222: rta 0.200ms, lost 0%','rta=0.200ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630543,2,21397,0,0,1,5,1,1,'2024-12-27 15:35:15',686621,'2024-12-27 15:35:17',695423,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630544,2,23553,0,0,1,10,1,1,'2024-12-27 15:35:17',695720,'2024-12-27 15:35:18',694617,26989,'','',30,0,0.999,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630545,2,28279,0,0,1,1,0,1,'2024-12-27 15:35:18',697142,'2024-12-27 15:35:20',726803,26989,'','',30,0,0.00659,3.697,0,'OK - 192.168.77.9: rta 0.014ms, lost 0%','rta=0.014ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630546,2,23554,0,0,1,1,0,1,'2024-12-27 15:35:20',726868,'2024-12-27 15:35:20',737200,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630547,2,28533,0,0,1,1,1,1,'2024-12-27 15:35:25',768263,'2024-12-27 15:35:27',778408,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630548,2,23554,0,0,1,1,0,1,'2024-12-27 15:35:27',780944,'2024-12-27 15:35:30',809853,26989,'','',30,0,0.00914,2.78,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630549,2,23551,0,0,1,1,0,1,'2024-12-27 15:35:30',809928,'2024-12-27 15:35:30',821302,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630550,2,28279,0,0,1,1,0,1,'2024-12-27 15:35:35',860925,'2024-12-27 15:35:35',869463,26989,'','',30,0,0.008,0,0,'OK - 192.168.77.9: rta 0.014ms, lost 0%','rta=0.014ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630551,2,21397,0,0,1,5,1,1,'2024-12-27 15:35:30',824306,'2024-12-27 15:35:35',870007,26989,'','',30,0,2.00871,0.824,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630552,2,28533,0,0,1,1,1,1,'2024-12-27 15:35:30',826916,'2024-12-27 15:35:35',870247,26989,'','',30,0,2.00793,0.826,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630553,2,23548,0,0,1,5,1,1,'2024-12-27 15:35:30',829940,'2024-12-27 15:35:35',870500,26989,'','',30,0,2.00838,0.829,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630554,2,21395,0,0,1,5,1,1,'2024-12-27 15:35:30',831919,'2024-12-27 15:35:35',870736,26989,'','',30,0,2.00811,0.831,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630555,2,23552,0,0,1,1,0,1,'2024-12-27 15:35:35',870824,'2024-12-27 15:35:35',880051,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.118ms, lost 0%','rta=0.118ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630556,2,23553,0,0,1,10,1,1,'2024-12-27 15:35:45',969082,'2024-12-27 15:35:47',977862,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630557,2,21397,0,0,1,5,1,1,'2024-12-27 15:35:47',978181,'2024-12-27 15:35:48',978104,26989,'','',30,0,1,0,1,'CRITICAL - 172.20.3.10: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630558,2,23554,0,0,1,1,0,1,'2024-12-27 15:35:48',978649,'2024-12-27 15:35:48',988555,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630559,2,21396,0,0,1,5,0,1,'2024-12-27 15:35:48',991041,'2024-12-27 15:35:50',2,26989,'','',30,0,0.02037,3.991,0,'OK - 192.168.77.159: rta 0.707ms, lost 0%','rta=0.707ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630560,2,28533,0,0,1,1,1,1,'2024-12-27 15:35:55',6933,'2024-12-27 15:35:57',161,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630561,2,23551,0,0,1,1,0,1,'2024-12-27 15:36:00',285,'2024-12-27 15:36:00',22795,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630562,2,23552,0,0,1,1,0,1,'2024-12-27 15:36:05',6,'2024-12-27 15:36:05',63,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.115ms, lost 0%','rta=0.115ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630563,2,23553,0,0,1,10,1,1,'2024-12-27 15:36:05',7,'2024-12-27 15:36:07',0,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630564,2,23551,0,0,1,1,0,1,'2024-12-27 15:36:07',0,'2024-12-27 15:36:10',115342,26989,'','',30,0,0.00897,2.098,0,'OK - 192.168.77.29: rta 0.154ms, lost 0%','rta=0.154ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630565,2,23553,0,0,1,10,1,1,'2024-12-27 15:36:07',101179,'2024-12-27 15:36:10',115569,26989,'','',30,0,0.98366,2.101,2,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630566,2,23548,0,0,1,5,1,1,'2024-12-27 15:36:10',115620,'2024-12-27 15:36:12',124930,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630567,2,23554,0,0,1,1,0,1,'2024-12-27 15:36:12',139103,'2024-12-27 15:36:12',150345,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630568,2,23552,0,0,1,1,0,1,'2024-12-27 15:36:15',164263,'2024-12-27 15:36:20',187350,26989,'','',30,0,0.00933,0.164,0,'OK - 192.168.77.8: rta 0.126ms, lost 0%','rta=0.126ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630569,2,23549,0,0,1,10,0,1,'2024-12-27 15:36:15',167878,'2024-12-27 15:36:20',187590,26989,'','',30,0,0.01238,0.167,0,'OK - 84.38.95.222: rta 0.303ms, lost 0%','rta=0.303ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630570,2,28279,0,0,1,1,0,1,'2024-12-27 15:36:20',189877,'2024-12-27 15:36:25',213133,26989,'','',30,0,0.00664,0.189,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630571,2,21395,0,0,1,5,1,1,'2024-12-27 15:36:25',213197,'2024-12-27 15:36:27',223440,26989,'','',30,0,2.009,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630572,2,23551,0,0,1,1,0,1,'2024-12-27 15:36:27',224093,'2024-12-27 15:36:27',235431,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630573,2,28533,0,0,1,1,1,1,'2024-12-27 15:36:30',285390,'2024-12-27 15:36:32',295071,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630574,2,23552,0,0,1,1,0,1,'2024-12-27 15:36:32',295601,'2024-12-27 15:36:32',305278,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.122ms, lost 0%','rta=0.122ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630575,2,23548,0,0,1,5,1,1,'2024-12-27 15:36:32',305559,'2024-12-27 15:36:34',313320,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630576,2,23554,0,0,1,1,0,1,'2024-12-27 15:36:34',315798,'2024-12-27 15:36:35',338140,26989,'','',30,0,0.00936,4.315,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630577,2,21397,0,0,1,5,1,1,'2024-12-27 15:36:35',340209,'2024-12-27 15:36:40',389554,26989,'','',30,0,2.00758,0.34,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630578,2,28533,0,0,1,1,1,1,'2024-12-27 15:36:35',343296,'2024-12-27 15:36:40',389802,26989,'','',30,0,2.00838,0.343,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630579,2,23548,0,0,1,5,1,1,'2024-12-27 15:36:35',346377,'2024-12-27 15:36:40',390030,26989,'','',30,0,2.0084,0.346,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630580,2,21395,0,0,1,5,1,1,'2024-12-27 15:36:35',347922,'2024-12-27 15:36:40',390266,26989,'','',30,0,2.00845,0.347,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630581,2,23553,0,0,1,10,1,1,'2024-12-27 15:36:40',390579,'2024-12-27 15:36:41',471655,26989,'','',30,0,1.08,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630582,2,23554,0,0,1,1,0,1,'2024-12-27 15:36:50',539565,'2024-12-27 15:36:50',550902,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630583,2,23552,0,0,1,1,0,1,'2024-12-27 15:36:50',551249,'2024-12-27 15:36:50',560890,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.137ms, lost 0%','rta=0.137ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630584,2,21396,0,0,1,5,0,1,'2024-12-27 15:36:50',564278,'2024-12-27 15:36:55',588575,26989,'','',30,0,0.02822,0.564,0,'OK - 192.168.77.159: rta 1.105ms, lost 0%','rta=1.105ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630585,2,23551,0,0,1,1,0,1,'2024-12-27 15:37:05',651100,'2024-12-27 15:37:05',661902,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630586,2,28533,0,0,1,1,1,1,'2024-12-27 15:37:05',662195,'2024-12-27 15:37:07',671106,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630587,2,28279,0,0,1,1,0,1,'2024-12-27 15:37:10',704714,'2024-12-27 15:37:10',712450,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630588,2,23551,0,0,1,1,0,1,'2024-12-27 15:37:10',715085,'2024-12-27 15:37:15',742075,26989,'','',30,0,0.00943,0.715,0,'OK - 192.168.77.29: rta 0.155ms, lost 0%','rta=0.155ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630589,2,23553,0,0,1,10,1,1,'2024-12-27 15:37:10',717384,'2024-12-27 15:37:15',742596,26989,'','',30,0,2.00819,0.717,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630590,2,23552,0,0,1,1,0,1,'2024-12-27 15:37:15',742654,'2024-12-27 15:37:15',753311,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630591,2,21396,0,0,1,5,0,1,'2024-12-27 15:37:20',798627,'2024-12-27 15:37:20',822984,26989,'','',30,0,0.024,0,0,'OK - 192.168.77.159: rta 0.862ms, lost 0%','rta=0.862ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630592,2,23552,0,0,1,1,0,1,'2024-12-27 15:37:20',825969,'2024-12-27 15:37:25',846270,26989,'','',30,0,0.01054,0.825,0,'OK - 192.168.77.8: rta 0.140ms, lost 0%','rta=0.140ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630593,2,23549,0,0,1,10,0,1,'2024-12-27 15:37:20',827967,'2024-12-27 15:37:25',846498,26989,'','',30,0,0.012,0.827,0,'OK - 84.38.95.222: rta 0.277ms, lost 0%','rta=0.277ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630594,2,23554,0,0,1,1,0,1,'2024-12-27 15:37:25',846551,'2024-12-27 15:37:25',857177,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630595,2,28279,0,0,1,1,0,1,'2024-12-27 15:37:25',859804,'2024-12-27 15:37:30',883946,26989,'','',30,0,0.00729,0.859,0,'OK - 192.168.77.9: rta 0.016ms, lost 0%','rta=0.016ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630596,2,23554,0,0,1,1,0,1,'2024-12-27 15:37:35',912130,'2024-12-27 15:37:40',940332,26989,'','',30,0,0.00912,0.912,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630597,2,21397,0,0,1,5,1,1,'2024-12-27 15:37:40',942529,'2024-12-27 15:37:45',972043,26989,'','',30,0,0.64113,0.942,2,'CRITICAL - 172.20.3.10: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630598,2,23548,0,0,1,5,1,1,'2024-12-27 15:37:40',949100,'2024-12-27 15:37:45',972325,26989,'','',30,0,0.63476,0.949,2,'CRITICAL - 172.20.3.11: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630599,2,28533,0,0,1,1,1,1,'2024-12-27 15:37:40',945385,'2024-12-27 15:37:45',972574,26989,'','',30,0,2.00926,0.945,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630600,2,21395,0,0,1,5,1,1,'2024-12-27 15:37:40',952074,'2024-12-27 15:37:45',972824,26989,'','',30,0,2.00854,0.952,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630601,2,23552,0,0,1,1,0,1,'2024-12-27 15:37:45',972891,'2024-12-27 15:37:45',983456,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.127ms, lost 0%','rta=0.127ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630602,2,23553,0,0,1,10,1,1,'2024-12-27 15:37:45',983852,'2024-12-27 15:37:47',993265,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630603,2,23549,0,0,1,10,0,1,'2024-12-27 15:37:50',66,'2024-12-27 15:37:50',149,26989,'','',30,0,0.012,0,0,'OK - 84.38.95.222: rta 0.202ms, lost 0%','rta=0.202ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630604,2,23554,0,0,1,1,0,1,'2024-12-27 15:37:55',3,'2024-12-27 15:37:55',20580,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630605,2,23551,0,0,1,1,0,1,'2024-12-27 15:37:55',324,'2024-12-27 15:37:55',24812,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630606,2,21396,0,0,1,5,0,1,'2024-12-27 15:37:55',50,'2024-12-27 15:38:00',0,26989,'','',30,0,0.0258,0.062,0,'OK - 192.168.77.159: rta 0.993ms, lost 0%','rta=0.993ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630607,2,28533,0,0,1,1,1,1,'2024-12-27 15:38:05',0,'2024-12-27 15:38:07',118552,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630608,2,23552,0,0,1,1,0,1,'2024-12-27 15:38:10',128645,'2024-12-27 15:38:10',138624,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.112ms, lost 0%','rta=0.112ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630609,2,21397,0,0,1,5,1,1,'2024-12-27 15:38:15',169008,'2024-12-27 15:38:17',177815,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630610,2,23553,0,0,1,10,1,1,'2024-12-27 15:38:17',192119,'2024-12-27 15:38:18',177922,26989,'','',30,0,0.986,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630611,2,23551,0,0,1,1,0,1,'2024-12-27 15:38:18',180383,'2024-12-27 15:38:20',205091,26989,'','',30,0,0.01024,3.18,0,'OK - 192.168.77.29: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630612,2,23554,0,0,1,1,0,1,'2024-12-27 15:38:20',205175,'2024-12-27 15:38:20',216182,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630613,2,23549,0,0,1,10,0,1,'2024-12-27 15:38:20',216524,'2024-12-27 15:38:20',229750,26989,'','',30,0,0.012,0,0,'OK - 84.38.95.222: rta 0.313ms, lost 0%','rta=0.313ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630614,2,23553,0,0,1,10,1,1,'2024-12-27 15:38:18',183531,'2024-12-27 15:38:20',230293,26989,'','',30,0,2.00867,3.183,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630615,2,28533,0,0,1,1,1,1,'2024-12-27 15:38:25',262325,'2024-12-27 15:38:27',271096,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630616,2,23552,0,0,1,1,0,1,'2024-12-27 15:38:27',286355,'2024-12-27 15:38:30',306143,26989,'','',30,0,0.01052,2.286,0,'OK - 192.168.77.8: rta 0.184ms, lost 0%','rta=0.184ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630617,2,23549,0,0,1,10,0,1,'2024-12-27 15:38:27',288177,'2024-12-27 15:38:30',306372,26989,'','',30,0,0.01288,2.288,0,'OK - 84.38.95.222: rta 0.290ms, lost 0%','rta=0.290ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630618,2,28279,0,0,1,1,0,1,'2024-12-27 15:38:30',308990,'2024-12-27 15:38:35',324025,26989,'','',30,0,0.00662,0.308,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630619,2,23551,0,0,1,1,0,1,'2024-12-27 15:38:40',337145,'2024-12-27 15:38:40',348536,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630620,2,23554,0,0,1,1,0,1,'2024-12-27 15:38:40',354175,'2024-12-27 15:38:45',370107,26989,'','',30,0,0.00997,0.354,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630621,2,21397,0,0,1,5,1,1,'2024-12-27 15:38:45',370170,'2024-12-27 15:38:47',379767,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630622,2,23553,0,0,1,10,1,1,'2024-12-27 15:38:47',394095,'2024-12-27 15:38:48',378933,26989,'','',30,0,0.985,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630623,2,21397,0,0,1,5,1,1,'2024-12-27 15:38:48',381888,'2024-12-27 15:38:50',407204,26989,'','',30,0,2.00636,3.381,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630624,2,23548,0,0,1,5,1,1,'2024-12-27 15:38:48',384982,'2024-12-27 15:38:50',407462,26989,'','',30,0,2.0075,3.384,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630625,2,28533,0,0,1,1,1,1,'2024-12-27 15:38:48',387182,'2024-12-27 15:38:50',407692,26989,'','',30,0,2.00858,3.387,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630626,2,21395,0,0,1,5,1,1,'2024-12-27 15:38:48',388894,'2024-12-27 15:38:50',407928,26989,'','',30,0,2.0081,3.388,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630627,2,23551,0,0,1,1,0,1,'2024-12-27 15:39:00',446781,'2024-12-27 15:39:00',457995,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630628,2,21396,0,0,1,5,0,1,'2024-12-27 15:39:00',460637,'2024-12-27 15:39:05',471232,26989,'','',30,0,0.02196,0.46,0,'OK - 192.168.77.159: rta 0.794ms, lost 0%','rta=0.794ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630629,2,23552,0,0,1,1,0,1,'2024-12-27 15:39:05',471310,'2024-12-27 15:39:05',481412,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.117ms, lost 0%','rta=0.117ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630630,2,23553,0,0,1,10,1,1,'2024-12-27 15:39:05',481787,'2024-12-27 15:39:07',490226,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630631,2,23548,0,0,1,5,1,1,'2024-12-27 15:39:10',504982,'2024-12-27 15:39:12',514208,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630632,2,23554,0,0,1,1,0,1,'2024-12-27 15:39:12',514483,'2024-12-27 15:39:12',524598,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630633,2,23551,0,0,1,1,0,1,'2024-12-27 15:39:20',584489,'2024-12-27 15:39:25',617462,26989,'','',30,0,0.00953,0.584,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630634,2,21395,0,0,1,5,1,1,'2024-12-27 15:39:25',617533,'2024-12-27 15:39:27',626847,26989,'','',30,0,2.009,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630635,2,23552,0,0,1,1,0,1,'2024-12-27 15:39:27',627218,'2024-12-27 15:39:27',637292,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.144ms, lost 0%','rta=0.144ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630636,2,23553,0,0,1,10,1,1,'2024-12-27 15:39:20',587710,'2024-12-27 15:39:27',637839,26989,'','',30,0,2.00818,0.587,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630637,2,28533,0,0,1,1,1,1,'2024-12-27 15:39:30',677807,'2024-12-27 15:39:32',687883,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630638,2,23548,0,0,1,5,1,1,'2024-12-27 15:39:35',711321,'2024-12-27 15:39:36',758189,26989,'','',30,0,1.046,0,1,'CRITICAL - 172.20.3.11: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630639,2,23552,0,0,1,1,0,1,'2024-12-27 15:39:32',690903,'2024-12-27 15:39:36',759056,26989,'','',30,0,0.00881,2.69,0,'OK - 192.168.77.8: rta 0.139ms, lost 0%','rta=0.139ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630640,2,23549,0,0,1,10,0,1,'2024-12-27 15:39:32',694067,'2024-12-27 15:39:36',759290,26989,'','',30,0,0.01071,2.694,0,'OK - 84.38.95.222: rta 0.202ms, lost 0%','rta=0.202ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630641,2,28279,0,0,1,1,0,1,'2024-12-27 15:39:36',761630,'2024-12-27 15:39:40',806897,26989,'','',30,0,0.00636,1.761,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630642,2,23553,0,0,1,10,1,1,'2024-12-27 15:39:40',807284,'2024-12-27 15:39:41',884205,26989,'','',30,0,1.076,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630643,2,23551,0,0,1,1,0,1,'2024-12-27 15:39:41',884545,'2024-12-27 15:39:41',894501,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.148ms, lost 0%','rta=0.148ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630644,2,23554,0,0,1,1,0,1,'2024-12-27 15:39:45',924229,'2024-12-27 15:39:50',971750,26989,'','',30,0,0.00944,0.924,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630645,2,23552,0,0,1,1,0,1,'2024-12-27 15:39:50',972348,'2024-12-27 15:39:50',983118,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.127ms, lost 0%','rta=0.127ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630646,2,21395,0,0,1,5,1,1,'2024-12-27 15:39:50',983919,'2024-12-27 15:39:51',946444,26989,'','',30,0,0.963,0,1,'CRITICAL - 192.168.77.154: Host unreachable @ 192.168.77.9. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630647,2,21397,0,0,1,5,1,1,'2024-12-27 15:39:51',948956,'2024-12-27 15:39:55',984473,26989,'','',30,0,0.0641,1.948,2,'CRITICAL - 172.20.3.10: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630648,2,23548,0,0,1,5,1,1,'2024-12-27 15:39:51',952049,'2024-12-27 15:39:55',984751,26989,'','',30,0,0.06162,1.952,2,'CRITICAL - 172.20.3.11: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630649,2,28533,0,0,1,1,1,1,'2024-12-27 15:39:51',954808,'2024-12-27 15:39:55',985022,26989,'','',30,0,2.00872,1.954,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630650,2,21395,0,0,1,5,1,1,'2024-12-27 15:39:51',957897,'2024-12-27 15:39:55',985273,26989,'','',30,0,2.00825,1.957,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630651,2,23554,0,0,1,1,0,1,'2024-12-27 15:40:01',0,'2024-12-27 15:40:01',1,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630652,2,23551,0,0,1,1,0,1,'2024-12-27 15:40:05',32,'2024-12-27 15:40:05',2665,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630653,2,21396,0,0,1,5,0,1,'2024-12-27 15:40:05',22757,'2024-12-27 15:40:10',59,26989,'','',30,0,0.02101,0.054,0,'OK - 192.168.77.159: rta 0.746ms, lost 0%','rta=0.746ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630654,2,28279,0,0,1,1,0,1,'2024-12-27 15:40:10',481,'2024-12-27 15:40:10',0,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630655,2,23552,0,0,1,1,0,1,'2024-12-27 15:40:15',0,'2024-12-27 15:40:15',105738,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.123ms, lost 0%','rta=0.123ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630656,2,23553,0,0,1,10,1,1,'2024-12-27 15:40:20',120307,'2024-12-27 15:40:22',129209,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630657,2,23554,0,0,1,1,0,1,'2024-12-27 15:40:25',137146,'2024-12-27 15:40:25',147732,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630658,2,23551,0,0,1,1,0,1,'2024-12-27 15:40:25',150136,'2024-12-27 15:40:30',181062,26989,'','',30,0,0.00888,0.15,0,'OK - 192.168.77.29: rta 0.148ms, lost 0%','rta=0.148ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630659,2,23553,0,0,1,10,1,1,'2024-12-27 15:40:27',156482,'2024-12-27 15:40:30',181297,26989,'','',30,0,2.00672,0.156,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630660,2,23552,0,0,1,1,0,1,'2024-12-27 15:40:36',211707,'2024-12-27 15:40:40',239207,26989,'','',30,0,0.00872,0.211,0,'OK - 192.168.77.8: rta 0.128ms, lost 0%','rta=0.128ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630661,2,23549,0,0,1,10,0,1,'2024-12-27 15:40:36',214795,'2024-12-27 15:40:40',239449,26989,'','',30,0,0.01065,0.214,0,'OK - 84.38.95.222: rta 0.201ms, lost 0%','rta=0.201ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630662,2,28279,0,0,1,1,0,1,'2024-12-27 15:40:40',241684,'2024-12-27 15:40:45',263305,26989,'','',30,0,0.00661,0.241,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630663,2,23553,0,0,1,10,1,1,'2024-12-27 15:40:45',263672,'2024-12-27 15:40:47',273419,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630664,2,23554,0,0,1,1,0,1,'2024-12-27 15:40:50',301411,'2024-12-27 15:40:55',332112,26989,'','',30,0,0.01015,0.301,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630665,2,23551,0,0,1,1,0,1,'2024-12-27 15:40:55',332443,'2024-12-27 15:40:55',343934,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630666,2,21397,0,0,1,5,1,1,'2024-12-27 15:40:55',346438,'2024-12-27 15:41:00',392777,26989,'','',30,0,2.00806,0.346,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630667,2,23548,0,0,1,5,1,1,'2024-12-27 15:40:55',347384,'2024-12-27 15:41:00',393024,26989,'','',30,0,2.00981,0.347,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630668,2,28533,0,0,1,1,1,1,'2024-12-27 15:40:55',349680,'2024-12-27 15:41:00',393259,26989,'','',30,0,2.00764,0.349,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630669,2,21395,0,0,1,5,1,1,'2024-12-27 15:40:55',350868,'2024-12-27 15:41:00',393496,26989,'','',30,0,2.00803,0.35,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630670,2,23552,0,0,1,1,0,1,'2024-12-27 15:41:10',455024,'2024-12-27 15:41:10',465425,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.116ms, lost 0%','rta=0.116ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630671,2,21396,0,0,1,5,0,1,'2024-12-27 15:41:10',467921,'2024-12-27 15:41:15',495135,26989,'','',30,0,0.02837,0.467,0,'OK - 192.168.77.159: rta 1.125ms, lost 0%','rta=1.125ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630672,2,21397,0,0,1,5,1,1,'2024-12-27 15:41:15',495192,'2024-12-27 15:41:17',505558,26989,'','',30,0,2.01,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630673,2,23553,0,0,1,10,1,1,'2024-12-27 15:41:17',505876,'2024-12-27 15:41:18',503736,26989,'','',30,0,0.998,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630674,2,23554,0,0,1,1,0,1,'2024-12-27 15:41:20',532424,'2024-12-27 15:41:20',543198,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.154ms, lost 0%','rta=0.154ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630675,2,23549,0,0,1,10,0,1,'2024-12-27 15:41:20',543511,'2024-12-27 15:41:20',554787,26989,'','',30,0,0.011,0,0,'OK - 84.38.95.222: rta 0.216ms, lost 0%','rta=0.216ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630676,2,28533,0,0,1,1,1,1,'2024-12-27 15:41:25',584187,'2024-12-27 15:41:27',594116,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630677,2,23551,0,0,1,1,0,1,'2024-12-27 15:41:30',625139,'2024-12-27 15:41:30',636130,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630678,2,23551,0,0,1,1,0,1,'2024-12-27 15:41:30',638979,'2024-12-27 15:41:35',673800,26989,'','',30,0,0.00963,0.638,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630679,2,28279,0,0,1,1,0,1,'2024-12-27 15:41:35',673880,'2024-12-27 15:41:35',682533,26989,'','',30,0,0.008,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630680,2,23553,0,0,1,10,1,1,'2024-12-27 15:41:30',639884,'2024-12-27 15:41:35',683052,26989,'','',30,0,2.0106,0.639,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630681,2,23552,0,0,1,1,0,1,'2024-12-27 15:41:35',683130,'2024-12-27 15:41:35',692416,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.117ms, lost 0%','rta=0.117ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630682,2,23552,0,0,1,1,0,1,'2024-12-27 15:41:40',726004,'2024-12-27 15:41:45',755848,26989,'','',30,0,0.01045,0.725,0,'OK - 192.168.77.8: rta 0.155ms, lost 0%','rta=0.155ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630683,2,23549,0,0,1,10,0,1,'2024-12-27 15:41:40',729088,'2024-12-27 15:41:45',756117,26989,'','',30,0,0.01102,0.729,0,'OK - 84.38.95.222: rta 0.233ms, lost 0%','rta=0.233ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630684,2,21397,0,0,1,5,1,1,'2024-12-27 15:41:45',756181,'2024-12-27 15:41:47',764807,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630685,2,23553,0,0,1,10,1,1,'2024-12-27 15:41:47',765159,'2024-12-27 15:41:48',765068,26989,'','',30,0,1,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630686,2,23554,0,0,1,1,0,1,'2024-12-27 15:41:48',765689,'2024-12-27 15:41:48',775738,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630687,2,28279,0,0,1,1,0,1,'2024-12-27 15:41:48',778377,'2024-12-27 15:41:50',807298,26989,'','',30,0,0.00624,3.778,0,'OK - 192.168.77.9: rta 0.014ms, lost 0%','rta=0.014ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630688,2,28533,0,0,1,1,1,1,'2024-12-27 15:41:55',833248,'2024-12-27 15:41:56',894971,26989,'','',30,0,1.061,0,1,'CRITICAL - 172.50.1.3: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630689,2,23554,0,0,1,1,0,1,'2024-12-27 15:41:56',897477,'2024-12-27 15:42:00',937702,26989,'','',30,0,0.00896,1.897,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630690,2,23551,0,0,1,1,0,1,'2024-12-27 15:42:00',938392,'2024-12-27 15:42:00',949647,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.29: rta 0.148ms, lost 0%','rta=0.148ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630691,2,21397,0,0,1,5,1,1,'2024-12-27 15:42:00',952504,'2024-12-27 15:42:05',991867,26989,'','',30,0,2.00778,0.952,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630692,2,23548,0,0,1,5,1,1,'2024-12-27 15:42:00',955595,'2024-12-27 15:42:05',992106,26989,'','',30,0,2.00841,0.955,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630693,2,28533,0,0,1,1,1,1,'2024-12-27 15:42:00',959076,'2024-12-27 15:42:05',992321,26989,'','',30,0,2.00792,0.959,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630694,2,21395,0,0,1,5,1,1,'2024-12-27 15:42:00',960977,'2024-12-27 15:42:05',992543,26989,'','',30,0,2.00883,0.96,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630695,2,23552,0,0,1,1,0,1,'2024-12-27 15:42:05',992597,'2024-12-27 15:42:06',1423,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.119ms, lost 0%','rta=0.119ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630696,2,23553,0,0,1,10,1,1,'2024-12-27 15:42:06',2,'2024-12-27 15:42:08',535,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630697,2,21396,0,0,1,5,0,1,'2024-12-27 15:42:15',3,'2024-12-27 15:42:20',47,26989,'','',30,0,0.02055,0.038,0,'OK - 192.168.77.159: rta 0.729ms, lost 0%','rta=0.729ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630698,2,21395,0,0,1,5,1,1,'2024-12-27 15:42:25',32443,'2024-12-27 15:42:27',0,26989,'','',30,0,2.009,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630699,2,23552,0,0,1,1,0,1,'2024-12-27 15:42:27',0,'2024-12-27 15:42:27',0,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.131ms, lost 0%','rta=0.131ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630700,2,23551,0,0,1,1,0,1,'2024-12-27 15:42:27',0,'2024-12-27 15:42:27',107164,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630701,2,28533,0,0,1,1,1,1,'2024-12-27 15:42:30',162465,'2024-12-27 15:42:32',173475,26989,'','',30,0,2.01,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630702,2,23548,0,0,1,5,1,1,'2024-12-27 15:42:32',174257,'2024-12-27 15:42:34',182707,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630703,2,23551,0,0,1,1,0,1,'2024-12-27 15:42:35',204348,'2024-12-27 15:42:40',247011,26989,'','',30,0,0.00936,0.204,0,'OK - 192.168.77.29: rta 0.154ms, lost 0%','rta=0.154ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630704,2,23553,0,0,1,10,1,1,'2024-12-27 15:42:35',207628,'2024-12-27 15:42:40',247231,26989,'','',30,0,2.00735,0.207,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630705,2,23552,0,0,1,1,0,1,'2024-12-27 15:42:45',286539,'2024-12-27 15:42:50',327183,26989,'','',30,0,0.00955,0.286,0,'OK - 192.168.77.8: rta 0.119ms, lost 0%','rta=0.119ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630706,2,23549,0,0,1,10,0,1,'2024-12-27 15:42:45',290699,'2024-12-27 15:42:50',327407,26989,'','',30,0,0.01173,0.29,0,'OK - 84.38.95.222: rta 0.215ms, lost 0%','rta=0.215ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630707,2,23554,0,0,1,1,0,1,'2024-12-27 15:42:50',328218,'2024-12-27 15:42:50',338899,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630708,2,21395,0,0,1,5,1,1,'2024-12-27 15:42:55',379885,'2024-12-27 15:42:57',390573,26989,'','',30,0,2.01,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630709,2,28279,0,0,1,1,0,1,'2024-12-27 15:42:50',341572,'2024-12-27 15:42:57',391019,26989,'','',30,0,0.00617,0.341,0,'OK - 192.168.77.9: rta 0.014ms, lost 0%','rta=0.014ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630710,2,23553,0,0,1,10,1,1,'2024-12-27 15:42:57',391084,'2024-12-27 15:42:59',399067,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630711,2,23554,0,0,1,1,0,1,'2024-12-27 15:43:00',405324,'2024-12-27 15:43:05',438402,26989,'','',30,0,0.00913,0.405,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630712,2,23551,0,0,1,1,0,1,'2024-12-27 15:43:05',438473,'2024-12-27 15:43:05',449883,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630713,2,28533,0,0,1,1,1,1,'2024-12-27 15:43:05',450233,'2024-12-27 15:43:07',459610,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630714,2,28279,0,0,1,1,0,1,'2024-12-27 15:43:10',503797,'2024-12-27 15:43:10',511512,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.014ms, lost 0%','rta=0.014ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630715,2,28533,0,0,1,1,1,1,'2024-12-27 15:43:07',466942,'2024-12-27 15:43:10',512025,26989,'','',30,0,0.98995,2.466,2,'CRITICAL - 172.50.1.3: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630716,2,21397,0,0,1,5,1,1,'2024-12-27 15:43:07',462013,'2024-12-27 15:43:10',512264,26989,'','',30,0,2.00812,2.461,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630717,2,23548,0,0,1,5,1,1,'2024-12-27 15:43:07',464451,'2024-12-27 15:43:10',512501,26989,'','',30,0,2.00901,2.464,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630718,2,21395,0,0,1,5,1,1,'2024-12-27 15:43:07',470634,'2024-12-27 15:43:10',512722,26989,'','',30,0,2.00797,2.47,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630719,2,23552,0,0,1,1,0,1,'2024-12-27 15:43:15',536074,'2024-12-27 15:43:15',546171,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.122ms, lost 0%','rta=0.122ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630720,2,21396,0,0,1,5,0,1,'2024-12-27 15:43:20',603466,'2024-12-27 15:43:20',624968,26989,'','',30,0,0.021,0,0,'OK - 192.168.77.159: rta 0.704ms, lost 0%','rta=0.704ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630721,2,23553,0,0,1,10,1,1,'2024-12-27 15:43:20',625303,'2024-12-27 15:43:22',632870,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630722,2,23554,0,0,1,1,0,1,'2024-12-27 15:43:25',653289,'2024-12-27 15:43:25',664475,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630723,2,21396,0,0,1,5,0,1,'2024-12-27 15:43:22',635586,'2024-12-27 15:43:25',664999,26989,'','',30,0,0.03009,2.635,0,'OK - 192.168.77.159: rta 1.187ms, lost 0%','rta=1.187ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630724,2,23551,0,0,1,1,0,1,'2024-12-27 15:43:40',752209,'2024-12-27 15:43:45',782036,26989,'','',30,0,0.00974,0.752,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630725,2,23553,0,0,1,10,1,1,'2024-12-27 15:43:40',755869,'2024-12-27 15:43:45',782274,26989,'','',30,0,0.64626,0.755,2,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630726,2,23552,0,0,1,1,0,1,'2024-12-27 15:43:45',782334,'2024-12-27 15:43:45',792551,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.122ms, lost 0%','rta=0.122ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630727,2,23549,0,0,1,10,0,1,'2024-12-27 15:43:50',834680,'2024-12-27 15:43:50',847398,26989,'','',30,0,0.012,0,0,'OK - 84.38.95.222: rta 0.231ms, lost 0%','rta=0.231ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630728,2,23552,0,0,1,1,0,1,'2024-12-27 15:43:50',849837,'2024-12-27 15:43:55',880129,26989,'','',30,0,0.00826,0.849,0,'OK - 192.168.77.8: rta 0.121ms, lost 0%','rta=0.121ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630729,2,23549,0,0,1,10,0,1,'2024-12-27 15:43:50',852849,'2024-12-27 15:43:55',880355,26989,'','',30,0,0.01093,0.852,0,'OK - 84.38.95.222: rta 0.231ms, lost 0%','rta=0.231ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630730,2,23554,0,0,1,1,0,1,'2024-12-27 15:43:55',880418,'2024-12-27 15:43:55',891708,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630731,2,28279,0,0,1,1,0,1,'2024-12-27 15:43:57',902134,'2024-12-27 15:44:00',934976,26989,'','',30,0,0.00781,0.902,0,'OK - 192.168.77.9: rta 0.016ms, lost 0%','rta=0.016ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630732,2,23551,0,0,1,1,0,1,'2024-12-27 15:44:00',935563,'2024-12-27 15:44:00',945791,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630733,2,28533,0,0,1,1,1,1,'2024-12-27 15:44:05',975881,'2024-12-27 15:44:07',985551,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630734,2,23554,0,0,1,1,0,1,'2024-12-27 15:44:07',988158,'2024-12-27 15:44:11',6898,26989,'','',30,0,0.00917,2.988,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630735,2,23552,0,0,1,1,0,1,'2024-12-27 15:44:11',6935,'2024-12-27 15:44:11',174,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.129ms, lost 0%','rta=0.129ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630736,2,21397,0,0,1,5,1,1,'2024-12-27 15:44:15',40,'2024-12-27 15:44:17',5,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630737,2,28533,0,0,1,1,1,1,'2024-12-27 15:44:11',2,'2024-12-27 15:44:17',384,26989,'','',30,0,2.00688,1.028,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630738,2,21397,0,0,1,5,1,1,'2024-12-27 15:44:11',13030,'2024-12-27 15:44:17',24799,26989,'','',30,0,2.00681,1.031,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630739,2,23548,0,0,1,5,1,1,'2024-12-27 15:44:11',14833,'2024-12-27 15:44:17',389,26989,'','',30,0,2.00739,1.034,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630740,2,21395,0,0,1,5,1,1,'2024-12-27 15:44:11',3,'2024-12-27 15:44:17',48,26989,'','',30,0,2.00819,1.038,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630741,2,23553,0,0,1,10,1,1,'2024-12-27 15:44:20',31474,'2024-12-27 15:44:22',0,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630742,2,23549,0,0,1,10,0,1,'2024-12-27 15:44:22',0,'2024-12-27 15:44:22',112143,26989,'','',30,0,0.012,0,0,'OK - 84.38.95.222: rta 0.276ms, lost 0%','rta=0.276ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630743,2,21396,0,0,1,5,0,1,'2024-12-27 15:44:25',127493,'2024-12-27 15:44:30',144499,26989,'','',30,0,0.03263,0.127,0,'OK - 192.168.77.159: rta 1.274ms, lost 0%','rta=1.274ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630744,2,23551,0,0,1,1,0,1,'2024-12-27 15:44:30',144583,'2024-12-27 15:44:30',156173,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.29: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630745,2,28279,0,0,1,1,0,1,'2024-12-27 15:44:35',173361,'2024-12-27 15:44:35',181534,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630746,2,23552,0,0,1,1,0,1,'2024-12-27 15:44:35',181917,'2024-12-27 15:44:35',192723,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.142ms, lost 0%','rta=0.142ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630747,2,21397,0,0,1,5,1,1,'2024-12-27 15:44:45',234260,'2024-12-27 15:44:47',242679,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630748,2,23553,0,0,1,10,1,1,'2024-12-27 15:44:47',243024,'2024-12-27 15:44:48',241905,26989,'','',30,0,0.999,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630749,2,23554,0,0,1,1,0,1,'2024-12-27 15:44:48',242498,'2024-12-27 15:44:48',252374,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630750,2,23551,0,0,1,1,0,1,'2024-12-27 15:44:48',254975,'2024-12-27 15:44:50',291373,26989,'','',30,0,0.00963,3.254,0,'OK - 192.168.77.29: rta 0.186ms, lost 0%','rta=0.186ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630751,2,23553,0,0,1,10,1,1,'2024-12-27 15:44:48',257708,'2024-12-27 15:44:50',291627,26989,'','',30,0,2.00773,3.257,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630752,2,28533,0,0,1,1,1,1,'2024-12-27 15:44:55',316498,'2024-12-27 15:44:56',374575,26989,'','',30,0,1.057,0,1,'CRITICAL - 172.50.1.3: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630753,2,23552,0,0,1,1,0,1,'2024-12-27 15:44:56',377016,'2024-12-27 15:45:00',397686,26989,'','',30,0,0.01186,1.376,0,'OK - 192.168.77.8: rta 0.253ms, lost 0%','rta=0.253ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630754,2,23549,0,0,1,10,0,1,'2024-12-27 15:44:56',377678,'2024-12-27 15:45:00',397930,26989,'','',30,0,0.01921,1.377,0,'OK - 84.38.95.222: rta 0.484ms, lost 0%','rta=0.484ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630755,2,28279,0,0,1,1,0,1,'2024-12-27 15:45:00',401391,'2024-12-27 15:45:05',422073,26989,'','',30,0,0.00739,0.401,0,'OK - 192.168.77.9: rta 0.016ms, lost 0%','rta=0.016ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630756,2,23551,0,0,1,1,0,1,'2024-12-27 15:45:05',422410,'2024-12-27 15:45:05',432466,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630757,2,23553,0,0,1,10,1,1,'2024-12-27 15:45:05',432790,'2024-12-27 15:45:07',440961,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630758,2,23548,0,0,1,5,1,1,'2024-12-27 15:45:10',473369,'2024-12-27 15:45:12',483603,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630759,2,23554,0,0,1,1,0,1,'2024-12-27 15:45:12',483921,'2024-12-27 15:45:12',494283,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.163ms, lost 0%','rta=0.163ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630760,2,23554,0,0,1,1,0,1,'2024-12-27 15:45:12',496761,'2024-12-27 15:45:15',524691,26989,'','',30,0,0.00904,1.496,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630761,2,28533,0,0,1,1,1,1,'2024-12-27 15:45:17',536632,'2024-12-27 15:45:20',573894,26989,'','',30,0,2.00865,0.536,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630762,2,21397,0,0,1,5,1,1,'2024-12-27 15:45:17',539663,'2024-12-27 15:45:20',574126,26989,'','',30,0,2.00794,0.539,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630763,2,23548,0,0,1,5,1,1,'2024-12-27 15:45:17',540666,'2024-12-27 15:45:20',574360,26989,'','',30,0,2.0089,0.54,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630764,2,21395,0,0,1,5,1,1,'2024-12-27 15:45:17',542412,'2024-12-27 15:45:20',574580,26989,'','',30,0,2.00822,0.542,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630765,2,23552,0,0,1,1,0,1,'2024-12-27 15:45:25',604116,'2024-12-27 15:45:25',614866,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.126ms, lost 0%','rta=0.126ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630766,2,23551,0,0,1,1,0,1,'2024-12-27 15:45:25',615200,'2024-12-27 15:45:25',625431,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630767,2,23548,0,0,1,5,1,1,'2024-12-27 15:45:35',710231,'2024-12-27 15:45:36',748520,26989,'','',30,0,1.037,0,1,'CRITICAL - 172.20.3.11: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630768,2,21396,0,0,1,5,0,1,'2024-12-27 15:45:30',669408,'2024-12-27 15:45:36',749047,26989,'','',30,0,0.02435,0.669,0,'OK - 192.168.77.159: rta 0.850ms, lost 0%','rta=0.850ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630769,2,28533,0,0,1,1,1,1,'2024-12-27 15:45:36',749109,'2024-12-27 15:45:38',758611,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630770,2,23553,0,0,1,10,1,1,'2024-12-27 15:45:40',799138,'2024-12-27 15:45:41',875476,26989,'','',30,0,1.076,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630771,2,23551,0,0,1,1,0,1,'2024-12-27 15:45:41',875813,'2024-12-27 15:45:41',885746,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.148ms, lost 0%','rta=0.148ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630772,2,23552,0,0,1,1,0,1,'2024-12-27 15:45:50',977818,'2024-12-27 15:45:50',987797,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.117ms, lost 0%','rta=0.117ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630773,2,23554,0,0,1,1,0,1,'2024-12-27 15:45:50',988111,'2024-12-27 15:45:50',997986,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630774,2,21395,0,0,1,5,1,1,'2024-12-27 15:45:55',121,'2024-12-27 15:45:57',183,26989,'','',30,0,2.009,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630775,2,23551,0,0,1,1,0,1,'2024-12-27 15:45:51',0,'2024-12-27 15:45:57',11938,26989,'','',30,0,0.00905,1,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630776,2,23553,0,0,1,10,1,1,'2024-12-27 15:45:51',3,'2024-12-27 15:45:57',12086,26989,'','',30,0,1.00199,1.003,2,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630777,2,23552,0,0,1,1,0,1,'2024-12-27 15:46:00',3,'2024-12-27 15:46:05',55,26989,'','',30,0,0.00981,0.038,0,'OK - 192.168.77.8: rta 0.138ms, lost 0%','rta=0.138ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630778,2,23549,0,0,1,10,0,1,'2024-12-27 15:46:00',17671,'2024-12-27 15:46:05',6,26989,'','',30,0,0.01313,0.042,0,'OK - 84.38.95.222: rta 0.338ms, lost 0%','rta=0.338ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630779,2,28533,0,0,1,1,1,1,'2024-12-27 15:46:05',6,'2024-12-27 15:46:07',32641,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630780,2,28279,0,0,1,1,0,1,'2024-12-27 15:46:07',0,'2024-12-27 15:46:10',0,26989,'','',30,0,0.00656,2.08,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630781,2,23551,0,0,1,1,0,1,'2024-12-27 15:46:15',111629,'2024-12-27 15:46:15',122396,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630782,2,23554,0,0,1,1,0,1,'2024-12-27 15:46:15',125168,'2024-12-27 15:46:20',144255,26989,'','',30,0,0.00891,0.125,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630783,2,21396,0,0,1,5,0,1,'2024-12-27 15:46:20',144309,'2024-12-27 15:46:20',166574,26989,'','',30,0,0.022,0,0,'OK - 192.168.77.159: rta 0.758ms, lost 0%','rta=0.758ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630784,2,23553,0,0,1,10,1,1,'2024-12-27 15:46:20',166911,'2024-12-27 15:46:22',175660,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630785,2,23548,0,0,1,5,1,1,'2024-12-27 15:46:22',182180,'2024-12-27 15:46:25',192574,26989,'','',30,0,0.99067,2.182,2,'CRITICAL - 172.20.3.11: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630786,2,21397,0,0,1,5,1,1,'2024-12-27 15:46:22',181396,'2024-12-27 15:46:25',192835,26989,'','',30,0,0.99161,2.181,2,'CRITICAL - 172.20.3.10: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630787,2,28533,0,0,1,1,1,1,'2024-12-27 15:46:22',178387,'2024-12-27 15:46:25',193090,26989,'','',30,0,2.00752,2.178,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630788,2,21395,0,0,1,5,1,1,'2024-12-27 15:46:22',183092,'2024-12-27 15:46:25',193332,26989,'','',30,0,2.01125,2.183,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630789,2,21396,0,0,1,5,0,1,'2024-12-27 15:46:36',231826,'2024-12-27 15:46:40',267426,26989,'','',30,0,0.02967,0.231,0,'OK - 192.168.77.159: rta 1.122ms, lost 0%','rta=1.122ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630790,2,23552,0,0,1,1,0,1,'2024-12-27 15:46:45',290231,'2024-12-27 15:46:45',300677,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.140ms, lost 0%','rta=0.140ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630791,2,23553,0,0,1,10,1,1,'2024-12-27 15:46:45',301024,'2024-12-27 15:46:47',310354,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630792,2,23549,0,0,1,10,0,1,'2024-12-27 15:46:50',340019,'2024-12-27 15:46:50',358447,26989,'','',30,0,0.018,0,0,'OK - 84.38.95.222: rta 0.519ms, lost 0%','rta=0.519ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630793,2,23554,0,0,1,1,0,1,'2024-12-27 15:46:55',378320,'2024-12-27 15:46:55',389021,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630794,2,23551,0,0,1,1,0,1,'2024-12-27 15:46:55',389333,'2024-12-27 15:46:55',399214,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630795,2,23551,0,0,1,1,0,1,'2024-12-27 15:46:57',408403,'2024-12-27 15:47:00',439637,26989,'','',30,0,0.01148,0.408,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630796,2,23553,0,0,1,10,1,1,'2024-12-27 15:46:57',409391,'2024-12-27 15:47:00',440193,26989,'','',30,0,2.00852,0.409,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630797,2,28533,0,0,1,1,1,1,'2024-12-27 15:47:05',474614,'2024-12-27 15:47:07',483322,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630798,2,23552,0,0,1,1,0,1,'2024-12-27 15:47:07',485999,'2024-12-27 15:47:10',515058,26989,'','',30,0,0.01206,2.485,0,'OK - 192.168.77.8: rta 0.129ms, lost 0%','rta=0.129ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630799,2,23549,0,0,1,10,0,1,'2024-12-27 15:47:07',486969,'2024-12-27 15:47:10',515293,26989,'','',30,0,0.01511,2.486,0,'OK - 84.38.95.222: rta 0.431ms, lost 0%','rta=0.431ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630800,2,28279,0,0,1,1,0,1,'2024-12-27 15:47:10',517877,'2024-12-27 15:47:15',548449,26989,'','',30,0,0.00682,0.517,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630801,2,21397,0,0,1,5,1,1,'2024-12-27 15:47:15',548510,'2024-12-27 15:47:17',556959,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630802,2,23553,0,0,1,10,1,1,'2024-12-27 15:47:17',557288,'2024-12-27 15:47:18',556146,26989,'','',30,0,0.999,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630803,2,23554,0,0,1,1,0,1,'2024-12-27 15:47:20',580704,'2024-12-27 15:47:20',592310,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630804,2,23554,0,0,1,1,0,1,'2024-12-27 15:47:20',595128,'2024-12-27 15:47:25',621981,26989,'','',30,0,0.00886,0.595,0,'OK - 192.168.77.208: rta 0.148ms, lost 0%','rta=0.148ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630805,2,28533,0,0,1,1,1,1,'2024-12-27 15:47:25',622267,'2024-12-27 15:47:27',633048,26989,'','',30,0,2.01,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630806,2,28533,0,0,1,1,1,1,'2024-12-27 15:47:27',641492,'2024-12-27 15:47:30',686114,26989,'','',30,0,0.98871,2.641,2,'CRITICAL - 172.50.1.3: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630807,2,23551,0,0,1,1,0,1,'2024-12-27 15:47:30',686177,'2024-12-27 15:47:30',697208,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630808,2,23548,0,0,1,5,1,1,'2024-12-27 15:47:27',635540,'2024-12-27 15:47:30',697984,26989,'','',30,0,2.00807,2.635,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630809,2,21397,0,0,1,5,1,1,'2024-12-27 15:47:27',638392,'2024-12-27 15:47:30',698211,26989,'','',30,0,2.00819,2.638,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630810,2,21395,0,0,1,5,1,1,'2024-12-27 15:47:27',645092,'2024-12-27 15:47:30',698434,26989,'','',30,0,2.00977,2.645,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630811,2,28279,0,0,1,1,0,1,'2024-12-27 15:47:35',735933,'2024-12-27 15:47:35',744637,26989,'','',30,0,0.008,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630812,2,23552,0,0,1,1,0,1,'2024-12-27 15:47:35',744974,'2024-12-27 15:47:35',754371,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.126ms, lost 0%','rta=0.126ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630813,2,21396,0,0,1,5,0,1,'2024-12-27 15:47:40',919107,'2024-12-27 15:47:45',948557,26989,'','',30,0,0.02876,0.919,0,'OK - 192.168.77.159: rta 1.123ms, lost 0%','rta=1.123ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630814,2,23553,0,0,1,10,1,1,'2024-12-27 15:47:45',948619,'2024-12-27 15:47:47',958586,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630815,2,21397,0,0,1,5,1,1,'2024-12-27 15:47:47',958939,'2024-12-27 15:47:48',956751,26989,'','',30,0,0.998,0,1,'CRITICAL - 172.20.3.10: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630816,2,23554,0,0,1,1,0,1,'2024-12-27 15:47:48',957352,'2024-12-27 15:47:48',967483,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630817,2,28533,0,0,1,1,1,1,'2024-12-27 15:47:55',7795,'2024-12-27 15:47:57',11468,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630818,2,23551,0,0,1,1,0,1,'2024-12-27 15:48:00',18339,'2024-12-27 15:48:00',23176,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630819,2,23551,0,0,1,1,0,1,'2024-12-27 15:48:00',24556,'2024-12-27 15:48:05',473,26989,'','',30,0,0.00996,0.057,0,'OK - 192.168.77.29: rta 0.182ms, lost 0%','rta=0.182ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630820,2,23553,0,0,1,10,1,1,'2024-12-27 15:48:00',5,'2024-12-27 15:48:05',30483,26989,'','',30,0,2.01029,0.058,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630821,2,23552,0,0,1,1,0,1,'2024-12-27 15:48:05',476,'2024-12-27 15:48:05',0,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.134ms, lost 0%','rta=0.134ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630822,2,23548,0,0,1,5,1,1,'2024-12-27 15:48:10',102884,'2024-12-27 15:48:12',111409,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630823,2,23554,0,0,1,1,0,1,'2024-12-27 15:48:12',111761,'2024-12-27 15:48:12',121950,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630824,2,23552,0,0,1,1,0,1,'2024-12-27 15:48:12',124644,'2024-12-27 15:48:15',138335,26989,'','',30,0,0.00985,2.124,0,'OK - 192.168.77.8: rta 0.173ms, lost 0%','rta=0.173ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630825,2,23549,0,0,1,10,0,1,'2024-12-27 15:48:12',127377,'2024-12-27 15:48:15',138559,26989,'','',30,0,0.01659,2.127,0,'OK - 84.38.95.222: rta 0.474ms, lost 0%','rta=0.474ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630826,2,28279,0,0,1,1,0,1,'2024-12-27 15:48:15',140977,'2024-12-27 15:48:20',176607,26989,'','',30,0,0.00635,0.14,0,'OK - 192.168.77.9: rta 0.014ms, lost 0%','rta=0.014ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630827,2,21395,0,0,1,5,1,1,'2024-12-27 15:48:25',206175,'2024-12-27 15:48:27',216095,26989,'','',30,0,2.009,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630828,2,23551,0,0,1,1,0,1,'2024-12-27 15:48:27',216750,'2024-12-27 15:48:27',226994,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630829,2,28533,0,0,1,1,1,1,'2024-12-27 15:48:30',267996,'2024-12-27 15:48:32',277824,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630830,2,23554,0,0,1,1,0,1,'2024-12-27 15:48:27',229626,'2024-12-27 15:48:32',278406,26989,'','',30,0,0.00893,2.229,0,'OK - 192.168.77.208: rta 0.146ms, lost 0%','rta=0.146ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630831,2,23552,0,0,1,1,0,1,'2024-12-27 15:48:32',278733,'2024-12-27 15:48:32',288444,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.116ms, lost 0%','rta=0.116ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630832,2,23548,0,0,1,5,1,1,'2024-12-27 15:48:35',312738,'2024-12-27 15:48:37',321235,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630833,2,28533,0,0,1,1,1,1,'2024-12-27 15:48:32',291030,'2024-12-27 15:48:37',322002,26989,'','',30,0,0.98491,2.291,2,'CRITICAL - 172.50.1.3: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630834,2,23548,0,0,1,5,1,1,'2024-12-27 15:48:32',293886,'2024-12-27 15:48:37',322221,26989,'','',30,0,2.00892,2.293,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630835,2,21397,0,0,1,5,1,1,'2024-12-27 15:48:32',294926,'2024-12-27 15:48:37',322442,26989,'','',30,0,2.00986,2.294,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630836,2,21395,0,0,1,5,1,1,'2024-12-27 15:48:32',297773,'2024-12-27 15:48:37',322682,26989,'','',30,0,2.00922,2.297,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630837,2,23553,0,0,1,10,1,1,'2024-12-27 15:48:40',354123,'2024-12-27 15:48:41',444622,26989,'','',30,0,1.09,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630838,2,21396,0,0,1,5,0,1,'2024-12-27 15:48:45',475569,'2024-12-27 15:48:50',504566,26989,'','',30,0,0.02438,0.475,0,'OK - 192.168.77.159: rta 0.868ms, lost 0%','rta=0.868ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630839,2,23554,0,0,1,1,0,1,'2024-12-27 15:48:50',504965,'2024-12-27 15:48:50',516281,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.208: rta 0.154ms, lost 0%','rta=0.154ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630840,2,23552,0,0,1,1,0,1,'2024-12-27 15:48:50',516616,'2024-12-27 15:48:50',525911,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.121ms, lost 0%','rta=0.121ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630841,2,21395,0,0,1,5,1,1,'2024-12-27 15:48:55',550984,'2024-12-27 15:48:57',561431,26989,'','',30,0,2.01,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630842,2,23553,0,0,1,10,1,1,'2024-12-27 15:48:57',561764,'2024-12-27 15:48:59',569824,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630843,2,23551,0,0,1,1,0,1,'2024-12-27 15:49:05',619562,'2024-12-27 15:49:05',630297,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630844,2,28533,0,0,1,1,1,1,'2024-12-27 15:49:05',630623,'2024-12-27 15:49:07',639346,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630845,2,23551,0,0,1,1,0,1,'2024-12-27 15:49:07',641888,'2024-12-27 15:49:10',679447,26989,'','',30,0,0.00903,2.641,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630846,2,28279,0,0,1,1,0,1,'2024-12-27 15:49:10',679785,'2024-12-27 15:49:10',687521,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630847,2,23553,0,0,1,10,1,1,'2024-12-27 15:49:07',645111,'2024-12-27 15:49:10',688020,26989,'','',30,0,2.00949,2.645,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630848,2,23552,0,0,1,1,0,1,'2024-12-27 15:49:15',711226,'2024-12-27 15:49:15',721081,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.113ms, lost 0%','rta=0.113ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630849,2,23552,0,0,1,1,0,1,'2024-12-27 15:49:15',723568,'2024-12-27 15:49:20',761536,26989,'','',30,0,0.00853,0.723,0,'OK - 192.168.77.8: rta 0.134ms, lost 0%','rta=0.134ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630850,2,23549,0,0,1,10,0,1,'2024-12-27 15:49:15',726497,'2024-12-27 15:49:20',761758,26989,'','',30,0,0.01199,0.726,0,'OK - 84.38.95.222: rta 0.284ms, lost 0%','rta=0.284ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630851,2,21396,0,0,1,5,0,1,'2024-12-27 15:49:20',761812,'2024-12-27 15:49:20',790937,26989,'','',30,0,0.028,0,0,'OK - 192.168.77.159: rta 1.095ms, lost 0%','rta=1.095ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630852,2,28279,0,0,1,1,0,1,'2024-12-27 15:49:20',793924,'2024-12-27 15:49:25',815436,26989,'','',30,0,0.00609,0.793,0,'OK - 192.168.77.9: rta 0.016ms, lost 0%','rta=0.016ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630853,2,23554,0,0,1,1,0,1,'2024-12-27 15:49:25',815490,'2024-12-27 15:49:25',825653,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630854,2,23554,0,0,1,1,0,1,'2024-12-27 15:49:32',855479,'2024-12-27 15:49:35',878998,26989,'','',30,0,0.01044,0.855,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630855,2,28533,0,0,1,1,1,1,'2024-12-27 15:49:37',886642,'2024-12-27 15:49:40',920715,26989,'','',30,0,2.01007,0.886,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630856,2,23548,0,0,1,5,1,1,'2024-12-27 15:49:37',889665,'2024-12-27 15:49:40',920968,26989,'','',30,0,2.0084,0.889,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630857,2,21397,0,0,1,5,1,1,'2024-12-27 15:49:37',892434,'2024-12-27 15:49:40',921231,26989,'','',30,0,2.00775,0.892,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630858,2,21395,0,0,1,5,1,1,'2024-12-27 15:49:37',896000,'2024-12-27 15:49:40',921474,26989,'','',30,0,2.00782,0.895,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630859,2,23552,0,0,1,1,0,1,'2024-12-27 15:49:45',949918,'2024-12-27 15:49:45',960754,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.137ms, lost 0%','rta=0.137ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630860,2,23553,0,0,1,10,1,1,'2024-12-27 15:49:45',961104,'2024-12-27 15:49:47',969236,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630861,2,23549,0,0,1,10,0,1,'2024-12-27 15:49:51',1300,'2024-12-27 15:49:51',105,26989,'','',30,0,0.012,0,0,'OK - 84.38.95.222: rta 0.218ms, lost 0%','rta=0.218ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630862,2,21396,0,0,1,5,0,1,'2024-12-27 15:49:51',1022,'2024-12-27 15:49:55',13247,26989,'','',30,0,0.02837,1.017,0,'OK - 192.168.77.159: rta 1.120ms, lost 0%','rta=1.120ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630863,2,23554,0,0,1,1,0,1,'2024-12-27 15:49:55',13277,'2024-12-27 15:49:55',274,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630864,2,23551,0,0,1,1,0,1,'2024-12-27 15:49:55',2226,'2024-12-27 15:49:55',339,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630865,2,28533,0,0,1,1,1,1,'2024-12-27 15:50:05',0,'2024-12-27 15:50:07',0,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630866,2,23552,0,0,1,1,0,1,'2024-12-27 15:50:10',124260,'2024-12-27 15:50:10',135474,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.170ms, lost 0%','rta=0.170ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630867,2,23551,0,0,1,1,0,1,'2024-12-27 15:50:10',138096,'2024-12-27 15:50:15',157450,26989,'','',30,0,0.00974,0.138,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630868,2,23553,0,0,1,10,1,1,'2024-12-27 15:50:10',141467,'2024-12-27 15:50:15',157707,26989,'','',30,0,2.00862,0.141,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630869,2,21397,0,0,1,5,1,1,'2024-12-27 15:50:15',157818,'2024-12-27 15:50:17',166775,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630870,2,23554,0,0,1,1,0,1,'2024-12-27 15:50:20',196470,'2024-12-27 15:50:20',208021,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.208: rta 0.148ms, lost 0%','rta=0.148ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630871,2,23549,0,0,1,10,0,1,'2024-12-27 15:50:20',208363,'2024-12-27 15:50:20',224488,26989,'','',30,0,0.015,0,0,'OK - 84.38.95.222: rta 0.456ms, lost 0%','rta=0.456ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630872,2,23552,0,0,1,1,0,1,'2024-12-27 15:50:20',227345,'2024-12-27 15:50:25',266044,26989,'','',30,0,0.01059,0.227,0,'OK - 192.168.77.8: rta 0.130ms, lost 0%','rta=0.130ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630873,2,23549,0,0,1,10,0,1,'2024-12-27 15:50:20',230270,'2024-12-27 15:50:25',266293,26989,'','',30,0,0.01706,0.23,0,'OK - 84.38.95.222: rta 0.482ms, lost 0%','rta=0.482ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630874,2,28533,0,0,1,1,1,1,'2024-12-27 15:50:25',266586,'2024-12-27 15:50:27',275383,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630875,2,28279,0,0,1,1,0,1,'2024-12-27 15:50:27',294135,'2024-12-27 15:50:30',308792,26989,'','',30,0,0.0063,2.294,0,'OK - 192.168.77.9: rta 0.014ms, lost 0%','rta=0.014ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630876,2,23551,0,0,1,1,0,1,'2024-12-27 15:50:30',308853,'2024-12-27 15:50:30',319846,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630877,2,23554,0,0,1,1,0,1,'2024-12-27 15:50:35',347891,'2024-12-27 15:50:40',362234,26989,'','',30,0,0.0095,0.347,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630878,2,23548,0,0,1,5,1,1,'2024-12-27 15:50:40',369832,'2024-12-27 15:50:45',402191,26989,'','',30,0,0.07555,0.369,2,'CRITICAL - 172.20.3.11: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630879,2,21397,0,0,1,5,1,1,'2024-12-27 15:50:45',402260,'2024-12-27 15:50:47',412488,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630880,2,21397,0,0,1,5,1,1,'2024-12-27 15:50:40',370849,'2024-12-27 15:50:47',426068,26989,'','',30,0,0.07471,0.37,2,'CRITICAL - 172.20.3.10: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630881,2,28533,0,0,1,1,1,1,'2024-12-27 15:50:40',367956,'2024-12-27 15:50:47',426298,26989,'','',30,0,2.009,0.367,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630882,2,21395,0,0,1,5,1,1,'2024-12-27 15:50:40',371868,'2024-12-27 15:50:47',426519,26989,'','',30,0,2.00844,0.371,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630883,2,23553,0,0,1,10,1,1,'2024-12-27 15:50:47',426579,'2024-12-27 15:50:48',411580,26989,'','',30,0,0.985,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630884,2,21396,0,0,1,5,0,1,'2024-12-27 15:50:55',442275,'2024-12-27 15:51:00',461174,26989,'','',30,0,0.02167,0.442,0,'OK - 192.168.77.159: rta 0.722ms, lost 0%','rta=0.722ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630885,2,28533,0,0,1,1,1,1,'2024-12-27 15:51:00',461775,'2024-12-27 15:51:02',471090,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630886,2,23551,0,0,1,1,0,1,'2024-12-27 15:51:02',471385,'2024-12-27 15:51:02',481363,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630887,2,23552,0,0,1,1,0,1,'2024-12-27 15:51:05',491798,'2024-12-27 15:51:05',502754,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.138ms, lost 0%','rta=0.138ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630888,2,23553,0,0,1,10,1,1,'2024-12-27 15:51:05',503082,'2024-12-27 15:51:07',510616,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630889,2,23548,0,0,1,5,1,1,'2024-12-27 15:51:10',522322,'2024-12-27 15:51:12',531863,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630890,2,23554,0,0,1,1,0,1,'2024-12-27 15:51:12',532128,'2024-12-27 15:51:12',542266,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630891,2,23551,0,0,1,1,0,1,'2024-12-27 15:51:15',569441,'2024-12-27 15:51:20',602960,26989,'','',30,0,0.00945,0.569,0,'OK - 192.168.77.29: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630892,2,23553,0,0,1,10,1,1,'2024-12-27 15:51:15',572627,'2024-12-27 15:51:20',603214,26989,'','',30,0,2.00794,0.572,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630893,2,21395,0,0,1,5,1,1,'2024-12-27 15:51:25',635337,'2024-12-27 15:51:27',645689,26989,'','',30,0,2.01,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630894,2,23552,0,0,1,1,0,1,'2024-12-27 15:51:27',646037,'2024-12-27 15:51:27',655572,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.113ms, lost 0%','rta=0.113ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630895,2,28533,0,0,1,1,1,1,'2024-12-27 15:51:30',698123,'2024-12-27 15:51:32',707750,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630896,2,23552,0,0,1,1,0,1,'2024-12-27 15:51:27',658406,'2024-12-27 15:51:32',708233,26989,'','',30,0,0.00849,2.658,0,'OK - 192.168.77.8: rta 0.129ms, lost 0%','rta=0.129ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630897,2,23549,0,0,1,10,0,1,'2024-12-27 15:51:27',661504,'2024-12-27 15:51:32',708438,26989,'','',30,0,0.01228,2.661,0,'OK - 84.38.95.222: rta 0.286ms, lost 0%','rta=0.286ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630898,2,23548,0,0,1,5,1,1,'2024-12-27 15:51:35',726168,'2024-12-27 15:51:36',786578,26989,'','',30,0,1.06,0,1,'CRITICAL - 172.20.3.11: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630899,2,28279,0,0,1,1,0,1,'2024-12-27 15:51:32',711180,'2024-12-27 15:51:36',787318,26989,'','',30,0,0.00633,2.711,0,'OK - 192.168.77.9: rta 0.014ms, lost 0%','rta=0.014ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630900,2,23551,0,0,1,1,0,1,'2024-12-27 15:51:40',826712,'2024-12-27 15:51:40',838360,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630901,2,23553,0,0,1,10,1,1,'2024-12-27 15:51:40',838736,'2024-12-27 15:51:41',911192,26989,'','',30,0,1.072,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630902,2,23554,0,0,1,1,0,1,'2024-12-27 15:51:41',914035,'2024-12-27 15:51:45',940521,26989,'','',30,0,0.00904,1.914,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630903,2,23548,0,0,1,5,1,1,'2024-12-27 15:51:45',943290,'2024-12-27 15:51:50',982104,26989,'','',30,0,0.96783,0.943,2,'CRITICAL - 172.20.3.11: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630904,2,23552,0,0,1,1,0,1,'2024-12-27 15:51:50',982458,'2024-12-27 15:51:50',992575,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.127ms, lost 0%','rta=0.127ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630905,2,21397,0,0,1,5,1,1,'2024-12-27 15:51:47',950201,'2024-12-27 15:51:50',993898,26989,'','',30,0,2.00954,0.95,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630906,2,28533,0,0,1,1,1,1,'2024-12-27 15:51:47',952268,'2024-12-27 15:51:50',994144,26989,'','',30,0,2.00944,0.952,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630907,2,21395,0,0,1,5,1,1,'2024-12-27 15:51:47',953291,'2024-12-27 15:51:50',994393,26989,'','',30,0,2.01057,0.953,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630908,2,23554,0,0,1,1,0,1,'2024-12-27 15:52:00',1,'2024-12-27 15:52:00',2,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630909,2,21396,0,0,1,5,0,1,'2024-12-27 15:52:00',208,'2024-12-27 15:52:05',23463,26989,'','',30,0,0.02053,0.032,0,'OK - 192.168.77.159: rta 0.729ms, lost 0%','rta=0.729ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630910,2,23551,0,0,1,1,0,1,'2024-12-27 15:52:05',23514,'2024-12-27 15:52:05',3498,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630911,2,28533,0,0,1,1,1,1,'2024-12-27 15:52:05',54,'2024-12-27 15:52:07',60,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630912,2,28279,0,0,1,1,0,1,'2024-12-27 15:52:10',0,'2024-12-27 15:52:10',0,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630913,2,23552,0,0,1,1,0,1,'2024-12-27 15:52:15',111283,'2024-12-27 15:52:15',121465,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.127ms, lost 0%','rta=0.127ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630914,2,21396,0,0,1,5,0,1,'2024-12-27 15:52:20',157307,'2024-12-27 15:52:20',187250,26989,'','',30,0,0.029,0,0,'OK - 192.168.77.159: rta 1.087ms, lost 0%','rta=1.087ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630915,2,23553,0,0,1,10,1,1,'2024-12-27 15:52:20',187608,'2024-12-27 15:52:22',195387,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630916,2,23554,0,0,1,1,0,1,'2024-12-27 15:52:25',216523,'2024-12-27 15:52:25',226436,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.148ms, lost 0%','rta=0.148ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630917,2,23551,0,0,1,1,0,1,'2024-12-27 15:52:22',198258,'2024-12-27 15:52:25',226943,26989,'','',30,0,0.00904,2.198,0,'OK - 192.168.77.29: rta 0.148ms, lost 0%','rta=0.148ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630918,2,23553,0,0,1,10,1,1,'2024-12-27 15:52:22',200573,'2024-12-27 15:52:25',227186,26989,'','',30,0,0.99408,2.2,2,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630919,2,23552,0,0,1,1,0,1,'2024-12-27 15:52:32',274188,'2024-12-27 15:52:35',299033,26989,'','',30,0,0.00938,0.274,0,'OK - 192.168.77.8: rta 0.107ms, lost 0%','rta=0.107ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630920,2,23549,0,0,1,10,0,1,'2024-12-27 15:52:32',277143,'2024-12-27 15:52:35',299268,26989,'','',30,0,0.01648,0.277,0,'OK - 84.38.95.222: rta 0.498ms, lost 0%','rta=0.498ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630921,2,28279,0,0,1,1,0,1,'2024-12-27 15:52:36',302998,'2024-12-27 15:52:40',332452,26989,'','',30,0,0.00645,0.302,0,'OK - 192.168.77.9: rta 0.016ms, lost 0%','rta=0.016ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630922,2,23553,0,0,1,10,1,1,'2024-12-27 15:52:45',348330,'2024-12-27 15:52:47',358153,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630923,2,23554,0,0,1,1,0,1,'2024-12-27 15:52:47',360757,'2024-12-27 15:52:50',395408,26989,'','',30,0,0.0093,2.36,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630924,2,23549,0,0,1,10,0,1,'2024-12-27 15:52:50',395743,'2024-12-27 15:52:50',408686,26989,'','',30,0,0.012,0,0,'OK - 84.38.95.222: rta 0.248ms, lost 0%','rta=0.248ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630925,2,23548,0,0,1,5,1,1,'2024-12-27 15:52:50',411085,'2024-12-27 15:52:55',446915,26989,'','',30,0,2.00767,0.411,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630926,2,21397,0,0,1,5,1,1,'2024-12-27 15:52:50',414158,'2024-12-27 15:52:55',447138,26989,'','',30,0,2.00834,0.414,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630927,2,28533,0,0,1,1,1,1,'2024-12-27 15:52:50',417595,'2024-12-27 15:52:55',447352,26989,'','',30,0,2.00886,0.417,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630928,2,21395,0,0,1,5,1,1,'2024-12-27 15:52:50',419486,'2024-12-27 15:52:55',447569,26989,'','',30,0,2.01,0.419,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630929,2,23551,0,0,1,1,0,1,'2024-12-27 15:52:55',447632,'2024-12-27 15:52:55',458165,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630930,2,21396,0,0,1,5,0,1,'2024-12-27 15:53:05',533272,'2024-12-27 15:53:10',564069,26989,'','',30,0,0.02153,0.533,0,'OK - 192.168.77.159: rta 0.753ms, lost 0%','rta=0.753ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630931,2,23552,0,0,1,1,0,1,'2024-12-27 15:53:10',564127,'2024-12-27 15:53:10',574209,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.121ms, lost 0%','rta=0.121ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630932,2,21397,0,0,1,5,1,1,'2024-12-27 15:53:15',604090,'2024-12-27 15:53:17',613466,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630933,2,23553,0,0,1,10,1,1,'2024-12-27 15:53:17',613776,'2024-12-27 15:53:18',612803,26989,'','',30,0,0.999,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630934,2,23554,0,0,1,1,0,1,'2024-12-27 15:53:20',651004,'2024-12-27 15:53:20',661479,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630935,2,23549,0,0,1,10,0,1,'2024-12-27 15:53:20',661814,'2024-12-27 15:53:20',674694,26989,'','',30,0,0.012,0,0,'OK - 84.38.95.222: rta 0.300ms, lost 0%','rta=0.300ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630936,2,28533,0,0,1,1,1,1,'2024-12-27 15:53:25',694400,'2024-12-27 15:53:27',703131,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630937,2,23551,0,0,1,1,0,1,'2024-12-27 15:53:27',705517,'2024-12-27 15:53:30',744271,26989,'','',30,0,0.00961,2.705,0,'OK - 192.168.77.29: rta 0.181ms, lost 0%','rta=0.181ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630938,2,23553,0,0,1,10,1,1,'2024-12-27 15:53:27',708598,'2024-12-27 15:53:30',745073,26989,'','',30,0,2.00789,2.708,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630939,2,28279,0,0,1,1,0,1,'2024-12-27 15:53:35',779978,'2024-12-27 15:53:35',788021,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630940,2,23552,0,0,1,1,0,1,'2024-12-27 15:53:35',788332,'2024-12-27 15:53:35',797726,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.120ms, lost 0%','rta=0.120ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630941,2,23552,0,0,1,1,0,1,'2024-12-27 15:53:35',800261,'2024-12-27 15:53:40',825144,26989,'','',30,0,0.00989,0.8,0,'OK - 192.168.77.8: rta 0.123ms, lost 0%','rta=0.123ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630942,2,23549,0,0,1,10,0,1,'2024-12-27 15:53:35',802875,'2024-12-27 15:53:40',825351,26989,'','',30,0,0.01134,0.802,0,'OK - 84.38.95.222: rta 0.217ms, lost 0%','rta=0.217ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630943,2,28279,0,0,1,1,0,1,'2024-12-27 15:53:40',831039,'2024-12-27 15:53:45',859779,26989,'','',30,0,0.00702,0.83,0,'OK - 192.168.77.9: rta 0.022ms, lost 0%','rta=0.022ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630944,2,21397,0,0,1,5,1,1,'2024-12-27 15:53:45',859864,'2024-12-27 15:53:47',869111,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630945,2,23553,0,0,1,10,1,1,'2024-12-27 15:53:47',869479,'2024-12-27 15:53:48',868277,26989,'','',30,0,0.999,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630946,2,23554,0,0,1,1,0,1,'2024-12-27 15:53:48',868903,'2024-12-27 15:53:48',878991,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630947,2,23554,0,0,1,1,0,1,'2024-12-27 15:53:50',903929,'2024-12-27 15:53:55',934365,26989,'','',30,0,0.01013,0.903,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630948,2,28533,0,0,1,1,1,1,'2024-12-27 15:53:55',934435,'2024-12-27 15:53:56',994680,26989,'','',30,0,1.059,0,1,'CRITICAL - 172.50.1.3: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630949,2,23551,0,0,1,1,0,1,'2024-12-27 15:54:00',10806,'2024-12-27 15:54:00',1886,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.148ms, lost 0%','rta=0.148ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630950,2,23548,0,0,1,5,1,1,'2024-12-27 15:53:56',997288,'2024-12-27 15:54:00',29,26989,'','',30,0,2.00745,1.997,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630951,2,21397,0,0,1,5,1,1,'2024-12-27 15:53:56',998436,'2024-12-27 15:54:00',15417,26989,'','',30,0,2.01027,1.998,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630952,2,28533,0,0,1,1,1,1,'2024-12-27 15:53:57',702,'2024-12-27 15:54:00',15553,26989,'','',30,0,2.00832,2.001,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630953,2,21395,0,0,1,5,1,1,'2024-12-27 15:53:57',2569,'2024-12-27 15:54:00',15689,26989,'','',30,0,2.00871,2.004,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630954,2,23552,0,0,1,1,0,1,'2024-12-27 15:54:05',4,'2024-12-27 15:54:05',5,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.117ms, lost 0%','rta=0.117ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630955,2,23553,0,0,1,10,1,1,'2024-12-27 15:54:05',24742,'2024-12-27 15:54:07',6,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630956,2,23554,0,0,1,1,0,1,'2024-12-27 15:54:10',0,'2024-12-27 15:54:10',105341,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.154ms, lost 0%','rta=0.154ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630957,2,21396,0,0,1,5,0,1,'2024-12-27 15:54:10',107759,'2024-12-27 15:54:15',120439,26989,'','',30,0,0.02722,0.107,0,'OK - 192.168.77.159: rta 1.067ms, lost 0%','rta=1.067ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630958,2,21395,0,0,1,5,1,1,'2024-12-27 15:54:25',157397,'2024-12-27 15:54:27',167643,26989,'','',30,0,2.009,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630959,2,23552,0,0,1,1,0,1,'2024-12-27 15:54:27',167968,'2024-12-27 15:54:27',177776,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.136ms, lost 0%','rta=0.136ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630960,2,23551,0,0,1,1,0,1,'2024-12-27 15:54:27',178108,'2024-12-27 15:54:27',187963,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.148ms, lost 0%','rta=0.148ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630961,2,28533,0,0,1,1,1,1,'2024-12-27 15:54:30',233056,'2024-12-27 15:54:32',243613,26989,'','',30,0,2.01,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630962,2,23548,0,0,1,5,1,1,'2024-12-27 15:54:32',244358,'2024-12-27 15:54:34',252894,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630963,2,23551,0,0,1,1,0,1,'2024-12-27 15:54:34',255377,'2024-12-27 15:54:35',268457,26989,'','',30,0,0.00947,4.255,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630964,2,23553,0,0,1,10,1,1,'2024-12-27 15:54:34',258108,'2024-12-27 15:54:35',268718,26989,'','',30,0,0.99273,4.258,2,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630965,2,23552,0,0,1,1,0,1,'2024-12-27 15:54:40',311348,'2024-12-27 15:54:45',330719,26989,'','',30,0,0.00984,0.311,0,'OK - 192.168.77.8: rta 0.120ms, lost 0%','rta=0.120ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630966,2,23549,0,0,1,10,0,1,'2024-12-27 15:54:40',315437,'2024-12-27 15:54:45',330935,26989,'','',30,0,0.01159,0.315,0,'OK - 84.38.95.222: rta 0.228ms, lost 0%','rta=0.228ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630967,2,28279,0,0,1,1,0,1,'2024-12-27 15:54:45',333656,'2024-12-27 15:54:50',378527,26989,'','',30,0,0.00731,0.333,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630968,2,23554,0,0,1,1,0,1,'2024-12-27 15:54:50',378867,'2024-12-27 15:54:50',390360,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630969,2,23553,0,0,1,10,1,1,'2024-12-27 15:54:50',391295,'2024-12-27 15:54:51',437223,26989,'','',30,0,1.045,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630970,2,21395,0,0,1,5,1,1,'2024-12-27 15:54:51',437569,'2024-12-27 15:54:53',445421,26989,'','',30,0,2.007,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630971,2,23554,0,0,1,1,0,1,'2024-12-27 15:54:55',481085,'2024-12-27 15:55:00',514915,26989,'','',30,0,0.00913,0.481,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630972,2,23552,0,0,1,1,0,1,'2024-12-27 15:55:00',514983,'2024-12-27 15:55:00',525117,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.119ms, lost 0%','rta=0.119ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630973,2,23551,0,0,1,1,0,1,'2024-12-27 15:55:05',567798,'2024-12-27 15:55:05',578588,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630974,2,28533,0,0,1,1,1,1,'2024-12-27 15:55:05',578901,'2024-12-27 15:55:07',587904,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630975,2,21397,0,0,1,5,1,1,'2024-12-27 15:55:00',528727,'2024-12-27 15:55:07',588361,26989,'','',30,0,2.00809,0.528,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630976,2,23548,0,0,1,5,1,1,'2024-12-27 15:55:00',527963,'2024-12-27 15:55:07',588577,26989,'','',30,0,2.01079,0.527,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630977,2,28533,0,0,1,1,1,1,'2024-12-27 15:55:00',530958,'2024-12-27 15:55:07',588783,26989,'','',30,0,2.00827,0.53,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630978,2,21395,0,0,1,5,1,1,'2024-12-27 15:55:00',534652,'2024-12-27 15:55:07',588988,26989,'','',30,0,2.00716,0.534,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630979,2,28279,0,0,1,1,0,1,'2024-12-27 15:55:10',626840,'2024-12-27 15:55:10',634859,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.016ms, lost 0%','rta=0.016ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630980,2,21396,0,0,1,5,0,1,'2024-12-27 15:55:15',664315,'2024-12-27 15:55:20',700452,26989,'','',30,0,0.02128,0.664,0,'OK - 192.168.77.159: rta 0.728ms, lost 0%','rta=0.728ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630981,2,23553,0,0,1,10,1,1,'2024-12-27 15:55:20',700780,'2024-12-27 15:55:22',710638,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630982,2,23554,0,0,1,1,0,1,'2024-12-27 15:55:25',731938,'2024-12-27 15:55:25',742598,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630983,2,23551,0,0,1,1,0,1,'2024-12-27 15:55:35',793129,'2024-12-27 15:55:40',826517,26989,'','',30,0,0.01031,0.793,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630984,2,23553,0,0,1,10,1,1,'2024-12-27 15:55:35',796474,'2024-12-27 15:55:40',826777,26989,'','',30,0,2.00785,0.796,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630985,2,23552,0,0,1,1,0,1,'2024-12-27 15:55:45',852243,'2024-12-27 15:55:45',862006,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.116ms, lost 0%','rta=0.116ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630986,2,23552,0,0,1,1,0,1,'2024-12-27 15:55:45',864700,'2024-12-27 15:55:50',908243,26989,'','',30,0,0.00838,0.864,0,'OK - 192.168.77.8: rta 0.122ms, lost 0%','rta=0.122ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630987,2,23549,0,0,1,10,0,1,'2024-12-27 15:55:45',867742,'2024-12-27 15:55:50',908488,26989,'','',30,0,0.01135,0.867,0,'OK - 84.38.95.222: rta 0.201ms, lost 0%','rta=0.201ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630988,2,28279,0,0,1,1,0,1,'2024-12-27 15:55:50',911178,'2024-12-27 15:55:55',952654,26989,'','',30,0,0.00711,0.911,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630989,2,23554,0,0,1,1,0,1,'2024-12-27 15:55:55',952709,'2024-12-27 15:55:55',963550,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630990,2,23551,0,0,1,1,0,1,'2024-12-27 15:55:55',963849,'2024-12-27 15:55:55',973849,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630991,2,23554,0,0,1,1,0,1,'2024-12-27 15:56:01',122,'2024-12-27 15:56:05',225,26989,'','',30,0,0.00924,1.017,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630992,2,28533,0,0,1,1,1,1,'2024-12-27 15:56:10',379,'2024-12-27 15:56:12',437,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630993,2,23548,0,0,1,5,1,1,'2024-12-27 15:56:07',16412,'2024-12-27 15:56:12',0,26989,'','',30,0,0.1077,0.039,2,'CRITICAL - 172.20.3.11: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630994,2,21397,0,0,1,5,1,1,'2024-12-27 15:56:07',3,'2024-12-27 15:56:12',0,26989,'','',30,0,0.10889,0.038,2,'CRITICAL - 172.20.3.10: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630995,2,23552,0,0,1,1,0,1,'2024-12-27 15:56:12',0,'2024-12-27 15:56:12',0,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.119ms, lost 0%','rta=0.119ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276630996,2,28533,0,0,1,1,1,1,'2024-12-27 15:56:07',17864,'2024-12-27 15:56:12',0,26989,'','',30,0,2.00797,0.042,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630997,2,21395,0,0,1,5,1,1,'2024-12-27 15:56:07',37,'2024-12-27 15:56:12',0,26989,'','',30,0,2.00811,0.045,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630998,2,23553,0,0,1,10,1,1,'2024-12-27 15:56:15',109125,'2024-12-27 15:56:17',117916,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276630999,2,23554,0,0,1,1,0,1,'2024-12-27 15:56:20',145369,'2024-12-27 15:56:20',155921,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.148ms, lost 0%','rta=0.148ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631000,2,23549,0,0,1,10,0,1,'2024-12-27 15:56:20',156256,'2024-12-27 15:56:20',167150,26989,'','',30,0,0.01,0,0,'OK - 84.38.95.222: rta 0.203ms, lost 0%','rta=0.203ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631001,2,21396,0,0,1,5,0,1,'2024-12-27 15:56:20',169754,'2024-12-27 15:56:25',184512,26989,'','',30,0,0.02675,0.169,0,'OK - 192.168.77.159: rta 1.040ms, lost 0%','rta=1.040ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631002,2,28533,0,0,1,1,1,1,'2024-12-27 15:56:25',184826,'2024-12-27 15:56:27',193765,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631003,2,23551,0,0,1,1,0,1,'2024-12-27 15:56:30',219581,'2024-12-27 15:56:30',230331,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631004,2,28279,0,0,1,1,0,1,'2024-12-27 15:56:35',247193,'2024-12-27 15:56:35',255230,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631005,2,23552,0,0,1,1,0,1,'2024-12-27 15:56:35',255622,'2024-12-27 15:56:35',266556,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.135ms, lost 0%','rta=0.135ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631006,2,23551,0,0,1,1,0,1,'2024-12-27 15:56:40',285853,'2024-12-27 15:56:45',301088,26989,'','',30,0,0.01084,0.285,0,'OK - 192.168.77.29: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631007,2,21397,0,0,1,5,1,1,'2024-12-27 15:56:45',301161,'2024-12-27 15:56:47',326202,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631008,2,23553,0,0,1,10,1,1,'2024-12-27 15:56:40',287777,'2024-12-27 15:56:47',326734,26989,'','',30,0,0.05893,0.287,2,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631009,2,23554,0,0,1,1,0,1,'2024-12-27 15:56:47',327303,'2024-12-27 15:56:47',360483,26989,'','',30,0,0.032,0,0,'OK - 192.168.77.208: rta 1.313ms, lost 0%','rta=1.313ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631010,2,23552,0,0,1,1,0,1,'2024-12-27 15:56:50',374161,'2024-12-27 15:56:55',394628,26989,'','',30,0,0.01001,0.374,0,'OK - 192.168.77.8: rta 0.156ms, lost 0%','rta=0.156ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631011,2,23549,0,0,1,10,0,1,'2024-12-27 15:56:50',377217,'2024-12-27 15:56:55',394861,26989,'','',30,0,0.0172,0.377,0,'OK - 84.38.95.222: rta 0.480ms, lost 0%','rta=0.480ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631012,2,28533,0,0,1,1,1,1,'2024-12-27 15:56:55',394935,'2024-12-27 15:56:56',476614,26989,'','',30,0,1.081,0,1,'CRITICAL - 172.50.1.3: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631013,2,28279,0,0,1,1,0,1,'2024-12-27 15:56:56',479143,'2024-12-27 15:57:00',500399,26989,'','',30,0,0.0063,1.479,0,'OK - 192.168.77.9: rta 0.016ms, lost 0%','rta=0.016ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631014,2,23551,0,0,1,1,0,1,'2024-12-27 15:57:00',501029,'2024-12-27 15:57:00',512180,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631015,2,23553,0,0,1,10,1,1,'2024-12-27 15:57:05',527311,'2024-12-27 15:57:07',535912,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631016,2,23554,0,0,1,1,0,1,'2024-12-27 15:57:07',538471,'2024-12-27 15:57:10',551949,26989,'','',30,0,0.00897,2.538,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631017,2,23548,0,0,1,5,1,1,'2024-12-27 15:57:10',552008,'2024-12-27 15:57:12',563033,26989,'','',30,0,2.01,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631018,2,23548,0,0,1,5,1,1,'2024-12-27 15:57:12',568781,'2024-12-27 15:57:15',582419,26989,'','',30,0,0.99127,0.568,2,'CRITICAL - 172.20.3.11: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631019,2,21397,0,0,1,5,1,1,'2024-12-27 15:57:12',570751,'2024-12-27 15:57:15',582660,26989,'','',30,0,0.98941,0.57,2,'CRITICAL - 172.20.3.10: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631020,2,28533,0,0,1,1,1,1,'2024-12-27 15:57:12',571966,'2024-12-27 15:57:15',582890,26989,'','',30,0,2.00828,0.571,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631021,2,21395,0,0,1,5,1,1,'2024-12-27 15:57:12',575871,'2024-12-27 15:57:15',583112,26989,'','',30,0,2.00874,0.575,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631022,2,23552,0,0,1,1,0,1,'2024-12-27 15:57:25',624141,'2024-12-27 15:57:25',634673,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.117ms, lost 0%','rta=0.117ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631023,2,23551,0,0,1,1,0,1,'2024-12-27 15:57:25',634989,'2024-12-27 15:57:25',645012,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631024,2,21396,0,0,1,5,0,1,'2024-12-27 15:57:25',647520,'2024-12-27 15:57:30',700146,26989,'','',30,0,0.02802,0.647,0,'OK - 192.168.77.159: rta 1.102ms, lost 0%','rta=1.102ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631025,2,28533,0,0,1,1,1,1,'2024-12-27 15:57:30',700230,'2024-12-27 15:57:32',710520,26989,'','',30,0,2.01,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631026,2,23548,0,0,1,5,1,1,'2024-12-27 15:57:32',711372,'2024-12-27 15:57:34',719959,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631027,2,23553,0,0,1,10,1,1,'2024-12-27 15:57:40',784490,'2024-12-27 15:57:41',874257,26989,'','',30,0,1.089,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631028,2,23551,0,0,1,1,0,1,'2024-12-27 15:57:41',874597,'2024-12-27 15:57:41',884680,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631029,2,23551,0,0,1,1,0,1,'2024-12-27 15:57:45',914507,'2024-12-27 15:57:50',962043,26989,'','',30,0,0.00966,0.914,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631030,2,23554,0,0,1,1,0,1,'2024-12-27 15:57:50',962102,'2024-12-27 15:57:50',973111,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631031,2,23552,0,0,1,1,0,1,'2024-12-27 15:57:50',973422,'2024-12-27 15:57:50',983094,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.129ms, lost 0%','rta=0.129ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631032,2,23553,0,0,1,10,1,1,'2024-12-27 15:57:47',921203,'2024-12-27 15:57:50',984257,26989,'','',30,0,2.00829,0.921,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631033,2,21395,0,0,1,5,1,1,'2024-12-27 15:57:56',819,'2024-12-27 15:57:58',1216,26989,'','',30,0,2.008,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631034,2,23552,0,0,1,1,0,1,'2024-12-27 15:57:58',21,'2024-12-27 15:58:00',14206,26989,'','',30,0,0.00925,3.025,0,'OK - 192.168.77.8: rta 0.127ms, lost 0%','rta=0.127ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631035,2,23549,0,0,1,10,0,1,'2024-12-27 15:57:58',186,'2024-12-27 15:58:00',223,26989,'','',30,0,0.01201,3.027,0,'OK - 84.38.95.222: rta 0.198ms, lost 0%','rta=0.198ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631036,2,28279,0,0,1,1,0,1,'2024-12-27 15:58:00',1936,'2024-12-27 15:58:05',397,26989,'','',30,0,0.00683,0.036,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631037,2,23551,0,0,1,1,0,1,'2024-12-27 15:58:05',25518,'2024-12-27 15:58:05',3806,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631038,2,28533,0,0,1,1,1,1,'2024-12-27 15:58:05',30687,'2024-12-27 15:58:07',0,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631039,2,23554,0,0,1,1,0,1,'2024-12-27 15:58:10',102149,'2024-12-27 15:58:15',115809,26989,'','',30,0,0.0094,0.102,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631040,2,23552,0,0,1,1,0,1,'2024-12-27 15:58:15',116131,'2024-12-27 15:58:15',126081,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.113ms, lost 0%','rta=0.113ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631041,2,21396,0,0,1,5,0,1,'2024-12-27 15:58:20',155671,'2024-12-27 15:58:20',176702,26989,'','',30,0,0.02,0,0,'OK - 192.168.77.159: rta 0.695ms, lost 0%','rta=0.695ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631042,2,23548,0,0,1,5,1,1,'2024-12-27 15:58:15',128516,'2024-12-27 15:58:20',177225,26989,'','',30,0,2.00749,0.128,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631043,2,21397,0,0,1,5,1,1,'2024-12-27 15:58:15',131529,'2024-12-27 15:58:20',177460,26989,'','',30,0,2.00844,0.131,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631044,2,28533,0,0,1,1,1,1,'2024-12-27 15:58:15',132134,'2024-12-27 15:58:20',177718,26989,'','',30,0,2.00889,0.132,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631045,2,21395,0,0,1,5,1,1,'2024-12-27 15:58:15',135291,'2024-12-27 15:58:20',177967,26989,'','',30,0,2.00896,0.135,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631046,2,23553,0,0,1,10,1,1,'2024-12-27 15:58:20',178025,'2024-12-27 15:58:22',185241,26989,'','',30,0,2.006,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631047,2,21396,0,0,1,5,0,1,'2024-12-27 15:58:30',205850,'2024-12-27 15:58:35',232214,26989,'','',30,0,0.02947,0.205,0,'OK - 192.168.77.159: rta 1.166ms, lost 0%','rta=1.166ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631048,2,23552,0,0,1,1,0,1,'2024-12-27 15:58:45',297576,'2024-12-27 15:58:45',307401,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.127ms, lost 0%','rta=0.127ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631049,2,23553,0,0,1,10,1,1,'2024-12-27 15:58:45',307745,'2024-12-27 15:58:47',315475,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631050,2,23549,0,0,1,10,0,1,'2024-12-27 15:58:50',332585,'2024-12-27 15:58:50',351558,26989,'','',30,0,0.018,0,0,'OK - 84.38.95.222: rta 0.529ms, lost 0%','rta=0.529ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631051,2,23551,0,0,1,1,0,1,'2024-12-27 15:58:50',354132,'2024-12-27 15:58:55',382172,26989,'','',30,0,0.00901,0.354,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631052,2,23554,0,0,1,1,0,1,'2024-12-27 15:58:55',382239,'2024-12-27 15:58:55',392956,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631053,2,23553,0,0,1,10,1,1,'2024-12-27 15:58:50',357008,'2024-12-27 15:58:55',393501,26989,'','',30,0,2.00808,0.356,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631054,2,23552,0,0,1,1,0,1,'2024-12-27 15:59:00',432931,'2024-12-27 15:59:05',462691,26989,'','',30,0,0.00933,0.432,0,'OK - 192.168.77.8: rta 0.116ms, lost 0%','rta=0.116ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631055,2,23549,0,0,1,10,0,1,'2024-12-27 15:59:00',435351,'2024-12-27 15:59:05',462918,26989,'','',30,0,0.01083,0.435,0,'OK - 84.38.95.222: rta 0.212ms, lost 0%','rta=0.212ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631056,2,28533,0,0,1,1,1,1,'2024-12-27 15:59:05',463270,'2024-12-27 15:59:07',472848,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631057,2,28279,0,0,1,1,0,1,'2024-12-27 15:59:07',475414,'2024-12-27 15:59:10',504487,26989,'','',30,0,0.00637,2.475,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631058,2,21397,0,0,1,5,1,1,'2024-12-27 15:59:15',526465,'2024-12-27 15:59:17',537112,26989,'','',30,0,2.01,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631059,2,23553,0,0,1,10,1,1,'2024-12-27 15:59:17',537437,'2024-12-27 15:59:18',535083,26989,'','',30,0,0.998,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631060,2,23554,0,0,1,1,0,1,'2024-12-27 15:59:18',537615,'2024-12-27 15:59:20',568598,26989,'','',30,0,0.01182,3.537,0,'OK - 192.168.77.208: rta 0.287ms, lost 0%','rta=0.287ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631061,2,23549,0,0,1,10,0,1,'2024-12-27 15:59:20',568953,'2024-12-27 15:59:20',583254,26989,'','',30,0,0.014,0,0,'OK - 84.38.95.222: rta 0.333ms, lost 0%','rta=0.333ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631062,2,23548,0,0,1,5,1,1,'2024-12-27 15:59:20',585826,'2024-12-27 15:59:25',621633,26989,'','',30,0,2.00802,0.585,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631063,2,21397,0,0,1,5,1,1,'2024-12-27 15:59:20',586445,'2024-12-27 15:59:25',621874,26989,'','',30,0,2.01037,0.586,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631064,2,28533,0,0,1,1,1,1,'2024-12-27 15:59:20',588779,'2024-12-27 15:59:25',622118,26989,'','',30,0,2.00954,0.588,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631065,2,21395,0,0,1,5,1,1,'2024-12-27 15:59:20',593196,'2024-12-27 15:59:25',622350,26989,'','',30,0,2.00901,0.593,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631066,2,23551,0,0,1,1,0,1,'2024-12-27 15:59:30',657917,'2024-12-27 15:59:30',669121,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631067,2,28279,0,0,1,1,0,1,'2024-12-27 15:59:35',702359,'2024-12-27 15:59:35',710291,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631068,2,23552,0,0,1,1,0,1,'2024-12-27 15:59:35',710640,'2024-12-27 15:59:35',720724,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.133ms, lost 0%','rta=0.133ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631069,2,21396,0,0,1,5,0,1,'2024-12-27 15:59:35',723301,'2024-12-27 15:59:40',792464,26989,'','',30,0,0.02519,0.723,0,'OK - 192.168.77.159: rta 0.923ms, lost 0%','rta=0.923ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631070,2,23553,0,0,1,10,1,1,'2024-12-27 15:59:45',824417,'2024-12-27 15:59:47',834916,26989,'','',30,0,2.01,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631071,2,21397,0,0,1,5,1,1,'2024-12-27 15:59:47',835236,'2024-12-27 15:59:48',833112,26989,'','',30,0,0.998,0,1,'CRITICAL - 172.20.3.10: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631072,2,23554,0,0,1,1,0,1,'2024-12-27 15:59:48',833663,'2024-12-27 15:59:48',843500,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631073,2,28533,0,0,1,1,1,1,'2024-12-27 15:59:55',897914,'2024-12-27 15:59:56',959686,26989,'','',30,0,1.061,0,1,'CRITICAL - 172.50.1.3: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631074,2,23551,0,0,1,1,0,1,'2024-12-27 15:59:56',962136,'2024-12-27 16:00:01',39,26989,'','',30,0,0.00999,1.962,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631075,2,23553,0,0,1,10,1,1,'2024-12-27 15:59:56',964051,'2024-12-27 16:00:01',5,26989,'','',30,0,2.00865,1.964,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631076,2,23552,0,0,1,1,0,1,'2024-12-27 16:00:05',7993,'2024-12-27 16:00:05',1531,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.131ms, lost 0%','rta=0.131ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631077,2,23552,0,0,1,1,0,1,'2024-12-27 16:00:05',24,'2024-12-27 16:00:10',2691,26989,'','',30,0,0.01025,0.03,0,'OK - 192.168.77.8: rta 0.221ms, lost 0%','rta=0.221ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631078,2,23549,0,0,1,10,0,1,'2024-12-27 16:00:05',27,'2024-12-27 16:00:10',21703,26989,'','',30,0,0.0104,0.033,0,'OK - 84.38.95.222: rta 0.209ms, lost 0%','rta=0.209ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631079,2,23548,0,0,1,5,1,1,'2024-12-27 16:00:10',21757,'2024-12-27 16:00:12',25950,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631080,2,23554,0,0,1,1,0,1,'2024-12-27 16:00:12',50,'2024-12-27 16:00:12',471,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631081,2,28279,0,0,1,1,0,1,'2024-12-27 16:00:12',31507,'2024-12-27 16:00:15',0,26989,'','',30,0,0.00612,2.075,0,'OK - 192.168.77.9: rta 0.014ms, lost 0%','rta=0.014ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631082,2,23554,0,0,1,1,0,1,'2024-12-27 16:00:20',134395,'2024-12-27 16:00:25',172544,26989,'','',30,0,0.0099,0.134,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631083,2,21395,0,0,1,5,1,1,'2024-12-27 16:00:25',172605,'2024-12-27 16:00:27',181990,26989,'','',30,0,2.009,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631084,2,23552,0,0,1,1,0,1,'2024-12-27 16:00:27',182317,'2024-12-27 16:00:27',192228,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.139ms, lost 0%','rta=0.139ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631085,2,23551,0,0,1,1,0,1,'2024-12-27 16:00:27',192539,'2024-12-27 16:00:27',202415,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631086,2,28533,0,0,1,1,1,1,'2024-12-27 16:00:30',244575,'2024-12-27 16:00:32',254670,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631087,2,21395,0,0,1,5,1,1,'2024-12-27 16:00:27',213909,'2024-12-27 16:00:32',255186,26989,'','',30,0,0.96647,2.213,2,'CRITICAL - 192.168.77.154: Host unreachable @ 192.168.77.9. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631088,2,23548,0,0,1,5,1,1,'2024-12-27 16:00:27',204984,'2024-12-27 16:00:32',255661,26989,'','',30,0,2.00763,2.204,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631089,2,21397,0,0,1,5,1,1,'2024-12-27 16:00:27',207810,'2024-12-27 16:00:32',256129,26989,'','',30,0,2.00828,2.207,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631090,2,28533,0,0,1,1,1,1,'2024-12-27 16:00:27',210879,'2024-12-27 16:00:32',256349,26989,'','',30,0,2.00777,2.21,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631091,2,23553,0,0,1,10,1,1,'2024-12-27 16:00:40',321580,'2024-12-27 16:00:41',408147,26989,'','',30,0,1.086,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631092,2,21396,0,0,1,5,0,1,'2024-12-27 16:00:41',411345,'2024-12-27 16:00:45',439505,26989,'','',30,0,0.0275,1.411,0,'OK - 192.168.77.159: rta 1.074ms, lost 0%','rta=1.074ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631093,2,28533,0,0,1,1,1,1,'2024-12-27 16:00:45',439792,'2024-12-27 16:00:47',448999,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631094,2,23554,0,0,1,1,0,1,'2024-12-27 16:00:50',497122,'2024-12-27 16:00:50',508576,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631095,2,23552,0,0,1,1,0,1,'2024-12-27 16:00:50',508907,'2024-12-27 16:00:50',518244,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.120ms, lost 0%','rta=0.120ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631096,2,21395,0,0,1,5,1,1,'2024-12-27 16:00:50',519287,'2024-12-27 16:00:51',467088,26989,'','',30,0,0.948,0,1,'CRITICAL - 192.168.77.154: Host unreachable @ 192.168.77.9. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631097,2,23551,0,0,1,1,0,1,'2024-12-27 16:01:01',546916,'2024-12-27 16:01:05',571356,26989,'','',30,0,0.01007,0.546,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631098,2,28533,0,0,1,1,1,1,'2024-12-27 16:01:05',571676,'2024-12-27 16:01:07',580470,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631099,2,23553,0,0,1,10,1,1,'2024-12-27 16:01:01',548889,'2024-12-27 16:01:07',580900,26989,'','',30,0,2.00857,0.548,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631100,2,28279,0,0,1,1,0,1,'2024-12-27 16:01:10',614753,'2024-12-27 16:01:10',623231,26989,'','',30,0,0.008,0,0,'OK - 192.168.77.9: rta 0.016ms, lost 0%','rta=0.016ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631101,2,23552,0,0,1,1,0,1,'2024-12-27 16:01:10',625802,'2024-12-27 16:01:15',658124,26989,'','',30,0,0.00847,0.625,0,'OK - 192.168.77.8: rta 0.126ms, lost 0%','rta=0.126ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631102,2,23549,0,0,1,10,0,1,'2024-12-27 16:01:10',628909,'2024-12-27 16:01:15',658334,26989,'','',30,0,0.01164,0.628,0,'OK - 84.38.95.222: rta 0.260ms, lost 0%','rta=0.260ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631103,2,28279,0,0,1,1,0,1,'2024-12-27 16:01:15',661038,'2024-12-27 16:01:20',690774,26989,'','',30,0,0.00676,0.661,0,'OK - 192.168.77.9: rta 0.016ms, lost 0%','rta=0.016ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631104,2,21396,0,0,1,5,0,1,'2024-12-27 16:01:20',690835,'2024-12-27 16:01:20',712844,26989,'','',30,0,0.021,0,0,'OK - 192.168.77.159: rta 0.736ms, lost 0%','rta=0.736ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631105,2,23553,0,0,1,10,1,1,'2024-12-27 16:01:20',713175,'2024-12-27 16:01:22',722053,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631106,2,23554,0,0,1,1,0,1,'2024-12-27 16:01:25',745367,'2024-12-27 16:01:25',755509,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.154ms, lost 0%','rta=0.154ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631107,2,23554,0,0,1,1,0,1,'2024-12-27 16:01:25',757988,'2024-12-27 16:01:30',789438,26989,'','',30,0,0.00882,0.757,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631108,2,21395,0,0,1,5,1,1,'2024-12-27 16:01:32',797474,'2024-12-27 16:01:35',823363,26989,'','',30,0,2.00842,0.797,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631109,2,23548,0,0,1,5,1,1,'2024-12-27 16:01:32',799242,'2024-12-27 16:01:35',823620,26989,'','',30,0,2.00865,0.799,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631110,2,21397,0,0,1,5,1,1,'2024-12-27 16:01:32',801218,'2024-12-27 16:01:35',823874,26989,'','',30,0,2.0086,0.801,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631111,2,28533,0,0,1,1,1,1,'2024-12-27 16:01:32',803219,'2024-12-27 16:01:35',824115,26989,'','',30,0,2.0077,0.803,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631112,2,23552,0,0,1,1,0,1,'2024-12-27 16:01:45',874200,'2024-12-27 16:01:45',884281,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.128ms, lost 0%','rta=0.128ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631113,2,23553,0,0,1,10,1,1,'2024-12-27 16:01:45',884587,'2024-12-27 16:01:47',892435,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631114,2,21396,0,0,1,5,0,1,'2024-12-27 16:01:47',894918,'2024-12-27 16:01:50',930204,26989,'','',30,0,0.02732,2.894,0,'OK - 192.168.77.159: rta 1.070ms, lost 0%','rta=1.070ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631115,2,23549,0,0,1,10,0,1,'2024-12-27 16:01:50',930512,'2024-12-27 16:01:50',942516,26989,'','',30,0,0.011,0,0,'OK - 84.38.95.222: rta 0.203ms, lost 0%','rta=0.203ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631116,2,23554,0,0,1,1,0,1,'2024-12-27 16:01:55',969449,'2024-12-27 16:01:55',979957,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631117,2,23551,0,0,1,1,0,1,'2024-12-27 16:01:55',980257,'2024-12-27 16:01:55',989980,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.148ms, lost 0%','rta=0.148ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631118,2,23551,0,0,1,1,0,1,'2024-12-27 16:02:05',2,'2024-12-27 16:02:10',18983,26989,'','',30,0,0.00943,0.028,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631119,2,28533,0,0,1,1,1,1,'2024-12-27 16:02:10',19030,'2024-12-27 16:02:12',28923,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631120,2,23553,0,0,1,10,1,1,'2024-12-27 16:02:07',14482,'2024-12-27 16:02:12',56,26989,'','',30,0,0.10437,0.034,2,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631121,2,23552,0,0,1,1,0,1,'2024-12-27 16:02:12',56,'2024-12-27 16:02:12',0,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.118ms, lost 0%','rta=0.118ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631122,2,21397,0,0,1,5,1,1,'2024-12-27 16:02:15',0,'2024-12-27 16:02:17',101542,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631123,2,23552,0,0,1,1,0,1,'2024-12-27 16:02:17',118098,'2024-12-27 16:02:20',133585,26989,'','',30,0,0.00878,2.118,0,'OK - 192.168.77.8: rta 0.131ms, lost 0%','rta=0.131ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631124,2,23549,0,0,1,10,0,1,'2024-12-27 16:02:17',121234,'2024-12-27 16:02:20',133817,26989,'','',30,0,0.01069,2.121,0,'OK - 84.38.95.222: rta 0.210ms, lost 0%','rta=0.210ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631125,2,23554,0,0,1,1,0,1,'2024-12-27 16:02:20',133877,'2024-12-27 16:02:20',144813,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.163ms, lost 0%','rta=0.163ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631126,2,28279,0,0,1,1,0,1,'2024-12-27 16:02:20',147500,'2024-12-27 16:02:25',181166,26989,'','',30,0,0.00627,0.147,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631127,2,23551,0,0,1,1,0,1,'2024-12-27 16:02:30',202549,'2024-12-27 16:02:30',213268,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631128,2,23554,0,0,1,1,0,1,'2024-12-27 16:02:30',216079,'2024-12-27 16:02:35',232977,26989,'','',30,0,0.00889,0.216,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631129,2,23552,0,0,1,1,0,1,'2024-12-27 16:02:35',233309,'2024-12-27 16:02:35',243388,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.129ms, lost 0%','rta=0.129ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631130,2,21397,0,0,1,5,1,1,'2024-12-27 16:02:35',251530,'2024-12-27 16:02:40',266485,26989,'','',30,0,0.08008,0.251,2,'CRITICAL - 172.20.3.10: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631131,2,23548,0,0,1,5,1,1,'2024-12-27 16:02:35',249003,'2024-12-27 16:02:40',266731,26989,'','',30,0,0.08266,0.248,2,'CRITICAL - 172.20.3.11: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631132,2,21395,0,0,1,5,1,1,'2024-12-27 16:02:35',245897,'2024-12-27 16:02:40',266962,26989,'','',30,0,2.00739,0.245,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631133,2,28533,0,0,1,1,1,1,'2024-12-27 16:02:35',253265,'2024-12-27 16:02:40',267206,26989,'','',30,0,2.00908,0.253,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631134,2,23553,0,0,1,10,1,1,'2024-12-27 16:02:45',297969,'2024-12-27 16:02:47',307344,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631135,2,23554,0,0,1,1,0,1,'2024-12-27 16:02:47',307988,'2024-12-27 16:02:47',318763,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631136,2,21396,0,0,1,5,0,1,'2024-12-27 16:02:50',353151,'2024-12-27 16:02:55',381387,26989,'','',30,0,0.02926,0.353,0,'OK - 192.168.77.159: rta 1.097ms, lost 0%','rta=1.097ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631137,2,28533,0,0,1,1,1,1,'2024-12-27 16:02:55',381462,'2024-12-27 16:02:56',434457,26989,'','',30,0,1.052,0,1,'CRITICAL - 172.50.1.3: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631138,2,23551,0,0,1,1,0,1,'2024-12-27 16:03:00',471105,'2024-12-27 16:03:00',482011,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631139,2,23552,0,0,1,1,0,1,'2024-12-27 16:03:05',510059,'2024-12-27 16:03:05',519594,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.122ms, lost 0%','rta=0.122ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631140,2,23553,0,0,1,10,1,1,'2024-12-27 16:03:05',520191,'2024-12-27 16:03:07',529140,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631141,2,23548,0,0,1,5,1,1,'2024-12-27 16:03:10',556944,'2024-12-27 16:03:12',566031,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631142,2,23554,0,0,1,1,0,1,'2024-12-27 16:03:12',566373,'2024-12-27 16:03:12',576324,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631143,2,23551,0,0,1,1,0,1,'2024-12-27 16:03:12',578930,'2024-12-27 16:03:15',600122,26989,'','',30,0,0.00881,2.578,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631144,2,23553,0,0,1,10,1,1,'2024-12-27 16:03:12',584587,'2024-12-27 16:03:15',600559,26989,'','',30,0,0.97968,0.584,2,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631145,2,23552,0,0,1,1,0,1,'2024-12-27 16:03:20',641736,'2024-12-27 16:03:25',675858,26989,'','',30,0,0.009,0.641,0,'OK - 192.168.77.8: rta 0.118ms, lost 0%','rta=0.118ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631146,2,23549,0,0,1,10,0,1,'2024-12-27 16:03:20',645047,'2024-12-27 16:03:25',676137,26989,'','',30,0,0.0107,0.645,0,'OK - 84.38.95.222: rta 0.218ms, lost 0%','rta=0.218ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631147,2,21395,0,0,1,5,1,1,'2024-12-27 16:03:25',676201,'2024-12-27 16:03:27',685136,26989,'','',30,0,2.008,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631148,2,28533,0,0,1,1,1,1,'2024-12-27 16:03:30',723386,'2024-12-27 16:03:32',734101,26989,'','',30,0,2.01,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631149,2,28279,0,0,1,1,0,1,'2024-12-27 16:03:27',688364,'2024-12-27 16:03:32',734595,26989,'','',30,0,0.00641,2.688,0,'OK - 192.168.77.9: rta 0.014ms, lost 0%','rta=0.014ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631150,2,23548,0,0,1,5,1,1,'2024-12-27 16:03:35',799676,'2024-12-27 16:03:36',808826,26989,'','',30,0,1.008,0,1,'CRITICAL - 172.20.3.11: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631151,2,23554,0,0,1,1,0,1,'2024-12-27 16:03:36',811572,'2024-12-27 16:03:40',851471,26989,'','',30,0,0.00907,1.811,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631152,2,23551,0,0,1,1,0,1,'2024-12-27 16:03:40',851539,'2024-12-27 16:03:40',863042,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631153,2,23553,0,0,1,10,1,1,'2024-12-27 16:03:40',863370,'2024-12-27 16:03:41',940484,26989,'','',30,0,1.076,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631154,2,28533,0,0,1,1,1,1,'2024-12-27 16:03:41',951290,'2024-12-27 16:03:45',978696,26989,'','',30,0,0.54041,1.951,2,'CRITICAL - 172.50.1.3: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631155,2,21397,0,0,1,5,1,1,'2024-12-27 16:03:41',943288,'2024-12-27 16:03:45',978955,26989,'','',30,0,2.00778,1.943,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631156,2,23548,0,0,1,5,1,1,'2024-12-27 16:03:41',946306,'2024-12-27 16:03:45',979205,26989,'','',30,0,2.00774,1.946,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631157,2,21395,0,0,1,5,1,1,'2024-12-27 16:03:41',949769,'2024-12-27 16:03:45',979469,26989,'','',30,0,2.00992,1.949,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631158,2,23552,0,0,1,1,0,1,'2024-12-27 16:03:50',1120,'2024-12-27 16:03:50',5291,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.137ms, lost 0%','rta=0.137ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631159,2,21396,0,0,1,5,0,1,'2024-12-27 16:03:55',1589,'2024-12-27 16:04:00',34,26989,'','',30,0,0.02543,0.03,0,'OK - 192.168.77.159: rta 0.960ms, lost 0%','rta=0.960ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631160,2,23554,0,0,1,1,0,1,'2024-12-27 16:04:00',18083,'2024-12-27 16:04:00',43,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631161,2,23551,0,0,1,1,0,1,'2024-12-27 16:04:05',498,'2024-12-27 16:04:05',0,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631162,2,28533,0,0,1,1,1,1,'2024-12-27 16:04:05',0,'2024-12-27 16:04:07',0,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631163,2,28279,0,0,1,1,0,1,'2024-12-27 16:04:10',114590,'2024-12-27 16:04:10',122325,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631164,2,23552,0,0,1,1,0,1,'2024-12-27 16:04:15',134450,'2024-12-27 16:04:15',144746,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.142ms, lost 0%','rta=0.142ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631165,2,23551,0,0,1,1,0,1,'2024-12-27 16:04:15',147221,'2024-12-27 16:04:20',170243,26989,'','',30,0,0.00898,0.147,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631166,2,21396,0,0,1,5,0,1,'2024-12-27 16:04:20',170315,'2024-12-27 16:04:20',196145,26989,'','',30,0,0.025,0,0,'OK - 192.168.77.159: rta 0.905ms, lost 0%','rta=0.905ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631167,2,23553,0,0,1,10,1,1,'2024-12-27 16:04:15',150264,'2024-12-27 16:04:20',196717,26989,'','',30,0,2.00733,0.15,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631168,2,23554,0,0,1,1,0,1,'2024-12-27 16:04:25',208900,'2024-12-27 16:04:25',219485,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631169,2,23552,0,0,1,1,0,1,'2024-12-27 16:04:25',222062,'2024-12-27 16:04:30',252795,26989,'','',30,0,0.00841,0.222,0,'OK - 192.168.77.8: rta 0.119ms, lost 0%','rta=0.119ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631170,2,23549,0,0,1,10,0,1,'2024-12-27 16:04:25',224938,'2024-12-27 16:04:30',253006,26989,'','',30,0,0.0124,0.224,0,'OK - 84.38.95.222: rta 0.252ms, lost 0%','rta=0.252ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631171,2,28279,0,0,1,1,0,1,'2024-12-27 16:04:32',262079,'2024-12-27 16:04:35',280150,26989,'','',30,0,0.00754,0.262,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631172,2,23554,0,0,1,1,0,1,'2024-12-27 16:04:40',306997,'2024-12-27 16:04:45',334022,26989,'','',30,0,0.00941,0.306,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631173,2,23552,0,0,1,1,0,1,'2024-12-27 16:04:45',334091,'2024-12-27 16:04:45',344126,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.124ms, lost 0%','rta=0.124ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631174,2,23553,0,0,1,10,1,1,'2024-12-27 16:04:45',344469,'2024-12-27 16:04:47',353310,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631175,2,23548,0,0,1,5,1,1,'2024-12-27 16:04:47',362295,'2024-12-27 16:04:50',401909,26989,'','',30,0,0.98831,2.362,2,'CRITICAL - 172.20.3.11: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631176,2,21397,0,0,1,5,1,1,'2024-12-27 16:04:47',358950,'2024-12-27 16:04:50',402147,26989,'','',30,0,0.99228,2.358,2,'CRITICAL - 172.20.3.10: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631177,2,28533,0,0,1,1,1,1,'2024-12-27 16:04:47',355862,'2024-12-27 16:04:50',402662,26989,'','',30,0,2.00694,2.355,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631178,2,21395,0,0,1,5,1,1,'2024-12-27 16:04:47',365372,'2024-12-27 16:04:50',402899,26989,'','',30,0,2.0083,2.365,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631179,2,23549,0,0,1,10,0,1,'2024-12-27 16:04:50',402957,'2024-12-27 16:04:50',417114,26989,'','',30,0,0.013,0,0,'OK - 84.38.95.222: rta 0.290ms, lost 0%','rta=0.290ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631180,2,23551,0,0,1,1,0,1,'2024-12-27 16:04:55',446671,'2024-12-27 16:04:55',457206,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631181,2,23554,0,0,1,1,0,1,'2024-12-27 16:05:00',496117,'2024-12-27 16:05:00',506768,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631182,2,21396,0,0,1,5,0,1,'2024-12-27 16:05:00',509636,'2024-12-27 16:05:05',537313,26989,'','',30,0,0.02114,0.509,0,'OK - 192.168.77.159: rta 0.760ms, lost 0%','rta=0.760ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631183,2,28533,0,0,1,1,1,1,'2024-12-27 16:05:05',537604,'2024-12-27 16:05:07',546132,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631184,2,23552,0,0,1,1,0,1,'2024-12-27 16:05:10',568711,'2024-12-27 16:05:10',578877,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.126ms, lost 0%','rta=0.126ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631185,2,21397,0,0,1,5,1,1,'2024-12-27 16:05:15',603791,'2024-12-27 16:05:17',612749,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631186,2,23553,0,0,1,10,1,1,'2024-12-27 16:05:17',613067,'2024-12-27 16:05:18',612959,26989,'','',30,0,1,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631187,2,23554,0,0,1,1,0,1,'2024-12-27 16:05:20',641420,'2024-12-27 16:05:20',653196,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.208: rta 0.154ms, lost 0%','rta=0.154ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631188,2,23549,0,0,1,10,0,1,'2024-12-27 16:05:20',653593,'2024-12-27 16:05:20',666765,26989,'','',30,0,0.012,0,0,'OK - 84.38.95.222: rta 0.246ms, lost 0%','rta=0.246ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631189,2,23551,0,0,1,1,0,1,'2024-12-27 16:05:20',669388,'2024-12-27 16:05:25',699876,26989,'','',30,0,0.00955,0.669,0,'OK - 192.168.77.29: rta 0.179ms, lost 0%','rta=0.179ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631190,2,23553,0,0,1,10,1,1,'2024-12-27 16:05:20',672505,'2024-12-27 16:05:25',700121,26989,'','',30,0,2.00805,0.672,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631191,2,28533,0,0,1,1,1,1,'2024-12-27 16:05:25',700397,'2024-12-27 16:05:27',710601,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631192,2,23552,0,0,1,1,0,1,'2024-12-27 16:05:30',803993,'2024-12-27 16:05:35',842331,26989,'','',30,0,0.00925,0.803,0,'OK - 192.168.77.8: rta 0.129ms, lost 0%','rta=0.129ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631193,2,23549,0,0,1,10,0,1,'2024-12-27 16:05:30',807452,'2024-12-27 16:05:35',842592,26989,'','',30,0,0.01207,0.807,0,'OK - 84.38.95.222: rta 0.280ms, lost 0%','rta=0.280ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631194,2,28279,0,0,1,1,0,1,'2024-12-27 16:05:35',842661,'2024-12-27 16:05:35',851063,26989,'','',30,0,0.008,0,0,'OK - 192.168.77.9: rta 0.016ms, lost 0%','rta=0.016ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631195,2,28279,0,0,1,1,0,1,'2024-12-27 16:05:35',853959,'2024-12-27 16:05:40',889542,26989,'','',30,0,0.00604,0.853,0,'OK - 192.168.77.9: rta 0.014ms, lost 0%','rta=0.014ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631196,2,23551,0,0,1,1,0,1,'2024-12-27 16:05:40',889607,'2024-12-27 16:05:40',900151,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631197,2,21397,0,0,1,5,1,1,'2024-12-27 16:05:45',930190,'2024-12-27 16:05:47',939757,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631198,2,23553,0,0,1,10,1,1,'2024-12-27 16:05:47',940113,'2024-12-27 16:05:48',939054,26989,'','',30,0,0.999,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631199,2,23554,0,0,1,1,0,1,'2024-12-27 16:05:48',939638,'2024-12-27 16:05:48',949651,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631200,2,23554,0,0,1,1,0,1,'2024-12-27 16:05:48',952324,'2024-12-27 16:05:50',989453,26989,'','',30,0,0.00901,3.952,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631201,2,28533,0,0,1,1,1,1,'2024-12-27 16:05:55',5282,'2024-12-27 16:05:57',9410,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631202,2,28533,0,0,1,1,1,1,'2024-12-27 16:05:50',996464,'2024-12-27 16:05:57',18,26989,'','',30,0,1.06907,0.996,2,'CRITICAL - 172.50.1.3: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631203,2,23548,0,0,1,5,1,1,'2024-12-27 16:05:50',991894,'2024-12-27 16:05:57',152,26989,'','',30,0,2.0085,0.991,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631204,2,21397,0,0,1,5,1,1,'2024-12-27 16:05:50',994472,'2024-12-27 16:05:57',9962,26989,'','',30,0,2.00888,0.994,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631205,2,21395,0,0,1,5,1,1,'2024-12-27 16:05:50',998501,'2024-12-27 16:05:57',157,26989,'','',30,0,2.00744,0.998,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631206,2,23551,0,0,1,1,0,1,'2024-12-27 16:06:00',3,'2024-12-27 16:06:00',21056,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631207,2,23552,0,0,1,1,0,1,'2024-12-27 16:06:05',425,'2024-12-27 16:06:05',31386,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.135ms, lost 0%','rta=0.135ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631208,2,23553,0,0,1,10,1,1,'2024-12-27 16:06:05',31568,'2024-12-27 16:06:07',0,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631209,2,21396,0,0,1,5,0,1,'2024-12-27 16:06:07',103125,'2024-12-27 16:06:10',118634,26989,'','',30,0,0.02133,2.103,0,'OK - 192.168.77.159: rta 0.770ms, lost 0%','rta=0.770ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631210,2,23548,0,0,1,5,1,1,'2024-12-27 16:06:10',118681,'2024-12-27 16:06:12',127778,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631211,2,23554,0,0,1,1,0,1,'2024-12-27 16:06:12',140992,'2024-12-27 16:06:12',151072,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631212,2,21395,0,0,1,5,1,1,'2024-12-27 16:06:25',196231,'2024-12-27 16:06:27',207066,26989,'','',30,0,2.01,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631213,2,23552,0,0,1,1,0,1,'2024-12-27 16:06:27',207386,'2024-12-27 16:06:27',217062,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.129ms, lost 0%','rta=0.129ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631214,2,23551,0,0,1,1,0,1,'2024-12-27 16:06:27',217368,'2024-12-27 16:06:27',227249,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.148ms, lost 0%','rta=0.148ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631215,2,28533,0,0,1,1,1,1,'2024-12-27 16:06:30',265984,'2024-12-27 16:06:32',276110,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631216,2,23551,0,0,1,1,0,1,'2024-12-27 16:06:27',229779,'2024-12-27 16:06:32',276643,26989,'','',30,0,0.00895,2.229,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631217,2,23553,0,0,1,10,1,1,'2024-12-27 16:06:27',232818,'2024-12-27 16:06:32',277156,26989,'','',30,0,2.00762,2.232,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631218,2,23548,0,0,1,5,1,1,'2024-12-27 16:06:32',277474,'2024-12-27 16:06:34',286462,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631219,2,23552,0,0,1,1,0,1,'2024-12-27 16:06:35',293238,'2024-12-27 16:06:40',341906,26989,'','',30,0,0.00945,0.293,0,'OK - 192.168.77.8: rta 0.137ms, lost 0%','rta=0.137ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631220,2,23549,0,0,1,10,0,1,'2024-12-27 16:06:35',296359,'2024-12-27 16:06:40',342144,26989,'','',30,0,0.01752,0.296,0,'OK - 84.38.95.222: rta 0.519ms, lost 0%','rta=0.519ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631221,2,28279,0,0,1,1,0,1,'2024-12-27 16:06:40',345265,'2024-12-27 16:06:45',375190,26989,'','',30,0,0.0074,0.345,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631222,2,23554,0,0,1,1,0,1,'2024-12-27 16:06:50',424474,'2024-12-27 16:06:50',435946,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631223,2,23553,0,0,1,10,1,1,'2024-12-27 16:06:50',436287,'2024-12-27 16:06:51',469377,26989,'','',30,0,1.032,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631224,2,23552,0,0,1,1,0,1,'2024-12-27 16:06:51',469707,'2024-12-27 16:06:51',479391,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.134ms, lost 0%','rta=0.134ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631225,2,21395,0,0,1,5,1,1,'2024-12-27 16:06:51',479980,'2024-12-27 16:06:53',487696,26989,'','',30,0,2.007,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631226,2,23554,0,0,1,1,0,1,'2024-12-27 16:06:53',490279,'2024-12-27 16:06:55',519370,26989,'','',30,0,0.00918,3.49,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631227,2,28533,0,0,1,1,1,1,'2024-12-27 16:06:57',524443,'2024-12-27 16:07:00',558748,26989,'','',30,0,2.00858,0.524,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631228,2,23548,0,0,1,5,1,1,'2024-12-27 16:06:57',528220,'2024-12-27 16:07:00',558987,26989,'','',30,0,2.00776,0.528,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631229,2,21397,0,0,1,5,1,1,'2024-12-27 16:06:57',529291,'2024-12-27 16:07:00',559236,26989,'','',30,0,2.00972,0.529,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631230,2,21395,0,0,1,5,1,1,'2024-12-27 16:06:57',530260,'2024-12-27 16:07:00',559482,26989,'','',30,0,2.00935,0.53,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631231,2,23551,0,0,1,1,0,1,'2024-12-27 16:07:05',595270,'2024-12-27 16:07:05',606216,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631232,2,28279,0,0,1,1,0,1,'2024-12-27 16:07:10',635300,'2024-12-27 16:07:10',643335,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.016ms, lost 0%','rta=0.016ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631233,2,21396,0,0,1,5,0,1,'2024-12-27 16:07:10',645915,'2024-12-27 16:07:15',672403,26989,'','',30,0,0.02012,0.645,0,'OK - 192.168.77.159: rta 0.709ms, lost 0%','rta=0.709ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631234,2,23552,0,0,1,1,0,1,'2024-12-27 16:07:15',672773,'2024-12-27 16:07:15',683081,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.117ms, lost 0%','rta=0.117ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631235,2,23553,0,0,1,10,1,1,'2024-12-27 16:07:20',722100,'2024-12-27 16:07:22',730785,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631236,2,23554,0,0,1,1,0,1,'2024-12-27 16:07:25',746620,'2024-12-27 16:07:25',757263,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631237,2,23551,0,0,1,1,0,1,'2024-12-27 16:07:32',791040,'2024-12-27 16:07:35',813016,26989,'','',30,0,0.00966,0.791,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631238,2,23553,0,0,1,10,1,1,'2024-12-27 16:07:32',794556,'2024-12-27 16:07:35',813263,26989,'','',30,0,2.00848,0.794,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631239,2,23552,0,0,1,1,0,1,'2024-12-27 16:07:40',845831,'2024-12-27 16:07:45',871134,26989,'','',30,0,0.00957,0.845,0,'OK - 192.168.77.8: rta 0.128ms, lost 0%','rta=0.128ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631240,2,23549,0,0,1,10,0,1,'2024-12-27 16:07:40',849598,'2024-12-27 16:07:45',871371,26989,'','',30,0,0.01759,0.849,0,'OK - 84.38.95.222: rta 0.532ms, lost 0%','rta=0.532ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631241,2,28279,0,0,1,1,0,1,'2024-12-27 16:07:45',874162,'2024-12-27 16:07:50',912623,26989,'','',30,0,0.00707,0.874,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631242,2,23554,0,0,1,1,0,1,'2024-12-27 16:07:55',941533,'2024-12-27 16:07:55',952775,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631243,2,23551,0,0,1,1,0,1,'2024-12-27 16:07:55',953080,'2024-12-27 16:07:55',962887,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631244,2,23554,0,0,1,1,0,1,'2024-12-27 16:07:55',965344,'2024-12-27 16:08:00',999859,26989,'','',30,0,0.00894,0.965,0,'OK - 192.168.77.208: rta 0.148ms, lost 0%','rta=0.148ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631245,2,28533,0,0,1,1,1,1,'2024-12-27 16:08:01',1678,'2024-12-27 16:08:05',170,26989,'','',30,0,2.00877,1.003,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631246,2,23548,0,0,1,5,1,1,'2024-12-27 16:08:01',5,'2024-12-27 16:08:05',11106,26989,'','',30,0,2.00844,1.005,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631247,2,21397,0,0,1,5,1,1,'2024-12-27 16:08:01',0,'2024-12-27 16:08:05',175,26989,'','',30,0,2.00841,1.008,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631248,2,21395,0,0,1,5,1,1,'2024-12-27 16:08:01',9,'2024-12-27 16:08:05',11278,26989,'','',30,0,2.00805,1.011,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631249,2,23552,0,0,1,1,0,1,'2024-12-27 16:08:10',3,'2024-12-27 16:08:10',4,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.129ms, lost 0%','rta=0.129ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631250,2,23553,0,0,1,10,1,1,'2024-12-27 16:08:15',26547,'2024-12-27 16:08:17',29990,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631251,2,21396,0,0,1,5,0,1,'2024-12-27 16:08:17',60,'2024-12-27 16:08:20',0,26989,'','',30,0,0.02731,2.074,0,'OK - 192.168.77.159: rta 1.065ms, lost 0%','rta=1.065ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631252,2,23554,0,0,1,1,0,1,'2024-12-27 16:08:20',0,'2024-12-27 16:08:20',101928,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631253,2,23549,0,0,1,10,0,1,'2024-12-27 16:08:20',102293,'2024-12-27 16:08:20',113415,26989,'','',30,0,0.01,0,0,'OK - 84.38.95.222: rta 0.206ms, lost 0%','rta=0.206ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631254,2,28533,0,0,1,1,1,1,'2024-12-27 16:08:25',134998,'2024-12-27 16:08:27',144428,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631255,2,23551,0,0,1,1,0,1,'2024-12-27 16:08:30',176285,'2024-12-27 16:08:30',187442,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631256,2,28279,0,0,1,1,0,1,'2024-12-27 16:08:35',224173,'2024-12-27 16:08:35',232506,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631257,2,23552,0,0,1,1,0,1,'2024-12-27 16:08:35',232886,'2024-12-27 16:08:35',242802,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.113ms, lost 0%','rta=0.113ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631258,2,23551,0,0,1,1,0,1,'2024-12-27 16:08:35',245364,'2024-12-27 16:08:40',289431,26989,'','',30,0,0.00885,0.245,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631259,2,23553,0,0,1,10,1,1,'2024-12-27 16:08:35',248420,'2024-12-27 16:08:40',289702,26989,'','',30,0,0.05546,0.248,2,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631260,2,21397,0,0,1,5,1,1,'2024-12-27 16:08:45',324778,'2024-12-27 16:08:47',333998,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631261,2,23554,0,0,1,1,0,1,'2024-12-27 16:08:47',334842,'2024-12-27 16:08:47',344846,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631262,2,23552,0,0,1,1,0,1,'2024-12-27 16:08:47',347340,'2024-12-27 16:08:50',374409,26989,'','',30,0,0.00846,2.347,0,'OK - 192.168.77.8: rta 0.127ms, lost 0%','rta=0.127ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631263,2,23549,0,0,1,10,0,1,'2024-12-27 16:08:47',350401,'2024-12-27 16:08:50',374644,26989,'','',30,0,0.01188,2.35,0,'OK - 84.38.95.222: rta 0.273ms, lost 0%','rta=0.273ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631264,2,28279,0,0,1,1,0,1,'2024-12-27 16:08:50',376935,'2024-12-27 16:08:55',403892,26989,'','',30,0,0.00766,0.376,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631265,2,28533,0,0,1,1,1,1,'2024-12-27 16:08:55',403951,'2024-12-27 16:08:57',414173,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631266,2,23551,0,0,1,1,0,1,'2024-12-27 16:09:00',448782,'2024-12-27 16:09:00',459350,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.148ms, lost 0%','rta=0.148ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631267,2,23554,0,0,1,1,0,1,'2024-12-27 16:09:00',461744,'2024-12-27 16:09:05',483840,26989,'','',30,0,0.00881,0.461,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631268,2,23552,0,0,1,1,0,1,'2024-12-27 16:09:05',483908,'2024-12-27 16:09:05',493683,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.119ms, lost 0%','rta=0.119ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631269,2,23553,0,0,1,10,1,1,'2024-12-27 16:09:05',494046,'2024-12-27 16:09:07',504045,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631270,2,23548,0,0,1,5,1,1,'2024-12-27 16:09:07',509654,'2024-12-27 16:09:10',545495,26989,'','',30,0,0.99257,2.509,2,'CRITICAL - 172.20.3.11: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631271,2,21397,0,0,1,5,1,1,'2024-12-27 16:09:07',512594,'2024-12-27 16:09:10',545741,26989,'','',30,0,0.98966,2.512,2,'CRITICAL - 172.20.3.10: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631272,2,28533,0,0,1,1,1,1,'2024-12-27 16:09:07',506816,'2024-12-27 16:09:10',546485,26989,'','',30,0,2.00861,2.506,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631273,2,21395,0,0,1,5,1,1,'2024-12-27 16:09:07',516170,'2024-12-27 16:09:10',546720,26989,'','',30,0,2.00922,2.516,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631274,2,21396,0,0,1,5,0,1,'2024-12-27 16:09:20',607919,'2024-12-27 16:09:25',646169,26989,'','',30,0,0.02231,0.607,0,'OK - 192.168.77.159: rta 0.774ms, lost 0%','rta=0.774ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631275,2,23552,0,0,1,1,0,1,'2024-12-27 16:09:25',646230,'2024-12-27 16:09:25',656848,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.122ms, lost 0%','rta=0.122ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631276,2,21395,0,0,1,5,1,1,'2024-12-27 16:09:25',657181,'2024-12-27 16:09:27',666033,26989,'','',30,0,2.008,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631277,2,23551,0,0,1,1,0,1,'2024-12-27 16:09:27',666350,'2024-12-27 16:09:27',676493,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631278,2,28533,0,0,1,1,1,1,'2024-12-27 16:09:30',799688,'2024-12-27 16:09:32',810616,26989,'','',30,0,2.01,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631279,2,23548,0,0,1,5,1,1,'2024-12-27 16:09:32',811348,'2024-12-27 16:09:34',819898,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631280,2,23553,0,0,1,10,1,1,'2024-12-27 16:09:40',885421,'2024-12-27 16:09:41',969982,26989,'','',30,0,1.084,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631281,2,23551,0,0,1,1,0,1,'2024-12-27 16:09:41',972875,'2024-12-27 16:09:46',55,26989,'','',30,0,0.00954,1.972,0,'OK - 192.168.77.29: rta 0.155ms, lost 0%','rta=0.155ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631282,2,23553,0,0,1,10,1,1,'2024-12-27 16:09:41',973674,'2024-12-27 16:09:46',3624,26989,'','',30,0,2.01052,1.973,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631283,2,28533,0,0,1,1,1,1,'2024-12-27 16:09:46',3841,'2024-12-27 16:09:46',520914,26989,'','',30,0,0.513,0,1,'CRITICAL - 172.50.1.3: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631284,2,23554,0,0,1,1,0,1,'2024-12-27 16:09:50',544914,'2024-12-27 16:09:50',556543,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631285,2,23552,0,0,1,1,0,1,'2024-12-27 16:09:50',556878,'2024-12-27 16:09:50',566203,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.117ms, lost 0%','rta=0.117ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631286,2,21395,0,0,1,5,1,1,'2024-12-27 16:09:50',567109,'2024-12-27 16:09:51',537761,26989,'','',30,0,0.971,0,1,'CRITICAL - 192.168.77.154: Host unreachable @ 192.168.77.9. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631287,2,23552,0,0,1,1,0,1,'2024-12-27 16:09:51',540189,'2024-12-27 16:09:55',556485,26989,'','',30,0,0.00878,1.54,0,'OK - 192.168.77.8: rta 0.131ms, lost 0%','rta=0.131ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631288,2,23549,0,0,1,10,0,1,'2024-12-27 16:09:51',543348,'2024-12-27 16:09:55',556718,26989,'','',30,0,0.01038,1.543,0,'OK - 84.38.95.222: rta 0.203ms, lost 0%','rta=0.203ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631289,2,28279,0,0,1,1,0,1,'2024-12-27 16:09:55',559529,'2024-12-27 16:10:00',571373,26989,'','',30,0,0.00729,0.559,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631290,2,23551,0,0,1,1,0,1,'2024-12-27 16:10:05',593154,'2024-12-27 16:10:05',603924,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631291,2,28533,0,0,1,1,1,1,'2024-12-27 16:10:05',604247,'2024-12-27 16:10:07',612617,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631292,2,23554,0,0,1,1,0,1,'2024-12-27 16:10:07',615122,'2024-12-27 16:10:10',649639,26989,'','',30,0,0.00914,2.615,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631293,2,23548,0,0,1,5,1,1,'2024-12-27 16:10:10',652466,'2024-12-27 16:10:15',683624,26989,'','',30,0,2.00859,0.652,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631294,2,21397,0,0,1,5,1,1,'2024-12-27 16:10:10',656263,'2024-12-27 16:10:15',683861,26989,'','',30,0,2.00851,0.656,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631295,2,28533,0,0,1,1,1,1,'2024-12-27 16:10:10',657523,'2024-12-27 16:10:15',684106,26989,'','',30,0,2.0079,0.657,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631296,2,21395,0,0,1,5,1,1,'2024-12-27 16:10:10',660588,'2024-12-27 16:10:15',684355,26989,'','',30,0,2.00815,0.66,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631297,2,23552,0,0,1,1,0,1,'2024-12-27 16:10:15',684419,'2024-12-27 16:10:15',694968,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.116ms, lost 0%','rta=0.116ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631298,2,21396,0,0,1,5,0,1,'2024-12-27 16:10:20',740976,'2024-12-27 16:10:20',763385,26989,'','',30,0,0.022,0,0,'OK - 192.168.77.159: rta 0.702ms, lost 0%','rta=0.702ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631299,2,23553,0,0,1,10,1,1,'2024-12-27 16:10:20',763747,'2024-12-27 16:10:22',772800,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631300,2,23554,0,0,1,1,0,1,'2024-12-27 16:10:25',800178,'2024-12-27 16:10:25',810383,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631301,2,21396,0,0,1,5,0,1,'2024-12-27 16:10:25',812854,'2024-12-27 16:10:30',837366,26989,'','',30,0,0.02947,0.812,0,'OK - 192.168.77.159: rta 1.181ms, lost 0%','rta=1.181ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631302,2,23552,0,0,1,1,0,1,'2024-12-27 16:10:45',931872,'2024-12-27 16:10:45',941963,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.129ms, lost 0%','rta=0.129ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631303,2,23553,0,0,1,10,1,1,'2024-12-27 16:10:45',942348,'2024-12-27 16:10:47',952246,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631304,2,23551,0,0,1,1,0,1,'2024-12-27 16:10:47',954838,'2024-12-27 16:10:50',995718,26989,'','',30,0,0.01152,1.954,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631305,2,23553,0,0,1,10,1,1,'2024-12-27 16:10:47',955601,'2024-12-27 16:10:50',995969,26989,'','',30,0,0.99468,1.955,2,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631306,2,23549,0,0,1,10,0,1,'2024-12-27 16:10:50',996329,'2024-12-27 16:10:51',0,26989,'','',30,0,0.013,0,0,'OK - 84.38.95.222: rta 0.199ms, lost 0%','rta=0.199ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631307,2,23554,0,0,1,1,0,1,'2024-12-27 16:10:55',9991,'2024-12-27 16:10:55',14437,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631308,2,23552,0,0,1,1,0,1,'2024-12-27 16:10:55',30,'2024-12-27 16:11:00',25014,26989,'','',30,0,0.00877,0.036,0,'OK - 192.168.77.8: rta 0.141ms, lost 0%','rta=0.141ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631309,2,23549,0,0,1,10,0,1,'2024-12-27 16:10:55',3,'2024-12-27 16:11:00',48,26989,'','',30,0,0.01068,0.039,0,'OK - 84.38.95.222: rta 0.202ms, lost 0%','rta=0.202ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631310,2,28279,0,0,1,1,0,1,'2024-12-27 16:11:00',413,'2024-12-27 16:11:05',0,26989,'','',30,0,0.00633,0.063,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631311,2,23551,0,0,1,1,0,1,'2024-12-27 16:11:05',0,'2024-12-27 16:11:05',0,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631312,2,28533,0,0,1,1,1,1,'2024-12-27 16:11:05',0,'2024-12-27 16:11:07',102743,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631313,2,23554,0,0,1,1,0,1,'2024-12-27 16:11:10',131226,'2024-12-27 16:11:15',146018,26989,'','',30,0,0.00949,0.131,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631314,2,21397,0,0,1,5,1,1,'2024-12-27 16:11:15',146067,'2024-12-27 16:11:17',154974,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631315,2,23553,0,0,1,10,1,1,'2024-12-27 16:11:17',163640,'2024-12-27 16:11:18',154949,26989,'','',30,0,0.992,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631316,2,23549,0,0,1,10,0,1,'2024-12-27 16:11:20',179862,'2024-12-27 16:11:20',192665,26989,'','',30,0,0.012,0,0,'OK - 84.38.95.222: rta 0.222ms, lost 0%','rta=0.222ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631317,2,23548,0,0,1,5,1,1,'2024-12-27 16:11:18',157604,'2024-12-27 16:11:20',193196,26989,'','',30,0,2.00657,3.157,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631318,2,21397,0,0,1,5,1,1,'2024-12-27 16:11:18',159983,'2024-12-27 16:11:20',193449,26989,'','',30,0,2.00945,3.159,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631319,2,28533,0,0,1,1,1,1,'2024-12-27 16:11:18',161970,'2024-12-27 16:11:20',193687,26989,'','',30,0,2.00855,3.161,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631320,2,21395,0,0,1,5,1,1,'2024-12-27 16:11:18',163031,'2024-12-27 16:11:20',193944,26989,'','',30,0,2.01047,3.162,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631321,2,23551,0,0,1,1,0,1,'2024-12-27 16:11:30',227524,'2024-12-27 16:11:30',238971,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631322,2,21396,0,0,1,5,0,1,'2024-12-27 16:11:30',241741,'2024-12-27 16:11:35',258230,26989,'','',30,0,0.02646,0.241,0,'OK - 192.168.77.159: rta 1.024ms, lost 0%','rta=1.024ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631323,2,28279,0,0,1,1,0,1,'2024-12-27 16:11:35',258304,'2024-12-27 16:11:35',266961,26989,'','',30,0,0.008,0,0,'OK - 192.168.77.9: rta 0.016ms, lost 0%','rta=0.016ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631324,2,23552,0,0,1,1,0,1,'2024-12-27 16:11:35',267291,'2024-12-27 16:11:35',276228,26989,'','',30,0,0.008,0,0,'OK - 192.168.77.8: rta 0.109ms, lost 0%','rta=0.109ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631325,2,21397,0,0,1,5,1,1,'2024-12-27 16:11:45',312479,'2024-12-27 16:11:47',321902,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631326,2,23553,0,0,1,10,1,1,'2024-12-27 16:11:47',322205,'2024-12-27 16:11:48',320351,26989,'','',30,0,0.998,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631327,2,23554,0,0,1,1,0,1,'2024-12-27 16:11:48',320996,'2024-12-27 16:11:48',332299,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631328,2,23551,0,0,1,1,0,1,'2024-12-27 16:11:50',364740,'2024-12-27 16:11:55',388748,26989,'','',30,0,0.01,0.364,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631329,2,23553,0,0,1,10,1,1,'2024-12-27 16:11:50',368075,'2024-12-27 16:11:55',389008,26989,'','',30,0,2.00798,0.368,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631330,2,28533,0,0,1,1,1,1,'2024-12-27 16:11:55',389069,'2024-12-27 16:11:57',398372,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631331,2,23552,0,0,1,1,0,1,'2024-12-27 16:12:00',439299,'2024-12-27 16:12:05',464384,26989,'','',30,0,0.01146,0.439,0,'OK - 192.168.77.8: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631332,2,23549,0,0,1,10,0,1,'2024-12-27 16:12:00',441649,'2024-12-27 16:12:05',464600,26989,'','',30,0,0.01534,0.441,0,'OK - 84.38.95.222: rta 0.380ms, lost 0%','rta=0.380ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631333,2,28279,0,0,1,1,0,1,'2024-12-27 16:12:05',467457,'2024-12-27 16:12:10',498203,26989,'','',30,0,0.00647,0.467,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631334,2,23548,0,0,1,5,1,1,'2024-12-27 16:12:10',498281,'2024-12-27 16:12:12',508389,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631335,2,23554,0,0,1,1,0,1,'2024-12-27 16:12:12',508716,'2024-12-27 16:12:12',518860,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631336,2,23554,0,0,1,1,0,1,'2024-12-27 16:12:15',543686,'2024-12-27 16:12:20',570988,26989,'','',30,0,0.00935,0.543,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631337,2,23552,0,0,1,1,0,1,'2024-12-27 16:12:25',610656,'2024-12-27 16:12:25',621131,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.113ms, lost 0%','rta=0.113ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631338,2,21395,0,0,1,5,1,1,'2024-12-27 16:12:25',621462,'2024-12-27 16:12:27',629439,26989,'','',30,0,2.007,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631339,2,21397,0,0,1,5,1,1,'2024-12-27 16:12:20',574291,'2024-12-27 16:12:27',629914,26989,'','',30,0,2.00816,0.574,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631340,2,23548,0,0,1,5,1,1,'2024-12-27 16:12:20',573199,'2024-12-27 16:12:27',630143,26989,'','',30,0,2.01041,0.573,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631341,2,28533,0,0,1,1,1,1,'2024-12-27 16:12:20',577524,'2024-12-27 16:12:27',630377,26989,'','',30,0,2.00906,0.577,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631342,2,21395,0,0,1,5,1,1,'2024-12-27 16:12:20',580473,'2024-12-27 16:12:27',630609,26989,'','',30,0,2.00831,0.58,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631343,2,23551,0,0,1,1,0,1,'2024-12-27 16:12:27',630674,'2024-12-27 16:12:27',640866,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.146ms, lost 0%','rta=0.146ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631344,2,21396,0,0,1,5,0,1,'2024-12-27 16:12:35',718865,'2024-12-27 16:12:40',769077,26989,'','',30,0,0.02584,0.718,0,'OK - 192.168.77.159: rta 0.931ms, lost 0%','rta=0.931ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631345,2,23553,0,0,1,10,1,1,'2024-12-27 16:12:40',769421,'2024-12-27 16:12:41',852793,26989,'','',30,0,1.083,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631346,2,28533,0,0,1,1,1,1,'2024-12-27 16:12:45',881927,'2024-12-27 16:12:47',891255,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631347,2,23554,0,0,1,1,0,1,'2024-12-27 16:12:50',937848,'2024-12-27 16:12:50',949489,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631348,2,23552,0,0,1,1,0,1,'2024-12-27 16:12:50',949847,'2024-12-27 16:12:50',959280,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.114ms, lost 0%','rta=0.114ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631349,2,21395,0,0,1,5,1,1,'2024-12-27 16:12:50',960355,'2024-12-27 16:12:51',907871,26989,'','',30,0,0.948,0,1,'CRITICAL - 192.168.77.154: Host unreachable @ 192.168.77.9. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631350,2,23551,0,0,1,1,0,1,'2024-12-27 16:12:55',931839,'2024-12-27 16:13:00',954830,26989,'','',30,0,0.01054,0.931,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631351,2,23553,0,0,1,10,1,1,'2024-12-27 16:12:55',932668,'2024-12-27 16:13:00',955291,26989,'','',30,0,2.01013,0.932,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631352,2,28533,0,0,1,1,1,1,'2024-12-27 16:13:05',996378,'2024-12-27 16:13:08',49,26989,'','',30,0,2.01,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631353,2,23552,0,0,1,1,0,1,'2024-12-27 16:13:08',0,'2024-12-27 16:13:10',2,26989,'','',30,0,0.01383,3.008,0,'OK - 192.168.77.8: rta 0.343ms, lost 0%','rta=0.343ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631354,2,23549,0,0,1,10,0,1,'2024-12-27 16:13:08',5324,'2024-12-27 16:13:10',12326,26989,'','',30,0,0.01644,3.012,0,'OK - 84.38.95.222: rta 0.505ms, lost 0%','rta=0.505ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631355,2,28279,0,0,1,1,0,1,'2024-12-27 16:13:10',12362,'2024-12-27 16:13:10',16373,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631356,2,28279,0,0,1,1,0,1,'2024-12-27 16:13:10',16650,'2024-12-27 16:13:15',335,26989,'','',30,0,0.00613,0.04,0,'OK - 192.168.77.9: rta 0.014ms, lost 0%','rta=0.014ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631357,2,23551,0,0,1,1,0,1,'2024-12-27 16:13:15',41,'2024-12-27 16:13:15',25836,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631358,2,21396,0,0,1,5,0,1,'2024-12-27 16:13:20',0,'2024-12-27 16:13:20',110115,26989,'','',30,0,0.028,0,0,'OK - 192.168.77.159: rta 1.071ms, lost 0%','rta=1.071ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631359,2,23553,0,0,1,10,1,1,'2024-12-27 16:13:20',110464,'2024-12-27 16:13:22',118499,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631360,2,23554,0,0,1,1,0,1,'2024-12-27 16:13:25',128250,'2024-12-27 16:13:25',139558,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631361,2,23554,0,0,1,1,0,1,'2024-12-27 16:13:22',121333,'2024-12-27 16:13:25',140091,26989,'','',30,0,0.00937,2.121,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631362,2,23548,0,0,1,5,1,1,'2024-12-27 16:13:27',147526,'2024-12-27 16:13:30',162744,26989,'','',30,0,2.00786,0.147,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631363,2,21397,0,0,1,5,1,1,'2024-12-27 16:13:27',146459,'2024-12-27 16:13:30',162973,26989,'','',30,0,2.01211,0.146,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631364,2,28533,0,0,1,1,1,1,'2024-12-27 16:13:27',150644,'2024-12-27 16:13:30',163205,26989,'','',30,0,2.00991,0.15,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631365,2,21395,0,0,1,5,1,1,'2024-12-27 16:13:27',153588,'2024-12-27 16:13:30',163434,26989,'','',30,0,2.00849,0.153,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631366,2,21396,0,0,1,5,0,1,'2024-12-27 16:13:40',197061,'2024-12-27 16:13:45',213222,26989,'','',30,0,0.02727,0.197,0,'OK - 192.168.77.159: rta 1.042ms, lost 0%','rta=1.042ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631367,2,23552,0,0,1,1,0,1,'2024-12-27 16:13:45',213286,'2024-12-27 16:13:45',223173,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.124ms, lost 0%','rta=0.124ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631368,2,23553,0,0,1,10,1,1,'2024-12-27 16:13:45',223507,'2024-12-27 16:13:47',231869,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631369,2,23549,0,0,1,10,0,1,'2024-12-27 16:13:50',248704,'2024-12-27 16:13:50',267498,26989,'','',30,0,0.018,0,0,'OK - 84.38.95.222: rta 0.526ms, lost 0%','rta=0.526ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631370,2,23554,0,0,1,1,0,1,'2024-12-27 16:13:55',284692,'2024-12-27 16:13:55',295175,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631371,2,23551,0,0,1,1,0,1,'2024-12-27 16:13:55',295551,'2024-12-27 16:13:55',305354,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631372,2,23551,0,0,1,1,0,1,'2024-12-27 16:14:00',323380,'2024-12-27 16:14:05',347072,26989,'','',30,0,0.00922,0.323,0,'OK - 192.168.77.29: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631373,2,23553,0,0,1,10,1,1,'2024-12-27 16:14:00',326537,'2024-12-27 16:14:05',347327,26989,'','',30,0,2.00797,0.326,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631374,2,28533,0,0,1,1,1,1,'2024-12-27 16:14:05',347649,'2024-12-27 16:14:07',357613,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631375,2,23552,0,0,1,1,0,1,'2024-12-27 16:14:10',386008,'2024-12-27 16:14:10',396201,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.132ms, lost 0%','rta=0.132ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631376,2,23552,0,0,1,1,0,1,'2024-12-27 16:14:10',398751,'2024-12-27 16:14:15',424727,26989,'','',30,0,0.00851,0.398,0,'OK - 192.168.77.8: rta 0.126ms, lost 0%','rta=0.126ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631377,2,23549,0,0,1,10,0,1,'2024-12-27 16:14:10',401660,'2024-12-27 16:14:15',424966,26989,'','',30,0,0.01142,0.401,0,'OK - 84.38.95.222: rta 0.200ms, lost 0%','rta=0.200ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631378,2,21397,0,0,1,5,1,1,'2024-12-27 16:14:15',425023,'2024-12-27 16:14:17',434233,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631379,2,23553,0,0,1,10,1,1,'2024-12-27 16:14:17',434571,'2024-12-27 16:14:18',433413,26989,'','',30,0,0.999,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631380,2,28279,0,0,1,1,0,1,'2024-12-27 16:14:18',435957,'2024-12-27 16:14:20',467915,26989,'','',30,0,0.00654,3.435,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631381,2,23554,0,0,1,1,0,1,'2024-12-27 16:14:20',467992,'2024-12-27 16:14:20',479486,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631382,2,28533,0,0,1,1,1,1,'2024-12-27 16:14:25',506272,'2024-12-27 16:14:27',514842,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631383,2,23554,0,0,1,1,0,1,'2024-12-27 16:14:27',517537,'2024-12-27 16:14:30',554169,26989,'','',30,0,0.00913,2.517,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631384,2,23551,0,0,1,1,0,1,'2024-12-27 16:14:30',554242,'2024-12-27 16:14:30',565146,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631385,2,28279,0,0,1,1,0,1,'2024-12-27 16:14:35',617178,'2024-12-27 16:14:35',625093,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.016ms, lost 0%','rta=0.016ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631386,2,23548,0,0,1,5,1,1,'2024-12-27 16:14:30',568025,'2024-12-27 16:14:35',625618,26989,'','',30,0,2.00988,0.568,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631387,2,21397,0,0,1,5,1,1,'2024-12-27 16:14:30',570347,'2024-12-27 16:14:35',625852,26989,'','',30,0,2.00968,0.57,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631388,2,28533,0,0,1,1,1,1,'2024-12-27 16:14:30',571354,'2024-12-27 16:14:35',626090,26989,'','',30,0,2.01064,0.571,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631389,2,21395,0,0,1,5,1,1,'2024-12-27 16:14:30',574384,'2024-12-27 16:14:35',626321,26989,'','',30,0,2.00961,0.574,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631390,2,23552,0,0,1,1,0,1,'2024-12-27 16:14:35',626382,'2024-12-27 16:14:35',636051,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.123ms, lost 0%','rta=0.123ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631391,2,23553,0,0,1,10,1,1,'2024-12-27 16:14:45',740839,'2024-12-27 16:14:47',749543,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631392,2,21397,0,0,1,5,1,1,'2024-12-27 16:14:47',749861,'2024-12-27 16:14:48',749733,26989,'','',30,0,1,0,1,'CRITICAL - 172.20.3.10: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631393,2,23554,0,0,1,1,0,1,'2024-12-27 16:14:48',750283,'2024-12-27 16:14:48',760232,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631394,2,21396,0,0,1,5,0,1,'2024-12-27 16:14:48',762728,'2024-12-27 16:14:50',791199,26989,'','',30,0,0.02933,3.762,0,'OK - 192.168.77.159: rta 1.174ms, lost 0%','rta=1.174ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631395,2,28533,0,0,1,1,1,1,'2024-12-27 16:14:55',820998,'2024-12-27 16:14:57',831055,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631396,2,23551,0,0,1,1,0,1,'2024-12-27 16:15:00',869104,'2024-12-27 16:15:00',879761,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631397,2,23552,0,0,1,1,0,1,'2024-12-27 16:15:05',902733,'2024-12-27 16:15:05',912354,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.118ms, lost 0%','rta=0.118ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631398,2,23553,0,0,1,10,1,1,'2024-12-27 16:15:05',912680,'2024-12-27 16:15:07',921201,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631399,2,23551,0,0,1,1,0,1,'2024-12-27 16:15:07',923869,'2024-12-27 16:15:10',956488,26989,'','',30,0,0.00911,2.923,0,'OK - 192.168.77.29: rta 0.147ms, lost 0%','rta=0.147ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631400,2,23553,0,0,1,10,1,1,'2024-12-27 16:15:07',926989,'2024-12-27 16:15:10',956721,26989,'','',30,0,0.99238,2.926,2,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631401,2,23548,0,0,1,5,1,1,'2024-12-27 16:15:10',956774,'2024-12-27 16:15:12',964381,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631402,2,23554,0,0,1,1,0,1,'2024-12-27 16:15:12',964672,'2024-12-27 16:15:12',974544,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631403,2,23552,0,0,1,1,0,1,'2024-12-27 16:15:16',2805,'2024-12-27 16:15:20',11720,26989,'','',30,0,0.00963,1.005,0,'OK - 192.168.77.8: rta 0.128ms, lost 0%','rta=0.128ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631404,2,23549,0,0,1,10,0,1,'2024-12-27 16:15:16',0,'2024-12-27 16:15:20',22,26989,'','',30,0,0.01699,1.008,0,'OK - 84.38.95.222: rta 0.514ms, lost 0%','rta=0.514ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631405,2,28279,0,0,1,1,0,1,'2024-12-27 16:15:20',2,'2024-12-27 16:15:25',21323,26989,'','',30,0,0.00675,0.029,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631406,2,21395,0,0,1,5,1,1,'2024-12-27 16:15:25',41,'2024-12-27 16:15:27',25696,26989,'','',30,0,2.009,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631407,2,23551,0,0,1,1,0,1,'2024-12-27 16:15:27',25895,'2024-12-27 16:15:27',30136,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631408,2,28533,0,0,1,1,1,1,'2024-12-27 16:15:30',0,'2024-12-27 16:15:32',109690,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631409,2,23552,0,0,1,1,0,1,'2024-12-27 16:15:32',110337,'2024-12-27 16:15:32',120319,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.140ms, lost 0%','rta=0.140ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631410,2,23548,0,0,1,5,1,1,'2024-12-27 16:15:32',120647,'2024-12-27 16:15:34',129970,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631411,2,23554,0,0,1,1,0,1,'2024-12-27 16:15:34',132575,'2024-12-27 16:15:35',138733,26989,'','',30,0,0.00923,4.132,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631412,2,23548,0,0,1,5,1,1,'2024-12-27 16:15:35',140909,'2024-12-27 16:15:40',175376,26989,'','',30,0,2.00726,0.14,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631413,2,21397,0,0,1,5,1,1,'2024-12-27 16:15:35',143963,'2024-12-27 16:15:40',175628,26989,'','',30,0,2.00719,0.143,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631414,2,28533,0,0,1,1,1,1,'2024-12-27 16:15:35',147402,'2024-12-27 16:15:40',175871,26989,'','',30,0,2.00775,0.147,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631415,2,21395,0,0,1,5,1,1,'2024-12-27 16:15:35',150083,'2024-12-27 16:15:40',176118,26989,'','',30,0,2.00782,0.15,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631416,2,23553,0,0,1,10,1,1,'2024-12-27 16:15:40',176478,'2024-12-27 16:15:41',281931,26989,'','',30,0,1.105,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631417,2,23554,0,0,1,1,0,1,'2024-12-27 16:15:50',318374,'2024-12-27 16:15:50',328893,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631418,2,23552,0,0,1,1,0,1,'2024-12-27 16:15:50',329263,'2024-12-27 16:15:50',338615,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.127ms, lost 0%','rta=0.127ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631419,2,21395,0,0,1,5,1,1,'2024-12-27 16:15:55',355292,'2024-12-27 16:15:57',364884,26989,'','',30,0,2.009,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631420,2,21396,0,0,1,5,0,1,'2024-12-27 16:15:50',342065,'2024-12-27 16:15:57',365366,26989,'','',30,0,0.0267,0.342,0,'OK - 192.168.77.159: rta 1.043ms, lost 0%','rta=1.043ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631421,2,23553,0,0,1,10,1,1,'2024-12-27 16:15:57',365426,'2024-12-27 16:15:59',374229,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631422,2,23551,0,0,1,1,0,1,'2024-12-27 16:16:05',403009,'2024-12-27 16:16:05',413907,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631423,2,28533,0,0,1,1,1,1,'2024-12-27 16:16:05',414244,'2024-12-27 16:16:07',423354,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631424,2,28279,0,0,1,1,0,1,'2024-12-27 16:16:10',460704,'2024-12-27 16:16:10',468578,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631425,2,23551,0,0,1,1,0,1,'2024-12-27 16:16:10',471195,'2024-12-27 16:16:15',501730,26989,'','',30,0,0.01032,0.471,0,'OK - 192.168.77.29: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631426,2,23553,0,0,1,10,1,1,'2024-12-27 16:16:10',473994,'2024-12-27 16:16:15',502285,26989,'','',30,0,2.00831,0.473,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631427,2,23552,0,0,1,1,0,1,'2024-12-27 16:16:15',502348,'2024-12-27 16:16:15',512746,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.124ms, lost 0%','rta=0.124ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631428,2,21396,0,0,1,5,0,1,'2024-12-27 16:16:20',545177,'2024-12-27 16:16:20',574620,26989,'','',30,0,0.029,0,0,'OK - 192.168.77.159: rta 1.095ms, lost 0%','rta=1.095ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631429,2,23552,0,0,1,1,0,1,'2024-12-27 16:16:20',577728,'2024-12-27 16:16:25',598350,26989,'','',30,0,0.00897,0.577,0,'OK - 192.168.77.8: rta 0.144ms, lost 0%','rta=0.144ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631430,2,23549,0,0,1,10,0,1,'2024-12-27 16:16:20',580812,'2024-12-27 16:16:25',598576,26989,'','',30,0,0.01581,0.58,0,'OK - 84.38.95.222: rta 0.475ms, lost 0%','rta=0.475ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631431,2,23554,0,0,1,1,0,1,'2024-12-27 16:16:25',598629,'2024-12-27 16:16:25',609922,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631432,2,28279,0,0,1,1,0,1,'2024-12-27 16:16:25',612492,'2024-12-27 16:16:30',636593,26989,'','',30,0,0.00625,0.612,0,'OK - 192.168.77.9: rta 0.014ms, lost 0%','rta=0.014ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631433,2,23554,0,0,1,1,0,1,'2024-12-27 16:16:35',666160,'2024-12-27 16:16:40',691562,26989,'','',30,0,0.01018,0.666,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631434,2,21397,0,0,1,5,1,1,'2024-12-27 16:16:40',694585,'2024-12-27 16:16:45',730094,26989,'','',30,0,0.64704,0.694,2,'CRITICAL - 172.20.3.10: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631435,2,23548,0,0,1,5,1,1,'2024-12-27 16:16:40',693918,'2024-12-27 16:16:45',730336,26989,'','',30,0,0.64776,0.693,2,'CRITICAL - 172.20.3.11: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631436,2,28533,0,0,1,1,1,1,'2024-12-27 16:16:40',697470,'2024-12-27 16:16:45',730561,26989,'','',30,0,2.00765,0.697,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631437,2,21395,0,0,1,5,1,1,'2024-12-27 16:16:40',699374,'2024-12-27 16:16:45',730792,26989,'','',30,0,2.00787,0.699,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631438,2,23552,0,0,1,1,0,1,'2024-12-27 16:16:45',730851,'2024-12-27 16:16:45',741228,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.124ms, lost 0%','rta=0.124ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631439,2,23553,0,0,1,10,1,1,'2024-12-27 16:16:45',741564,'2024-12-27 16:16:47',750440,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631440,2,23549,0,0,1,10,0,1,'2024-12-27 16:16:50',782904,'2024-12-27 16:16:50',795466,26989,'','',30,0,0.012,0,0,'OK - 84.38.95.222: rta 0.231ms, lost 0%','rta=0.231ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631441,2,23554,0,0,1,1,0,1,'2024-12-27 16:16:55',821539,'2024-12-27 16:16:55',832573,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631442,2,23551,0,0,1,1,0,1,'2024-12-27 16:16:55',832906,'2024-12-27 16:16:55',842784,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631443,2,21396,0,0,1,5,0,1,'2024-12-27 16:16:57',852006,'2024-12-27 16:17:00',889118,26989,'','',30,0,0.02562,0.851,0,'OK - 192.168.77.159: rta 0.771ms, lost 0%','rta=0.771ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631444,2,28533,0,0,1,1,1,1,'2024-12-27 16:17:05',924076,'2024-12-27 16:17:07',933927,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631445,2,23552,0,0,1,1,0,1,'2024-12-27 16:17:10',958477,'2024-12-27 16:17:10',969119,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.117ms, lost 0%','rta=0.117ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631446,2,21397,0,0,1,5,1,1,'2024-12-27 16:17:15',999800,'2024-12-27 16:17:18',65,26989,'','',30,0,2.011,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631447,2,23553,0,0,1,10,1,1,'2024-12-27 16:17:18',4432,'2024-12-27 16:17:19',0,26989,'','',30,0,0.998,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631448,2,23551,0,0,1,1,0,1,'2024-12-27 16:17:19',4614,'2024-12-27 16:17:20',10842,26989,'','',30,0,0.01036,4.01,0,'OK - 192.168.77.29: rta 0.182ms, lost 0%','rta=0.182ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631449,2,23554,0,0,1,1,0,1,'2024-12-27 16:17:20',169,'2024-12-27 16:17:20',237,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631450,2,23549,0,0,1,10,0,1,'2024-12-27 16:17:20',29,'2024-12-27 16:17:20',19954,26989,'','',30,0,0.01,0,0,'OK - 84.38.95.222: rta 0.201ms, lost 0%','rta=0.201ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631451,2,23553,0,0,1,10,1,1,'2024-12-27 16:17:19',742,'2024-12-27 16:17:25',26855,26989,'','',30,0,2.00828,4.013,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631452,2,28533,0,0,1,1,1,1,'2024-12-27 16:17:25',27062,'2024-12-27 16:17:27',488,26989,'','',30,0,2.01,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631453,2,23552,0,0,1,1,0,1,'2024-12-27 16:17:27',32623,'2024-12-27 16:17:30',100543,26989,'','',30,0,0.00884,2.077,0,'OK - 192.168.77.8: rta 0.126ms, lost 0%','rta=0.126ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631454,2,23549,0,0,1,10,0,1,'2024-12-27 16:17:27',0,'2024-12-27 16:17:30',100756,26989,'','',30,0,0.01284,2.08,0,'OK - 84.38.95.222: rta 0.275ms, lost 0%','rta=0.275ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631455,2,28279,0,0,1,1,0,1,'2024-12-27 16:17:30',103474,'2024-12-27 16:17:35',119214,26989,'','',30,0,0.00727,0.103,0,'OK - 192.168.77.9: rta 0.016ms, lost 0%','rta=0.016ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631456,2,23551,0,0,1,1,0,1,'2024-12-27 16:17:40',133815,'2024-12-27 16:17:40',144302,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631457,2,23554,0,0,1,1,0,1,'2024-12-27 16:17:40',149836,'2024-12-27 16:17:45',160188,26989,'','',30,0,0.00963,0.149,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631458,2,21397,0,0,1,5,1,1,'2024-12-27 16:17:45',160250,'2024-12-27 16:17:47',168347,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631459,2,23553,0,0,1,10,1,1,'2024-12-27 16:17:47',195511,'2024-12-27 16:17:48',168653,26989,'','',30,0,0.973,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631460,2,21397,0,0,1,5,1,1,'2024-12-27 16:17:48',171571,'2024-12-27 16:17:50',193319,26989,'','',30,0,2.00795,3.171,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631461,2,23548,0,0,1,5,1,1,'2024-12-27 16:17:48',174439,'2024-12-27 16:17:50',193565,26989,'','',30,0,2.00904,3.174,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631462,2,28533,0,0,1,1,1,1,'2024-12-27 16:17:48',177714,'2024-12-27 16:17:50',193795,26989,'','',30,0,2.00779,3.177,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631463,2,21395,0,0,1,5,1,1,'2024-12-27 16:17:48',181112,'2024-12-27 16:17:55',222747,26989,'','',30,0,2.00987,3.181,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631464,2,23551,0,0,1,1,0,1,'2024-12-27 16:18:00',253898,'2024-12-27 16:18:00',264614,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631465,2,21396,0,0,1,5,0,1,'2024-12-27 16:18:00',267178,'2024-12-27 16:18:05',282528,26989,'','',30,0,0.02092,0.267,0,'OK - 192.168.77.159: rta 0.745ms, lost 0%','rta=0.745ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631466,2,23552,0,0,1,1,0,1,'2024-12-27 16:18:05',282606,'2024-12-27 16:18:05',293502,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.158ms, lost 0%','rta=0.158ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631467,2,23553,0,0,1,10,1,1,'2024-12-27 16:18:05',293821,'2024-12-27 16:18:07',301772,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631468,2,23548,0,0,1,5,1,1,'2024-12-27 16:18:10',323458,'2024-12-27 16:18:12',349491,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631469,2,23554,0,0,1,1,0,1,'2024-12-27 16:18:12',349766,'2024-12-27 16:18:12',359931,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631470,2,23551,0,0,1,1,0,1,'2024-12-27 16:18:20',393125,'2024-12-27 16:18:25',423702,26989,'','',30,0,0.01052,0.393,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631471,2,23552,0,0,1,1,0,1,'2024-12-27 16:18:25',423764,'2024-12-27 16:18:25',434697,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.125ms, lost 0%','rta=0.125ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631472,2,21395,0,0,1,5,1,1,'2024-12-27 16:18:25',435015,'2024-12-27 16:18:27',444406,26989,'','',30,0,2.009,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631473,2,28533,0,0,1,1,1,1,'2024-12-27 16:18:30',471615,'2024-12-27 16:18:32',480577,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631474,2,23553,0,0,1,10,1,1,'2024-12-27 16:18:27',447243,'2024-12-27 16:18:32',481414,26989,'','',30,0,2.00754,2.447,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631475,2,23548,0,0,1,5,1,1,'2024-12-27 16:18:35',503763,'2024-12-27 16:18:36',574015,26989,'','',30,0,1.07,0,1,'CRITICAL - 172.20.3.11: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631476,2,23552,0,0,1,1,0,1,'2024-12-27 16:18:32',484032,'2024-12-27 16:18:36',574702,26989,'','',30,0,0.00875,2.484,0,'OK - 192.168.77.8: rta 0.122ms, lost 0%','rta=0.122ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631477,2,23549,0,0,1,10,0,1,'2024-12-27 16:18:32',486749,'2024-12-27 16:18:36',574890,26989,'','',30,0,0.01038,2.486,0,'OK - 84.38.95.222: rta 0.200ms, lost 0%','rta=0.200ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631478,2,28279,0,0,1,1,0,1,'2024-12-27 16:18:36',577066,'2024-12-27 16:18:40',629975,26989,'','',30,0,0.00645,1.577,0,'OK - 192.168.77.9: rta 0.014ms, lost 0%','rta=0.014ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631479,2,23551,0,0,1,1,0,1,'2024-12-27 16:18:40',630048,'2024-12-27 16:18:40',641412,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631480,2,23554,0,0,1,1,0,1,'2024-12-27 16:18:45',671574,'2024-12-27 16:18:50',719263,26989,'','',30,0,0.01,0.671,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631481,2,23552,0,0,1,1,0,1,'2024-12-27 16:18:50',719831,'2024-12-27 16:18:50',729891,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.121ms, lost 0%','rta=0.121ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631482,2,23553,0,0,1,10,1,1,'2024-12-27 16:18:50',730199,'2024-12-27 16:18:51',766830,26989,'','',30,0,1.036,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631483,2,21395,0,0,1,5,1,1,'2024-12-27 16:18:55',807963,'2024-12-27 16:18:57',816387,26989,'','',30,0,2.008,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631484,2,21397,0,0,1,5,1,1,'2024-12-27 16:18:51',769651,'2024-12-27 16:18:57',817059,26989,'','',30,0,2.00791,1.769,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631485,2,23548,0,0,1,5,1,1,'2024-12-27 16:18:51',772758,'2024-12-27 16:18:57',817243,26989,'','',30,0,2.00873,1.772,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631486,2,28533,0,0,1,1,1,1,'2024-12-27 16:18:51',776471,'2024-12-27 16:18:57',817404,26989,'','',30,0,2.00801,1.776,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631487,2,21395,0,0,1,5,1,1,'2024-12-27 16:18:57',819828,'2024-12-27 16:19:00',843879,26989,'','',30,0,0.99554,2.819,2,'CRITICAL - 192.168.77.154: Host unreachable @ 192.168.77.9. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631488,2,23551,0,0,1,1,0,1,'2024-12-27 16:19:05',876728,'2024-12-27 16:19:05',887605,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631489,2,21396,0,0,1,5,0,1,'2024-12-27 16:19:05',890364,'2024-12-27 16:19:10',930200,26989,'','',30,0,0.0212,0.89,0,'OK - 192.168.77.159: rta 0.760ms, lost 0%','rta=0.760ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631490,2,28279,0,0,1,1,0,1,'2024-12-27 16:19:10',930548,'2024-12-27 16:19:10',938741,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631491,2,23552,0,0,1,1,0,1,'2024-12-27 16:19:15',964346,'2024-12-27 16:19:15',975302,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.128ms, lost 0%','rta=0.128ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631492,2,21396,0,0,1,5,0,1,'2024-12-27 16:19:21',58,'2024-12-27 16:19:21',15219,26989,'','',30,0,0.028,0,0,'OK - 192.168.77.159: rta 1.059ms, lost 0%','rta=1.059ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631493,2,23553,0,0,1,10,1,1,'2024-12-27 16:19:21',29,'2024-12-27 16:19:23',288,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631494,2,23554,0,0,1,1,0,1,'2024-12-27 16:19:25',4,'2024-12-27 16:19:25',5,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.147ms, lost 0%','rta=0.147ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631495,2,23551,0,0,1,1,0,1,'2024-12-27 16:19:25',25848,'2024-12-27 16:19:30',3821,26989,'','',30,0,0.00908,0.062,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631496,2,23553,0,0,1,10,1,1,'2024-12-27 16:19:32',0,'2024-12-27 16:19:35',110182,26989,'','',30,0,2.00884,0.084,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631497,2,23552,0,0,1,1,0,1,'2024-12-27 16:19:36',113244,'2024-12-27 16:19:40',141692,26989,'','',30,0,0.01084,0.113,0,'OK - 192.168.77.8: rta 0.158ms, lost 0%','rta=0.158ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631498,2,23549,0,0,1,10,0,1,'2024-12-27 16:19:36',115375,'2024-12-27 16:19:40',141934,26989,'','',30,0,0.0111,0.115,0,'OK - 84.38.95.222: rta 0.204ms, lost 0%','rta=0.204ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631499,2,28279,0,0,1,1,0,1,'2024-12-27 16:19:40',144296,'2024-12-27 16:19:45',180304,26989,'','',30,0,0.00674,0.144,0,'OK - 192.168.77.9: rta 0.016ms, lost 0%','rta=0.016ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631500,2,23554,0,0,1,1,0,1,'2024-12-27 16:19:50',213432,'2024-12-27 16:19:55',244827,26989,'','',30,0,0.01011,0.213,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631501,2,23551,0,0,1,1,0,1,'2024-12-27 16:19:55',245180,'2024-12-27 16:19:55',256464,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.29: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631502,2,28533,0,0,1,1,1,1,'2024-12-27 16:19:57',273692,'2024-12-27 16:20:00',302023,26989,'','',30,0,0.06195,0.273,2,'CRITICAL - 172.50.1.3: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631503,2,21397,0,0,1,5,1,1,'2024-12-27 16:19:57',267285,'2024-12-27 16:20:00',302550,26989,'','',30,0,2.00781,0.267,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631504,2,23548,0,0,1,5,1,1,'2024-12-27 16:19:57',270055,'2024-12-27 16:20:00',302784,26989,'','',30,0,2.00765,0.269,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631505,2,21395,0,0,1,5,1,1,'2024-12-27 16:20:00',305724,'2024-12-27 16:20:05',338354,26989,'','',30,0,2.00774,0.305,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631506,2,23552,0,0,1,1,0,1,'2024-12-27 16:20:10',369504,'2024-12-27 16:20:10',380574,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.162ms, lost 0%','rta=0.162ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631507,2,21396,0,0,1,5,0,1,'2024-12-27 16:20:10',383189,'2024-12-27 16:20:15',407432,26989,'','',30,0,0.02733,0.383,0,'OK - 192.168.77.159: rta 1.068ms, lost 0%','rta=1.068ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631508,2,21397,0,0,1,5,1,1,'2024-12-27 16:20:15',407494,'2024-12-27 16:20:17',417095,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631509,2,23553,0,0,1,10,1,1,'2024-12-27 16:20:17',417428,'2024-12-27 16:20:18',416452,26989,'','',30,0,0.999,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631510,2,23554,0,0,1,1,0,1,'2024-12-27 16:20:20',450052,'2024-12-27 16:20:20',460631,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631511,2,23549,0,0,1,10,0,1,'2024-12-27 16:20:20',460971,'2024-12-27 16:20:20',472829,26989,'','',30,0,0.011,0,0,'OK - 84.38.95.222: rta 0.250ms, lost 0%','rta=0.250ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631512,2,28533,0,0,1,1,1,1,'2024-12-27 16:20:25',503869,'2024-12-27 16:20:27',512425,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631513,2,23551,0,0,1,1,0,1,'2024-12-27 16:20:30',543001,'2024-12-27 16:20:30',554231,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631514,2,23551,0,0,1,1,0,1,'2024-12-27 16:20:30',556863,'2024-12-27 16:20:35',584299,26989,'','',30,0,0.00885,0.556,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631515,2,28279,0,0,1,1,0,1,'2024-12-27 16:20:35',584362,'2024-12-27 16:20:35',592434,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631516,2,23552,0,0,1,1,0,1,'2024-12-27 16:20:35',592737,'2024-12-27 16:20:35',601952,26989,'','',30,0,0.008,0,0,'OK - 192.168.77.8: rta 0.115ms, lost 0%','rta=0.115ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631517,2,23553,0,0,1,10,1,1,'2024-12-27 16:20:35',604413,'2024-12-27 16:20:40',702246,26989,'','',30,0,0.07224,0.604,2,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631518,2,23552,0,0,1,1,0,1,'2024-12-27 16:20:40',707904,'2024-12-27 16:20:45',743393,26989,'','',30,0,0.01005,0.707,0,'OK - 192.168.77.8: rta 0.140ms, lost 0%','rta=0.140ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631519,2,23549,0,0,1,10,0,1,'2024-12-27 16:20:40',710808,'2024-12-27 16:20:45',743645,26989,'','',30,0,0.01095,0.71,0,'OK - 84.38.95.222: rta 0.217ms, lost 0%','rta=0.217ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631520,2,21397,0,0,1,5,1,1,'2024-12-27 16:20:45',743964,'2024-12-27 16:20:47',752729,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631521,2,23554,0,0,1,1,0,1,'2024-12-27 16:20:47',753292,'2024-12-27 16:20:47',763283,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631522,2,28279,0,0,1,1,0,1,'2024-12-27 16:20:47',765927,'2024-12-27 16:20:50',797716,26989,'','',30,0,0.00607,2.765,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631523,2,28533,0,0,1,1,1,1,'2024-12-27 16:20:55',822107,'2024-12-27 16:20:57',831357,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631524,2,23554,0,0,1,1,0,1,'2024-12-27 16:20:57',833914,'2024-12-27 16:21:00',870042,26989,'','',30,0,0.01054,2.833,0,'OK - 192.168.77.208: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631525,2,23551,0,0,1,1,0,1,'2024-12-27 16:21:00',870765,'2024-12-27 16:21:00',881461,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631526,2,28533,0,0,1,1,1,1,'2024-12-27 16:21:00',883906,'2024-12-27 16:21:05',913448,26989,'','',30,0,2.00625,0.883,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631527,2,21397,0,0,1,5,1,1,'2024-12-27 16:21:00',886987,'2024-12-27 16:21:05',913682,26989,'','',30,0,2.00716,0.886,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631528,2,23548,0,0,1,5,1,1,'2024-12-27 16:21:00',890435,'2024-12-27 16:21:05',913930,26989,'','',30,0,2.00671,0.89,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631529,2,23552,0,0,1,1,0,1,'2024-12-27 16:21:05',913997,'2024-12-27 16:21:05',924519,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.147ms, lost 0%','rta=0.147ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631530,2,23553,0,0,1,10,1,1,'2024-12-27 16:21:05',924873,'2024-12-27 16:21:07',933311,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631531,2,21395,0,0,1,5,1,1,'2024-12-27 16:21:07',936295,'2024-12-27 16:21:10',964454,26989,'','',30,0,2.00749,2.936,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631532,2,21396,0,0,1,5,0,1,'2024-12-27 16:21:15',989391,'2024-12-27 16:21:20',971,26989,'','',30,0,0.02057,0.989,0,'OK - 192.168.77.159: rta 0.707ms, lost 0%','rta=0.707ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631533,2,23552,0,0,1,1,0,1,'2024-12-27 16:21:25',2105,'2024-12-27 16:21:25',21702,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.8: rta 0.137ms, lost 0%','rta=0.137ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631534,2,21395,0,0,1,5,1,1,'2024-12-27 16:21:25',21888,'2024-12-27 16:21:27',48,26989,'','',30,0,2.008,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631535,2,23551,0,0,1,1,0,1,'2024-12-27 16:21:27',3145,'2024-12-27 16:21:27',458,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631536,2,28533,0,0,1,1,1,1,'2024-12-27 16:21:30',0,'2024-12-27 16:21:32',122142,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631537,2,23548,0,0,1,5,1,1,'2024-12-27 16:21:32',122680,'2024-12-27 16:21:34',130947,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631538,2,23551,0,0,1,1,0,1,'2024-12-27 16:21:35',137537,'2024-12-27 16:21:40',164692,26989,'','',30,0,0.00931,0.137,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631539,2,23553,0,0,1,10,1,1,'2024-12-27 16:21:40',165037,'2024-12-27 16:21:41',268496,26989,'','',30,0,1.103,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631540,2,23553,0,0,1,10,1,1,'2024-12-27 16:21:41',271298,'2024-12-27 16:21:45',285105,26989,'','',30,0,2.00789,1.271,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631541,2,23552,0,0,1,1,0,1,'2024-12-27 16:21:45',287869,'2024-12-27 16:21:50',340115,26989,'','',30,0,0.00997,0.287,0,'OK - 192.168.77.8: rta 0.127ms, lost 0%','rta=0.127ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631542,2,23549,0,0,1,10,0,1,'2024-12-27 16:21:45',291419,'2024-12-27 16:21:50',340331,26989,'','',30,0,0.01309,0.291,0,'OK - 84.38.95.222: rta 0.326ms, lost 0%','rta=0.326ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631543,2,23554,0,0,1,1,0,1,'2024-12-27 16:21:50',340387,'2024-12-27 16:21:50',351120,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.156ms, lost 0%','rta=0.156ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631544,2,21395,0,0,1,5,1,1,'2024-12-27 16:21:50',352327,'2024-12-27 16:21:51',326574,26989,'','',30,0,0.974,0,1,'CRITICAL - 192.168.77.154: Host unreachable @ 192.168.77.9. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631545,2,28279,0,0,1,1,0,1,'2024-12-27 16:21:51',329365,'2024-12-27 16:21:55',339481,26989,'','',30,0,0.00717,1.329,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631546,2,23554,0,0,1,1,0,1,'2024-12-27 16:22:00',353708,'2024-12-27 16:22:05',379453,26989,'','',30,0,0.0096,0.353,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631547,2,23551,0,0,1,1,0,1,'2024-12-27 16:22:05',379518,'2024-12-27 16:22:05',390077,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631548,2,28533,0,0,1,1,1,1,'2024-12-27 16:22:05',390431,'2024-12-27 16:22:07',398848,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631549,2,28533,0,0,1,1,1,1,'2024-12-27 16:22:07',401480,'2024-12-27 16:22:10',438489,26989,'','',30,0,0.99566,2.401,2,'CRITICAL - 172.50.1.3: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631550,2,28279,0,0,1,1,0,1,'2024-12-27 16:22:10',438846,'2024-12-27 16:22:10',447030,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631551,2,21397,0,0,1,5,1,1,'2024-12-27 16:22:07',402619,'2024-12-27 16:22:10',447593,26989,'','',30,0,2.00852,2.402,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631552,2,23548,0,0,1,5,1,1,'2024-12-27 16:22:07',405797,'2024-12-27 16:22:10',447853,26989,'','',30,0,2.00877,2.405,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631553,2,21395,0,0,1,5,1,1,'2024-12-27 16:22:10',450221,'2024-12-27 16:22:15',488000,26989,'','',30,0,2.00711,0.45,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631554,2,23552,0,0,1,1,0,1,'2024-12-27 16:22:15',488063,'2024-12-27 16:22:15',498278,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.116ms, lost 0%','rta=0.116ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631555,2,21396,0,0,1,5,0,1,'2024-12-27 16:22:20',526078,'2024-12-27 16:22:20',548387,26989,'','',30,0,0.022,0,0,'OK - 192.168.77.159: rta 0.757ms, lost 0%','rta=0.757ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631556,2,23553,0,0,1,10,1,1,'2024-12-27 16:22:20',548713,'2024-12-27 16:22:22',556639,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631557,2,23554,0,0,1,1,0,1,'2024-12-27 16:22:25',576094,'2024-12-27 16:22:25',586072,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631558,2,21396,0,0,1,5,0,1,'2024-12-27 16:22:22',559503,'2024-12-27 16:22:25',586572,26989,'','',30,0,0.02799,2.559,0,'OK - 192.168.77.159: rta 1.102ms, lost 0%','rta=1.102ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631559,2,23551,0,0,1,1,0,1,'2024-12-27 16:22:40',668265,'2024-12-27 16:22:45',695972,26989,'','',30,0,0.00992,0.668,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631560,2,23552,0,0,1,1,0,1,'2024-12-27 16:22:45',696051,'2024-12-27 16:22:45',706476,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.115ms, lost 0%','rta=0.115ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631561,2,23553,0,0,1,10,1,1,'2024-12-27 16:22:45',706848,'2024-12-27 16:22:47',714880,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631562,2,23553,0,0,1,10,1,1,'2024-12-27 16:22:47',717566,'2024-12-27 16:22:50',752484,26989,'','',30,0,0.99561,2.717,2,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631563,2,23549,0,0,1,10,0,1,'2024-12-27 16:22:50',752816,'2024-12-27 16:22:50',765535,26989,'','',30,0,0.012,0,0,'OK - 84.38.95.222: rta 0.219ms, lost 0%','rta=0.219ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631564,2,23552,0,0,1,1,0,1,'2024-12-27 16:22:50',768051,'2024-12-27 16:22:55',795277,26989,'','',30,0,0.00927,0.768,0,'OK - 192.168.77.8: rta 0.157ms, lost 0%','rta=0.157ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631565,2,23549,0,0,1,10,0,1,'2024-12-27 16:22:50',771220,'2024-12-27 16:22:55',795497,26989,'','',30,0,0.01081,0.771,0,'OK - 84.38.95.222: rta 0.204ms, lost 0%','rta=0.204ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631566,2,23554,0,0,1,1,0,1,'2024-12-27 16:22:55',795560,'2024-12-27 16:22:55',806437,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.154ms, lost 0%','rta=0.154ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631567,2,28279,0,0,1,1,0,1,'2024-12-27 16:22:55',809473,'2024-12-27 16:23:00',848685,26989,'','',30,0,0.00717,0.809,0,'OK - 192.168.77.9: rta 0.014ms, lost 0%','rta=0.014ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631568,2,23551,0,0,1,1,0,1,'2024-12-27 16:23:00',849276,'2024-12-27 16:23:00',860879,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631569,2,28533,0,0,1,1,1,1,'2024-12-27 16:23:05',902529,'2024-12-27 16:23:07',912011,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631570,2,23554,0,0,1,1,0,1,'2024-12-27 16:23:07',914541,'2024-12-27 16:23:10',942768,26989,'','',30,0,0.00988,2.914,0,'OK - 192.168.77.208: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631571,2,23552,0,0,1,1,0,1,'2024-12-27 16:23:10',942849,'2024-12-27 16:23:10',953617,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.128ms, lost 0%','rta=0.128ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631572,2,28533,0,0,1,1,1,1,'2024-12-27 16:23:10',956071,'2024-12-27 16:23:15',982231,26989,'','',30,0,2.00864,0.956,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631573,2,21397,0,0,1,5,1,1,'2024-12-27 16:23:10',958955,'2024-12-27 16:23:15',982461,26989,'','',30,0,2.00889,0.958,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631574,2,23548,0,0,1,5,1,1,'2024-12-27 16:23:10',960014,'2024-12-27 16:23:15',982692,26989,'','',30,0,2.01224,0.959,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631575,2,23553,0,0,1,10,1,1,'2024-12-27 16:23:15',982999,'2024-12-27 16:23:17',992758,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631576,2,21395,0,0,1,5,1,1,'2024-12-27 16:23:17',995203,'2024-12-27 16:23:25',8737,26989,'','',30,0,2.00859,2.995,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631577,2,23549,0,0,1,10,0,1,'2024-12-27 16:23:25',8778,'2024-12-27 16:23:25',27,26989,'','',30,0,0.012,0,0,'OK - 84.38.95.222: rta 0.231ms, lost 0%','rta=0.231ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631578,2,21396,0,0,1,5,0,1,'2024-12-27 16:23:25',30,'2024-12-27 16:23:30',5,26989,'','',30,0,0.02166,0.036,0,'OK - 192.168.77.159: rta 0.784ms, lost 0%','rta=0.784ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631579,2,23551,0,0,1,1,0,1,'2024-12-27 16:23:35',30946,'2024-12-27 16:23:35',0,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.148ms, lost 0%','rta=0.148ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631580,2,28279,0,0,1,1,0,1,'2024-12-27 16:23:35',0,'2024-12-27 16:23:35',0,26989,'','',30,0,0.007,0,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631581,2,23552,0,0,1,1,0,1,'2024-12-27 16:23:35',0,'2024-12-27 16:23:35',102214,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.117ms, lost 0%','rta=0.117ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631582,2,21397,0,0,1,5,1,1,'2024-12-27 16:23:45',133702,'2024-12-27 16:23:47',142917,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631583,2,23553,0,0,1,10,1,1,'2024-12-27 16:23:47',143251,'2024-12-27 16:23:48',142925,26989,'','',30,0,1,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631584,2,23554,0,0,1,1,0,1,'2024-12-27 16:23:48',143477,'2024-12-27 16:23:48',153418,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.153ms, lost 0%','rta=0.153ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631585,2,23551,0,0,1,1,0,1,'2024-12-27 16:23:48',155929,'2024-12-27 16:23:50',168119,26989,'','',30,0,0.01141,3.155,0,'OK - 192.168.77.29: rta 0.212ms, lost 0%','rta=0.212ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631586,2,23553,0,0,1,10,1,1,'2024-12-27 16:23:50',170405,'2024-12-27 16:23:55',198493,26989,'','',30,0,2.00757,0.17,2,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631587,2,28533,0,0,1,1,1,1,'2024-12-27 16:23:55',198566,'2024-12-27 16:23:57',207465,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631588,2,23552,0,0,1,1,0,1,'2024-12-27 16:23:57',210039,'2024-12-27 16:24:00',253486,26989,'','',30,0,0.00936,2.21,0,'OK - 192.168.77.8: rta 0.144ms, lost 0%','rta=0.144ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631589,2,23549,0,0,1,10,0,1,'2024-12-27 16:23:57',213166,'2024-12-27 16:24:00',253712,26989,'','',30,0,0.012,2.213,0,'OK - 84.38.95.222: rta 0.283ms, lost 0%','rta=0.283ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631590,2,28279,0,0,1,1,0,1,'2024-12-27 16:24:00',257032,'2024-12-27 16:24:05',282076,26989,'','',30,0,0.00647,0.257,0,'OK - 192.168.77.9: rta 0.014ms, lost 0%','rta=0.014ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631591,2,23551,0,0,1,1,0,1,'2024-12-27 16:24:05',282654,'2024-12-27 16:24:05',293040,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.29: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631592,2,23548,0,0,1,5,1,1,'2024-12-27 16:24:10',317116,'2024-12-27 16:24:12',326844,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631593,2,23554,0,0,1,1,0,1,'2024-12-27 16:24:12',327160,'2024-12-27 16:24:12',337185,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.208: rta 0.152ms, lost 0%','rta=0.152ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631594,2,23554,0,0,1,1,0,1,'2024-12-27 16:24:12',339687,'2024-12-27 16:24:15',363572,26989,'','',30,0,0.01108,2.339,0,'OK - 192.168.77.208: rta 0.255ms, lost 0%','rta=0.255ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631595,2,28533,0,0,1,1,1,1,'2024-12-27 16:24:15',365959,'2024-12-27 16:24:20',399537,26989,'','',30,0,2.00825,0.365,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631596,2,21397,0,0,1,5,1,1,'2024-12-27 16:24:15',369244,'2024-12-27 16:24:20',399805,26989,'','',30,0,2.0079,0.369,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631597,2,23548,0,0,1,5,1,1,'2024-12-27 16:24:15',372291,'2024-12-27 16:24:20',400029,26989,'','',30,0,2.0094,0.372,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631598,2,23552,0,0,1,1,0,1,'2024-12-27 16:24:25',432523,'2024-12-27 16:24:25',443585,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.131ms, lost 0%','rta=0.131ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631599,2,21395,0,0,1,5,1,1,'2024-12-27 16:24:25',443927,'2024-12-27 16:24:27',452513,26989,'','',30,0,2.008,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631600,2,23551,0,0,1,1,0,1,'2024-12-27 16:24:27',452841,'2024-12-27 16:24:27',463034,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.29: rta 0.149ms, lost 0%','rta=0.149ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631601,2,21395,0,0,1,5,1,1,'2024-12-27 16:24:27',465639,'2024-12-27 16:24:30',500656,26989,'','',30,0,0.98495,2.465,2,'CRITICAL - 192.168.77.154: Host unreachable @ 192.168.77.9. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631602,2,23548,0,0,1,5,1,1,'2024-12-27 16:24:35',526635,'2024-12-27 16:24:36',591227,26989,'','',30,0,1.064,0,1,'CRITICAL - 172.20.3.11: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631603,2,21396,0,0,1,5,0,1,'2024-12-27 16:24:30',503279,'2024-12-27 16:24:36',592017,26989,'','',30,0,0.03062,0.503,0,'OK - 192.168.77.159: rta 1.166ms, lost 0%','rta=1.166ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631604,2,28533,0,0,1,1,1,1,'2024-12-27 16:24:36',592079,'2024-12-27 16:24:38',602375,26989,'','',30,0,2.009,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631605,2,23553,0,0,1,10,1,1,'2024-12-27 16:24:40',639264,'2024-12-27 16:24:41',727140,26989,'','',30,0,1.087,0,1,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631606,2,23554,0,0,1,1,0,1,'2024-12-27 16:24:50',792147,'2024-12-27 16:24:50',803331,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631607,2,23552,0,0,1,1,0,1,'2024-12-27 16:24:50',803731,'2024-12-27 16:24:50',813957,26989,'','',30,0,0.009,0,0,'OK - 192.168.77.8: rta 0.120ms, lost 0%','rta=0.120ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631608,2,21395,0,0,1,5,1,1,'2024-12-27 16:24:55',842086,'2024-12-27 16:24:57',852108,26989,'','',30,0,2.009,0,1,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631609,2,23551,0,0,1,1,0,1,'2024-12-27 16:24:50',817234,'2024-12-27 16:24:57',852601,26989,'','',30,0,0.0089,0.817,0,'OK - 192.168.77.29: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631610,2,23553,0,0,1,10,1,1,'2024-12-27 16:24:57',852662,'2024-12-27 16:24:59',860430,26989,'','',30,0,2.007,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631611,2,23553,0,0,1,10,1,1,'2024-12-27 16:24:59',863182,'2024-12-27 16:25:05',919247,26989,'','',30,0,0.99631,4.863,2,'CRITICAL - 172.21.1.2: Host unreachable @ 172.50.1.2. rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631612,2,23552,0,0,1,1,0,1,'2024-12-27 16:25:00',887534,'2024-12-27 16:25:05',919488,26989,'','',30,0,0.00921,0.887,0,'OK - 192.168.77.8: rta 0.137ms, lost 0%','rta=0.137ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631613,2,23549,0,0,1,10,0,1,'2024-12-27 16:25:00',888316,'2024-12-27 16:25:05',919701,26989,'','',30,0,0.01657,0.888,0,'OK - 84.38.95.222: rta 0.501ms, lost 0%','rta=0.501ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631614,2,28533,0,0,1,1,1,1,'2024-12-27 16:25:05',920005,'2024-12-27 16:25:07',928586,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631615,2,28279,0,0,1,1,0,1,'2024-12-27 16:25:07',931090,'2024-12-27 16:25:10',959901,26989,'','',30,0,0.0062,2.931,0,'OK - 192.168.77.9: rta 0.015ms, lost 0%','rta=0.015ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631616,2,23551,0,0,1,1,0,1,'2024-12-27 16:25:15',981989,'2024-12-27 16:25:15',993522,26989,'','',30,0,0.011,0,0,'OK - 192.168.77.29: rta 0.151ms, lost 0%','rta=0.151ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631617,2,23554,0,0,1,1,0,1,'2024-12-27 16:25:15',996551,'2024-12-27 16:25:20',92,26989,'','',30,0,0.00973,0.996,0,'OK - 192.168.77.208: rta 0.150ms, lost 0%','rta=0.150ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631618,2,21396,0,0,1,5,0,1,'2024-12-27 16:25:20',5991,'2024-12-27 16:25:20',28,26989,'','',30,0,0.021,0,0,'OK - 192.168.77.159: rta 0.709ms, lost 0%','rta=0.709ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631619,2,23553,0,0,1,10,1,1,'2024-12-27 16:25:25',42,'2024-12-27 16:25:27',3160,26989,'','',30,0,2.008,0,1,'CRITICAL - 172.21.1.2: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631620,2,28533,0,0,1,1,1,1,'2024-12-27 16:25:20',16226,'2024-12-27 16:25:27',29243,26989,'','',30,0,2.00832,0.037,2,'CRITICAL - 172.50.1.3: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631621,2,21397,0,0,1,5,1,1,'2024-12-27 16:25:20',3,'2024-12-27 16:25:27',29408,26989,'','',30,0,2.01073,0.038,2,'CRITICAL - 172.20.3.10: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631622,2,23548,0,0,1,5,1,1,'2024-12-27 16:25:20',32,'2024-12-27 16:25:27',461,26989,'','',30,0,2.00882,0.04,2,'CRITICAL - 172.20.3.11: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631623,2,21395,0,0,1,5,1,1,'2024-12-27 16:25:30',0,'2024-12-27 16:25:35',101393,26989,'','',30,0,2.00777,0.08,2,'CRITICAL - 192.168.77.154: rta nan, lost 100%','rta=0.000ms;10000.000;50000.000;0; pl=100%;85;100;;',''),(276631624,2,21396,0,0,1,5,0,1,'2024-12-27 16:25:36',105176,'2024-12-27 16:25:40',135629,26989,'','',30,0,0.03057,0.105,0,'OK - 192.168.77.159: rta 1.163ms, lost 0%','rta=1.163ms;10000.000;50000.000;0; pl=0%;85;100;;',''),(276631625,2,23552,0,0,1,1,0,1,'2024-12-27 16:25:45',149862,'2024-12-27 16:25:45',160387,26989,'','',30,0,0.01,0,0,'OK - 192.168.77.8: rta 0.118ms, lost 0%','rta=0.118ms;10000.000;50000.000;0; pl=0%;85;100;;',