<?php
    error_reporting(0);
    include_once("config.php");
    include_once("snmp_get_functions.php");
    
    $ip=         $_REQUEST["ip"];
    $community=  $_REQUEST["snmp"];
    if($community==="" || !isset($community)) $community=$default_community;
    $refresh=    $_REQUEST["refresh"];
    if($refresh==="" || !isset($refresh)) $refresh=$auto_refresh;
?>

<?php
/**
 * @copyright       Copyright (C) 2017 MDM-IT. All rights reserved.
 * @license         see LICENSE.txt
 * 
 * Run: http://<server>/snmp_mdmit/index.php?ip=<ip>&snmp=<snmp ro community>
 */
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<HEAD>
    <TITLE>MDM-IT SNMP</TITLE>
    <META http-equiv="content-type" content="text/html; charset=utf-8"/>
    <META HTTP-EQUIV="Cache-Control" content="no-cache"/>
    <META HTTP-EQUIV="Pragma" CONTENT="no-cache"/>
    <!--<META HTTP-EQUIV="Refresh" CONTENT="60" />-->
    
    <link type="text/css" href="js/jquery/css/redmond/jquery-ui.custom.css" rel="stylesheet" />
    <script type="text/javascript" src="js/jquery/jquery.js"></script>
    <script type="text/javascript" src="js/jquery/jquery-ui.js"></script>
    <script type="text/javascript" src="js/tabs/tabpane.js"></script>
    <link type="text/css" rel="stylesheet" href="js/tabs/tab.winclassic.css" />    
    <link rel="stylesheet" href="js/Zebra/css/mdmit/zebra_dialog.css" type="text/css"/>
    <script type="text/javascript" src="js/Zebra/zebra_dialog.js"></script>
    <script type="text/javascript" src="lib/mdmit_dialogs.js"></script>
    <link rel="stylesheet" href="snmp_get_window.css" type="text/css"/>    
</HEAD>

<body onload="set_onLoad();">
<div id="form_top">
  <table width="100%" border="0">
    <tr>
        <td width="80%">
            <form>
                <label for="ip_id" id="ip_label_id">Host IP: </label><input  name="ip_id"  id="ip_id"  value="127.0.0.1"  type="text" tabindex="1"/>
                <label for="sparams_id" id="sparams_label_id">SNMP Community: </label><input  name="sparams_id" id="sparams_id" value="<?php echo $community; ?>" type="text" tabindex="2"/>
                <label for="refresh_id" id="refresh_label_id">Auto Refresh [s]: </label><input  name="refresh_id" id="refresh_id" value="<?php echo $refresh; ?>" type="text" tabindex="3"/>
                    <input  name="start_id" id="start_id" value="Check" type="button" tabindex="4" onclick="snmp_check_all();"/>
                    <input  name="stop_id"  id="stop_id"  value="Stop"  type="button" tabindex="5" onclick="stopAuto();"/>
            </form>           
        </td>
        <td widht="15%" align="left" style="font-family: Arial,Verdana; font-size: 14px; color:#8c8c8c; font-weight: bold;">
            <div id="device_name"></div>
        </td>
        <td align="right" style="font-family: Verdana; font-size: 8px; color:#a6a6a6;">
            <div id="state_id"></div>
        </td>
    </tr>      
  </table>
</div>

<div id="snmp_interfaces_h">
    <table width="100%" class="table_header_snmp">
    <tr>
      <td width="20%">
          IP: <?php echo $ip; ?>
      </td>
      <td width="50%">
          Model:
      </td>
      <td width="30%">
          Location:
      </td>
    </tr>
    <tr>
      <td width="20%">
          Name:
      </td>
      <td width="30%">
          UpTime:
      </td>
    </tr>
    </table>
</div>
<table width="100%" style="border-style: solid; border-width: 0px" bordercolor="#eeeeee" bgcolor="#fff">
    <tr>
      <td></td>
    </tr>
</table>
    
<div class="tab-pane" id="tab-pane-1">
    <div class="tab-page"><h4 class="tab">Interfaces</h4>
        <div id="snmp_interfaces"></div>
    </div>
    <div class="tab-page"><h4 class="tab">Vlans</h4>
        <div id="snmp_vlans"></div>
    </div>
    <div class="tab-page"><h4 class="tab">Custom View</h4>
        <div id="snmp_custom"></div>
    </div>
</div>    

<script type="text/javascript">
var updateInterval=30000;
var ww_s_s,ww_s_s2,ww_s_s3;
var ajax_timeout=<?php echo $ajax_timeout; ?>;

function set_onLoad()
{
    $("#ip_id").val("<?php echo $ip; ?>");
    
    $("#sparams_id").val("<?php echo $community; ?>");
    if($("#sparams_id").val() === "") $("#sparams_id").val("public");
    
    $("#refresh_id").val("<?php echo $refresh; ?>");
    if(parseInt($("#refresh_id").val()) <= 0 || $("#refresh_id").val() === "") $("#refresh_id").val(30);
    
    if($("#ip_id").val() !== "")
    {
        snmp_check_all();
    }
}
function check_ping()
{
    var ip=$("#ip_id").val();
    var sd='0';
    $.ajax({
        url:         "check_ping_ringo.php",
        async:       false,
        contentType: "text",
        cache:       false,
        type:        "GET",
        data: ({ip  : ip}),
        success: function(data){
                sd=data;
        }
    });
    if(sd==='0') return true;
    else
        {
            $("#device_name").empty();
            $("#device_name").append("No response from host");
            $("#snmp_interfaces_h").empty();
            $("#snmp_interfaces").empty();
            $("#snmp_custom").empty();
            $("#snmp_vlans").empty();
            return false;
        }
}
function snmp_check_all()
{   
    if(check_ping())
    {    
        try {gen_snmp_header();} catch(e){;}
        try {get_vendor();} catch(e){;}
        try {
            w_progress('Check interfaces...');
            p_get_interfaces();
        } catch(e) {;}
        try {
            p_get_vlans();
        } catch(e) {;}
        try {
            p_get_custom_snmp();
        } catch(e) {;}
    }
    idInterval=setInterval(p_get_snmp,updateInterval);
}
function gen_snmp_header()
{
    var ip=     $("#ip_id").val();
    var snmp_c= $("#sparams_id").val();
    $.ajax({
        url:         "gen_snmp_header.php",
        async:       true,
        contentType: "text",
        cache:       false,
        type:        "GET",
        timeout:     ajax_timeout,  //ms
        data: ({ip  : ip,
                snmp: snmp_c
        }),
        success: function(data){
            $("#snmp_interfaces_h").empty();
            $("#snmp_interfaces_h").append(data);            
        }
    });
}
function p_get_snmp()
{
    if(check_ping())
    {
        try {p_get_interfaces(1);}  catch(e){;}
        try {p_get_custom_snmp();} catch(e){;}
        try {p_get_vlans();}       catch(e){;}
    }
}
function p_get_interfaces(tt)
{
    var ip=       $("#ip_id").val();
    var snmp_c=   $("#sparams_id").val();
    var a_refresh=parseInt($("#refresh_id").val());

    $("#state_id").empty();
    $("#state_id").append('Checking interfaces');
    $.ajax({
        url:         "snmp_interfaces_ringo.php",
        async:       true,
        contentType: "text",
        cache:       false,
        type:        "GET",
        timeout:     ajax_timeout,  //ms
        data: ({ip  : ip,
                snmp: snmp_c,
                auto_refresh: a_refresh,
                thr: tt
        }),
        success: function(data){
            $("#snmp_interfaces").empty();
            $("#snmp_interfaces").append(data);
            try { ww_s_s.close();} catch(e){;}
            $("#state_id").empty();
            $("#state_id").append('Waiting');
        }    
    });
}
function p_get_custom_snmp()
{
    var ip=     $("#ip_id").val();
    var snmp_c= $("#sparams_id").val();

    $("#state_id").empty();
    $("#state_id").append('Checking custom query');
    $.ajax({
        url:         "get_snmp_custom_ringo.php",
        async:       true,
        contentType: "text",
        cache:       false,
        type:        "GET",
        timeout:     ajax_timeout,  //ms
        data: ({ip  : ip,
                snmp: snmp_c
        }),
        success: function(data){
            $("#snmp_custom").empty();
            $("#snmp_custom").append(data);
            $("#state_id").empty();
            $("#state_id").append('Waiting');
        }    
    });
}
function p_get_vlans()
{
    var ip=     $("#ip_id").val();
    var snmp_c= $("#sparams_id").val();
    $("#state_id").empty();
    $("#state_id").append('Checking vlans');
    $.ajax({
        url:         "snmp_vlans_ringo.php",
        async:       true,
        contentType: "text",
        cache:       false,
        type:        "GET",
        timeout:     ajax_timeout,  //ms
        data: ({ip  : ip,
                snmp: snmp_c
        }),
        success: function(data){
            $("#snmp_vlans").empty();
            $("#snmp_vlans").append(data);
            $("#state_id").empty();
            $("#state_id").append('Waiting');
        }
    });
}

function get_vendor(ip,snmp_c)
{
    var ip=     $("#ip_id").val();
    var snmp_c= $("#sparams_id").val();

    $.ajax({
        url:         "get_vendor_header.php",
        async:       true,
        contentType: "text",
        cache:       false,
        type:        "GET",
        timeout:     ajax_timeout,  //ms
        data: ({ip  : ip,
                snmp: snmp_c
        }),
        success: function(h_data){
                    $("#device_name").empty();
                    $("#device_name").append(h_data);
        }
    });
}

function stopAuto()
{
    clearInterval(idInterval);
    $("#state_id").empty();
    $("#state_id").append('Stop checking');
    try {ww_s_s.close();} catch(e){;}
}

function w_progress(s_title)
{
    ww_s_s = new $.Zebra_Dialog(s_title, {
                'type':    false,
                'title':   false,
                'buttons': false,
                'center_buttons': true,
                'modal':   false,
                'width':   150,
                'show_close_button': false,
                'custom_class': 'wait_m_class',
                'position': ['center', 'center'],
                'auto_close': false
            });
}

</script>
    
</body>
</html>    
