<?php
    function get_device_vendor($ip,$community)
    {
        include("config_device_id.php");
        list($d)=explode('.',str_replace('.1.3.6.1.4.1.','',get_snmp($ip,$community,'1.3.6.1.2.1.1.2.0', $snmp_timeout, $snmp_retry)));
        $device_idd=$device_id[$d];
        if(!isset($device_idd) || $device_idd === null || $device_idd === "") $device_idd=0;
        return $device_idd;
    }
        
    //function get_count_interfaces($ip,$community,$device)
    //{
    //    return count(get_snmp_walk($ip,$community,$device['ifIndex']));
    //}
    
    function get_if_vlans($ip,$community,$oid,$device)
    {
        if(!isset($oid) || $oid === null || $oid === '') return "";
        return get_snmp_walk($ip,$community,$oid,$device);
    }
    function get_count_vlans($ip,$community,$oid,$device)
    {
        if(!isset($oid) || $oid === null || $oid === '') return "";
        return count(get_snmp_walk($ip,$community,$oid,$device));
    }
        
    function get_snmp($ip,$community,$oid)
    {
        if(!isset($oid) || $oid === null || $oid === '') return "";
        require("config.php");
        snmp_set_oid_output_format(SNMP_OID_OUTPUT_NUMERIC);
        return trim(str_replace($replace_table,"",@snmpget($ip, $community, $oid, $snmp_timeout, $snmp_retry)));
    }                

    function get_snmp_walk($ip,$community,$oid,$n)
    {
        //if(!isset($oid) || $oid === null || $oid === '') return "";
        require("config.php");
        snmp_set_oid_output_format(SNMP_OID_OUTPUT_NUMERIC);
        $a=@snmpwalk($ip,$community,$oid, $snmp_timeout, $snmp_retry);
        $b=array();
        if(!isset($n)) $n=0;
	for ($i=0; $i<count($a); $i++)
        {
            switch ($n)
            {
                case 0: $b[]=trim(str_replace($replace_table,"",$a[$i]));
                    break;
                case 1: $line=preg_replace("/[^0-9]/","",str_replace($replace_table,"",$a[$i]));
                        $b[]=trim($line);
                    break;
                default:$b[]=trim(str_replace($replace_table,"",$a[$i]));
            }
        }                
        return $b;
    }
            
    function get_snmp_walk_bps($ip,$community,$oid)
    {
        if(!isset($oid) || $oid === null || $oid === '') return "";
        require("config.php");
        snmp_set_oid_output_format(SNMP_OID_OUTPUT_NUMERIC);
        $a=@snmpwalk($ip,$community,$oid, $snmp_timeout, $snmp_retry);
        $b=array();
	for ($i=0; $i<count($a); $i++)
        {
            $line=preg_replace("/[^0-9]/","",str_replace($replace_table,"",$a[$i])) / 1000000;
            $b[]=trim($line);
        }                
        return $b;
    }
    
    function get_snmp_walk_bps_in($ip,$community,$if_index,$nr_pos,$device,$d_time,$in_out_o)
    {
        $d_bps=1000000*$d_time;
        $bps=array();
        $gdir=dirname(__FILE__).'/tmp';
        if(!(file_exists($gdir))) 
        {
            mkdir($gdir);
        }
        $file_in=$gdir."/".$ip.'_in';
        
        if(file_exists($file_in))
        {    
            $wp=fopen($file_in,'r');
            while (!feof($wp))
            {
                $in_o_hist[]=fgets($wp,128);
            }
            fclose($wp);
            for($i=0;$i<count($in_out_o);$i++)
            {
                $bp=($in_out_o[$i] - $in_o_hist[$i]);
                if($bp<0) $bp=0;
                $bps[]=round(($bp / $d_bps)*8,4);
            }
        }    
        $wp=fopen($file_in,'w');
        for($i=0;$i<count($in_out_o);$i++)
        {
            $text_in=$in_out_o[$i]."\n";
            fwrite($wp,$text_in,strlen($text_in));
        }    
        fclose($wp);
        return $bps;
    }
    function get_snmp_walk_bps_out($ip,$community,$if_index,$nr_pos,$device,$d_time,$in_out_o)
    {
        $d_bps=1000000*$d_time;
        $bps=array();
        $gdir=dirname(__FILE__).'/tmp';
        if(!(file_exists($gdir))) 
        {
            mkdir($gdir);
        }
        $file_in=$gdir."/".$ip.'_out';
        
        if(file_exists($file_in))
        {    
            $wp=fopen($file_in,'r');
            while (!feof($wp))
            {
                $in_o_hist[]=fgets($wp,128);
            }
            fclose($wp);
            for($i=0;$i<count($in_out_o);$i++)
            {
                $bp=($in_out_o[$i] - $in_o_hist[$i]);
                if($bp<0) $bp=0;
                $bps[]=round(($bp / $d_bps)*8,4);
            }
        }    
        $wp=fopen($file_in,'w');
        for($i=0;$i<count($in_out_o);$i++)
        {
            $text_in=$in_out_o[$i]."\n";
            fwrite($wp,$text_in,strlen($text_in));
        }    
        fclose($wp);
        return $bps;
    }
    
    function get_snmp_duplex_status($ip,$community,$if_index,$nr_pos,$device)
    {
        $k_i=array();
        if(count($if_index)>0)
        {    
            for($i=0;$i<count($if_index);$i++)
            {
                $k_i[$if_index[$i]]=$nr_pos[$i]; //array interface => pos
            }    
            $pos_interface=array_flip($k_i); //array pos=>interface        
            $if_duplex_r=array_fill(0,count($if_index)-1,""); //returned full empty table of interfaces        
            for($i=0;$i<count($if_duplex_r);$i++)
            {
                $if_duplex_interface[$i]=preg_replace("/[^0-9]/","",get_snmp($ip,$community,$device['ifDuplexStatus'].'.'.$pos_interface[$i]));
            }
            return $if_duplex_interface;
        } else return "";
    }
    
//----------------------------------------------------------------------------------------------------------------------------------------    
    function get_snmp_walk_ip($ip,$community,$if_index,$nr_pos,$device)
    {
        include("config.php");
        include("config_snmp.php");
        if(count($if_index)>0)
        {                    
            $ip_r=array_fill(0,count($if_index)-1,""); //returned table ip addresses
        
            $ip_a=get_snmp_walk($ip,$community,$device['ipAdEntAddr']); //ip addresses
            for($i=0;$i<count($ip_a);$i++)
            {
                $int_index[$ip_a[$i]]=get_snmp($ip,$community,$device['ipAdEntIfIndex'].'.'.$ip_a[$i]); //array ip => interface index
            }
            $int_key=array_values($int_index); //if index 
            $int_ip= array_keys($int_index);   //ip
        
            $mask=get_snmp_walk($ip,$community,$device['ipAdEntNetMask']); //mask for ip
            for ($i=0; $i<count($mask); $i++)
            {
                $ip_mask[$ip_a[$i]]=$ipMask[$mask[$i]]; //full ip address width mask
            }
        
            for($i=0;$i<count($if_index);$i++)
            {
                for($k=0;$k<count($int_key);$k++) //find all ip for if_index
                {
                    if($int_key[$k] == $if_index[$i])
                    {
                        if($int_ip[$k]<>"")
                        {
                            $ip_r[$i]=$ip_r[$i].' '.$int_ip[$k].'/'.$ip_mask[$int_ip[$k]];
                        } else $ip_r[$i]="";
                    }
                }
            }
            return $ip_r;
        } else return "";     
    }
    
    function get_snmp_walk_vlan($ip,$community,$oid,$device)
    {
        if(!isset($oid) || $oid === null || $oid === '') return "";
        require("config.php");
        $a=@snmpwalkoid($ip,$community,$oid);
        $b=array();
        for (reset($a); $i = key($a); next($a)) 
        {
            $b[]=str_replace($replace_table,"",$i);
        }
        return $b;
    }
    
    function get_snmp_walk_vlan2($ip,$community,$oid,$device)
    {
        if(!isset($oid) || $oid === null || $oid === '') return "";
        return get_snmp_walk($ip,$community,$oid);
    }
    
    function get_snmp_walk_vlan_desc($ip,$community,$oid,$device)
    {
        if(!isset($oid) || $oid === null || $oid === '') return "";
        return get_snmp_walk($ip,$community,$oid);
    }

    function get_snmp_walk_vlan_port($ip,$community,$vlan,$device)
    {
        $p=array();   
        for($i=0;$i<count($vlan);$i++)
        {
            $oid1='1.3.6.1.2.1.17.7.1.2.2.1.2.'.$vlan[$i];
            $oid2='1.3.6.1.2.1.17.7.1.2.2.1.3.'.$vlan[$i];
            $a1=get_snmp_walk($ip,$community,$oid1);
            $a2=get_snmp_walk($ip,$community,$oid2);
            //1.3.6.1.2.1.17.7.1.2.2.1.2. + vlan + mac = port
            for ($i=0; $i<count($a1); $i++)
            {
                $line=str_replace($replace_table,"",$a1[$i]);
                $b1[]=$line;
                $line=str_replace($replace_table,"",$a2[$i]);
                $b2[]=$line;
            }
        }    
        return $p;
    }
    
//----------------------------------------------------------------------------------------------------------------------------------------
    
   function get_model($ip,$community)
    {
        $model_p=get_snmp($ip, $community, '1.3.6.1.2.1.1.1.0', $snmp_timeout, $snmp_retry);
        $model="CISCO"; //default
        if(!stristr($model_p,'3712') === false)
        {
            $model='MGS3712';
            return $model;
        } else if(!stristr($model_p,'3700') === false)
               {
                    $model='MGS3700';
                    return $model;
               } else if(!stristr($model_p,'4700') === false)
                      {
                        $model='XGS4700';
                        return $model;
                      } if(!stristr($model_p,'4728') === false)
                        {
                            $model='XGS4728';
                            return $model;
                        } else if(!stristr($model_p,'MES') === false)
                                {
                                    $model='MES';
                                    return $model;
                                } else  if(!stristr($model_p,'ES') === false)
                                        {
                                            $model='ES';
                                            return $model;
                                        } else if(!stristr($model_p, 'GS') === false)
                                               {
                                                    $model = 'GS';
                                                    return $model;
                                               } else if(!stristr($model_p, 'ISCOM') === false)
                                                      {
                                                            $model = 'RAISECOM';
                                                            return $model;
                                                      } else      
                                                        {
                                                            $model = 'NONE';
                                                            return $model;
                                                        }
    }
    function get_tryb_pracy_portu($ip,$community,$device)
    {
        $pp=array();        
        if($device['device_id']==='zyxel')
        {
            $mm=get_model($ip,$community);
            switch ($mm)
            {
                case 'XGS4700': $oid='1.3.6.1.4.1.890.1.5.8.54.23.1.1.1';
                                $pp=get_snmp_walk($ip,$community,$oid);
                    break;
                case 'XGS4728': $oid='1.3.6.1.4.1.890.1.5.8.46.23.1.1.1';
                                $pp=get_snmp_walk($ip,$community,$oid);
                    break;                
                case 'MGS3700': $oid='1.3.6.1.4.1.890.1.5.8.75.22.1.1.1';
                                $pp=get_snmp_walk($ip,$community,$oid);
                    break;
                case 'MGS3712': $oid='1.3.6.1.4.1.890.1.5.8.48.22.1.1.1';
                                $pp=get_snmp_walk($ip,$community,$oid);
                    break;                
                case 'ES':      $oid='1.3.6.1.4.1.890.1.5.8.19.19.1.1.1';
                                $pp=get_snmp_walk($ip,$community,$oid);
                    break;
                case 'GS':      $oid='1.3.6.1.4.1.890.1.5.8.59.24.1.1.1';
                                $pp=get_snmp_walk($ip,$community,$oid);
                    break;
                case 'MES':     $oid='1.3.6.1.4.1.890.1.5.8.19.19.1.1.1';
                                $pp=get_snmp_walk($ip,$community,$oid);
                    break;
                default:        $oid='';
            }
        }             
        return $pp;
    }
    function get_typ_modulu($ip,$community,$device)
    {
        $pp=array();
        if($device['device_id']==='zyxel')
        {
            $mm=get_model($ip,$community);
            switch ($mm)
            {
                case 'XGS4700': $oid='1.3.6.1.4.1.890.1.5.8.54.23.1.1.4';
                                $pp=get_snmp_walk($ip,$community,$oid);
                    break;
                case 'XGS4728': $oid='1.3.6.1.4.1.890.1.5.8.46.23.1.1.4';
                                $pp=get_snmp_walk($ip,$community,$oid);
                    break;                
                case 'MGS3700': $oid='1.3.6.1.4.1.890.1.5.8.75.22.1.1.4';
                                $pp=get_snmp_walk($ip,$community,$oid);
                    break;
                case 'MGS3712': $oid='1.3.6.1.4.1.890.1.5.8.48.22.1.1.4';
                                $pp=get_snmp_walk($ip,$community,$oid);
                    break;                
                case 'ES':      $oid='1.3.6.1.4.1.890.1.5.8.19.19.1.1.4';
                                $pp=get_snmp_walk($ip,$community,$oid);
                    break;                
                case 'GS':      $oid='1.3.6.1.4.1.890.1.5.8.59.24.1.1.4';
                                $pp=get_snmp_walk($ip,$community,$oid);
                    break;
                case 'MES':     $oid='1.3.6.1.4.1.890.1.5.8.19.19.1.1.4';
                                $pp=get_snmp_walk($ip,$community,$oid);
                    break;                
                default:        $oid='';
            }
        }
        return $pp;
    }
    
    function get_run_modul($ip,$community,$device)
    {
        $pp=array();
        if($device['device_id']==='zyxel')
        {
            $mm=get_model($ip,$community);
            switch ($mm)
            {
                case 'XGS4700': $oid='1.3.6.1.4.1.890.1.5.8.54.23.1.1.5';
                                $pp=get_snmp_walk($ip,$community,$oid);
                    break;
                case 'XGS4728': $oid='1.3.6.1.4.1.890.1.5.8.46.23.1.1.5';
                                $pp=get_snmp_walk($ip,$community,$oid);
                    break;                
                case 'MGS3700': $oid='1.3.6.1.4.1.890.1.5.8.75.22.1.1.5';
                                $pp=get_snmp_walk($ip,$community,$oid);
                    break;
                case 'MGS3712': $oid='1.3.6.1.4.1.890.1.5.8.48.22.1.1.5';
                                $pp=get_snmp_walk($ip,$community,$oid);
                    break;                
                case 'ES':      $oid='1.3.6.1.4.1.890.1.5.8.19.19.1.1.5';
                                $pp=get_snmp_walk($ip,$community,$oid);
                    break;
                case 'GS':      $oid='1.3.6.1.4.1.890.1.5.8.59.24.1.1.5';
                                $pp=get_snmp_walk($ip,$community,$oid);
                    break;
                case 'MES':     $oid='1.3.6.1.4.1.890.1.5.8.19.19.1.1.5';
                                $pp=get_snmp_walk($ip,$community,$oid);
                    break;                
                default:        $oid='';
            }        
        }
        return $pp;
    }
        

?>
