##############################################################################
# "Settings" library
# A collection of shared functions related to the application settings.
#
# Version 0.1
# Written by Y. Charton, from extracts of settings.pm of nagiosbp
#
# Revision history:
# 2011-06-09 v0.1   Y. Charton    First release
#
##############################################################################

package Settings;
use strict;
use lib ('interface_table_v3t/lib');
use Exporter;
use GeneralUtils;

##############################################################################
### I N I T ##################################################################
##############################################################################

BEGIN {
    use vars qw(@ISA @EXPORT @EXPORT_OK $VERSION $AUTHOR);
    @ISA         = qw(Exporter);
    @EXPORT      = qw(parseConfigFile);
    @EXPORT_OK   = qw();
    $VERSION     = 0.1;
    $AUTHOR      = "Y. Charton";
}

##############################################################################
### S U B S ##################################################################
##############################################################################

sub parseConfigFile
{
    my $file = shift;
    my $config = shift;
    my ($in, $var, $value);

    logger(3, "#==== Start of config ====#");
    open(IN, "<$file") or die "unable to read file $file\n";
        while ($in = <IN>)
        {
            chomp($in);          # Get rid of the trailling \n
            $in =~ s/^\s*//;     # Remove spaces at the start of the line
            $in =~ s/\s*$//;     # Remove spaces at the end of the line
            if ($in !~ m/(^$|^#)/) {
                ($var, $value) = split(/=/, $in);
                $var = cutOffSpaces($var);
                $value = cutOffSpaces($value);
                $$config{$var}=$value;
                logger(3, "variable: ".$var.", value: ".$value);
            }
        }
    close(IN);
    logger(3, "#==== End of config ====#");
}

1;

__END__

# vi: set ts=4 sw=4 expandtab :
