<?php
    //error_reporting(0);
    include_once("config.php");
    include("logs.php");
    include_once("libexec_ajax/snmp_get_functions.php");
    
    $ip=         trim($_REQUEST["ip"]);
    $community=  trim($_REQUEST["snmp"]);
    if($ip === "" || !isset($ip)) $ip='127.0.0.1';
    if($community==="" || !isset($community)) $community=$default_community;
    $refresh=    $_REQUEST["refresh"];
    if($refresh==="" || !isset($refresh)) $refresh=$auto_refresh;
    write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.': '.$ip." -   ".$community);
?>

<?php
/**
 * @copyright       Copyright (C) 2018 MDM-IT. All rights reserved.
 * @license         see LICENSE.txt
 * 
 * Run: http://<server>/snmp_mdmit/index.php?ip=<ip>&snmp=<snmp ro community>
 */
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<HEAD>
    <TITLE>MDM-IT SNMP View</TITLE> 
    <META http-equiv="content-type" content="text/html; charset=utf-8"/>
    <META HTTP-EQUIV="Cache-Control" content="no-cache"/>
    <META HTTP-EQUIV="Pragma" CONTENT="no-cache"/>
    <!--<META HTTP-EQUIV="Refresh" CONTENT="60" />-->
    
    <link type="text/css" href="js/jquery/css/redmond/jquery-ui.custom.css" rel="stylesheet" />
    <script type="text/javascript" src="js/jquery/jquery.js"></script>
    <script type="text/javascript" src="js/jquery/jquery-ui.js"></script>
    <script type="text/javascript" src="js/tabs/tabpane.js"></script>
    <link type="text/css" rel="stylesheet" href="js/tabs/tab.winclassic.css" />    
    
    <link type="text/css" href="js/jquery_window/css/jquery.window.css" rel="stylesheet" />
    <link type="text/css" href="js/jquery_window/css/mdmit_window.css" rel="stylesheet" />
    <script type="text/javascript" src="js/jquery_window/jquery.window.js"></script>        
        
    <link rel="stylesheet" href="js/Zebra/css/mdmit/zebra_dialog.css" type="text/css">
    <script type="text/javascript" src="js/Zebra/zebra_dialog.js"></script>
    <script type="text/javascript" src="mdmit_dialogs.min.js"></script>

    <link rel="stylesheet" href="snmp_get_window.css" type="text/css"/>    
</HEAD>

<body onload="set_onLoad();">
	<div id="overlay" style="position:absolute;top:50%;left:50%;font-family: Verdana; font-size: 6px; color: #000080;">
            <img border="0" src="lib/786_black_32.gif">
        <br/>&nbsp;&nbsp;MDM-IT
        </div>
    
<div id="form_top">
  <table width="100%" border="0">
    <tr>
        <td width="60%">
            <form>
                <label for="ip_id" id="ip_label_id">Host IP: </label><input  name="ip_id"  id="ip_id"  value=<?php echo $ip; ?>"  type="text" tabindex="1"/>
                <label for="sparams_id" id="sparams_label_id">SNMP Community: </label><input  name="sparams_id" id="sparams_id" value="<?php echo $community; ?>" type="text" tabindex="2"/>
                <label for="refresh_id" id="refresh_label_id">Auto Refresh [s]: </label><input  name="refresh_id" id="refresh_id" value="<?php echo $refresh/1000; ?>" type="text" tabindex="3"/>
                    <input  name="start_id" id="start_id" value="Check" type="button" tabindex="4" onclick="snmp_check_all();"/>
                    <input  name="stop_id"  id="stop_id"  value="Stop"  type="button" tabindex="5" onclick="stopAuto();"/>
                    <input  name="close_id" id="close_id" value="Close" type="button" tabindex="6" onclick="CloseWin();"/>
            </form>           
        </td>
        <td widht="30%" align="right" style="font-family: Verdana; font-size: 13px; color:#000000; font-weight: bold;">
            <div id="device_name"></div>
        </td>
        <td width="10%" align="right" style="font-family: Verdana; font-size: 8px; color:#8c8c8c;">
            <div id="state_id"></div>
        </td>
    </tr>      
  </table>
</div>

<div id="snmp_interfaces_h">
    <table width="100%" class="table_header_snmp">
    <tr>
      <td width="20%">
          IP: <a href="javascript:show_graph_icmp_window()"><?php echo $ip; ?></a>
      </td>
      <td width="50%">
          Model:
      </td>
      <td width="30%">
          Location:
      </td>
    </tr>
    <tr>
      <td width="20%">
          Name:
      </td>
      <td width="30%">
          UpTime:
      </td>
    </tr>
    </table>
</div>
<table width="100%" style="border-style: solid; border-width: 0px" bordercolor="#eeeeee" bgcolor="#fff">
    <tr>
      <td></td>
    </tr>
</table>

<div id="main_tab_id">    
 <div class="tab-pane" id="tab-pane-1">
    <div class="tab-page"><h4 class="tab">Interfaces</h4>
        <div id="snmp_interfaces"></div>
    </div>
    <div class="tab-page"><h4 class="tab">Vlans</h4>
        <div id="snmp_vlans"></div>
    </div>
    <div class="tab-page"><h4 class="tab">Vlans/Ports/MAC</h4>
        <div id="snmp_vlans_ports_mac"></div>
    </div>
    <div class="tab-page"><h4 class="tab">Custom View</h4>
        <div id="snmp_custom"></div>
    </div>
 </div>    
</div>
<script type="text/javascript">
var updateInterval=<?php echo $auto_refresh; ?>; //             30000;
var updateInterval_s=<?php echo $auto_refresh/1000; ?>;
var ww_s_s,ww_s_s2,ww_s_s3,w_icmp;
var ajax_timeout=<?php echo $ajax_timeout; ?>;
var count_thr=0;

function CloseWin()
{
    close();
}

function set_onLoad()
{
    $("#overlay").fadeOut();

    $("#snmp_interfaces").append('     <font color="#000000"><font size="2">Checking...</font></font>');
    $("#snmp_vlans").append('          <font color="#000000"><font size="2">Checking...</font></font>');
    $("#snmp_vlans_ports_mac").append('<font color="#000000"><font size="2">Checking...</font></font>');
    $("#snmp_custom").append('         <font color="#000000"><font size="2">Checking...</font></font>');
    
    $("#ip_id").val("<?php echo $ip; ?>");
    
    $("#sparams_id").val("<?php echo $community; ?>");
    if($("#sparams_id").val() === "") $("#sparams_id").val("public");
    
    $("#refresh_id").val(updateInterval_s);
    if(parseInt($("#refresh_id").val()) <= 0 || $("#refresh_id").val() === "") $("#refresh_id").val(15000);
    
    if($("#ip_id").val() !== "")
    {
        snmp_check_all();
    }
}

function snmp_check_all()
{   
    if(check_ping())
    {
        count_thr=6;
        
        try {get_snmp_header();} catch(e){;}  //headres in 1 row table
        try {get_h_vendor();} catch(e){;}       //device info in first header
        try {
            w_progress('Check interfaces...');
            p_get_interfaces(0);
        } catch(e) {;}
        try {
            p_get_vlans();
        } catch(e) {;}
        try {
            p_get_vlans_ports_mac();
        } catch(e) {;}
        try {
            p_get_custom_snmp();
        } catch(e) {;}
    }
    idInterval=setInterval(p_get_snmp,updateInterval);
}

function check_ping()
{
    var ip=$("#ip_id").val();
    var ping_t='0';
    $.ajax({
        url:         "libexec_ajax/check_ping.php",
        async:       false,
        contentType: "text",
        cache:       false,
        type:        "GET",
        data: ({ip  : ip}),
        beforeSend: function(data){
            $("#state_id").empty();
            $("#state_id").append('<font color="#000000">Checking ping</font>');
        },
        success: function(data){
                //var sd=data.split('|');
                //var ping_r=sd[0].split('time=');                
                ping_t=data;
        }
    });
    if(ping_t === '0' || ping_t === 0) return true;
    else
        {
            $("#device_name").empty();
            $("#device_name").append('<font color="#FF0000">No response from host</font>');
            $("#snmp_interfaces_h").empty();
            $("#snmp_interfaces").empty();
            $("#snmp_custom").empty();
            $("#snmp_vlans").empty();
            $("#state_id").empty();
            return false;
        }
}

//name of device in table header
function get_snmp_header()
{
    var ip=     $("#ip_id").val();
    var snmp_c= $("#sparams_id").val();
    $.ajax({
        url:         "libexec_ajax/snmp_header.php",
        async:       true,
        contentType: "text",
        cache:       false,
        type:        "GET",
        timeout:     ajax_timeout,  //ms
        data: ({ip  : ip,
                snmp: snmp_c
        }),
        beforeSend: function(data){
            $("#state_id").empty();
            $("#state_id").append('<font color="#000000">Checking header</font>');
        },
        success: function(data){
            $("#snmp_interfaces_h").empty();
            $("#snmp_interfaces_h").append(data);
            count_thr--;
        }
    });
}

//get vendor of device in main window header
function get_h_vendor()
{
    var ip=     $("#ip_id").val();
    var snmp_c= $("#sparams_id").val();

    $.ajax({
        url:         "libexec_ajax/vendor_header.php",
        async:       true,
        contentType: "text",
        cache:       false,
        type:        "GET",
        timeout:     ajax_timeout,  //ms
        data: ({ip  : ip,
                snmp: snmp_c
        }),
        beforeSend: function(data){
            $("#state_id").empty();
            $("#state_id").append('<font color="#000000">Checking vendor</font>');
        },
        success: function(h_data){
            $("#device_name").empty();
            $("#device_name").append(h_data);
            count_thr--;
            //$("#state_id").empty();
            if(count_thr===0)
            {    
                $("#state_id").empty();
                $("#state_id").append('<font color="#000000">Waiting</font>');
            }                    
        }
    });
}

function p_get_snmp()
{
    if(check_ping())
    {
        count_thr=4;
        try {p_get_interfaces(1);}     catch(e){;} //przejscie za drugim razem - dla przyspieszenia odczytow
        try {p_get_vlans();}           catch(e){;}
        try {p_get_vlans_ports_mac();} catch(e){;}
        try {p_get_custom_snmp();}     catch(e){;}
    }
}

    
//get interfaces
function p_get_interfaces(tt)
{
    var ip=       $("#ip_id").val();
    var snmp_c=   $("#sparams_id").val();
    var a_refresh=parseInt($("#refresh_id").val());

    $.ajax({
        url:         "libexec_ajax/snmp_interfaces.php",
        async:       true,
        contentType: "text",
        cache:       false,
        type:        "GET",
        timeout:     ajax_timeout,  //ms
        data: ({ip  : ip,
                snmp: snmp_c,
                auto_refresh: a_refresh,
                thr: tt
        }),
        beforeSend: function(data){
            $("#state_id").empty();
            $("#state_id").append('<font color="#000000">Checking interfaces</font>');
        },
        success: function(data){
            $("#snmp_interfaces").empty();
            $("#snmp_interfaces").append(data);
            try { ww_s_s.close();} catch(e){;}
            count_thr--;
            //$("#state_id").empty();
            if(count_thr===0)
            {
                $("#state_id").empty();
                $("#state_id").append('<font color="#000000">Waiting...</font>');
            }
        }    
    });
}

//get vlans
function p_get_vlans()
{
    var ip=     $("#ip_id").val();
    var snmp_c= $("#sparams_id").val();
    $.ajax({
        url:         "libexec_ajax/snmp_vlans.php",
        async:       true,
        contentType: "text",
        cache:       false,
        type:        "GET",
        timeout:     ajax_timeout,  //ms
        data: ({ip  : ip,
                snmp: snmp_c
        }),
        beforeSend: function(data){
            $("#state_id").empty();
            $("#state_id").append('<font color="#000000">Checking vlans</font>');            
        },
        success: function(data){
            $("#snmp_vlans").empty();
            $("#snmp_vlans").append(data);            
            count_thr--;
            //$("#state_id").empty();
            if(count_thr===0)
            {    
                $("#state_id").empty();
                $("#state_id").append('<font color="#000000">Waiting...</font>');
            }
        }
    });
}

//get vlans
function p_get_vlans_ports_mac()
{
    var ip=     $("#ip_id").val();
    var snmp_c= $("#sparams_id").val();
    $.ajax({
        url:         "libexec_ajax/snmp_vlans_ports_mac.php",
        async:       true,
        contentType: "text",
        cache:       false,
        type:        "GET",
        timeout:     ajax_timeout,  //ms
        data: ({ip  : ip,
                snmp: snmp_c
        }),
        beforeSend: function(data){
            $("#state_id").empty();
            $("#state_id").append('<font color="#000000">Checking vlans-ports-mac</font>');
        },
        success: function(data){
            $("#snmp_vlans_ports_mac").empty();
            $("#snmp_vlans_ports_mac").append(data);            
            count_thr--;
            //$("#state_id").empty();
            if(count_thr===0)
            {    
                $("#state_id").empty();
                $("#state_id").append('<font color="#000000">Waiting...</font>');
            }
        }
    });
}

//get custom snmp query
function p_get_custom_snmp()
{
    var ip=     $("#ip_id").val();
    var snmp_c= $("#sparams_id").val();

    $.ajax({
        url:         "libexec_ajax/snmp_custom.php",
        async:       true,
        contentType: "text",
        cache:       false,
        type:        "GET",
        timeout:     ajax_timeout,  //ms
        data: ({ip  : ip,
                snmp: snmp_c
        }),
        beforeSend: function(data){
            $("#state_id").empty();
            $("#state_id").append('<font color="#000000">Checking custom query</font>');
        },
        success: function(data){
            $("#snmp_custom").empty();
            $("#snmp_custom").append(data);
            count_thr--;
            //$("#state_id").empty();
            if(count_thr===0)
            {    
                $("#state_id").empty();
                $("#state_id").append('<font color="#000000">Waiting...</font>');
            }
        }    
    });
}

function stopAuto()
{
    clearInterval(idInterval);
    count_thr=0;
    $("#state_id").empty();
    $("#state_id").append('<font color="#FF0000">Stop checking</font>');
    try {ww_s_s.close();} catch(e){;}
}

function show_graph_icmp_window()
{
    var ip=$("#ip_id").val();
    var win="<?php echo $window_modal; ?>";
    var refresh=<?php echo $graph_refresh; ?>;
    //if(win==="0")
        window.open("show_graph_icmp_main_window_j.php?ip="+ip+"&auto_refresh="+refresh, "_blank", 'scrollbars=yes,width=520,height=300');    
    //if(win==="1")
    //    w_icmp=mdmit_run_function_w("show_graph_icmp_main_window_j.php?ip="+ip+"&auto_refresh="+refresh,"Ping: "+ip,500,200,"",'','w_icmp',false);
}

function show_graph_interface_window(ip,auto_refresh,k,port_name)
{
    var win="<?php echo $window_modal; ?>";
    //if(win==="0")
        window.open("show_graph_main_window_j.php?ip="+ip+"&auto_refresh="+auto_refresh+"&k="+k+"&port_name="+port_name, "_blank", 'scrollbars=yes,width=520,height=300');
    
    //if(win==="1")
    //    //w_s_gr=mdmit_run_function_w("show_graph_main_window_j.php?ip="+ip+"&auto_refresh="+auto_refresh+"&k="+k,"Interface "+k+" "+port_name,500,200,"",'','w_s_gr',false);
    //    w_s_gr=mdmit_run_function_w("show_jp_graph.php?ip="+ip+"&auto_refresh="+auto_refresh+"&k="+k,"Interface "+k+" "+port_name,500,200,"",'','w_s_gr',false);
    
    //window.open("show_graph_main_window.php?ip="+ip+"&auto_refresh="+auto_refresh+"&k="+k, "_blank", 'scrollbars=yes,width=520,height=300');
    //window.open("show_jp_graph.php?ip="+ip+"&auto_refresh="+auto_refresh+"&k_interface="+k, "_blank", 'scrollbars=yes,width=520,height=300');
}

</script>
    
<?php
    include("footer_window.php");
?>
