<?php
    error_reporting(0);
    include_once("config.php");
    
    $ip=       $_REQUEST["ip"];
    $refresh=  $_REQUEST["auto_refresh"];
    if($refresh==="" || !isset($refresh)) $refresh=$auto_refresh;
?>

<?php
/**
 * @copyright       Copyright (C) 2017 MDM-IT. All rights reserved.
 * @license         see LICENSE.txt
 * 
 * Run: http://<server>/snmp_mdmit/index.php?ip=<ip>&snmp=<snmp ro community>
 */
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<HEAD>
    <TITLE>MDM-IT RRD</TITLE>
    <META http-equiv="content-type" content="text/html; charset=utf-8"/>
    <META HTTP-EQUIV="Cache-Control" content="no-cache"/>
    <META HTTP-EQUIV="Pragma" CONTENT="no-cache"/>
    
    <!--<META HTTP-EQUIV="Refresh" CONTENT="10" />-->
    
    <link type="text/css" href="js/jquery/css/redmond/jquery-ui.custom.css" rel="stylesheet" />
    <script type="text/javascript" src="js/jquery/jquery.js"></script>
    <script type="text/javascript" src="js/jquery/jquery-ui.js"></script>    
    <script type="text/javascript" src="js/jquery/jquery.jqplot.min.js"></script>
    <script type="text/javascript" src="js/jquery/plugins/jqplot.dateAxisRenderer.js"></script>
    <script type="text/javascript" src="js/jquery/plugins/jqplot.cursor.js"></script>
    <!--<script type="text/javascript" src="js/jquery/plugins/jqplot.dragable.js"></script>-->
    <script type="text/javascript" src="js/jquery/plugins/jqplot.highlighter.js"></script>
    <!--<script type="text/javascript" src="js/jquery/plugins/jqplot.canvasAxisLabelRenderer.js"></script>-->
    <link rel="stylesheet" type="text/css" href="js/jquery/css/jquery.jqplot.min.css" />    

</HEAD>
    
<script type="text/javascript">
var updateInterval=<?php echo $refresh; ?>;
var ip="<?php echo $ip; ?>";
var g_plot;

</script>
    
<body onload="set_onLoad();">
<div id="rrd_graph_plot" style="height:300px; width:500px;"></div>
    
<script type="text/javascript">
    
function set_onLoad()
{
    set_size();
    //p_get_icmp();
    p_get_graph();
    $(document).ready(function() {
        setInterval(p_get_graph,updateInterval);
        //$.jqplot.config.enablePlugins=true;
        //$.jqplot._noToImageButton=true;
    });
}

$(window).bind('resize', function(event, ui) 
{
    set_size();
    if(g_plot)
        g_plot.replot({resetAxes: true});
});

function p_get_icmp()
{
    var ip="<?php echo $ip; ?>";

    $.ajax({
        url:         "check_icmp.php",
        async:       false,
        contentType: "text",
        cache:       false,
        type:        "GET",
        data: ({ip  : ip
        }),
        success: function(data){
            //alert(data);
        }    
    });
}

function set_size()
{
    var w_height=$(window).height()*0.92; //-30;
    var w_width= $(window).width()*0.96; //- 30;
    $('#rrd_graph_plot').height(w_height);
    $('#rrd_graph_plot').width(w_width);
}

function p_get_graph()
{
    var wTmp1 = [];
    var wPoints1 = [];
    var wPoints2 = [];
    
    $.ajax({
        url:         "gen_graph_data_icmp.php",
        async:       false,
        contentType: "text",
        cache:       false,
        type:        "GET",
        data: ({ip  : ip
        }),
        success: function(data){
            wTmp1=data.split('|');
            for(i=0;i<wTmp1.length;i++)
            {
                if(wTmp1[i]>=0)
                {
                    wPoints1[i]=wTmp1[i]/1;
                    wPoints2[i]=0;
                } else
                    {
                        wPoints1[i]=0;
                        wPoints2[i]=wTmp1[i]/1;
                    }
            }
            if (g_plot) 
                g_plot.destroy();
            
            plot_graph(wPoints1,wPoints2);
        }    
    });
}
 
function plot_graph(wPoints1,wPoints2)
{
    g_plot=$.jqplot('rrd_graph_plot', [wPoints1,wPoints2],
    {
        cursor:{
            zoom: false,
            looseZoom: false,
            showToolTip: false,
            followMouse: false,
            showToolTipOutsideZoom: false
        },
        title:{
            text: 'Ping: '+ip,
            fontFamily: 'Helvetica',
            fontSize: '10px',
            textColor: '#000000'
        },
        legend: {
            show: false,
            location: 'ne',     // compass direction, nw, n, ne, e, se, s, sw, w.
            xoffset: 12,        // pixel offset of the legend box from the x (or x2) axis.
            yoffset: 12        // pixel offset of the legend box from the y (or y2) axis.
        },
        //stactSeries: false,
        //-------------------------------------------------------------------
        axesDefaults: {
            labelRenderer: $.jqplot.CanvasAxisLabelRenderer
        },
        axes:{
          xaxis:{
            min: 0,
            //max: 180,
            autoscale:true,
            tickOptions:{ 
                //angle: -30,
                showGridLine: false,
                labelPosition: 'right',
                fontFamily:'Helvetica',
                fontSize: '7px'
            },    
            pad: 0,
            tickRenderer:$.jqplot.CanvasAxisTickRenderer,
            //label:'Time', 
            labelOptions:{
                fontFamily:'Helvetica',
                fontSize: '7px'
            },
            labelRenderer: $.jqplot.CanvasAxisLabelRenderer
          }, 
          yaxis:{
            //min: 0,
            //max: 1000,
            autoscale:true,
            renderer:$.jqplot.LogAxisRenderer,
            tickOptions:{
                labelPosition: 'middle',
                //angle:-30
                fontFamily:'Helvetica',
                fontSize: '7px'
            },
            pad: 0,
            tickRenderer:$.jqplot.CanvasAxisTickRenderer,
            labelRenderer: $.jqplot.CanvasAxisLabelRenderer,
            labelOptions:{
                fontFamily:'Helvetica',
                fontSize: '7px'
                //angle: -30
            },
            label:'Ping [ms]'
          }
        },
        //----------------------------------------------------------------------
        grid:{
            drawBorder: true,
            shadow: true,
            shadowAngle: 45,
            shadowOffset: 1.5,
            shadowWidth: 3,
            shadowDepth: 3,
            shadowAlpha: 0.07,
            //background: 'white',
            background: 'rgba(250,250,255,0.8)',
            gridLineColor: '#E8E8E8',
            gridLineWidth: 1,
            borderWidth: 2.0
        },
        //------------------------------------------------------------------------
        seriesDefaults: {
            rendererOptions: {
                smooth: true
            },
            ShowMarker: false
            //fillToZero: true
            //fill: true,
            //fillAndStroke: false
        },
        series:[
            {
                color: '#06e701',
                //color: 'rgba(113, 218, 113,0.4)',
                lineWidth:1,
                showLine:true,
                fill: true,
                fillAndStroke: false,
                fillToZero: true,
                markerOptions: { size: 0}
            },
            {
                color: '#ff0000',
                lineWidth:1,
                showLine:true,
                fill: true,
                fillAndStroke: false,
                fillToZero: true,
                markerOptions: { size: 0}
            }
        ]
   });
}

</script>
    
</body>
</html>    
