<!--
PHP Subnet Calculator v1.2.
Copyright 06/25/2003 Raymond Ferguson ferguson_at_share-foo.com.
Released under GNU GPL.
Special thanks to krischan at jodies.cx for ipcalc.pl http://jodies.de/ipcalc
The presentation and concept was mostly taken from ipcalc.pl.
-->
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN
		"http://www.w3.org/TR/html4/loose.dtd"">
<html>
<head>
  <title>Subnet IPv4 Calculator</title>
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
  <link rel="shortcut icon" href="../../lib/top_bar_files/tostart2.png" />
  <meta name="GENERATOR" content="MDM-IT">
</head>
<body bgcolor="#D3D3D3">
<form method="post" action="<?php print $_SERVER['PHP_SELF'] ?> ">
<BR \><BR \>
<table width=80% align=center cellpadding=2 cellspacing=2 border=0>
  <tr><td bgcolor="#999999">
     <center><b><A HREF="https://192.168.211.196/core/net_tools/SubnetCalc/SubnetCalc.php">Subnet IPv4 Calculator</A></b></center>
  </td></tr>
</table>
<BR \>
<table align="center">
  <tr><td>
        <td>IPv4 &amp; Mask or CIDR:&nbsp;&nbsp;&nbsp;</td>
        <td><input type="text" name="my_net_info" value="" size="100" maxlength="32"></td>
        <td>&nbsp;&nbsp;&nbsp;&nbsp;<input type="submit" value="Calculate" name="subnetcalc">
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
            &nbsp;</td>
  </td></tr>
</table>
<BR \><BR \>

<?php
if (empty($_POST['my_net_info'])){
	print "\n\n</body></html>" ;
	exit ;
}

$my_net_info=rtrim($_POST['my_net_info']);
$end="</table>\n</body>\n</html>\n";

//Start table
print '<table align="center" cellpadding="2">' . "\n" ;

if (! ereg('^[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}(( [0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3})|(/[0-9]{1,2}))$',$my_net_info)){
	do_error("Invalid Input or not IPv4.\n");
	print "<tr><td>Use IPv4 & CIDR Netmask:&nbsp;</td><td>10.0.0.1/22</td></tr>\n";
	print "<tr><td>Or IPv4 & Netmask:</td><td>10.0.0.1 255.255.252.0</td></tr>\n";
	print "<tr><td>Or IPv4 & Wildcard Mask:</td><td>10.0.0.1 0.0.3.255</td></tr>\n";
	print $end ;
	exit ;
}

if (ereg("/",$my_net_info)){  //if cidr type mask
	$dq_host = strtok("$my_net_info", "/");
	$cdr_nmask = strtok("/");
	if (!($cdr_nmask >= 0 && $cdr_nmask <= 32)){
		do_error("Invalid CIDR value. Try integer 0 - 32.");
		print "$end";
		exit ;
	}
	$bin_nmask=cdrtobin($cdr_nmask);
	$bin_wmask=binnmtowm($bin_nmask);
} else { //Dotted quad mask?
    $dqs=explode(" ", $my_net_info);
	$dq_host=$dqs[0];
	$bin_nmask=dqtobin($dqs[1]);
	$bin_wmask=binnmtowm($bin_nmask);
	if (ereg("0",rtrim($bin_nmask, "0"))) {  //Wildcard mask then? hmm?
		$bin_wmask=dqtobin($dqs[1]);
		$bin_nmask=binwmtonm($bin_wmask);
		if (ereg("0",rtrim($bin_nmask, "0"))){ //If it's not wcard, whussup?
			do_error("Invalid Netmask.");
			print "$end";
			exit ;
		}
	}
	$cdr_nmask=bintocdr($bin_nmask);
}

//Check for valid $dq_host
if(! ereg('^0.',$dq_host)){
	foreach( explode(".",$dq_host) as $octet ){
 		if($octet > 255) do_error("Invalid IPv4 Address");
	}
}

$bin_host=dqtobin($dq_host);
$bin_bcast=(str_pad(substr($bin_host,0,$cdr_nmask),32,1));
$bin_net=(str_pad(substr($bin_host,0,$cdr_nmask),32,0));
$bin_first=(str_pad(substr($bin_net,0,31),32,1));
$bin_last=(str_pad(substr($bin_bcast,0,31),32,0));
$host_total=(bindec(str_pad("",(32-$cdr_nmask),1)) - 1);

if ($host_total <= 0){  //Takes care of 31 and 32 bit masks.
	$bin_first="N/A" ; $bin_last="N/A" ; $host_total="N/A";
	if ($bin_net === $bin_bcast) $bin_bcast="N/A";
}

if (ereg('^0',$bin_net)){
	$class="A";
	$dotbin_net= "<font color=\"Green\">0</font>" . substr(dotbin($bin_net,$cdr_nmask),1) ;
}

if (ereg('^10',$bin_net)){
	$class="B";
	$dotbin_net= "<font color=\"Green\">10</font>" . substr(dotbin($bin_net,$cdr_nmask),2) ;
}

if (ereg('^110',$bin_net)){
  	$class="C";
	$dotbin_net= "<font color=\"Green\">110</font>" . substr(dotbin($bin_net,$cdr_nmask),3) ;
}

if (ereg('^1110',$bin_net)){
  	$class="D";
	$dotbin_net= "<font color=\"Green\">1110</font>" . substr(dotbin($bin_net,$cdr_nmask),4) ;
	$special="<font color=\"Green\">Class D = Multicast Address Space.</font>";
}

if (ereg('^1111',$bin_net)){
  	$class="E";
	$dotbin_net= "<font color=\"Green\">1111</font>" . substr(dotbin($bin_net,$cdr_nmask),4) ;
	$special="<font color=\"Green\">Class E = Experimental Address Space.</font>";
}

if (ereg('^(00001010)|(101011000001)|(1100000010101000)',$bin_net)){
  	 $special='<a href="http://www.ietf.org/rfc/rfc1918.txt">( RFC-1918 Private Internet Address. )</a>';
}

// Print Results
print "<tr><td><font color=\"black\">Address:</font></td><td><font color=\"blue\">$dq_host".
	"</font></td><td><font color=\"brown\">".dotbin($bin_host,$cdr_nmask)."</font></td></tr>\n" ;
print "<tr><td><font color=\"black\">Netmask:</font></td><td><font color=\"blue\">".bintodq($bin_nmask).
	" = $cdr_nmask</font></td><td><font color=\"red\">".dotbin($bin_nmask, $cdr_nmask)."</font></td></tr>\n" ;
print "<tr><td><font color=\"black\">Wildcard:</font></td><td><font color=\"blue\">".bintodq($bin_wmask).
	"</font></td><td><font color=\"brown\">". dotbin($bin_wmask, $cdr_nmask) ."</font></td></tr>\n" ;
print "<tr><td><font color=\"black\">Network:</font></td><td><font color=\"blue\">".bintodq($bin_net).
	"</font></td><td><font color=\"brown\">$dotbin_net</font></td><td><font color=\"Green\">".
	"(Class $class)</font></td></tr>\n" ;
print "<tr><td><font color=\"black\">Broadcast:</font></td><td><font color=\"blue\">" . bintodq($bin_bcast).
	"</font></td><td><font color=\"brown\">". dotbin($bin_bcast, $cdr_nmask) . "</font></td></tr>\n" ;
print "<tr><td><font color=\"black\">HostMin:</font></td><td><font color=\"blue\">" . bintodq($bin_first) .
	"</font></td><td><font color=\"brown\">". dotbin($bin_first, $cdr_nmask) . "</font></td></tr>\n" ;
print "<tr><td><font color=\"black\">HostMax:</font></td><td><font color=\"blue\">" . bintodq($bin_last) .
	"</font></td><td><font color=\"brown\">" . dotbin($bin_last, $cdr_nmask) . "</font></td></tr>\n" ;
@ print "<tr><td><font color=\"black\">Hosts/Net:</font></td><td><font color=\"blue\">" . $host_total .
	"</font></td><td>$special</td></tr>\n" ;
print "$end";

function binnmtowm($binin){
	$binin=rtrim($binin, "0");
	if (!ereg("0",$binin) ){
		return str_pad(str_replace("1","0",$binin), 32, "1");
	} else return "1010101010101010101010101010101010101010";
}

function bintocdr ($binin){
	return strlen(rtrim($binin,"0"));
}

function bintodq ($binin) {
	if ($binin=="N/A") return $binin;
	$binin=explode(".", chunk_split($binin,8,"."));
	for ($i=0; $i<4 ; $i++) {
		$dq[$i]=bindec($binin[$i]);
	}
        return implode(".",$dq) ;
}

function bintoint ($binin){
        return bindec($binin);
}

function binwmtonm($binin){
	$binin=rtrim($binin, "1");
	if (!ereg("1",$binin)){
		return str_pad(str_replace("0","1",$binin), 32, "0");
	} else return "1010101010101010101010101010101010101010";
}

function cdrtobin ($cdrin){
	return str_pad(str_pad("", $cdrin, "1"), 32, "0");
}

function do_error($line){
	print '<tr><td align="left" colspan="3">';
	print $line . "</td></tr>\n";
}

function dotbin($binin,$cdr_nmask){
	// splits 32 bit bin into dotted bin octets
	if ($binin=="N/A") return $binin;
	$oct=rtrim(chunk_split($binin,8,"."),".");
	if ($cdr_nmask > 0){
		$offset=sprintf("%u",$cdr_nmask/8) + $cdr_nmask ;
		return substr($oct,0,$offset ) . "&nbsp;&nbsp;&nbsp;" . substr($oct,$offset) ;
	} else {
	return $oct;
	}
}

function dqtobin($dqin) {
        $dq = explode(".",$dqin);
        for ($i=0; $i<4 ; $i++) {
           $bin[$i]=str_pad(decbin($dq[$i]), 8, "0", STR_PAD_LEFT);
        }
        return implode("",$bin);
}

function inttobin ($intin) {
        return str_pad(decbin($intin), 32, "0", STR_PAD_LEFT);
}

?>
