{
    function createEditor(config)
    {
        var editor = null;		
        try
        {
            mxObjectCodec.allowEval = true;
            var node = mxUtils.load(config).getDocumentElement();
            editor = new mxEditor(node);
            mxObjectCodec.allowEval = false;

            // Adds active border for panning inside the container
            editor.graph.createPanningManager = function()
            {
                    var pm = new mxPanningManager(this);
                    pm.border = 3; //30;					
                    return pm;
            };				
            editor.graph.allowAutoPanning = true;
            editor.graph.timerAutoScroll = true;
        }
        catch (e)
        {
            // Shows an error message if the editor cannot start
            mxUtils.alert('Cannot start application: ' + e.message);
            throw e; // for debugging
        }
        return editor;
    }

}
