/* 
 * Copyright (c) 2006-2013, JGraph Ltd
 *
 * Defines the startup sequence of the application.
 */
{

	/**
	 * Constructs a new application (returns an mxEditor instance)
	 */
	function createEditor(config)
	{
		var editor = null;		
		try
		{
			//if (!mxClient.isBrowserSupported())
			//{
			//	mxUtils.error('Browser is not supported!', 200, false);
			//}
			//else
			//{
				mxObjectCodec.allowEval = true;
				var node = mxUtils.load(config).getDocumentElement();
				editor = new mxEditor(node);
				mxObjectCodec.allowEval = false;
				
				// Adds active border for panning inside the container
				editor.graph.createPanningManager = function()
				{
					var pm = new mxPanningManager(this);
					pm.border = 3; //30;					
					return pm;
				};				
				editor.graph.allowAutoPanning = true;
				editor.graph.timerAutoScroll = true;
			//}
		}
		catch (e)
		{
			// Shows an error message if the editor cannot start
			mxUtils.alert('Cannot start application: ' + e.message);
			throw e; // for debugging
		}

		return editor;
	}

}
