<?php
/**
 * @package         
 * @copyright       Copyright (C) 2017 MDM-IT Mariusz Dziewulski. All rights reserved.
 * @license         see LICENSE.txt
 */

    //error_reporting(0);    
    include_once("permition_app_class.php");
    $app_permit=new app_permit();
    if($app_permit->permit_module(basename(__FILE__))==='0') exit;
    include("config/config.php");
?>
<html>
<header>    
<title>NetMap4Nagios</title>
<link rel="icon" type="image/x-icon" href="js/images/globe.ico">
<link   type="text/css" href="js/jquery/css/redmond/jquery-ui.custom.css" rel="stylesheet" />
<script type="text/javascript" src="js/jquery/jquery.js"></script>
<script type="text/javascript" src="js/jquery/jquery-ui.js"></script>
<!--<link rel="stylesheet" type="text/css" href="js/dhtmlxLayout/skins/skyblue/dhtmlxlayout.css"/>-->
<link rel="stylesheet" type="text/css" href="js/dhtmlxLayout/skins/terrace/dhtmlxlayout.css"/>
<script src="js/dhtmlxLayout/codebase/dhtmlxlayout.js"></script>

<link rel="stylesheet" href="js/Zebra/css/mdmit/zebra_dialog.css" type="text/css">
<script type="text/javascript" src="js/Zebra/zebra_dialog.js"></script>
<script type="text/javascript" src="lib/mdmit_dialogs.js"></script>
<script type="text/javascript" src="lib/mdmit_lib.js"></script>
<link type="text/css" href="js/jquery_window/css/jquery.window.css" rel="stylesheet" />
<link type="text/css" href="js/jquery_window/css/mdmit_window.css" rel="stylesheet" />
<script type="text/javascript" src="js/jquery_window/jquery.window.js"></script> 
<!--<link type="text/css" href="main_window_style.css" rel="stylesheet" />-->

<style>
body {
	margin: 0 0 0 0;
	padding: 0;        
}
    
.ui-button-text {
   font-size: 0.9em !important;
   line-height: 1.2 !important;
   font-style: normal;
   font-weight: normal;
   padding: 0.2em 0.8em !important;
}
.ui-button {
   border-radius: 2px !important; 
}
</style>
</header>
    
<body onload="doOnLoad();">

<?php    
    include_once("main_window_menu.php");
    include_once("main_window_toolbar.php");
?>

<div id="main_page_id">
<table width="100%" height="92%" cellspacing="0" cellpadding="2">
    <tr>
        <td>
            <div id="layoutObj" style="height: 100%; width: 100%;"></div>
        </td>
    </tr>
</table>
</div>

<script>
var NetLayout, w_imp_hg,w_subnet_win, w_select_img,g_g_editor;
var height_c="<?php echo $height_c; ?>";
var events_on_main_page="<?php echo $events_on_main_page; ?>";

    NetLayout = new dhtmlXLayoutObject({
                                parent: "layoutObj", 
                                pattern: "2U",
                                skin: 'dhx_terrace',
                                cells: [{id: "a", header: false, text: "", width: "<?php echo $width_a  ?>"},
                                        {id: "b", header: false, text: ""}]
               });
    NetLayout.setOffsets({
                top:    "<?php echo $offset_top ?>",
                right:  "<?php echo $offset_right ?>",
                bottom: "<?php echo $offset_bottom ?>",
                left:   "<?php echo $offset_left ?>"});
    NetLayout.setAutoSize("b");
    NetLayout.attachEvent("onContentLoaded", function(id){
	NetLayout.cells("a").progressOff();
        NetLayout.cells("b").progressOff();
    });
    NetLayout.attachEvent("onPanelResizeFinish", function(){
			refresh_frames();
		});
    //NetLayout.attachStatusBar({text:"Status bar text here"});
    NetLayout.cells("a").progressOn();
    NetLayout.cells("b").progressOn();
    NetLayout.cells("a").attachURL("tree_map.php", null,true);
    NetLayout.cells("b").attachURL('netmap4nagios.php?xml='+"<?php echo $default_map ?>", null,true);
    
function doOnLoad() 
{
;
}

$(window).bind('resize', function() {
    refresh_frames();
    //$("#grid1").setGridHeight($(window).height()-200);
    //$("#grid1").setGridWidth($(window).width()-12);
}).trigger('resize');
    
$(function() {
	$("a", ".button_id").button();
});    

function import_nagios_hostgroup_cm()
{
    if(permit_app("import_hostgroup.php"))
        w_imp_hg=mdmit_run_dialog("import_hostgroup.php","Import hostgroup",490,250,"",$('#main_page_id'),'w_imp_hg',true);
}
function import_nagios_servicegroup_cm()
{
    if(permit_app("import_servicegroup.php"))
        w_imp_hg=mdmit_run_dialog("import_servicegroup.php","Import servicegroup",490,250,"",$('#main_page_id'),'w_imp_hg',true);
}
function refresh_frames()
{
    NetLayout.attachEvent("onContentLoaded", function(id){
        NetLayout.cells("a").progressOff();
    });
    NetLayout.cells("a").progressOn();        
    NetLayout.cells("a").attachURL("tree_map.php", null,true);
}
function refresh_map(url_doc)
{
    NetLayout.attachEvent("onContentLoaded", function(id){
        NetLayout.cells("b").progressOff();
    });
    NetLayout.cells("b").progressOn();        
    NetLayout.cells("b").attachURL('netmap4nagios.php?xml='+url_doc, null,true);
}

</script>
</div>

<?php
    require_once("main_window_footer_end.php");
?>
