<?php
//error_reporting(0);
include_once("config/config.php");
include_once("logs.php");

function get_interfaces($ip)
{
    //$config_f='../devices_core/config/'.$ip;
    if(trim($path_to_config_devices_files) !== '')
	$config_f=$path_to_config_devices_files.$ip;
    else $config_f='devices_core/config/'.$ip;
    write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Path to file: >'.$path_to_config_devices_files.'<'."\n");
    write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Config file: '.$config_f."\n");
    
    $lista_interfaces=get_interfaces_device($config_f);
    //write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Interfaces lista: '.$lista_interfaces."\n");
    
    return $lista_interfaces; 
}

function get_interfaces_device($config_f)
{
    $tt[]='';
    $tt_c[]='';
    $interf[]='';
    $interf_u[]='';

    //cisco
    $doc=file_get_contents($config_f);
    preg_match_all('/((interface [B,G,T,H].*))/', $doc,$tt_c);
    for($i=0; $i < count($tt_c[0]);$i++)
    {
        $aa=$tt_c[0][$i];
        $aa=str_replace('interface ','',$aa);
        $pos=strpos($aa,'.');
        $aa=trim(substr($aa,0,$pos));
        if($aa !== '') $interf[]=$aa;
    }
    sort($interf);
    if(count($interf > 0)) $interf_u = array_unique($interf);

    //juniper
    $interf[]='';
    $interf_u[]='';
    $doc=juniper_config_to_set($config_f);
    preg_match_all('/(set interfaces .*)/', $doc,$tt);
    for($i=0; $i < count($tt[0]);$i++)
    {
        $aa=$tt[0][$i];
        $aa=str_replace('set interfaces ','',$aa);
        $aa=str_replace('inactive:','',$aa);
        $aa=str_replace(' ','',$aa);
        $pos=strpos($aa,'unit');
        $aa=trim(substr($aa,0,$pos));
        if($aa !== '') $interf[]=$aa;
    }
    sort($interf);
    $interf_u = array_unique($interf);
    
    $lista_interfaces= '<option value="-">-</option>,';
    $lista_interfaces.='<option value="-">-</option>,';
    foreach($interf_u as $item) //dla petli for($i=0;$i<count($interf_u);$i++) //array_unique dziala blednie
    {
        $s_str=$item;
        write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Interface: '.$s_str."\n");
        $lista_interfaces.='<option value='.'"'.$s_str.'"'.'>'.$s_str.'</option>,';
    }
    $pos=strrpos($lista_interfaces,',');
    $lista_interfaces[$pos]=str_replace(',',' ',$lista_interfaces[$pos]);

    return $lista_interfaces;
}

function juniper_config_to_set($config_f)
{
    $doc= file_get_contents($config_f);

    $file_name=rand(0,1000);
    $file_name=dirname(__FILE__).'/tmp/'.$file_name;
    file_put_contents($file_name,$doc);

    $tree=array();
    if(file_exists($file_name))
    {
        $s_line='';
        $hw=fopen($file_name,"r");
        while($line = fgets($hw))
        { 
            if(strpos($line,'#')===0) 
            {
                continue;
            }
            $line=trim($line);
            if(preg_match('/; ##/',$line)==1) 
            {
                list($line,$comment)=preg_split('/; ##/',$line);
                $line .= ";";
            }
            if(endswith($line,';')) 
            {
                $line = rtrim($line,';');
                if(count($tree)==0) 
                {
                    $s_line.="set $line\n";
                } else 
                    {
                        $s_line.="set " . printtree($tree) . " $line\n";
                    }
            }
            if(endswith($line,'{')) 
            {
                $line = rtrim($line,' {');
                $tree=addtotree($tree,$line);
            }
            if(endswith($line,'}')) 
            {
                $tree=removewordfromtree($tree);
            }
        }
    }    
    fclose($hw);
    try
    {
        unlink($file_name);
    } catch (Exception $ex) {;}

    return $s_line;
}

function endswith($string, $test) 
{
    $strlen = strlen($string);
    $testlen = strlen($test);
    if ($testlen > $strlen) return false;
    return substr_compare($string, $test, $strlen - $testlen, $testlen) === 0;
}

function addtotree($tree,$word) 
{
	array_push($tree,$word);
	return $tree;
}

function removewordfromtree($tree) 
{
	array_pop($tree);
	return $tree;
}

function printtree($tree) 
{
	return implode(" ",$tree);
}

