<?php

function Strip($value)
{
	if(get_magic_quotes_gpc() != 0)
  	{
    	if(is_array($value))
			if ( array_is_associative($value) )
			{
				foreach( $value as $k=>$v)
					$tmp_val[$k] = stripslashes($v);
				$value = $tmp_val;
			}
			else
				for($j = 0; $j < sizeof($value); $j++)
        			$value[$j] = stripslashes($value[$j]);
		else
			$value = stripslashes($value);
	}
	return $value;
}

function array_is_associative ($array)
{
    if ( is_array($array) && ! empty($array) )
    {
        for ( $iterator = count($array) - 1; $iterator; $iterator-- )
        {
            if ( ! array_key_exists($iterator, $array) ) { return true; }
        }
        return ! array_key_exists(0, $array);
    }
    return false;
}

function sqlvalue($val, $quote)
{
  if ($quote)
    $tmp = sqlstr($val);
  else
    $tmp = $val;
  if ($tmp == "")
    $tmp = "NULL";
  elseif ($quote)
    $tmp = "'".$tmp."'";
  return $tmp;
}

function sqlstr($val)
{
  $val=str_replace('\\','',$val);
  return str_replace("'", "''", $val);
}

function constructWhere($s)
{
    $qwery = "";
	//['eq','ne','lt','le','gt','ge','bw','bn','in','ni','ew','en','cn','nc']
    $qopers = array(
		'eq'=>" = ",
		'ne'=>" <> ",
		'lt'=>" < ",
		'le'=>" <= ",
		'gt'=>" > ",
		'ge'=>" >= ",
		'bw'=>" LIKE ",
		'bn'=>" NOT LIKE ",
		'in'=>" IN ",
		'ni'=>" NOT IN ",
		'ew'=>" LIKE ",
		'en'=>" NOT LIKE ",
		'cn'=>" LIKE " ,
		'nc'=>" NOT LIKE ",
                'nn'=>" IS NOT NULL ",);
    if ($s)
    {
        $jsona = json_decode($s,true);
        if(is_array($jsona))
        {
            $gopr = $jsona['groupOp'];
            //dla jezyka polskiego
            switch ($gopr) {
               case "ORAZ": $gopr=" AND ";
                  break;
               case "LUB":  $gopr=" OR ";
                  break;
            }
            $rules = $jsona['rules'];
            $i =0;
            foreach($rules as $key=>$val)
            {
                $field = $val['field'];
                $op = $val['op'];
                $v = $val['data'];
		if($v && $op)
                {
	           $i++;
		   // ToSql in this case is absolutley needed
		   $v = ToSql($field,$op,$v);
		   if ($i == 1) $qwery = " AND ";
		   else $qwery .= " " .$gopr." ";
		   switch ($op) {
			case 'in' :
			case 'ni' :$qwery .= $field.$qopers[$op]." (".$v.")";
                              break;
                        default: $qwery .= $field.$qopers[$op].$v;
                   }
		}
            }
        }
    }
    return $qwery;
}

function getStringForGroup( $group )
{
    $i_='';
    $sopt = array(  'eq' => "=",
                    'ne' => "<>",
                    'lt' => "<",
                    'le' => "<=",
                    'gt' => ">",
                    'ge' => ">=",
                    'bw'=>" {$i_}LIKE ",
                    'bn'=>" NOT {$i_}LIKE ",
                    'in'=>' IN ',
                    'ni'=> ' NOT IN',
                    'ew'=>" {$i_}LIKE ",
                    'en'=>" NOT {$i_}LIKE ",
                    'cn'=>" {$i_}LIKE ",
                    'nc'=>" NOT {$i_}LIKE ", 
                    'nu'=>'IS NULL', 
                    'nn'=>'IS NOT NULL');
    $s = "(";
    if( isset ($group['groups']) && is_array($group['groups']) && count($group['groups']) >0 )
    {
        for($j=0; $j<count($group['groups']);$j++ )
	{
            if(strlen($s) > 1 ) 
            {
                $s .= " ".$group['groupOp']." ";
            }
            try 
            {
                $dat = getStringForGroup($group['groups'][$j]);
		$s .= $dat;
            } 
            catch (Exception $e) 
            {
                echo $e->getMessage();
            }
	}
    }
    if (isset($group['rules']) && count($group['rules'])>0 ) 
    {
        try
        {
            foreach($group['rules'] as $key=>$val) 
            {
                if (strlen($s) > 1) 
                {
                    $s .= " ".$group['groupOp']." ";
		}
		$field = $val['field'];
		$op = $val['op'];
		$v = $val['data'];
		if( $op ) 
                {
                    switch ($op)
                    {
                        case 'bw':
			case 'bn': $s .= $field.' '.$sopt[$op]."'$v%'";
				break;
			case 'ew':
			case 'en': $s .= $field.' '.$sopt[$op]."'%$v'";
				break;
			case 'cn':
			case 'nc': $s .= $field.' '.$sopt[$op]."'%$v%'";
				break;
			case 'in':
			case 'ni': $s .= $field.' '.$sopt[$op]."( '$v' )";
				break;
			case 'nu':
			case 'nn': $s .= $field.' '.$sopt[$op]." ";
				break;
			default :  $s .= $field.' '.$sopt[$op]." '$v' ";
				break;
                    }
		}
            }
	} 
        catch (Exception $e) 	
        {
            echo $e->getMessage();
	}
    }
    $s .= ")";
    if ($s == "()") 
    {
        //return array("",$prm); // ignore groups that don't have rules
        return " 1=1 ";
    } else 
        {
            return $s;;
	}
}

function ToSql ($field, $oper, $val)
{
   switch ($field) {
	case 'id':return intval($val);
		break;
	case 'amount':
	case 'tax':
	case 'total':return floatval($val);
		break;
	default :if($oper=='bw' || $oper=='bn') return "'" . addslashes($val) . "%'";
		 else if ($oper=='ew' || $oper=='en') return "'%" . addcslashes($val) . "'";
		 else if ($oper=='cn' || $oper=='nc') return "'%" . addslashes($val) . "%'";
		 else return "'" . addslashes($val) . "'";
   }
}
