<?php
require_once("../../utils.php");
require_once("../../db_class.php");
include("../../logs.php");
require("utils_gen_config.php");

    $src_d=         $_REQUEST["src_d"]; //1-rekord podstawowy, 2-subgrid
    $src=           $_REQUEST["src"];
    $rec_id=        $_REQUEST["rec_id"];
    $rec_id_p=      $_REQUEST["rec_id_p"];
    $nazwa_klienta= trim($_REQUEST["nazwa_klienta"]);
    write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Nazwa klienta: '.$nazwa_klienta."\n");
    write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' SRC_D: '.        $src_d."\n");
    write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' SRC: '.          $src."\n");
    write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' REC_ID: '.       $rec_id."\n");
    write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' REC_ID_P: '.     $rec_id_p."\n");
    //setlocale(LC_ALL, 'pl_PL');
    
    $description_a='';
    $description_b='';
    $nazwa_uslugi='';
    
    $s_params[]='';
    $zamiana=   array('@','&','+','?',' ','$','/','\\','_','(',')');
    $zamiana_d= array('@','&','+','?',' ','$','/','\\','(',')');
    $zamiana_p= array(';',',','/31','/30','/29','/28','/27');
    $zmiana_usluga=array('_(WARSZAWA)','_(DEBICA)');
    
    //Read from db record for rec id = ID = $rec_id
    if($src_d===1 || $src_d==='1')
    {        
        $db = new db_connect(__FILE__.' '.__FUNCTION__.' '.__LINE__);
        $row_k=$db->db_get_columns("core_b2b");
        $sql="SELECT $row_k FROM core_b2b WHERE id='$rec_id' ";
        write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.'  '.$sql."\n");
    } else
        if($src_d===2 || $src_d==='2')
        {
            $db = new db_connect(__FILE__.' '.__FUNCTION__.' '.__LINE__);
            $row_k=$db->db_get_columns("core_b2b_subgrid");
            $sql="SELECT $row_k FROM core_b2b_subgrid WHERE id='$rec_id' ";
            write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.'  '.$sql."\n");
        }
        
        $result = $db->db_get($sql,__FILE__.' '.__FUNCTION__.' '.__LINE__);
        $row = $db->db_fetch($result);
        
        $s_params['interface_a']=        trim($row["interface_a"]);
        $s_params['s_unit']=             trim($row["s_unit"]);
        $s_params['s_vlan']=             trim($row["s_vlan"]);
        $s_params['c_vlan']=             trim($row["c_vlan"]);
        $s_params['router_a']=           trim($row["router_a"]);        
        $s_params['miasto_a']=           trim(iconv(mb_detect_encoding($row["miasto_a"]), 'ASCII//TRANSLIT', $row["miasto_a"]));
        $s_params['ip_a']=               trim($row["ip_a"]);
        $ip_a=$s_params['ip_a'];
        $s_params['ip_p2p']=             str_replace(';','',trim($row["ip_p2p"]));
        $s_params['ip_pi']=              trim($row["ip_pi"]);
        $s_params['as_klienta']=         trim($row["as_klienta"]);
        $s_params['ip_pa']=              trim($row["ip_pa"]);
        $ip_b=$s_params['ip_b'];
        $s_params['miasto_b']=           trim(iconv(mb_detect_encoding($row["miasto_b"]), 'ASCII//TRANSLIT', $row["miasto_b"]));
        $s_params['router_b']=           trim($row["router_b"]);
        $s_params['ip_b']=               trim($row["ip_b"]);
        $s_params['interface_b']=        trim($row["interface_b"]);
        $s_params['d_unit']=             trim($row["d_unit"]);
        $s_params['d_vlan']=             trim($row["d_vlan"]);
        if($nazwa_klienta==='')
        {
            $s_params['nazwa_klienta'] = str_replace(' ','_',trim(iconv(mb_detect_encoding($row["nazwa_klienta"]), 'ASCII//TRANSLIT', $row["nazwa_klienta"])));
        } else $s_params['nazwa_klienta'] = str_replace(' ','_',trim(iconv(mb_detect_encoding($nazwa_klienta), 'ASCII//TRANSLIT', $nazwa_klienta)));
        $s_params['usluga']=             trim(str_replace(' ','_',trim(strtoupper($row["usluga"]))));
        write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Usluga 1: '.$s_params['usluga']."\n");
        $s_params['usluga']=             trim(str_replace($zmiana_usluga,'',$s_params["usluga"]));
        write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Usluga 2: '.$s_params['usluga']."\n");
        $s_params['pasmo']=              trim($row["pasmo"]);
        $s_params['router_a_typ']=       trim(strtoupper($row["router_a_typ"]));
        $s_params['router_b_typ']=       trim(strtoupper($row["router_b_typ"]));
        $s_params['template_a']=         trim($row["template_a"]);
        $s_params['template_b']=         trim($row["template_b"]);
        $s_params['logical_system_a']=   trim($row["logical_system_a"]);
        $s_params['logical_system_b']=   trim($row["logical_system_b"]);
        $s_params['description_a']=      str_replace(' ','_',trim($row["description_a"]));
        $s_params['description_b']=      str_replace(' ','_',trim($row["description_b"]));
        $s_params['id_uslugi']=          trim($row["id_uslugi"]);
        $s_params['id_uslugi_external']= trim($row["id_uslugi_external"]);
        
        //if($s_params['id_uslugi'] !== '') $s_params['id_uslugi']=$s_params['id_uslugi'].'_';
        
        $nazwa_uslugi=trim(str_replace($zmiana_d,'_',$s_params['nazwa_klienta']));
        $s_params['nazwa_uslugi_full']=$nazwa_uslugi;
        //$s_params['nazwa_uslugi']=substr($nazwa_uslugi.'_'.$s_params['usluga'],0,59); //nie moze byc dluzsze niz 50 znakow dla access list i policerow
        $s_params['nazwa_uslugi']=substr($nazwa_uslugi,0,50); //nie moze byc dluzsze niz 64 znaki dla access list i policerow
        
        write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Show rec: '.print_r($s_params)."\n");

    //}
    $description_a=$s_params['description_a'];
    $description_b=$s_params['description_b'];
        
    if($s_params['description_a']==='' || !isset($s_params['description_a'])) 
    {
        if(trim($s_params['ip_b'])==='' || trim($s_params['ip_b'])==='undefined') //|| trim($s_params['interface_b'])==='' ||  trim($s_params['d_unit'])==='')                
            $description_a=$s_params['id_uslugi'].$s_params['nazwa_klienta'].'_'.$s_params['usluga'];
        else $description_a=$s_params['nazwa_klienta'].'_'.$s_params['usluga'].'_'.$s_params['ip_b'].'_'.$s_params['interface_b'].'_'.$s_params['d_unit'].'_c_vlan_'.$s_params['d_vlan'];
    }
    if($s_params['description_b']==='' || !isset($s_params['description_b'])) 
    {
        if(trim($s_params['ip_a'])==='' || trim($s_params['ip_a'])==='undefined') // || trim($s_params['interface_b'])==='' &&  trim($s_params['d_unit'])==='')
            $description_b=$s_params['id_uslugi'].$s_params['nazwa_klienta'].'_'.$s_params['usluga'];
        else $description_b=$s_params['nazwa_klienta'].'_'.$s_params['usluga'].'_'.$s_params['ip_a'].'_'.$s_params['interface_a'].'_'.$s_params['s_unit'];
    }
    $s_params['description_a']=trim($description_a);
    $s_params['description_b']=trim($description_b);
    $s_params['description_a']=str_replace(' ','_',trim(iconv(mb_detect_encoding($s_params['description_a']), 'ASCII//TRANSLIT', $s_params['description_a']))); //juniper max 253 znaki        
    $s_params['description_b']=str_replace(' ','_',trim(iconv(mb_detect_encoding($s_params['description_b']), 'ASCII//TRANSLIT', $s_params['description_b'])));
    $s_params['description_a']=str_replace($zamiana_d,'',$s_params['description_a']);
    $s_params['description_b']=str_replace($zamiana_d,'',$s_params['description_b']);
    write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Desc A: '.$s_params['description_a']."\n");
    write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Desc B: '.$s_params['description_b']."\n");
            
    //========================================================================================================================================================================
    $conf='';
    write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Nazwa uslugi: '.$s_params['nazwa_uslugi']."\n");
    write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Usluga: '.$s_params['usluga']."\n");
    
    switch ($s_params['usluga'])
    {
        case "INTERNET":
                        $conf_juniper_a=gen_config_juniper_B2B_internet($s_params);
                        $conf_vectra_a= gen_config_via_vectra_a($s_params);

                        $conf.= $conf_juniper_a."\n\n";
                        $conf.= $conf_vectra_a."\n\n";
                        $conf.= "##############################################"."\n\n";            
            break;
            
        case "INTERNET_BGP":
                        $conf_juniper_a= gen_config_juniper_B2B_bgp($s_params);
                        $conf.= $conf_juniper_a."\n\n";
                        $conf.= $conf_vectra_a."\n\n";
                        $conf.="##############################################"."\n\n";
            break;

        case "INTERNET_BGP_DDOS":
                        $conf_juniper_a= gen_config_juniper_B2B_bgp_ddos($s_params);
                        $conf.= $conf_juniper_a."\n\n";
                        $conf.= $conf_vectra_a."\n\n";
                        $conf.="##############################################"."\n\n";
            break;

        case "INTERNET_LOKALNY":
                        if($s_params['router_a_typ'] !== 'CISCO')
                        {
                            $conf_juniper_a = gen_config_juniper_internet_lokalny($s_params);
                        } else
                            {
                                $conf_cisco_a = gen_config_cisco_internet_lokalny($s_params);
                            }
                        $conf.= $conf_juniper_a."\n\n";
                        $conf.= $conf_cisco_a."\n\n";
                        $conf.="##############################################"."\n\n";
             break;

        case "INTERNET_LOKALNY_BGP":
                        $conf_juniper_a=gen_config_juniper_B2B_lokalny_bgp($s_params);

                        $conf.= $conf_juniper_a."\n\n";
                        $conf.=$conf_cisco_a."\n\n";
                        $conf.=$conf_vectra_a."\n\n";
                        $conf.="##############################################"."\n\n";
             break;
         
        case "INTERNET_LOKALNY_BGP_DDOS":
                        $conf_juniper_a=gen_config_juniper_B2B_lokalny_bgp_ddos($s_params);
                        $conf.= $conf_juniper_a."\n\n";
                        $conf.=$conf_cisco_a."\n\n";
                        $conf.=$conf_vectra_a."\n\n";
                        $conf.="##############################################"."\n\n";
             break;

        case "XCONNECT":
                        if($s_params['router_a_typ'] !== 'CISCO')
                        {
                            $conf_juniper_a=    gen_config_juniper_xconnect_a($s_params);
                        } else $conf_cisco_a=   gen_config_cisco_xconnect_a($s_params);

                        if($s_params['router_b_typ'] !== 'CISCO')
                        {
                            $conf_juniper_b=    gen_config_juniper_xconnect_b($s_params);
                        } else $conf_cisco_b=   gen_config_cisco_xconnect_b($s_params);

                        $conf_vectra_a= gen_config_via_vectra_a($s_params);
                        $conf_vectra_b= gen_config_via_vectra_b($s_params);

                        $conf.= $conf_juniper_a."\n\n";
                        $conf.= $conf_juniper_b."\n\n";
                        $conf.= $conf_cisco_a."\n\n";
                        $conf.= $conf_cisco_b."\n\n";
                        $conf.= $conf_vectra_a."\n\n";
                        $conf.= $conf_vectra_b."\n\n";
                        $conf.= "##############################################"."\n\n";
            break;

        case "XCONNECT-Vlan":
                        if($s_params['router_a_typ'] !== 'CISCO')
                        {
                            $conf_juniper_a=    gen_config_juniper_xconnect_encaps_vlan_a($s_params);
                        } else $conf_cisco_a=   gen_config_cisco_xconnect_encaps_vlan_a($s_params);

                        if($s_params['router_b_typ'] !== 'CISCO')
                        {
                            $conf_juniper_b=    gen_config_juniper_xconnect_encaps_vlan_b($s_params);
                        } else $conf_cisco_b=   gen_config_cisco_xconnect_encaps_vlan_b($s_params);

                        $conf_vectra_a= gen_config_via_vectra_encaps_vlan_a($s_params);
                        $conf_vectra_b= gen_config_via_vectra_encaps_vlan_b($s_params);

                        $conf.= $conf_juniper_a."\n\n";
                        $conf.= $conf_juniper_b."\n\n";
                        $conf.= $conf_cisco_a."\n\n";
                        $conf.= $conf_cisco_b."\n\n";
                        $conf.= $conf_vectra_a."\n\n";
                        $conf.= $conf_vectra_b."\n\n";
                        $conf.= "##############################################"."\n\n";
            break;
            
        case "BRIDGE":
                        if($s_params['router_b_typ'] !== 'CISCO')
                        {
                            $conf_juniper_b=  gen_config_juniper_bridge($s_params);
                            $conf.=$conf_juniper_b."\n\n";
                        }
                        else
                            {
                                $conf_cisco_b=   gen_config_cisco_bridge($s_params);
                                $conf.=$conf_cisco_b."\n\n";
                            }
                        $conf.="##############################################"."\n\n";
            break;
                
        default: $conf.="# DEFAULT #############################################"."\n\n";
            break;
    }    
    
    //Send config to tmp file and window
    $ii=rand(1,1000);
    $file_name_all=             '/data/tmp/'.$ii.'_all.txt';
    $file_name_juniper_a=       '/data/tmp/'.$ii.'_juniper_a.txt';
    $file_name_juniper_b=       '/data/tmp/'.$ii.'_juniper_b.txt';
    $file_name_cisco=           '/data/tmp/'.$ii.'_cisco.txt';
    $file_name_cisco_a=         '/data/tmp/'.$ii.'_cisco_a.txt';
    $file_name_cisco_b=         '/data/tmp/'.$ii.'_cisco_b.txt';
    $file_name_vectra_a=        '/data/tmp/'.$ii.'_vectra_a.txt';
    $file_name_vectra_b=        '/data/tmp/'.$ii.'_vectra_b.txt';
    $conf_all = $conf;
    
    write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Gen_file rand: '.$ii.' = '.$file_name_all."\n");
    if($src===1 || $src==='1')
    {
        write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Conf: '.          $conf_all."\n");
        write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Conf juniper_a: '.$conf_juniper_a."\n");
        write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Conf juniper_b: '.$conf_juniper_b."\n");
        write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Conf cisco_a: '.  $conf_cisco_a."\n");
        write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Conf cisco_b: '.  $conf_cisco_b."\n");
        write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Conf vectra_a: '. $conf_vectra_a."\n");
        write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Conf vectra_b: '. $conf_vectra_b."\n");
        
        //$ff_all=            file_put_contents($file_name_all,nl2br(htmlentities($conf)));
                                        
        $ff_juniper_a=      file_put_contents($file_name_juniper_a,$conf_juniper_a);
        $ff_juniper_b=      file_put_contents($file_name_juniper_b,$conf_juniper_b);
        $ff_cisco_a=        file_put_contents($file_name_cisco_a,$conf_cisco_a);
        $ff_cisco_b=        file_put_contents($file_name_cisco_b,$conf_cisco_b);
        $ff_vectra_a=       file_put_contents($file_name_vectra_a,$conf_vectra_a);
        $ff_vectra_b=       file_put_contents($file_name_vectra_b,$conf_vectra_b);
        
        $ff_all=            file_put_contents($file_name_all,($conf_all));
        
        $router_a=  $s_params['router_a'];
        $miasto_a=  $s_params['miasto_a'];
        $ip_a=      $s_params['ip_a'];
        
        $miasto_b=  $s_params['miasto_b'];
        $router_b=  $s_params['router_b'];
        $ip_b=      $s_params['ip_b'];
        
        write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Gen_file: '.$ff_all.' = '.$file_name_all."\n");
        echo nl2br(htmlentities($conf_all)).'||'.$file_name_all.'||'.$file_name_peer.'||'.$file_name_juniper_a.'||'.$file_name_juniper_b.'||'.$file_name_cisco_a.'||'.$file_name_cisco_b.'||'.$file_name_vectra_a.'||'.$file_name_vectra_b.'||'.$file_name_peer_b.'||'.$miasto_a.'||'.$router_a.'||'.$ip_a.'||'.$miasto_b.'||'.$router_b.'||'.$ip_b.'||'.$file_name_intercon254_20.'||'.$file_name_intercon254_25.'||'.$file_name_intercon233_20;
    } else
        {
            write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Conf: '.             $conf_all."\n");
            write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Conf juniper_a: '.   $conf_juniper_a."\n");
            write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Conf juniper_b: '.   $conf_juniper_b."\n");
            write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Conf cisco_a: '.     $conf_cisco_a."\n");
            write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Conf cisco_b: '.     $conf_cisco_b."\n");
            write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Conf vectra_a: '.    $conf_vectra_a."\n");
            write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Conf vectra_b: '.    $conf_vectra_b."\n");        

            write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Conf:  '.            $conf."\n");
            //$ff=file_put_contents($file_name,htmlentities($conf));
            
            $ff_juniper_a=      file_put_contents($file_name_juniper_a,$conf_juniper_a);
            $ff_juniper_b=      file_put_contents($file_name_juniper_b,$conf_juniper_b);
            $ff_cisco_a=        file_put_contents($file_name_cisco_a,$conf_cisco_a);
            $ff_cisco_b=        file_put_contents($file_name_cisco_b,$conf_cisco_b);
            $ff_vectra_a=       file_put_contents($file_name_vectra_a,$conf_vectra_a);
            $ff_vectra_b=       file_put_contents($file_name_vectra_b,$conf_vectra_b);

            $ff_all=file_put_contents($file_name,($conf_all));
            
            $router_a=  $s_params['router_a'];
            $miasto_a=  $s_params['miasto_a'];
            $ip_a=      $s_params['ip_a'];
        
            $miasto_b=  $s_params['miasto_b'];
            $router_b=  $s_params['router_b'];
            $ip_b=      $s_params['ip_b'];

            write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Gen_file: '.$ff_all.' = '.$file_name_all."\n");
            echo nl2br(htmlentities($conf_all)).'||'.$file_name_all.'||'.$file_name_peer.'||'.$file_name_juniper_a.'||'.$file_name_juniper_b.'||'.$file_name_cisco_a.'||'.$file_name_cisco_b.'||'.$file_name_vectra_a.'||'.$file_name_vectra_b.'||'.$file_name_peer_b.'||'.$miasto_a.'||'.$router_a.'||'.$ip_a.'||'.$miasto_b.'||'.$router_b.'||'.$ip_b.'||'.$file_name_intercon254_20.'||'.$file_name_intercon254_25.'||'.$file_name_intercon233_20;
        }

//=================================================================================================================================


function gen_config_juniper_B2B_internet($s_params)  //router B2B Warszawa
{
    $ip_p2p=str_replace($zamiana_p,'',$s_params['ip_p2p']);
    $ip_p2p_mask=trim(get_ip_p2p_mask($s_params['ip_p2p']));
    $ip_p2p_1=str_replace($zamiana_p,'',trim(get_ip_p2p_1($s_params['ip_p2p'])));
    $ip_p2p_2=str_replace($zamiana_p,'',trim(get_ip_p2p_2($s_params['ip_p2p'])));
    $ip_pa=   get_ip_pa($s_params['ip_pa']);
    $download=trim(get_download($s_params['pasmo']));
    $burst_d=(int)($download/10);
    $upload=  trim(get_upload($s_params['pasmo']));
    $burst_u=(int)($upload/10);
    
    $arp_policer='';
    $arp_policer.='set firewall policer ARP-LIMIT if-exceeding bandwidth-limit 8k'."\n";
    $arp_policer.='set firewall policer ARP-LIMIT if-exceeding burst-size-limit 1500'."\n";
    $arp_policer.='set firewall policer ARP-LIMIT then discard'."\n";
    
    $conf='';
    $conf.="#####################################################################"."\n";
    $conf.="##### B2B -- ".$s_params['miasto_a']."  ---  ".$s_params['ip_a']." --- ".$s_params['router_a']."\n\n";
    $conf.="##### B2B - policer #######################################################"."\n";
    
    $conf.="set ".$s_params['logical_system_a']." firewall policer ".'Biznes_download_'.$download." if-exceeding bandwidth-limit ".$download."m"."\n";
    if($burst_d !== 0) $conf.="set ".$s_params['logical_system_a']." firewall policer ".'Biznes_download_'.$download." if-exceeding burst-size-limit ".$burst_d."m"."\n";
    else $conf.="set ".$s_params['logical_system_a']." firewall policer ".'Biznes_download_'.$download." if-exceeding burst-size-limit ".'1'."m"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall policer ".'Biznes_download_'.$download." then discard"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall policer ".'Biznes_upload_'.$upload." if-exceeding bandwidth-limit ".$upload."m"."\n";
    if($burst_u !== 0) $conf.="set ".$s_params['logical_system_a']." firewall policer ".'Biznes_upload_'.$upload." if-exceeding burst-size-limit ".$burst_u."m"."\n";
    else $conf.="set ".$s_params['logical_system_a']." firewall policer ".'Biznes_upload_'.$upload." if-exceeding burst-size-limit ".'1'."m"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall policer ".'Biznes_upload_'.$upload." then discard"."\n";
            
    return $conf;
}

//=================================================================================================================================

function gen_config_juniper_B2B_bgp($s_params)
{
    $ip_p2p=str_replace($zamiana_p,'',$s_params['ip_p2p']);
    $ip_p2p_mask=trim(get_ip_p2p_mask($s_params['ip_p2p']));
    $ip_p2p_1=str_replace($zamiana_p,'',trim(get_ip_p2p_1($s_params['ip_p2p'])));
    $ip_p2p_2=str_replace($zamiana_p,'',trim(get_ip_p2p_2($s_params['ip_p2p'])));    
    $ip_pa=   get_ip_pa($s_params['ip_pa']);  //w przypadku BGP adresy PA nie powinny istniec
    $ip_pi=   get_ip_pi($s_params['ip_pi']);
    $download=trim(get_download($s_params['pasmo']));
    $burst_d=(int)($download/10);
    $upload=  trim(get_upload($s_params['pasmo']));
    $burst_u=(int)($upload/10);
    $as_k=$s_params['as_klienta'];
        
    $arp_policer='';
    $arp_policer.='set firewall policer ARP-LIMIT if-exceeding bandwidth-limit 8k'."\n";
    $arp_policer.='set firewall policer ARP-LIMIT if-exceeding burst-size-limit 1500'."\n";
    $arp_policer.='set firewall policer ARP-LIMIT then discard'."\n";
    
    //Normalna konfiguracja dla polaczeniowki
    $conf='';
    $conf.="##########################################################################################"."\n";
    $conf.="##### B2B -- ".$s_params['miasto_a']."  ---  ".$s_params['ip_a']." --- ".$s_params['router_a']."\n\n";    
    $conf.="##### B2B - policer ###################################################################################################"."\n";
        
    $conf.="set ".$s_params['logical_system_a']." firewall policer ".'Biznes_download_'.$download." if-exceeding bandwidth-limit ".$download."m"."\n";
    if($burst_d !== 0) $conf.="set ".$s_params['logical_system_a']." firewall policer ".'Biznes_download_'.$download." if-exceeding burst-size-limit ".$burst_d."m"."\n";
    else $conf.="set ".$s_params['logical_system_a']." firewall policer ".'Biznes_download_'.$download." if-exceeding burst-size-limit ".'1'."m"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall policer ".'Biznes_download_'.$download." then discard"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall policer ".'Biznes_upload_'.$upload." if-exceeding bandwidth-limit ".$upload."m"."\n";
    if($burst_u !== 0) $conf.="set ".$s_params['logical_system_a']." firewall policer ".'Biznes_upload_'.$upload." if-exceeding burst-size-limit ".$burst_u."m"."\n";
    else $conf.="set ".$s_params['logical_system_a']." firewall policer ".'Biznes_upload_'.$upload." if-exceeding burst-size-limit ".'1'."m"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall policer ".'Biznes_upload_'.$upload." then discard"."\n";
            
    //$conf.=gen_interconnect_B2B_bgp($s_params)    
    return $conf;
}


function gen_config_juniper_B2B_lokalny_bgp($s_params)
{
    $ip_p2p=str_replace($zamiana_p,'',$s_params['ip_p2p']);
    $ip_p2p_mask=trim(get_ip_p2p_mask($s_params['ip_p2p']));
    $ip_p2p_1=str_replace($zamiana_p,'',trim(get_ip_p2p_1($s_params['ip_p2p'])));
    $ip_p2p_2=str_replace($zamiana_p,'',trim(get_ip_p2p_2($s_params['ip_p2p'])));    
    //$ip_pa=   get_ip_pa($s_params['ip_pa']);  //w przypadku BGP adresy PA nie powinny istniec
    $ip_pi=   get_ip_pi($s_params['ip_pi']);
    $download=trim(get_download($s_params['pasmo']));
    $burst_d=(int)($download/10);
    $upload=  trim(get_upload($s_params['pasmo']));
    $burst_u=(int)($upload/10);
    
    //Normalna konfiguracja dla polaczeniowki
    $conf='';
    $conf.="##########################################################################################"."\n";
    $conf.="##### B2B -- ".$s_params['miasto_a']."  ---  ".$s_params['ip_a']." --- ".$s_params['router_a']."\n\n";
    $conf.="##### B2B - policer ###################################################################################################"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."-IN if-exceeding bandwidth-limit ".$download."m"."\n";
    if($burst_d !== 0) $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."-IN if-exceeding burst-size-limit ".$burst_d."m"."\n";
    else $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."-IN if-exceeding burst-size-limit ".'1'."m"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."-IN then discard"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."-OUT if-exceeding bandwidth-limit ".$upload."m"."\n";
    if($burst_u !== 0) $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."-OUT if-exceeding burst-size-limit ".$burst_u."m"."\n";
    else $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."-OUT if-exceeding burst-size-limit ".'1'."m"."\n";    
    $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."-OUT then discard"."\n";

    return $conf;
}

//===========================================================================================================================================================================================
function gen_config_juniper_b($s_params)
{
    $ip_p2p=str_replace($zamiana_p,'',$s_params['ip_p2p']);
    $ip_p2p_mask=trim(get_ip_p2p_mask($s_params['ip_p2p']));
    $ip_p2p_1=str_replace($zamiana_p,'',trim(get_ip_p2p_1($s_params['ip_p2p'])));
    $ip_p2p_2=str_replace($zamiana_p,'',trim(get_ip_p2p_2($s_params['ip_p2p'])));
    $ip_pa=   get_ip_pa($s_params['ip_pa']);
    $download=trim(get_download($s_params['pasmo']));
    $burst_d=(int)($download/10);
    $upload=  trim(get_upload($s_params['pasmo']));
    $burst_u=(int)($upload/10);
    
    return $conf;
}
//========================================================================================================================================================================================================
function gen_config_juniper_xconnect_a($s_params)
{
    $download=trim(get_download($s_params['pasmo']));
    $burst_d=(int)($download/10);
    $upload=  trim(get_upload($s_params['pasmo']));
    $burst_u=(int)($upload/10);

    $conf='';
    $conf.="#### Router A ".$s_params['miasto_a']." --- ".$s_params['ip_a']."  -- ".$s_params['router_a']." ############################"."\n\n";
    
    $conf.="set ".$s_params['logical_system_a']." firewall policer "."Biznes_L2_download_".$download." if-exceeding bandwidth-limit ".$download."m"."\n";
    if($burst_d !== 0) $conf.="set ".$s_params['logical_system_a']." firewall policer "."Biznes_L2_download_".$download." if-exceeding burst-size-limit ".$burst_d."m"."\n";
    else $conf.="set ".$s_params['logical_system_a']." firewall policer "."Biznes_L2_download_".$download." if-exceeding burst-size-limit ".'1'."m"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall policer "."Biznes_L2_download_".$download." then discard"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall policer "."Biznes_L2_upload_".$upload." if-exceeding bandwidth-limit ".$upload."m"."\n";
    if($burst_u !== 0) $conf.="set ".$s_params['logical_system_a']." firewall policer "."Biznes_L2_upload_".$upload." if-exceeding burst-size-limit ".$burst_u."m"."\n";
    else $conf.="set ".$s_params['logical_system_a']." firewall policer "."Biznes_L2_upload_".$upload." if-exceeding burst-size-limit ".'1'."m"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall policer "."Biznes_L2_upload_".$upload." then discard"."\n";

    $conf.="\n\n";
        
    return $conf;
}

function gen_config_juniper_xconnect_encaps_vlan_a($s_params)
{
    $download=trim(get_download($s_params['pasmo']));
    $burst_d=(int)($download/10);
    $upload=  trim(get_upload($s_params['pasmo']));
    $burst_u=(int)($upload/10);

    $conf='';
    $conf.="#### Router A ".$s_params['miasto_a']." --- ".$s_params['ip_a']."  -- ".$s_params['router_a']." ############################"."\n\n";    
    $conf.="set ".$s_params['logical_system_a']." firewall policer "."Biznes_L2_download_".$download." if-exceeding bandwidth-limit ".$download."m"."\n";
    if($burst_d !== 0) $conf.="set ".$s_params['logical_system_a']." firewall policer "."Biznes_L2_download_".$download." if-exceeding burst-size-limit ".$burst_d."m"."\n";
    else $conf.="set ".$s_params['logical_system_a']." firewall policer "."Biznes_L2_download_".$download." if-exceeding burst-size-limit ".'1'."m"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall policer "."Biznes_L2_download_".$download." then discard"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall policer "."Biznes_L2_upload_".$upload." if-exceeding bandwidth-limit ".$upload."m"."\n";
    if($burst_u !== 0) $conf.="set ".$s_params['logical_system_a']." firewall policer "."Biznes_L2_upload_".$upload." if-exceeding burst-size-limit ".$burst_u."m"."\n";
    else $conf.="set ".$s_params['logical_system_a']." firewall policer "."Biznes_L2_upload_".$upload." if-exceeding burst-size-limit ".'1'."m"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall policer "."Biznes_L2_upload_".$upload." then discard"."\n";

    $conf.="\n\n";
        
    return $conf;
}

function gen_config_juniper_xconnect_b($s_params)
{
    $download=trim(get_download($s_params['pasmo']));
    $burst_d=(int)($download/10);
    $upload=  trim(get_upload($s_params['pasmo']));
    $burst_u=(int)($upload/10);    
    
    if($d_unit==='') $d_unit=$s_params['s_unit'];
    if($d_vlan==='') $d_vlan=$s_params['c_vlan'];

    $conf.="set ".$s_params['logical_system_b']." firewall policer "."Biznes_L2_download_".$download." if-exceeding bandwidth-limit ".$download."m"."\n";
    if($burst_d !== 0) $conf.="set ".$s_params['logical_system_b']." firewall policer "."Biznes_L2_download_".$download." if-exceeding burst-size-limit ".$burst_d."m"."\n";
    else $conf.="set ".$s_params['logical_system_b']." firewall policer "."Biznes_L2_download_".$download." if-exceeding burst-size-limit ".'1'."m"."\n";
    $conf.="set ".$s_params['logical_system_b']." firewall policer "."Biznes_L2_download_".$download." then discard"."\n";
    $conf.="set ".$s_params['logical_system_b']." firewall policer "."Biznes_L2_upload_".$upload." if-exceeding bandwidth-limit ".$upload."m"."\n";
    if($burst_u !== 0) $conf.="set ".$s_params['logical_system_b']." firewall policer "."Biznes_L2_upload_".$upload." if-exceeding burst-size-limit ".$burst_u."m"."\n";
    else $conf.="set ".$s_params['logical_system_b']." firewall policer "."Biznes_L2_upload_".$upload." if-exceeding burst-size-limit ".'1'."m"."\n";
    $conf.="set ".$s_params['logical_system_b']." firewall policer "."Biznes_L2_upload_".$upload." then discard"."\n";

    $conf.="\n\n";

    return $conf;
}

function gen_config_juniper_xconnect_encaps_vlan_b($s_params)
{
    $download=trim(get_download($s_params['pasmo']));
    $burst_d=(int)($download/10);
    $upload=  trim(get_upload($s_params['pasmo']));
    $burst_u=(int)($upload/10);    
    
    $conf='';
    $conf.="#### Router B ".$s_params['miasto_b']." ---  ".$s_params['ip_b']." -- ".$s_params['router_b']." ##########################"."\n\n";
    $conf.="set ".$s_params['logical_system_b']." firewall policer "."Biznes_L2_download_".$download." if-exceeding bandwidth-limit ".$download."m"."\n";
    if($burst_d !== 0) $conf.="set ".$s_params['logical_system_b']." firewall policer "."Biznes_L2_download_".$download." if-exceeding burst-size-limit ".$burst_d."m"."\n";
    else $conf.="set ".$s_params['logical_system_b']." firewall policer "."Biznes_L2_download_".$download." if-exceeding burst-size-limit ".'1'."m"."\n";
    $conf.="set ".$s_params['logical_system_b']." firewall policer "."Biznes_L2_download_".$download." then discard"."\n";
    $conf.="set ".$s_params['logical_system_b']." firewall policer "."Biznes_L2_upload_".$upload." if-exceeding bandwidth-limit ".$upload."m"."\n";
    if($burst_u !== 0) $conf.="set ".$s_params['logical_system_b']." firewall policer "."Biznes_L2_upload_".$upload." if-exceeding burst-size-limit ".$burst_u."m"."\n";
    else $conf.="set ".$s_params['logical_system_b']." firewall policer "."Biznes_L2_upload_".$upload." if-exceeding burst-size-limit ".'1'."m"."\n";
    $conf.="set ".$s_params['logical_system_b']." firewall policer "."Biznes_L2_upload_".$download." then discard"."\n";

    $conf.="\n\n";
    return $conf;
}

function gen_config_cisco_tr($s_params)
{
    $download=trim(get_download($s_params['pasmo']));
    $upload=  trim(get_upload($s_params['pasmo']));    

    $s_vlan=$s_params['s_vlan'];
    if($s_vlan==='') $s_vlan=$s_params['c_vlan']; //konieczne dla zwyklego tranzytu
    $conf='';
    $conf.="!!!! Router CISCO B ".$s_params['ip_b']." --- ".$s_params['router_b']."\n\n";
    
    $conf.="interface ".$s_params['interface_b'].'.'.$s_vlan." l2transport"."\n";
    $conf.="    description ".$s_params['description_a']."\n";
    $conf.="    encapsulation dot1q ".$s_params['c_vlan']."\n";
    $conf.="    mtu 9014"."\n";
    $conf.="    rewrite ingress tag pop 1 symmetric"."\n";
    $conf.="    service-policy input ".$s_params['nazwa_uslugi']."_IN"."\n";
    $conf.="    service-policy output ".$s_params['nazwa_uslugi']."_OUT"."\n";
    $conf.="exit"."\n";
    $conf.="\n\n";
    
    $conf.="policy-map ".$s_params['nazwa_uslugi']."_IN"."\n";
    $conf.="    class class-default"."\n";
    $conf.="    police rate ".$download." mbps"."\n";
    $conf.="end-policy-map"."\n";
    $conf.="\n\n";
    
    $conf.="policy-map ".$s_params['nazwa_uslugi']."_OUT"."\n";
    $conf.="    class class-default"."\n";
    $conf.="    police rate ".$upload." mbps"."\n";
    $conf.="end-policy-map"."\n";

    return $conf;
}

function gen_config_cisco_xconnect_a($s_params)
{
    $download=trim(get_download($s_params['pasmo']));
    $upload=  trim(get_upload($s_params['pasmo']));    
    
    $s_vlan=$s_params['c_vlan'];
    if($s_vlan==='') $s_vlan=$s_params['c_vlan']; //konieczne dla zwyklego tranzytu
    $conf='';
    $conf.="!!!! Router CISCO A ".$s_params['ip_a']." --- ".$s_params['router_a']."\n\n";
    
    $conf.="interface ".$s_params['interface_a'].'.'.$s_params['c_vlan']." l2transport"."\n";
    $conf.="    description ".$s_params['description_a']."\n";
    $conf.="    encapsulation dot1q ".$s_params['c_vlan']."\n";
    $conf.="    mtu 9014"."\n";
    $conf.="    rewrite ingress tag pop 1 symmetric"."\n";
    $conf.="    service-policy input ".$s_params['nazwa_uslugi']."_IN"."\n";
    $conf.="    service-policy output ".$s_params['nazwa_uslugi']."_OUT"."\n";
    $conf.="exit"."\n";
    $conf.="\n\n";
    
    $conf.="policy-map ".$s_params['nazwa_uslugi']."_IN"."\n";
    $conf.="    class class-default"."\n";
    $conf.="    police rate ".$download." mbps"."\n";
    $conf.="end-policy-map"."\n";
    $conf.="\n\n";
    
    $conf.="policy-map ".$s_params['nazwa_uslugi']."_OUT"."\n";
    $conf.="    class class-default"."\n";
    $conf.="    police rate ".$upload." mbps"."\n";
    $conf.="end-policy-map"."\n";

    $conf.="\n\n";

    $conf.="l2vpn"."\n";
    $conf.="    pw-class ptp_B2B_vlan_".$s_params['c_vlan']."\n";
    $conf.="    encapsulation mpls"."\n";
    $conf.="    control-word"."\n";    
    $conf.="    protocol ldp"."\n";
    $conf.="    !transport-mode vlan"."\n";
    $conf.="    transport-mode ethernet"."\n";
    $conf.="exit"."\n";
    $conf.="exit"."\n";
    $conf.="exit"."\n";
    
    $conf.="l2vpn"."\n";
    $conf.="    xconnect group ptp_B2B_vlan_".$s_params['c_vlan']."\n";
    $conf.="    p2p ptp_B2B_vlan_".$s_params['c_vlan']."\n";
    $conf.="    interface ".$s_params['interface_a'].'.'.$s_params['c_vlan']."\n";
    $conf.="    neighbor ipv4 ".$s_params['router_b']." pw-id ".$s_params['c_vlan']."\n";
    $conf.="        pw-class ptp_B2B_vlan_".$s_params['c_vlan']."\n";
    $conf.="        exit"."\n";
    $conf.="    exit"."\n";
    $conf.="exit"."\n";
    $conf.="exit"."\n";
    $conf.="\n\n";
    
    return $conf;
}

function gen_config_cisco_xconnect_encaps_vlan_a($s_params)
{
    $download=trim(get_download($s_params['pasmo']));
    $upload=  trim(get_upload($s_params['pasmo']));    
    
    $s_vlan=$s_params['c_vlan'];
    if($s_vlan==='') $s_vlan=$s_params['c_vlan']; //konieczne dla zwyklego tranzytu
    $conf='';
    $conf.="!!!! Router CISCO A ".$s_params['ip_a']." --- ".$s_params['router_a']."\n\n";
    
    $conf.="interface ".$s_params['interface_a'].'.'.$s_params['c_vlan']." l2transport"."\n";
    $conf.="    description ".$s_params['description_a']."\n";
    $conf.="    encapsulation dot1q ".$s_params['c_vlan']."\n";
    $conf.="    mtu 9014"."\n";
    $conf.="    rewrite ingress tag pop 1 symmetric"."\n";
    $conf.="    service-policy input ".$s_params['nazwa_uslugi']."_IN"."\n";
    $conf.="    service-policy output ".$s_params['nazwa_uslugi']."_OUT"."\n";
    $conf.="exit"."\n";
    $conf.="\n\n";
    
    $conf.="policy-map ".$s_params['nazwa_uslugi']."_IN"."\n";
    $conf.="    class class-default"."\n";
    $conf.="    police rate ".$download." mbps"."\n";
    $conf.="end-policy-map"."\n";
    $conf.="\n\n";
    
    $conf.="policy-map ".$s_params['nazwa_uslugi']."_OUT"."\n";
    $conf.="    class class-default"."\n";
    $conf.="    police rate ".$upload." mbps"."\n";
    $conf.="end-policy-map"."\n";

    $conf.="\n\n";

    $conf.="l2vpn"."\n";
    $conf.="    pw-class ptp_B2B_vlan_".$s_params['c_vlan']."\n";
    $conf.="    encapsulation mpls"."\n";
    $conf.="    control-word"."\n";    
    $conf.="    protocol ldp"."\n";
    $conf.="    transport-mode vlan"."\n";
    $conf.="    !transport-mode ethernet"."\n";
    $conf.="exit"."\n";
    $conf.="exit"."\n";
    $conf.="exit"."\n";
    
    $conf.="l2vpn"."\n";
    $conf.="    xconnect group ptp_B2B_vlan_".$s_params['c_vlan']."\n";
    $conf.="    p2p ptp_B2B_vlan_".$s_params['c_vlan']."\n";
    $conf.="    interface ".$s_params['interface_a'].'.'.$s_params['c_vlan']."\n";
    $conf.="    neighbor ipv4 ".$s_params['router_b']." pw-id ".$s_params['c_vlan']."\n";
    $conf.="        pw-class ptp_B2B_vlan_".$s_params['c_vlan']."\n";
    $conf.="        exit"."\n";
    $conf.="    exit"."\n";
    $conf.="exit"."\n";
    $conf.="exit"."\n";
    $conf.="\n\n";
    
    return $conf;
}

function gen_config_cisco_xconnect_b($s_params)
{
    $download=trim(get_download($s_params['pasmo']));
    $upload=  trim(get_upload($s_params['pasmo']));    
    
    $s_vlan=$s_params['c_vlan'];
    if($s_vlan==='') $s_vlan=$s_params['c_vlan']; //konieczne dla zwyklego tranzytu
    $conf='';
    $conf.="!!!! Router CISCO B ".$s_params['ip_b']." --- ".$s_params['router_b']."\n\n";
    
    $conf.="interface ".$s_params['interface_b'].'.'.$s_params['c_vlan']." l2transport"."\n";
    $conf.="    description ".$s_params['description_b']."\n";
    $conf.="    encapsulation dot1q ".$s_params['c_vlan']."\n";
    $conf.="    mtu 9014"."\n";
    $conf.="    rewrite ingress tag pop 1 symmetric"."\n";
    $conf.="    service-policy input ".$s_params['nazwa_uslugi']."_IN"."\n";
    $conf.="    service-policy output ".$s_params['nazwa_uslugi']."_OUT"."\n";
    $conf.="exit"."\n";
    $conf.="\n\n";
    
    $conf.="policy-map ".$s_params['nazwa_uslugi']."_IN"."\n";
    $conf.="    class class-default"."\n";
    $conf.="    police rate ".$download." mbps"."\n";
    $conf.="end-policy-map"."\n";
    $conf.="\n\n";
    
    $conf.="policy-map ".$s_params['nazwa_uslugi']."_OUT"."\n";
    $conf.="    class class-default"."\n";
    $conf.="    police rate ".$upload." mbps"."\n";
    $conf.="end-policy-map"."\n";

    $conf.="\n\n";

    $conf.="l2vpn"."\n";
    $conf.="    pw-class ptp_B2B_vlan_".$s_params['c_vlan']."\n";
    $conf.="    encapsulation mpls"."\n";
    $conf.="    control-word"."\n";    
    $conf.="    protocol ldp"."\n";
    $conf.="    !transport-mode vlan"."\n";
    $conf.="    transport-mode ethernet"."\n";
    $conf.="exit"."\n";
    
    $conf.="l2vpn"."\n";
    $conf.="    xconnect group ptp_B2B_vlan_".$s_params['c_vlan']."\n";
    $conf.="    p2p ptp_B2B_vlan_".$s_params['c_vlan']."\n";
    $conf.="    interface ".$s_params['interface_b'].'.'.$s_params['c_vlan']."\n";
    $conf.="    neighbor ipv4 ".$s_params['router_a']." pw-id ".$s_params['c_vlan']."\n";
    $conf.="        pw-class ptp_B2B_vlan_".$s_params['c_vlan']."\n";
    $conf.="        exit"."\n";
    $conf.="    exit"."\n";
    $conf.="exit"."\n";
    $conf.="exit"."\n";
    $conf.="\n\n";
    
    return $conf;
}

function gen_config_cisco_xconnect_encaps_vlan_b($s_params)
{
    $download=trim(get_download($s_params['pasmo']));
    $upload=  trim(get_upload($s_params['pasmo']));    
    
    $s_vlan=$s_params['s_vlan'];
    if($s_vlan==='') $s_vlan=$s_params['c_vlan']; //konieczne dla zwyklego tranzytu
    $conf='';
    $conf.="!!!! Router CISCO B ".$s_params['ip_b']." --- ".$s_params['router_b']."\n\n";
    
    $conf.="interface ".$s_params['interface_b'].'.'.$s_params['c_vlan']." l2transport"."\n";
    $conf.="    description ".$s_params['description_b']."\n";
    $conf.="    encapsulation dot1q ".$s_params['c_vlan']."\n";
    $conf.="    mtu 9014"."\n";
    $conf.="    rewrite ingress tag pop 1 symmetric"."\n";
    $conf.="    service-policy input ".$s_params['nazwa_uslugi']."_IN"."\n";
    $conf.="    service-policy output ".$s_params['nazwa_uslugi']."_OUT"."\n";
    $conf.="exit"."\n";
    $conf.="\n\n";
    
    $conf.="policy-map ".$s_params['nazwa_uslugi']."_IN"."\n";
    $conf.="    class class-default"."\n";
    $conf.="    police rate ".$download." mbps"."\n";
    $conf.="end-policy-map"."\n";
    $conf.="\n\n";
    
    $conf.="policy-map ".$s_params['nazwa_uslugi']."_OUT"."\n";
    $conf.="    class class-default"."\n";
    $conf.="    police rate ".$upload." mbps"."\n";
    $conf.="end-policy-map"."\n";

    $conf.="\n\n";

    $conf.="l2vpn"."\n";
    $conf.="    pw-class ptp_B2B_vlan_".$s_params['c_vlan']."\n";
    $conf.="    encapsulation mpls"."\n";
    $conf.="    control-word"."\n";    
    $conf.="    protocol ldp"."\n";
    $conf.="    transport-mode vlan"."\n";
    $conf.="    !transport-mode ethernet"."\n";
    $conf.="exit"."\n";
    
    $conf.="l2vpn"."\n";
    $conf.="    xconnect group ptp_B2B_vlan_".$s_params['c_vlan']."\n";
    $conf.="    p2p ptp_B2B_vlan_".$s_params['c_vlan']."\n";
    $conf.="    interface ".$s_params['interface_b'].'.'.$s_params['c_vlan']."\n";
    $conf.="    neighbor ipv4 ".$s_params['router_a']." pw-id ".$s_params['c_vlan']."\n";
    $conf.="        pw-class ptp_B2B_vlan_".$s_params['c_vlan']."\n";
    $conf.="        exit"."\n";
    $conf.="    exit"."\n";
    $conf.="exit"."\n";
    $conf.="exit"."\n";
    $conf.="\n\n";
    
    return $conf;
}
//=======================================================================================================================================================================================================

function gen_config_juniper_internet_lokalny($s_params)
{
    $ip_p2p=str_replace($zamiana_p,'',$s_params['ip_p2p']);
    $ip_p2p_mask=trim(get_ip_p2p_mask($s_params['ip_p2p']));
    $ip_p2p_1=str_replace($zamiana_p,'',trim(get_ip_p2p_1($s_params['ip_p2p'])));
    $ip_p2p_2=str_replace($zamiana_p,'',trim(get_ip_p2p_2($s_params['ip_p2p'])));
    $ip_pa=   get_ip_pa($s_params['ip_pa']);
    $download=trim(get_download($s_params['pasmo']));
    $burst_d=(int)($download/10);
    $upload=  trim(get_upload($s_params['pasmo']));
    $burst_u=(int)($upload/10);
    
    $conf='';
    $conf.="#####################################################################"."\n";
    $conf.="##### B2B -- ".$s_params['miasto_a']."  ---  ".$s_params['ip_a']." --- ".$s_params['router_a']."\n\n";    
    $conf.="set ".$s_params['logical_system_b']." firewall policer "."Biznes_L2_download_".$download." if-exceeding bandwidth-limit ".$download."m"."\n";
    if($burst_d !== 0) $conf.="set ".$s_params['logical_system_b']." firewall policer "."Biznes_L2_download_".$download." if-exceeding burst-size-limit ".$burst_d."m"."\n";
    else $conf.="set ".$s_params['logical_system_b']." firewall policer "."Biznes_L2_download_".$download." if-exceeding burst-size-limit ".'1'."m"."\n";
    $conf.="set ".$s_params['logical_system_b']." firewall policer "."Biznes_L2_download_".$download." then discard"."\n";
    $conf.="set ".$s_params['logical_system_b']." firewall policer "."Biznes_L2_upload_".$upload." if-exceeding bandwidth-limit ".$upload."m"."\n";
    if($burst_u !== 0) $conf.="set ".$s_params['logical_system_b']." firewall policer "."Biznes_L2_upload_".$upload." if-exceeding burst-size-limit ".$burst_u."m"."\n";
    else $conf.="set ".$s_params['logical_system_b']." firewall policer "."Biznes_L2_upload_".$upload." if-exceeding burst-size-limit ".'1'."m"."\n";
    $conf.="set ".$s_params['logical_system_b']." firewall policer "."Biznes_L2_upload_".$upload." then discard"."\n";
        
    return $conf;
}

function gen_config_juniper_B2B_bgp_ddos($s_params)
{
    $ip_p2p=str_replace($zamiana_p,'',$s_params['ip_p2p']);
    $ip_p2p_mask=trim(get_ip_p2p_mask($s_params['ip_p2p']));
    $ip_p2p_1=str_replace($zamiana_p,'',trim(get_ip_p2p_1($s_params['ip_p2p'])));
    $ip_p2p_2=str_replace($zamiana_p,'',trim(get_ip_p2p_2($s_params['ip_p2p'])));
    //$ip_pa=   get_ip_pa($s_params['ip_pa']);  //w przypadku BGP adresy PA nie powinny istniec
    $ip_pi=   get_ip_pi($s_params['ip_pi']);
    
    $download=trim(get_download($s_params['pasmo']));
    $burst_d=(int)($download/10);
    $upload=  trim(get_upload($s_params['pasmo']));
    $burst_u=(int)($upload/10);
    
    //Normalna konfiguracja dla polaczeniowki
    $conf='';
    $conf.="#####################################################################"."\n";
    $conf.="##### B2B -- ".$s_params['miasto_a']."  ---  ".$s_params['ip_a']." --- ".$s_params['router_a']."\n\n";
    $conf.="##### B2B - policer"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-IN if-exceeding bandwidth-limit ".$download."m"."\n";
    if($burst_d !== 0) $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-IN if-exceeding burst-size-limit ".$burst_d."m"."\n";
    else $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-IN if-exceeding burst-size-limit ".'1'."m"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-IN then discard"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-OUT if-exceeding bandwidth-limit ".$upload."m"."\n";
    if($burst_u !== 0) $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-OUT if-exceeding burst-size-limit ".$burst_u."m"."\n";
    else $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-OUT if-exceeding burst-size-limit ".'1'."m"."\n";    
    $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-OUT then discard"."\n";
    
    return $conf;
}

function gen_config_juniper_B2B_lokalny_bgp_ddos($s_params)
{
    $ip_p2p=str_replace($zamiana_p,'',$s_params['ip_p2p']);
    $ip_p2p_mask=trim(get_ip_p2p_mask($s_params['ip_p2p']));
    $ip_p2p_1=str_replace($zamiana_p,'',trim(get_ip_p2p_1($s_params['ip_p2p'])));
    $ip_p2p_2=str_replace($zamiana_p,'',trim(get_ip_p2p_2($s_params['ip_p2p'])));
    //$ip_pa=   get_ip_pa($s_params['ip_pa']);  //w przypadku BGP adresy PA nie powinny istniec
    $ip_pi=   get_ip_pi($s_params['ip_pi']);
    
    $download=trim(get_download($s_params['pasmo']));
    $burst_d=(int)($download/10);
    $upload=  trim(get_upload($s_params['pasmo']));
    $burst_u=(int)($upload/10);
    
    //Normalna konfiguracja dla polaczeniowki
    $conf='';
    $conf.="#####################################################################"."\n";
    $conf.="##### B2B -- ".$s_params['miasto_a']."  ---  ".$s_params['ip_a']." --- ".$s_params['router_a']."\n\n";
    $conf.="##### B2B - policer"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-IN if-exceeding bandwidth-limit ".$download."m"."\n";
    if($burst_d !== 0) $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-IN if-exceeding burst-size-limit ".$burst_d."m"."\n";
    else $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-IN if-exceeding burst-size-limit ".'1'."m"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-IN then discard"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-OUT if-exceeding bandwidth-limit ".$upload."m"."\n";
    if($burst_u !== 0) $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-OUT if-exceeding burst-size-limit ".$burst_u."m"."\n";
    else $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-OUT if-exceeding burst-size-limit ".'1'."m"."\n";    
    $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-OUT then discard"."\n";

    return $conf;
}
//======================================================================================================================================================================================================
function gen_config_via_vectra_a_bgp($s_params)
{
    $ip_p2p=str_replace($zamiana_p,'',$s_params['ip_p2p']);
    $ip_p2p_mask=trim(get_ip_p2p_mask($s_params['ip_p2p']));
    $ip_p2p_1=str_replace($zamiana_p,'',trim(get_ip_p2p_1($s_params['ip_p2p'])));
    $ip_p2p_2=str_replace($zamiana_p,'',trim(get_ip_p2p_2($s_params['ip_p2p'])));
    //$ip_pa=   get_ip_pa($s_params['ip_pa']);  //w przypadku BGP adresy PA nie powinny istniec
    $ip_pi=   get_ip_pi($s_params['ip_pi']);
    
    $download=trim(get_download($s_params['pasmo']));
    $burst_d=(int)($download/10);
    $upload=  trim(get_upload($s_params['pasmo']));
    $burst_u=(int)($upload/10);
    
    $conf='';
    $conf.="!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n\n";
    $conf.="!!!! Router CISCO A VECTRA Warszawa Pereca ".$s_params['ip_a']." --- ".$s_params['router_a']."\n\n";
    
    $s_vlan=$s_params['s_vlan'];
    if($s_vlan==='') $s_vlan=$s_params['c_vlan']; //konieczne dla zwyklego tranzytu
    $conf.="interface ".$s_params['interface_b'].'.'.$s_vlan." l2transport"."\n";
    $conf.="    description Biznes-MMP-".$s_params['miasto_b']."-QinQ"."\n";
    $conf.="    encapsulation dot1q ".$s_vlan." second-dot1q ".$s_params['c_vlan']."\n";
    $conf.="    mtu 2004"."\n";
    $conf.="    rewrite ingress tag pop 1 symmetric"."\n";
    $conf.="    service-policy input marker_BE"."\n";
    //$conf.="    service-policy output ".$s_params['nazwa_uslugi']."_OUT"."\n";
    $conf.="exit"."\n";
    $conf.="\n\n";
    
    $conf.="l2vpn"."\n";
    $conf.="    xconnect group BE30_".$s_vlan."_651501246"."\n";
    $conf.="    p2p EoMPLS_ELINE_vlan".$s_vlan."\n";
    $conf.="    interface ".$s_params['interface_b'].'.'.$s_vlan."\n";
    $conf.="    neighbor ipv4 172.17.17.150 pw-id 65150".$s_vlan."\n";
    //$conf.="    neighbor ipv4 89.228.0.50 pw-id ".$s_vlan."\n";
    $conf.="        pw-class fat-pw"."\n";
    $conf.="        exit"."\n";
    $conf.="    exit"."\n";
    $conf.="exit"."\n";
    $conf.="exit"."\n";
    $conf.="\n\n";
    
    return $conf;
}


function gen_config_via_vectra_a_lokalny_bgp($s_params)
{
    $ip_p2p=str_replace($zamiana_p,'',$s_params['ip_p2p']);
    $ip_p2p_mask=trim(get_ip_p2p_mask($s_params['ip_p2p']));
    $ip_p2p_1=str_replace($zamiana_p,'',trim(get_ip_p2p_1($s_params['ip_p2p'])));
    $ip_p2p_2=str_replace($zamiana_p,'',trim(get_ip_p2p_2($s_params['ip_p2p'])));
    //$ip_pa=   get_ip_pa($s_params['ip_pa']);  //w przypadku BGP adresy PA nie powinny istniec
    $ip_pi=   get_ip_pi($s_params['ip_pi']);
    
    $download=trim(get_download($s_params['pasmo']));
    $burst_d=(int)($download/10);
    $upload=  trim(get_upload($s_params['pasmo']));
    $burst_u=(int)($upload/10);
    
    $conf='';
    $conf.="!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n\n";
    $conf.="!!!! Router CISCO A VECTRA Warszawa Pereca ".$s_params['ip_a']." --- ".$s_params['router_a']."\n\n";
    
    $s_vlan=$s_params['s_vlan'];
    if($s_vlan==='') $s_vlan=$s_params['c_vlan']; //konieczne dla zwyklego tranzytu
    $conf.="interface ".$s_params['interface_b'].'.'.$s_vlan." l2transport"."\n";
    $conf.="    description Biznes-MMP-".$s_params['miasto_b']."-QinQ"."\n";
    $conf.="    encapsulation dot1q ".$s_vlan." second-dot1q ".$s_params['c_vlan']."\n";
    $conf.="    mtu 2004"."\n";
    $conf.="    rewrite ingress tag pop 1 symmetric"."\n";
    $conf.="    service-policy input marker_BE"."\n";
    //$conf.="    service-policy output ".$s_params['nazwa_uslugi']."_OUT"."\n";
    $conf.="exit"."\n";
    $conf.="\n\n";
    
    $conf.="l2vpn"."\n";
    $conf.="    xconnect group BE30_".$s_vlan."_651501246"."\n";
    $conf.="    p2p EoMPLS_ELINE_vlan".$s_vlan."\n";
    $conf.="    interface ".$s_params['interface_b'].'.'.$s_vlan."\n";
    $conf.="    neighbor ipv4 172.17.17.150 pw-id 65150".$s_vlan."\n";
    //$conf.="    neighbor ipv4 89.228.0.50 pw-id ".$s_vlan."\n";
    $conf.="        pw-class fat-pw"."\n";
    $conf.="        exit"."\n";
    $conf.="    exit"."\n";
    $conf.="exit"."\n";
    $conf.="exit"."\n";
    $conf.="\n\n";
    
    return $conf;
}


function gen_config_via_vectra_a($s_params)
{
    $download=trim(get_download($s_params['pasmo']));
    $upload=  trim(get_upload($s_params['pasmo']));    
    
    $conf='';
    $conf.="!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n\n";
    $conf.="!!!! Router CISCO A VECTRA TRANZYT Warszawa Pereca ".$s_params['ip_a']." --- ".$s_params['router_a']."\n\n";
    
    $s_vlan=$s_params['s_vlan'];
    if($s_vlan==='') $s_vlan=$s_params['c_vlan']; //konieczne dla zwyklego tranzytu
    $conf.="interface ".$s_params['interface_b'].'.'.$s_vlan." l2transport"."\n";
    $conf.="    description Biznes-MMP-".$s_params['miasto_b']."-QinQ"."\n";
    $conf.="    encapsulation dot1q ".$s_vlan." second-dot1q ".$s_params['c_vlan']."\n";
    $conf.="    mtu 2004"."\n";
    $conf.="    rewrite ingress tag pop 1 symmetric"."\n";
    $conf.="    service-policy input marker_BE"."\n";
    //$conf.="    service-policy output ".$s_params['nazwa_uslugi']."_OUT"."\n";
    $conf.="exit"."\n";
    $conf.="\n\n";
    
    $conf.="l2vpn"."\n";
    $conf.="    xconnect group BE30_".$s_vlan."_651501246"."\n";
    $conf.="    p2p EoMPLS_ELINE_vlan".$s_vlan."\n";
    $conf.="    interface ".$s_params['interface_b'].'.'.$s_vlan."\n";
    $conf.="    neighbor ipv4 172.17.17.150 pw-id 65150".$s_vlan."\n";
    //$conf.="    neighbor ipv4 89.228.0.50 pw-id ".$s_vlan."\n";
    $conf.="        pw-class fat-pw"."\n";
    $conf.="        exit"."\n";
    $conf.="    exit"."\n";
    $conf.="exit"."\n";
    $conf.="exit"."\n";
    $conf.="\n\n";
    
    return $conf;
}

function gen_config_via_vectra_b($s_params)
{
    $download=trim(get_download($s_params['pasmo']));
    $upload=  trim(get_upload($s_params['pasmo']));    
    
    $conf='';
    $conf.="!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n\n";
    $conf.="!!!! Router CISCO B VECTRA -- ".$s_params['ip_b']." --- ".$s_params['router_b']."\n\n";
    
    $s_vlan=$s_params['s_vlan'];
    if($s_vlan==='') $s_vlan=$s_params['c_vlan']; //konieczne dla zwyklego tranzytu
    $conf.="interface ".$s_params['interface_b'].'.'.$s_vlan." l2transport"."\n";
    $conf.="    description Biznes-MMP-".$s_params['miasto_b']."-QinQ"."\n";
    $conf.="    encapsulation dot1q ".$s_vlan." second-dot1q ".$s_params['c_vlan']."\n";
    $conf.="    mtu 2004"."\n";
    $conf.="    rewrite ingress tag pop 1 symmetric"."\n";
    $conf.="    service-policy input marker_BE"."\n";
    //$conf.="    service-policy output ".$s_params['nazwa_uslugi']."_OUT"."\n";
    $conf.="exit"."\n";
    $conf.="\n\n";
    
    $conf.="l2vpn"."\n";
    $conf.="    xconnect group BE30_".$s_vlan."_651501246"."\n";
    $conf.="    p2p EoMPLS_ELINE_vlan".$s_vlan."\n";
    $conf.="    interface ".$s_params['interface_b'].'.'.$s_vlan."\n";
    $conf.="    neighbor ipv4 172.17.17.150 pw-id 65150".$s_vlan."\n";
    //$conf.="    neighbor ipv4 89.228.0.50 pw-id ".$s_vlan."\n";
    $conf.="        pw-class fat-pw"."\n";
    $conf.="        exit"."\n";
    $conf.="    exit"."\n";
    $conf.="exit"."\n";
    $conf.="exit"."\n";
    $conf.="\n\n";
    
    return $conf;
}
//===============================================================================================================================================================================================
function gen_config_cisco_internet_lokalny($s_params)
{
    $ip_p2p=str_replace($zamiana_p,'',$s_params['ip_p2p']);
    $ip_p2p_mask=trim(get_ip_p2p_mask($s_params['ip_p2p']));
    $ip_p2p_1=str_replace($zamiana_p,'',trim(get_ip_p2p_1($s_params['ip_p2p'])));
    $ip_p2p_2=str_replace($zamiana_p,'',trim(get_ip_p2p_2($s_params['ip_p2p'])));
    $ip_pa=   get_ip_pa($s_params['ip_pa']);
    $download=trim(get_download($s_params['pasmo']));
    $burst_d=(int)($download/10);
    $upload=  trim(get_upload($s_params['pasmo']));
    $burst_u=(int)($upload/10);
        
    $conf='';
    $conf.="!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n\n";
    $conf.="!!!! Router CISCO B -- ".$s_params['ip_a']." --- ".$s_params['router_a']."\n\n";
        
    $conf.="interface ".$s_params['interface_a'].'.'.$s_params['s_unit']."\n";
    $conf.="    description ".$s_params['description_a']."\n";
    $conf.="    encapsulation dot1q ".$s_params['c_vlan']."\n";
    //$conf.="    mtu 9014"."\n";
    $conf.="    ipv4 address ".$ip_p2p_1." 255.255.255.252"."\n";
    $conf.="    service-policy input ". $s_params['nazwa_uslugi']."_IN"."\n";
    $conf.="    service-policy output ".$s_params['nazwa_uslugi']."_OUT"."\n";
    $conf.="    ipv4 access-group ". $s_params['nazwa_uslugi']."_IN ingress"."\n";
    $conf.="    ipv4 access-group  ".$s_params['nazwa_uslugi']."_OUT egress"."\n";
    $conf.="exit"."\n";
    $conf.="\n\n";
    
    $conf.="policy-map ".$s_params['nazwa_uslugi']."_IN"."\n";
    $conf.="    class class-default"."\n";
    $conf.="    police rate ".$download." mbps"."\n";
    $conf.="end-policy-map"."\n";
    $conf.="\n\n";
    
    $conf.="policy-map ".$s_params['nazwa_uslugi']."_OUT"."\n";
    $conf.="    class class-default"."\n";
    $conf.="    police rate ".$upload." mbps"."\n";
    $conf.="end-policy-map"."\n";
    $conf.="\n\n";
    
    $conf.="!!!!! B2B - access list IN"."\n";
    $conf.="ipv4 access-list ".$s_params['nazwa_uslugi']."_IN"."\n";
    $conf.="    permit icmp any host ".$ip_p2p_1."\n";
    $conf.="    deny tcp any host ".$ip_p2p_1."\n";
    //$conf.="    deny udp any host ".$ip_p2p_1." eq snmp"."\n";
    $conf.="    deny ipv4 any 10.0.0.0 0.255.255.255"."\n";
    $conf.="    deny ipv4 any 192.168.0.0 0.0.255.255"."\n";
    $conf.="    deny ipv4 any 172.16.0.0 0.15.255.255"."\n";
    $conf.="    permit ipv4 ".$ip_p2p." 0.0.0.3 any"."\n";
    $conf.="exit"."\n";
        
    if(count($ip_pa) >0)
    {
        if($ip_pa[0] !== '')
        {
            $conf.="!!!! B2B - adresacja PA"."\n";
            for($i=0;$i<count($ip_pa);$i++)
            {        
                if(trim(str_replace(' ','',$ip_pa[$i])) !== '') $conf.="permit ipv4 ".trim(str_replace(' ','',$ip_pa[$i]))." 0.0.0.7"." any"."\n";
            }
        }
    }
    $conf.="    deny ipv4 any any"."\n";
    $conf.="\n\n";

    $conf.="!!!!! B2B - access list OUT"."\n";
    $conf.="ipv4 access-list ".$s_params['nazwa_uslugi']."_OUT"."\n";
    $conf.="    permit ipv4 any ".$ip_p2p.' 0.0.0.3'."\n";    
    if(count($ip_pa) >0)
    {
        for($i=0;$i<count($ip_pa);$i++)
        {        
            if(trim(str_replace(' ','',$ip_pa[$i])) !== '') $conf.="  permit ipv4 ".$ip_pa.' 0.0.0.7'." any"."\n";  //do przeliczenia maska odwrotna dla ip pa
        }
    }
    $conf.="    deny ipv4 any any"."\n";
    $conf.="\n\n";

    if(count($ip_pa) >0)
    {
        if($ip_pa[0] !== '')
        {
            $conf.="!!!! B2B - adresacja PA"."\n";
            for($i=0;$i<count($ip_pa);$i++)
            {        
                if(trim(str_replace(' ','',$ip_pa[$i])) !== '')
                {
                    $conf.="router static"."\n";
                    $conf.="address-family ipv4 unicast"."\n";
                    $conf.=trim(str_replace(' ','',$ip_pa[$i])).' '.$ip_p2p_2." description ".$s_params['nazwa_uslugi']."\n";
                }
            }
        }
    }

    //czasem ospf
    $conf.="!!! Czasem rozgloszenie przez OSPF - nalezy sprawdzic na konkretnym routerze"."\n";
    $conf.="router ospf 10"."\n";
    $conf.="  area 0"."\n";
    $conf.="   interface ".$s_params['interface_a'].".".$s_params['s_unit']."\n";
    $conf.="exit"."\n";
    $conf.="exit"."\n";

    $conf.="\n\n";
    
    return $conf;
}

function gen_config_cisco($s_params)
{
    $c_vlans_zakres=find_c_vlans($s_params,$s_params['router_b_typ']); //szuka konfiguracji vlanow interfejsu cisco B
    $c_vlan_s=$c_vlans_zakres;
    
    $conf='';
    $conf.="!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n\n";
    $conf.="!!!! Router CISCO B -- ".$s_params['ip_b']." --- ".$s_params['router_b'].'  '.$s_params['router_b_typ']."\n\n";    
    $conf.="!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n\n";
    $s_vlan=$s_params['s_vlan'];
    if($s_params['s_vlan']==='') $s_vlan=$s_params['c_vlan']; //konieczne dla zwyklego tranzytu
    $conf.="interface ".$s_params['interface_b'].'.'.$s_vlan." l2transport"."\n";
    //$conf.="    encapsulation dot1q ".$c_vlan_s.', '.$s_params['c_vlan']."\n";  //pełna linia z encapsulacją jest zwracana przez funkcję "find_c_vlan". Możliwe, że w linii jest nie tylko 'encapsulation dot1q ...'
    $conf.=$c_vlan_s.', '.$s_params['c_vlan']."\n";
    $conf.="exit"."\n\n\n";
    write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Conf 1: '.  $c_vlan_s);
    write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Conf 2: '.  $conf);
    $conf.="!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!";    
    
    return $conf;
}


function gen_config_juniper_bridge($s_params)
{
    $download=trim(get_download($s_params['pasmo']));
    $burst_d=(int)($download/10);
    $upload=  trim(get_upload($s_params['pasmo']));
    $burst_u=(int)($upload/10);

    $conf='';

    $conf.="#### Router Interface 1: ".$s_params['interface_a']." miasto: ".$s_params['miasto_a']." --- ".$s_params['ip_a']."  -- ".$s_params['router_a']." ############################"."\n\n";
    
    $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-IN if-exceeding bandwidth-limit ".$download."m"."\n";
    if($burst_d !== 0) $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-IN if-exceeding burst-size-limit ".$burst_d."m"."\n";
    else $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-IN if-exceeding burst-size-limit ".'1'."m"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-IN then discard"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-OUT if-exceeding bandwidth-limit ".$upload."m"."\n";
    if($burst_u !== 0) $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-OUT if-exceeding burst-size-limit ".$burst_u."m"."\n";
    else $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-OUT if-exceeding burst-size-limit ".'1'."m"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-OUT then discard"."\n";
    
    $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-IN if-exceeding bandwidth-limit ".$download."m"."\n";
    if($burst_d !== 0) $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-IN if-exceeding burst-size-limit ".$burst_d."m"."\n";
    else $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-IN if-exceeding burst-size-limit ".'1'."m"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-IN then discard"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-OUT if-exceeding bandwidth-limit ".$upload."m"."\n";
    if($burst_u !== 0) $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-OUT if-exceeding burst-size-limit ".$burst_u."m"."\n";
    else $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-OUT if-exceeding burst-size-limit ".'1'."m"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-OUT then discard"."\n";

    $conf.="\n";

    return $conf;
}

function gen_config_cisco_bridge($s_params)
{
    $download=trim(get_download($s_params['pasmo']));
    $burst_d=(int)($download/10);
    $upload=  trim(get_upload($s_params['pasmo']));
    $burst_u=(int)($upload/10);
    
    $s_unit=$s_params['s_unit'];
    if($s_unit==='') $s_unit=$s_params['c_vlan']; //konieczne dla zwyklego tranzytu
    $conf='';
    $conf.="!!!! Router CISCO 1 ".$s_params['ip_a']." --- ".$s_params['router_a']."\n\n";
    
    $conf.="interface ".$s_params['interface_a'].'.'.$s_unit." l2transport"."\n";
    $conf.="    description ".$s_params['description_a']."\n";
    $conf.="    encapsulation dot1q ".$s_params['c_vlan']."\n";
    $conf.="    mtu 2000"."\n";
    $conf.="    rewrite ingress tag pop 1 symmetric"."\n";
    $conf.="    service-policy input ".$s_params['nazwa_uslugi']."_IN"."\n";
    $conf.="    service-policy output ".$s_params['nazwa_uslugi']."_OUT"."\n";
    $conf.="exit"."\n";
    $conf.="\n\n";
    
    $conf.="policy-map ".$s_params['nazwa_uslugi']."_IN"."\n";
    $conf.="    class class-default"."\n";
    $conf.="    police rate ".$download." mbps"."\n";
    $conf.="end-policy-map"."\n";
    $conf.="\n\n";
    
    $conf.="policy-map ".$s_params['nazwa_uslugi']."_OUT"."\n";
    $conf.="    class class-default"."\n";
    $conf.="    police rate ".$upload." mbps"."\n";
    $conf.="end-policy-map"."\n";

    $conf.="\n\n";
    
    $conf.="!!!! Router CISCO 2 ".$s_params['ip_a']." --- ".$s_params['router_a']."\n\n";
    
    $conf.="interface ".$s_params['interface_b'].'.'.$s_unit." l2transport"."\n";
    $conf.="    description ".$s_params['description_b']."\n";
    $conf.="    encapsulation dot1q ".$s_params['c_vlan']."\n";
    $conf.="    mtu 2000"."\n";
    $conf.="    rewrite ingress tag pop 1 symmetric"."\n";
    $conf.="    service-policy input ".$s_params['nazwa_uslugi']."_IN"."\n";
    $conf.="    service-policy output ".$s_params['nazwa_uslugi']."_OUT"."\n";
    $conf.="exit"."\n";
    $conf.="\n\n";
    
    $conf.="l2vpn"."\n";
    //$conf.="    bridge group ptp_B2B_vlan_".$s_vlan."\n";
    $conf.="    bridge group MM"."\n";
    $conf.="    bridge-domain Vlan".$s_unit."\n";
    $conf.="        interface ".$s_params['interface_a'].'.'.$s_vlan."\n";
    $conf.="        interface ".$s_params['interface_b'].'.'.$s_vlan."\n";
    $conf.="    exit"."\n";
    $conf.="exit"."\n";
    $conf.="exit"."\n";
    $conf.="\n\n";
    
    $conf.="\n\n";

    return $conf;
}
//=================================================================================================================================================
function gen_config_juniper_switching($s_params)
{
    $conf='';

    $conf.="#### JUNIPER ".$s_params['ip_a']."\n\n";
    
    $conf.="set vlans v".$s_params['c_vlan']." vlan-id ".$s_params['c_vlan']."\n";
    $conf.="set protocols vstp vlan ".$s_params['c_vlan']."\n";
    
    $conf.="set "." interfaces ".$s_params['interface_a']." unit 0 family ethernet-switching vlan members ".$s_params['c_vlan']."\n";
    $conf.="set "." interfaces ".$s_params['interface_b']." unit 0 family ethernet-switching vlan members ".$s_params['c_vlan']."\n";

    $conf.="\n";

    return $conf;
}

function gen_config_cisco_switching($s_params)
{
    $conf='';
    $conf.="!!!! CISCO ".$s_params['ip_a']."\n\n";
    
    //Create vlan
    $conf.="vlan ".$s_params['c_vlan']."\n";
    $conf.="    name ".$s_params['description_a']."\n";
    
    //Configure interface a
    $conf.="interface ".$s_params['interface_a'].'.'.$s_params['c_vlan']."\n";
    //$conf.="    description ".$s_params['description_a']."\n";
    $conf.="    switchport trunk allowed vlan add ".$s_params['c_vlan']."\n";
    $conf.="exit"."\n";
    
    //Config interface b
    $conf.="interface ".$s_params['interface_b'].'.'.$s_params['c_vlan']."\n";
    //$conf.="    description ".$s_params['description_b']."\n";
    $conf.="    switchport trunk allowed vlan add ".$s_params['c_vlan']."\n";
    $conf.="exit"."\n";
        
    $conf.="\n";

    return $conf;
}

//-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

?>
