<?php
require_once("utils.php");
require_once("db_class.php");
include("logs.php");
require("utils_gen_config.php");

    $src_d=         $_REQUEST["src_d"]; //1-rekord podstawowy, 2-subgrid
    $src=           $_REQUEST["src"];
    $rec_id=        $_REQUEST["rec_id"];
    $rec_id_p=      $_REQUEST["rec_id_p"];
    $nazwa_klienta= trim($_REQUEST["nazwa_klienta"]);
    $migracja=      $_REQUEST["migracja"]; //0-nie, 1-tak
    
    $mtu_juniper=   9000;
    $mtu_cisco=     9018;
    
    write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Nazwa klienta: '.$nazwa_klienta."\n");
    write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' SRC_D: '.        $src_d."\n");
    write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' SRC: '.          $src."\n");
    write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' REC_ID: '.       $rec_id."\n");
    write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' REC_ID_P: '.     $rec_id_p."\n");
    //setlocale(LC_ALL, 'pl_PL');
    
    $description_a='';
    $description_b='';
    $nazwa_uslugi='';
    
    $s_params[]='';
    $zamiana=   array('@','&','+','?',' ','$','/','\\','_','(',')');
    $zamiana_d= array('@','&','+','?',' ','$','/','\\','(',')');
    $zamiana_p= array(';',',','/31','/30','/29','/28','/27','/26','/25','/24','/23','/22','/21','/20','/19','/18','/17','/16','/15','/14','/13','/12','/11','/10');
    $zmiana_usluga=array('_(WARSZAWA)','_(DEBICA)');
    
    //Read from db record for rec id = ID = $rec_id
    if($src_d===1 || $src_d==='1')
    {        
        $db = new db_connect(__FILE__.' '.__FUNCTION__.' '.__LINE__);
        $row_k=$db->db_get_columns("core_b2b");
        $sql="SELECT $row_k FROM core_b2b WHERE id='$rec_id' ";
        write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.'  '.$sql."\n");
    } else
        if($src_d===2 || $src_d==='2')
        {
            $db = new db_connect(__FILE__.' '.__FUNCTION__.' '.__LINE__);
            $row_k=$db->db_get_columns("core_b2b_subgrid");
            $sql="SELECT $row_k FROM core_b2b_subgrid WHERE id='$rec_id' ";
            write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.'  '.$sql."\n");
        }   
        
    $result = $db->db_get($sql,__FILE__.' '.__FUNCTION__.' '.__LINE__);
    $row = $db->db_fetch($result);
    
    $s_params['interface_a']=        trim($row["interface_a"]);
    $s_params['s_unit']=             trim($row["s_unit"]);
    $s_params['s_vlan']=             trim($row["s_vlan"]);
    $s_params['c_vlan']=             trim($row["c_vlan"]);
    $s_params['router_a']=           trim($row["router_a"]);        
    $s_params['miasto_a']=           trim(iconv(mb_detect_encoding($row["miasto_a"]), 'ASCII//TRANSLIT', $row["miasto_a"]));
    $s_params['ip_a']=               trim($row["ip_a"]);
    $ip_a=$s_params['ip_a'];
    $s_params['ip_p2p']=             str_replace(';','',trim($row["ip_p2p"]));
    $s_params['ip_pi']=              trim($row["ip_pi"]);
    $s_params['as_klienta']=         trim($row["as_klienta"]);
    $s_params['ip_pa']=              trim($row["ip_pa"]);
    $ip_b=$s_params['ip_b'];
    $s_params['miasto_b']=           trim(iconv(mb_detect_encoding($row["miasto_b"]), 'ASCII//TRANSLIT', $row["miasto_b"]));
    $s_params['router_b']=           trim($row["router_b"]);
    $s_params['ip_b']=               trim($row["ip_b"]);
    $s_params['interface_b']=        trim($row["interface_b"]);
    $s_params['d_unit']=             trim($row["d_unit"]);
    $s_params['d_vlan']=             trim($row["d_vlan"]);
    if($nazwa_klienta==='')
    {
        $s_params['nazwa_klienta'] = str_replace(' ','_',trim(iconv(mb_detect_encoding($row["nazwa_klienta"]), 'ASCII//TRANSLIT', $row["nazwa_klienta"])));
    } else $s_params['nazwa_klienta'] = str_replace(' ','_',trim(iconv(mb_detect_encoding($nazwa_klienta), 'ASCII//TRANSLIT', $nazwa_klienta)));
    $s_params['usluga']=             trim(str_replace(' ','_',trim(strtoupper($row["usluga"]))));
    write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Usluga 1: '.$s_params['usluga']."\n");
    $s_params['usluga']=             trim(str_replace($zmiana_usluga,'',$s_params["usluga"]));
    write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Usluga 2: '.$s_params['usluga']."\n");
    $s_params['pasmo']=              trim($row["pasmo"]);
    $s_params['router_a_typ']=       trim(strtoupper($row["router_a_typ"]));
    $s_params['router_b_typ']=       trim(strtoupper($row["router_b_typ"]));
    $s_params['template_a']=         trim($row["template_a"]);
    $s_params['template_b']=         trim($row["template_b"]);
    $s_params['logical_system_a']=   trim($row["logical_system_a"]);
    $s_params['logical_system_b']=   trim($row["logical_system_b"]);
    $s_params['description_a']=      str_replace(' ','_',trim($row["description_a"]));
    $s_params['description_b']=      str_replace(' ','_',trim($row["description_b"]));
    $s_params['id_uslugi']=          trim($row["id_uslugi"]);
    $s_params['id_uslugi_external']= trim($row["id_uslugi_external"]);
    
    //if($s_params['id_uslugi'] !== '') $s_params['id_uslugi']=$s_params['id_uslugi'].'_';
    
    $nazwa_uslugi=trim(str_replace($zmiana_d,'_',$s_params['nazwa_klienta']));
    $s_params['nazwa_uslugi_full']=$nazwa_uslugi;
    //$s_params['nazwa_uslugi']=substr($nazwa_uslugi.'_'.$s_params['usluga'],0,59); //nie moze byc dluzsze niz 50 znakow dla access list i policerow
    $s_params['nazwa_uslugi']=substr($nazwa_uslugi,0,50); //nie moze byc dluzsze niz 64 znaki dla access list i policerow
    
    write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Show rec: '.print_r($s_params,$migracja)."\n");

    //}
    $description_a=$s_params['description_a'];
    $description_b=$s_params['description_b'];
        
    if($s_params['description_a']==='' || !isset($s_params['description_a'])) 
    {
        if(trim($s_params['ip_b'])==='' || trim($s_params['ip_b'])==='undefined') //|| trim($s_params['interface_b'])==='' ||  trim($s_params['d_unit'])==='')                
            $description_a=$s_params['id_uslugi'].$s_params['nazwa_klienta'].'_'.$s_params['usluga'];
        else $description_a=$s_params['nazwa_klienta'].'_'.$s_params['usluga'].'_'.$s_params['ip_b'].'_'.$s_params['interface_b'].'_'.$s_params['d_unit'].'_c_vlan_'.$s_params['d_vlan'];
    }
    if($s_params['description_b']==='' || !isset($s_params['description_b'])) 
    {
        if(trim($s_params['ip_a'])==='' || trim($s_params['ip_a'])==='undefined') // || trim($s_params['interface_b'])==='' &&  trim($s_params['d_unit'])==='')
            $description_b=$s_params['id_uslugi'].$s_params['nazwa_klienta'].'_'.$s_params['usluga'];
        else $description_b=$s_params['nazwa_klienta'].'_'.$s_params['usluga'].'_'.$s_params['ip_a'].'_'.$s_params['interface_a'].'_'.$s_params['s_unit'];
    }
    $s_params['description_a']=trim($description_a);
    $s_params['description_b']=trim($description_b);
    $s_params['description_a']=str_replace(' ','_',trim(iconv(mb_detect_encoding($s_params['description_a']), 'ASCII//TRANSLIT', $s_params['description_a']))); //juniper max 253 znaki        
    $s_params['description_b']=str_replace(' ','_',trim(iconv(mb_detect_encoding($s_params['description_b']), 'ASCII//TRANSLIT', $s_params['description_b'])));
    $s_params['description_a']=str_replace($zamiana_d,'',$s_params['description_a']);
    $s_params['description_b']=str_replace($zamiana_d,'',$s_params['description_b']);
    write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Desc A: '.$s_params['description_a']."\n");
    write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Desc B: '.$s_params['description_b']."\n");
            
    //========================================================================================================================================================================
    $conf='';
    write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Nazwa uslugi: '.$s_params['nazwa_uslugi']."\n");
    write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Usluga: '.$s_params['usluga']."\n");
    
    switch ($s_params['usluga'])
    {
        case "INTERNET":
                        $conf_peer=     gen_config_peer_a($s_params,$migracja,$mtu_cisco,$mtu_juniper);
                        $conf_peer_b=   gen_config_peer_b($s_params,$migracja,$mtu_cisco,$mtu_juniper);
                        
                        $conf_juniper_a=gen_config_juniper_B2B_internet($s_params,$migracja,$mtu_cisco,$mtu_juniper);
                        if($s_params['router_b_typ'] !== 'CISCO')
                        {
                            $conf_juniper_b = gen_config_juniper_b($s_params,$migracja,$mtu_cisco,$mtu_juniper);
                        } else $conf_cisco_b = gen_config_cisco($s_params,$migracja,$mtu_cisco,$mtu_juniper);

                        $conf_vectra_a= gen_config_via_vectra_a($s_params,$migracja,$mtu_cisco,$mtu_juniper);
                        $conf_vectra_b= gen_config_via_vectra_b($s_params,$migracja,$mtu_cisco,$mtu_juniper);

                        $conf.= $conf_peer."\n\n";
                        $conf.= $conf_peer_b."\n\n";
                        $conf.= $conf_juniper_a."\n\n";
                        $conf.= $conf_juniper_b."\n\n";
                        $conf.= $conf_cisco_b."\n\n";
                        $conf.= $conf_vectra_a."\n\n";
                        $conf.= $conf_vectra_b."\n\n";
                        $conf.= "##############################################"."\n\n";            
            break;
            
        case "INTERNET_BGP":
                        $conf_peer=     gen_config_peer_a($s_params,$migracja,$mtu_cisco,$mtu_juniper);
                        $conf_peer_b=   gen_config_peer_b($s_params,$migracja,$mtu_cisco,$mtu_juniper);

                        $conf_juniper_a=        gen_config_juniper_B2B_bgp($s_params,$migracja,$mtu_cisco,$mtu_juniper);
                        $conf_intercon254_20=   gen_interconnect_B2B_bgp_254_20($s_params,$migracja,$mtu_cisco,$mtu_juniper);
                        $conf_intercon254_25=   gen_interconnect_B2B_bgp_254_25($s_params,$migracja,$mtu_cisco,$mtu_juniper);
                        $conf_intercon233_20=   gen_interconnect_B2B_bgp_233_20($s_params,$migracja,$mtu_cisco,$mtu_juniper);
                        if($s_params['router_b_typ'] !== 'CISCO')
                        {
                            $conf_juniper_b = gen_config_juniper_b($s_params,$migracja,$mtu_cisco,$mtu_juniper);
                        } else $conf_cisco_b = gen_config_cisco($s_params,$migracja,$mtu_cisco,$mtu_juniper);

                        //$conf_vectra_a= gen_config_via_vectra_a_bgp($s_params,$migracja);
                        //$conf_vectra_b= gen_config_via_vectra_b($s_params,$migracja);

                        $conf.= $conf_peer."\n\n";
                        $conf.= $conf_peer_b."\n\n";
                        $conf.= $conf_juniper_a."\n\n";
                        $conf.= $conf_intercon254_20."\n\n";
                        $conf.= $conf_intercon254_25."\n\n";
                        $conf.= $conf_intercon233_20."\n\n";
                        $conf.= $conf_juniper_b."\n\n";
                        $conf.= $conf_cisco_b."\n\n";
                        $conf.= $conf_vectra_a."\n\n";
                        $conf.= $conf_vectra_b."\n\n";
                        $conf.="##############################################"."\n\n";
            break;

        case "INTERNET_BGP_DDOS":
                        $conf_peer=     gen_config_peer_a($s_params,$migracja,$mtu_cisco,$mtu_juniper);
                        $conf_peer_b=   gen_config_peer_b($s_params,$migracja,$mtu_cisco,$mtu_juniper);

                        $conf_juniper_a=        gen_config_juniper_B2B_bgp_ddos($s_params,$migracja,$mtu_cisco,$mtu_juniper);
                        $conf_intercon254_20=   gen_interconnect_B2B_bgp_254_20($s_params,$migracja,$mtu_cisco,$mtu_juniper);
                        $conf_intercon254_25=   gen_interconnect_B2B_bgp_254_25($s_params,$migracja,$mtu_cisco,$mtu_juniper);
                        $conf_intercon233_20=   gen_interconnect_B2B_bgp_233_20($s_params,$migracja,$mtu_cisco,$mtu_juniper);
                        if($s_params['router_b_typ'] !== 'CISCO')
                        {
                            $conf_juniper_b = gen_config_juniper_b($s_params,$migracja,$mtu_cisco,$mtu_juniper);
                        } else $conf_cisco_b = gen_config_cisco($s_params,$migracja,$mtu_cisco,$mtu_juniper);

                        //$conf_vectra_a= gen_config_via_vectra_a_bgp($s_params,$migracja);
                        //$conf_vectra_b= gen_config_via_vectra_b($s_params,$migracja);

                        $conf.= $conf_peer."\n\n";
                        $conf.= $conf_peer_b."\n\n";
                        $conf.= $conf_juniper_a."\n\n";
                        $conf.= $conf_intercon254_20."\n\n";
                        $conf.= $conf_intercon254_25."\n\n";
                        $conf.= $conf_intercon233_20."\n\n";
                        $conf.= $conf_juniper_b."\n\n";
                        $conf.= $conf_cisco_b."\n\n";
                        $conf.= $conf_vectra_a."\n\n";
                        $conf.= $conf_vectra_b."\n\n";
                        $conf.="##############################################"."\n\n";
            break;

        case "INTERNET_LOKALNY":
                        if($s_params['router_a_typ'] !== 'CISCO')
                        {
                            $conf_juniper_a = gen_config_juniper_internet_lokalny($s_params,$migracja,$mtu_cisco,$mtu_juniper);
                        } else
                            {
                                $conf_cisco_a = gen_config_cisco_internet_lokalny($s_params,$migracja,$mtu_cisco,$mtu_juniper);
                            }
                        //$conf_vectra_a= gen_config_via_vectra_a($s_params,$migracja);
                        //$conf_vectra_b= gen_config_via_vectra_b($s_params,$migracja);

                        //$conf.= $conf_juniper_a."\n\n";
                        $conf.= $conf_juniper_a."\n\n";
                        $conf.= $conf_cisco_a."\n\n";
                        //$conf.=$conf_vectra_a."\n\n";
                        //$conf.=$conf_vectra_b."\n\n";
                        $conf.="##############################################"."\n\n";
             break;

        case "INTERNET_LOKALNY_BGP":
                        //$conf_peer_b=   gen_config_peer_warszawa_b($s_params,$migracja);
                        $conf_juniper_a=gen_config_juniper_B2B_lokalny_bgp($s_params,$migracja,$mtu_cisco,$mtu_juniper);
                        //if($s_params['router_b_typ'] !== 'CISCO')
                        //{
                        //    $conf_juniper_b = gen_config_juniper_b($s_params,$migracja);
                        //} else $conf_cisco = gen_config_cisco($s_params,$migracja);

                        //$conf_vectra_a= gen_config_via_vectra_a_bgp($s_params,$migracja);
                        //$conf_vectra_b= gen_config_via_vectra_b($s_params,$migracja);

                        $conf.= $conf_peer."\n\n";
                        //$conf.= $conf_peer_b."\n\n";
                        $conf.= $conf_juniper_a."\n\n";
                        //$conf.= $conf_juniper_b."\n\n";
                        $conf.=$conf_cisco_a."\n\n";
                        $conf.=$conf_vectra_a."\n\n";
                        $conf.=$conf_vectra_b."\n\n";
                        $conf.="##############################################"."\n\n";
             break;
         
        case "INTERNET_LOKALNY_BGP_DDOS":
                        //$conf_peer_b=   gen_config_peer_warszawa_b($s_params,$migracja);
                        $conf_juniper_a=gen_config_juniper_B2B_lokalny_bgp_ddos($s_params,$migracja,$mtu_cisco,$mtu_juniper);
                        //if($s_params['router_b_typ'] !== 'CISCO')
                        //{
                        //    $conf_juniper_b = gen_config_juniper_b($s_params,$migracja);
                        //} else $conf_cisco = gen_config_cisco($s_params,$migracja);

                        //$conf_vectra_a= gen_config_via_vectra_a_bgp($s_params,$migracja);
                        //$conf_vectra_b= gen_config_via_vectra_b($s_params,$migracja);

                        $conf.= $conf_peer."\n\n";
                        //$conf.= $conf_peer_b."\n\n";
                        $conf.= $conf_juniper_a."\n\n";
                        //$conf.= $conf_juniper_b."\n\n";
                        $conf.=$conf_cisco_a."\n\n";
                        $conf.=$conf_vectra_a."\n\n";
                        $conf.=$conf_vectra_b."\n\n";
                        $conf.="##############################################"."\n\n";
             break;

        case "SIP-T":
                        $conf_peer=     gen_config_peer_a($s_params,$migracja,$mtu_cisco,$mtu_juniper);
                        $conf_peer_b=   gen_config_peer_b($s_params,$migracja,$mtu_cisco,$mtu_juniper);

                        $conf_juniper_a=gen_config_juniper_sip_t_a($s_params,$migracja);
                        if($s_params['router_b_typ'] !== 'CISCO')
                        {
                            $conf_juniper_b=    gen_config_juniper_sip_t_b($s_params,$migracja);
                        } else $conf_cisco_b=   gen_config_cisco_sip_t_b($s_params,$migracja);

                        $conf_vectra_a= gen_config_via_vectra_a($s_params,$migracja);
                        $conf_vectra_b= gen_config_via_vectra_b($s_params,$migracja);

                        $conf.= $conf_peer."\n\n";
                        $conf.= $conf_peer_b."\n\n";
                        $conf.= $conf_juniper_a."\n\n";
                        $conf.= $conf_juniper_b."\n\n";
                        $conf.=$conf_cisco_b."\n\n";
                        $conf.=$conf_vectra_a."\n\n";
                        $conf.=$conf_vectra_b."\n\n";
                        $conf.="##############################################"."\n\n";
            break;
    
        case "SIP":
                        $conf_peer=     gen_config_peer_a($s_params,$migracja);
                        $conf_peer_b=   gen_config_peer_b($s_params,$migracja,$mtu_cisco,$mtu_juniper);

                        $conf_juniper_a=gen_config_juniper_sip_a($s_params,$migracja);
                        if($s_params['router_b_typ'] !== 'CISCO')
                        {
                            $conf_juniper_b=    gen_config_juniper_sip_b($s_params,$migracja);
                        } else $conf_cisco_b=   gen_config_cisco_sip($s_params,$migracja);

                        $conf_vectra_a= gen_config_via_vectra_a($s_params,$migracja);
                        $conf_vectra_b= gen_config_via_vectra_b($s_params,$migracja);

                        $conf.= $conf_peer."\n\n";
                        $conf.= $conf_peer_b."\n\n";
                        $conf.= $conf_juniper_a."\n\n";
                        $conf.= $conf_juniper_b."\n\n";
                        $conf.=$conf_cisco_b."\n\n";
                        $conf.=$conf_vectra_a."\n\n";
                        $conf.=$conf_vectra_b."\n\n";
                        $conf.="##############################################"."\n\n";
            break;

        case "XCONNECT":
                        if($s_params['router_a_typ'] !== 'CISCO')
                        {
                            $conf_juniper_a=    gen_config_juniper_xconnect_a($s_params,$migracja,$mtu_cisco,$mtu_juniper);
                        } else $conf_cisco_a=   gen_config_cisco_xconnect_a($s_params,$migracja,$mtu_cisco,$mtu_juniper);

                        if($s_params['router_b_typ'] !== 'CISCO')
                        {
                            $conf_juniper_b=    gen_config_juniper_xconnect_b($s_params,$migracja,$mtu_cisco,$mtu_juniper);
                        } else $conf_cisco_b=   gen_config_cisco_xconnect_b($s_params,$migracja,$mtu_cisco,$mtu_juniper);

                        $conf_vectra_a= gen_config_via_vectra_a($s_params,$migracja,$mtu_cisco,$mtu_juniper);
                        $conf_vectra_b= gen_config_via_vectra_b($s_params,$migracja,$mtu_cisco,$mtu_juniper);

                        $conf.= $conf_juniper_a."\n\n";
                        $conf.= $conf_juniper_b."\n\n";
                        $conf.= $conf_cisco_a."\n\n";
                        $conf.= $conf_cisco_b."\n\n";
                        $conf.= $conf_vectra_a."\n\n";
                        $conf.= $conf_vectra_b."\n\n";
                        $conf.= "##############################################"."\n\n";
            break;

        case "XCONNECT-Vlan":
                        if($s_params['router_a_typ'] !== 'CISCO')
                        {
                            $conf_juniper_a=    gen_config_juniper_xconnect_encaps_vlan_a($s_params,$migracja,$mtu_cisco,$mtu_juniper);
                        } else $conf_cisco_a=   gen_config_cisco_xconnect_encaps_vlan_a($s_params,$migracja,$mtu_cisco,$mtu_juniper);

                        if($s_params['router_b_typ'] !== 'CISCO')
                        {
                            $conf_juniper_b=    gen_config_juniper_xconnect_encaps_vlan_b($s_params,$migracja,$mtu_cisco,$mtu_juniper);
                        } else $conf_cisco_b=   gen_config_cisco_xconnect_encaps_vlan_b($s_params,$migracja,$mtu_cisco,$mtu_juniper);

                        $conf_vectra_a= gen_config_via_vectra_encaps_vlan_a($s_params,$migracja,$mtu_cisco,$mtu_juniper);
                        $conf_vectra_b= gen_config_via_vectra_encaps_vlan_b($s_params,$migracja,$mtu_cisco,$mtu_juniper);

                        $conf.= $conf_juniper_a."\n\n";
                        $conf.= $conf_juniper_b."\n\n";
                        $conf.= $conf_cisco_a."\n\n";
                        $conf.= $conf_cisco_b."\n\n";
                        $conf.= $conf_vectra_a."\n\n";
                        $conf.= $conf_vectra_b."\n\n";
                        $conf.= "##############################################"."\n\n";
            break;
            
        case "BRIDGE":
                        if($s_params['router_a_typ'] !== 'CISCO')
                        {
                            $conf_juniper_b=  gen_config_juniper_bridge($s_params,$migracja,$mtu_cisco,$mtu_juniper);
                            $conf.=$conf_juniper_b."\n\n";
                        }
                        else
                            {
                                $conf_cisco_b=   gen_config_cisco_bridge($s_params,$migracja,$mtu_cisco,$mtu_juniper);
                                $conf.=$conf_cisco_b."\n\n";
                            }
                        $conf.="##############################################"."\n\n";
            break;
    
        case "SWITCHING":
                        if($s_params['router_a_typ'] !== 'CISCO')
                        {
                            $conf_juniper_b=  gen_config_juniper_switching($s_params,$migracja,$mtu_cisco,$mtu_juniper);
                            $conf.=$conf_juniper_b."\n\n";
                        }
                        else
                            {
                                $conf_cisco_b=   gen_config_cisco_switching($s_params,$migracja,$mtu_cisco,$mtu_juniper);
                                $conf.=$conf_cisco_b."\n\n";
                            }
                        $conf.="##############################################"."\n\n";
            break;
            
        case "CONNECTED":
                        if($s_params['router_a_typ'] !== 'CISCO')
                        {
                            $conf_juniper_a=    gen_config_juniper_connected_a($s_params,$migracja,$mtu_cisco,$mtu_juniper);
                        } else $conf_cisco_a=   gen_config_cisco_connected_a($s_params,$migracja,$mtu_cisco,$mtu_juniper);

                        if($s_params['router_b_typ'] !== 'CISCO')
                        {
                            $conf_juniper_b=    gen_config_juniper_connected_b($s_params,$migracja,$mtu_cisco,$mtu_juniper);
                        } else $conf_cisco_b=   gen_config_cisco_connected_b($s_params,$migracja,$mtu_cisco,$mtu_juniper);

                        //$conf_vectra_a= gen_config_via_vectra_a($s_params,$migracja);
                        //$conf_vectra_b= gen_config_via_vectra_b($s_params,$migracja);

                        $conf.= $conf_juniper_a."\n\n";
                        $conf.= $conf_juniper_b."\n\n";
                        $conf.= $conf_cisco_a."\n\n";
                        $conf.= $conf_cisco_b."\n\n";
                        $conf.= $conf_vectra_a."\n\n";
                        $conf.= $conf_vectra_b."\n\n";
                        $conf.= "##############################################"."\n\n";
            break;
            
        default: $conf.="# DEFAULT #############################################"."\n\n";
            break;
    }    

    try
    {
        update_db($s_params,$conf,$rec_id,$src_d);
    } catch(Exception $e)
        {
            ;
        }
      
    
    //Send config to tmp file and window
    $ii=rand(1,1000);
    $file_name_all=             '/data/tmp/'.$ii.'_all.txt';
    $file_name_peer=            '/data/tmp/'.$ii.'_peer.txt';
    $file_name_peer_b=          '/data/tmp/'.$ii.'_peer_b.txt';
    $file_name_juniper_a=       '/data/tmp/'.$ii.'_juniper_a.txt';
    $file_name_juniper_b=       '/data/tmp/'.$ii.'_juniper_b.txt';
    $file_name_cisco=           '/data/tmp/'.$ii.'_cisco.txt';
    $file_name_cisco_a=         '/data/tmp/'.$ii.'_cisco_a.txt';
    $file_name_cisco_b=         '/data/tmp/'.$ii.'_cisco_b.txt';
    $file_name_vectra_a=        '/data/tmp/'.$ii.'_vectra_a.txt';
    $file_name_vectra_b=        '/data/tmp/'.$ii.'_vectra_b.txt';
    $file_name_intercon254_20=  '/data/tmp/'.$ii.'_intercon254_20.txt';
    $file_name_intercon254_25=  '/data/tmp/'.$ii.'_intercon254_25.txt';
    $file_name_intercon233_20=  '/data/tmp/'.$ii.'_intercon233_20.txt';
    $conf_all = $conf;
    
    write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Gen_file rand: '.$ii.' = '.$file_name_all."\n");
    if($src===1 || $src==='1')
    {
        write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Conf: '.          $conf_all."\n");
        write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Conf peer: '.     $conf_peer."\n");
        write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Conf peer b: '.   $conf_peer_b."\n");
        write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Conf juniper_a: '.$conf_juniper_a."\n");
        write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Conf juniper_b: '.$conf_juniper_b."\n");
        write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Conf cisco_a: '.  $conf_cisco_a."\n");
        write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Conf cisco_b: '.  $conf_cisco_b."\n");
        write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Conf vectra_a: '. $conf_vectra_a."\n");
        write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Conf vectra_b: '. $conf_vectra_b."\n");
        write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Conf intercon: '. $conf_intercon254_20."\n");
        write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Conf intercon: '. $conf_intercon254_25."\n");
        write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Conf intercon: '. $conf_intercon233_20."\n");
        
        //$ff=file_put_contents($file_name,nl2br(htmlentities($conf)));
                                        
        $ff_peer=           file_put_contents($file_name_peer,$conf_peer);
        $ff_intercon254_20= file_put_contents($file_name_intercon254_20,$conf_intercon254_20);
        $ff_intercon254_25= file_put_contents($file_name_intercon254_25,$conf_intercon254_25);
        $ff_intercon233_20= file_put_contents($file_name_intercon233_20,$conf_intercon233_20);
        $ff_peer_b=         file_put_contents($file_name_peer_b,$conf_peer_b);
        $ff_juniper_a=      file_put_contents($file_name_juniper_a,$conf_juniper_a);
        $ff_juniper_b=      file_put_contents($file_name_juniper_b,$conf_juniper_b);
        $ff_cisco_a=        file_put_contents($file_name_cisco_a,$conf_cisco_a);
        $ff_cisco_b=        file_put_contents($file_name_cisco_b,$conf_cisco_b);
        $ff_vectra_a=       file_put_contents($file_name_vectra_a,$conf_vectra_a);
        $ff_vectra_b=       file_put_contents($file_name_vectra_b,$conf_vectra_b);
        
        $ff_all=            file_put_contents($file_name_all,($conf_all));
        
        $router_a=  $s_params['router_a'];
        $miasto_a=  $s_params['miasto_a'];
        $ip_a=      $s_params['ip_a'];
        
        $miasto_b=  $s_params['miasto_b'];
        $router_b=  $s_params['router_b'];
        $ip_b=      $s_params['ip_b'];
        
        write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Gen_file: '.$ff_all.' = '.$file_name_all."\n");
        echo nl2br(htmlentities($conf_all)).'||'.$file_name_all.'||'.$file_name_peer.'||'.$file_name_juniper_a.'||'.$file_name_juniper_b.'||'.$file_name_cisco_a.'||'.$file_name_cisco_b.'||'.$file_name_vectra_a.'||'.$file_name_vectra_b.'||'.$file_name_peer_b.'||'.$miasto_a.'||'.$router_a.'||'.$ip_a.'||'.$miasto_b.'||'.$router_b.'||'.$ip_b.'||'.$file_name_intercon254_20.'||'.$file_name_intercon254_25.'||'.$file_name_intercon233_20;
    } else
        {
            write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Conf: '.             $conf_all."\n");
            write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Conf peer: '.        $conf_peer."\n");
            write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Conf juniper_a: '.   $conf_juniper_a."\n");
            write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Conf juniper_b: '.   $conf_juniper_b."\n");
            write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Conf cisco_a: '.     $conf_cisco_a."\n");
            write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Conf cisco_b: '.     $conf_cisco_b."\n");
            write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Conf vectra_a: '.    $conf_vectra_a."\n");
            write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Conf vectra_b: '.    $conf_vectra_b."\n");        
            write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Conf intercon: '.    $conf_intercon254_20."\n");
            write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Conf intercon: '.    $conf_intercon254_25."\n");
            write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Conf intercon: '.    $conf_intercon233_20."\n");

            write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Conf:  '.            $conf."\n");
            //$ff=file_put_contents($file_name,htmlentities($conf));
            
            $ff_peer=           file_put_contents($file_name_peer,$conf_peer);
            $ff_intercon254_20= file_put_contents($file_name_intercon254_20,$conf_intercon254_20);
            $ff_intercon254_25= file_put_contents($file_name_intercon254_25,$conf_intercon254_25);
            $ff_intercon233_20= file_put_contents($file_name_intercon233_20,$conf_intercon233_20);
            $ff_peer_b=         file_put_contents($file_name_peer,$conf_peer_b);
            $ff_juniper_a=      file_put_contents($file_name_juniper_a,$conf_juniper_a);
            $ff_juniper_b=      file_put_contents($file_name_juniper_b,$conf_juniper_b);
            $ff_cisco_a=        file_put_contents($file_name_cisco_a,$conf_cisco_a);
            $ff_cisco_b=        file_put_contents($file_name_cisco_b,$conf_cisco_b);
            $ff_vectra_a=       file_put_contents($file_name_vectra_a,$conf_vectra_a);
            $ff_vectra_b=       file_put_contents($file_name_vectra_b,$conf_vectra_b);

            $ff_all=file_put_contents($file_name,($conf_all));
            
            $router_a=  $s_params['router_a'];
            $miasto_a=  $s_params['miasto_a'];
            $ip_a=      $s_params['ip_a'];
        
            $miasto_b=  $s_params['miasto_b'];
            $router_b=  $s_params['router_b'];
            $ip_b=      $s_params['ip_b'];

            write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Gen_file: '.$ff_all.' = '.$file_name_all."\n");
            echo nl2br(htmlentities($conf_all)).'||'.$file_name_all.'||'.$file_name_peer.'||'.$file_name_juniper_a.'||'.$file_name_juniper_b.'||'.$file_name_cisco_a.'||'.$file_name_cisco_b.'||'.$file_name_vectra_a.'||'.$file_name_vectra_b.'||'.$file_name_peer_b.'||'.$miasto_a.'||'.$router_a.'||'.$ip_a.'||'.$miasto_b.'||'.$router_b.'||'.$ip_b.'||'.$file_name_intercon254_20.'||'.$file_name_intercon254_25.'||'.$file_name_intercon233_20;
        }

//=================================================================================================================================

function gen_config_peer_a($s_params,$migracja,$mtu_cisco,$mtu_juniper)
{   
    $ip_a=trim($s_params["ip_a"]);
    switch ($ip_a)
    {
        case '192.168.168.100':  //B2B Warszawa
                            $conf='';
                            $conf.="##### Pereca -- 192.168.168.1"." --- 89.228.0.50 "."\n\n";

                            $conf.="set interfaces ae20 unit ".$s_params['s_vlan']." description ".'"'."Biznes_L2VPN_".$s_params['miasto_b'].'"'."\n";
                            $conf.="set interfaces ae20 unit ".$s_params['s_vlan']." encapsulation vlan-ccc"."\n";
                            $conf.="set interfaces ae20 unit ".$s_params['s_vlan']." vlan-id ".$s_params['s_vlan']."\n";
                            $conf.="\n";
                            $conf.="set protocols l2circuit neighbor ".$s_params['router_b']." interface ae20".'.'.$s_params['s_vlan']." virtual-circuit-id ".$s_params['s_vlan']."\n";
                            $conf.="set protocols l2circuit neighbor ".$s_params['router_b']." interface ae20".'.'.$s_params['s_vlan']." flow-label-transmit"."\n";
                            $conf.="set protocols l2circuit neighbor ".$s_params['router_b']." interface ae20".'.'.$s_params['s_vlan']." flow-label-receive"."\n";
                            $conf.="set protocols l2circuit neighbor ".$s_params['router_b']." interface ae20".'.'.$s_params['s_vlan']." mtu ".$mtu_juniper."\n";
                            if($s_params['router_b_typ']==='JUNIPER')
                            {
                                $conf.="set protocols l2circuit neighbor ".$s_params['router_b']." interface ae20".'.'.$s_params['s_vlan']." encapsulation-type ethernet"."\n";  
                            } else $conf.="set protocols l2circuit neighbor ".$s_params['router_b']." interface ae20".'.'.$s_params['s_vlan']." encapsulation-type ethernet-vlan"."\n";
              break;
              
        case '192.168.164.111':  //B2B Debica
                            $conf='';
                            $conf.="##### Debica -- 192.168.164.1"." --- 89.228.0.9 "."\n\n";

                            $conf.="set interfaces ae2 unit ".$s_params['s_vlan']." description ".'"'."Biznes_L2VPN_".$s_params['miasto_b'].'"'."\n";
                            $conf.="set interfaces ae2 unit ".$s_params['s_vlan']." encapsulation vlan-ccc"."\n";
                            $conf.="set interfaces ae2 unit ".$s_params['s_vlan']." vlan-id ".$s_params['s_vlan']."\n";
                            $conf.="\n";
                            $conf.="set protocols l2circuit neighbor ".$s_params['router_b']." interface ae2".'.'.$s_params['s_vlan']." virtual-circuit-id ".$s_params['s_vlan']."\n";
                            $conf.="set protocols l2circuit neighbor ".$s_params['router_b']." interface ae2".'.'.$s_params['s_vlan']." flow-label-transmit"."\n";
                            $conf.="set protocols l2circuit neighbor ".$s_params['router_b']." interface ae2".'.'.$s_params['s_vlan']." flow-label-receive"."\n";
                            $conf.="set protocols l2circuit neighbor ".$s_params['router_b']." interface ae2".'.'.$s_params['s_vlan']." mtu ".$mtu_juniper."\n";
                            if($s_params['router_b_typ']==='JUNIPER')
                            {
                                $conf.="set protocols l2circuit neighbor ".$s_params['router_b']." interface ae2".'.'.$s_params['s_vlan']." encapsulation-type ethernet"."\n";  
                            } else $conf.="set protocols l2circuit neighbor ".$s_params['router_b']." interface ae2".'.'.$s_params['s_vlan']." encapsulation-type ethernet-vlan"."\n";
              break;
    }
        
    return $conf;
}
function gen_config_peer_b($s_params,$migracja,$mtu_cisco,$mtu_juniper,$mtu_cisco,$mtu_juniper)
{   
    $conf='';
    $ip_a=trim($s_params["ip_a"]);
    switch ($ip_a)
    {
        case '192.168.168.100':  //Xconnect z Pereca
                            $conf='';
                            if($s_params['router_b_typ']==='JUNIPER')
                            {
                                $conf.="### IF NOT EXISTS - create Xconnect to Pereca ##############################################################################\n";
                                $conf.="set ".$s_params['logical_system_b']." protocols l2circuit neighbor 89.228.0.50 interface ".$s_params['interface_b'].'.'.$s_params['s_vlan']." virtual-circuit-id ".$s_params['s_vlan']."\n";
                                $conf.="set ".$s_params['logical_system_b']." protocols l2circuit neighbor 89.228.0.50 interface ".$s_params['interface_b'].'.'.$s_params['s_vlan']." mtu ".$mtu_juniper."\n";
                                $conf.="set ".$s_params['logical_system_b']." protocols l2circuit neighbor 89.228.0.50 interface ".$s_params['interface_b'].'.'.$s_params['s_vlan']." encapsulation-type ethernet"."\n";
                                $conf.="set ".$s_params['logical_system_b']." protocols l2circuit neighbor 89.228.0.50 interface ".$s_params['interface_b'].'.'.$s_params['s_vlan']." flow-label-transmit"."\n";
                                $conf.="set ".$s_params['logical_system_b']." protocols l2circuit neighbor 89.228.0.50 interface ".$s_params['interface_b'].'.'.$s_params['s_vlan']." flow-label-receive"."\n";
                                $conf.="set ".$s_params['logical_system_b']." protocols l2circuit neighbor 89.228.0.50 interface ".$s_params['interface_b'].'.'.$s_params['s_vlan']." encapsulation-type ethernet-vlan"."\n";
                                $conf.="### END of Xconnect to Pereca if not exists ##############################################################################\n";    
                            } else
                                {
                                    $conf.="\n\n\n";
                                    $conf.="!! FOR CISCO !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"."\n";  
                                    $s_vlan=$s_params['s_vlan'];
                                    if($s_params['s_vlan']==='') $s_vlan=$s_params['c_vlan']; //konieczne dla zwyklego tranytu
                                    $conf.="interface ".$s_params['interface_b'].'.'.$s_vlan." l2transport"."\n";
                                    $conf.="    description Biznes_L2VPN_".$s_params['miasto_b']."_Warszawa_do_Pereca"."\n";
                                    $conf.="    encapsulation dot1q ".$s_params['c_vlan']."\n";
                                    $conf.="    mtu ".$mtu_cisco."\n";
                                    $conf.="    no rewrite ingress tag pop 1 symmetric"."\n";
                                    $conf.="exit"."\n";
                                    $conf.="\n\n";
                                    $conf.="!!!IF NOT EXIST!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n\n";
                                    $conf.="l2vpn"."\n";
                                    $conf.="    pw-class ptp_B2B_vlan_".$s_vlan."\n";
                                    $conf.="    encapsulation mpls"."\n";
                                    $conf.="    control-word"."\n";
                                    $conf.="    protocol ldp"."\n";
                                    $conf.="    transport-mode vlan"."\n";
                                    $conf.="    !transport-mode ethernet"."\n";
                                    $conf.="exit"."\n";

                                    $conf.="l2vpn"."\n";
                                    $conf.="    xconnect group ptp_B2B_vlan_".$s_vlan."\n";
                                    $conf.="    p2p ptp_B2B_vlan_".$s_vlan."\n";
                                    $conf.="    interface ".$s_params['interface_b'].'.'.$s_vlan."\n";
                                    $conf.="    neighbor ipv4 89.228.0.50 pw-id ".$s_vlan."\n";
                                    $conf.="        pw-class ptp_B2B_vlan_".$s_vlan."\n";
                                    $conf.="        exit"."\n";
                                    $conf.="    exit"."\n";
                                    $conf.="exit"."\n";
                                    $conf.="exit"."\n";
                                }
              break;
              
        case '192.168.164.111':  //xconnect z Debicy
                            $conf='';
                            if($s_params['router_b_typ']==='JUNIPER')
                            {
                                $conf.="### IF NOT EXISTS - create Xconnect to Debica ##############################################################################\n";
                                $conf.="set ".$s_params['logical_system_b']." protocols l2circuit neighbor 89.228.0.9 interface ".$s_params['interface_b'].'.'.$s_params['s_vlan']." virtual-circuit-id ".$s_params['s_vlan']."\n";
                                $conf.="set ".$s_params['logical_system_b']." protocols l2circuit neighbor 89.228.0.9 interface ".$s_params['interface_b'].'.'.$s_params['s_vlan']." mtu ".$mtu_juniper."\n";
                                $conf.="set ".$s_params['logical_system_b']." protocols l2circuit neighbor 89.228.0.9 interface ".$s_params['interface_b'].'.'.$s_params['s_vlan']." encapsulation-type ethernet"."\n";
                                $conf.="set ".$s_params['logical_system_b']." protocols l2circuit neighbor 89.228.0.9 interface ".$s_params['interface_b'].'.'.$s_params['s_vlan']." flow-label-transmit"."\n";
                                $conf.="set ".$s_params['logical_system_b']." protocols l2circuit neighbor 89.228.0.9 interface ".$s_params['interface_b'].'.'.$s_params['s_vlan']." flow-label-receive"."\n";
                                $conf.="set ".$s_params['logical_system_b']." protocols l2circuit neighbor 89.228.0.9 interface ".$s_params['interface_b'].'.'.$s_params['s_vlan']." encapsulation-type ethernet-vlan"."\n";
                                $conf.="### END of Xconnect to Debica router if not exists ##############################################################################\n";    
                            } else
                                {
                                    $conf.="\n\n\n";
                                    $conf.="!! FOR CISCO !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"."\n";  
                                    $s_vlan=$s_params['s_vlan'];
                                    if($s_params['s_vlan']==='') $s_vlan=$s_params['c_vlan']; //konieczne dla zwyklego tranytu
                                    $conf.="interface ".$s_params['interface_b'].'.'.$s_vlan." l2transport"."\n";
                                    $conf.="    description Biznes_L2VPN_".$s_params['miasto_b']."_Warszawa_do_Debica"."\n";
                                    $conf.="    encapsulation dot1q ".$s_params['c_vlan']."\n";
                                    $conf.="    mtu ".$mtu_cisco."\n";
                                    $conf.="    no rewrite ingress tag pop 1 symmetric"."\n";
                                    //$conf.="    service-policy input ".$s_params['nazwa_uslugi']."_IN"."\n";
                                    //$conf.="    service-policy output ".$s_params['nazwa_uslugi']."_OUT"."\n";
                                    $conf.="exit"."\n";
                                    $conf.="\n\n";
                                    $conf.="!!!IF NOT EXIST!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n\n";
                                    $conf.="l2vpn"."\n";
                                    $conf.="    pw-class ptp_B2B_vlan_".$s_vlan."\n";
                                    $conf.="    encapsulation mpls"."\n";
                                    $conf.="    control-word"."\n";
                                    $conf.="    protocol ldp"."\n";
                                    $conf.="    transport-mode vlan"."\n";
                                    $conf.="    !transport-mode ethernet"."\n";
                                    $conf.="exit"."\n";

                                    $conf.="l2vpn"."\n";
                                    $conf.="    xconnect group ptp_B2B_vlan_".$s_vlan."\n";
                                    $conf.="    p2p ptp_B2B_vlan_".$s_vlan."\n";
                                    $conf.="    interface ".$s_params['interface_b'].'.'.$s_vlan."\n";
                                    $conf.="    neighbor ipv4 89.228.0.9 pw-id ".$s_vlan."\n";
                                    $conf.="        pw-class ptp_B2B_vlan_".$s_vlan."\n";
                                    $conf.="        exit"."\n";
                                    $conf.="    exit"."\n";
                                    $conf.="exit"."\n";
                                    $conf.="exit"."\n";
                                }
              break;
    }
    return $conf;
}

//====================================================================================================================================================================

function gen_config_juniper_B2B_internet($s_params,$migracja,$mtu_cisco,$mtu_juniper)  //router B2B Warszawa
{
    $ip_p2p=str_replace($zamiana_p,'',$s_params['ip_p2p']);
    $ip_p2p_mask=trim(get_ip_p2p_mask($s_params['ip_p2p']));
    $ip_p2p_1=str_replace($zamiana_p,'',trim(get_ip_p2p_1($s_params['ip_p2p'])));
    $ip_p2p_2=str_replace($zamiana_p,'',trim(get_ip_p2p_2($s_params['ip_p2p'])));
    $ip_pa=   get_ip_pa($s_params['ip_pa']);
    $download=trim(get_download($s_params['pasmo']));
    $burst_d=(int)($download/10);
    $upload=  trim(get_upload($s_params['pasmo']));
    $burst_u=(int)($upload/10);
    
    $arp_policer='';
    $arp_policer.='set firewall policer ARP-LIMIT if-exceeding bandwidth-limit 8k'."\n";
    $arp_policer.='set firewall policer ARP-LIMIT if-exceeding burst-size-limit 1500'."\n";
    $arp_policer.='set firewall policer ARP-LIMIT then discard'."\n";
    
    $conf='';
    $conf.="#####################################################################"."\n";
    $conf.="##### B2B -- ".$s_params['miasto_a']."  ---  ".$s_params['ip_a']." --- ".$s_params['router_a']."\n\n";
    $conf.="##### B2B - Interface"."\n\n";
    if($migracja===1 || $migracja==='1') $conf.="#delete ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']."\n";
    else $conf.="#delete ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']."\n";
    
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." description ".$s_params['description_a']."\n";
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." vlan-tags outer ".$s_params['s_vlan']." inner ".$s_params['c_vlan']."\n";
    //$conf.="###set interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." vlan-id ".$s_params['c_vlan']."\n";
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." family inet filter input ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_in"."\n";
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." family inet filter output ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_out"."\n";
    
    //$conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." family inet policer input ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."-IN"."\n";
    //$conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." family inet policer output ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."-OUT"."\n";
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." family inet policer arp ARP-LIMIT"."\n";
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." family inet policer input ".'Biznes_download_'.$download."\n";
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." family inet policer output ".'Biznes_upload_'.$upload."\n";
    
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." family inet address ".$ip_p2p_1."/".$ip_p2p_mask."\n";
    
    $conf.="\n";
    $conf.="##### B2B - filtr IN"."\n\n";
    if($migracja===1 || $migracja==='1') $conf.="#delete ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_in"."\n\n";
    else $conf.="#delete ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_in"."\n\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_in term T1 from destination-address ".$ip_p2p_1."/32"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_in term T1 from protocol icmp"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_in term T1 then accept"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_in term T2 from destination-address ".$ip_p2p_1."/32"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_in term T2 from protocol tcp"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_in term T2 then discard"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_in term T3 from destination-address 192.168.0.0/16"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_in term T3 from destination-address 172.16.0.0/12"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_in term T3 from destination-address 10.0.0.0/8"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_in term T3 then discard"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_in term T4 from source-address ".$s_params['ip_p2p']."\n";
    if(count($ip_pa) >0)
    {
        $conf.="\n";
        if($ip_pa[0] !== '')
        {
            $conf.="##### B2B - adresacja PA #########################################"."\n";
            for($i=0;$i<count($ip_pa);$i++)
            {        
                if(trim(str_replace(' ','',$ip_pa[$i])) !== '') 
                {
                    $ip_pa[$i]=str_replace(';','',$ip_pa[$i]);
                    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_in term T4 from source-address ".trim(str_replace(' ','',$ip_pa[$i]))."\n";
                }
            }
        }
    }
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_in term T4 then dscp 0"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_in term T4 then accept"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_in term T5 then discard"."\n";
    $conf.="\n";
    $conf.="##### B2B - filtr OUT ##########################################################"."\n";
    if($migracja===1 || $migracja==='1') $conf.="#delete ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_out"."\n\n";    
    else $conf.="#delete ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_out"."\n\n";    
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_out term T1 from destination-address ".$s_params['ip_p2p']."\n";
    if(count($ip_pa) >0)
    {
        if($ip_pa[0] !== '')
        {
            for($i=0;$i<count($ip_pa);$i++)
            {        
                if(trim(str_replace(' ','',$ip_pa[$i])) !== '')
                {
                    $ip_pa[$i]=str_replace(';','',$ip_pa[$i]);
                    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_out term T1 from destination-address ".trim(str_replace(' ','',$ip_pa[$i]))."\n";
                }
            }
        }
    }
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_out term T1 then accept"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_out term T2 then discard"."\n";
    $conf.="\n\n";    

    $conf.="##### B2B - policer ###########################################"."\n";
    if($migracja===1 || $migracja==='1')
    {    
        $conf.="#delete ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."-IN"."\n";
        $conf.="#delete ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."-OUT"."\n";
    } else
    {
        $conf.="#delete ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."-IN"."\n";
        $conf.="#delete ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."-OUT"."\n";
    }
    
    $conf.="set ".$s_params['logical_system_a']." firewall policer ".'Biznes_download_'.$download." if-exceeding bandwidth-limit ".$download."m"."\n";
    if($burst_d !== 0) $conf.="set ".$s_params['logical_system_a']." firewall policer ".'Biznes_download_'.$download." if-exceeding burst-size-limit ".$burst_d."m"."\n";
    else $conf.="set ".$s_params['logical_system_a']." firewall policer ".'Biznes_download_'.$download." if-exceeding burst-size-limit ".'1'."m"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall policer ".'Biznes_download_'.$download." then discard"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall policer ".'Biznes_upload_'.$upload." if-exceeding bandwidth-limit ".$upload."m"."\n";
    if($burst_u !== 0) $conf.="set ".$s_params['logical_system_a']." firewall policer ".'Biznes_upload_'.$upload." if-exceeding burst-size-limit ".$burst_u."m"."\n";
    else $conf.="set ".$s_params['logical_system_a']." firewall policer ".'Biznes_upload_'.$upload." if-exceeding burst-size-limit ".'1'."m"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall policer ".'Biznes_upload_'.$upload." then discard"."\n";
    
    //STATIC ROUTE dla PA
    $conf.="\n";
    if(count($ip_pa) >0)
    {
        if($ip_pa[0] !== '')
        {
            for($i=0;$i<count($ip_pa);$i++)
            {
                if(trim(str_replace(' ','',$ip_pa[$i])) !== '') 
                {
                    $ip_pa[$i]=str_replace(';','',$ip_pa[$i]);
                    $conf.="set ".$s_params['logical_system_a']." routing-options static route ".trim(str_replace(' ','',$ip_pa[$i]))." next-hop ".$ip_p2p_2."\n";
                    $conf.='#'."set ".$s_params['logical_system_a']." routing-options static route ".trim(str_replace(' ','',$ip_pa[$i]))." qualified-next-hop ".$ip_p2p_2.' preference 25 '."\n";
                }
            }
        }
    }
    
    //iBGP
    $conf.="\n";    
    if(count($ip_pa) >0)
    {
        if($ip_pa[0] !== '')
        {
            for($i=0;$i<count($ip_pa);$i++)
            {        
                $conf.="\n";
                if($s_params['router_a']==='89.228.0.140') 
                {
                    if(trim(str_replace(' ','',$ip_pa[$i])) !== '')
                    {
                        $ip_pa[$i]=str_replace(';','',$ip_pa[$i]);
                        if($ip_pa[$i] !== '')
                            $conf.="set ".$s_params['logical_system_a']." policy-options policy-statement BGP_STATIC term static from route-filter ".trim(str_replace(' ','',$ip_pa[$i]))." orlonger"."\n";
                    }
                }
                if($s_params['router_a']==='89.228.0.154') 
                {
                    if(trim(str_replace(' ','',$ip_pa[$i])) !== '')
                    {
                        $ip_pa[$i]=str_replace(';','',$ip_pa[$i]);
                        if($ip_pa[$i] !== '')
                            $conf.="set ".$s_params['logical_system_a']." policy-options prefix-list BIZNES-BGP-export ".trim(str_replace(' ','',$ip_pa[$i]))." "."\n";
                    }
                }
            }
        }
    }
    //$conf.="\n";
    //$conf.="set policy-options policy-statement CONNECT_OSPF from route-filter ".$s_params['ip_p2p']." exact"."\n";
        
    return $conf;
}

//=================================================================================================================================

function gen_config_juniper_B2B_bgp($s_params,$migracja,$mtu_cisco,$mtu_juniper)
{
    $ip_p2p=str_replace($zamiana_p,'',$s_params['ip_p2p']);
    $ip_p2p_mask=trim(get_ip_p2p_mask($s_params['ip_p2p']));
    $ip_p2p_1=str_replace($zamiana_p,'',trim(get_ip_p2p_1($s_params['ip_p2p'])));
    $ip_p2p_2=str_replace($zamiana_p,'',trim(get_ip_p2p_2($s_params['ip_p2p'])));    
    $ip_pa=   get_ip_pa($s_params['ip_pa']);  //w przypadku BGP adresy PA nie powinny istniec
    $ip_pi=   get_ip_pi($s_params['ip_pi']);
    $download=trim(get_download($s_params['pasmo']));
    $burst_d=(int)($download/10);
    $upload=  trim(get_upload($s_params['pasmo']));
    $burst_u=(int)($upload/10);
    $as_k=$s_params['as_klienta'];
        
    $arp_policer='';
    $arp_policer.='set firewall policer ARP-LIMIT if-exceeding bandwidth-limit 8k'."\n";
    $arp_policer.='set firewall policer ARP-LIMIT if-exceeding burst-size-limit 1500'."\n";
    $arp_policer.='set firewall policer ARP-LIMIT then discard'."\n";
    
    //Normalna konfiguracja dla polaczeniowki
    $conf='';
    $conf.="##########################################################################################"."\n";
    $conf.="##### B2B -- ".$s_params['miasto_a']."  ---  ".$s_params['ip_a']." --- ".$s_params['router_a']."\n\n";
    $conf.="##### B2B - Interface ####################################################################"."\n\n";
    
    $conf.="delete ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']."\n";
    
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." description ".$s_params['description_a']."\n";
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." vlan-tags outer ".$s_params['s_vlan']." inner ".$s_params['c_vlan']."\n";
    $conf.="###set interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." vlan-id ".$s_params['c_vlan']."\n";
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." family inet filter input ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_in"."\n";
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." family inet filter output ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_out"."\n";
    
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." family inet policer arp ARP-LIMIT"."\n";
    
    //$conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." family inet policer input ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."-IN"."\n";
    //$conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." family inet policer output ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."-OUT"."\n";
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." family inet policer input ".'Biznes_download_'.$download."\n";
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." family inet policer output ".'Biznes_upload_'.$upload."\n";

    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." family inet address ".$ip_p2p_1."/".$ip_p2p_mask."\n";
    
    $conf.="\n";
    $conf.="##### B2B - filtr IN BGP ####################################################################"."\n\n";
    $conf.="delete ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_in"."\n\n";
    
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_in term T1 from source-address ".$ip_p2p_2."/32"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_in term T1 from destination-address ".$ip_p2p_1."/32"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_in term T1 from protocol icmp"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_in term T1 then accept"."\n";

    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_in term T2 from source-address ".$ip_p2p_2."/32"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_in term T2 from destination-address ".$ip_p2p_1."/32"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_in term T2 from protocol tcp"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_in term T2 from port bgp"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_in term T2 then accept"."\n";
    
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_in term T3 from destination-address 192.168.0.0/16"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_in term T3 from destination-address 172.16.0.0/12"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_in term T3 from destination-address 10.0.0.0/8"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_in term T3 from destination-address ".$ip_p2p_1."/32"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_in term T3 then discard"."\n";
    
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_in term T4 from source-address ".$s_params['ip_p2p']."\n";

    if(count($ip_pi) >0)
    {
        if($ip_pi[0] !== '')
        {
            for($i=0;$i<count($ip_pi);$i++)
            {           
                if(trim(str_replace(' ','',$ip_pi[$i])) !== '') $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_in term T4 from source-address ".trim(str_replace(' ','',$ip_pi[$i]))."\n";
            }
        }
    }
    if(count($ip_pa) >0)
    {
        if($ip_pa[0] !== '')
        {
            for($i=0;$i<count($ip_pa);$i++)
            {        
                if(trim(str_replace(' ','',$ip_pa[$i])) !== '') $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_in term T4 from source-address ".trim(str_replace(' ','',$ip_pa[$i]))."\n";
            }
        }
    }
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_in term T4 then dscp 0"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_in term T4 then accept"."\n";
    
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_in term T5 then discard"."\n";
    $conf.="\n";
    
    $conf.="##### B2B - filtr OUT BGP ###################################################################################################"."\n";
    $conf.="delete ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_out"."\n\n";
    
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_out term T1 from destination-address ".$s_params['ip_p2p']."\n";
    if(count($ip_pi) >0)
    {
        if($ip_pi[0] !== '')
        {
            for($i=0;$i<count($ip_pi);$i++)
            {        
                if(trim(str_replace(' ','',$ip_pi[$i])) !== '')
                    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_out term T1 from destination-address ".trim(str_replace(' ','',$ip_pi[$i]))."\n";
            }
        }
    }
    if(count($ip_pa) >0)
    {
        if($ip_pa[0] !== '')
        {
            for($i=0;$i<count($ip_pa);$i++)
            {        
                if(trim(str_replace(' ','',$ip_pa[$i])) !== '')
                {
                    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_out term T1 from destination-address ".trim(str_replace(' ','',$ip_pa[$i]))."\n";
                }
            }
        }
    }    
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_out term T1 then accept"."\n";
    
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_out term T2 then discard"."\n";
    $conf.="\n";

    $conf.="##### B2B - policer ###################################################################################################"."\n";
    //$conf.="#delete ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."-IN"."\n";
    //$conf.="#delete ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."-OUT"."\n";
        
    $conf.="set ".$s_params['logical_system_a']." firewall policer ".'Biznes_download_'.$download." if-exceeding bandwidth-limit ".$download."m"."\n";
    if($burst_d !== 0) $conf.="set ".$s_params['logical_system_a']." firewall policer ".'Biznes_download_'.$download." if-exceeding burst-size-limit ".$burst_d."m"."\n";
    else $conf.="set ".$s_params['logical_system_a']." firewall policer ".'Biznes_download_'.$download." if-exceeding burst-size-limit ".'1'."m"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall policer ".'Biznes_download_'.$download." then discard"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall policer ".'Biznes_upload_'.$upload." if-exceeding bandwidth-limit ".$upload."m"."\n";
    if($burst_u !== 0) $conf.="set ".$s_params['logical_system_a']." firewall policer ".'Biznes_upload_'.$upload." if-exceeding burst-size-limit ".$burst_u."m"."\n";
    else $conf.="set ".$s_params['logical_system_a']." firewall policer ".'Biznes_upload_'.$upload." if-exceeding burst-size-limit ".'1'."m"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall policer ".'Biznes_upload_'.$upload." then discard"."\n";
        
    
    $conf.="##### B2B - konfig standard (import) ###################################################################################################"."\n";
    $conf.="\n";        
    $conf.="set ".$s_params['logical_system_a']." policy-options policy-statement ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_import term 1 from as-path "."as_path_".$s_params['nazwa_uslugi'].'_in'."\n";
    $conf.="set ".$s_params['logical_system_a']." policy-options policy-statement ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_import term 1 from prefix-list "."prefix_list_".$s_params['nazwa_uslugi']."\n";
    $conf.="set ".$s_params['logical_system_a']." policy-options policy-statement ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_import term 1 then local-preference 300 "."\n";
    $conf.="set ".$s_params['logical_system_a']." policy-options policy-statement ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_import term 1 then accept "."\n";
    //$conf.="set ".$s_params['logical_system_a']." policy-options policy-statement ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_import term 2 from as-path any "."\n";
    //$conf.="set ".$s_params['logical_system_a']." policy-options policy-statement ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_import term 2 from community [ no-adv-any no-adv-peer-int ] "."\n";
    $conf.="set ".$s_params['logical_system_a']." policy-options policy-statement ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_import term 2 then reject "."\n";
    //$conf.="set ".$s_params['logical_system_a']." policy-options policy-statement ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_import term 3 from as-path any "."\n";  
    //$conf.="set ".$s_params['logical_system_a']." policy-options policy-statement ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_import term 3 then accept "."\n";    
        
    $conf.="##### Konfig DEFAULT ROUTE ONLY (export) ###################################################################################################"."\n";
    $conf.="#set ".$s_params['logical_system_a']." policy-options policy-statement ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_export term 1 from route-filter "."0.0.0.0/0"." exact"."\n";  //default route
    $conf.="#set ".$s_params['logical_system_a']." policy-options policy-statement ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_export term 1 then accept "."\n";
    $conf.="#set ".$s_params['logical_system_a']." policy-options policy-statement ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_export term default then reject "."\n";
    $conf.="##### END Konfig DEFAULT ROUTE ONLY (export) ###################################################################################################"."\n\n";
    $conf.="##### Pominac, gdy  DEFAULT ROUTE ONLY (export) ###################################################################################################"."\n";
    $conf.="set ".$s_params['logical_system_a']." policy-options policy-statement ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_export term 1 from community [ no-adv-any no-adv-peer-int ]"."\n";
    $conf.="set ".$s_params['logical_system_a']." policy-options policy-statement ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_export term 1 then reject "."\n";    
    $conf.="set ".$s_params['logical_system_a']." policy-options policy-statement ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_export term 2 from protocol bgp"."\n";
    $conf.="set ".$s_params['logical_system_a']." policy-options policy-statement ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_export term 2 from as-path "."as_path_".$s_params['nazwa_uslugi']."_out"."\n";
    $conf.="set ".$s_params['logical_system_a']." policy-options policy-statement ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_export term 2 then accept "."\n";
    $conf.="set ".$s_params['logical_system_a']." policy-options policy-statement ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_export term 3 then reject "."\n";
    $conf.="##### END  DEFAULT ROUTE ONLY (export) ###################################################################################################"."\n";
        
    if(count($ip_pi) >0)
    {
        $conf.="\n";
        for($i=0;$i<count($ip_pi);$i++)
        {        
            if(trim(str_replace(' ','',$ip_pi[$i])) !== '')
            {
                $conf.="set ".$s_params['logical_system_a']." policy-options prefix-list "."prefix_list_".$s_params['nazwa_uslugi']." ".trim(str_replace(' ','',$ip_pi[$i]))."\n";
            }
        }
    }
    if(count($ip_pa) >0)
    {
        $conf.="\n";
        for($i=0;$i<count($ip_pa);$i++)
        {        
            if(trim(str_replace(' ','',$ip_pa[$i])) !== '')
            {
                $conf.="set ".$s_params['logical_system_a']." policy-options prefix-list "."prefix_list_".$s_params['nazwa_uslugi']." ".trim(str_replace(' ','',$ip_pa[$i]))."\n";
            }
        }
    }
    
    #set policy-options as-path-group aspath16 as-path aspath_16_1 "^199978(_199978)*$"
    #set policy-options as-path-group aspath16 as-path aspath_16_2 "^199978(_199978)*_52203(_52203)*$"
    $conf.="\n";
    $as_k=trim(str_replace(' ','',$s_params['as_klienta']));
    //$as_k_reg='"'.'^'.$as_k.'(_'.$as_k.')*$"';                   //"^8834(_8834)*$" - nie zawsze dziala poprawnie
    //$conf.="set ".$s_params['logical_system_a']." policy-options as-path "."as_path_".$s_params['nazwa_uslugi']."_in ".$as_k_reg."\n\n";

    //$as_k_reg='"'.'^'.$as_k.'( '.$as_k.')*$"';                   //"^8834( 8834)*$"
    $as_k_reg='"'.'^'.$as_k.'(_'.$as_k.')*$"';                   //"^8834( 8834)*$"
    $conf.="set ".$s_params['logical_system_a']." policy-options as-path "."as_path_".$s_params['nazwa_uslugi']."_in ".$as_k_reg."\n";
    //lub
    $conf.='# lub'."\n";
    $as_k_reg='#"'.'^'.$as_k.'$"';                   //"^8834$"
    $conf.="#set ".$s_params['logical_system_a']." policy-options as-path "."as_path_".$s_params['nazwa_uslugi']."_in ".$as_k_reg."\n";
    //lub
    //$as_k_reg=$as_k.'+'; 
    //$conf.="#set ".$s_params['logical_system_a']." policy-options as-path "."as_path_".$s_params['nazwa_uslugi']."_in ".$as_k_reg."\n";
    //lub
    $as_k_reg='.*';  //all
    $conf.="#set ".$s_params['logical_system_a']." policy-options as-path any"."\n";
    $conf.="\n";
    $conf.="set ".$s_params['logical_system_a']." policy-options as-path "."as_path_".$s_params['nazwa_uslugi']."_out ".$as_k_reg."\n";

    $conf.="\n";
    $conf.="##### Konfig BGP session ###################################################################################################"."\n";
    if($ip_pi[0] !== '') $prefix_list_max_1=count($ip_pi)+1;
    if($ip_pa[0] !== '') $prefix_list_max_2=count($ip_pa)+1;
    $prefix_list_max=$prefix_list_max_1+$prefix_list_max_2;
    $conf.="\n";
    $conf.="set ".$s_params['logical_system_a']." protocols bgp group "."BGP_".$s_params['nazwa_uslugi']." type external"."\n";
    $conf.="set ".$s_params['logical_system_a']." protocols bgp group "."BGP_".$s_params['nazwa_uslugi']." import ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_import"."\n";
    $conf.="set ".$s_params['logical_system_a']." protocols bgp group "."BGP_".$s_params['nazwa_uslugi']." family inet unicast prefix-limit maximum ".$prefix_list_max."\n";
    $conf.="set ".$s_params['logical_system_a']." protocols bgp group "."BGP_".$s_params['nazwa_uslugi']." family inet unicast prefix-limit teardown 75 "."\n";
    $conf.="set ".$s_params['logical_system_a']." protocols bgp group "."BGP_".$s_params['nazwa_uslugi']." family inet unicast prefix-limit teardown idle-timeout forever "."\n";
    $conf.="set ".$s_params['logical_system_a']." protocols bgp group "."BGP_".$s_params['nazwa_uslugi']." export ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_export"."\n";
    $conf.="set ".$s_params['logical_system_a']." protocols bgp group "."BGP_".$s_params['nazwa_uslugi']." remove-private"."\n";
    $conf.="set ".$s_params['logical_system_a']." protocols bgp group "."BGP_".$s_params['nazwa_uslugi']." peer-as ".$as_k."\n";
    $conf.="set ".$s_params['logical_system_a']." protocols bgp group "."BGP_".$s_params['nazwa_uslugi']." graceful-restart"."\n";
    $conf.="#### FOR local BGP ##############"."\n";
    $conf.="#set ".$s_params['logical_system_a']." protocols bgp group "."BGP_".$s_params['nazwa_uslugi']." local-as ".'[wstawić local-as, jeżeli jest to konieczne, głównie dla starych sesji]'."\n";
    $conf.="#### FOR multiple neighbor addresses ##############"."\n";
    $conf.="#set ".$s_params['logical_system_a']." protocols bgp group "."BGP_".$s_params['nazwa_uslugi']." multipath"."\n";    
    $conf.="set ".$s_params['logical_system_a']." protocols bgp group "."BGP_".$s_params['nazwa_uslugi']." neighbor ".$ip_p2p_2."\n";
    $conf.="\n\n";
    if(count($ip_pa) >0)
    {
        if($ip_pa[0] !== '')
        {
            for($i=0;$i<count($ip_pa);$i++)
            {
                if(trim(str_replace(' ','',$ip_pa[$i])) !== '') 
                {
                    $ip_pa[$i]=str_replace(';','',$ip_pa[$i]);
                    $conf.="set ".$s_params['logical_system_a']." routing-options static route ".trim(str_replace(' ','',$ip_pa[$i]))." next-hop ".$ip_p2p_2."\n";
                    $conf.='#'."set ".$s_params['logical_system_a']." routing-options static route ".trim(str_replace(' ','',$ip_pa[$i]))." qualified-next-hop ".$ip_p2p_2.' preference 25 '."\n";
                }
            }
        }
    }
    
    $conf.="\n";    
    if(count($ip_pa) >0)
    {
        if($ip_pa[0] !== '')
        {
            for($i=0;$i<count($ip_pa);$i++)
            {        
                $conf.="\n";
                if(trim(str_replace(' ','',$ip_pa[$i])) !== '')
                {
                    $ip_pa[$i]=str_replace(';','',$ip_pa[$i]);
                    if($ip_pa[$i] !== '')
                        $conf.="set ".$s_params['logical_system_a']." policy-options policy-statement BGP_STATIC term static from route-filter ".trim(str_replace(' ','',$ip_pa[$i]))." orlonger"."\n";
                }
            }
        }
        $conf.="\n";
        $conf.="\n";
    }
    
    $conf.='set policy-options community no-adv-any members 21021:9000'."\n";
    $conf.='set policy-options community no-adv-any_p1_permit members 21021:9000'."\n";
    $conf.='set policy-options community no-adv-peer-ext members 21021:9100'."\n";
    $conf.='set policy-options community no-adv-peer-int members 21021:9200'."\n";
    $conf.='set policy-options community no-adv-peer-int_p1_permit members 21021:9200'."\n";
    
    //$conf.=gen_interconnect_B2B_bgp($s_params,$migracja)    
    return $conf;
}

function gen_interconnect_B2B_bgp_254_20($s_params,$migracja,$mtu_cisco,$mtu_juniper)
{
    $a_cont=array();
    //$ip_pa=   get_ip_pa($s_params['ip_pa']);  //w przypadku BGP adresy PA nie powinny istniec
    $ip_pi=   get_ip_pi($s_params['ip_pi']);
    $as_k=$s_params['as_klienta'];
        
    $conf.="###########################################################################"."\n";
    $conf.="##### Config interconnect 192.168.254.20 === 89.228.0.51 Warszawa #########"."\n";
    if(count($ip_pi) >0)
    {
        $conf.="\n";
        for($i=0;$i<count($ip_pi);$i++)
        {        
            if(trim(str_replace(' ','',$ip_pi[$i])) !== '')
            {
                $conf.="set policy-options prefix-list bgp-clients-prefixes"." ".trim(str_replace(' ','',$ip_pi[$i]))."\n";
            }
        }
    }
    $conf.="\n";
    //set policy-options prefix-list bgp-clients-prefixes 212.14.55.0/24
    $file_doc='/raid0/apps/kk/devices_core/config/192.168.254.20';
    if(file_exists($file_doc))
    {
        $file_convert=convert_from_juniper($file_doc);
        $a_cont=explode("\n",$file_convert);
        for($i=0; $i<count($a_cont); $i++)
        {
            $pp=strpos($a_cont[$i],'set policy-options as-path 9');
            if($pp !== false)
            {
                $cc=str_replace('*$"','*$',$a_cont[$i]); //ostatni znak " nalezy usunac, poniewaz zamyka caly string. Nastepnie nalezy dodac na koncu
                $conf.=$cc.'|^'.$as_k.'( '.$as_k.')*$"';
                break;
            }
        }
        $conf.="\n\n";
        for($i=0; $i<count($a_cont); $i++)
        {
            $pp=strpos($a_cont[$i],'set policy-options as-path 8');
            if($pp !== false)
            {
                $cc=str_replace('*$"','*$',$a_cont[$i]);
                $conf.=$cc.'|^'.$as_k.'( '.$as_k.')*$"';
                break;
            }
        }
    }
    $conf.="\n\n";
    //set policy-options as-path 9 "^29323( 29323)*$|^47229( 47229)*$|^23456( 23456)*$|^3\.210( 3\.210)*$|^3\.29( 3\.29)*$|^42763( 42763)*$|^35596( 35596)*$|^44643( 44643)*$|^51305( 51305)*$|16340( 16340)*$|^16340 ( .*) 41006$|^16340 ( .*) 50450$|^16340 ( .*) 23456$|^16340 ( .*) 196969$|^50829( 50829)*$|^39219( 39219)*$|^52203( 52203)*$|42763( 42763)* 52195( 52195)*$|^196969( 196969)*$|^49989( 49989)*$|^198048( 198048)*$|^198048 ( .*) 52203$|^51272( 51272)*$|^41006( 41006)*$|^51589( 51589)*$|^56441( 56441)*$|^198655( 198655)*$|^39349( 39349)*$|^198525( 198525)*$|^196637( 196637)*$|^199061( 199061)*$|^48659( 48659)*$|^198176( 198176)*$|^48311( 48311)*$|^57978( 57978)*$|^50101( 50101)*$|^60563( 60563)*$|^44082( 44082)*$|^60279( 60279)*$|^199978( 199978)*$|^199978 ( .*) 52203$|^198766( 198766)*$|^44082 ( .*) 52110$|^41207( 41207)*$|^199720( 199720)*$|^199980( 199980)*$|^34076( 34076)*$|^42763 ( .*) 198051$|^201001( 201001)*$|^201001 ( .*) 57978*$|^198164( 198164)*$|^39439( 39439)*$|^204190( 204190)*$|^60323( 60323)*$|^196637( 196637)*$|^199723( 199723)*$|^206953( 206953)*$|^198418( 198418)*$|^207012( 207012)*$|^206685( 206685)*$|^202860( 202860)*$|^203064( 203064)*$|^197552( 197552)*$|^207218( 207218)*$|^204747( 204747)*$|^210085( 210085)*$|^205136( 205136)*$|^204190( 204190)*$|^39489( 39489)*$|^209430( 209430)*$|^205257( 205257)*$|^60563( 60563)*$|^50625( 50625)*$|^207311( 207311)*$|^212176( 212176)*$|^8834( 8834)*$|^211046( 211046)*$|^57360( 57360)*$|^210910( 210910)*$|^199855( 199855)*$"
    //set policy-options as-path 8 "^31381( 31381)*$|^8834( 8834)*$|^29323( 29323)*$|^42763( 42763)*$|^23456( 23456)*$|^3\.210( 3\.210)*$|^47229( 47229)*$|^3\.29( 3\.29)*$|^35596( 35596)*$|^44643( 44643)*$|^47329( 47329)*$|^51305( 51305)*$|^16340( 16340)*$|^16340 ( .*) 41006$|^16340 ( .*) 50450$|^16340 ( .*) 23456$|^16340 ( .*) 196969$|^16340 (.*) 51589$|^50829( 50829)*$|^39219( 39219)*$|^52203( 52203)*$|42763( 42763)* 52195( 52195)*$|^196969( 196969)*$|^49989( 49989)*$|^198048( 198048)*$|^198048 ( .*) 52203$|^199978 ( .*) 52203$|^51272( 51272)*$|^41006( 41006)*$|^51589( 51589)*$|^56441( 56441)*$|^198655( 198655)*$|^39349( 39349)*$|^198525( 198525)*$|^196637( 196637)*$|^199061( 199061)*$|^48659( 48659)*$|^198176( 198176)*$|^48311( 48311)*$|^57978( 57978)*$|^50101( 50101)*$|^60563( 60563)*$|^44082( 44082)*$|^60279( 60279)*$|^199978( 199978)*$|^198766( 198766)*$|^44082 ( .*) 52110$|^41207( 41207)*$|^199720( 199720)*$|^199980( 199980)*$|^34076( 34076)*$|^42763 ( .*) 198051$|^201001( 201001)*$|^201001 ( .*) 57978*$|^198164( 198164)*$|^39439( 39439)*$|^204190( 204190)*$|^60323( 60323)*$|^196637( 196637)*$|^199723( 199723)*$|^206953( 206953)*$|^198418( 198418)*$|^207012( 207012)*$|^206685( 206685)*$|^202860( 202860)*$|^203064( 203064)*$|^197552( 197552)*$|^207218( 207218)*$|^204747( 204747)*$|^210085( 210085)*$|^205136( 205136)*$|^204190( 204190)*$|^39489( 39489)*$|^209430( 209430)*$|^205257( 205257)*$|^60563( 60563)*$|^50625( 50625)*$|^207311( 207311)*$|^212176( 212176)*$|^8834( 8834)*$|^211046( 211046)*$|^57360( 57360)*$|^210910( 210910)*$|^199855( 199855)*$"
    $conf.="##### END OF CONFIG interconnect 89.228.0.51 Warszawa ##################################"."\n\n"; 

    return $conf;
}
function gen_interconnect_B2B_bgp_254_25($s_params,$migracja,$mtu_cisco,$mtu_juniper)
{
    $a_cont=array();
    //$ip_pa=   get_ip_pa($s_params['ip_pa']);  //w przypadku BGP adresy PA nie powinny istniec
    $ip_pi=   get_ip_pi($s_params['ip_pi']);
    $as_k=$s_params['as_klienta'];

    $conf.="##### Config interconnect 192.168.254.25 === 89.228.0.52 Warszawa ######################"."\n";
    if(count($ip_pi) >0)
    {
        $conf.="\n";
        for($i=0;$i<count($ip_pi);$i++)
        {        
            if(trim(str_replace(' ','',$ip_pi[$i])) !== '')
            {
                $conf.="set policy-options prefix-list bgp-clients-prefixes"." ".trim(str_replace(' ','',$ip_pi[$i]))."\n";
            }
        }
    }
    $conf.="\n";
    
    $file_doc='/raid0/apps/kk/devices_core/config/192.168.254.25';
    if(file_exists($file_doc))
    {
        $file_convert=convert_from_juniper($file_doc);
        $a_cont=explode("\n",$file_convert);
        for($i=0; $i<count($a_cont); $i++)
        {
            $pp=strpos($a_cont[$i],'set policy-options as-path 9');
            if($pp !== false)
            {
                $cc=str_replace('*$"','*$',$a_cont[$i]); //ostatni znak " nalezy usunac, poniewaz zamyka caly string. Nastepnie nalezy dodac na koncu
                $conf.=$cc.'|^'.$as_k.'( '.$as_k.')*$"';
                break;
            }
        }
        $conf.="\n\n";
        for($i=0; $i<count($a_cont); $i++)
        {
            $pp=strpos($a_cont[$i],'set policy-options as-path 8');
            if($pp !== false)
            {
                $cc=str_replace('*$"','*$',$a_cont[$i]);
                $conf.=$cc.'|^'.$as_k.'( '.$as_k.')*$"';
                break;
            }
        }
    }
    $conf.="\n\n";
    $conf.="##### END of config interconnect 89.228.0.52 Warszawa ###########################################"."\n\n";    
    //set policy-options as-path 9 "^29323( 29323)*$|^47229( 47229)*$|^23456( 23456)*$|^3\.210( 3\.210)*$|^3\.29( 3\.29)*$|^42763( 42763)*$|^35596( 35596)*$|^44643( 44643)*$|^51305( 51305)*$|16340( 16340)*$|^16340 ( .*) 41006$|^16340 ( .*) 50450$|^16340 ( .*) 23456$|^16340 ( .*) 196969$|^50829( 50829)*$|^39219( 39219)*$|^52203( 52203)*$|42763( 42763)* 52195( 52195)*$|^196969( 196969)*$|^49989( 49989)*$|^198048( 198048)*$|^198048 ( .*) 52203$|^51272( 51272)*$|^41006( 41006)*$|^51589( 51589)*$|^56441( 56441)*$|^198655( 198655)*$|^39349( 39349)*$|^198525( 198525)*$|^196637( 196637)*$|^199061( 199061)*$|^48659( 48659)*$|^198176( 198176)*$|^48311( 48311)*$|^57978( 57978)*$|^50101( 50101)*$|^60563( 60563)*$|^44082( 44082)*$|^60279( 60279)*$|^199978( 199978)*$|^199978 ( .*) 52203$|^198766( 198766)*$|^44082 ( .*) 52110$|^41207( 41207)*$|^199720( 199720)*$|^199980( 199980)*$|^34076( 34076)*$|^42763 ( .*) 198051$|^201001( 201001)*$|^201001 ( .*) 57978*$|^198164( 198164)*$|^39439( 39439)*$|^204190( 204190)*$|^60323( 60323)*$|^196637( 196637)*$|^199723( 199723)*$|^206953( 206953)*$|^198418( 198418)*$|^207012( 207012)*$|^206685( 206685)*$|^202860( 202860)*$|^203064( 203064)*$|^197552( 197552)*$|^207218( 207218)*$|^204747( 204747)*$|^210085( 210085)*$|^205136( 205136)*$|^204190( 204190)*$|^39489( 39489)*$|^209430( 209430)*$|^205257( 205257)*$|^60563( 60563)*$|^50625( 50625)*$|^207311( 207311)*$|^212176( 212176)*$|^8834( 8834)*$|^211046( 211046)*$|^57360( 57360)*$|^210910( 210910)*$|^199855( 199855)*$"
    //set policy-options as-path 8 "^31381( 31381)*$|^8834( 8834)*$|^29323( 29323)*$|^42763( 42763)*$|^23456( 23456)*$|^3\.210( 3\.210)*$|^47229( 47229)*$|^3\.29( 3\.29)*$|^35596( 35596)*$|^44643( 44643)*$|^47329( 47329)*$|^51305( 51305)*$|^16340( 16340)*$|^16340 ( .*) 41006$|^16340 ( .*) 50450$|^16340 ( .*) 23456$|^16340 ( .*) 196969$|^16340 (.*) 51589$|^50829( 50829)*$|^39219( 39219)*$|^52203( 52203)*$|42763( 42763)* 52195( 52195)*$|^196969( 196969)*$|^49989( 49989)*$|^198048( 198048)*$|^198048 ( .*) 52203$|^199978 ( .*) 52203$|^51272( 51272)*$|^41006( 41006)*$|^51589( 51589)*$|^56441( 56441)*$|^198655( 198655)*$|^39349( 39349)*$|^198525( 198525)*$|^196637( 196637)*$|^199061( 199061)*$|^48659( 48659)*$|^198176( 198176)*$|^48311( 48311)*$|^57978( 57978)*$|^50101( 50101)*$|^60563( 60563)*$|^44082( 44082)*$|^60279( 60279)*$|^199978( 199978)*$|^198766( 198766)*$|^44082 ( .*) 52110$|^41207( 41207)*$|^199720( 199720)*$|^199980( 199980)*$|^34076( 34076)*$|^42763 ( .*) 198051$|^201001( 201001)*$|^201001 ( .*) 57978*$|^198164( 198164)*$|^39439( 39439)*$|^204190( 204190)*$|^60323( 60323)*$|^196637( 196637)*$|^199723( 199723)*$|^206953( 206953)*$|^198418( 198418)*$|^207012( 207012)*$|^206685( 206685)*$|^202860( 202860)*$|^203064( 203064)*$|^197552( 197552)*$|^207218( 207218)*$|^204747( 204747)*$|^210085( 210085)*$|^205136( 205136)*$|^204190( 204190)*$|^39489( 39489)*$|^209430( 209430)*$|^205257( 205257)*$|^60563( 60563)*$|^50625( 50625)*$|^207311( 207311)*$|^212176( 212176)*$|^8834( 8834)*$|^211046( 211046)*$|^57360( 57360)*$|^210910( 210910)*$|^199855( 199855)*$"

    return $conf;
}
function gen_interconnect_B2B_bgp_233_20($s_params,$migracja,$mtu_cisco,$mtu_juniper)
{
    $a_cont=array();
    //$ip_pa=   get_ip_pa($s_params['ip_pa']);  //w przypadku BGP adresy PA nie powinny istniec
    $ip_pi=   get_ip_pi($s_params['ip_pi']);
    $as_k=$s_params['as_klienta'];
    
    $conf.="##### Config interconnect 192.168.233.20 === 89.228.0.53 Katowice ################################"."\n";
    if(count($ip_pi) >0)
    {
        $conf.="\n";
        for($i=0;$i<count($ip_pi);$i++)
        {        
            if(trim(str_replace(' ','',$ip_pi[$i])) !== '')
            {
                $conf.="set policy-options prefix-list bgp-clients-prefixes"." ".trim(str_replace(' ','',$ip_pi[$i]))."\n";
            }
        }
    }
    $conf.="\n";
    $file_doc='/raid0/apps/kk/devices_core/config/192.168.233.20';    
    if(file_exists($file_doc))
    {
        $file_convert=convert_from_juniper($file_doc);
        $a_cont=explode("\n",$file_convert);
        for($i=0; $i<count($a_cont); $i++)
        {
            $pp=strpos($a_cont[$i],'set policy-options as-path 9');
            if($pp !== false)
            {
                $cc=str_replace('*$"','*$',$a_cont[$i]);
                $conf.=$cc.'|^'.$as_k.'( '.$as_k.')*$"';
                break;
            }
        }
        $conf.="\n\n";
        for($i=0; $i<count($a_cont); $i++)
        {
            $pp=strpos($a_cont[$i],'set policy-options as-path 8');
            if($pp !== false)
            {
                $cc=str_replace('*$"','*$',$a_cont[$i]);
                $conf.=$cc.'|^'.$as_k.'( '.$as_k.')*$"';
                break;
            }
        }
    }
    $conf.="\n\n";
    //set policy-options prefix-list bgp-clients-prefixes 212.14.55.0/24
    //set policy-options as-path 9 "^29323( 29323)*$|^47229( 47229)*$|^23456( 23456)*$|^3\.210( 3\.210)*$|^3\.29( 3\.29)*$|^42763( 42763)*$|^35596( 35596)*$|^44643( 44643)*$|^51305( 51305)*$|16340( 16340)*$|^16340 ( .*) 41006$|^16340 ( .*) 50450$|^16340 ( .*) 23456$|^16340 ( .*) 196969$|^50829( 50829)*$|^39219( 39219)*$|^52203( 52203)*$|42763( 42763)* 52195( 52195)*$|^196969( 196969)*$|^49989( 49989)*$|^198048( 198048)*$|^198048 ( .*) 52203$|^51272( 51272)*$|^41006( 41006)*$|^51589( 51589)*$|^56441( 56441)*$|^198655( 198655)*$|^39349( 39349)*$|^198525( 198525)*$|^196637( 196637)*$|^199061( 199061)*$|^48659( 48659)*$|^198176( 198176)*$|^48311( 48311)*$|^57978( 57978)*$|^50101( 50101)*$|^60563( 60563)*$|^44082( 44082)*$|^60279( 60279)*$|^199978( 199978)*$|^199978 ( .*) 52203$|^198766( 198766)*$|^44082 ( .*) 52110$|^41207( 41207)*$|^199720( 199720)*$|^199980( 199980)*$|^34076( 34076)*$|^42763 ( .*) 198051$|^201001( 201001)*$|^201001 ( .*) 57978*$|^198164( 198164)*$|^39439( 39439)*$|^204190( 204190)*$|^60323( 60323)*$|^196637( 196637)*$|^199723( 199723)*$|^206953( 206953)*$|^198418( 198418)*$|^207012( 207012)*$|^206685( 206685)*$|^202860( 202860)*$|^203064( 203064)*$|^197552( 197552)*$|^207218( 207218)*$|^204747( 204747)*$|^210085( 210085)*$|^205136( 205136)*$|^204190( 204190)*$|^39489( 39489)*$|^209430( 209430)*$|^205257( 205257)*$|^60563( 60563)*$|^50625( 50625)*$|^207311( 207311)*$|^212176( 212176)*$|^8834( 8834)*$|^211046( 211046)*$|^57360( 57360)*$|^210910( 210910)*$|^199855( 199855)*$"
    //set policy-options as-path 8 "^31381( 31381)*$|^8834( 8834)*$|^29323( 29323)*$|^42763( 42763)*$|^23456( 23456)*$|^3\.210( 3\.210)*$|^47229( 47229)*$|^3\.29( 3\.29)*$|^35596( 35596)*$|^44643( 44643)*$|^47329( 47329)*$|^51305( 51305)*$|^16340( 16340)*$|^16340 ( .*) 41006$|^16340 ( .*) 50450$|^16340 ( .*) 23456$|^16340 ( .*) 196969$|^16340 (.*) 51589$|^50829( 50829)*$|^39219( 39219)*$|^52203( 52203)*$|42763( 42763)* 52195( 52195)*$|^196969( 196969)*$|^49989( 49989)*$|^198048( 198048)*$|^198048 ( .*) 52203$|^199978 ( .*) 52203$|^51272( 51272)*$|^41006( 41006)*$|^51589( 51589)*$|^56441( 56441)*$|^198655( 198655)*$|^39349( 39349)*$|^198525( 198525)*$|^196637( 196637)*$|^199061( 199061)*$|^48659( 48659)*$|^198176( 198176)*$|^48311( 48311)*$|^57978( 57978)*$|^50101( 50101)*$|^60563( 60563)*$|^44082( 44082)*$|^60279( 60279)*$|^199978( 199978)*$|^198766( 198766)*$|^44082 ( .*) 52110$|^41207( 41207)*$|^199720( 199720)*$|^199980( 199980)*$|^34076( 34076)*$|^42763 ( .*) 198051$|^201001( 201001)*$|^201001 ( .*) 57978*$|^198164( 198164)*$|^39439( 39439)*$|^204190( 204190)*$|^60323( 60323)*$|^196637( 196637)*$|^199723( 199723)*$|^206953( 206953)*$|^198418( 198418)*$|^207012( 207012)*$|^206685( 206685)*$|^202860( 202860)*$|^203064( 203064)*$|^197552( 197552)*$|^207218( 207218)*$|^204747( 204747)*$|^210085( 210085)*$|^205136( 205136)*$|^204190( 204190)*$|^39489( 39489)*$|^209430( 209430)*$|^205257( 205257)*$|^60563( 60563)*$|^50625( 50625)*$|^207311( 207311)*$|^212176( 212176)*$|^8834( 8834)*$|^211046( 211046)*$|^57360( 57360)*$|^210910( 210910)*$|^199855( 199855)*$"

    $conf.="##### END of config interconnect 89.228.0.53 Katowice ##################################################"."\n\n";    

    return $conf;
}

function gen_config_juniper_B2B_lokalny_bgp($s_params,$migracja,$mtu_cisco,$mtu_juniper)
{
    $ip_p2p=str_replace($zamiana_p,'',$s_params['ip_p2p']);
    $ip_p2p_mask=trim(get_ip_p2p_mask($s_params['ip_p2p']));
    $ip_p2p_1=str_replace($zamiana_p,'',trim(get_ip_p2p_1($s_params['ip_p2p'])));
    $ip_p2p_2=str_replace($zamiana_p,'',trim(get_ip_p2p_2($s_params['ip_p2p'])));    
    //$ip_pa=   get_ip_pa($s_params['ip_pa']);  //w przypadku BGP adresy PA nie powinny istniec
    $ip_pi=   get_ip_pi($s_params['ip_pi']);
    $download=trim(get_download($s_params['pasmo']));
    $burst_d=(int)($download/10);
    $upload=  trim(get_upload($s_params['pasmo']));
    $burst_u=(int)($upload/10);
    
    //Normalna konfiguracja dla polaczeniowki
    $conf='';
    $conf.="##########################################################################################"."\n";
    $conf.="##### B2B -- ".$s_params['miasto_a']."  ---  ".$s_params['ip_a']." --- ".$s_params['router_a']."\n\n";
    $conf.="##### B2B - Interface ####################################################################"."\n\n";
    $conf.="delete ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']."\n";
    
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." description ".$s_params['description_a']."\n";
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." vlan-tags outer ".$s_params['s_vlan']." inner ".$s_params['c_vlan']."\n";
    $conf.="###set interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." vlan-id ".$s_params['c_vlan']."\n";
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." family inet filter input ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_in"."\n";
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." family inet filter output ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_out"."\n";
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." family inet policer input ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."-IN"."\n";
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." family inet policer output ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."-OUT"."\n";
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." family inet address ".$ip_p2p_1."/".$ip_p2p_mask."\n";
    
    $conf.="\n";
    $conf.="##### B2B - filtr IN BGP ####################################################################"."\n\n";
    $conf.="delete ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_in";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_in term T1 from source-address ".$ip_p2p_2."/32"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_in term T1 from destination-address ".$ip_p2p_1."/32"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_in term T1 from protocol icmp"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_in term T1 then accept"."\n";

    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_in term T2 from source-address ".$ip_p2p_2."/32"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_in term T2 from destination-address ".$ip_p2p_1."/32"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_in term T2 from protocol tcp"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_in term T2 from port bgp"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_in term T2 then accept"."\n";
    
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_in term T3 from destination-address 192.168.0.0/16"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_in term T3 from destination-address 172.16.0.0/12"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_in term T3 from destination-address 10.0.0.0/8"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_in term T3 from destination-address ".$ip_p2p_1."/32"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_in term T3 then discard"."\n";
    
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_in term T4 from source-address ".$s_params['ip_p2p']."\n";
    //###########################################################################################################################################################################################    
    if(count($ip_pi) >0)
    {
        $conf.="\n";
        if($ip_pi[0] !== '') $conf.="##### B2B - adresacja PI ###################################################################################################"."\n";
        for($i=0;$i<count($ip_pi);$i++)
        {        
            if(trim(str_replace(' ','',$ip_pi[$i])) !== '') $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_in term T4 from source-address ".trim(str_replace(' ','',$ip_pi[$i]))."\n";
        }
    }
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_in term T4 then dscp 0"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_in term T4 then accept"."\n";
    
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_in term T5 then discard"."\n";
    
    $conf.="\n";
    
    $conf.="##### B2B - filtr OUT BGP ###################################################################################################"."\n";
    $conf.="delete ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_out";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_out term T1 from destination-address ".$s_params['ip_p2p']."\n";
    if(count($ip_pi) >0)
    {
        for($i=0;$i<count($ip_pi);$i++)
        {        
            if(trim(str_replace(' ','',$ip_pi[$i])) !== '')
                $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_out term T1 from destination-address ".trim(str_replace(' ','',$ip_pi[$i]))."\n";
        }
    }
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_out term T1 then accept"."\n";
    
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."_acl_out term T2 then discard"."\n";
    $conf.="\n";

    $conf.="##### B2B - policer ###################################################################################################"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."-IN if-exceeding bandwidth-limit ".$download."m"."\n";
    if($burst_d !== 0) $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."-IN if-exceeding burst-size-limit ".$burst_d."m"."\n";
    else $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."-IN if-exceeding burst-size-limit ".'1'."m"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."-IN then discard"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."-OUT if-exceeding bandwidth-limit ".$upload."m"."\n";
    if($burst_u !== 0) $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."-OUT if-exceeding burst-size-limit ".$burst_u."m"."\n";
    else $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."-OUT if-exceeding burst-size-limit ".'1'."m"."\n";    
    $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."-OUT then discard"."\n";
        
    $conf.="##### B2B - konfig ###################################################################################################"."\n";
    $conf.="\n";
    //filtry IN BGP
    $conf.="set ".$s_params['logical_system_a']." policy-options policy-statement ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."-IN term 1 from as-path "."as_path_".$s_params['nazwa_uslugi']."\n";
    $conf.="set ".$s_params['logical_system_a']." policy-options policy-statement ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."-IN term 1 from prefix-list "."prefix_list_".$s_params['nazwa_uslugi']."\n";
    $conf.="set ".$s_params['logical_system_a']." policy-options policy-statement ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."-IN term 1 then local-preference 300 "."\n";
    $conf.="set ".$s_params['logical_system_a']." policy-options policy-statement ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."-IN term 1 then accept "."\n";    
    $conf.="set ".$s_params['logical_system_a']." policy-options policy-statement ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."-IN term 2 then reject "."\n";

    //filtr OUT BGP
    $conf.="##### Konfig default route ###################################################################################################"."\n";
    $conf.="#set ".$s_params['logical_system_a']." policy-options policy-statement ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."-OUT term 1 from route-filter "."0.0.0.0/0"."\n";  //default route
    $conf.="#set ".$s_params['logical_system_a']." policy-options policy-statement ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."-OUT term 1 then accept "."\n";
    $conf.="set ".$s_params['logical_system_a']." policy-options policy-statement ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."-OUT term 1 from community no-adv-any"."\n";
    $conf.="set ".$s_params['logical_system_a']." policy-options policy-statement ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."-OUT term 1 then reject "."\n";
    $conf.="set ".$s_params['logical_system_a']." policy-options policy-statement ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."-OUT term 2 from community no-adv-peer-int"."\n";
    $conf.="set ".$s_params['logical_system_a']." policy-options policy-statement ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."-OUT term 2 then reject "."\n";
    $conf.="set ".$s_params['logical_system_a']." policy-options policy-statement ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."-OUT term 3 from protocol bgp"."\n";
    $conf.="set ".$s_params['logical_system_a']." policy-options policy-statement ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."-OUT term 3 then accept "."\n";
    
    $conf.="#set ".$s_params['logical_system_a']." policy-options policy-statement ".$s_params['nazwa_uslugi'].'_'.$s_params['s_unit']."-OUT term default then reject "."\n";

    if(count($ip_pi) >0)
    {
        $conf.="\n";
        for($i=0;$i<count($ip_pi);$i++)
        {        
            if(trim(str_replace(' ','',$ip_pi[$i])) !== '')
            {
                $conf.="set ".$s_params['logical_system_a']." policy-options prefix-list "."prefix_list_".$s_params['nazwa_uslugi']." ".trim(str_replace(' ','',$ip_pi[$i]))."\n";
            }
        }
    }
    
    #set policy-options as-path-group aspath16 as-path aspath_16_1 "^199978(_199978)*$"
    #set policy-options as-path-group aspath16 as-path aspath_16_2 "^199978(_199978)*_52203(_52203)*$"
    $conf.="\n";
    $as_k=trim(str_replace(' ','',$s_params['as_klienta']));
    $as_k_reg='"'.'^'.$as_k.'(_'.$as_k.')*$"';                   //"^8834(_8834)*$" 
    $conf.="set ".$s_params['logical_system_a']." policy-options as-path "."as_path_".$s_params['nazwa_uslugi']." ".$as_k_reg."\n";
    //lub
    $as_k_reg='"'.'^'.$as_k.'( '.$as_k.')*$"';
    $conf.="#set ".$s_params['logical_system_a']." policy-options as-path "."as_path_".$s_params['nazwa_uslugi']." ".$as_k_reg."\n";
    //lub
    $as_k_reg=$as_k.'+';
    $conf.="#set ".$s_params['logical_system_a']." policy-options as-path "."as_path_".$s_params['nazwa_uslugi']." ".$as_k_reg."\n";
    //lub
    //$as_k_reg='.*';  //all
    //$conf.="#set ".$s_params['logical_system_a']." policy-options as-path "."as_path_".$s_params['nazwa_uslugi']." ".$as_k_reg."\n";
    $conf.="\n";
    $conf.="##### Konfig BGP session ###################################################################################################"."\n";
    $prefix_list_max=count($ip_pi)+1;
    $conf.="\n";
    $conf.="set ".$s_params['logical_system_a']." protocols bgp group "."BGP_".$s_params['nazwa_uslugi']." type external"."\n";
    $conf.="set ".$s_params['logical_system_a']." protocols bgp group "."BGP_".$s_params['nazwa_uslugi']." import ".$s_params['nazwa_uslugi']."-IN"."\n";
    $conf.="#set ".$s_params['logical_system_a']." protocols bgp group "."BGP_".$s_params['nazwa_uslugi']." family inet unicast prefix-list maximum ".$prefix_list_max."\n";
    $conf.="set ".$s_params['logical_system_a']." protocols bgp group "."BGP_".$s_params['nazwa_uslugi']." family inet unicast prefix-list maximum ".$prefix_list_max."\n";
    $conf.="set ".$s_params['logical_system_a']." protocols bgp group "."BGP_".$s_params['nazwa_uslugi']." export ".$s_params['nazwa_uslugi']."-OUT"."\n";
    $conf.="set ".$s_params['logical_system_a']." protocols bgp group "."BGP_".$s_params['nazwa_uslugi']." remove-private"."\n";
    $conf.="set ".$s_params['logical_system_a']." protocols bgp group "."BGP_".$s_params['nazwa_uslugi']." peer-as ".$as_k."\n";
    $conf.="set ".$s_params['logical_system_a']." protocols bgp group "."BGP_".$s_params['nazwa_uslugi']." peer-as ".$as_k."\n";
    $conf.="#set ".$s_params['logical_system_a']." protocols bgp group "."BGP_".$s_params['nazwa_uslugi']." local-as ".'[wstawić local-as, jeżeli jest to konieczne, głównie dla starych sesji]'."\n";
    $conf.="set ".$s_params['logical_system_a']." protocols bgp group "."BGP_".$s_params['nazwa_uslugi']." neighbor ".$ip_p2p_2."\n";    

    return $conf;
}

//===========================================================================================================================================================================================
function gen_config_juniper_b($s_params,$migracja,$mtu_cisco,$mtu_juniper)
{
    $ip_p2p=str_replace($zamiana_p,'',$s_params['ip_p2p']);
    $ip_p2p_mask=trim(get_ip_p2p_mask($s_params['ip_p2p']));
    $ip_p2p_1=str_replace($zamiana_p,'',trim(get_ip_p2p_1($s_params['ip_p2p'])));
    $ip_p2p_2=str_replace($zamiana_p,'',trim(get_ip_p2p_2($s_params['ip_p2p'])));
    $ip_pa=   get_ip_pa($s_params['ip_pa']);
    $download=trim(get_download($s_params['pasmo']));
    $burst_d=(int)($download/10);
    $upload=  trim(get_upload($s_params['pasmo']));
    $burst_u=(int)($upload/10);
    
    if($s_params['ip_b'] !== '192.168.168.1')
    {
        $conf="";
        $conf.="#################################################################################\n\n";
        $conf.="#### Router B -- ".$s_params['miasto_b']."  ---  ".$s_params['ip_b']." --- ".$s_params['router_b']."\n";
        $conf.="#################################################################################\n";
        
        if($migracja===1 || $migracja==='1') $conf.="delete ".$s_params['logical_system_b']." interfaces ".$s_params['interface_b']." unit ".$s_params['c_vlan']."\n";    
        else $conf.="#delete ".$s_params['logical_system_b']." interfaces ".$s_params['interface_b']." unit ".$s_params['c_vlan']."\n";    
        if(count($ip_pa) >0)
        {
            for($i=0;$i<count($ip_pa);$i++)
            {    
                if($migracja===1 || $migracja==='1') 
                {
                    if(trim(str_replace(' ','',$ip_pa[$i])) !== '') $conf.="#delete ".$s_params['logical_system_b']." routing-options static route ".trim(str_replace(' ','',$ip_pa[$i]))." next-hop ".$ip_p2p_2."\n";
                } else
                {
                    if(trim(str_replace(' ','',$ip_pa[$i])) !== '') $conf.="#delete ".$s_params['logical_system_b']." routing-options static route ".trim(str_replace(' ','',$ip_pa[$i]))." next-hop ".$ip_p2p_2."\n";
                }
            }
            for($i=0;$i<count($ip_pa);$i++)
            {
                if($s_params['router_a']==='89.228.0.140')
                {
                    $ip_pa[$i]=trim(str_replace(';','',$ip_pa[$i]));
                    if($ip_pa[$i] !== '')
                    {
                        if($migracja===1 || $migracja==='1') $conf.="delete ".$s_params['logical_system_b']." policy-options policy-statement BGP_STATIC term static from route-filter ".trim(str_replace(' ','',$ip_pa[$i]))." orlonger"."\n"; //roznie jest na roznych routerach
                        else $conf.="#delete ".$s_params['logical_system_b']." policy-options policy-statement BGP_STATIC term static from route-filter ".trim(str_replace(' ','',$ip_pa[$i]))." orlonger"."\n"; //roznie jest na roznych routerach
                    }
                } else
                    {
                        if($migracja===1 || $migracja==='1')
                        {
                            $ip_pa[$i]=trim(str_replace(';','',$ip_pa[$i]));
                            if($ip_pa[$i] !== '')
                            {
                                $conf.="delete ".$s_params['logical_system_b']." policy-options policy-statement BGP_STATIC term static from route-filter ".trim(str_replace(' ','',$ip_pa[$i]))." orlonger"."\n"; //roznie jest na roznych routerach
                                $conf.="delete ".$s_params['logical_system_b']." policy-options policy-statement BGP_STATIC term static from route-filter ".trim(str_replace(' ','',$ip_pa[$i]))." exact"."\n";
                                $conf.="delete ".$s_params['logical_system_b']." policy-options prefix-list pfx_BGP_STATIC_p1_permit ".trim(str_replace(' ','',$ip_pa[$i]))."\n";
                            }
                        } else
                        {
                            $ip_pa[$i]=trim(str_replace(';','',$ip_pa[$i]));
                            if($ip_pa[$i] !== '')
                            {
                                $conf.="#delete ".$s_params['logical_system_b']." policy-options policy-statement BGP_STATIC term static from route-filter ".trim(str_replace(' ','',$ip_pa[$i]))." orlonger"."\n"; //roznie jest na roznych routerach
                                $conf.="#delete ".$s_params['logical_system_b']." policy-options policy-statement BGP_STATIC term static from route-filter ".trim(str_replace(' ','',$ip_pa[$i]))." exact"."\n";
                                $conf.="#delete ".$s_params['logical_system_b']." policy-options prefix-list pfx_BGP_STATIC_p1_permit ".trim(str_replace(' ','',$ip_pa[$i]))."\n";
                            }
                        }
                    }
                if($s_params['router_a']==='89.228.0.154')
                {
                    $ip_pa[$i]=str_replace(';','',$ip_pa[$i]);
                    if($ip_pa[$i] !== '')
                    {
                        if($migracja===1 || $migracja==='1') $conf.="delete ".$s_params['logical_system_b']." policy-options policy-statement BGP_STATIC term static from route-filter ".trim(str_replace(' ','',$ip_pa[$i]))." orlonger"."\n"; //roznie jest na roznych routerach
                        else $conf.="#delete ".$s_params['logical_system_b']." policy-options policy-statement BGP_STATIC term static from route-filter ".trim(str_replace(' ','',$ip_pa[$i]))." orlonger"."\n"; //roznie jest na roznych routerach
                    }
                } else
                    {
                        if($migracja===1 || $migracja==='1')
                        {    
                            $conf.="delete ".$s_params['logical_system_b']." policy-options policy-statement BGP_STATIC term static from route-filter ".trim(str_replace(' ','',$ip_pa[$i]))." orlonger"."\n"; //roznie jest na roznych routerach
                            $conf.="delete ".$s_params['logical_system_b']." policy-options policy-statement BGP_STATIC term static from route-filter ".trim(str_replace(' ','',$ip_pa[$i]))." exact"."\n";
                            $conf.="delete ".$s_params['logical_system_b']." policy-options prefix-list pfx_BGP_STATIC_p1_permit ".trim(str_replace(' ','',$ip_pa[$i]))."\n";
                        } else
                        {
                            $conf.="#delete ".$s_params['logical_system_b']." policy-options policy-statement BGP_STATIC term static from route-filter ".trim(str_replace(' ','',$ip_pa[$i]))." orlonger"."\n"; //roznie jest na roznych routerach
                            $conf.="#delete ".$s_params['logical_system_b']." policy-options policy-statement BGP_STATIC term static from route-filter ".trim(str_replace(' ','',$ip_pa[$i]))." exact"."\n";
                            $conf.="#delete ".$s_params['logical_system_b']." policy-options prefix-list pfx_BGP_STATIC_p1_permit ".trim(str_replace(' ','',$ip_pa[$i]))."\n";
                        }
                    }
            }
        }
        
        if($migracja===1 || $migracja==='1')
        {
            $conf.="delete ".$s_params['logical_system_b']." protocols ospf area 0.0.0.0 interface ".$s_params['interface_b'].'.'.$s_params['c_vlan']." passive"."\n";
            $conf.="delete ".$s_params['logical_system_b']." policy-options policy-statement BGP_STATIC term static from route-filter ".$ip_p2p_2." orlonger"."\n";
            //$conf.="delete ".$s_params['logical_system_b']." policy-options policy-statement BGP_STATIC term static from route-filter ".$ip_p2p_2." exact"."\n";
            //$conf.="delete ".$s_params['logical_system_b']." policy-options prefix-list pfx_BGP_STATIC_p1_permit ".$ip_p2p_2."\n";

            $conf.="#################################################################################\n\n";    
            $conf.="\n";
            //$conf.="#delete ".$s_params['logical_system_b']." interfaces ".$s_params['interface_b']." unit ".$s_params['d_unit']." vlan-id-list ". $s_params['c_vlan']."\n";
            $conf.="set ".$s_params['logical_system_b']." interfaces ".$s_params['interface_b']." unit ".$s_params['d_unit']." vlan-id-list ". $s_params['c_vlan']."\n\n";
            
            $conf.="#set ".$s_params['logical_system_b']." interfaces ".$s_params['interface_b']." unit ".$s_params['d_unit']." description Biznes_L2VPN_Wawa_B2B_do_Pereca"."\n";
            $conf.="#set ".$s_params['logical_system_b']." interfaces ".$s_params['interface_b']." unit ".$s_params['d_unit']." encapsulation vlan-ccc"."\n";    
            $conf.="#set ".$s_params['logical_system_b']." interfaces ".$s_params['interface_b']." unit ".$s_params['d_unit']." input-vlan-map push"."\n";
            $conf.="#set ".$s_params['logical_system_b']." interfaces ".$s_params['interface_b']." unit ".$s_params['d_unit']." vlan-id-list ". $s_params['s_vlan']."\n";
            $conf.="#set ".$s_params['logical_system_b']." interfaces ".$s_params['interface_b']." unit ".$s_params['d_unit']." output-vlan-map pop"."\n";
            $conf.="#set ".$s_params['logical_system_b']." interfaces ".$s_params['interface_b']." unit ".$s_params['d_unit']." input-vlan-map vlan-id ".$s_params['s_vlan']."\n\n";
            $conf.="\n\n";
        } else
        {
            $conf.="#################################################################################\n\n";    
            $conf.="\n";
            $conf.="set ".$s_params['logical_system_b']." interfaces ".$s_params['interface_b']." unit ".$s_params['d_unit']." vlan-id-list ". $s_params['c_vlan']."\n\n\n";
            
            $conf.="#delete ".$s_params['logical_system_b']." protocols ospf area 0.0.0.0 interface ".$s_params['interface_b'].'.'.$s_params['c_vlan']." passive"."\n";
            $conf.="#delete ".$s_params['logical_system_b']." policy-options policy-statement BGP_STATIC term static from route-filter ".$ip_p2p_2." orlonger"."\n";
            //$conf.="delete ".$s_params['logical_system_b']." policy-options policy-statement BGP_STATIC term static from route-filter ".$ip_p2p_2." exact"."\n";
            //$conf.="delete ".$s_params['logical_system_b']." policy-options prefix-list pfx_BGP_STATIC_p1_permit ".$ip_p2p_2."\n";           
            $conf.="#delete ".$s_params['logical_system_b']." interfaces ".$s_params['interface_b']." unit ".$s_params['d_unit']." vlan-id-list ". $s_params['c_vlan']."\n";
                    
            $conf.="\n\n";
            $conf.="#set ".$s_params['logical_system_b']." interfaces ".$s_params['interface_b']." unit ".$s_params['d_unit']." description Biznes_L2VPN_Wawa_B2B_do_Pereca"."\n";
            $conf.="#set ".$s_params['logical_system_b']." interfaces ".$s_params['interface_b']." unit ".$s_params['d_unit']." encapsulation vlan-ccc"."\n";    
            $conf.="#set ".$s_params['logical_system_b']." interfaces ".$s_params['interface_b']." unit ".$s_params['d_unit']." input-vlan-map push"."\n";
            $conf.="#set ".$s_params['logical_system_b']." interfaces ".$s_params['interface_b']." unit ".$s_params['d_unit']." vlan-id-list ". $s_params['s_vlan']."\n";
            $conf.="#set ".$s_params['logical_system_b']." interfaces ".$s_params['interface_b']." unit ".$s_params['d_unit']." output-vlan-map pop"."\n";
            $conf.="#set ".$s_params['logical_system_b']." interfaces ".$s_params['interface_b']." unit ".$s_params['d_unit']." input-vlan-map vlan-id ".$s_params['s_vlan']."\n";
            $conf.="\n\n";
        }

        //$conf.="### IF NOT EXISTS - create Xconnect to Pereca ##############################################################################\n";
        //$conf.="#set ".$s_params['logical_system_b']." protocols l2circuit neighbor 89.228.0.50 interface ".$s_params['interface_b'].'.'.$s_params['s_vlan']." virtual-circuit-id ".$s_params['s_vlan']."\n";
        //$conf.="#set ".$s_params['logical_system_a']." protocols l2circuit neighbor 89.228.0.50 interface ".$s_params['interface_b'].'.'.$s_params['s_vlan']." flow-label-transmit"."\n";
        //$conf.="#set ".$s_params['logical_system_a']." protocols l2circuit neighbor 89.228.0.50 interface ".$s_params['interface_b'].'.'.$s_params['s_vlan']." flow-label-receive"."\n";
        //$conf.="#set ".$s_params['logical_system_b']." protocols l2circuit neighbor 89.228.0.50 interface ".$s_params['interface_b'].'.'.$s_params['s_vlan']." mtu 9200"."\n";
        //if($s_params['router_b_typ']==='JUNIPER')
        //{
        //    $conf.="#set ".$s_params['logical_system_b']." protocols l2circuit neighbor 89.228.0.50 interface ".$s_params['interface_b'].'.'.$s_params['s_vlan']." encapsulation-type ethernet"."\n";  
        //} else $conf.="#set ".$s_params['logical_system_b']." protocols l2circuit neighbor 89.228.0.50 interface ".$s_params['interface_b'].'.'.$s_params['s_vlan']." encapsulation-type ethernet-vlan"."\n";
        //$conf.="### END of Xconnect to Pereca if not exists ##############################################################################\n";    
    }
    
    if($s_params['ip_b'] === '192.168.164.1')
    {
        $conf="";
        $conf.="#################################################################################\n\n";
        $conf.="#### Router B -- ".$s_params['miasto_b']."  ---  ".$s_params['ip_b']." --- ".$s_params['router_b']."\n";
        $conf.="#################################################################################\n";
        
        $conf.="#delete ".$s_params['logical_system_b']." interfaces ".$s_params['interface_b']." unit ".$s_params['c_vlan']."\n";    
        if(count($ip_pa) >0)
        {
            for($i=0;$i<count($ip_pa);$i++)
            {        
                if(trim(str_replace(' ','',$ip_pa[$i])) !== '') $conf.="#delete ".$s_params['logical_system_b']." routing-options static route ".trim(str_replace(' ','',$ip_pa[$i]))." next-hop ".$ip_p2p_2."\n";
            }
        }
        $conf.="#delete ".$s_params['logical_system_b']." protocols ospf area 0.0.0.0 interface ".$s_params['interface_b'].'.'.$s_params['c_vlan']." passive"."\n";
        $conf.="#delete ".$s_params['logical_system_b']." policy-options policy-statement BGP_STATIC term static from route-filter ".$ip_p2p_2." orlonger"."\n";
        //$conf.="delete ".$s_params['logical_system_b']." policy-options policy-statement BGP_STATIC term static from route-filter ".$ip_p2p_2." exact"."\n";
        //$conf.="delete ".$s_params['logical_system_b']." policy-options prefix-list pfx_BGP_STATIC_p1_permit ".$ip_p2p_2."\n";

        $conf.="#################################################################################\n\n";    
        $conf.="\n";
        $conf.="#delete ".$s_params['logical_system_b']." interfaces ".$s_params['interface_b']." unit ".$s_params['d_unit']." vlan-id-list ". $s_params['c_vlan']."\n";
        
        $conf.="set ".$s_params['logical_system_b']." interfaces ".$s_params['interface_b']." unit ".$s_params['d_unit']." vlan-id-list ". $s_params['c_vlan']."\n";
        $conf.="\n\n";
        $conf.="#set ".$s_params['logical_system_b']." interfaces ".$s_params['interface_b']." unit ".$s_params['d_unit']." description Biznes_L2VPN_Wawa_B2B_do_Pereca"."\n";
        $conf.="#set ".$s_params['logical_system_b']." interfaces ".$s_params['interface_b']." unit ".$s_params['d_unit']." encapsulation vlan-ccc"."\n";    
        $conf.="#set ".$s_params['logical_system_b']." interfaces ".$s_params['interface_b']." unit ".$s_params['d_unit']." input-vlan-map push"."\n";
        $conf.="#set ".$s_params['logical_system_b']." interfaces ".$s_params['interface_b']." unit ".$s_params['d_unit']." vlan-id-list ". $s_params['s_vlan']."\n";
        $conf.="#set ".$s_params['logical_system_b']." interfaces ".$s_params['interface_b']." unit ".$s_params['d_unit']." output-vlan-map pop"."\n";
        $conf.="#set ".$s_params['logical_system_b']." interfaces ".$s_params['interface_b']." unit ".$s_params['d_unit']." input-vlan-map vlan-id ".$s_params['s_vlan']."\n";
        $conf.="\n\n";
        
        $conf.="#### IF NOT EXIST ON PERECA #############################################################################\n\n";    
        $conf.="\n";
        $conf.="#set ".$s_params['logical_system_b']." set protocols connections interface-switch BIZNES_B2B interface ".$s_params['interface_b'].".".$s_params['d_unit']."\n"; //xe-1/1/17.1198
        $conf.="#set ".$s_params['logical_system_b']." set protocols connections interface-switch BIZNES_B2B interface ae20".".".$s_params['d_unit']."\n"; //1198
        $conf.="#### END ON PERECA #############################################################################\n\n";    
    }
    
    return $conf;
}
//========================================================================================================================================================================================================
function gen_config_juniper_xconnect_a($s_params,$migracja,$mtu_cisco,$mtu_juniper)
{
    $download=trim(get_download($s_params['pasmo']));
    $burst_d=(int)($download/10);
    $upload=  trim(get_upload($s_params['pasmo']));
    $burst_u=(int)($upload/10);

    $conf='';
    $conf.="#### Router A ".$s_params['miasto_a']." --- ".$s_params['ip_a']."  -- ".$s_params['router_a']." ############################"."\n\n";
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." description ".$s_params['description_a']."\n";
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." encapsulation vlan-ccc"."\n";
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." vlan-id ".$s_params['c_vlan']."\n";
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." family ccc policer input "."Biznes_L2_download_".$download."\n";
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." family ccc policer output "."Biznes_L2_upload_".$upload."\n";
    $conf.="\n\n";
    
    $conf.="set ".$s_params['logical_system_a']." firewall policer "."Biznes_L2_download_".$download." if-exceeding bandwidth-limit ".$download."m"."\n";
    if($burst_d !== 0) $conf.="set ".$s_params['logical_system_a']." firewall policer "."Biznes_L2_download_".$download." if-exceeding burst-size-limit ".$burst_d."m"."\n";
    else $conf.="set ".$s_params['logical_system_a']." firewall policer "."Biznes_L2_download_".$download." if-exceeding burst-size-limit ".'1'."m"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall policer "."Biznes_L2_download_".$download." then discard"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall policer "."Biznes_L2_upload_".$upload." if-exceeding bandwidth-limit ".$upload."m"."\n";
    if($burst_u !== 0) $conf.="set ".$s_params['logical_system_a']." firewall policer "."Biznes_L2_upload_".$upload." if-exceeding burst-size-limit ".$burst_u."m"."\n";
    else $conf.="set ".$s_params['logical_system_a']." firewall policer "."Biznes_L2_upload_".$upload." if-exceeding burst-size-limit ".'1'."m"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall policer "."Biznes_L2_upload_".$upload." then discard"."\n";

    $conf.="\n\n";
        
    $conf.="set ".$s_params['logical_system_a']." protocols l2circuit neighbor ".$s_params['router_b']." interface ".$s_params['interface_a'].'.'.$s_params['c_vlan']." virtual-circuit-id ".$s_params['c_vlan']."\n";
    $conf.="set ".$s_params['logical_system_a']." protocols l2circuit neighbor ".$s_params['router_b']." interface ".$s_params['interface_a'].'.'.$s_params['c_vlan']." encapsulation-type ethernet"."\n";
    $conf.="set ".$s_params['logical_system_a']." protocols l2circuit neighbor ".$s_params['router_b']." interface ".$s_params['interface_a'].'.'.$s_params['c_vlan']." flow-label-transmit"."\n";
    $conf.="set ".$s_params['logical_system_a']." protocols l2circuit neighbor ".$s_params['router_b']." interface ".$s_params['interface_a'].'.'.$s_params['c_vlan']." flow-label-receive"."\n";
    $conf.="set ".$s_params['logical_system_a']." protocols l2circuit neighbor ".$s_params['router_b']." interface ".$s_params['interface_a'].'.'.$s_params['c_vlan']." mtu ".$mtu_juniper."\n";
        
    return $conf;
}

function gen_config_juniper_xconnect_encaps_vlan_a($s_params,$migracja,$mtu_cisco,$mtu_juniper)
{
    $download=trim(get_download($s_params['pasmo']));
    $burst_d=(int)($download/10);
    $upload=  trim(get_upload($s_params['pasmo']));
    $burst_u=(int)($upload/10);

    $conf='';
    $conf.="#### Router A ".$s_params['miasto_a']." --- ".$s_params['ip_a']."  -- ".$s_params['router_a']." ############################"."\n\n";
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." description ".$s_params['description_a']."\n";
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." encapsulation vlan-ccc"."\n";
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." vlan-id ".$s_params['c_vlan']."\n";
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." family ccc policer input "."Biznes_L2_download_".$download."\n";
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." family ccc policer output "."Biznes_L2_upload_".$upload."\n";
    $conf.="\n\n";
    
    $conf.="set ".$s_params['logical_system_a']." firewall policer "."Biznes_L2_download_".$download." if-exceeding bandwidth-limit ".$download."m"."\n";
    if($burst_d !== 0) $conf.="set ".$s_params['logical_system_a']." firewall policer "."Biznes_L2_download_".$download." if-exceeding burst-size-limit ".$burst_d."m"."\n";
    else $conf.="set ".$s_params['logical_system_a']." firewall policer "."Biznes_L2_download_".$download." if-exceeding burst-size-limit ".'1'."m"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall policer "."Biznes_L2_download_".$download." then discard"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall policer "."Biznes_L2_upload_".$upload." if-exceeding bandwidth-limit ".$upload."m"."\n";
    if($burst_u !== 0) $conf.="set ".$s_params['logical_system_a']." firewall policer "."Biznes_L2_upload_".$upload." if-exceeding burst-size-limit ".$burst_u."m"."\n";
    else $conf.="set ".$s_params['logical_system_a']." firewall policer "."Biznes_L2_upload_".$upload." if-exceeding burst-size-limit ".'1'."m"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall policer "."Biznes_L2_upload_".$upload." then discard"."\n";

    $conf.="\n\n";
        
    $conf.="set ".$s_params['logical_system_a']." protocols l2circuit neighbor ".$s_params['router_b']." interface ".$s_params['interface_a'].'.'.$s_params['c_vlan']." virtual-circuit-id ".$s_params['c_vlan']."\n";
    $conf.="set ".$s_params['logical_system_a']." protocols l2circuit neighbor ".$s_params['router_b']." interface ".$s_params['interface_a'].'.'.$s_params['c_vlan']." encapsulation-type vlan"."\n";
    $conf.="set ".$s_params['logical_system_a']." protocols l2circuit neighbor ".$s_params['router_b']." interface ".$s_params['interface_a'].'.'.$s_params['c_vlan']." flow-label-transmit"."\n";
    $conf.="set ".$s_params['logical_system_a']." protocols l2circuit neighbor ".$s_params['router_b']." interface ".$s_params['interface_a'].'.'.$s_params['c_vlan']." flow-label-receive"."\n";
    $conf.="set ".$s_params['logical_system_a']." protocols l2circuit neighbor ".$s_params['router_b']." interface ".$s_params['interface_a'].'.'.$s_params['c_vlan']." mtu ".$mtu_juniper."\n";
        
    return $conf;
}

function gen_config_juniper_xconnect_b($s_params,$migracja,$mtu_cisco,$mtu_juniper)
{
    $download=trim(get_download($s_params['pasmo']));
    $burst_d=(int)($download/10);
    $upload=  trim(get_upload($s_params['pasmo']));
    $burst_u=(int)($upload/10);    
    
    if($d_unit==='') $d_unit=$s_params['s_unit'];
    if($d_vlan==='') $d_vlan=$s_params['c_vlan'];

    $conf='';
    $conf.="#### Router B ".$s_params['miasto_b']." ---  ".$s_params['ip_b']." -- ".$s_params['router_b']." ##########################"."\n\n";
    $conf.="set ".$s_params['logical_system_b']." interfaces ".$s_params['interface_b']." unit ".$s_params['d_unit']." description ".$s_params['description_b']."\n";
    $conf.="set ".$s_params['logical_system_b']." interfaces ".$s_params['interface_b']." unit ".$s_params['d_unit']." encapsulation vlan-ccc"."\n";
    $conf.="set ".$s_params['logical_system_b']." interfaces ".$s_params['interface_b']." unit ".$s_params['d_unit']." vlan-id ".$s_params['d_vlan']."\n";
    $conf.="set ".$s_params['logical_system_b']." interfaces ".$s_params['interface_b']." unit ".$s_params['d_unit']." family ccc policer input "."Biznes_L2_download_".$download."\n";
    $conf.="set ".$s_params['logical_system_b']." interfaces ".$s_params['interface_b']." unit ".$s_params['d_unit']." family ccc policer output "."Biznes_L2_upload_".$upload."\n";
    $conf.="\n\n";
    
    $conf.="set ".$s_params['logical_system_b']." firewall policer "."Biznes_L2_download_".$download." if-exceeding bandwidth-limit ".$download."m"."\n";
    if($burst_d !== 0) $conf.="set ".$s_params['logical_system_b']." firewall policer "."Biznes_L2_download_".$download." if-exceeding burst-size-limit ".$burst_d."m"."\n";
    else $conf.="set ".$s_params['logical_system_b']." firewall policer "."Biznes_L2_download_".$download." if-exceeding burst-size-limit ".'1'."m"."\n";
    $conf.="set ".$s_params['logical_system_b']." firewall policer "."Biznes_L2_download_".$download." then discard"."\n";
    $conf.="set ".$s_params['logical_system_b']." firewall policer "."Biznes_L2_upload_".$upload." if-exceeding bandwidth-limit ".$upload."m"."\n";
    if($burst_u !== 0) $conf.="set ".$s_params['logical_system_b']." firewall policer "."Biznes_L2_upload_".$upload." if-exceeding burst-size-limit ".$burst_u."m"."\n";
    else $conf.="set ".$s_params['logical_system_b']." firewall policer "."Biznes_L2_upload_".$upload." if-exceeding burst-size-limit ".'1'."m"."\n";
    $conf.="set ".$s_params['logical_system_b']." firewall policer "."Biznes_L2_upload_".$upload." then discard"."\n";

    $conf.="\n\n";
        
    $conf.="set ".$s_params['logical_system_b']." protocols l2circuit neighbor ".$s_params['router_a']." interface ".$s_params['interface_b'].'.'.$s_params['c_vlan']." virtual-circuit-id ".$s_params['c_vlan']."\n";
    $conf.="set ".$s_params['logical_system_b']." protocols l2circuit neighbor ".$s_params['router_a']." interface ".$s_params['interface_b'].'.'.$s_params['c_vlan']." encapsulation-type ethernet"."\n";
    $conf.="set ".$s_params['logical_system_b']." protocols l2circuit neighbor ".$s_params['router_a']." interface ".$s_params['interface_b'].'.'.$s_params['c_vlan']." flow-label-transmit"."\n";
    $conf.="set ".$s_params['logical_system_b']." protocols l2circuit neighbor ".$s_params['router_a']." interface ".$s_params['interface_b'].'.'.$s_params['c_vlan']." flow-label-receive"."\n";
    $conf.="set ".$s_params['logical_system_b']." protocols l2circuit neighbor ".$s_params['router_a']." interface ".$s_params['interface_b'].'.'.$s_params['c_vlan']." mtu ".$mtu_juniper."\n";

    $conf.="\n\n\n".$conf_t;
    return $conf;
}

function gen_config_juniper_xconnect_encaps_vlan_b($s_params,$migracja,$mtu_cisco,$mtu_juniper)
{
    $download=trim(get_download($s_params['pasmo']));
    $burst_d=(int)($download/10);
    $upload=  trim(get_upload($s_params['pasmo']));
    $burst_u=(int)($upload/10);    
    
    if($d_unit==='') $d_unit=$s_params['s_unit'];
    if($d_vlan==='') $d_vlan=$s_params['c_vlan'];

    $conf='';
    $conf.="#### Router B ".$s_params['miasto_b']." ---  ".$s_params['ip_b']." -- ".$s_params['router_b']." ##########################"."\n\n";
    $conf.="set ".$s_params['logical_system_b']." interfaces ".$s_params['interface_b']." unit ".$s_params['d_unit']." description ".$s_params['description_b']."\n";
    $conf.="set ".$s_params['logical_system_b']." interfaces ".$s_params['interface_b']." unit ".$s_params['d_unit']." encapsulation vlan-ccc"."\n";
    $conf.="set ".$s_params['logical_system_b']." interfaces ".$s_params['interface_b']." unit ".$s_params['d_unit']." vlan-id ".$s_params['d_vlan']."\n";
    $conf.="set ".$s_params['logical_system_b']." interfaces ".$s_params['interface_b']." unit ".$s_params['d_unit']." family ccc policer input "."Biznes_L2_download_".$download."\n";
    $conf.="set ".$s_params['logical_system_b']." interfaces ".$s_params['interface_b']." unit ".$s_params['d_unit']." family ccc policer output "."Biznes_L2_upload_".$upload."\n";
    $conf.="\n\n";
    
    $conf.="set ".$s_params['logical_system_b']." firewall policer "."Biznes_L2_download_".$download." if-exceeding bandwidth-limit ".$download."m"."\n";
    if($burst_d !== 0) $conf.="set ".$s_params['logical_system_b']." firewall policer "."Biznes_L2_download_".$download." if-exceeding burst-size-limit ".$burst_d."m"."\n";
    else $conf.="set ".$s_params['logical_system_b']." firewall policer "."Biznes_L2_download_".$download." if-exceeding burst-size-limit ".'1'."m"."\n";
    $conf.="set ".$s_params['logical_system_b']." firewall policer "."Biznes_L2_download_".$download." then discard"."\n";
    $conf.="set ".$s_params['logical_system_b']." firewall policer "."Biznes_L2_upload_".$upload." if-exceeding bandwidth-limit ".$upload."m"."\n";
    if($burst_u !== 0) $conf.="set ".$s_params['logical_system_b']." firewall policer "."Biznes_L2_upload_".$upload." if-exceeding burst-size-limit ".$burst_u."m"."\n";
    else $conf.="set ".$s_params['logical_system_b']." firewall policer "."Biznes_L2_upload_".$upload." if-exceeding burst-size-limit ".'1'."m"."\n";
    $conf.="set ".$s_params['logical_system_b']." firewall policer "."Biznes_L2_upload_".$download." then discard"."\n";

    $conf.="\n\n";
        
    $conf.="set ".$s_params['logical_system_b']." protocols l2circuit neighbor ".$s_params['router_a']." interface ".$s_params['interface_b'].'.'.$s_params['c_vlan']." virtual-circuit-id ".$s_params['c_vlan']."\n";
    $conf.="set ".$s_params['logical_system_b']." protocols l2circuit neighbor ".$s_params['router_a']." interface ".$s_params['interface_b'].'.'.$s_params['c_vlan']." encapsulation-type vlan"."\n";
    $conf.="set ".$s_params['logical_system_b']." protocols l2circuit neighbor ".$s_params['router_a']." interface ".$s_params['interface_b'].'.'.$s_params['c_vlan']." flow-label-transmit"."\n";
    $conf.="set ".$s_params['logical_system_b']." protocols l2circuit neighbor ".$s_params['router_a']." interface ".$s_params['interface_b'].'.'.$s_params['c_vlan']." flow-label-receive"."\n";
    $conf.="set ".$s_params['logical_system_b']." protocols l2circuit neighbor ".$s_params['router_a']." interface ".$s_params['interface_b'].'.'.$s_params['c_vlan']." mtu ".$mtu_juniper."\n";

    $conf.="\n\n\n".$conf_t;
    return $conf;
}

function gen_config_cisco_tr($s_params,$migracja,$mtu_cisco,$mtu_juniper)
{
    $download=trim(get_download($s_params['pasmo']));
    $upload=  trim(get_upload($s_params['pasmo']));    

    $s_vlan=$s_params['s_vlan'];
    if($s_vlan==='') $s_vlan=$s_params['c_vlan']; //konieczne dla zwyklego tranzytu
    $conf='';
    $conf.="!!!! Router CISCO B ".$s_params['ip_b']." --- ".$s_params['router_b']."\n\n";
    
    $conf.="interface ".$s_params['interface_b'].'.'.$s_vlan." l2transport"."\n";
    $conf.="    description ".$s_params['description_a']."\n";
    $conf.="    encapsulation dot1q ".$s_params['c_vlan']."\n";
    $conf.="    mtu ".$mtu_cisco."\n";
    $conf.="    rewrite ingress tag pop 1 symmetric"."\n";
    $conf.="    service-policy input ".$s_params['nazwa_uslugi']."_IN"."\n";
    $conf.="    service-policy output ".$s_params['nazwa_uslugi']."_OUT"."\n";
    $conf.="exit"."\n";
    $conf.="\n\n";
    
    $conf.="policy-map ".$s_params['nazwa_uslugi']."_IN"."\n";
    $conf.="    class class-default"."\n";
    $conf.="    police rate ".$download." mbps"."\n";
    $conf.="end-policy-map"."\n";
    $conf.="\n\n";
    
    $conf.="policy-map ".$s_params['nazwa_uslugi']."_OUT"."\n";
    $conf.="    class class-default"."\n";
    $conf.="    police rate ".$upload." mbps"."\n";
    $conf.="end-policy-map"."\n";

    $conf.="\n\n";

    $conf.="l2vpn"."\n";
    $conf.="    pw-class ptp_B2B_vlan_".$s_vlan."\n";
    $conf.="    encapsulation mpls"."\n";
    $conf.="    control-word"."\n";    
    $conf.="    protocol ldp"."\n";
    $conf.="    transport-mode vlan"."\n";
    $conf.="    !!transport-mode ethernet"."\n";
    $conf.="exit"."\n";
    $conf.="exit"."\n";
    $conf.="exit"."\n";
    
    $conf.="l2vpn"."\n";
    $conf.="    xconnect group ptp_B2B_vlan_".$s_vlan."\n";
    $conf.="    p2p ptp_B2B_vlan_".$s_vlan."\n";
    $conf.="    interface ".$s_params['interface_b'].'.'.$s_vlan."\n";
    $conf.="    neighbor ipv4 ".$s_params['router_a']." pw-id ".$s_vlan."\n";
    $conf.="        pw-class ptp_B2B_vlan_".$s_vlan."\n";
    $conf.="        exit"."\n";
    $conf.="    exit"."\n";
    $conf.="exit"."\n";
    $conf.="exit"."\n";
    $conf.="\n\n";
    
    return $conf;
}

function gen_config_cisco_xconnect_a($s_params,$migracja,$mtu_cisco,$mtu_juniper)
{
    $download=trim(get_download($s_params['pasmo']));
    $upload=  trim(get_upload($s_params['pasmo']));    
    
    $s_vlan=$s_params['c_vlan'];
    if($s_vlan==='') $s_vlan=$s_params['c_vlan']; //konieczne dla zwyklego tranzytu
    $conf='';
    $conf.="!!!! Router CISCO A ".$s_params['ip_a']." --- ".$s_params['router_a']."\n\n";
    
    $conf.="interface ".$s_params['interface_a'].'.'.$s_params['c_vlan']." l2transport"."\n";
    $conf.="    description ".$s_params['description_a']."\n";
    $conf.="    encapsulation dot1q ".$s_params['c_vlan']."\n";
    $conf.="    mtu ".$mtu_cisco."\n";
    $conf.="    rewrite ingress tag pop 1 symmetric"."\n";
    $conf.="    service-policy input ".$s_params['nazwa_uslugi']."_IN"."\n";
    $conf.="    service-policy output ".$s_params['nazwa_uslugi']."_OUT"."\n";
    $conf.="exit"."\n";
    $conf.="\n\n";
    
    $conf.="policy-map ".$s_params['nazwa_uslugi']."_IN"."\n";
    $conf.="    class class-default"."\n";
    $conf.="    police rate ".$download." mbps"."\n";
    $conf.="end-policy-map"."\n";
    $conf.="\n\n";
    
    $conf.="policy-map ".$s_params['nazwa_uslugi']."_OUT"."\n";
    $conf.="    class class-default"."\n";
    $conf.="    police rate ".$upload." mbps"."\n";
    $conf.="end-policy-map"."\n";

    $conf.="\n\n";

    $conf.="l2vpn"."\n";
    $conf.="    pw-class ptp_B2B_vlan_".$s_params['c_vlan']."\n";
    $conf.="    encapsulation mpls"."\n";
    $conf.="    control-word"."\n";    
    $conf.="    protocol ldp"."\n";
    $conf.="    transport-mode vlan"."\n";
    $conf.="    !!transport-mode ethernet"."\n";
    $conf.="exit"."\n";
    $conf.="exit"."\n";
    $conf.="exit"."\n";
    
    $conf.="l2vpn"."\n";
    $conf.="    xconnect group ptp_B2B_vlan_".$s_params['c_vlan']."\n";
    $conf.="    p2p ptp_B2B_vlan_".$s_params['c_vlan']."\n";
    $conf.="    interface ".$s_params['interface_a'].'.'.$s_params['c_vlan']."\n";
    $conf.="    neighbor ipv4 ".$s_params['router_b']." pw-id ".$s_params['c_vlan']."\n";
    $conf.="        pw-class ptp_B2B_vlan_".$s_params['c_vlan']."\n";
    $conf.="        exit"."\n";
    $conf.="    exit"."\n";
    $conf.="exit"."\n";
    $conf.="exit"."\n";
    $conf.="\n\n";
    
    return $conf;
}

function gen_config_cisco_xconnect_encaps_vlan_a($s_params,$migracja,$mtu_cisco,$mtu_juniper)
{
    $download=trim(get_download($s_params['pasmo']));
    $upload=  trim(get_upload($s_params['pasmo']));    
    
    $s_vlan=$s_params['c_vlan'];
    if($s_vlan==='') $s_vlan=$s_params['c_vlan']; //konieczne dla zwyklego tranzytu
    $conf='';
    $conf.="!!!! Router CISCO A ".$s_params['ip_a']." --- ".$s_params['router_a']."\n\n";
    
    $conf.="interface ".$s_params['interface_a'].'.'.$s_params['c_vlan']." l2transport"."\n";
    $conf.="    description ".$s_params['description_a']."\n";
    $conf.="    encapsulation dot1q ".$s_params['c_vlan']."\n";
    $conf.="    mtu ".$mtu_cisco."\n";
    $conf.="    rewrite ingress tag pop 1 symmetric"."\n";
    $conf.="    service-policy input ".$s_params['nazwa_uslugi']."_IN"."\n";
    $conf.="    service-policy output ".$s_params['nazwa_uslugi']."_OUT"."\n";
    $conf.="exit"."\n";
    $conf.="\n\n";
    
    $conf.="policy-map ".$s_params['nazwa_uslugi']."_IN"."\n";
    $conf.="    class class-default"."\n";
    $conf.="    police rate ".$download." mbps"."\n";
    $conf.="end-policy-map"."\n";
    $conf.="\n\n";
    
    $conf.="policy-map ".$s_params['nazwa_uslugi']."_OUT"."\n";
    $conf.="    class class-default"."\n";
    $conf.="    police rate ".$upload." mbps"."\n";
    $conf.="end-policy-map"."\n";

    $conf.="\n\n";

    $conf.="l2vpn"."\n";
    $conf.="    pw-class ptp_B2B_vlan_".$s_params['c_vlan']."\n";
    $conf.="    encapsulation mpls"."\n";
    $conf.="    control-word"."\n";    
    $conf.="    protocol ldp"."\n";
    $conf.="    transport-mode vlan"."\n";
    $conf.="    !transport-mode ethernet"."\n";
    $conf.="exit"."\n";
    $conf.="exit"."\n";
    $conf.="exit"."\n";
    
    $conf.="l2vpn"."\n";
    $conf.="    xconnect group ptp_B2B_vlan_".$s_params['c_vlan']."\n";
    $conf.="    p2p ptp_B2B_vlan_".$s_params['c_vlan']."\n";
    $conf.="    interface ".$s_params['interface_a'].'.'.$s_params['c_vlan']."\n";
    $conf.="    neighbor ipv4 ".$s_params['router_b']." pw-id ".$s_params['c_vlan']."\n";
    $conf.="        pw-class ptp_B2B_vlan_".$s_params['c_vlan']."\n";
    $conf.="        exit"."\n";
    $conf.="    exit"."\n";
    $conf.="exit"."\n";
    $conf.="exit"."\n";
    $conf.="\n\n";
    
    return $conf;
}

function gen_config_cisco_xconnect_b($s_params,$migracja,$mtu_cisco,$mtu_juniper)
{
    $download=trim(get_download($s_params['pasmo']));
    $upload=  trim(get_upload($s_params['pasmo']));    
    
    $s_vlan=$s_params['c_vlan'];
    if($s_vlan==='') $s_vlan=$s_params['c_vlan']; //konieczne dla zwyklego tranzytu
    $conf='';
    $conf.="!!!! Router CISCO B ".$s_params['ip_b']." --- ".$s_params['router_b']."\n\n";
    
    $conf.="interface ".$s_params['interface_b'].'.'.$s_params['c_vlan']." l2transport"."\n";
    $conf.="    description ".$s_params['description_b']."\n";
    $conf.="    encapsulation dot1q ".$s_params['c_vlan']."\n";
    $conf.="    mtu ".$mtu_cisco."\n";
    $conf.="    rewrite ingress tag pop 1 symmetric"."\n";
    $conf.="    service-policy input ".$s_params['nazwa_uslugi']."_IN"."\n";
    $conf.="    service-policy output ".$s_params['nazwa_uslugi']."_OUT"."\n";
    $conf.="exit"."\n";
    $conf.="\n\n";
    
    $conf.="policy-map ".$s_params['nazwa_uslugi']."_IN"."\n";
    $conf.="    class class-default"."\n";
    $conf.="    police rate ".$download." mbps"."\n";
    $conf.="end-policy-map"."\n";
    $conf.="\n\n";
    
    $conf.="policy-map ".$s_params['nazwa_uslugi']."_OUT"."\n";
    $conf.="    class class-default"."\n";
    $conf.="    police rate ".$upload." mbps"."\n";
    $conf.="end-policy-map"."\n";

    $conf.="\n\n";

    $conf.="l2vpn"."\n";
    $conf.="    pw-class ptp_B2B_vlan_".$s_params['c_vlan']."\n";
    $conf.="    encapsulation mpls"."\n";
    $conf.="    control-word"."\n";    
    $conf.="    protocol ldp"."\n";
    $conf.="    transport-mode vlan"."\n";
    $conf.="    !!transport-mode ethernet"."\n";
    $conf.="exit"."\n";
    
    $conf.="l2vpn"."\n";
    $conf.="    xconnect group ptp_B2B_vlan_".$s_params['c_vlan']."\n";
    $conf.="    p2p ptp_B2B_vlan_".$s_params['c_vlan']."\n";
    $conf.="    interface ".$s_params['interface_b'].'.'.$s_params['c_vlan']."\n";
    $conf.="    neighbor ipv4 ".$s_params['router_a']." pw-id ".$s_params['c_vlan']."\n";
    $conf.="        pw-class ptp_B2B_vlan_".$s_params['c_vlan']."\n";
    $conf.="        exit"."\n";
    $conf.="    exit"."\n";
    $conf.="exit"."\n";
    $conf.="exit"."\n";
    $conf.="\n\n";
    
    return $conf;
}

function gen_config_cisco_xconnect_encaps_vlan_b($s_params,$migracja,$mtu_cisco,$mtu_juniper)
{
    $download=trim(get_download($s_params['pasmo']));
    $upload=  trim(get_upload($s_params['pasmo']));    
    
    $s_vlan=$s_params['s_vlan'];
    if($s_vlan==='') $s_vlan=$s_params['c_vlan']; //konieczne dla zwyklego tranzytu
    $conf='';
    $conf.="!!!! Router CISCO B ".$s_params['ip_b']." --- ".$s_params['router_b']."\n\n";
    
    $conf.="interface ".$s_params['interface_b'].'.'.$s_params['c_vlan']." l2transport"."\n";
    $conf.="    description ".$s_params['description_b']."\n";
    $conf.="    encapsulation dot1q ".$s_params['c_vlan']."\n";
    $conf.="    mtu ".$mtu_cisco."\n";
    $conf.="    rewrite ingress tag pop 1 symmetric"."\n";
    $conf.="    service-policy input ".$s_params['nazwa_uslugi']."_IN"."\n";
    $conf.="    service-policy output ".$s_params['nazwa_uslugi']."_OUT"."\n";
    $conf.="exit"."\n";
    $conf.="\n\n";
    
    $conf.="policy-map ".$s_params['nazwa_uslugi']."_IN"."\n";
    $conf.="    class class-default"."\n";
    $conf.="    police rate ".$download." mbps"."\n";
    $conf.="end-policy-map"."\n";
    $conf.="\n\n";
    
    $conf.="policy-map ".$s_params['nazwa_uslugi']."_OUT"."\n";
    $conf.="    class class-default"."\n";
    $conf.="    police rate ".$upload." mbps"."\n";
    $conf.="end-policy-map"."\n";

    $conf.="\n\n";

    $conf.="l2vpn"."\n";
    $conf.="    pw-class ptp_B2B_vlan_".$s_params['c_vlan']."\n";
    $conf.="    encapsulation mpls"."\n";
    $conf.="    control-word"."\n";    
    $conf.="    protocol ldp"."\n";
    $conf.="    transport-mode vlan"."\n";
    $conf.="    !transport-mode ethernet"."\n";
    $conf.="exit"."\n";
    
    $conf.="l2vpn"."\n";
    $conf.="    xconnect group ptp_B2B_vlan_".$s_params['c_vlan']."\n";
    $conf.="    p2p ptp_B2B_vlan_".$s_params['c_vlan']."\n";
    $conf.="    interface ".$s_params['interface_b'].'.'.$s_params['c_vlan']."\n";
    $conf.="    neighbor ipv4 ".$s_params['router_a']." pw-id ".$s_params['c_vlan']."\n";
    $conf.="        pw-class ptp_B2B_vlan_".$s_params['c_vlan']."\n";
    $conf.="        exit"."\n";
    $conf.="    exit"."\n";
    $conf.="exit"."\n";
    $conf.="exit"."\n";
    $conf.="\n\n";
    
    return $conf;
}
//=======================================================================================================================================================================================================

function gen_config_juniper_sip_a($s_params,$migracja,$mtu_cisco,$mtu_juniper)
{
    $ip_p2p=str_replace($zamiana_p,'',$s_params['ip_p2p']);
    $ip_p2p_mask=trim(get_ip_p2p_mask($s_params['ip_p2p']));
    $ip_p2p_1=str_replace($zamiana_p,'',trim(get_ip_p2p_1($s_params['ip_p2p'])));
    $ip_p2p_2=str_replace($zamiana_p,'',trim(get_ip_p2p_2($s_params['ip_p2p'])));
    //$download=trim(get_download($s_params['pasmo']));
    //$burst_d=(int)($download/10);
    //$upload=  trim(get_upload($s_params['pasmo']));
    //$burst_u=(int)($upload/10);    
    
    $conf='';
    $conf.="#####################################################################"."\n";
    $conf.="##### B2B --  ".$s_params['miasto_a']." --- ".$s_params['ip_a']." --- ".$s_params['router_a']."\n\n";
    $conf.="##### B2B - Interface"."\n\n";
    $conf.="#delete interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']."\n";
    
    $conf.="set interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." description ".$s_params['description_a']."\n";
    $conf.="set interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." vlan-tags outer ".$s_params['s_vlan']." inner ".$s_params['c_vlan']."\n";
    //$conf.="set interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." family inet filter input ".$s_params['nazwa_uslugi']."_acl_in"."\n";
    //$conf.="set interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." family inet filter output ".$s_params['nazwa_uslugi']."_acl_out"."\n";
    $conf.="set interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." family inet address ".$ip_p2p_1."/".$ip_p2p_mask."\n";
    $conf.="set interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." family mpls"."\n";

    $conf.="\n\n";
    $conf.="##### B2B - filtr"."\n\n";
    $conf.="#delete firewall family inet filter ".$s_params['nazwa_uslugi']."_acl_in"."\n";
    
    $conf.="set firewall family inet filter ".$s_params['nazwa_uslugi']."_acl_in term T1 from source-address ".$ip_p2p_2."/32"."\n";
    $conf.="set firewall family inet filter ".$s_params['nazwa_uslugi']."_acl_in term T1 from destination-address ".$ip_p2p_1."/32"."\n";
    $conf.="set firewall family inet filter ".$s_params['nazwa_uslugi']."_acl_in term T1 from protocol icmp"."\n";
    $conf.="set firewall family inet filter ".$s_params['nazwa_uslugi']."_acl_in term T1 then accept"."\n";
    $conf.="set firewall family inet filter ".$s_params['nazwa_uslugi']."_acl_in term T2 from source-address ".$s_params['ip_p2p']."\n";
    $conf.="set firewall family inet filter ".$s_params['nazwa_uslugi']."_acl_in term T2 from destination-address 172.16.192.0/29"."\n";
    $conf.="set firewall family inet filter ".$s_params['nazwa_uslugi']."_acl_in term T2 from destination-address 172.16.199.248/29"."\n";
    $conf.="set firewall family inet filter ".$s_params['nazwa_uslugi']."_acl_in term T2 then accept"."\n";
    $conf.="set firewall family inet filter ".$s_params['nazwa_uslugi']."_acl_in term T3 from source-address ".$ip_p2p_2."/32"."\n";
    $conf.="set firewall family inet filter ".$s_params['nazwa_uslugi']."_acl_in term T3 from destination-address 172.16.65.0/24"."\n";
    $conf.="set firewall family inet filter ".$s_params['nazwa_uslugi']."_acl_in term T3 from destination-address 172.16.67.0/24"."\n";    
    $conf.="set firewall family inet filter ".$s_params['nazwa_uslugi']."_acl_in term T3 then accept"."\n";
    $conf.="set firewall family inet filter ".$s_params['nazwa_uslugi']."_acl_in term T4 then discard"."\n";
    $conf.="\n";
    $conf.="#delete firewall family inet filter ".$s_params['nazwa_uslugi']."_acl_out"."\n";
    
    $conf.="set firewall family inet filter ".$s_params['nazwa_uslugi']."_acl_out term T1 from source-address ".$ip_p2p_1."/32"."\n";
    $conf.="set firewall family inet filter ".$s_params['nazwa_uslugi']."_acl_out term T1 from destination-address ".$ip_p2p_2."/32"."\n";
    $conf.="set firewall family inet filter ".$s_params['nazwa_uslugi']."_acl_out term T1 from protocol icmp"."\n";
    $conf.="set firewall family inet filter ".$s_params['nazwa_uslugi']."_acl_out term T1 then accept"."\n";
    $conf.="set firewall family inet filter ".$s_params['nazwa_uslugi']."_acl_out term T2 from source-address 172.16.192.0/29"."\n";
    $conf.="set firewall family inet filter ".$s_params['nazwa_uslugi']."_acl_out term T2 from source-address 172.16.199.248/29"."\n";
    $conf.="set firewall family inet filter ".$s_params['nazwa_uslugi']."_acl_out term T2 from destination-address ".$s_params['ip_p2p']."\n";
    $conf.="set firewall family inet filter ".$s_params['nazwa_uslugi']."_acl_out term T2 then accept"."\n";
    $conf.="set firewall family inet filter ".$s_params['nazwa_uslugi']."_acl_out term T3 from source-address 172.16.65.0/24"."\n";
    $conf.="set firewall family inet filter ".$s_params['nazwa_uslugi']."_acl_out term T3 from source-address 172.16.67.0/24"."\n";
    $conf.="set firewall family inet filter ".$s_params['nazwa_uslugi']."_acl_out term T3 from source-address 172.16.199.248/29"."\n";
    $conf.="set firewall family inet filter ".$s_params['nazwa_uslugi']."_acl_out term T3 from destination-address ".$ip_p2p_2."/32"."\n";
    $conf.="set firewall family inet filter ".$s_params['nazwa_uslugi']."_acl_out term T3 then accept"."\n";
    $conf.="set firewall family inet filter ".$s_params['nazwa_uslugi']."_acl_out term T4 then discard"."\n";
    
    $conf.="set routing-instances SBC-SIP interface ".$s_params['interface_a'].'.'.$s_params['s_unit']."\n";

    return $conf;
}

function gen_config_juniper_sip_b($s_params,$migracja,$mtu_cisco,$mtu_juniper)
{
    $ip_p2p=str_replace($zamiana_p,'',$s_params['ip_p2p']);
    $ip_p2p_mask=trim(get_ip_p2p_mask($s_params['ip_p2p']));
    $ip_p2p_1=str_replace($zamiana_p,'',trim(get_ip_p2p_1($s_params['ip_p2p'])));
    $ip_p2p_2=str_replace($zamiana_p,'',trim(get_ip_p2p_2($s_params['ip_p2p'])));
    $download=trim(get_download($s_params['pasmo']));
    $burst_d=(int)($download/10);
    $upload=  trim(get_upload($s_params['pasmo']));
    $burst_u=(int)($upload/10);    
    
    $d_unit=$s_params['d_unit'];
    if($d_unit==='') $d_unit=$s_params['s_unit'];
    if($d_vlan==='') $d_vlan=$s_params['s_vlan'];

    $conf="";
    $conf.="#################################################################################\n\n";
    $conf.="#### Router B -- ".$s_params['ip_b']." --- ".$s_params['router_b']."\n";
    $conf.="#################################################################################\n";
    $conf.="#delete interfaces ".$s_params['interface_b']." unit ".$s_params['c_vlan']."\n";
    $conf.="#delete protocols ospf area 0.0.0.0 interface ".$s_params['interface_b'].'.'.$s_params['c_vlan']." passive"."\n";
    $conf.="#################################################################################\n\n";    
    $conf.="\n\n";
    
    $conf.="#delete ".$s_params['logical_system_b']." interfaces ".$s_params['interface_b']." unit ".$s_params['d_unit']." vlan-id-list ". $s_params['c_vlan']."\n";
    
    $conf.="#set ".$s_params['logical_system_b']." interfaces ".$s_params['interface_b']." unit ".$d_unit." description Biznes_L2VPN_Wawa_B2B_do_Pereca"."\n";
    $conf.="#set ".$s_params['logical_system_b']." interfaces ".$s_params['interface_b']." unit ".$d_unit." encapsulation vlan-ccc"."\n";
    $conf.="set ".$s_params['logical_system_b']." interfaces ".$s_params['interface_b']." unit ".$d_unit." vlan-id-list ".$s_params['c_vlan']."\n";
    $conf.="#set ".$s_params['logical_system_b']." interfaces ".$s_params['interface_b']." unit ".$d_unit." input-vlan-map push"."\n";
    $conf.="#set ".$s_params['logical_system_b']." interfaces ".$s_params['interface_b']." unit ".$d_unit." vlan-id-list ".$s_params['s_vlan']."\n";
    $conf.="#set ".$s_params['logical_system_b']." interfaces ".$s_params['interface_b']." unit ".$d_unit." output-vlan-map pop"."\n"; 
    $conf.="#set ".$s_params['logical_system_b']." interfaces ".$s_params['interface_b']." unit ".$sd_unit." input-vlan-map vlan-id ".$s_params['s_vlan']."\n";
    $conf.="\n\n";
    
    //$conf.="set protocols l2circuit neighbor 89.228.0.50 interface ".$s_params['interface_b'].'.'.$s_params['s_vlan']." virtual-circuit-id ".$s_params['s_vlan']."\n";
    //$conf.="set protocols l2circuit neighbor 89.228.0.50 interface ".$s_params['interface_b'].'.'.$s_params['s_vlan']." mtu 9200"."\n";
    //if($s_params['router_b_typ']==='JUNIPER')
    //{
    //    $conf.="set protocols l2circuit neighbor 89.228.0.50 interface ".$s_params['interface_b'].'.'.$s_params['s_vlan']." encapsulation-type ethernet"."\n";  
    //} else $conf.="set protocols l2circuit neighbor 89.228.0.50 interface ".$s_params['interface_b'].'.'.$s_params['s_vlan']." encapsulation-type ethernet-vlan"."\n";
        
    return $conf;
}

function gen_config_cisco_sip($s_params,$migracja,$mtu_cisco,$mtu_juniper)
{
    $ip_p2p=str_replace($zamiana_p,'',$s_params['ip_p2p']);
    $ip_p2p_mask=trim(get_ip_p2p_mask($s_params['ip_p2p']));
    $ip_p2p_1=str_replace($zamiana_p,'',trim(get_ip_p2p_1($s_params['ip_p2p'])));
    $ip_p2p_2=str_replace($zamiana_p,'',trim(get_ip_p2p_2($s_params['ip_p2p'])));
    $ip_pa=   get_ip_pa($s_params['ip_pa']);
    $download=trim(get_download($s_params['pasmo']));
    $upload=  trim(get_upload($s_params['pasmo']));

    $s_vlan=$s_params['s_vlan'];
    if($s_vlan==='') $s_vlan=$s_params['c_vlan']; //konieczne dla zwyklego tranytu

    $conf='';
    $conf.="!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n\n";
    $conf.="!!!! Router CISCO B -- ".$s_params['ip_b']." --- ".$s_params['router_b']."\n\n";    
    $conf.="!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n";
    $conf.="no interface ".$s_params['interface_b'].'.'.$s_params['c_vlan']."\n";   
    //$conf.="exit"."\n";
    $conf.="\n\n";
    $conf.="!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n\n";  
    $conf.='router ospf 10'."\n";
    $conf.=' area 0'."\n";
    $conf.='  no interface '.$s_params['interface_b'].'.'.$s_params['c_vlan']."\n";
    $conf.="exit"."\n";
    $conf.="exit"."\n";
    if(count($ip_pa) > 0)
    {
        if($ip_pa[0] !== '')
        {
            $conf.="\n\n";
            $conf.="prefix-set BGP_STATIC"."\n";
            for($i=0; $i<count($ip_pa);$i++)
            {
                list($ip,$maska)=explode('/',$ip_pa[$i]);
                if(trim($ip_pa[$i]) !== '') $conf.=" no ".$ip_pa[$i].' ge '.'/'.$maska."\n";
            }
            $conf.="exit"."\n";
            //$conf.="exit"."\n";
        
            $conf.="\n\n";
            $conf.="router static"."\n";
            $conf.="address-family ipv4 unicast"."\n";
            for($i=0; $i<count($ip_pa);$i++)
            {
                list($ip,$maska)=explode('/',$ip_pa[$i]);
                if(trim($ip_pa[$i]) !== '') $conf.=" no ".$ip_pa[$i].' '.$ip_p2p_2."\n";
            }
            $conf.="exit"."\n";
            $conf.="exit"."\n";
        }
    }
    $conf.="!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n\n";    
    $conf.="\n\n\n";
    
    $conf.="interface ".$s_params['interface_b'].'.'.$s_vlan." l2transport"."\n";
    $conf.="    description Biznes_L2VPN_Warszawa_B2B_do_Pereca"."\n";
    $conf.="    encapsulation dot1q ".$s_params['c_vlan']."\n";
    $conf.="    mtu ".$mtu_cisco."\n";
    //$conf.="    rewrite ingress tag pop 1 symmetric"."\n";
    $conf.="exit"."\n";
    $conf.="\n\n\n";
                
    $conf.="l2vpn"."\n";
    $conf.="    pw-class ptp_B2B_vlan_".$s_vlan."\n";
    $conf.="    encapsulation mpls"."\n";
    $conf.="    control-word"."\n";    
    $conf.="    protocol ldp"."\n";
    $conf.="    !transport-mode vlan"."\n";
    $conf.="    transport-mode ethernet"."\n";
    $conf.="exit"."\n";
    
    $conf.="l2vpn"."\n";
    $conf.="    xconnect group ptp_B2B_vlan_".$s_vlan."\n";
    $conf.="    p2p ptp_B2B_vlan_".$s_vlan."\n";
    $conf.="    interface ".$s_params['interface_b'].'.'.$s_vlan."\n";
    $conf.="    neighbor ipv4 "." 89.228.0.50 "." pw-id ".$s_vlan."\n";
    $conf.="        pw-class ptp_B2B_vlan_".$s_vlan."\n";
    $conf.="        exit"."\n";
    $conf.="    exit"."\n";
    $conf.="exit"."\n";
    $conf.="exit"."\n";
    $conf.="\n\n";
    
    return $conf;
}

function gen_config_cisco_sip_t_b($s_params,$migracja,$mtu_cisco,$mtu_juniper)
{
    $c_vlans_zakres=find_c_vlans($s_params,$s_params['router_b_typ']); //szuka konfiguracji vlanow interfejsu cisco B
    $c_vlan_s=$c_vlans_zakres;
    
    $conf='';
    $conf.="!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n\n";
    $conf.="!!!! Router CISCO B -- ".$s_params['ip_b']." --- ".$s_params['router_b']."\n\n";    
    $conf.="!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n\n";
    $s_vlan=$s_params['s_vlan'];
    if($s_params['s_vlan']==='') $s_vlan=$s_params['c_vlan']; //konieczne dla zwyklego tranzytu
    $conf.="interface ".$s_params['interface_b'].'.'.$s_vlan." l2transport"."\n";
    //$conf.="    encapsulation dot1q ".$c_vlan_s.', '.$s_params['c_vlan']."\n";  //pełna linia z encapsulacją jest zwracana przez funkcję "find_c_vlan". Możliwe, że w linii jest nie tylko 'encapsulation dot1q ...'
    $conf.=$c_vlan_s.', '.$s_params['c_vlan']."\n";
    $conf.="exit"."\n\n\n";
    write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Conf 1: '.  $c_vlan_s);
    write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Conf 2: '.  $conf);
    $conf.="!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!";    
    
    return $conf;    
}

function gen_config_juniper_sip_t_a($s_params,$migracja,$mtu_cisco,$mtu_juniper)
{
    $ip_p2p=str_replace($zamiana_p,'',$s_params['ip_p2p']);
    $ip_p2p_mask=trim(get_ip_p2p_mask($s_params['ip_p2p']));
    $ip_p2p_1=str_replace($zamiana_p,'',trim(get_ip_p2p_1($s_params['ip_p2p'])));
    $ip_p2p_2=str_replace($zamiana_p,'',trim(get_ip_p2p_2($s_params['ip_p2p'])));
    $download=trim(get_download($s_params['pasmo']));
    $burst_d=(int)($download/10);
    $upload=  trim(get_upload($s_params['pasmo']));
    $burst_u=(int)($upload/10);
        
    $conf='';
    $conf.="#####################################################################"."\n";
    $conf.="##### B2B -- ".$s_params['ip_a']." --- ".$s_params['router_a']."\n\n";
    $conf.="##### B2B - Interface"."\n\n";
    $conf.="#delete interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']."\n";
    
    $conf.="set interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." description ".$s_params['description_a']."\n";
    $conf.="set interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." vlan-tags outer ".$s_params['s_vlan']." inner ".$s_params['c_vlan']."\n";
    //$conf.="set interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." family inet filter input ".$s_params['nazwa_uslugi']."_acl_in"."\n";
    //$conf.="set interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." family inet filter output ".$s_params['nazwa_uslugi']."_acl_out"."\n";
    $conf.="set interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." family inet address ".$ip_p2p_1."/".$ip_p2p_mask."\n";
    $conf.="set interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." family mpls"."\n";

    $conf.="\n\n";
    $conf.="##### B2B - filtr"."\n\n";
    $conf.="#delete firewall family inet filter ".$s_params['nazwa_uslugi']."_acl_in"."\n";
    
    $conf.="set firewall family inet filter ".$s_params['nazwa_uslugi']."_acl_in term T1 from source-address ".$ip_p2p_2."/32"."\n";
    $conf.="set firewall family inet filter ".$s_params['nazwa_uslugi']."_acl_in term T1 from destination-address ".$ip_p2p_1."/32"."\n";
    $conf.="set firewall family inet filter ".$s_params['nazwa_uslugi']."_acl_in term T1 from protocol icmp"."\n";
    $conf.="set firewall family inet filter ".$s_params['nazwa_uslugi']."_acl_in term T1 then accept"."\n";
    
    $conf.="set firewall family inet filter ".$s_params['nazwa_uslugi']."_acl_in term T2 from source-address ".$s_params['ip_p2p']."\n";
    $conf.="set firewall family inet filter ".$s_params['nazwa_uslugi']."_acl_in term T2 from destination-address 172.16.200.0/29"."\n";
    //$conf.="set firewall family inet filter ".$s_params['nazwa_uslugi']."_acl_in term T2 from destination-address 172.16.207.248/29"."\n";
    $conf.="set firewall family inet filter ".$s_params['nazwa_uslugi']."_acl_in term T2 then accept"."\n";
    
    $conf.="set firewall family inet filter ".$s_params['nazwa_uslugi']."_acl_in term T3 from source-address ".$ip_p2p_2."/32"."\n";
    $conf.="set firewall family inet filter ".$s_params['nazwa_uslugi']."_acl_in term T3 from destination-address 172.16.65.0/24"."\n";
    $conf.="set firewall family inet filter ".$s_params['nazwa_uslugi']."_acl_in term T3 from destination-address 172.16.67.0/24"."\n";    
    $conf.="set firewall family inet filter ".$s_params['nazwa_uslugi']."_acl_in term T3 then accept"."\n";
    
    $conf.="set firewall family inet filter ".$s_params['nazwa_uslugi']."_acl_in term T4 then discard"."\n";
    $conf.="\n";
    
    $conf.="#delete firewall family inet filter ".$s_params['nazwa_uslugi']."_acl_out"."\n";
    
    $conf.="set firewall family inet filter ".$s_params['nazwa_uslugi']."_acl_out term T1 from source-address ".$ip_p2p_1."/32"."\n";
    $conf.="set firewall family inet filter ".$s_params['nazwa_uslugi']."_acl_out term T1 from destination-address ".$ip_p2p_2."/32"."\n";
    $conf.="set firewall family inet filter ".$s_params['nazwa_uslugi']."_acl_out term T1 from protocol icmp"."\n";
    $conf.="set firewall family inet filter ".$s_params['nazwa_uslugi']."_acl_out term T1 then accept"."\n";
    
    $conf.="set firewall family inet filter ".$s_params['nazwa_uslugi']."_acl_out term T2 from source-address 172.16.200.0/29"."\n";
    $conf.="set firewall family inet filter ".$s_params['nazwa_uslugi']."_acl_out term T2 from destination-address ".$s_params['ip_p2p']."\n";
    $conf.="set firewall family inet filter ".$s_params['nazwa_uslugi']."_acl_out term T2 then accept"."\n";
    
    $conf.="set firewall family inet filter ".$s_params['nazwa_uslugi']."_acl_out term T3 from source-address 172.16.65.0/24"."\n";
    $conf.="set firewall family inet filter ".$s_params['nazwa_uslugi']."_acl_out term T3 from source-address 172.16.67.0/24"."\n";
    $conf.="set firewall family inet filter ".$s_params['nazwa_uslugi']."_acl_out term T3 from destination-address ".$ip_p2p_2."/32"."\n";
    $conf.="set firewall family inet filter ".$s_params['nazwa_uslugi']."_acl_out term T3 then accept"."\n";
    $conf.="set firewall family inet filter ".$s_params['nazwa_uslugi']."_acl_out term T4 then discard"."\n";
    $conf.="\n";
    $conf.="set routing-instances SBC-SIP-T interface ".$s_params['interface_a'].'.'.$s_params['s_unit']."\n";

    return $conf;
}

function gen_config_juniper_sip_t_b($s_params,$migracja,$mtu_cisco,$mtu_juniper)
{
    $ip_p2p=str_replace($zamiana_p,'',$s_params['ip_p2p']);
    $ip_p2p_mask=trim(get_ip_p2p_mask($s_params['ip_p2p']));
    $ip_p2p_1=str_replace($zamiana_p,'',trim(get_ip_p2p_1($s_params['ip_p2p'])));
    $ip_p2p_2=str_replace($zamiana_p,'',trim(get_ip_p2p_2($s_params['ip_p2p'])));
    $download=trim(get_download($s_params['pasmo']));
    $burst_d=(int)($download/10);
    $upload=  trim(get_upload($s_params['pasmo']));
    $burst_u=(int)($upload/10);
    
    $d_vlan=$s_params['d_vlan'];
    if($d_vlan==='') $d_vlan=$s_params['s_vlan'];

    $conf="";
    $conf.="#################################################################################\n\n";
    $conf.="#### Router B -- ".$s_params['ip_b']." --- ".$s_params['router_b']."\n";
    $conf.="#################################################################################\n";
    $conf.="#delete interfaces ".$s_params['interface_b']." unit ".$s_params['c_vlan']."\n";
    $conf.="#delete protocols ospf area 0.0.0.0 interface ".$s_params['interface_b'].'.'.$s_params['c_vlan']." passive"."\n";
    $conf.="#################################################################################\n\n";    
    $conf.="\n\n";
    $conf.="#delete ".$s_params['logical_system_b']." interfaces ".$s_params['interface_b']." unit ".$s_params['d_unit']." vlan-id-list ". $s_params['c_vlan']."\n";
    
    $conf.="set ".$s_params['logical_system_b']." interfaces ".$s_params['interface_b']." unit ".$s_params['d_unit']." vlan-id-list ".$s_params['c_vlan']."\n";
    $conf.="#set ".$s_params['logical_system_b']." interfaces ".$s_params['interface_b']." unit ".$s_params['d_unit']." description Biznes_L2VPN_Wawa_B2B_do_Pereca"."\n";
    $conf.="#set ".$s_params['logical_system_b']." interfaces ".$s_params['interface_b']." unit ".$s_params['d_unit']." encapsulation vlan-ccc"."\n";    
    $conf.="#set ".$s_params['logical_system_b']." interfaces ".$s_params['interface_b']." unit ".$s_params['d_unit']." input-vlan-map push"."\n";
    $conf.="#set ".$s_params['logical_system_b']." interfaces ".$s_params['interface_b']." unit ".$s_params['d_unit']." vlan-id-list ".$s_params['s_vlan']."\n";
    $conf.="#set ".$s_params['logical_system_b']." interfaces ".$s_params['interface_b']." unit ".$s_params['d_unit']." output-vlan-map pop"."\n";
    $conf.="#set ".$s_params['logical_system_b']." interfaces ".$s_params['interface_b']." unit ".$s_params['d_unit']." input-vlan-map vlan-id ".$s_params['s_vlan']."\n";
    $conf.="\n\n";
    
    //$conf.="set protocols l2circuit neighbor 89.228.0.50 interface ".$s_params['interface_b'].'.'.$s_params['s_vlan']." virtual-circuit-id ".$s_params['s_vlan']."\n";
    //$conf.="set protocols l2circuit neighbor 89.228.0.50 interface ".$s_params['interface_b'].'.'.$s_params['s_vlan']." mtu 9200"."\n";
    //if($s_params['router_b_typ']==='JUNIPER')
    //{
    //    $conf.="set protocols l2circuit neighbor 89.228.0.50 interface ".$s_params['interface_b'].'.'.$s_params['s_vlan']." encapsulation-type ethernet"."\n";  
    //} else $conf.="set protocols l2circuit neighbor 89.228.0.50 interface ".$s_params['interface_b'].'.'.$s_params['s_vlan']." encapsulation-type ethernet-vlan"."\n";
        
    return $conf;
}
//==================================================================================================================================================================================================

function gen_config_juniper_internet_lokalny($s_params,$migracja,$mtu_cisco,$mtu_juniper)
{
    $ip_p2p=str_replace($zamiana_p,'',$s_params['ip_p2p']);
    $ip_p2p_mask=trim(get_ip_p2p_mask($s_params['ip_p2p']));
    $ip_p2p_1=str_replace($zamiana_p,'',trim(get_ip_p2p_1($s_params['ip_p2p'])));
    $ip_p2p_2=str_replace($zamiana_p,'',trim(get_ip_p2p_2($s_params['ip_p2p'])));
    $ip_pa=   get_ip_pa($s_params['ip_pa']);
    $download=trim(get_download($s_params['pasmo']));
    $burst_d=(int)($download/10);
    $upload=  trim(get_upload($s_params['pasmo']));
    $burst_u=(int)($upload/10);
    
    $conf='';
    $conf.="#####################################################################"."\n";
    $conf.="##### B2B -- ".$s_params['miasto_a']."  ---  ".$s_params['ip_a']." --- ".$s_params['router_a']."\n\n";
    $conf.="##### B2B - Interface"."\n\n";
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." description ".$s_params['description_a']."\n";
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." vlan-id ".$s_params['c_vlan']."\n";
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." family inet filter input ".$s_params['nazwa_uslugi']."_acl_in"."\n";
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." family inet filter output ".$s_params['nazwa_uslugi']."_acl_out"."\n";
    //$conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." family inet policer input ".$s_params['nazwa_uslugi']."-IN"."\n";
    //$conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." family inet policer output ".$s_params['nazwa_uslugi']."-OUT"."\n";
    $conf.="set ".$s_params['logical_system_b']." interfaces ".$s_params['interface_b']." unit ".$s_params['d_unit']." family ccc policer input "."Biznes_L2_download_".$download."\n";
    $conf.="set ".$s_params['logical_system_b']." interfaces ".$s_params['interface_b']." unit ".$s_params['d_unit']." family ccc policer output "."Biznes_L2_upload_".$upload."\n";
    $conf.="\n\n";
    
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." family inet address ".$ip_p2p_1."/".$ip_p2p_mask."\n";

    $conf.="\n";
    $conf.="##### B2B - filtr IN"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_in term T1 from destination-address ".$ip_p2p_1."/32"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_in term T1 from protocol icmp"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_in term T1 then accept"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_in term T2 from destination-address ".$ip_p2p_1."/32"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_in term T2 from protocol tcp"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_in term T2 then discard"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_in term T3 from destination-address 192.168.0.0/16"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_in term T3 from destination-address 172.16.0.0/12"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_in term T3 from destination-address 10.0.0.0/8"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_in term T3 then discard"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_in term T4 from source-address ".$s_params['ip_p2p']."\n";
    if(count($ip_pa) >0)
    {
        $conf.="\n";
        if($ip_pa[0] !== '')
        {
            $conf.="##### B2B - adresacja PA"."\n";
            for($i=0;$i<count($ip_pa);$i++)
            {        
                if(trim(str_replace(' ','',$ip_pa[$i])) !== '') $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_in term T4 from source-address ".trim(str_replace(' ','',$ip_pa[$i]))."\n";
            }
        }
    }
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_in term T4 then dscp 0"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_in term T4 then accept"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_in term T5 then discard"."\n";
    
    $conf.="\n";
    $conf.="##### B2B - filtr OUT"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_out term T1 from destination-address ".$s_params['ip_p2p']."\n";
    if(count($ip_pa) >0)
    {
        if($ip_pa[0] !== '')
        {
            for($i=0;$i<count($ip_pa);$i++)
            {        
                if(trim(str_replace(' ','',$ip_pa[$i])) !== '') $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_out term T1 from destination-address ".trim(str_replace(' ','',$ip_pa[$i]))."\n";
            }
        }
    }
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_out term T1 then accept"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_out term T2 then discard"."\n";
    $conf.="\n\n";    
    
    $conf.="set ".$s_params['logical_system_b']." firewall policer "."Biznes_L2_download_".$download." if-exceeding bandwidth-limit ".$download."m"."\n";
    if($burst_d !== 0) $conf.="set ".$s_params['logical_system_b']." firewall policer "."Biznes_L2_download_".$download." if-exceeding burst-size-limit ".$burst_d."m"."\n";
    else $conf.="set ".$s_params['logical_system_b']." firewall policer "."Biznes_L2_download_".$download." if-exceeding burst-size-limit ".'1'."m"."\n";
    $conf.="set ".$s_params['logical_system_b']." firewall policer "."Biznes_L2_download_".$download." then discard"."\n";
    $conf.="set ".$s_params['logical_system_b']." firewall policer "."Biznes_L2_upload_".$upload." if-exceeding bandwidth-limit ".$upload."m"."\n";
    if($burst_u !== 0) $conf.="set ".$s_params['logical_system_b']." firewall policer "."Biznes_L2_upload_".$upload." if-exceeding burst-size-limit ".$burst_u."m"."\n";
    else $conf.="set ".$s_params['logical_system_b']." firewall policer "."Biznes_L2_upload_".$upload." if-exceeding burst-size-limit ".'1'."m"."\n";
    $conf.="set ".$s_params['logical_system_b']." firewall policer "."Biznes_L2_upload_".$upload." then discard"."\n";
        
    //STATIC ROUTE dla PA
    $conf.="\n";
    if(count($ip_pa) >0)
    {
        if($ip_pa[0] !== '')
        {
            for($i=0;$i<count($ip_pa);$i++)
            {
                if($s_params['router_a']==='89.228.0.140')
                {
                    if(trim(str_replace(' ','',$ip_pa[$i])) !== '')
                    {
                        $conf.="set ".$s_params['logical_system_a']." routing-options static route ".trim(str_replace(' ','',$ip_pa[$i]))." next-hop ".$ip_p2p_2."\n";
                        $conf.='#'."set ".$s_params['logical_system_a']." routing-options static route ".trim(str_replace(' ','',$ip_pa[$i]))." qualified-next-hop ".$ip_p2p_2.' preference 25 '."\n";
                    }
                } else
                    if(trim(str_replace(' ','',$ip_pa[$i])) !== '')
                    {
                        $conf.="set ".$s_params['logical_system_a']." routing-options static route ".trim(str_replace(' ','',$ip_pa[$i]))." next-hop ".$ip_p2p_2."\n";
                        $conf.='#'."set ".$s_params['logical_system_a']." routing-options static route ".trim(str_replace(' ','',$ip_pa[$i]))." qualified-next-hop ".$ip_p2p_2.' preference 25 '."\n";
                    }
            }
        }
    }

    $conf.="\n";
    //OSPF
    if(count($ip_pa) >0)
    {
        for($i=0;$i<count($ip_pa);$i++)
        {        
            //$conf.="\n";
            if($s_params['router_a']==='89.228.0.140')
            {
                $ip_pa[$i]=str_replace(';','',$ip_pa[$i]);
                if($ip_pa[$i] !== '')
                {
                    $conf.="set ".$s_params['logical_system_a']." policy-options policy-statement BGP_STATIC term static from route-filter ".trim(str_replace(' ','',$ip_pa[$i]))." orlonger"."\n";
                }
            } else
                if(trim(str_replace(' ','',$ip_pa[$i])) !== '')
                {
                    $conf.="set ".$s_params['logical_system_a']." policy-options policy-statement CONNECT_OSPF from route-filter ".trim(str_replace(' ','',$ip_pa[$i]))." exact"."\n"; //dla routera na Pereca 192.168.168.1
                    //$conf.="set ".$s_params['logical_system_a']." policy-options policy-statement STATIC_OSPF term T1 from route-filter ".trim(str_replace(' ','',$ip_pa[$i]))." orlonger"."\n";  //dla routera na Pereca 192.168.168.1
                }
        }
    }
    
    $conf.="\n";    
    #Dla routera PERECA 192.168.168.1
    $conf.="set ".$s_params['logical_system_a']." policy-options policy-statement CONNECT_OSPF from route-filter ".$s_params['ip_p2p']." exact"."\n";
    
    $conf.="#set ".$s_params['logical_system_a']." policy-options policy-statement STATIC_OSPF term T1 from route-filter ".$s_params['ip_p2p']." orlonger"."\n";  //dla routera na Pereca 192.168.168.1
        
    return $conf;
}

function gen_config_juniper_B2B_bgp_ddos($s_params,$migracja,$mtu_cisco,$mtu_juniper)
{
    $ip_p2p=str_replace($zamiana_p,'',$s_params['ip_p2p']);
    $ip_p2p_mask=trim(get_ip_p2p_mask($s_params['ip_p2p']));
    $ip_p2p_1=str_replace($zamiana_p,'',trim(get_ip_p2p_1($s_params['ip_p2p'])));
    $ip_p2p_2=str_replace($zamiana_p,'',trim(get_ip_p2p_2($s_params['ip_p2p'])));
    //$ip_pa=   get_ip_pa($s_params['ip_pa']);  //w przypadku BGP adresy PA nie powinny istniec
    $ip_pi=   get_ip_pi($s_params['ip_pi']);
    
    $download=trim(get_download($s_params['pasmo']));
    $burst_d=(int)($download/10);
    $upload=  trim(get_upload($s_params['pasmo']));
    $burst_u=(int)($upload/10);
    
    //Normalna konfiguracja dla polaczeniowki
    $conf='';
    $conf.="#####################################################################"."\n";
    $conf.="##### B2B -- ".$s_params['miasto_a']."  ---  ".$s_params['ip_a']." --- ".$s_params['router_a']."\n\n";
    $conf.="##### B2B - Interface"."\n\n";
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." description ".$s_params['description_a']."\n";
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." vlan-tags outer ".$s_params['s_vlan']." inner ".$s_params['c_vlan']."\n";
    $conf.="###set interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." vlan-id ".$s_params['c_vlan']."\n";
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." family inet filter input ".$s_params['nazwa_uslugi']."_acl_in"."\n";
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." family inet filter output ".$s_params['nazwa_uslugi']."_acl_out"."\n";
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." family inet policer input ".$s_params['nazwa_uslugi']."-IN"."\n";
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." family inet policer output ".$s_params['nazwa_uslugi']."-OUT"."\n";
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." family inet address ".$ip_p2p_1."/".$ip_p2p_mask."\n";
    
    $conf.="\n";
    $conf.="##### B2B - filtr IN"."\n\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_in term T1 from source-address ".$ip_p2p_2."/32"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_in term T1 from destination-address ".$ip_p2p_1."/32"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_in term T1 from protocol icmp"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_in term T1 then accept"."\n";

    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_in term T2 from source-address ".$ip_p2p_2."/32"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_in term T2 from destination-address ".$ip_p2p_1."/32"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_in term T2 from protocol tcp"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_in term T2 from port bgp"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_in term T2 then accept"."\n";
    
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_in term T3 from destination-address 192.168.0.0/16"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_in term T3 from destination-address 172.16.0.0/12"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_in term T3 from destination-address 10.0.0.0/8"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_in term T3 from destination-address ".$ip_p2p_1."/32"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_in term T3 then discard"."\n";
    
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_in term T4 from source-address ".$s_params['ip_p2p']."\n";
    //###########################################################################################################################################################################################
    
    if(count($ip_pi) >0)
    {
        //$conf.="\n";
        if($ip_pi[0] !== '')
            $conf.="##### B2B - adresacja PI"."\n";
        for($i=0;$i<count($ip_pi);$i++)
        {        
            if(trim(str_replace(' ','',$ip_pi[$i])) !== '') $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_in term T4 from source-address ".trim(str_replace(' ','',$ip_pi[$i]))."\n";
        }
    }
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_in term T4 then dscp 0"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_in term T4 then accept"."\n";
    
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_in term T5 then discard"."\n";
    
    $conf.="\n";
    $conf.="##### B2B - filtr OUT"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_out term T1 from destination-address ".$s_params['ip_p2p']."\n";
    if(count($ip_pi) >0)
    {
        for($i=0;$i<count($ip_pi);$i++)
        {        
            if(trim(str_replace(' ','',$ip_pi[$i])) !== '')
                $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_out term T1 from destination-address ".trim(str_replace(' ','',$ip_pi[$i]))."\n";
        }
    }
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_out term T1 then accept"."\n";
    
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_out term T2 then discard"."\n";
    $conf.="\n\n";    

    $conf.="##### B2B - policer"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-IN if-exceeding bandwidth-limit ".$download."m"."\n";
    if($burst_d !== 0) $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-IN if-exceeding burst-size-limit ".$burst_d."m"."\n";
    else $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-IN if-exceeding burst-size-limit ".'1'."m"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-IN then discard"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-OUT if-exceeding bandwidth-limit ".$upload."m"."\n";
    if($burst_u !== 0) $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-OUT if-exceeding burst-size-limit ".$burst_u."m"."\n";
    else $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-OUT if-exceeding burst-size-limit ".'1'."m"."\n";    
    $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-OUT then discard"."\n";
    
    //BGP config
    $conf.="\n";
    
    //filtry IN BGP
    $conf.="set ".$s_params['logical_system_a']." policy-options policy-statement ".$s_params['nazwa_uslugi']."-IN term 1 from as-path "."as_path_".$s_params['nazwa_uslugi']."\n";
    $conf.="set ".$s_params['logical_system_a']." policy-options policy-statement ".$s_params['nazwa_uslugi']."-IN term 1 from prefix-list "."prefix_list_".$s_params['nazwa_uslugi']."\n";
    $conf.="set ".$s_params['logical_system_a']." policy-options policy-statement ".$s_params['nazwa_uslugi']."-IN term 1 then local-preference 300 "."\n";    
    $conf.="set ".$s_params['logical_system_a']." policy-options policy-statement ".$s_params['nazwa_uslugi']."-IN term 2 then reject "."\n";

    //FlowSpec
    $conf.="set ".$s_params['logical_system_a']." policy-options policy-statement ".$s_params['nazwa_uslugi']."-IN term flowspec_import from ".'rib inetflow.0'."\n";
    if(count($ip_pa) >0)
    {
        for($i=0;$i<count($ip_pa);$i++)
        {
            if(trim(str_replace(' ','',$ip_pa[$i])) !== '') $conf.="set ".$s_params['logical_system_a']." policy-options policy-statement ".$s_params['nazwa_uslugi']."-IN term flowspec_import from "." route-filter ".trim(str_replace(' ','',$ip_pa[$i])).' prefix-length-range /32-/32'."\n";
        }
    }

    if(count($ip_pi) >0)
    {
        for($i=0;$i<count($ip_pi);$i++)
        {        
            $conf.="\n";
            if(trim(str_replace(' ','',$ip_pi[$i])) !== '')
            {
                $conf.="set ".$s_params['logical_system_a']." policy-options policy-statement ".$s_params['nazwa_uslugi']."-IN term flowspec_import from "." route-filter ".trim(str_replace(' ','',$ip_pi[$i])).' prefix-length-range /32-/32'."\n";
            }
        }
    }
    $conf.="set ".$s_params['logical_system_a']." policy-options policy-statement ".$s_params['nazwa_uslugi']."-IN term flowspec_import  then accept"."\n";    
    $conf.="set ".$s_params['logical_system_a']." policy-options policy-statement ".$s_params['nazwa_uslugi']."-IN term Blackhole then community add no-export"."\n";
    $conf.="set ".$s_params['logical_system_a']." policy-options policy-statement ".$s_params['nazwa_uslugi']."-IN term Blackhole then next-hop ".'172.17.17.1'."\n";
    $conf.="set ".$s_params['logical_system_a']." policy-options policy-statement ".$s_params['nazwa_uslugi']."-IN term Blackhole then accept"."\n";
    $conf.="set ".$s_params['logical_system_a']." policy-options policy-statement ".$s_params['nazwa_uslugi']."-IN term default then reject"."\n";
    
    //filtr OUT BGP
    $conf.="set ".$s_params['logical_system_a']." policy-options policy-statement ".$s_params['nazwa_uslugi']."-OUT term 1 from route-filter "."0.0.0.0/0"."\n";  //default route
    $conf.="set ".$s_params['logical_system_a']." policy-options policy-statement ".$s_params['nazwa_uslugi']."-OUT term 1 then accept "."\n";    
    $conf.="set ".$s_params['logical_system_a']." policy-options policy-statement ".$s_params['nazwa_uslugi']."-OUT term default then reject "."\n";
    
    if(count($ip_pi) >0)
    {
        $conf.="\n";
        for($i=0;$i<count($ip_pi);$i++)
        {        
            if(trim(str_replace(' ','',$ip_pi[$i])) !== '')
            {
                $conf.="set ".$s_params['logical_system_a']." policy-options prefix-list policy-statement "."prefix_list_".$s_params['nazwa_uslugi']." ".trim(str_replace(' ','',$ip_pi[$i]))."\n";
            }
        }
    }
    
    $conf.="\n";
    $as_k=trim(str_replace(' ','',$s_params['as_klienta']));
    $as_k_reg='"'.'^'.$as_k.'( '.$as_k.')*$"';                   //"^8834( 8834)*$"
    $conf.="set ".$s_params['logical_system_a']." policy-options as-path "."as_path_".$s_params['nazwa_uslugi']." ".$as_k_reg."\n";
    //lub
    $as_k_reg=$as_k.'+';
    $conf.="#set ".$s_params['logical_system_a']." policy-options as-path "."as_path_".$s_params['nazwa_uslugi']." ".$as_k_reg."\n";
    //lub
    $as_k_reg='".*"';  //all
    $conf.="#set ".$s_params['logical_system_a']." policy-options as-path "."as_path_".$s_params['nazwa_uslugi']." ".$as_k_reg."\n";

    //run BGP
    $prefix_list_max=count($ip_pi)+1;
    $conf.="\n";
    $conf.="set ".$s_params['logical_system_a']." protocols bgp group "."BGP_".$s_params['nazwa_uslugi']." type external"."\n";
    $conf.="set ".$s_params['logical_system_a']." protocols bgp group "."BGP_".$s_params['nazwa_uslugi']." import ".$s_params['nazwa_uslugi']."-IN"."\n";
    $conf.="set ".$s_params['logical_system_a']." protocols bgp group "."BGP_".$s_params['nazwa_uslugi']." family inet unicast prefix-list maximum ".$prefix_list_max."\n";
    $conf.="set ".$s_params['logical_system_a']." protocols bgp group "."BGP_".$s_params['nazwa_uslugi']." export ".$s_params['nazwa_uslugi']."-OUT"."\n";
    $conf.="set ".$s_params['logical_system_a']." protocols bgp group "."BGP_".$s_params['nazwa_uslugi']." remove-private"."\n";
    $conf.="set ".$s_params['logical_system_a']." protocols bgp group "."BGP_".$s_params['nazwa_uslugi']." peer-as ".$as_k."\n";
    $conf.="set ".$s_params['logical_system_a']." protocols bgp group "."BGP_".$s_params['nazwa_uslugi']." neighbor ".$ip_p2p_2."\n";    

    return $conf;
}

function gen_config_juniper_B2B_lokalny_bgp_ddos($s_params,$migracja,$mtu_cisco,$mtu_juniper)
{
    $ip_p2p=str_replace($zamiana_p,'',$s_params['ip_p2p']);
    $ip_p2p_mask=trim(get_ip_p2p_mask($s_params['ip_p2p']));
    $ip_p2p_1=str_replace($zamiana_p,'',trim(get_ip_p2p_1($s_params['ip_p2p'])));
    $ip_p2p_2=str_replace($zamiana_p,'',trim(get_ip_p2p_2($s_params['ip_p2p'])));
    //$ip_pa=   get_ip_pa($s_params['ip_pa']);  //w przypadku BGP adresy PA nie powinny istniec
    $ip_pi=   get_ip_pi($s_params['ip_pi']);
    
    $download=trim(get_download($s_params['pasmo']));
    $burst_d=(int)($download/10);
    $upload=  trim(get_upload($s_params['pasmo']));
    $burst_u=(int)($upload/10);
    
    //Normalna konfiguracja dla polaczeniowki
    $conf='';
    $conf.="#####################################################################"."\n";
    $conf.="##### B2B -- ".$s_params['miasto_a']."  ---  ".$s_params['ip_a']." --- ".$s_params['router_a']."\n\n";
    $conf.="##### B2B - Interface"."\n\n";
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." description ".$s_params['description_a']."\n";
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." vlan-tags outer ".$s_params['s_vlan']." inner ".$s_params['c_vlan']."\n";
    $conf.="###set interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." vlan-id ".$s_params['c_vlan']."\n";
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." family inet filter input ".$s_params['nazwa_uslugi']."_acl_in"."\n";
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." family inet filter output ".$s_params['nazwa_uslugi']."_acl_out"."\n";
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." family inet policer input ".$s_params['nazwa_uslugi']."-IN"."\n";
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." family inet policer output ".$s_params['nazwa_uslugi']."-OUT"."\n";
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." family inet address ".$ip_p2p_1."/".$ip_p2p_mask."\n";
    
    $conf.="\n";
    $conf.="##### B2B - filtr IN"."\n\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_in term T1 from source-address ".$ip_p2p_2."/32"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_in term T1 from destination-address ".$ip_p2p_1."/32"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_in term T1 from protocol icmp"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_in term T1 then accept"."\n";

    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_in term T2 from source-address ".$ip_p2p_2."/32"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_in term T2 from destination-address ".$ip_p2p_1."/32"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_in term T2 from protocol tcp"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_in term T2 from port bgp"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_in term T2 then accept"."\n";
    
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_in term T3 from destination-address 192.168.0.0/16"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_in term T3 from destination-address 172.16.0.0/12"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_in term T3 from destination-address 10.0.0.0/8"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_in term T3 from destination-address ".$ip_p2p_1."/32"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_in term T3 then discard"."\n";
    
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_in term T4 from source-address ".$s_params['ip_p2p']."\n";
    //###########################################################################################################################################################################################
    
    if(count($ip_pi) >0)
    {
        //$conf.="\n";
        if($ip_pi[0] !== '')
            $conf.="##### B2B - adresacja PI"."\n";
        for($i=0;$i<count($ip_pi);$i++)
        {        
            if(trim(str_replace(' ','',$ip_pi[$i])) !== '') $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_in term T4 from source-address ".trim(str_replace(' ','',$ip_pi[$i]))."\n";
        }
    }
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_in term T4 then dscp 0"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_in term T4 then accept"."\n";
    
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_in term T5 then discard"."\n";
    
    $conf.="\n";
    $conf.="##### B2B - filtr OUT"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_out term T1 from destination-address ".$s_params['ip_p2p']."\n";
    if(count($ip_pi) >0)
    {
        for($i=0;$i<count($ip_pi);$i++)
        {        
            if(trim(str_replace(' ','',$ip_pi[$i])) !== '')
                $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_out term T1 from destination-address ".trim(str_replace(' ','',$ip_pi[$i]))."\n";
        }
    }
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_out term T1 then accept"."\n";
    
    $conf.="set ".$s_params['logical_system_a']." firewall filter ".$s_params['nazwa_uslugi']."_acl_out term T2 then discard"."\n";
    $conf.="\n\n";    

    $conf.="##### B2B - policer"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-IN if-exceeding bandwidth-limit ".$download."m"."\n";
    if($burst_d !== 0) $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-IN if-exceeding burst-size-limit ".$burst_d."m"."\n";
    else $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-IN if-exceeding burst-size-limit ".'1'."m"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-IN then discard"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-OUT if-exceeding bandwidth-limit ".$upload."m"."\n";
    if($burst_u !== 0) $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-OUT if-exceeding burst-size-limit ".$burst_u."m"."\n";
    else $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-OUT if-exceeding burst-size-limit ".'1'."m"."\n";    
    $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-OUT then discard"."\n";
    
    //BGP config
    $conf.="\n";
    //filtry IN BGP
    $conf.="set ".$s_params['logical_system_a']." policy-options policy-statement ".$s_params['nazwa_uslugi']."-IN term 1 from as-path "."as_path_".$s_params['nazwa_uslugi']."\n";
    $conf.="set ".$s_params['logical_system_a']." policy-options policy-statement ".$s_params['nazwa_uslugi']."-IN term 1 from prefix-list "."prefix_list_".$s_params['nazwa_uslugi']."\n";
    $conf.="set ".$s_params['logical_system_a']." policy-options policy-statement ".$s_params['nazwa_uslugi']."-IN term 1 then local-preference 300 "."\n";    
    $conf.="set ".$s_params['logical_system_a']." policy-options policy-statement ".$s_params['nazwa_uslugi']."-IN term 2 then reject "."\n";

    //FlowSpec
    $conf.="set ".$s_params['logical_system_a']." policy-options policy-statement ".$s_params['nazwa_uslugi']."-IN term flowspec_import from ".'rib inetflow.0'."\n";
    $conf.="set ".$s_params['logical_system_a']." policy-options policy-statement ".$s_params['nazwa_uslugi']."-IN term flowspec_import  then accept"."\n";

    if(count($ip_pa) >0)
    {
        for($i=0;$i<count($ip_pa);$i++)
        {
            if(trim(str_replace(' ','',$ip_pa[$i])) !== '') $conf.="set ".$s_params['logical_system_a']." policy-options policy-statement ".$s_params['nazwa_uslugi']."-IN term flowspec_import from "." route-filter ".trim(str_replace(' ','',$ip_pa[$i])).' prefix-length-range /32-/32'."\n";
        }
    }

    if(count($ip_pi) >0)
    {
        for($i=0;$i<count($ip_pi);$i++)
        {        
            $conf.="\n";
            if(trim(str_replace(' ','',$ip_pi[$i])) !== '')
            {
                $conf.="set ".$s_params['logical_system_a']." policy-options policy-statement ".$s_params['nazwa_uslugi']."-IN term flowspec_import from "." route-filter ".trim(str_replace(' ','',$ip_pi[$i])).' prefix-length-range /32-/32'."\n";
            }
        }
    }    
    $conf.="set ".$s_params['logical_system_a']." policy-options policy-statement ".$s_params['nazwa_uslugi']."-IN term "." Blackhole then community add no-export"."\n";
    $conf.="set ".$s_params['logical_system_a']." policy-options policy-statement ".$s_params['nazwa_uslugi']."-IN term "." Blackhole then next-hop ".'172.17.17.1'."\n";
    $conf.="set ".$s_params['logical_system_a']." policy-options policy-statement ".$s_params['nazwa_uslugi']."-IN term "." Blackhole then accept"."\n";
    $conf.="set ".$s_params['logical_system_a']." policy-options policy-statement ".$s_params['nazwa_uslugi']."-IN term "." Blackhole then reject"."\n";
    
    //filtr OUT BGP
    $conf.="set ".$s_params['logical_system_a']." policy-options policy-statement ".$s_params['nazwa_uslugi']."-OUT term 1 from route-filter "."0.0.0.0/0"."\n";  //default route
    $conf.="set ".$s_params['logical_system_a']." policy-options policy-statement ".$s_params['nazwa_uslugi']."-OUT term 1 then accept "."\n";
    
    $conf.="set ".$s_params['logical_system_a']." policy-options policy-statement ".$s_params['nazwa_uslugi']."-OUT term default then reject "."\n";
    
    if(count($ip_pi) >0)
    {
        $conf.="\n";
        for($i=0;$i<count($ip_pi);$i++)
        {        
            if(trim(str_replace(' ','',$ip_pi[$i])) !== '')
            {
                $conf.="set ".$s_params['logical_system_a']." policy-options prefix-list policy-statement "."prefix_list_".$s_params['nazwa_uslugi']." ".trim(str_replace(' ','',$ip_pi[$i]))."\n";
            }
        }
    }
    
    $conf.="\n";
    $as_k=trim(str_replace(' ','',$s_params['as_klienta']));
    $as_k_reg='"'.'^'.$as_k.'( '.$as_k.')*$"';                   //"^8834( 8834)*$"
    $conf.="set ".$s_params['logical_system_a']." policy-options as-path "."as_path_".$s_params['nazwa_uslugi']." ".$as_k_reg."\n";
    //lub
    $as_k_reg=$as_k.'+';
    $conf.="#set ".$s_params['logical_system_a']." policy-options as-path "."as_path_".$s_params['nazwa_uslugi']." ".$as_k_reg."\n";
    //lub
    $as_k_reg='".*"';  //all
    $conf.="#set ".$s_params['logical_system_a']." policy-options as-path "."as_path_".$s_params['nazwa_uslugi']." ".$as_k_reg."\n";

    //run BGP
    $prefix_list_max=count($ip_pi)+1;
    $conf.="\n";
    $conf.="set ".$s_params['logical_system_a']." protocols bgp group "."BGP_".$s_params['nazwa_uslugi']." type external"."\n";
    $conf.="set ".$s_params['logical_system_a']." protocols bgp group "."BGP_".$s_params['nazwa_uslugi']." import ".$s_params['nazwa_uslugi']."-IN"."\n";
    $conf.="#set ".$s_params['logical_system_a']." protocols bgp group "."BGP_".$s_params['nazwa_uslugi']." family inet unicast prefix-list maximum ".$prefix_list_max."\n";
    $conf.="set ".$s_params['logical_system_a']." protocols bgp group "."BGP_".$s_params['nazwa_uslugi']." family inet unicast prefix-list maximum ".$prefix_list_max."\n";
    $conf.="set ".$s_params['logical_system_a']." protocols bgp group "."BGP_".$s_params['nazwa_uslugi']." export ".$s_params['nazwa_uslugi']."-OUT"."\n";
    $conf.="set ".$s_params['logical_system_a']." protocols bgp group "."BGP_".$s_params['nazwa_uslugi']." remove-private"."\n";
    $conf.="set ".$s_params['logical_system_a']." protocols bgp group "."BGP_".$s_params['nazwa_uslugi']." peer-as ".$as_k."\n";
    $conf.="set ".$s_params['logical_system_a']." protocols bgp group "."BGP_".$s_params['nazwa_uslugi']." neighbor ".$ip_p2p_2."\n";    

    return $conf;
}
//======================================================================================================================================================================================================
function gen_config_via_vectra_a_bgp($s_params,$migracja,$mtu_cisco,$mtu_juniper)
{
    $ip_p2p=str_replace($zamiana_p,'',$s_params['ip_p2p']);
    $ip_p2p_mask=trim(get_ip_p2p_mask($s_params['ip_p2p']));
    $ip_p2p_1=str_replace($zamiana_p,'',trim(get_ip_p2p_1($s_params['ip_p2p'])));
    $ip_p2p_2=str_replace($zamiana_p,'',trim(get_ip_p2p_2($s_params['ip_p2p'])));
    //$ip_pa=   get_ip_pa($s_params['ip_pa']);  //w przypadku BGP adresy PA nie powinny istniec
    $ip_pi=   get_ip_pi($s_params['ip_pi']);
    
    $download=trim(get_download($s_params['pasmo']));
    $burst_d=(int)($download/10);
    $upload=  trim(get_upload($s_params['pasmo']));
    $burst_u=(int)($upload/10);
    
    $conf='';
    $conf.="!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n\n";
    $conf.="!!!! Router CISCO A VECTRA Warszawa Pereca ".$s_params['ip_a']." --- ".$s_params['router_a']."\n\n";
    
    $s_vlan=$s_params['s_vlan'];
    if($s_vlan==='') $s_vlan=$s_params['c_vlan']; //konieczne dla zwyklego tranzytu
    $conf.="interface ".$s_params['interface_b'].'.'.$s_vlan." l2transport"."\n";
    $conf.="    description Biznes-MMP-".$s_params['miasto_b']."-QinQ"."\n";
    $conf.="    encapsulation dot1q ".$s_vlan." second-dot1q ".$s_params['c_vlan']."\n";
    $conf.="    mtu 2004"."\n";
    $conf.="    rewrite ingress tag pop 1 symmetric"."\n";
    $conf.="    service-policy input marker_BE"."\n";
    //$conf.="    service-policy output ".$s_params['nazwa_uslugi']."_OUT"."\n";
    $conf.="exit"."\n";
    $conf.="\n\n";
    
    $conf.="l2vpn"."\n";
    $conf.="    xconnect group BE30_".$s_vlan."_651501246"."\n";
    $conf.="    p2p EoMPLS_ELINE_vlan".$s_vlan."\n";
    $conf.="    interface ".$s_params['interface_b'].'.'.$s_vlan."\n";
    $conf.="    neighbor ipv4 172.17.17.150 pw-id 65150".$s_vlan."\n";
    //$conf.="    neighbor ipv4 89.228.0.50 pw-id ".$s_vlan."\n";
    $conf.="        pw-class fat-pw"."\n";
    $conf.="        exit"."\n";
    $conf.="    exit"."\n";
    $conf.="exit"."\n";
    $conf.="exit"."\n";
    $conf.="\n\n";
    
    return $conf;
}


function gen_config_via_vectra_a_lokalny_bgp($s_params,$migracja,$mtu_cisco,$mtu_juniper)
{
    $ip_p2p=str_replace($zamiana_p,'',$s_params['ip_p2p']);
    $ip_p2p_mask=trim(get_ip_p2p_mask($s_params['ip_p2p']));
    $ip_p2p_1=str_replace($zamiana_p,'',trim(get_ip_p2p_1($s_params['ip_p2p'])));
    $ip_p2p_2=str_replace($zamiana_p,'',trim(get_ip_p2p_2($s_params['ip_p2p'])));
    //$ip_pa=   get_ip_pa($s_params['ip_pa']);  //w przypadku BGP adresy PA nie powinny istniec
    $ip_pi=   get_ip_pi($s_params['ip_pi']);
    
    $download=trim(get_download($s_params['pasmo']));
    $burst_d=(int)($download/10);
    $upload=  trim(get_upload($s_params['pasmo']));
    $burst_u=(int)($upload/10);
    
    $conf='';
    $conf.="!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n\n";
    $conf.="!!!! Router CISCO A VECTRA Warszawa Pereca ".$s_params['ip_a']." --- ".$s_params['router_a']."\n\n";
    
    $s_vlan=$s_params['s_vlan'];
    if($s_vlan==='') $s_vlan=$s_params['c_vlan']; //konieczne dla zwyklego tranzytu
    $conf.="interface ".$s_params['interface_b'].'.'.$s_vlan." l2transport"."\n";
    $conf.="    description Biznes-MMP-".$s_params['miasto_b']."-QinQ"."\n";
    $conf.="    encapsulation dot1q ".$s_vlan." second-dot1q ".$s_params['c_vlan']."\n";
    $conf.="    mtu 2004"."\n";
    $conf.="    rewrite ingress tag pop 1 symmetric"."\n";
    $conf.="    service-policy input marker_BE"."\n";
    //$conf.="    service-policy output ".$s_params['nazwa_uslugi']."_OUT"."\n";
    $conf.="exit"."\n";
    $conf.="\n\n";
    
    $conf.="l2vpn"."\n";
    $conf.="    xconnect group BE30_".$s_vlan."_651501246"."\n";
    $conf.="    p2p EoMPLS_ELINE_vlan".$s_vlan."\n";
    $conf.="    interface ".$s_params['interface_b'].'.'.$s_vlan."\n";
    $conf.="    neighbor ipv4 172.17.17.150 pw-id 65150".$s_vlan."\n";
    //$conf.="    neighbor ipv4 89.228.0.50 pw-id ".$s_vlan."\n";
    $conf.="        pw-class fat-pw"."\n";
    $conf.="        exit"."\n";
    $conf.="    exit"."\n";
    $conf.="exit"."\n";
    $conf.="exit"."\n";
    $conf.="\n\n";
    
    return $conf;
}


function gen_config_via_vectra_a($s_params,$migracja,$mtu_cisco,$mtu_juniper)
{
    $download=trim(get_download($s_params['pasmo']));
    $upload=  trim(get_upload($s_params['pasmo']));    
    
    $conf='';
    $conf.="!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n\n";
    $conf.="!!!! Router CISCO A VECTRA TRANZYT Warszawa Pereca ".$s_params['ip_a']." --- ".$s_params['router_a']."\n\n";
    
    $s_vlan=$s_params['s_vlan'];
    if($s_vlan==='') $s_vlan=$s_params['c_vlan']; //konieczne dla zwyklego tranzytu
    $conf.="interface ".$s_params['interface_b'].'.'.$s_vlan." l2transport"."\n";
    $conf.="    description Biznes-MMP-".$s_params['miasto_b']."-QinQ"."\n";
    $conf.="    encapsulation dot1q ".$s_vlan." second-dot1q ".$s_params['c_vlan']."\n";
    $conf.="    mtu 2004"."\n";
    $conf.="    rewrite ingress tag pop 1 symmetric"."\n";
    $conf.="    service-policy input marker_BE"."\n";
    //$conf.="    service-policy output ".$s_params['nazwa_uslugi']."_OUT"."\n";
    $conf.="exit"."\n";
    $conf.="\n\n";
    
    $conf.="l2vpn"."\n";
    $conf.="    xconnect group BE30_".$s_vlan."_651501246"."\n";
    $conf.="    p2p EoMPLS_ELINE_vlan".$s_vlan."\n";
    $conf.="    interface ".$s_params['interface_b'].'.'.$s_vlan."\n";
    $conf.="    neighbor ipv4 172.17.17.150 pw-id 65150".$s_vlan."\n";
    //$conf.="    neighbor ipv4 89.228.0.50 pw-id ".$s_vlan."\n";
    $conf.="        pw-class fat-pw"."\n";
    $conf.="        exit"."\n";
    $conf.="    exit"."\n";
    $conf.="exit"."\n";
    $conf.="exit"."\n";
    $conf.="\n\n";
    
    return $conf;
}

function gen_config_via_vectra_b($s_params,$migracja,$mtu_cisco,$mtu_juniper)
{
    $download=trim(get_download($s_params['pasmo']));
    $upload=  trim(get_upload($s_params['pasmo']));    
    
    $conf='';
    $conf.="!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n\n";
    $conf.="!!!! Router CISCO B VECTRA -- ".$s_params['ip_b']." --- ".$s_params['router_b']."\n\n";
    
    $s_vlan=$s_params['s_vlan'];
    if($s_vlan==='') $s_vlan=$s_params['c_vlan']; //konieczne dla zwyklego tranzytu
    $conf.="interface ".$s_params['interface_b'].'.'.$s_vlan." l2transport"."\n";
    $conf.="    description Biznes-MMP-".$s_params['miasto_b']."-QinQ"."\n";
    $conf.="    encapsulation dot1q ".$s_vlan." second-dot1q ".$s_params['c_vlan']."\n";
    $conf.="    mtu 2004"."\n";
    $conf.="    rewrite ingress tag pop 1 symmetric"."\n";
    $conf.="    service-policy input marker_BE"."\n";
    //$conf.="    service-policy output ".$s_params['nazwa_uslugi']."_OUT"."\n";
    $conf.="exit"."\n";
    $conf.="\n\n";
    
    $conf.="l2vpn"."\n";
    $conf.="    xconnect group BE30_".$s_vlan."_651501246"."\n";
    $conf.="    p2p EoMPLS_ELINE_vlan".$s_vlan."\n";
    $conf.="    interface ".$s_params['interface_b'].'.'.$s_vlan."\n";
    $conf.="    neighbor ipv4 172.17.17.150 pw-id 65150".$s_vlan."\n";
    //$conf.="    neighbor ipv4 89.228.0.50 pw-id ".$s_vlan."\n";
    $conf.="        pw-class fat-pw"."\n";
    $conf.="        exit"."\n";
    $conf.="    exit"."\n";
    $conf.="exit"."\n";
    $conf.="exit"."\n";
    $conf.="\n\n";
    
    return $conf;
}
//===============================================================================================================================================================================================
function gen_config_cisco_internet_lokalny($s_params,$migracja,$mtu_cisco,$mtu_juniper)
{
    $ip_p2p=str_replace($zamiana_p,'',$s_params['ip_p2p']);
    $ip_p2p_mask=trim(get_ip_p2p_mask($s_params['ip_p2p']));
    $ip_p2p_1=str_replace($zamiana_p,'',trim(get_ip_p2p_1($s_params['ip_p2p'])));
    $ip_p2p_2=str_replace($zamiana_p,'',trim(get_ip_p2p_2($s_params['ip_p2p'])));
    $ip_pa=   get_ip_pa($s_params['ip_pa']);
    $download=trim(get_download($s_params['pasmo']));
    $burst_d=(int)($download/10);
    $upload=  trim(get_upload($s_params['pasmo']));
    $burst_u=(int)($upload/10);
        
    $conf='';
    $conf.="!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n\n";
    $conf.="!!!! Router CISCO B -- ".$s_params['ip_a']." --- ".$s_params['router_a']."\n\n";
        
    $conf.="interface ".$s_params['interface_a'].'.'.$s_params['s_unit']."\n";
    $conf.="    description ".$s_params['description_a']."\n";
    $conf.="    encapsulation dot1q ".$s_params['c_vlan']."\n";
    //$conf.="    mtu ".$mtu_cisco."\n";
    $conf.="    ipv4 address ".$ip_p2p_1." 255.255.255.252"."\n";
    $conf.="    service-policy input ". $s_params['nazwa_uslugi']."_IN"."\n";
    $conf.="    service-policy output ".$s_params['nazwa_uslugi']."_OUT"."\n";
    $conf.="    ipv4 access-group ". $s_params['nazwa_uslugi']."_IN ingress"."\n";
    $conf.="    ipv4 access-group  ".$s_params['nazwa_uslugi']."_OUT egress"."\n";
    $conf.="exit"."\n";
    $conf.="\n\n";
    
    $conf.="policy-map ".$s_params['nazwa_uslugi']."_IN"."\n";
    $conf.="    class class-default"."\n";
    $conf.="    police rate ".$download." mbps"."\n";
    $conf.="end-policy-map"."\n";
    $conf.="\n\n";
    
    $conf.="policy-map ".$s_params['nazwa_uslugi']."_OUT"."\n";
    $conf.="    class class-default"."\n";
    $conf.="    police rate ".$upload." mbps"."\n";
    $conf.="end-policy-map"."\n";
    $conf.="\n\n";
    
    $conf.="!!!!! B2B - access list IN"."\n";
    $conf.="ipv4 access-list ".$s_params['nazwa_uslugi']."_IN"."\n";
    $conf.="    permit icmp any host ".$ip_p2p_1."\n";
    $conf.="    deny tcp any host ".$ip_p2p_1."\n";
    //$conf.="    deny udp any host ".$ip_p2p_1." eq snmp"."\n";
    $conf.="    deny ipv4 any 10.0.0.0 0.255.255.255"."\n";
    $conf.="    deny ipv4 any 192.168.0.0 0.0.255.255"."\n";
    $conf.="    deny ipv4 any 172.16.0.0 0.15.255.255"."\n";
    $conf.="    permit ipv4 ".$ip_p2p." 0.0.0.3 any"."\n";
    $conf.="exit"."\n";
        
    if(count($ip_pa) >0)
    {
        if($ip_pa[0] !== '')
        {
            $conf.="!!!! B2B - adresacja PA"."\n";
            for($i=0;$i<count($ip_pa);$i++)
            {        
                if(trim(str_replace(' ','',$ip_pa[$i])) !== '') $conf.="permit ipv4 ".trim(str_replace(' ','',$ip_pa[$i]))." 0.0.0.7"." any"."\n";
            }
        }
    }
    $conf.="    deny ipv4 any any"."\n";
    $conf.="\n\n";

    $conf.="!!!!! B2B - access list OUT"."\n";
    $conf.="ipv4 access-list ".$s_params['nazwa_uslugi']."_OUT"."\n";
    $conf.="    permit ipv4 any ".$ip_p2p.' 0.0.0.3'."\n";    
    if(count($ip_pa) >0)
    {
        for($i=0;$i<count($ip_pa);$i++)
        {        
            if(trim(str_replace(' ','',$ip_pa[$i])) !== '') $conf.="  permit ipv4 ".$ip_pa.' 0.0.0.7'." any"."\n";  //do przeliczenia maska odwrotna dla ip pa
        }
    }
    $conf.="    deny ipv4 any any"."\n";
    $conf.="\n\n";

    if(count($ip_pa) >0)
    {
        if($ip_pa[0] !== '')
        {
            $conf.="!!!! B2B - adresacja PA"."\n";
            for($i=0;$i<count($ip_pa);$i++)
            {        
                if(trim(str_replace(' ','',$ip_pa[$i])) !== '')
                {
                    $conf.="router static"."\n";
                    $conf.="address-family ipv4 unicast"."\n";
                    $conf.=trim(str_replace(' ','',$ip_pa[$i])).' '.$ip_p2p_2." description ".$s_params['nazwa_uslugi']."\n";
                }
            }
        }
    }

    //czasem ospf
    $conf.="!!! Czasem rozgloszenie przez OSPF - nalezy sprawdzic na konkretnym routerze"."\n";
    $conf.="router ospf 10"."\n";
    $conf.="  area 0"."\n";
    $conf.="   interface ".$s_params['interface_a'].".".$s_params['s_unit']."\n";
    $conf.="exit"."\n";
    $conf.="exit"."\n";

    $conf.="\n\n";
    
    return $conf;
}

function gen_config_cisco($s_params,$migracja,$mtu_cisco,$mtu_juniper)
{
    $c_vlans_zakres=find_c_vlans($s_params,$s_params['router_b_typ']); //szuka konfiguracji vlanow interfejsu cisco B
    $c_vlan_s=$c_vlans_zakres;  //encapsulation dot1q 302-399 , 2403-2417
    $c_vlan_s=str_replace('encapsulation dot1q','',$c_vlan_s);
    $c_vlan_s=str_replace("\r",'',$c_vlan_s);
    $c_vlan_s=str_replace("\n",'',$c_vlan_s);
    write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Conf 0: '.  $c_vlans_zakres);
    
    $conf='';
    $conf.="!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n\n";
    $conf.="!!!! Router CISCO B -- ".$s_params['ip_b']." --- ".$s_params['router_b'].'  '.$s_params['router_b_typ']."\n\n";    
    $conf.="!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n\n";
    $s_vlan=$s_params['s_vlan'];
    if($s_params['s_vlan']==='') $s_vlan=$s_params['c_vlan']; //konieczne dla zwyklego tranzytu

    $conf.="!!! no interface ".$s_params['interface_b'].'.'.$s_vlan."\n";  //delete old interface and create new l2
    $conf.="interface ".$s_params['interface_b'].'.'.$s_vlan." l2transport"."\n";
    //$conf.="    encapsulation dot1q ".$c_vlan_s.', '.$s_params['c_vlan']."\n";  //pełna linia z encapsulacją jest zwracana przez funkcję "find_c_vlan". Możliwe, że w linii jest nie tylko 'encapsulation dot1q ...'
    $conf.="!!!! vlany musza byc w porzadku rosnacym. Grupowanie vlanow (vlan - vlan) nalezy zrobic recznie. !!!!!!!"."\n";
    $conf.=" encapsulation dot1q ".$c_vlan_s.', '.$s_params['c_vlan']."\n";
    $conf.="exit"."\n\n\n";
    write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Conf 1: '.  $c_vlan_s);
    write_log(__FILE__.' '.__FUNCTION__.' '.__LINE__.' Conf 2: '.  $conf);
    $conf.="!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!";    
    
    return $conf;
}

/*
function gen_config_cisco($s_params,$migracja,$mtu_cisco,$mtu_juniper)
{
    $ip_p2p=str_replace($zamiana_p,'',$s_params['ip_p2p']);
    $ip_p2p_mask=trim(get_ip_p2p_mask($s_params['ip_p2p']));
    $ip_p2p_1=str_replace($zamiana_p,'',trim(get_ip_p2p_1($s_params['ip_p2p'])));
    $ip_p2p_2=str_replace($zamiana_p,'',trim(get_ip_p2p_2($s_params['ip_p2p'])));
    $ip_pa=   get_ip_pa($s_params['ip_pa']);
    $download=trim(get_download($s_params['pasmo']));
    $upload=  trim(get_upload($s_params['pasmo']));
            
    $conf='';
    $conf.="!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n\n";
    $conf.="!!!! Router CISCO B -- ".$s_params['ip_b']." --- ".$s_params['router_b']."\n\n";    
    $conf.="!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n";
    $conf.="no interface ".$s_params['interface_b'].'.'.$s_params['c_vlan']."\n";   
    //$conf.="exit"."\n";
    $conf.="\n";
    $conf.='router ospf 10'."\n";
    $conf.=' area 0'."\n";
    $conf.='  no interface '.$s_params['interface_b'].'.'.$s_params['c_vlan']."\n";
    $conf.="exit"."\n";
    $conf.="exit"."\n";
    if(count($ip_pa) > 0)
    {
        if($ip_pa[0] !== '')
        {
            $conf.="\n\n";
            $conf.="prefix-set BGP_STATIC"."\n";
            for($i=0; $i<count($ip_pa);$i++)
            {
                list($ip,$maska)=explode('/',$ip_pa[$i]);
                if(trim($ip_pa[$i]) !== '') $conf.=" no ".$ip_pa[$i].' ge '.'/'.$maska."\n";
            }
            $conf.="exit"."\n";
            //$conf.="exit"."\n";
        
            $conf.="\n\n";
            $conf.="router static"."\n";
            $conf.="address-family ipv4 unicast"."\n";
            for($i=0; $i<count($ip_pa);$i++)
            {
                list($ip,$maska)=explode('/',$ip_pa[$i]);
                if(trim($ip_pa[$i]) !== '') $conf.=" no ".$ip_pa[$i].' '.$ip_p2p_2."\n";
            }
            $conf.="exit"."\n";
            $conf.="exit"."\n";
        }
    }
    $conf.="!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n\n";    
    $conf.="\n\n\n";
    
    $s_vlan=$s_params['s_vlan'];
    if($s_params['s_vlan']==='') $s_vlan=$s_params['c_vlan']; //konieczne dla zwyklego tranytu
    $conf.="interface ".$s_params['interface_b'].'.'.$s_vlan." l2transport"."\n";
    $conf.="    description Biznes_L2VPN_Warszawa_B2B_do_Pereca"."\n";
    $conf.="    encapsulation dot1q ".$s_params['c_vlan']."\n";
    $conf.="    mtu ".$mtu_cisco."\n";
    $conf.="    no rewrite ingress tag pop 1 symmetric"."\n";
    //$conf.="    service-policy input ".$s_params['nazwa_uslugi']."_IN"."\n";
    //$conf.="    service-policy output ".$s_params['nazwa_uslugi']."_OUT"."\n";
    $conf.="exit"."\n";
    $conf.="\n\n\n\n";
    $conf.="!!!IF NOT EXIST!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n\n";
    $conf.="l2vpn"."\n";
    $conf.="    pw-class ptp_B2B_vlan_".$s_vlan."\n";
    $conf.="    encapsulation mpls"."\n";
    $conf.="    control-word"."\n";
    $conf.="    protocol ldp"."\n";
    $conf.="    transport-mode vlan"."\n";
    $conf.="exit"."\n";
    
    $conf.="l2vpn"."\n";
    $conf.="    xconnect group ptp_B2B_vlan_".$s_vlan."\n";
    $conf.="    p2p ptp_B2B_vlan_".$s_vlan."\n";
    $conf.="    interface ".$s_params['interface_b'].'.'.$s_vlan."\n";
    $conf.="    neighbor ipv4 89.228.0.50 pw-id ".$s_vlan."\n";
    $conf.="        pw-class ptp_B2B_vlan_".$s_vlan."\n";
    $conf.="        exit"."\n";
    $conf.="    exit"."\n";
    $conf.="exit"."\n";
    $conf.="exit"."\n";

    $conf.="\n\n";
    
    return $conf;
}
 * 
 */
//======================================================================================================================        

function gen_config_juniper_bridge($s_params,$migracja,$mtu_cisco,$mtu_juniper)
{
    $download=trim(get_download($s_params['pasmo']));
    $burst_d=(int)($download/10);
    $upload=  trim(get_upload($s_params['pasmo']));
    $burst_u=(int)($upload/10);

    $conf='';

    $conf.="#### Router Interface 1: ".$s_params['interface_a']." miasto: ".$s_params['miasto_a']." --- ".$s_params['ip_a']."  -- ".$s_params['router_a']." ############################"."\n\n";
    $conf.="#delete ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']."\n";
    
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." description ".$s_params['description_a']."\n";
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." encapsulation vlan-bridge"."\n";
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." vlan-id ".$s_params['c_vlan']."\n";
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." family bridge policer input ".$s_params['nazwa_uslugi']."-IN"."\n";
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." family bridge policer output ".$s_params['nazwa_uslugi']."-OUT"."\n";
    $conf.="\n\n";
    
    $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-IN if-exceeding bandwidth-limit ".$download."m"."\n";
    if($burst_d !== 0) $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-IN if-exceeding burst-size-limit ".$burst_d."m"."\n";
    else $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-IN if-exceeding burst-size-limit ".'1'."m"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-IN then discard"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-OUT if-exceeding bandwidth-limit ".$upload."m"."\n";
    if($burst_u !== 0) $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-OUT if-exceeding burst-size-limit ".$burst_u."m"."\n";
    else $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-OUT if-exceeding burst-size-limit ".'1'."m"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-OUT then discard"."\n";

    $conf.="#### Router Interface 2: ".$s_params['interface_b']." miasto: ".$s_params['miasto_a']." --- ".$s_params['ip_b']."  -- ".$s_params['router_b']." ############################"."\n\n";
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_b']." unit ".$s_params['s_unit']." description ".$s_params['description_b']."\n";
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_b']." unit ".$s_params['s_unit']." encapsulation vlan-bridge"."\n";
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_b']." unit ".$s_params['s_unit']." vlan-id ".$s_params['c_vlan']."\n";
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_b']." unit ".$s_params['s_unit']." family bridge policer input ".$s_params['nazwa_uslugi']."-IN"."\n";
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_b']." unit ".$s_params['s_unit']." family bridge policer output ".$s_params['nazwa_uslugi']."-OUT"."\n";
    $conf.="\n\n";
    
    $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-IN if-exceeding bandwidth-limit ".$download."m"."\n";
    if($burst_d !== 0) $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-IN if-exceeding burst-size-limit ".$burst_d."m"."\n";
    else $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-IN if-exceeding burst-size-limit ".'1'."m"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-IN then discard"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-OUT if-exceeding bandwidth-limit ".$upload."m"."\n";
    if($burst_u !== 0) $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-OUT if-exceeding burst-size-limit ".$burst_u."m"."\n";
    else $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-OUT if-exceeding burst-size-limit ".'1'."m"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-OUT then discard"."\n";

    $conf.="\n";

    //$conf.="set ".$s_params['logical_system_a']." bridge-domains "."Vlan".$s_params['c_vlan']." vlan-id ".$s_params['c_vlan']."\n";
    //$conf.="set ".$s_params['logical_system_a']." bridge-domains "."Vlan".$s_params['c_vlan']." interface ".$s_params['interface_b'].'.'.$s_params['s_unit']."\n";
    //$conf.="set ".$s_params['logical_system_a']." bridge-domains "."Vlan".$s_params['c_vlan']." interface ".$s_params['interface_a'].'.'.$s_params['s_unit']."\n";
    
    $conf.="set ".$s_params['logical_system_a']." bridge-domains ".$s_params['c_vlan']." vlan-id ".$s_params['c_vlan']."\n";
    $conf.="set ".$s_params['logical_system_a']." bridge-domains ".$s_params['c_vlan']." interface ".$s_params['interface_b'].'.'.$s_params['s_unit']."\n";
    $conf.="set ".$s_params['logical_system_a']." bridge-domains ".$s_params['c_vlan']." interface ".$s_params['interface_a'].'.'.$s_params['s_unit']."\n";

    return $conf;
}

function gen_config_cisco_bridge($s_params,$migracja)
{
    $download=trim(get_download($s_params['pasmo']));
    $burst_d=(int)($download/10);
    $upload=  trim(get_upload($s_params['pasmo']));
    $burst_u=(int)($upload/10);
    
    $s_unit=$s_params['s_unit'];
    if($s_unit==='') $s_unit=$s_params['c_vlan']; //konieczne dla zwyklego tranzytu
    $conf='';
    $conf.="!!!! Router CISCO 1 ".$s_params['ip_a']." --- ".$s_params['router_a']."\n\n";
    
    $conf.="interface ".$s_params['interface_a'].'.'.$s_unit." l2transport"."\n";
    $conf.="    description ".$s_params['description_a']."\n";
    $conf.="    encapsulation dot1q ".$s_params['c_vlan']."\n";
    $conf.="    mtu 2000"."\n";
    $conf.="    rewrite ingress tag pop 1 symmetric"."\n";
    $conf.="    service-policy input ".$s_params['nazwa_uslugi']."_IN"."\n";
    $conf.="    service-policy output ".$s_params['nazwa_uslugi']."_OUT"."\n";
    $conf.="exit"."\n";
    $conf.="\n\n";
    
    $conf.="policy-map ".$s_params['nazwa_uslugi']."_IN"."\n";
    $conf.="    class class-default"."\n";
    $conf.="    police rate ".$download." mbps"."\n";
    $conf.="end-policy-map"."\n";
    $conf.="\n\n";
    
    $conf.="policy-map ".$s_params['nazwa_uslugi']."_OUT"."\n";
    $conf.="    class class-default"."\n";
    $conf.="    police rate ".$upload." mbps"."\n";
    $conf.="end-policy-map"."\n";

    $conf.="\n\n";
    
    $conf.="!!!! Router CISCO 2 ".$s_params['ip_a']." --- ".$s_params['router_a']."\n\n";
    
    $conf.="interface ".$s_params['interface_b'].'.'.$s_unit." l2transport"."\n";
    $conf.="    description ".$s_params['description_b']."\n";
    $conf.="    encapsulation dot1q ".$s_params['c_vlan']."\n";
    $conf.="    mtu 2000"."\n";
    $conf.="    rewrite ingress tag pop 1 symmetric"."\n";
    $conf.="    service-policy input ".$s_params['nazwa_uslugi']."_IN"."\n";
    $conf.="    service-policy output ".$s_params['nazwa_uslugi']."_OUT"."\n";
    $conf.="exit"."\n";
    $conf.="\n\n";
    
    $conf.="l2vpn"."\n";
    //$conf.="    bridge group ptp_B2B_vlan_".$s_vlan."\n";
    $conf.="    bridge group MM"."\n";
    $conf.="    bridge-domain Vlan".$s_unit."\n";
    $conf.="        interface ".$s_params['interface_a'].'.'.$s_vlan."\n";
    $conf.="        interface ".$s_params['interface_b'].'.'.$s_vlan."\n";
    $conf.="    exit"."\n";
    $conf.="exit"."\n";
    $conf.="exit"."\n";
    $conf.="\n\n";
    
    $conf.="\n\n";

    return $conf;
}
//=================================================================================================================================================
function gen_config_juniper_switching($s_params,$migracja,$mtu_cisco,$mtu_juniper)
{
    $conf='';

    $conf.="#### JUNIPER ".$s_params['ip_a']."\n\n";
    
    $conf.="set vlans v".$s_params['c_vlan']." vlan-id ".$s_params['c_vlan']."\n";
    $conf.="set protocols vstp vlan ".$s_params['c_vlan']."\n";
    
    $conf.="set "." interfaces ".$s_params['interface_a']." unit 0 family ethernet-switching vlan members ".$s_params['c_vlan']."\n";
    $conf.="set "." interfaces ".$s_params['interface_b']." unit 0 family ethernet-switching vlan members ".$s_params['c_vlan']."\n";

    $conf.="\n";

    return $conf;
}

function gen_config_cisco_switching($s_params,$migracja,$mtu_cisco,$mtu_juniper)
{
    $conf='';
    $conf.="!!!! CISCO ".$s_params['ip_a']."\n\n";
    
    //Create vlan
    $conf.="vlan ".$s_params['c_vlan']."\n";
    $conf.="    name ".$s_params['description_a']."\n";
    
    //Configure interface a
    $conf.="interface ".$s_params['interface_a'].'.'.$s_params['c_vlan']."\n";
    //$conf.="    description ".$s_params['description_a']."\n";
    $conf.="    switchport trunk allowed vlan add ".$s_params['c_vlan']."\n";
    $conf.="exit"."\n";
    
    //Config interface b
    $conf.="interface ".$s_params['interface_b'].'.'.$s_params['c_vlan']."\n";
    //$conf.="    description ".$s_params['description_b']."\n";
    $conf.="    switchport trunk allowed vlan add ".$s_params['c_vlan']."\n";
    $conf.="exit"."\n";
        
    $conf.="\n";

    return $conf;
}

//-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
function gen_config_juniper_connected_a($s_params,$migracja,$mtu_cisco,$mtu_juniper)
{
    $download=trim(get_download($s_params['pasmo']));
    $burst_d=(int)($download/10);
    $upload=  trim(get_upload($s_params['pasmo']));
    $burst_u=(int)($upload/10);
    
    $conf='';
    $conf.="#### Router A ".$s_params['miasto_a']." --- ".$s_params['ip_a']."  -- ".$s_params['router_a']." ############################"."\n\n";
    $conf.="#delete ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']."\n";
    
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." description ".$s_params['description_a']."\n";
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." encapsulation vlan-ccc"."\n";
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." vlan-id ".$s_params['c_vlan']."\n";
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." family ccc policer input ".$s_params['nazwa_uslugi']."-IN"."\n";
    $conf.="set ".$s_params['logical_system_a']." interfaces ".$s_params['interface_a']." unit ".$s_params['s_unit']." family ccc policer output ".$s_params['nazwa_uslugi']."-OUT"."\n";
    $conf.="\n\n";
    
    $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-IN if-exceeding bandwidth-limit ".$download."m"."\n";
    if($burst_d !== 0) $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-IN if-exceeding burst-size-limit ".$burst_d."m"."\n";
    else $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-IN if-exceeding burst-size-limit ".'1'."m"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-IN then discard"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-OUT if-exceeding bandwidth-limit ".$upload."m"."\n";
    if($burst_u !== 0) $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-OUT if-exceeding burst-size-limit ".$burst_u."m"."\n";
    else $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-OUT if-exceeding burst-size-limit ".'1'."m"."\n";
    $conf.="set ".$s_params['logical_system_a']." firewall policer ".$s_params['nazwa_uslugi']."-OUT then discard"."\n";

    $conf.="\n\n";
        
    //$conf.="set ".$s_params['logical_system_a']." protocols l2circuit neighbor ".$s_params['router_b']." interface ".$s_params['interface_a'].'.'.$s_params['c_vlan']." virtual-circuit-id ".$s_params['c_vlan']."\n";
    //$conf.="set ".$s_params['logical_system_a']." protocols l2circuit neighbor ".$s_params['router_b']." interface ".$s_params['interface_a'].'.'.$s_params['c_vlan']." mtu ".$mtu_juniper."\n";
        
    return $conf;
}

function gen_config_juniper_connected_b($s_params,$migracja,$mtu_cisco,$mtu_juniper)
{
    $download=trim(get_download($s_params['pasmo']));
    $burst_d=(int)($download/10);
    $upload=  trim(get_upload($s_params['pasmo']));
    $burst_u=(int)($upload/10);    
    
    if($d_unit==='') $d_unit=$s_params['s_unit'];
    if($d_vlan==='') $d_vlan=$s_params['c_vlan'];

    $conf='';
    $conf.="#### Router B ".$s_params['miasto_b']." ---  ".$s_params['ip_b']." -- ".$s_params['router_b']." ##########################"."\n\n";
    $conf.="#delete ".$s_params['logical_system_b']." interfaces ".$s_params['interface_b']." unit ".$s_params['d_unit']."\n";
    
    $conf.="set ".$s_params['logical_system_b']." interfaces ".$s_params['interface_b']." unit ".$s_params['d_unit']." description ".$s_params['description_b']."\n";
    $conf.="set ".$s_params['logical_system_b']." interfaces ".$s_params['interface_b']." unit ".$s_params['d_unit']." encapsulation vlan-ccc"."\n";
    $conf.="set ".$s_params['logical_system_b']." interfaces ".$s_params['interface_b']." unit ".$s_params['d_unit']." vlan-id ".$s_params['d_vlan']."\n";
    $conf.="set ".$s_params['logical_system_b']." interfaces ".$s_params['interface_b']." unit ".$s_params['d_unit']." family ccc policer input ".$s_params['nazwa_uslugi']."-IN"."\n";
    $conf.="set ".$s_params['logical_system_b']." interfaces ".$s_params['interface_b']." unit ".$s_params['d_unit']." family ccc policer output ".$s_params['nazwa_uslugi']."-OUT"."\n";
    $conf.="\n\n";
    
    $conf.="set ".$s_params['logical_system_b']." firewall policer ".$s_params['nazwa_uslugi']."-IN if-exceeding bandwidth-limit ".$download."m"."\n";
    if($burst_d !== 0) $conf.="set ".$s_params['logical_system_b']." firewall policer ".$s_params['nazwa_uslugi']."-IN if-exceeding burst-size-limit ".$burst_d."m"."\n";
    else $conf.="set ".$s_params['logical_system_b']." firewall policer ".$s_params['nazwa_uslugi']."-IN if-exceeding burst-size-limit ".'1'."m"."\n";
    $conf.="set ".$s_params['logical_system_b']." firewall policer ".$s_params['nazwa_uslugi']."-IN then discard"."\n";
    $conf.="set ".$s_params['logical_system_b']." firewall policer ".$s_params['nazwa_uslugi']."-OUT if-exceeding bandwidth-limit ".$upload."m"."\n";
    if($burst_u !== 0) $conf.="set ".$s_params['logical_system_b']." firewall policer ".$s_params['nazwa_uslugi']."-OUT if-exceeding burst-size-limit ".$burst_u."m"."\n";
    else $conf.="set ".$s_params['logical_system_b']." firewall policer ".$s_params['nazwa_uslugi']."-OUT if-exceeding burst-size-limit ".'1'."m"."\n";
    $conf.="set ".$s_params['logical_system_b']." firewall policer ".$s_params['nazwa_uslugi']."-OUT then discard"."\n";

    $conf.="\n\n";
        
    //$conf.="set ".$s_params['logical_system_b']." protocols l2circuit neighbor ".$s_params['router_a']." interface ".$s_params['interface_b'].'.'.$s_params['c_vlan']." virtual-circuit-id ".$s_params['c_vlan']."\n";
    //$conf.="set ".$s_params['logical_system_b']." protocols l2circuit neighbor ".$s_params['router_a']." interface ".$s_params['interface_b'].'.'.$s_params['c_vlan']." mtu ".$mtu_juniper."\n";

    $conf.="\n\n\n".$conf_t;
    return $conf;
}

function gen_config_cisco_connected_a($s_params,$migracja,$mtu_cisco,$mtu_juniper)
{
    $download=trim(get_download($s_params['pasmo']));
    $upload=  trim(get_upload($s_params['pasmo']));    
    
    $s_vlan=$s_params['s_vlan'];
    if($s_vlan==='') $s_vlan=$s_params['c_vlan']; //konieczne dla zwyklego tranzytu
    $conf='';
    $conf.="!!!! Router CISCO A ".$s_params['ip_a']." --- ".$s_params['router_a']."\n\n";
    
    $conf.="interface ".$s_params['interface_a'].'.'.$s_vlan." l2transport"."\n";
    $conf.="    description ".$s_params['description_a']."\n";
    $conf.="    encapsulation dot1q ".$s_params['c_vlan']."\n";
    $conf.="    mtu ".$mtu_cisco."\n";
    $conf.="    rewrite ingress tag pop 1 symmetric"."\n";
    $conf.="    service-policy input ".$s_params['nazwa_uslugi']."_IN"."\n";
    $conf.="    service-policy output ".$s_params['nazwa_uslugi']."_OUT"."\n";
    $conf.="exit"."\n";
    $conf.="\n\n";
    
    $conf.="policy-map ".$s_params['nazwa_uslugi']."_IN"."\n";
    $conf.="    class class-default"."\n";
    $conf.="    police rate ".$download." mbps"."\n";
    $conf.="end-policy-map"."\n";
    $conf.="\n\n";
    
    $conf.="policy-map ".$s_params['nazwa_uslugi']."_OUT"."\n";
    $conf.="    class class-default"."\n";
    $conf.="    police rate ".$upload." mbps"."\n";
    $conf.="end-policy-map"."\n";

    $conf.="\n\n";

    $conf.="l2vpn"."\n";
    $conf.="    pw-class ptp_B2B_vlan_".$s_vlan."\n";
    $conf.="    encapsulation mpls"."\n";
    $conf.="    control-word"."\n";    
    $conf.="    protocol ldp"."\n";
    $conf.="    !transport-mode vlan"."\n";
    $conf.="    transport-mode ethernet"."\n";
    $conf.="exit"."\n";
    $conf.="exit"."\n";
    $conf.="exit"."\n";
    
    $conf.="l2vpn"."\n";
    $conf.="    xconnect group ptp_B2B_vlan_".$s_vlan."\n";
    $conf.="    p2p ptp_B2B_vlan_".$s_vlan."\n";
    $conf.="    interface ".$s_params['interface_a'].'.'.$s_vlan."\n";
    $conf.="    neighbor ipv4 ".$s_params['router_b']." pw-id ".$s_vlan."\n";
    $conf.="        pw-class ptp_B2B_vlan_".$s_vlan."\n";
    $conf.="        exit"."\n";
    $conf.="    exit"."\n";
    $conf.="exit"."\n";
    $conf.="exit"."\n";
    $conf.="\n\n";
    
    return $conf;
}

function gen_config_cisco_connected_b($s_params,$migracja,$mtu_cisco,$mtu_juniper)
{
    $download=trim(get_download($s_params['pasmo']));
    $upload=  trim(get_upload($s_params['pasmo']));    
    
    $s_vlan=$s_params['s_vlan'];
    if($s_vlan==='') $s_vlan=$s_params['c_vlan']; //konieczne dla zwyklego tranzytu
    $conf='';
    $conf.="!!!! Router CISCO B ".$s_params['ip_b']." --- ".$s_params['router_b']."\n\n";
    
    $conf.="interface ".$s_params['interface_b'].'.'.$s_vlan." l2transport"."\n";
    $conf.="    description ".$s_params['description_b']."\n";
    $conf.="    encapsulation dot1q ".$s_params['d_vlan']."\n";
    $conf.="    mtu ".$mtu_cisco."\n";
    $conf.="    rewrite ingress tag pop 1 symmetric"."\n";
    $conf.="    service-policy input ".$s_params['nazwa_uslugi']."_IN"."\n";
    $conf.="    service-policy output ".$s_params['nazwa_uslugi']."_OUT"."\n";
    $conf.="exit"."\n";
    $conf.="\n\n";
    
    $conf.="policy-map ".$s_params['nazwa_uslugi']."_IN"."\n";
    $conf.="    class class-default"."\n";
    $conf.="    police rate ".$download." mbps"."\n";
    $conf.="end-policy-map"."\n";
    $conf.="\n\n";
    
    $conf.="policy-map ".$s_params['nazwa_uslugi']."_OUT"."\n";
    $conf.="    class class-default"."\n";
    $conf.="    police rate ".$upload." mbps"."\n";
    $conf.="end-policy-map"."\n";

    $conf.="\n\n";

    $conf.="l2vpn"."\n";
    $conf.="    pw-class ptp_B2B_vlan_".$s_vlan."\n";
    $conf.="    encapsulation mpls"."\n";
    $conf.="    control-word"."\n";    
    $conf.="    protocol ldp"."\n";
    $conf.="    !transport-mode vlan"."\n";
    $conf.="    transport-mode ethernet"."\n";
    $conf.="exit"."\n";
    
    $conf.="l2vpn"."\n";
    $conf.="    xconnect group ptp_B2B_vlan_".$s_vlan."\n";
    $conf.="    p2p ptp_B2B_vlan_".$s_vlan."\n";
    $conf.="    interface ".$s_params['interface_b'].'.'.$s_vlan."\n";
    $conf.="    neighbor ipv4 ".$s_params['router_a']." pw-id ".$s_vlan."\n";
    $conf.="        pw-class ptp_B2B_vlan_".$s_vlan."\n";
    $conf.="        exit"."\n";
    $conf.="    exit"."\n";
    $conf.="exit"."\n";
    $conf.="exit"."\n";
    $conf.="\n\n";
    
    return $conf;
}
//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        
function update_db($s_params,$conf,$rec_id,$src_d)
{
    $d_a=$s_params['description_a'];
    $d_b=$s_params['description_b'];
    $db = new db_connect(__FILE__.' '.__FUNCTION__.' '.__LINE__);
    if($src_d===1 || $src_d==='1')
    {
        $sql="UPDATE core_b2b set   konfig='$conf',
                                    description_a='$d_a',
                                    description_b='$d_b'
              WHERE id='$rec_id'";
    } else
        if($src_d===2 || $src_d==='2')
        {
            $sql="UPDATE core_b2b_subgrid set konfig='$conf',
                                            description_a='$d_a',
                                            description_b='$d_b'
                  WHERE id='$rec_id'";
        }    
    $db->db_get($sql,__FILE__.' '.__FUNCTION__.' '.__LINE__);    
}

?>
