# **Interface statistics and trends**

### Table of contents

*   [Interface statistics and trends](#Interface_statistics_and_trends)
    *   [Interfacetable\_v3t performance data generalities](#Interfacetable_v3t_performance_data_generalities)
    *   [Pnp4nagios](#Pnp4nagios)
        *   [Performance data](#Performance_data)
        *   [Templates](#Templates)
        *   [General status graph page](#General_status_graph_page)
        *   [Interface related graph page](#Interface_related_graph_page)
    *   [Nagiosgrapher](#Nagiosgrapher)
        *   [Performance data](#Performance_data_2)
        *   [Templates](#Templates_2)
        *   [General status graph page](#General_status_graph_page_2)
        *   [Interface related graph page](#Interface_related_graph_page_2)

# Interface statistics and trends

## Interfacetable\_v3t performance data generalities

The plugin monitors the interface properties and traffic info, but can also gather lots of statistics for graphing purpose. This performance data are not returned by default, so you need to activate their generation by using the --enableperfdata option (or -f)

Also, you can specify which performance data need to be returned. This is triggered by the --perfdataformat option, which can take the following values:

*   full : generated performance data include plugin related stats, interface status, interface load stats, and packet error stats
*   loadonly : generated performance data include plugin related stats, interface status, and interface load stats
*   globalonly : generated performance data include only plugin related stats

Default is full. Note that 'loadonly' should be used in case of too many interfaces and consequently too much performance data which cannot fit in the nagios plugin output buffer. By default, its size is 8k and can be extended by modifying MAX\_PLUGIN\_OUTPUT\_LENGTH in the nagios sources.

More generally, the plugin can return 2 types of performance data:

*   global performance data: consist in some statistics about the plugin execution, and general interface availability counters
*   per interface performance data: consist in the interface operational status, traffic load and packet error/discard statistics

Hereunder is an example of the 2 types of performance data:

![Image](images/interface-statistics-and-trends/performance_data_types.png)

The performance data are usually used to create graphs for trend analysis. Different solutions exist for processing these data, and some popular ones are: Pnp4nagios, NagiosGrapher or NetwaysGrapherV2. The check\_interface\_table\_v3t.pl plugin should handle at least these 3 solutions. As the performance data generated by the plugin are following the guidelines (check\_multi guidelines especially), it should be supported by most of the graphing solutions. At the moment, the 2 following solutions have been completely tested: pnp4nagios and nagiosgrapher. Let's see how to use the plugin with them.

## Pnp4nagios

Pnp4nagios is the default graphing solution for Interfacetable\_v3t.

### Performance data

When using pnp4nagios as grapher (--grapher=pnp4nagios), the plugin returns the performance data in the standard output, after the pipe character. Then, the nagios core processes these performance data and generates the service perfdata file (generally named service-perfdata). This file is periodically loaded by pnp4nagios to update the rrd files containing the statistics used to generate the graphs. See the pnp4nagios website for more info on how to configure pnp4nagios (http://docs.pnp4nagios.org/pnp-0.6/start)

As noted previously, this plugin can returns lots of performance data in case of a significant number of interfaces (which is generally the case with swtiches). In this situation, the 'plugin output' buffer of nagios, which is a 8k buffer, can become full. The performance data are then truncated and can consequently be partial or invalid. To avoid that, you can:

*   increase your buffer limits in the nagios/icinga sources and recompile/reinstall nagios  
    Edit /include/nagios.h (icinga.h) and increase (MAX\_PLUGIN\_OUTPUT\_LENGTH and MAX\_INPUT\_BUFFER).  

    ```
    #define MAX_PLUGIN_OUTPUT_LENGTH               32768
    ```

    Edit /include/common.h and increase (MAX\_PLUGIN\_OUTPUT\_LENGTH und MAX\_INPUT\_BUFFER).  

    ```
    #define MAX_INPUT_BUFFER                       32768
    #define MAX_EXTERNAL_COMMAND_LENGTH            32768
    ```

    Note: when using nagios with extended buffer limits, you cannot use the pnp4nagios mode 'Bulk Mode with NPCD and npcdmod'. Indeed, npcdmod still truncates the performance data at 8k, and there is currently no ways to correct that. Instead, use the mode 'Bulk Mode with NPCD'.

*   reduce the amount of performance data returned by the plugin, by selecting some performance data to be not returned. Indeed, --perfdataformat=loadonly will only generate performance data related to the plugin, the interface status and the interface loads. Statistics related to the packet errors/discards will not be returned.

### Templates

Some pnp4nagios templates are available in the contrib directory of the interfacetable\_v3t package:

*   check\_interface\_table\_global.php
*   check\_interface\_table\_port\_bit.php
*   check\_interface\_table\_port\_octet.php

To use it,

*   copy the check\_interface\_table\_global.php file in the pnp4nagios template directory (ex: /usr/local/pnp4nagios/share/templates/).
*   if you will use the option --portperfunit=bit (default), copy the check\_interface\_table\_port\_bit.php file in the pnp4nagios template directory
*   if you will use the option --portperfunit=octet, copy the check\_interface\_table\_port\_octet.php file in the pnp4nagios template directory

Then, let's go to the pnp4nagios web interface to see the generated graphs.

![Image](images/interface-statistics-and-trends/pnp4nagios_home.png)

On the right of this page, there is the list of all nagios/icinga services generating graphs. Note the 'Interface status' service: it should be presented as a graph tree.

![Image](images/interface-statistics-and-trends/pnp4nagios_service_list.png)

Like the performance data types, there are 2 types of graph pages:

*   one for general status graphs
*   one for interface related graphs

### General status graph page

Clicking on the link 'Interface status' will direct you to the corresponding page.

On that page, you will see 2 graphs:

The first one reports some counters related to the status of the interface (free, used, administratively down).

![Image](images/interface-statistics-and-trends/pnp4nagios_general_status_graph_1.png)

The second one reports the time taken to pool the interface info from the monitored node (SNMP requests time). This is more a plugin related graph, used for maintenance and troubleshooting.

![Image](images/interface-statistics-and-trends/pnp4nagios_general_status_graph_2.png)

### Interface related graph page

Clicking on one of the interface name will redirect you to the graphs related to that interface.

You will find 2 or 3 graphs:

Traffic load on the interface

![Image](images/interface-statistics-and-trends/pnp4nagios_interface_graph_1.png)

Packet errors/discards on that interface

![Image](images/interface-statistics-and-trends/pnp4nagios_interface_graph_2.png)

Operational status changes

![Image](images/interface-statistics-and-trends/pnp4nagios_interface_graph_3.png)

Note that the last graph could be replaced by adding an operational status bar at the top of the traffic load graph, as shown below. This is an option easily switchable in the templates used by pnp4nagios to generate the graphs.

![Image](images/interface-statistics-and-trends/pnp4nagios_interface_graph_4.png)

## Nagiosgrapher

### Performance data

When using nagiosgrapher as grapher (--grapher=nagiosgrapher), the plugin returns the performance data in a performance data file. The location of this file is specified by the option --perfdatadir (ex: --perfdatadir /usr/local/nagiosgrapher/var/). Indeed, nagiosgrapher cannot handle check\_multi formated plugin outputs. Consequently, the graphs cannot be well plotted via the performance data files generated by the nagios/icinga core.

### Templates

Some nagiosgrapher templates are available in the contrib directory of the interfacetable\_v3t package:

*   check\_interface\_table\_global.ncfg
*   check\_interface\_table\_port\_bit.ncfg
*   check\_interface\_table\_port\_octet.ncfg

To use it,

*   copy the check\_interface\_table\_global.ncfg file in the nagiosgrapher template directory (ex: /Monitoring/icinga-addons/nagiosgrapher/etc/ngraph.d/templates/standard/).
*   if you will use the option --portperfunit=bit (default), copy the check\_interface\_table\_port\_bit.ncfg file in the nagiosgrapher template directory
*   if you will use the option --portperfunit=octet, copy the check\_interface\_table\_port\_octet.ncfg file in the nagiosgrapher template directory

Then, let's go to the nagiosgrapher web interface to see the generated graphs. There are 2 types of graph pages:

*   one for general status graphs
*   one for interface related graphs

### General status graph page

Clicking on the link 'Interface status' will direct you to the corresponding page.

On that page, you will see 2 graphs:

The first one reports some counters related to the status of the interface (free, used, administratively down).

![Image](images/interface-statistics-and-trends/nagiosgrapher_general_status_graph_1.png)

The second one reports the time taken to pool the interface info from the monitored node (SNMP requests time). This is more a plugin related graph, used for maintenance and troubleshooting.

![Image](images/interface-statistics-and-trends/nagiosgrapher_general_status_graph_2.png)

### Interface related graph page

Clicking on one of the interface name will redirect you to the graphs related to that interface.

You will find 3 graphs:

Operational status changes

![Image](images/interface-statistics-and-trends/nagiosgrapher_interface_graph_1.png)

Traffic load on the interface

![Image](images/interface-statistics-and-trends/nagiosgrapher_interface_graph_3.png)

Packet errors/discards on that interface

![Image](images/interface-statistics-and-trends/nagiosgrapher_interface_graph_2.png)
