<?php
/**
 * @package         
 * @copyright       Copyright (C) 2017 MDM-IT Mariusz Dziewulski. All rights reserved.
 * @license         see LICENSE.txt
 */

    //error_reporting(0);    
    include_once("permition_app_class.php");
    $app_permit=new app_permit();
    if($app_permit->permit_module(basename(__FILE__))==='0') exit;
    include("config/config.php");

    include_once("main_window_menu.php");
    include_once("main_window_toolbar.php");

?>
<html>
<header>    
<title>NetMap4Nagios</title>
<link type="text/css" href="js/jquery/css/redmond/jquery-ui.custom.css" rel="stylesheet" />
<script type="text/javascript" src="js/jquery/jquery.js"></script>
<script  type="text/javascript" src="js/jquery/jquery-ui.js"></script>

<link   rel="stylesheet" type="text/css" media="screen" href="js/jqGrid/css/ui.jqgrid.css" />
<link rel="stylesheet" type="text/css" media="screen" href="js/jqGrid/css/mdmit/redmond/ui.jqgrid_md.css" />
<!--<link rel="stylesheet" type="text/css" media="screen" href="js/jqGrid-4.8.2/css/ui.jqgrid.css" />-->
<script  src="js/jqGrid/js/i18n/grid.locale-en.js" type="text/javascript"></script>
<script  src="js/jqGrid/js/jquery.jqGrid.min.js" type="text/javascript"></script>
<script  type="text/javascript" src="js/jqGrid/js/jquery.contextmenu.js"></script>

<link rel="stylesheet" href="js/Zebra/css/mdmit/zebra_dialog.css" type="text/css">
<script type="text/javascript" src="js/Zebra/zebra_dialog.js"></script>
<link type="text/css" href="js/jquery_window/css/jquery.window.css" rel="stylesheet" />
<link type="text/css" href="js/jquery_window/css/mdmit_window.css" rel="stylesheet" />
<script type="text/javascript" src="js/jquery_window/jquery.window.min.js"></script>

<script type="text/javascript" src="lib/mdmit_dialogs.js"></script>

<!--<link type="text/css" href="lib/main_window_style.css" rel="stylesheet" />-->
<script type="text/javascript" src="lib/mdmit_lib.js"></script>
<style>
#grid tr:hover{  
    background:none;
}    
.ui-jqgrid .ui-jqgrid-htable th{
    color: #ffffff; 
    font-weight: bold;
    /*font-family: Lucida Grande, Lucida Sans, Arial,sans-serif,Tahoma,Verdana;*/
    font-size: 10px;
    background-image: url(js/jquery/css/redmond/images/ui-bg_gloss-wave_55_5c9ccc_500x100.png);
}
.ui-jqgrid .ui-jqgrid-htable th,
.ui-jqgrid .ui-jqgrid-btable .jqgrow td {
    /*height: 18px !important;*/
}
.evenTableRow
{
   background: #F4F4FF;
   /*background-color:#e8eef4;*/
}
.oddTableRow
{
   background: #e8eef4;
}    
/*.ui-jqgrid tr.jqgrow td 
{
    white-space: normal !important;
}*/
body {
	margin: 0 0 0 0;
	padding: 0;        
}
    
.ui-button-text {
   font-size: 0.9em !important;
   line-height: 1.2 !important;
   font-style: normal;
   font-weight: normal;
   padding: 0.2em 0.8em !important;
}
.ui-button {
   border-radius: 2px !important; 
}
</style>

<body>
<div id="main_page_id" style="margin-bottom: 3px; margin-top: 8px; margin-left: 5px; margin-right: 5px;" align="center">
    <table id="grid1"></table>
    <div id="pager1"></div>
    <div id="mysearch"></div>
</div>
<script type="text/javascript">
var refresh_interval="<?php echo $refresh_interval; ?>";
refresh_interval=refresh_interval*1000;
window.setInterval(startAutoRefreshing, refresh_interval);
function startAutoRefreshing()
{
    jQuery("#grid1").trigger("reloadGrid",[{current:true}]);
}

var mygrid = jQuery("#grid1").jqGrid({
   	url:"servers/serwer_nagios.php?q=select_hosts_state",
        datatype: "xml",
        colNames:['Service Disp Name','Host ID','Host Name','Address IP','Status Information','Last Check','Next Check','Last Hard State','State Type','Next Notifi.','Perfdata','State'],
        colModel:[
                  {name:'h_display_name',   index:'nagios_hosts.display_name',          width:60,hidden:true, align:"left"},
                  {name:'host_object_id',   index:'nagios_hosts.host_object_id',        width:10,hidden:true,  align:"left"},  
                  {name:'alias',            index:'nagios_hosts.alias',                 width:120,hidden:false,align:"left"},
                  {name:'adress_ip',        index:'nagios_hosts.address',               width:60,hidden:false, align:"left"},
                  {name:'output',           index:'nagios_hoststatus.output',           width:100,hidden:false, align:"left"},
                  {name:'last_check',       index:'nagios_hoststatus.last_check',       width:40,hidden:false, align:"left"},
                  {name:'next_check',       index:'nagios_hoststatus.next_check',       width:40,hidden:false, align:"left"},
                  {name:'last_hard_state',  index:'nagios_hoststatus.last_hard_state',  width:40,hidden:true,  align:"left"},
                  {name:'state_type',       index:'nagios_hoststatus.state_type',       width:20,hidden:true,  align:"left"},
                  {name:'next_notification',index:'nagios_hoststatus.next_notification',width:40,hidden:true, align:"left"},
                  {name:'perfdata',         index:'nagios_hoststatus.perfdata',         width:60,hidden:false, align:"left"},
		  {name:'current_state',    index:'nagios_hoststatus.current_state',	width:15,hidden:false, align:"left"}
   	],
        rowNum:500,
   	rowList:[500,1000,3000,10000],
        emptyrecords: "No data",
   	pager: '#pager1',
        toppager: true,
        mType: "POST",
   	sortname: 'nagios_hosts.display_name',
        viewrecords: true,
        gridView: true,
        sortorder: "asc",
        autowidth: true,
        height: 630,
        caption:"Nagios Hosts State",
        //caption:false,
        grouping:false,
        //groupingView : { 
        //        groupField : ['s_display_name'],
        //        groupColumnShow : [true],
        //        groupText: ['<b>      {0} -- ({1})</b>'],
        //        groupCollapse : true,
        //        groupOrder: ['asc']
        //},        
        gridComplete: function(){
           $("#grid1 tr:nth-child(even) ").addClass("evenTableRow");
           $("#grid1 tr:nth-child(odd) " ).addClass("oddTableRow");
	   var ids = $("#grid1").jqGrid('getDataIDs');
           var row = $("#grid1").jqGrid('getRowData');
	   for(var i=0;i < ids.length;i++)
           {
		var cl = ids[i];
		var state=row[i].current_state;
		switch (state)
		{
		    case "OK":		$("#grid1").jqGrid('setCell',ids[i],"current_state","",{'background-color':'#3BAC0B','background-image':'none'});
			break;
		    case "CRITICAL":	$("#grid1").jqGrid('setCell',ids[i],"current_state","",{'background-color':'#FF632A','background-image':'none'});
			break;
		    case "WARNING":	$("#grid1").jqGrid('setCell',ids[i],"current_state","",{'background-color':'#E7E24F','background-image':'none'});
			break;
		    case "UNKNOWN":	$("#grid1").jqGrid('setCell',ids[i],"current_state","",{'background-color':'#E7E6E6','background-image':'none'});
			break;
		}
	   }
        }
});
$(window).bind('resize', function() {
    $("#grid1").setGridHeight($(window).height()-200);
    $("#grid1").setGridWidth($(window).width()-12);
}).trigger('resize');

jQuery("#grid1").jqGrid('navGrid','#pager1',{edit:false,add:false,del:false,search:true,refresh:true,cloneToTop:true},
{},
{},
{},
{closeOnEscape:true,multipleSearch:true,searchOnEnter:true,multipleGroup:true,stringResult:true, showQuery:true});
//-----------------------------------------------------------------------------------------------
jQuery("#grid1").jqGrid('filterToolbar',{stringResult: true,searchOnEnter : true});
mygrid[0].toggleToolbar();
jQuery("#grid1").jqGrid('navButtonAdd',"#grid1_toppager",{
   caption:"",
   title:"Filter",
   buttonicon:'ui-icon-shuffle',
   onClickButton:function(){
         mygrid[0].toggleToolbar();
      }
});

</script>

<?php
    require_once("main_window_footer_end.php");
?>
