<?php
/**
 * @package         
 * @copyright       Copyright (C) 2017 MDM-IT Mariusz Dziewulski. All rights reserved.
 * @license         see LICENSE.txt
 */

    //error_reporting(0);    
    include_once("permition_app_class.php");
    $app_permit=new app_permit();
    if($app_permit->permit_module(basename(__FILE__))==='0') exit;
    include("config/config.php");

    include_once("main_window_menu.php");
    include_once("main_window_toolbar.php");

?>
<html>
<header>    
<title>NetMap4Nagios</title>
<link type="text/css" href="js/jquery/css/redmond/jquery-ui.custom.css" rel="stylesheet" />
<script type="text/javascript" src="js/jquery/jquery.js"></script>
<script  type="text/javascript" src="js/jquery/jquery-ui.js"></script>

<link   rel="stylesheet" type="text/css" media="screen" href="js/jqGrid/css/ui.jqgrid.css" />
<link rel="stylesheet" type="text/css" media="screen" href="js/jqGrid/css/mdmit/redmond/ui.jqgrid_md.css" />
<!--<link rel="stylesheet" type="text/css" media="screen" href="js/jqGrid-4.8.2/css/ui.jqgrid.css" />-->
<script  src="js/jqGrid/js/i18n/grid.locale-en.js" type="text/javascript"></script>
<script  src="js/jqGrid/js/jquery.jqGrid.min.js" type="text/javascript"></script>
<script  type="text/javascript" src="js/jqGrid/js/jquery.contextmenu.js"></script>

<link rel="stylesheet" href="js/Zebra/css/mdmit/zebra_dialog.css" type="text/css">
<script type="text/javascript" src="js/Zebra/zebra_dialog.js"></script>
<link type="text/css" href="js/jquery_window/css/jquery.window.css" rel="stylesheet" />
<link type="text/css" href="js/jquery_window/css/mdmit_window.css" rel="stylesheet" />
<script type="text/javascript" src="js/jquery_window/jquery.window.min.js"></script>

<script type="text/javascript" src="lib/mdmit_dialogs.js"></script>

<!--<link type="text/css" href="lib/main_window_style.css" rel="stylesheet" />-->
<script type="text/javascript" src="lib/mdmit_lib.js"></script>
<style>
#grid tr:hover{  
    background:none;
}    
.ui-jqgrid .ui-jqgrid-htable th{
    color: #ffffff; 
    font-weight: bold;
    /*font-family: Lucida Grande, Lucida Sans, Arial,sans-serif,Tahoma,Verdana;*/
    font-size: 10px;
    background-image: url(js/jquery/css/redmond/images/ui-bg_gloss-wave_55_5c9ccc_500x100.png);
}
.ui-jqgrid .ui-jqgrid-htable th,
.ui-jqgrid .ui-jqgrid-btable .jqgrow td {
    /*height: 18px !important;*/
}
.evenTableRow
{
   background: #F4F4FF;
   /*background-color:#e8eef4;*/
}
.oddTableRow
{
   background: #e8eef4;
}    
/*.ui-jqgrid tr.jqgrow td 
{
    white-space: normal !important;
}*/
body {
	margin: 0 0 0 0;
	padding: 0;        
}
    
.ui-button-text {
   font-size: 0.9em !important;
   line-height: 1.2 !important;
   font-style: normal;
   font-weight: normal;
   padding: 0.2em 0.8em !important;
}
.ui-button {
   border-radius: 2px !important; 
}
</style>

<body>
<div id="main_page_id" style="margin-bottom: 3px; margin-top: 8px; margin-left: 5px; margin-right: 5px;" align="center">
    <table id="grid1"></table>
    <div id="pager1"></div>
    <div id="mysearch"></div>
</div>
<!--
<table border="0" cellpadding="1" cellspacing="1" width="100%">
  <tr>
    <td width="100%">
        <table id="grid1"></table>
        <div id="pager1"></div>
        <div id="mysearch"></div>      
    <div id='loading' style="display:none;position:absolute;top:50%;left:50%;font-family: Verdana; font-size: 6px; color: #000080;">
        <img border="0" src="img/loading_box.gif">
        <br>MDM-IT    
    </div>
    </td>
  </tr>
</table>
-->
<script type="text/javascript">
var mygrid;
		  
mygrid = jQuery("#grid1").jqGrid({
   	url:"servers/serwer_nagios.php?q=select_hosts",
        datatype: "xml",
        colNames:['Host ID','Host Name','Address IP','Display Name','Action URL','Last Check','Last Time Down','Duration','Last Output','Perfdata','State'],
        colModel:[
                  {name:'host_object_id',   index:'nagios_hosts.host_object_id', width:10,hidden:true,editable:true},  
                  {name:'alias',	    index:'nagios_hosts.alias', width:120,hidden:false,align:"left"},
                  {name:'address_ip',	    index:'nagios_hosts.address', width:40,hidden:false,align:"left"},
                  {name:'display_name',	    index:'nagios_hosts.display_name', width:120,hidden:false,align:"left"},
		  {name:'action_url',	    index:'nagios_hosts.action_url', width:100,hidden:true,align:"left"},
                  {name:'last_check',	    index:'nagios_hoststatus.last_check', width:50,hidden:false,align:"left"},
                  {name:'last_time_down',   index:'nagios_hoststatus.last_time_down', width:50,hidden:false,align:"left"},
                  {name:'duration',	    index:'bagios_hoststatus.duration', width:50,hidden:false,align:"left"},
                  {name:'output',	    index:'nagios_hoststatus.output', width:120,hidden:false,align:"left"},
                  {name:'perfdata',	    index:'nagios_hoststatus.perfdata', width:100,hidden:true,align:"right"},
                  {name:'current_state',    index:'nagios_hoststatus.current_state', width:30,hidden:false,align:"left"}		  
   	],
        rowNum:100,
   	rowList:[100,200,300,1000,3000],
        emptyrecords: "No data",
   	pager: '#pager1',
        toppager: true,
        mType: "POST",
   	sortname: 'nagios_hosts.alias',
        viewrecords: true,
        gridView: true,
        sortorder: "asc",
        autowidth: true,
        autoheight: true,
        caption: 'Nagios Hosts',
	gridComplete: function(){
           $("#grid1 tr:nth-child(even) ").addClass("evenTableRow");
           $("#grid1 tr:nth-child(odd) " ).addClass("oddTableRow");
	   var ids = $("#grid1").jqGrid('getDataIDs');
           var row = $("#grid1").jqGrid('getRowData');
	   for(var i=0;i < ids.length;i++)
           {
		var cl = ids[i];
		var state=row[i].current_state;
		switch (state)
		{
		    case "OK":		$("#grid1").jqGrid('setCell',ids[i],"current_state","",{'background-color':'#3BAC0B','background-image':'none'});
			break;
		    case "CRITICAL":	$("#grid1").jqGrid('setCell',ids[i],"current_state","",{'background-color':'#FF632A','background-image':'none'});
			break;
		    case "WARNING":	$("#grid1").jqGrid('setCell',ids[i],"current_state","",{'background-color':'#E7E24F','background-image':'none'});
			break;
		    case "UNKNOWN":	$("#grid1").jqGrid('setCell',ids[i],"current_state","",{'background-color':'#E7E6E6','background-image':'none'});
			break;
		}
	   }
        },
        subGrid: true,
	subGridOptions: 
            { 
                "plusicon" : "ui-icon-triangle-1-e", 
                "minusicon" : "ui-icon-triangle-1-s", 
                "openicon" : "ui-icon-arrowreturn-1-e" 
            },        
        subGridRowExpanded: function(subgrid_id, row_id) 
            { 
                var row = jQuery("#grid1").jqGrid('getRowData');
                var host_id=(row[row_id-1].host_object_id);
                var ip2=(row[row_id-1].adress_ip);
                var subgrid_table_id, pager_id; 
                subgrid_table_id = subgrid_id+"_t"; 
                pager_id = "p_"+subgrid_table_id; 
                $("#"+subgrid_id).html("<table id='"+subgrid_table_id+"' class='scroll'></table><div id='"+pager_id+"' class='scroll'></div>"); 
                jQuery("#"+subgrid_table_id).jqGrid(
                        { 
                            url:"servers/serwer_nagios.php?q=select2&host_object_id="+host_id,
                            datatype: "xml",
                            colNames:['','ID','Service Name','Output','Current State','Last Check'], 
                            colModel:[
					{name:'act',index:'act', width:10,hidden:true,editable:false},
                                        {name:'host_object_id',index:'host_object_id', width:10,hidden:true,editable:false},
                                        {name:'service_name',index:'service.display_name', title:false, width:40,align:"left",hidden:false},
                                        {name:'service_output',index:'service.output', title:false, width:100,align:"left",hidden:false},
                                        {name:'current_state',index:'service.current_state', title:false, width:30,align:"left",hidden:false},
					{name:'service_last_check',index:'service.last_check', title:false, width:50,align:"left",hidden:false}
                                    ],
                            rowNum:2000, 
                            pager: pager_id, 
                            sortname: 'state_time', 
                            sortorder: "desc",
                            autowidth: true,
                            //loadonce: true,
                            scroll: true,
                            height: '100%',
			    gridComplete: function(){
				//$("#"+subgrid_table_id tr:nth-child(even) ").addClass("evenTableRow");
				//$("#"+subgrid_table_id tr:nth-child(odd) " ).addClass("oddTableRow");
				var s_ids = jQuery("#"+subgrid_table_id).jqGrid('getDataIDs');
				var s_row = jQuery("#"+subgrid_table_id).jqGrid('getRowData');
				for(var s_i=0;s_i < s_ids.length;s_i++)
				{
				     var s_cl = s_ids[s_i];
				     var s_state=s_row[s_i].current_state;
				     switch (s_state)
				     {
					 case "OK":		jQuery("#"+subgrid_table_id).jqGrid('setCell',s_ids[s_i],"current_state","",{'background-color':'#3BAC0B','background-image':'none'});
					     break;
					 case "CRITICAL":	jQuery("#"+subgrid_table_id).jqGrid('setCell',s_ids[s_i],"current_state","",{'background-color':'#FF632A','background-image':'none'});
					     break;
					 case "WARNING":	jQuery("#"+subgrid_table_id).jqGrid('setCell',s_ids[s_i],"current_state","",{'background-color':'#E7E24F','background-image':'none'});
					     break;
					 case "UNKNOWN":	jQuery("#"+subgrid_table_id).jqGrid('setCell',s_ids[s_i],"current_state","",{'background-color':'#E7E6E6','background-image':'none'});
					     break;
				     }
				}
			    }
                        }); 
                jQuery("#"+subgrid_table_id).jqGrid('navGrid',"#"+pager_id,{edit:false,add:false,del:false,search:false});
            }        
});
$(window).bind('resize', function() {
    $("#grid1").setGridHeight($(window).height()-200);
    $("#grid1").setGridWidth($(window).width()-12);
}).trigger('resize');

jQuery("#grid1").jqGrid('navGrid','#pager1',{edit:false,add:false,del:false,search:true,refresh:true,cloneToTop:true},
{},
{},
{},
{closeOnEscape:true,multipleSearch:true,searchOnEnter:true,multipleGroup:true,stringResult:true, showQuery:true});

//-----------------------------------------------------------------------------------------------
jQuery("#grid1").jqGrid('filterToolbar',{stringResult: true,searchOnEnter : true});
mygrid[0].toggleToolbar();
jQuery("#grid1").jqGrid('navButtonAdd',"#grid1_toppager",{
   caption:"",
   title:"Fast Filter",
   buttonicon:'ui-icon-shuffle',
   onClickButton:function(){
         mygrid[0].toggleToolbar();
      }
});

</script>


<?php
    require_once("main_window_footer_end.php");
?>
