<?php
    include_once("../lib_gen_config/utils_gen_config.php");

    //Record ID
    $RECORD_ID=		$_REQUEST["record_id"];
    //Map Name
    $MAP_NAME=		preg_replace('/[,!|@^&=+?*%$.\/]/', '_', $_REQUEST["map_name"]);
    
    //ASN ISP
    $ISP_ASN=		'[SET ISP_ASN]';
    
    //Old label
    $LABEL=		trim($_REQUEST["label"]);
    
    //HostName
    $HOSTNAME=		trim($_REQUEST["host_name"]);
    //MGMT IP
    $IP=		trim($_REQUEST["ip"]);

    //SNMP community
    $SNMP_COMMUNITY=	trim($_REQUEST["snmp"]);
    
    //MGMT IP for destination device
    $IP_MGMT_DST=	trim($_REQUEST["ip_mgmt_dst"]);
    
    //Name of service running on switch or device
    $SERVICE = strtoupper(trim($_REQUEST["service"]));    
    $SERVICE = preg_replace('/[,!|@^&:=+?*%$.\/]/', '_', $SERVICE); //replace all chars by '_'
    
    //Bandwidth for definig of policer
    $BANDWIDTH=		trim($_REQUEST["bandwidth"]);
    $DOWNLOAD=          get_download($BANDWIDTH);
    $UPLOAD=		get_upload($BANDWIDTH);
    
    //First Device location (for example city)
    $LOCATION_SRC=	trim($_REQUEST["location_src"]);
    
    //Second Device location (for example city)
    $LOCATION_DST=	trim($_REQUEST["location_dst"]);
    
    //Configuration template depends on the vendor
    $config_template=   trim($_REQUEST["config_template"]);
    
    //Any config of device or link
    $CONFIG=		trim($_REQUEST["config"]);
    
    //Connection to device. For example: http://, ssh://, telnet://
    $CONNECTION=	trim($_REQUEST["connection"]);
    
    //Path to performance graphs of device or links
    $PERF_PATH=		trim($_REQUEST["perf_path"]);
    
    //Path to Nagios state pf device
    $NAGIOS_STATE=	trim($_REQUEST["nagios_state"]);
    
    //Type of device: device, switch
    //Defined in file config/type_device.php
    $TYP_DEVICE=	trim($_REQUEST["typ_device_a"]);
    $TYP_DEVICE_A=	trim($_REQUEST["typ_device_a"]);
    $TYP_DEVICE_B=	trim($_REQUEST["typ_device_b"]);
    
    //Model of device: Juniper MX480, MX104 ...
    $MODEL_DEVICE=	trim($_REQUEST["model_device_a"]);
    $MODEL_DEVICE_A=    trim($_REQUEST["model_device_a"]);
    $MODEL_DEVICE_B=    trim($_REQUEST["model_device_b"]);
    
    //Vendor of device: JUNIPER, CISCO, DCN ...
    //Defined in file config/vendors.php
    $VENDOR=		strtoupper(trim($_REQUEST["vendor_a"]));
    $VENDOR_A=		strtoupper(trim($_REQUEST["vendor_a"]));
    $VENDOR_B=		strtoupper(trim($_REQUEST["vendor_b"]));
    
    //Source IP Loopback of device. It is used for configuration, L2VPN and XConnect connections
    $LOOPBACK_SRC=	trim($_REQUEST["loopback_src"]);
    $LOOPBACK=		trim($_REQUEST["loopback_src"]);
    $NEIGHBOR_SRC=	trim($_REQUEST["loopback_src"]);
    
    //Destination IP Loopback of device. It is used for configuration, L2VPN and XConnect connections
    $LOOPBACK_DST=	trim($_REQUEST["loopback_dst"]);
    $NEIGHBOR_DST=	trim($_REQUEST["loopback_dst"]);
    
    //IP P2P for configuration conection between devices or Internet servis for clients
    $IP_P2P=		trim($_REQUEST["ip_p2p"]);
    $IP_P2P_GATEWAY=	get_ip_p2p_gateway($IP_P2P);
    $IP_P2P_MASK=	get_ip_p2p_mask($IP_P2P);
    $IP_P2P_MASK_CISCO=	get_ip_p2p_mask_cisco($IP_P2P);
    
    $IP_P2P_NEXT_HOP=   get_ip_p2p_next_hop($IP_P2P);
    $IP_NEXT_HOP=	$IP_P2P_NEXT_HOP;
    $IP_P2P_CLIENT=	$IP_P2P_NEXT_HOP;
    
    //IP's prvider aggregatible pool
    //$IP_PA=		trim($_REQUEST["ip_pa"]); //with MASK
    //$IP_PA=		get_ip_pa(trim($_REQUEST["ip_pa"])); //The function return table of ip addresses. IP PA addresses must be saved in ip form: [ip_address1]/[mask];[ip_address2]/[mask];....
    $IP_PA=		trim($_REQUEST["ip_pa"]);
    
    //IP's provider independent poll
    //$IP_PI=		get_ip_pi(trim($_REQUEST["ip_pi"])); //with MASK
    $IP_PI=		trim($_REQUEST["ip_pi"]); //with MASK
    
    //ASN clients for configure BGP services
    $AS=		trim($_REQUEST["asn"]);
    $CLIENT_AS=		$AS;
    $ASN=		$AS;
    $CLIENT_ASN=	$AS;
    
    //Name of subinterface on source device
    $SUBINTERFACE_SRC=  trim($_REQUEST["subinterface_src"]);
    
    //Name of subinterface on destination device
    $SUBINTERFACE_DST=  trim($_REQUEST["subinterface_dst"]);
    
    //Name of interface on source device
    $INTERFACE_SRC=	trim($_REQUEST["interface_src"]);
    
    //Description of interface on source device
    $INTERFACE_DESCRIPTION_SRC=	preg_replace('/[,!|@^&=+?*%$.\/]/', '_',trim($_REQUEST["interface_desc_src"]));
    $INTERFACE_DESCRPTION =	$INTERFACE_DESCRIPTION_SRC;
    $INTERFACE_DESC_SRC=        $INTERFACE_DESCRIPTION_SRC;
    
    //Name of interface on destination device
    $INTERFACE_DST=		trim($_REQUEST["interface_dst"]);
    
    //Description of interface on destination device
    $INTERFACE_DESCRIPTION_DST=	preg_replace('/[,!|@^&=+?*%$.\/]/', '_',trim($_REQUEST["interface_desc_dst"]));
    $INTERFACE_DESC_DST=        $INTERFACE_DESCRIPTION_DST;
    
    //Name or ID S-Vlan on source device
    $S_VLAN_SRC=	trim($_REQUEST["s_vlan_src"]);
    
    //Name or ID S-Vlan on destination device
    //Source S-Vlan and destination S-Vlan usually have to be identical
    $S_VLAN_DST=	trim($_REQUEST["s_vlan_dst"]);
    
    //Name or ID C-Vlan on source device
    $C_VLAN_SRC=	trim($_REQUEST["c_vlan_src"]);
    $VLAN_SRC  =	$C_VLAN_SRC;
    $C_VLAN=		$C_VLAN_SRC;
    $VLAN=		$C_VLAN_SRC;
    
    $C_VLAN_NAME_SRC=	trim($_REQUEST["c_vlan_name_src"]);
    $VLAN_NAME_SRC  =	$C_VLAN_NAME_SRC;
    $VLAN_NAME=		$C_VLAN_NAME_SRC;
    
    //Name or ID C-Vlan on destionation device
    //Source C-Vlan and destination C-Vlan usually have to be identical
    $C_VLAN_DST=	trim($_REQUEST["c_vlan_dst"]);
    $VLAN_DST  =	$C_VLAN_DST;
    
    $C_VLAN_NAME_DST=	trim($_REQUEST["c_vlan_name_dst"]);
    $VLAN_NAME_DST  =	$C_VLAN_NAME_DST;        
    
    
    
    //======================================================================================================================
    //Definition for VEC
    $INTERFACE_L2VPN_V_SRC = preg_replace('/[,!|@^&:=+?*%$.\/]/', '',$INTERFACE_SRC);
    $INTERFACE_L2VPN_V_DST = preg_replace('/[,!|@^&:=+?*%$.\/]/', '',$INTERFACE_DST);
    
    try
    {
	list($oct_src1,$oct_src2,$oct_src3,$oct_src4)=explode('.',$NEIGHBOR_SRC);
    } catch(Exception $e){$oct_src4='';};
    
    try
    {
	list($oct_dst1,$oct_dst2,$oct_dst3,$oct_dst4)=explode('.',$NEIGHBOR_DST);
    } catch(Exception $e){$oct_dst4='';};
    
    //xconnect group TE04044_3504-402033504
    $XCONNECT_GROUP_V_SRC=$INTERFACE_L2VPN_V_SRC.'_'.$VLAN_SRC.'-'.$oct_src4.$oct_dst4.$VLAN_SRC;
    $XCONNECT_GROUP_V_DST=$INTERFACE_L2VPN_V_DST.'_'.$VLAN_DST.'-'.$oct_dst4.$oct_src4.$VLAN_DST;
    $PW_ID=$oct_src4.$oct_dst4.$VLAN_SRC;
    //======================================================================================================================
?>